def switches():
    _.switches.register('All', '-all')
    _.switches.register('Name', '-n')
    _.switches.register('toFile', '-f')
    _.switches.register('toDB', '-u')
    _.switches.register('DB', '-db')

import requests
exec(requests.get('https://sds.sh/micro.py/').text)
exec(loader)

# try:
#     from library.tools.db.duckdbMgr import duckdbMgr, FileLocker  # type: ignore
# except:
#     from duckdbMgr import duckdbMgr, FileLocker  # type: ignore


from library.tools.db.sqliteMgr import  sqliteMgr, FileLocker

import os

db = None
def get_db():
    global db
    if db is None:
        if _.switches.isActive('DB'):
            db = sqliteMgr(_.switches.value('DB'))
        else:
            db = sqliteMgr('C:/ProgramData/eco/eco.db')
    return db

def saveSomeFiles(names):
    db = get_db()
    for name in names:
        name = name.replace('.py', '')
        found = False
        for rec in db.read('py', {'name': name}):
            found = True
            fi = name + '.py'
            content = rec['content']
            _.saveText(content, fi)
            _.pr('Saved:', fi, c='green')
        if not found:
            _.pr(f"❌ Not found: {name}", c='red')

def saveSomeRecords(names):
    db = get_db()
    for name in names:
        name = name.replace('.py', '')
        fi = name + '.py'
        if os.path.exists(fi):
            content = _.getText(fi, raw=True)
            db.ui('py', {'name': name}, {'name': name, 'usage': 'ecocli', 'content': content})
            _.pr('Updated:', fi, c='yellow')
        else:
            _.pr(f"❌ File missing: {fi}", c='red')

def saveAll():
    db = get_db()
    recs = db.read('py', {'usage': 'ecocli'})
    for rec in recs:
        name = rec['name']
        fi = name + '.py'
        content = rec['content']
        _.saveText(content, fi)
        _.pr('Saved:', fi, c='cyan')

# --- Entry Point ---
if _.switches.isActive('Name'):
    if _.switches.isActive('toFile'):
        saveSomeFiles(_.switches.values('Name'))
    elif _.switches.isActive('toDB'):
        saveSomeRecords(_.switches.values('Name'))
elif _.switches.isActive('All'):
    saveAll()
