
# EcoEmuxDB.py
import os
import duckdb
import time

class EcoEmuxDB:
    def __init__(self, db_path):
        self.db_path = db_path
        os.makedirs(os.path.dirname(db_path), exist_ok=True)
        self.conn = duckdb.connect(db_path)
        self.init()

    def init(self):
        self.conn.execute("""
            CREATE TABLE IF NOT EXISTS emux_logs (
                id BIGINT AUTO_INCREMENT PRIMARY KEY,
                label TEXT,
                parent_id TEXT,
                timestamp DOUBLE,
                source TEXT, -- parent or child
                text TEXT
            )
        """)

    def insert(self, label, parent_id, source, text):
        now = time.time()
        self.conn.execute("""
            INSERT INTO emux_logs (label, parent_id, timestamp, source, text)
            VALUES (?, ?, ?, ?, ?)
        """, (label, parent_id, now, source, text))

    def tail(self, label, parent_id, limit=50):
        return self.conn.execute("""
            SELECT timestamp, source, text FROM emux_logs
            WHERE label = ? AND parent_id = ?
            ORDER BY timestamp DESC
            LIMIT ?
        """, (label, parent_id, limit)).fetchall()

    def purge_old(self, days=1):
        threshold = time.time() - (days * 86400)
        self.conn.execute("""
            DELETE FROM emux_logs
            WHERE timestamp < ?
        """, (threshold,))

π.e.EcoEmuxDB=EcoEmuxDB
