
# EcoSocketManager.py
import socket
import ssl
import json
import hashlib
import threading
import time

class EcoSocketManager:
    def __init__(self, π, label, port, host_id, salt):
        self.π = π
        self.label = label
        self.port = port
        self.host_id = host_id
        self.salt = salt
        self.api_key = self.generate_api_key()
        self.count = 0
        self.sock = None
        self.lock = threading.Lock()

    def generate_api_key(self):
        pid = str(os.getpid())
        key = hashlib.md5(hashlib.md5(hashlib.md5(pid.encode()).digest()).digest()).hexdigest()[:6]
        return key

    def loop_host(self, loops):
        value = self.host_id
        for _ in range(loops):
            value = hashlib.md5(value.encode()).hexdigest()
        return value

    def get_count_check(self):
        data = str(self.count) + self.loop_host(self.salt)
        return hashlib.md5(hashlib.md5(hashlib.md5(data.encode()).digest()).digest()).hexdigest()[:6]

    def connect(self):
        ctx = ssl.create_default_context()
        sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        self.sock = ctx.wrap_socket(sock, server_hostname='127.0.0.1')
        self.sock.connect(('127.0.0.1', self.port))

    def send(self, command):
        with self.lock:
            self.count += 1
            packet = {
                'api_key': self.api_key,
                'count_check': self.get_count_check(),
                'command': command
            }
            self.sock.sendall(json.dumps(packet).encode('utf-8'))

    def receive(self, bufsize=65536):
        data = self.sock.recv(bufsize)
        return data.decode('utf-8', errors='replace')

    def close(self):
        if self.sock:
            self.sock.close()
            self.sock = None

π.e.EcoSocketManager=EcoSocketManager
