
import subprocess
import sys

def PIP(package_name):
	"""
	Ensure a Python package is installed using the same interpreter.
	If missing, auto-install silently.
	"""
	try:
		__import__(package_name)
	except ImportError:
		print(f"[EcoCLI] ⚡ Installing missing package: {package_name}")
		python_exe = sys.executable
		try:
			subprocess.check_call([python_exe, "-m", "pip", "install", package_name])
			__import__(package_name)  # Try again after install
		except Exception as e:
			print(f"[EcoCLI] ❌ Failed to install {package_name}: {e}")
π.e.PIP=PIP
