
try:
    import _rightThumb._bookmarks as _bm # type: ignore
except: pass
import json
import os



# EcoMUX.py
import os
import sys
import json
import subprocess
import time
import signal

class EcoMUX:
    def __init__(self, π):
        self.π = π
        self.meta_path = os.path.expanduser('~/.eco/emux.meta'.replace('/', os.sep))
        self.port_base = 64000
        self.meta = self.load_meta()

    def load_meta(self):
        if not os.path.exists(self.meta_path):
            return {}
        with open(self.meta_path, 'r', encoding='utf-8') as f:
            return json.load(f)

    def save_meta(self):
        os.makedirs(os.path.dirname(self.meta_path), exist_ok=True)
        with open(self.meta_path, 'w', encoding='utf-8') as f:
            json.dump(self.meta, f, indent=4)

    def get_next_port(self):
        used_ports = [info.get('port', 0) for info in self.meta.values()]
        port = self.port_base
        while port in used_ports:
            port += 1
        return port

    def new(self, label):
        if label in self.meta:
            print(f"[emux] ❌ Session '{label}' already exists!")
            return

        cwd = os.getcwd()
        start_time = time.time()
        port = self.get_next_port()
        host_id = str(int(time.time()))
        salt = str(random.randint(30, 100))

        cmd = [
            sys.executable,
            os.path.abspath(__file__),
            '-label', label,
            '-parent', host_id,
            '-salt', salt
        ]

        process = subprocess.Popen(
            cmd,
            cwd=cwd,
            stdout=subprocess.DEVNULL,
            stderr=subprocess.DEVNULL,
            stdin=subprocess.DEVNULL,
            start_new_session=True
        )

        self.meta[label] = {
            'pid': process.pid,
            'cwd': cwd,
            'start_time': start_time,
            'port': port,
            'host_id': host_id,
            'salt': salt
        }
        self.save_meta()
        print(f"[emux] 🚀 Started '{label}' on port {port}")

    def kill(self, label):
        if label not in self.meta:
            print(f"[emux] ❌ No session '{label}'.")
            return
        try:
            os.kill(self.meta[label]['pid'], signal.SIGKILL)
        except Exception as e:
            print(f"[emux] ⚠️ Kill error: {e}")
        self.meta.pop(label, None)
        self.save_meta()

    def list(self):
        if not self.meta:
            print("[emux] ❌ No active sessions.")
            return
        for label, info in self.meta.items():
            print(f"- {label}: PID {info['pid']} Port {info['port']}")

π.e.EcoMUX=EcoMUX




import subprocess
import os
import sys
import signal
import shutil
import socket
import random
import readline
import atexit
import time
from prompt_toolkit import prompt # type: ignore
from prompt_toolkit.styles import Style # type: ignore
from prompt_toolkit.formatted_text import FormattedText  # type: ignore
from datetime import datetime
import re
import threading
from prompt_toolkit import PromptSession # type: ignore
from prompt_toolkit.key_binding import KeyBindings # type: ignore
from prompt_toolkit.buffer import Buffer # type: ignore
import os
from prompt_toolkit.history import FileHistory, InMemoryHistory # type: ignore
class TerminalProxy:

    def __init__(self):
        def getTable(path):
            try:
                if not os.sep in path:
                    import _rightThumb._vars as _v # type: ignore
                    path = _v.tt+os.sep+path
            except: pass
            if not os.path.exists(path):
                raise FileNotFoundError(f"File not found: {path}")
            
            with open(path, 'r', encoding='utf-8') as f:
                data = json.load(f)
            
            return data

        self.label = os.getenv('ECO_LABEL', None)
        self.parent = os.getenv('ECO_PARENT', None)
        self.salt = os.getenv('ECO_SALT', None)
        self.attached_label = None
        self.original_prompt_text = None
        self.isActive = True
        self.emoji = "🐞"
        self.user = os.getenv("USERNAME") or os.getenv("USER") or "user"
        self.host = self.get_hostname()
        self.shell = self.detect_shell()
        self.aliases = getTable('file-open-aliases.hash')
        if not self.aliases:
            self.aliases = {}
            self.aliases['aliases'] = {}
        self._cached_commands = None
        self.history_file = self.ptermHistory()
        self.meta_history_file = self.ptermHistory() + '.meta'
        self.ensure_file(self.history_file)
        self.ensure_file(self.meta_history_file)
        self.rotate_history_file(self.history_file)
        self.history = FileHistory(self.history_file)
        self.style = Style.from_dict({
            'prompt': '#b4009e bold',
            'user_input': 'ansicyan'
        })
        os.environ['pterm'] = 'true'
        if os.name != 'nt':
            self.setup_history()
            signal.signal(signal.SIGTSTP, signal.SIG_IGN)
            if hasattr(signal, 'SIGTTIN'):
                signal.signal(signal.SIGTTIN, signal.SIG_IGN)
            if hasattr(signal, 'SIGTTOU'):
                signal.signal(signal.SIGTTOU, signal.SIG_IGN)
        signal.signal(signal.SIGINT, self.sigint_handler)
        self.emux = None
        if self.label:
            print(f"[EcoMUX] 🧵 Running in detached mode: {self.label}")
            self.run_stream_server()
        else:
            self.start()

    def run_stream_server(self):
        """
        Background Eco child mode: Wait for commands from file and execute them.
        """
        threading.Thread(target=self.stream_loop, daemon=True).start()

    def stream_loop(self):
        """
        Continuously check for a command file for this session and execute.
        """
        session_dir = os.path.expanduser(f'~/.eco/emux_streams/'.replace('/', os.sep))
        os.makedirs(session_dir, exist_ok=True)
        input_file = os.path.join(session_dir, f'{self.label}.in')
        output_file = os.path.join(session_dir, f'{self.label}.out')
        print(f"[EcoMUX] 📝 Listening for commands at {input_file}")
        while True:
            if os.path.exists(input_file):
                try:
                    with open(input_file, 'r', encoding='utf-8') as f:
                        command = f.read().strip()
                    if command:
                        os.remove(input_file)
                        result = self.execute_command(command)
                        with open(output_file, 'w', encoding='utf-8') as f:
                            f.write(result)
                except Exception as e:
                    print(f"[EcoMUX] ⚠️ Stream error: {e}")
            time.sleep(0.5)

    def execute_command(self, command):
        """
        Actually run a single command and capture output.
        """
        import subprocess
        try:
            result = subprocess.check_output(command, shell=True, stderr=subprocess.STDOUT)
            return result.decode('utf-8', errors='replace')
        except subprocess.CalledProcessError as e:
            return e.output.decode('utf-8', errors='replace')

    def ensure_file(self, path):
        if not os.path.exists(path):
            with open(path, 'w', encoding='utf-8') as f:
                pass

    def rotate_history_file(self, path, max_lines=1000):
        try:
            with open(path, 'r', encoding='utf-8') as f:
                lines = f.readlines()
            if len(lines) > max_lines:
                with open(path, 'w', encoding='utf-8') as f:
                    f.writelines(lines[-max_lines:])
        except Exception as e:
            print(f"[pterm] ⚠️ Failed to rotate history: {e}")

    def get_history_commands(self, force_refresh=False):
        SESSION_RE = re.compile(r'# (.*?) \| session:(.*)')
        ANSI_RE = re.compile(r'\x1B(?:[@-Z\\-_]|\[[0-?]*[ -/]*[@-~])')
        if self._cached_commands and not force_refresh:
            return self._cached_commands
        commands = []
        try:
            with open(self.meta_history_file, 'r', encoding='utf-8') as f:
                raw = ANSI_RE.sub('', f.read().replace('\r', '').replace(chr(10), repr(chr(10))))
            session = None
            timestamp = None
            for line in raw.splitlines():
                if line.startswith('#'):
                    match = SESSION_RE.match(line)
                    if match:
                        timestamp, session = match.groups()
                elif line.startswith('+'):
                    commands.append({
                        'command': line[1:].strip(),
                        'session': session,
                        'time': timestamp
                    })
            self._cached_commands = commands
        except Exception as e:
            print(f"[pterm] ⚠️ Failed to load history: {e}")
            self._cached_commands = []
        return self._cached_commands

    def clean_history_file(self,path):
        try:
            with open(path, 'r', encoding='utf-8') as f:
                content = f.read()
            content = content.replace('\r', '')
            content = self.clean_history_file_content(content)
            with open(path, 'w', encoding='utf-8') as f:
                f.write(content)
        except Exception as e:
            print(f"[pterm] ⚠️ Failed to clean history file: {e}")

    def clean_history_file_content(self, raw: str):
        ansi_escape = re.compile(r'\x1B(?:[@-Z\\-_]|\[[0-?]*[ -/]*[@-~])')
        raw = raw.replace(chr(13), '')
        raw = ansi_escape.sub('', raw)
        return raw

    def add_to_history(self, command: str):
        if not command.strip():
            return
        cleaned = command.strip().replace(chr(13), '').replace('\x1b', '')
        try:
            if hasattr(self.history, 'append_string'):
                self.history.append_string(cleaned)
            session_id = os.environ.get('SESSION_ID', 'unknown')
            entry = f"# {datetime.now().isoformat()} | session:{session_id}{chr(10)}+{cleaned}{chr(10)}"
            with open(self.meta_history_file, 'a', encoding='utf-8') as f:
                f.write(entry)
        except Exception as e:
            print(f"[pterm] ⚠️ Failed to add to history: {e}")

    def setup_history(self):
        try:
            readline.read_history_file(self.history_file)
        except FileNotFoundError:
            pass
        atexit.register(readline.write_history_file, self.history_file)

    def get_hostname(self):
        if os.name == "nt":
            return os.environ.get("COMPUTERNAME", "PC")
        else:
            try:
                with open("/etc/hostname") as f:
                    return f.read().strip()
            except:
                return socket.gethostname()

    def pterm(self):
        if os.name == 'nt':
            home = os.getenv('USERPROFILE') or os.path.expanduser('~')
            return home.rstrip('\\') + '\\' + '.pterm'
        else:
            home = os.getenv('HOME') or os.path.expanduser('~')
            return home.rstrip('/') + '/' + '.pterm'

    def ptermHistory(self):
        if os.name == 'nt':
            home = os.getenv('USERPROFILE') or os.path.expanduser('~')
            return home.rstrip('\\') + '\\' + '.pterm_history'
        else:
            home = os.getenv('HOME') or os.path.expanduser('~')
            return home.rstrip('/') + '/' + '.pterm_history'

    def detect_shell(self):
        if os.name == "nt":
            return "cmd.exe"
        else:
            return os.environ.get("SHELL", "/bin/bash")

    def sigint_handler(self, sig, frame):
        os.environ.pop('pterm', None)
        if hasattr(self, 'shell_proc') and self.shell_proc:
            self.shell_proc.terminate()
        print(chr(10) + "[Exiting terminal proxy]")
        sys.exit(0)

    def handle_buffered_command(self, command):
        self.show_brand_next = False
        if command.strip() == 'c':
            self.show_brand_next = True
        if not command.strip():
            return
        if command.startswith("cd "):
            self.change_directory(command[3:].strip())
        elif command.startswith('emux '):
            self.handle_emux_command(command)
            return
        injected_command = self.inject(command)
        if injected_command.strip():
            self.run_command(injected_command)

    def change_directory(self, path):
        try:
            os.chdir(os.path.expandvars(os.path.expanduser(path)))
        except Exception as e:
            print(f"cd: {e}")

    def inject(self, command):
        self.show_brand_next = False
        if command.strip() == 'c':
            self.wasC = True
            self.show_brand_next = True
        else:
            self.wasC = False
        self.add_to_history(command)
        if command == 'exit': self.isActive = False
        if '.fi' in command or '.fo' in command or '.url' in command:
            parts = command.split()
            new = []
            for i, part in enumerate(parts):
                if not i:
                    new.append(part)
                    continue
                if part.endswith('.url'):
                    part = part[:-len('.url')]
                    path=_.url2file(part)
                    if path and os.path.exists(path):
                        part = path
                if part.endswith('.url.fo'):
                    part = part[:-len('.url.fo')]
                    path=_.url2file(part)
                    path = os.path.dirname(path)
                    if path and os.path.exists(path):
                        part = path
                elif part.endswith('.fi'):
                    if part[:-3] in self.aliases['aliases']:
                        part = self.aliases['aliases'][part[:-3]]
                elif part.endswith('.fo'):
                    try:
                        path = _bm.Bookmarks( part[:-3] ).get()
                        if path and os.path.exists(path):
                            part = path
                    except: pass
                new.append(part)
            command = ' '.join(new)
        if os.name != 'nt':
            blocked = ['clear', 'reset', 'stty', 'tput', 'less', 'more']
            if any(command.strip().startswith(b) for b in blocked):
                return f'echo "[pterm] ⛔ blocked: {command.strip()}"'
        command += ' && pwd > ' + self.pterm()
        return command

    def run_command(self, command):

        def runner():
            try:
                env = os.environ.copy()
                if os.name == 'nt':
                    subprocess.run(['cmd.exe', '/c', command], shell=False, env=env)
                else:
                    subprocess.run(f'bash -i -c "{command}"', shell=True, env=env)
            except Exception as e:
                print(f"[eco] ⚠️ Run error: {e}")
            finally:
                self.running_subprocess = None
        t = threading.Thread(target=runner, daemon=True)
        t.start()
        self.running_subprocess = t

    def brand(self):
        return self.get_fancy_prompt()

    def rewrite_eco_intent(self,inside):
        pass

    def process_full_buffer(self, text):
        if text.endswith(':eco'):
            inside = text[:-4].strip()
            if inside == 'test':
                return 'dir'
        return None

    def get_fancy_prompt(self):
        cwd = os.getcwd()
        home = os.path.expanduser('~')
        if cwd.startswith(home):
            cwd = cwd.replace(home, '~', 1)
        label = os.getenv('ECO_LABEL', None)
        if label:
            return FormattedText([
                ('class:prompt', f"┌──(emux: {label}: {self.user}{self.emoji}{self.host})-[ {cwd} ]{chr(10)}└─eco> ")
            ])
        else:
            return FormattedText([
                ('class:prompt', f"┌──({self.user}{self.emoji}{self.host})-[ {cwd} ]{chr(10)}└─eco> ")
            ])

    def handle_tab_autocomplete(self, event):
        text = self.buffered_input.strip()
        if not text:
            return
        path = text.split()[-1]  # Assume last word is the path fragment
        dirname = os.path.dirname(path) or '.'
        basename = os.path.basename(path)
        try:
            entries = os.listdir(dirname)
            matches = [e for e in entries if e.startswith(basename)]
            if matches:
                completed = os.path.join(dirname, matches[0])
                self.buffered_input = ' '.join(text.split()[:-1] + [completed])
                event.app.current_buffer.document = event.app.current_buffer.document._replace_text(self.buffered_input)
                event.app.current_buffer.cursor_position = len(self.buffered_input)
        except Exception as e:
            print(f"[EcoCLI] ⚠️ Autocomplete error: {e}")

    def tab_autocomplete(self, event):
        text = event.app.current_buffer.text.strip()
        print('text:', text)
        if not text:
            return
        words = text.split()
        partial = words[-1]  # Assume last word is target for completion
        is_command = False
        if len(words) == 1 and not any(c in partial for c in ('/', '\\', '.')):
            is_command = True
        if is_command:
            command_list = ['cd', 'ls', 'cat', 'nano', 'eco', 'e.file', 'e.cat', 'e.files', 'python', 'pip', 'dir']
            matches = [cmd for cmd in command_list if cmd.startswith(partial)]
            if matches:
                completed = matches[0]
                words[-1] = completed
                new_text = ' '.join(words)
                event.app.current_buffer.document = event.app.current_buffer.document._replace_text(new_text)
                event.app.current_buffer.cursor_position = len(new_text)
                self.buffered_input = new_text
            return
        base_dir = os.path.dirname(partial) or '.'
        fragment = os.path.basename(partial)
        try:
            entries = os.listdir(base_dir)
            matches = [e for e in entries if e.startswith(fragment)]
            if matches:
                completed = matches[0]
                completed_path = os.path.join(base_dir, completed)
                if os.path.isdir(completed_path):
                    completed_path += '/'
                words[-1] = completed_path
                new_text = ' '.join(words)
                event.app.current_buffer.document = event.app.current_buffer.document._replace_text(new_text)
                event.app.current_buffer.cursor_position = len(new_text)
                self.buffered_input = new_text
        except Exception as e:
            print(f"[EcoCLI] ⚠️ Autocomplete error: {e}")
        event.app.current_buffer.complete_state = None

    def start(self):
        os.system('cls' if os.name == 'nt' else 'clear')
        self.buffered_input = ''
        self.session = PromptSession()
        self.show_brand_next = True
        bindings = KeyBindings()
        @bindings.add('*')

        def _(event):
            if hasattr(event, 'data'):
                self.buffered_input += event.data
        @bindings.add('tab')

        def _(event):
            pass  # Your tab-complete logic here
        while self.isActive:
            if self.show_brand_next:
                prompt_text = self.get_fancy_prompt()
            else:
                prompt_text = 'eco> '
            try:
                command = self.session.prompt(
                    message=prompt_text,
                    key_bindings=bindings,
                )
            except EOFError:
                print(chr(10) + "[eco] 👋 Exit requested (EOF).")
                self.isActive = False
                break
            except KeyboardInterrupt:
                self.buffered_input = ''
                continue
            if command.strip():
                self.handle_buffered_command(command)
                self.buffered_input = ''
        self.isActive = False

    def process_full_buffer(self, text):
        if text.endswith(':-e'):
            search_text = text[:-3].strip()
            results = self.eco_search(search_text)
            if results:
                self.current_search_results = results  # Store in memory for selection
                self.show_search_results(results)
            else:
                print("[EcoCLI] ❌ No matches found.")
            return ''  # Clear buffer for selection
        if text.endswith(':e'):
            choice = text[:-2].strip()
            if choice.isdigit() and hasattr(self, 'current_search_results'):
                choice_idx = int(choice) - 1
                if 0 <= choice_idx < len(self.current_search_results):
                    selected_entry = self.current_search_results[choice_idx]
                    self.run_eco_entry(selected_entry)
                else:
                    print("[EcoCLI] ⚠️ Invalid selection.")
            else:
                print("[EcoCLI] ⚠️ Invalid selection or no previous search.")
            return ''
        return None

    def eco_search(self, search_text):
        """
        Search eco.db for matching entries.
        """
        try:
            import duckdb # type: ignore
            con = duckdb.connect(self.get_eco_db_path())  # your own db path getter
            query = f"SELECT * FROM apps WHERE keywords ILIKE '%{search_text}%' OR title ILIKE '%{search_text}%'"
            results = con.execute(query).fetchall()
            columns = [desc[0] for desc in con.description]
            con.close()
            entries = [dict(zip(columns, row)) for row in results]
            return entries
        except Exception as e:
            print(f"[EcoCLI] ❌ Search error: {e}")
            return []

    def show_search_results(self, results):
        """
        Display search results nicely numbered.
        """
        if not results:
            print("[EcoCLI] ❌ No results to show.")
            return
        print(repr(chr(10))+"[EcoCLI] Found matches:")
        for idx, entry in enumerate(results, 1):
            title = entry.get('title', 'No Title')
            keywords = entry.get('keywords', '')
            print(f" {idx}. {title}  ({keywords})")
        print(repr(chr(10))+"Type the number and ':e' to select.")

    def run_eco_entry(self, entry):
        """
        Execute or begin a decision tree for selected eco entry.
        """
        title = entry.get('title', 'Unknown')
        command = entry.get('command', '')
        intent_json = entry.get('intent_json', '{}')
        print(frepr(chr(10))+"[EcoCLI] 🚀 Selected: {title}")
        try:
            import json
            intent = json.loads(intent_json)
            if intent and isinstance(intent, dict) and 'questions' in intent:
                print("[EcoCLI] 🌱 Launching Decision Tree...")
                self.start_decision_tree(intent)
            else:
                print(f"[EcoCLI] ⚡ Running: {command}")
                self.handle_buffered_command(command)
        except Exception as e:
            print(f"[EcoCLI] ❌ Error processing entry: {e}")

    def attach_to_session(self, label):
        self.attached_label = label
        os.environ['ECO_LABEL'] = label
        self.show_brand_next = True
        print(f"[emux] 🧩 Attached to session '{label}'")

    def handle_emux_command(self, command):
        parts = command.strip().split()
        if len(parts) < 2:
            print("[emux] ❓ Usage: emux -n/-kill/-killall/-list/-send/-a label")
            return
        action = parts[1]
        if self.emux is None:
            self.emux = EcoMUX()
        if action in ('-n', '--new'):
            if len(parts) < 3:
                print("[emux] ❓ Usage: emux -n label")
                return
            label = parts[2]
            self.emux.new(label)
            self.attach_to_session(label)
        elif action in ('-a', '--attach'):
            if len(parts) < 3:
                print("[emux] ❓ Usage: emux -a label")
                return
            label = parts[2]
            self.attach_to_session(label)
        elif action in ('-k', '-kill', '--kill'):
            if len(parts) < 3:
                print("[emux] ❓ Usage: emux -kill label")
                return
            label = parts[2]
            self.emux.kill(label)
        elif action in ('-ka', '-killall', '--killall'):
            self.emux.killall()
        elif action in ('-l', '-list', '--list'):
            self.emux.list()
        elif action in ('-send', '--send'):
            if len(parts) < 4:
                print("[emux] ❓ Usage: emux -send label command_here")
                return
            label = parts[2]
            send_command = ' '.join(parts[3:])
            self.emux.send_command(label, send_command)
            print("[emux] ⏳ Waiting for response...")
            output = self.emux.receive_output(label)
            print(output)
        else:
            print(f"[emux] ❓ Unknown emux command: {action}")
'''
import importlib
importlib.reload(os)
'''












import datetime
def friendlyDate( theDate ):
	return str(datetime.datetime.fromtimestamp(float(theDate)).strftime('%Y-%m-%d %H:%M:%S'))
import datetime
import time

def autoDate(data, fail=False):
    try:
        import datefinder # type: ignore
        matches = list(datefinder.find_dates(str(data)))
        if matches:
            return matches[0].timestamp()
    except Exception:
        pass

    if isinstance(data, (int, float)):
        if int(data) > 1000000000:
            if int(data) > 9999999999:
                return int(data) / 1000
            return int(data)
        else:
            return False

    try:
        s = str(data).strip()
        s = s.replace('T', ' ').split('+')[0].split('Z')[0].strip()
        if any(x in s.lower() for x in ['am', 'pm']):
            try:
                dt = datetime.datetime.strptime(s, '%Y-%m-%d %I:%M:%S %p')
                return dt.timestamp()
            except Exception:
                pass
            try:
                dt = datetime.datetime.strptime(s, '%Y-%m-%d %I:%M %p')
                return dt.timestamp()
            except Exception:
                pass

        # Try ISO standard
        try:
            dt = datetime.datetime.fromisoformat(s)
            return dt.timestamp()
        except Exception:
            pass

        # Try some common formats
        for fmt in [
            '%Y-%m-%d %H:%M:%S',
            '%Y-%m-%d %H:%M',
            '%Y-%m-%d',
            '%m/%d/%Y',
            '%m/%d/%y',
            '%d-%m-%Y',
            '%d/%m/%Y',
            '%b %d %Y',
            '%B %d %Y',
            '%b %d, %Y',
            '%B %d, %Y',
        ]:
            try:
                dt = datetime.datetime.strptime(s, fmt)
                return dt.timestamp()
            except Exception:
                continue

        # If still looks numeric
        if s.isdigit():
            if len(s) > 10:
                return int(s) / 1000
            return int(s)

    except Exception as e:
        if fail:
            raise e
        return False

    if fail:
        raise Exception('Could not parse date')
    return False
import time
from datetime import datetime, timedelta

def ago(text):
    dt = autoDate(text)
    if dt:
        return dt
    text = text.strip().lower()
    now = time.time()
    
    # Fast path: if it ends with 'm', assume month first
    if text.endswith('m') and text[:-1].isdigit():
        number = int(text[:-1])
        now_dt = datetime.fromtimestamp(now)
        year = now_dt.year
        month = now_dt.month + number

        while month > 12:
            month -= 12
            year += 1

        days_in_month = [31,
                         29 if year % 4 == 0 and (year % 100 != 0 or year % 400 == 0) else 28,
                         31,30,31,30,31,31,30,31,30,31]
        day = min(now_dt.day, days_in_month[month - 1])
        new_dt = datetime(year, month, day, now_dt.hour, now_dt.minute, now_dt.second)
        return int(new_dt.timestamp())

    units = {
        's': 1,
        'sec': 1,
        'secs': 1,
        'second': 1,
        'seconds': 1,
        'min': 60,
        'mins': 60,
        'minute': 60,
        'minutes': 60,
        'h': 3600,
        'hr': 3600,
        'hrs': 3600,
        'hour': 3600,
        'hours': 3600,
        'd': 86400,
        'day': 86400,
        'days': 86400,
        'w': 604800,
        'wk': 604800,
        'wks': 604800,
        'week': 604800,
        'weeks': 604800,
        'y': 31536000,
        'yr': 31536000,
        'yrs': 31536000,
        'year': 31536000,
        'years': 31536000,
    }

    import re
    match = re.match(r'^(\d+)\s*([a-z]+)$', text)
    if not match:
        raise ValueError(f"Invalid format: {text}")
    
    number = int(match.group(1))
    unit = match.group(2)

    unit = unit.rstrip('s')  # allow plural forms like "hours", "minutes"

    if unit not in units:
        raise ValueError(f"Unknown time unit: {unit}")
    
    seconds = number * units[unit]
    return int(now + seconds)


import sys

class SwitchManager:
    def __init__(self, command=None, Switches=None, Triggers=None):

        if type(command) == str:
            while '  ' in command: command = command.replace('  ', ' ')
            command = command.split(' ')

        if Switches is None:
            Switches = {}
        if Triggers is None:
            Triggers = {}

        self.defaultTriggers = {
            'Ago': π.e.ago,
        }
        self.triggers = {}
        for key in self.defaultTriggers:
            self.triggers[key] = self.defaultTriggers[key]
        for key in Triggers:
            self.triggers[key] = Triggers[key]

        self.defaultSwitches = {}

        self.switchesRegister = {}
        for key in Switches:
            self.switchesRegister[key] = Switches[key]
        for key in self.defaultSwitches:
            if key not in self.switchesRegister:
                self.switchesRegister[key] = self.defaultSwitches[key]

        if not command:
            command = sys.argv
        self.command = command
        self.app = command[0]
        self.args = command[1:]

        self.used = {}
        self._Values = {}
        self.usage = {}
        self.instances = {}

        # Clean up switchesRegister formatting
        for key in self.switchesRegister:
            self.used[key] = False
            text = self.switchesRegister[key]
            text = text.replace(',', ' ').replace('|', ' ').replace(';', ' ')
            while '  ' in text:
                text = text.replace('  ', ' ')
            self.switchesRegister[key] = text.strip().replace(' ', ',')

        # Initialize empty value holders
        for key in self.switchesRegister:
            self._Values[key] = []

        # Build a flag lookup
        self.flag_to_key = {}
        for key, flags in self.switchesRegister.items():
            for flag in flags.split(','):
                self.flag_to_key[flag] = key

        self.parse()

    def strip(self):
        clean = []
        for item in self.command:
            if item not in self.switchesRegister and item not in self.flag_to_key:
                clean.append(item)
        return clean


    def parse(self):
        current_switch = None
        current_key = None
        i = 0

        while i < len(self.args):
            arg = self.args[i]
            if arg in self.flag_to_key:
                current_key = self.flag_to_key[arg]
                current_switch = arg

                if current_key not in self.instances:
                    self.used[current_key] = True
                    self.instances[current_key] = {}

                if current_switch not in self.instances[current_key]:
                    self.instances[current_key][current_switch] = []

                if current_key not in self.usage:
                    self.usage[current_key] = []
                if current_switch not in self.usage[current_key]:
                    self.usage[current_key].append(current_switch)

                if self._Values[current_key] == []:
                    self._Values[current_key] = True  # Assume True first
            else:
                if current_key and current_switch:
                    if self._Values[current_key] is True:
                        self._Values[current_key] = []
                    if current_key in self.triggers:
                        value = self.triggers[current_key](arg)
                    else:
                        value = arg
                    self._Values[current_key].append(value)
                    self.instances[current_key][current_switch].append(value)
            i += 1

    def isActive(self, name):
        return self.used.get(name, False)

    def Values(self, name, instance=None):
        if name not in self.instances:
            return []
        if instance is not None:
            return self.instances[name].get(instance, [])
        return self.values(name)

    def values(self, name):
        if name not in self._Values:
            return []
        if self._Values[name] is True:
            return []
        return self._Values[name]
    
    def value(self, name):
        val = self.values(name)
        return ','.join(val)
    
    def validate(self):
        import json

        print('\nApp:')
        print(self.app)

        print('\nUsed:')
        print(json.dumps(self.used, indent=4))

        print('\nValues:')
        print(json.dumps(self._Values, indent=4))
        if 'Ago' in self._Values:
            for ago in self._Values['Ago']:
                print('Ago:', π.e.friendlyDate(ago))

        print('\nUsage:')
        print(json.dumps(self.usage, indent=4))

        print('\nInstances:')
        print(json.dumps(self.instances, indent=4))
π.e.friendlyDate=friendlyDate
π.e.autoDate=autoDate
π.e.ago=ago
π.e.SwitchManager=SwitchManager

























def getYML(path):
    import yaml
    if not os.path.exists(path):
        raise FileNotFoundError(f"File not found: {path}")
    
    with open(path, 'r', encoding='utf-8') as f:
        data = yaml.safe_load(f)
    
    return data
π.e.getYML=getYML
def getText(path, raw=False):
    if not os.path.exists(path):
        raise FileNotFoundError(f"File not found: {path}")
    
    with open(path, 'r', encoding='utf-8') as f:
        if raw:
            return f.read()
        else:
            return f.read().splitlines()
π.e.getText=getText

def getTable(path):
    try:
        if not os.sep in path:
            import _rightThumb._vars as _v # type: ignore
            path = _v.tt+os.sep+path
    except: pass
    if not os.path.exists(path):
        raise FileNotFoundError(f"File not found: {path}")
    
    with open(path, 'r', encoding='utf-8') as f:
        data = json.load(f)
    
    return data
π.e.getTable=getTable

def url2file(path):
    def getText(path, raw=False):
        if not os.path.exists(path):
            raise FileNotFoundError(f"File not found: {path}")
        
        with open(path, 'r', encoding='utf-8') as f:
            if raw:
                return f.read()
            else:
                return f.read().splitlines()
    def getYML(path):
        import yaml
        if not os.path.exists(path):
            raise FileNotFoundError(f"File not found: {path}")
        
        with open(path, 'r', encoding='utf-8') as f:
            data = yaml.safe_load(f)
        
        return data
    def getTable(path):
        try:
            if not os.sep in path:
                import _rightThumb._vars as _v # type: ignore
                path = _v.tt+os.sep+path
        except: pass
        if not os.path.exists(path):
            raise FileNotFoundError(f"File not found: {path}")
        
        with open(path, 'r', encoding='utf-8') as f:
            data = json.load(f)
        
        return data
    url=path
    if path.startswith('http:'): path=path.replace('http:','https:')
    if path.startswith('https:') or path.startswith('http:'):
        url=url.replace('https://www.','https://')
        url=url.replace('http://www.','http://')
        if '?' in url: url=url.split('?')[0]
        sites=getTable('site-locations.list')
        for mPath in sites:
            if os.path.isfile(mPath):
                p = os.path.dirname(mPath)

                if getText( mPath, raw=True ).strip().startswith('{'): meta = getTable( mPath )
                else: meta = getYML( mPath )
                if 'url' in meta:
                    u = meta['url'].replace('https://www.','https://')
                    u = meta['url'].replace('http://www.','http://')
                    if url.startswith(u):
                        x=url[len(u):].replace('/',os.sep)
                        # print(x);sys.exit()
                        # print(x);sys.exit();
                        y=p+os.sep+x
                        # if not os.path.isdir(y): print('missing folder')
                        if os.path.isdir(y):
                            test='index.php index.htm index.html'.split(' ')
                            for t in test:
                                yt=str(y+os.sep+t).replace(os.sep+os.sep,os.sep)
                                if os.path.isfile(yt):
                                    y=yt
                        y=y.replace(os.sep+os.sep,os.sep)
                        if os.path.isfile(y):
                            path=y
    return path
π.e.url2file=url2file














π.e.TerminalProxy=TerminalProxy