
import subprocess
def CMD(command, shell=True, timeout=None, capture_stderr=True):
	"""
	Execute an OS command and return output as text.

	Args:
		command (str or list): The command to run.
		shell (bool): Whether to run in shell mode.
		timeout (int): Optional timeout in seconds.
		capture_stderr (bool): If True, merge stderr into stdout.

	Returns:
		A tuple (success: bool, output: str)
	"""
	try:
		if isinstance(command, str) and not shell:
			command = command.split()

		result = subprocess.run(
			command,
			shell=shell,
			check=False,
			stdout=subprocess.PIPE,
			stderr=subprocess.STDOUT if capture_stderr else subprocess.PIPE,
			timeout=timeout,
			text=True  # Return output as string not bytes
		)

		return True, result.stdout.strip()

	except subprocess.TimeoutExpired:
		return False, "[EcoCLI] ⏰ Command timed out"
	except Exception as e:
		return False, f"[EcoCLI] ❌ Command error: {str(e)}"
π.e.CMD=CMD
