
class EcoPrivateDB:
	def __init__(self):
		self.db_path = os.path.expanduser('~/.eco/private.db'.replace('/', os.sep))
		self.conn = None
		self.key = None

	def prompt_password(self):
		import getpass
		pw = getpass.getpass(prompt="[EcoCLI] 🔒 Enter Private DB Password: ")
		if not pw:
			raise Exception("Password required for private.db")
		return pw

	def derive_key(self, password, salt=b'eco_salt'):
		from hashlib import pbkdf2_hmac
		key = pbkdf2_hmac('sha256', password.encode('utf-8'), salt, 100000)
		return key

	def open(self):
		if not self.key:
			password = self.prompt_password()
			self.key = self.derive_key(password)

		# Open DuckDB normally for now
		self.conn = duckdb.connect(self.db_path)
		self.conn.execute("""
			CREATE TABLE IF NOT EXISTS secure_data (
				id INTEGER PRIMARY KEY,
				key TEXT,
				value TEXT
			)
		""")

	def encrypt(self, plaintext):
		from Crypto.Cipher import AES # type: ignore
		from Crypto.Random import get_random_bytes # type: ignore
		from base64 import b64encode

		nonce = get_random_bytes(12)
		cipher = AES.new(self.key[:32], AES.MODE_GCM, nonce=nonce)
		ciphertext, tag = cipher.encrypt_and_digest(plaintext.encode('utf-8'))
		return b64encode(nonce + tag + ciphertext).decode('utf-8')

	def decrypt(self, encrypted_text):
		from Crypto.Cipher import AES # type: ignore
		from base64 import b64decode

		data = b64decode(encrypted_text)
		nonce, tag, ciphertext = data[:12], data[12:28], data[28:]
		cipher = AES.new(self.key[:32], AES.MODE_GCM, nonce=nonce)
		plaintext = cipher.decrypt_and_verify(ciphertext, tag)
		return plaintext.decode('utf-8')

	def set(self, key, value):
		encrypted_value = self.encrypt(value)
		self.conn.execute(
			"INSERT INTO secure_data (key, value) VALUES (?, ?) ON CONFLICT(key) DO UPDATE SET value=excluded.value",
			(key, encrypted_value)
		)
		self.conn.commit()

	def get(self, key):
		result = self.conn.execute(
			"SELECT value FROM secure_data WHERE key = ?", (key,)
		).fetchone()
		if result:
			return self.decrypt(result[0])
		return None
π.e.EcoPrivateDB=EcoPrivateDB
