___
## features
- ctrl s, saves search or document
- save searches
- documents
    + open on reload page
    + saves associated search
        * when you re-search from document it lets you know what it is saved as
    + on page reload documents are sorted by saved searches
___
## features to add
- search folders

___
## scrap
~~~
if (isset($_COOKIE['ddb-color'])) { $color=$_COOKIE['ddb-color']; } else { $color='light'; }; $color=str_replace('"', '', $color);
$.cookie('ddb-color', '<?php echo $color; ?>', { expires: 3653, 'path': '/'});
~~~
___
## php zip file contents managment
https://chat.openai.com/chat
prompt: in php i want to upload a zip file. i want to check if a zip file named _file_.zip exists. if it does not exist save the uploaded file as that name. if it does exist take the uploaded zip file and add the contents to that zip file. if the file with the same name exists, replace it.
~~~php
<?php
$zip_file_name = "_file_.zip"; // Set the name of the zip file
$target_dir = "./"; // Set the target directory where the uploaded files will be stored
$target_file = $target_dir . basename($_FILES["file"]["name"]); // Get the name of the uploaded file
$uploadOk = 1;
$fileType = strtolower(pathinfo($target_file,PATHINFO_EXTENSION)); // Get the file extension

// Check if file already exists
if (file_exists($zip_file_name)) {
    $zip = new ZipArchive();
    // Open the existing zip file
    if ($zip->open($zip_file_name, ZipArchive::CREATE) !== TRUE) {
        exit("Unable to open <$zip_file_name>\n");
    }
    // Add the contents of the uploaded file to the existing zip file
    $zip->addFile($_FILES["file"]["tmp_name"], $_FILES["file"]["name"]);
    $zip->close();
} else {
    // Save the uploaded file as the zip file
    if (move_uploaded_file($_FILES["file"]["tmp_name"], $target_dir.$zip_file_name)) {
        echo "The file ". htmlspecialchars( basename( $_FILES["file"]["name"])). " has been uploaded.";
    } else {
        echo "Sorry, there was an error uploading your file.";
    }
}
?>
~~~

___
## python zip notes

### zip folder
~~~py
import shutil
shutil.make_archive(output_filename, 'zip', dir_name)
~~~

### unzip file
~~~py
import zipfile
with zipfile.ZipFile(path_to_zip_file, 'r') as zip_ref:
    zip_ref.extractall(directory_to_extract_to)
#### OR ####
import shutil
shutil.unpack_archive(filename, extract_dir)
#### OR ####
from zipfile import ZipFile
zf = ZipFile('path_to_file/file.zip', 'r')
zf.extractall('path_to_extract_folder')
zf.close()
~~~

### add file to existing zip file
~~~py
import zipfile

filepath = '/home/user/a/b/c/test.zip'
with zipfile.ZipFile(filepath, 'a') as zipf:
    source_path = '/home/user/a/b/c/1.txt'
    destination = 'foobar.txt'
    zipf.write(source_path, destination)
~~~

### extract file from zip
~~~py
import shutil
import zipfile

with zipfile.ZipFile('/path/to/my_file.apk') as z:
    with z.open('/res/drawable/icon.png') as zf, open('temp/icon.png', 'wb') as f:
        shutil.copyfileobj(zf, f)

#### OR ####
import zipfile

with zipfile.ZipFile('/path/to/my_file.apk') as z:
    with open('temp/icon.png', 'wb') as f:
        f.write(z.read('/res/drawable/icon.png'))
~~~
___
## Piller Dennis API key
~~~cmd
p sha1-string -password Jesus 0001-12-25 1998-11-21 813-690-1260 | cp
p sha1-string -password Jesus 0001-12-25 1998-11-21 813-964-7127 | cp
p sha1-string -password Jesus 0001-12-25 1998-11-21 813-455-9361 | cp
p sha1-string -password Jesus 0001-12-25 1998-11-21 813-624-5009 | cp
p sha1-string -password Jesus 0001-12-25 1998-11-21 813-967-7127 | cp
p sha1-string -password Jesus 0001-12-25 1998-11-21 813-690-1260 ADMIN | cp
~~~
813-967-7127