<?php
$target_dir = "../fi/";
$zip_file_name = "archive.zip";
$db_file_name = "documents.db";

// $_SERVER['HTTP_APP_API_KEY']

// Check if the zip file was uploaded and save it as "archive.zip"
if (isset($_FILES["zip_file"]) && $_FILES["zip_file"]["error"] == 0) {
    if (move_uploaded_file($_FILES["zip_file"]["tmp_name"], $target_dir . $zip_file_name)) {
        echo "The file ". htmlspecialchars($zip_file_name). " has been uploaded and saved as archive.zip.";


// Check if "documents.zip" already exists
if (!file_exists($target_dir . "documents.zip")) {
    // Rename the "archive.zip" file to "documents.zip"
    if (rename($target_dir . $zip_file_name, $target_dir . 'documents.zip')) {
        echo "The file ". htmlspecialchars($zip_file_name). " has been renamed to documents.zip.";
    } else {
        echo "Sorry, there was an error renaming the file.";
    }
} else {
    echo "The file documents.zip already exists.";



            // Source zip file
            $source_zip = new ZipArchive();
            $source_zip->open($target_dir . $zip_file_name);

            // Destination zip file
            $dest_zip = new ZipArchive();
            $dest_zip->open($target_dir . 'documents.zip', ZipArchive::CREATE);

            // Loop through each file in the source zip file
            for ($i = 0; $i < $source_zip->numFiles; $i++) {
                $filename = $source_zip->getNameIndex($i);

                // If file already exists in destination zip, delete it
                if ($dest_zip->getFromName($filename) !== false) {
                    $dest_zip->deleteName($filename);
                }

                // Add file to destination zip
                $dest_zip->addFromString($filename, $source_zip->getFromIndex($i));
            }

            // Close zip files
            $source_zip->close();
            $dest_zip->close();






}


    } else {
        echo "Sorry, there was an error uploading your zip file.";
    }
} else {
    echo "Please select a zip file to upload.";
}

// Check if the database file was uploaded and save it as "documents.db"
if (isset($_FILES["db_file"]) && $_FILES["db_file"]["error"] == 0) {
    if (move_uploaded_file($_FILES["db_file"]["tmp_name"], $target_dir . $db_file_name)) {
        echo "The file ". htmlspecialchars($db_file_name). " has been uploaded and saved as documents.db.";
    } else {
        echo "Sorry, there was an error uploading your database file.";
    }
} else {
    echo "Please select a database file to upload.";
}



?>
