DROP TABLE IF EXISTS `_reph_signature_staff_type`;
CREATE TABLE _reph_signature_staff_type (
	id int auto_increment primary key,
	date_created varchar(30),
	date_modified timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
	guid varchar(50),
	label varchar(50),
	services int(1) default '1',
	status int(1) default '1',
	del int(1) default '0'
);

DROP TABLE IF EXISTS `_reph_signature_category`;
CREATE TABLE _reph_signature_category (
	id int auto_increment primary key,
	date_created varchar(30),
	date_modified timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
	guid varchar(50),
	label varchar(50),
	status int(1) default '1',
	del int(1) default '0'
);

DROP TABLE IF EXISTS `_reph_signature_staff`;
CREATE TABLE _reph_signature_staff (
	id int auto_increment primary key, 
	date_created varchar(30),
	date_modified timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
	guid varchar(50),
	staff_type_mid varchar(50),
	label_first_last varchar(50),
	first varchar(50),
	last varchar(50),
	status int(1) default '1',
	loyalty varchar(50),
	permanent_makeup int(1) default '0',
	email varchar(50),
	phone varchar(50),
	street1 varchar(100),
	street2 varchar(100),
	city varchar(100),
	state varchar(2),
	zip varchar(100),
	availability_json varchar(800),
	del int(1) default '0'
);

DROP TABLE IF EXISTS `_reph_signature_services`;
CREATE TABLE _reph_signature_services (
	id int auto_increment primary key, 
	date_created varchar(30),
	date_modified timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
	guid varchar(50),
	staff_type_mid varchar(50),
	category_mid varchar(50),
	label varchar(100),
	duration varchar(100),
	dvalue varchar(100),
	addon int(1) default '0',
	status int(1) default '1',
	permanent_makeup int(1) default '0',
	del int(1) default '0'
);

DROP TABLE IF EXISTS `_reph_signature_weeks`;
CREATE TABLE _reph_signature_weeks (
	id int auto_increment primary key, 
	date_created varchar(30),
	date_modified timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
	guid varchar(50),
	staff_mid varchar(50),
	epoch varchar(50),
	woy int(10),
	pmoney varchar(20),
	cmoney varchar(20),
	duration varchar(20),
	tip varchar(20) default '0',
	status int(1) default '1',
	del int(1) default '0'
);


DROP TABLE IF EXISTS `_reph_signature_week_items`;
CREATE TABLE _reph_signature_week_items (
	id int auto_increment primary key, 
	date_created varchar(30),
	date_modified timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
	guid varchar(50),
	services_mid varchar(50),
	staff_mid varchar(50),
	epoch varchar(50),
	woy int(10),
	dvalue varchar(20),
	cnt int(5),
	duration varchar(20),
	row int(5),
	tip varchar(20) default '0',
	custom int(1) default '0',
	addon int(1) default '0',
	status int(1) default '1',
	del int(1) default '0'
);

DROP TABLE IF EXISTS `_reph_signature_payscale`;
CREATE TABLE _reph_signature_payscale (
	id int auto_increment primary key, 
	date_created varchar(30),
	date_modified timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
	guid varchar(50),
	services_mid varchar(50),
	staff_mid varchar(50),
	dvalue varchar(20),
	status int(1) default '1',
	del int(1) default '0'
);


DROP TABLE IF EXISTS `_reph_signature_schedule`;
CREATE TABLE _reph_signature_schedule (
	id int auto_increment primary key, 
	date_created varchar(30),
	date_modified timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
	guid varchar(50),
	staff_mid varchar(50),
	wd varchar(20),
	epoch varchar(50),
	woy int(10),
	hours int(10),
	status int(1) default '1',
	del int(1) default '0'
);




ALTER TABLE _reph_signature_week_items ADD tip int(5) default '0'
ALTER TABLE _reph_signature_week_items ADD row int(5)

ALTER TABLE _reph_signature_staff ADD permanent_makeup int(1) default '0';
ALTER TABLE _reph_signature_services ADD permanent_makeup int(1) default '0';
ALTER TABLE _reph_signature_staff ADD loyalty varchar(50);
-- weeks_id varchar(50),
-- percentage int(2),

ALTER TABLE _reph_signature_services ADD category_mid varchar(50);


ALTER TABLE _reph_signature_staff ADD availability_json varchar(800);

,