DROP TABLE IF EXISTS `_reph_signature_staff_type`;
CREATE TABLE _reph_signature_staff_type (
	id int auto_increment primary key,
	date_created int(30),
	date_modified timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
	guid varchar(50),
	label varchar(50),
	services int(1) default '1',
	status int(1) default '1',
	del int(1) default '0'
);

DROP TABLE IF EXISTS `_reph_signature_staff`;
CREATE TABLE _reph_signature_staff (
	id int auto_increment primary key, 
	date_created int(30),
	date_modified timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
	guid varchar(50),
	staff_type_mid varchar(50),
	label_first_last varchar(1),
	first varchar(50),
	last varchar(50),
	email varchar(50),
	phone varchar(50),
	availabilityjson varchar(800),
	status int(1) default '1',
	street1 varchar(100),
	street2 varchar(100),
	city varchar(100),
	state varchar(2),
	zip varchar(100),
	del int(1) default '0'
);

DROP TABLE IF EXISTS `_reph_signature_services`;
CREATE TABLE _reph_signature_services (
	id int auto_increment primary key, 
	date_created int(30),
	date_modified timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
	guid varchar(50),
	staff_type_mid varchar(50),
	label varchar(50),
	duration varchar(300),
	dvalue int(5),
	status int(1) default '1',
	del int(1) default '0'
);

DROP TABLE IF EXISTS `_reph_signature_appointments`;
CREATE TABLE _reph_signature_appointments (
	id int auto_increment primary key, 
	date_created int(30),
	date_modified timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
	guid varchar(50),
	customer_mid varchar(50),
	time_start int(30),
	time_end int(30),
	complete int(1) default '0',
	status int(1) default '1',
	del int(1) default '0'
);

DROP TABLE IF EXISTS `_reph_signature_appointment_items`;
CREATE TABLE _reph_signature_appointment_items (
	id int auto_increment primary key, 
	date_created int(30),
	date_modified timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
	guid varchar(50),
	appointments_id varchar(50),
	services_mid varchar(50),
	staff_mid varchar(50),
	dvalue int(5),
	duration int(10),
	status int(1) default '1',
	del int(1) default '0'
);

DROP TABLE IF EXISTS `_reph_signature_customers`;
CREATE TABLE _reph_signature_customers (
	id int auto_increment primary key, 
	date_created int(30),
	date_modified timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
	guid varchar(50),
	label_first_last varchar(1),
	first varchar(50),
	last varchar(50),
	email varchar(50),
	phone varchar(50),
	status int(1) default '1',
	street1 varchar(100),
	street2 varchar(100),
	city varchar(100),
	state varchar(2),
	zip varchar(100),
	del int(1) default '0'
);

