const sign = {
  ran: false,
  getLocation: function () {
    setTimeout(function () {
      if (!sign.ran) {
        sign.showLocation({ coords: { latitude: 0, longitude: 0 } });
      }
    }, 1000);
    try {
      navigator.geolocation.getCurrentPosition(sign.showLocation);
    } catch (err) {
      sign.showLocation({ coords: { latitude: 0, longitude: 0 } });
    }
  },
  showLocation: function (position) {
    sign.ran = true;
    const latitude = position.coords.latitude;
    const longitude = position.coords.longitude;
    const post = {};
    post.name = document.getElementById("signature_name").value;
    post.latitude = latitude;
    post.longitude = longitude;
    const payloadElement = document.querySelector("[payload]");
    if (payloadElement) {
      if (payloadElement.value !== undefined && payloadElement.value.length) {
        post.payload = payloadElement.value;
      } else if (payloadElement.innerHTML !== undefined) {
        post.payload = payloadElement.innerHTML;
      }
    }
    post.epoch = sign.epoch();
    post.clientWidth = document.documentElement.clientWidth;
    post.clientHeight = document.documentElement.clientHeight;
    post.width = screen.width;
    post.height = screen.height;
    post.tz = Intl.DateTimeFormat().resolvedOptions().timeZone;

    fetch("https://eyeformeta.com/apps/identity/sign.php", {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
      },
      body: JSON.stringify(post),
    })
      .then((response) => response.text())
      .then((data) => {
        sign.sig = data;
        document.getElementById("signature").innerHTML = data;
      });

  },
  epoch: function (d) {
    if (typeof d == "undefined") {
      d = new Date();
    }
    return (d.getTime() - d.getMilliseconds()) / 1000;
  },
  load: function () {
    const code = `<div id="signature" style="position: absolute; width: 100%; text-align: center; bottom: 10px;">
            <input type="text" id="signature_name" name="name" placeholder="name">
            <button onclick="sign.getLocation();">Sign</button>
        </div>`;
    document.addEventListener("DOMContentLoaded", function () {
      document.body.insertAdjacentHTML("beforeend", code);
    });
  },
};

sign.load();