[Get Started with Super SIM, the Raspberry Pi 4 and the Sixfab Cellular IoT Hat | Twilio](https://www.twilio.com/docs/iot/supersim/getting-started-super-sim-raspberry-pi-sixfab-cellular-iot-hat)
==============================================================================

Sixfab recently EOL’d the Cellular IoT Hat and is only making it available on build-to-order basis. If you already have a Cellular IoT Hat, you can continue with this tutorial. If not, check out our guides to working with Super SIM, the Raspberry Pi, and these add-on boards:

• [The Sixfab 3G-4G/LTE Base Hat.](https://www.twilio.com/docs/iot/supersim/getting-started-super-sim-raspberry-pi-sixfab-base-hat)

• [The Waveshare 4G Hat.](https://www.twilio.com/docs/iot/supersim/getting-started-super-sim-raspberry-pi-waveshare-4g-hat)

Twilio [Super SIM](https://www.twilio.com/docs/iot/supersim) can empower a huge range of IoT devices. This guide focuses on just one of them: [Sixfab’s Cellular IoT Hat](https://sixfab.com/product/raspberry-pi-lte-m-nb-iot-egprs-cellular-hat/), a development board which equips a low-cost Raspberry Pi computer with a Quectel BG96 cellular modem. The BG96 is a particularly good modem with which to try out Super SIM: it supports the key IoT-oriented cellular standard enabled by Super SIM, Cat-M. The European version also provides 2G for back-up where that is still available.

![](https://twilio-cms-prod.s3.amazonaws.com/images/P1020003.original.jpg)

![](https://twilio-cms-prod.s3.amazonaws.com/images/P1020003.original.jpg)

This guide requires a **configured** [Super SIM](https://www.twilio.com/docs/iot/supersim/super-sim-first-steps). If you haven’t set up your Super SIM in the [Console](https://www.twilio.com/console/iot/supersim/sims), please do so now. The [Super SIM First Steps guide](https://www.twilio.com/docs/iot/supersim/super-sim-first-steps) has help if you need it.

[The hardware](#the-hardware)
-----------------------------

In addition to your configured [Super SIM](https://www.twilio.com/docs/iot/supersim/super-sim-first-steps), you will need the following hardware to proceed with this guide:

*   A Sixfab [Cellular IoT Hat](https://sixfab.com/product/raspberry-pi-lte-m-nb-iot-egprs-cellular-hat/). It’s available in Worldwide and Verizon USA-certified forms; select the one that’s right for your location.
*   A [Raspberry Pi](https://www.raspberrypi.org/products/raspberry-pi-4-model-b/). This guide was written using the Pi 4 Model B, but there are other versions of the Pi available — it should work with any of them, but we’ve only tested the 4 and 3B. The Cellular IoT Hat works with all but the very first Pi. To run the Pi, you will also need:
    *   A Micro SD card of 8GB or above.
    *   A monitor and an HDMI-to-micro-HDMI cable.
    *   A keyboard and a mouse
    *   A 5V, 2A (10W) USB-C AC adaptor.

### [Hardware setup: the Raspberry Pi](#hardware-setup-the-raspberry-pi)

The Raspberry Pi has its own setup procedure which involves downloading and installing its Linux operating system, called Raspberry Pi OS, onto the Micro SD card. The Raspberry Pi Foundation has [a very good walkthrough](https://projects.raspberrypi.org/en/projects/raspberry-pi-setting-up) of its own that covers this process — you should use this to get your Pi ready before proceeding to the next stage of this guide.

![](https://twilio-cms-prod.s3.amazonaws.com/images/P1020064.original.jpg)

![](https://twilio-cms-prod.s3.amazonaws.com/images/P1020064.original.jpg)

During setup you should connect your Pi 4 to your WiFi network as you will need to download extra software later. We’ll disable WiFi in due course to demonstrate data access over cellular.

### [Hardware setup: the Cellular IoT Hat](#hardware-setup-the-cellular-iot-hat)

The Cellular IoT Hat ships with all you need to fit it onto the Pi. Just follow these steps to set everything up:

1.  If it’s powered up, turn off the Pi.
    *   If you’re at the command line, enter `sudo shutdown -h` now.
    *   If you’re at the desktop, select **Shutdown...** from the **Raspberry** menu and then click **Shutdown**.
    *   Remove the power cable when the Pi’s activity LED has flashed yellow ten times.
2.  Fit either of the two headers supplied with the Hat to the Pi’s paired row of GPIO pins and then slot the Cellular IoT Hat onto the extended header pins:  
    
    ![](https://twilio-cms-prod.s3.amazonaws.com/images/P1020065.original.jpg)
    
    ![](https://twilio-cms-prod.s3.amazonaws.com/images/P1020065.original.jpg)
    
3.  Fit your Super SIM into the Cellular IoT Hat’s SIM slot. The slot takes a 3FF Micro SIM, so take care removing your Super SIM from its mount, or use an adaptor if you have removed the Super SIM as a 4FF Nano SIM:  
    
    ![](https://twilio-cms-prod.s3.amazonaws.com/images/P1020066.original.jpg)
    
    ![](https://twilio-cms-prod.s3.amazonaws.com/images/P1020066.original.jpg)
    
4.  Connect the bundled cellular antenna to the Cellular IoT Hat. Match up the LTE line on the antenna with the LTE connector on the board. This guide doesn’t use the GPS antenna but we recommend fitting both antennas to reduce the strain on a single connector:  
    
    ![](https://twilio-cms-prod.s3.amazonaws.com/images/P1020067.original.jpg)
    
    ![](https://twilio-cms-prod.s3.amazonaws.com/images/P1020067.original.jpg)
    
5.  Connect the supplied USB cable to the micro USB port on the Cellular IoT Hat and a USB port on the Pi:  
    
    ![](https://twilio-cms-prod.s3.amazonaws.com/images/P1020068.original.jpg)
    
    ![](https://twilio-cms-prod.s3.amazonaws.com/images/P1020068.original.jpg)
    
6.  Finally, power up the Pi by re-inserting the power cable.

[Software setup](#software-setup)
---------------------------------

We now need to run through a few steps to get the Pi ready to talk to the Cellular IoT Hat. Some of these will require you to restart the Pi.

#### [1\. Set up serial port access](#1-set-up-serial-port-access)

1.  At the command line run `sudo raspi-config`.
2.  Use the cursor keys to highlight **Interfacing Options**, then hit **Enter**:  
    
    ![](https://twilio-cms-prod.s3.amazonaws.com/images/2020-11-09-121826_1920x1080_scrot.original.png)
    
    ![](https://twilio-cms-prod.s3.amazonaws.com/images/2020-11-09-121826_1920x1080_scrot.original.png)
    
3.  Now highlight **Serial Port** and hit **Enter**:  
    
    ![](https://twilio-cms-prod.s3.amazonaws.com/images/2020-11-10-130059_1920x1080_scrot.original.png)
    
    ![](https://twilio-cms-prod.s3.amazonaws.com/images/2020-11-10-130059_1920x1080_scrot.original.png)
    
4.  When you are asked **Would you like a login shell to be accessible over serial?** select **No** and hit **Enter**:  
    
    ![](https://twilio-cms-prod.s3.amazonaws.com/images/2020-11-10-130107_1920x1080_scrot.original.png)
    
    ![](https://twilio-cms-prod.s3.amazonaws.com/images/2020-11-10-130107_1920x1080_scrot.original.png)
    
5.  When you are asked **Would you like the serial port hardware to be enabled?** select **Yes** and hit **Enter**:  
    
    ![](https://twilio-cms-prod.s3.amazonaws.com/images/2020-11-10-130935_1920x1080_scrot.original.png)
    
    ![](https://twilio-cms-prod.s3.amazonaws.com/images/2020-11-10-130935_1920x1080_scrot.original.png)
    
6.  Select **Finish**.
7.  The `raspi-config` utility will offer to restart the Pi — accept its suggestion.

#### [2\. Power up the Hat](#2-power-up-the-hat)

When the Pi is back up, you should see that the Cellular IoT Hat’s **POWER** Led is lit green. Now press the **PWRKEY** button on the board — after a brief moment, the **STATUS** LED should light up too.

At the command line or in a desktop Terminal run:

    ls /dev/ttyUSB*
    

You should see a list of items all beginning with `ttyUSB` and including `ttyUSB3`, which is the device you will use in subsequent steps. With a Pi 4 and the current version of Raspberry Pi OS as of November 16, 2020 you should be good to go, but if you don’t see a list of TTYs, first check that the Cellular IoT Hat’s **PWR** and **STATUS** LEDs are lit. If they are, you will need to adjust the Pi’s system software; please [see this section](#appendix-downgrading-the-pi-kernel) before proceeding.

#### [3\. Attach to a cellular network](#3-attach-to-a-cellular-network)

The Cellular IoT Hat can be controlled using a software library written in Python. Enter the following at the command line or in a desktop Terminal:

    git clone https://github.com/sixfab/Sixfab_RPi_CellularIoT_Library.git sixfab
    

Jump into the `sixfab` directory and install the library:

    sudo python3 setup.py install
    

You will need to enter your Pi password. If you are in a location with Cat-M1 coverage, run

    python3 sample/configureCATM1.py
    

This script will give the Hat’s BG96 modem a minute to connect to the cellular network and then display some network information. At the `Waiting Time:` prompt, just hit **Enter**. You should see something like this when it’s done:

    +COPS: 0,0,"vodafone UK Twilio”,0
    

Exactly what you will see will depend on where in the world you are connecting from. If you see something like:

    +COPS: 0
    

then you are not in a region served with Cat-M1. To connect to a 2G network instead, run:

    python3 sample/configureGPRS.py
    

#### [4\. Connect to the Internet](#4-connect-to-the-internet)

If you have worked through this tutorial before, please note that the following section was updated February 2021 with a new, replacement Sixfab script so some parts of this step may be different than the last time you viewed it.

Now we know we have a cellular connection, we can connect to the Internet. We can set up the Pi’s required PPP (Point-to-Point Protocol) connection using software. Let’s install it now. Run the following at the command line or in a desktop Terminal:

    wget https://raw.githubusercontent.com/sixfab/Sixfab_PPP_Installer/master/ppp_install_standalone.sh
    

The script will take a second or two to download. Now run:

    chmod +x ppp_install_standalone.sh
    

and then:

    sudo ./ppp_install_standalone.sh
    

The script will prompt you for setup information:

*   When it asks **Please choose your Sixfab Shield/HAT**, enter `4` for the Pi Cellular IoT Hat.
*   When it asks **What is your carrier APN?**, enter `super`.
*   When it asks if you need to enter a username and password, just hit `n`.
*   When it asks **What is your device communication PORT?**, enter `ttyUSB3`.

Last of all, the script will also ask **Do you want to activate auto connect/reconnect service at R.Pi boot up?** You can enter `y` (yes) or `n` (no) according to preference. If you select no, you will need to start the PPP connection manually — this is what the remainder of this section of the tutoral assumes you have chosen. However, if you select yes, you can reboot the Pi and [jump straight to testing](#testing).

When the installation is done you’ll see the message **Press ENTER key to reboot** — do so.

After the Pi has rebooted, you’re all set to access the Internet over cellular. To be sure it’s working, turn off WiFi — this is easiest to do this from the icon in the Desktop menu bar.

To initiate an Internet connection, at the command line or in a desktop terminal run:

    sudo pon
    

You’ll see a stack of lines displayed at the command line.

When the prompt is back, you’re ready to try out the Internet connection:

*   Open up a browser and navigate to **twilio.com/docs/iot**:  
    
    ![](https://twilio-cms-prod.s3.amazonaws.com/images/2020-11-10-130146_1920x1080_scrot.original.png)
    
    ![](https://twilio-cms-prod.s3.amazonaws.com/images/2020-11-10-130146_1920x1080_scrot.original.png)
    
*   At the command line or in a desktop terminal, enter `ifconfig` and look for the `ppp0` entry — it should have a valid IP address listed under `inet`:  
    
    ![](https://twilio-cms-prod.s3.amazonaws.com/images/2020-11-09-131802_1920x1080_scrot.original.png)
    
    ![](https://twilio-cms-prod.s3.amazonaws.com/images/2020-11-09-131802_1920x1080_scrot.original.png)
    

Well done! You now have a Raspberry Pi computer that’s connected to the Internet via Twilio Super SIM. You can now start experimenting with cellular Internet connectivity, or begin developing your own IoT application proof-of-concept.

[Next steps](#next-steps)
-------------------------

Your Raspberry Pi and Sixfab Cellular IoT Hat are now able to access the cellular network. Over to you: what are you going to build? We can’t wait to find out.

In the meantime, here are some suggestions for things to try:

*   Write some code to get data from a cloud service API via cellular. Here’s a good selection of [public APIs](https://github.com/public-apis/public-apis).
*   Use the [Console](https://www.twilio.com/console/iot/supersim/usage/data) or [Super SIM API](https://www.twilio.com/docs/iot/supersim/api/usage-record-resource) to monitor your Super SIM’s data usage.
*   Check out our guide Introduction to [AT commands](https://www.twilio.com/docs/iot/supersim/introduction-at-commands) and try sending to your modem some of the more useful commands it lists.

#### [Appendix: downgrading the Pi kernel](#appendix-downgrading-the-pi-kernel)

Versions of Raspberry Pi OS’ Linux kernel above 5.4.65 have known problems connecting to the Cellular IoT Hat’s BG96 modem. To remedy this, you need to downgrade the kernel to version 5.4.65. You may need to do this after updating the Pi’s on-board software using `sudo apt update` and then `sudo apt upgrade`.

Here’s what to do. Run the following three commands at the command line or in a desktop terminal:

*   `sudo apt update`
*   `sudo rpi-update a995f0c9a9b3e5dbd2a41f69f5c4c82cdf33c7ec`
*   `sudo reboot`

You’ll now be able to access the modem and its Internet connection. You can now [continue with the setup process](#3-attach-to-a-cellular-network).

Rate this page:

#### Need some help?

We all do sometimes; code is hard. Get help now from our [support team](https://support.twilio.com/hc/en-us), or lean on the wisdom of the crowd by visiting Twilio's [Stack Overflow Collective](https://stackoverflow.com/collectives/twilio) or browsing the [Twilio tag](https://stackoverflow.com/questions/tagged/twilio) on Stack Overflow.

*   [Terms of Service](https://www.twilio.com/legal/tos)
*   [Privacy Policy](https://www.twilio.com/legal/privacy)
*   Copyright © 2022 Twilio Inc.