<?php
// Open SQLite database
$db = new SQLite3('database.db');

// Query all records from 'files' table
$results = $db->query('SELECT * FROM files');

// Loop through the records and print them to the screen
while ($row = $results->fetchArray()) {
  $file_path = $row['file_path'];
  $url = $row['url'];
  $hashtags = json_decode($row['hashtags'], true);

  echo "File path: $file_path<br>";
  echo "URL: $url<br>";
  echo "Hashtags: " . implode(', ', $hashtags) . "<br><br>";
}

// Close the database connection
$db->close();

?>