<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

class FileDatabase {
  private $db;

  function __construct($filename) {
    $this->db = new SQLite3($filename);
    $this->createTable();
  }

  function __destruct() {
    $this->db->close();
  }

  private function createTable() {
    $this->db->exec('CREATE TABLE IF NOT EXISTS files (file_path TEXT PRIMARY KEY, urls TEXT, hashtags TEXT)');
  }


  function getRecord($file_path) {
    $stmt = $this->db->prepare('SELECT * FROM files WHERE file_path = :file_path');
    $stmt->bindValue(':file_path', $file_path, SQLITE3_TEXT);
    $result = $stmt->execute();
    $row = $result->fetchArray(SQLITE3_ASSOC);
    if ($row !== false) {
      $row['urls'] = json_decode($row['urls'], true);
      $row['hashtags'] = json_decode($row['hashtags'], true);
    }
    return $row;
  }

  function addUrl($file_path, $url) {
    $record = $this->getRecord($file_path);
    if ($record !== false) {
      $urls = $record['urls'];
      if (!in_array($url, $urls)) {
        $urls[] = $url;
        $urls_json = json_encode($urls);
        $stmt = $this->db->prepare('UPDATE files SET urls = :urls WHERE file_path = :file_path');
        $stmt->bindValue(':urls', $urls_json, SQLITE3_TEXT);
        $stmt->bindValue(':file_path', $file_path, SQLITE3_TEXT);
        $stmt->execute();
      }
    } else {
      $urls = [$url];
      $urls_json = json_encode($urls);
      $hashtags_json = json_encode([]);
      $stmt = $this->db->prepare('INSERT INTO files (file_path, urls, hashtags) VALUES (:file_path, :urls, :hashtags)');
      $stmt->bindValue(':file_path', $file_path, SQLITE3_TEXT);
      $stmt->bindValue(':urls', $urls_json, SQLITE3_TEXT);
      $stmt->bindValue(':hashtags', $hashtags_json, SQLITE3_TEXT);
      $stmt->execute();
    }
  }

  function addHashtag($file_path, $hashtag) {
    $record = $this->getRecord($file_path);
    if ($record !== false) {
      $hashtags = $record['hashtags'];
      if (!in_array($hashtag, $hashtags)) {
        $hashtags[] = $hashtag;
        $hashtags_json = json_encode($hashtags);
        $stmt = $this->db->prepare('UPDATE files SET hashtags = :hashtags WHERE file_path = :file_path');
        $stmt->bindValue(':hashtags', $hashtags_json, SQLITE3_TEXT);
        $stmt->bindValue(':file_path', $file_path, SQLITE3_TEXT);
        $stmt->execute();
      }
    } else {
      $hashtags = [$hashtag];
      $hashtags_json = json_encode($hashtags);
      $urls_json = json_encode([]);
      $stmt = $this->db->prepare('INSERT INTO files (file_path, urls, hashtags) VALUES (:file_path, :urls, :hashtags)');
      $stmt->bindValue(':file_path', $file_path, SQLITE3_TEXT);
      $stmt->bindValue(':urls', $urls_json, SQLITE3_TEXT);
      $stmt->bindValue(':hashtags', $hashtags_json, SQLITE3_TEXT);
      $stmt->execute();
    }
  }

function removeHashtag($file_path, $hashtag) {
  $db = new SQLite3('database.db');

  // Get the current hashtags for the file path
  $stmt = $db->prepare('SELECT hashtags FROM files WHERE file_path = :file_path');
  $stmt->bindValue(':file_path', $file_path, SQLITE3_TEXT);
  $result = $stmt->execute();
  $row = $result->fetchArray(SQLITE3_ASSOC);
  $hashtags = $row['hashtags'];
  $result->finalize();
  $stmt->close();

  // Remove the hashtag from the list
  $hashtags_arr = json_decode($hashtags);
  if (($key = array_search($hashtag, $hashtags_arr)) !== false) {
    unset($hashtags_arr[$key]);
    $hashtags_arr = array_values($hashtags_arr);

    // Update the record in the database
    $hashtags_json = json_encode($hashtags_arr);
    $stmt = $db->prepare('UPDATE files SET hashtags = :hashtags WHERE file_path = :file_path');
    $stmt->bindValue(':hashtags', $hashtags_json, SQLITE3_TEXT);
    $stmt->bindValue(':file_path', $file_path, SQLITE3_TEXT);
    $stmt->execute();
    $stmt->close();
  }

  $db->close();
}

function removeUrl($file_path, $url) {
  $db = new SQLite3('database.db');

  // Get the current URLs for the file path
  $stmt = $db->prepare('SELECT urls FROM files WHERE file_path = :file_path');
  $stmt->bindValue(':file_path', $file_path, SQLITE3_TEXT);
  $result = $stmt->execute();
  $row = $result->fetchArray(SQLITE3_ASSOC);
  $urls = $row['urls'];
  $result->finalize();
  $stmt->close();

  // Remove the URL from the list
  $urls_arr = json_decode($urls);
  if (($key = array_search($url, $urls_arr)) !== false) {
    unset($urls_arr[$key]);
    $urls_arr = array_values($urls_arr);

    // Update the record in the database
    $urls_json = json_encode($urls_arr);
    $stmt = $db->prepare('UPDATE files SET urls = :urls WHERE file_path = :file_path');
    $stmt->bindValue(':urls', $urls_json, SQLITE3_TEXT);
    $stmt->bindValue(':file_path', $file_path, SQLITE3_TEXT);
    $stmt->execute();
    $stmt->close();
  }

  $db->close();
}

  
}

?>