<?php

function query_segment($string, $command='OR') {
    if (trim($string) === '') {
        return '';
    }

    while (strpos($string, '  ') !== false) {
        $string = rtrim($string, ' ');
    }

    if (strpos($string, '"') !== false) {
        $_string = array();
        $segments = explode('"', $string);
        foreach ($segments as $i => $sg) {
            $ii = $i + 1;
            if ($ii % 2 == 0) {
                $x = '"' . $sg . '"';
                $ix = strpos($string, $x);
                $string = substr_replace($string, str_replace(' ', '_', $sg), $ix, strlen($x));
            }
        }

        $string = str_replace('"', '', $string);
    }

    if (strpos($string, "'") !== false) {
        $_string = array();
        $segments = explode("'", $string);
        foreach ($segments as $i => $sg) {
            $ii = $i + 1;
            if ($ii % 2 == 0) {
                $x = "'" . $sg . "'";
                $ix = strpos($string, $x);
                $string = substr_replace($string, str_replace(' ', '_', $sg), $ix, strlen($x));
            }
        }

        $string = str_replace("'", '', $string);
    }

    $xx = array();
    $words = explode(' ', $string);
    foreach ($words as $x) {
        $xx[] = ' content LIKE "%' . str_replace('_', ' ', $x) . '%" ';
    }

    $cmd = ' ' . strtoupper($command) . ' ';
    return implode($cmd, $xx);
}

function builder($ANDs='', $NOTs='', $ORs=array()) {
    $q='';
    $ANDs=trim($ANDs);
    $NOTs=trim($NOTs);
    $ORx=array();
    foreach ($ORs as $x) {
        $x=trim($x);
        if ($x) {
            $ORx[] = $x;
        }
    }
    $ORs=$ORx;
    if ($ANDs) {
        $a=query_segment($ANDs,'AND');
        $q.=$a;
    }
    if ($ORs) {
        if ($q) {
            $q.=' AND ';
        }
        foreach ($ORs as $i=>$ORx) {
            $o=query_segment($ORx,'OR');
            if ($i) {
                $q.=' AND ('.$o.')';
            } else {
                $q.=' ('.$o.')';
            }
        }
    }
    if ($NOTs) {
        $n=query_segment($NOTs,'AND NOT');
        if ($q) {
            $q='('.$q.' AND NOT '.$n.')';
        } else {
            $q='( NOT '.$n.')';
        }
    }

    $sql = 'SELECT * FROM documents WHERE ' . $q;
    return $sql;
}

function basenameWin($path) {
  $path_parts = explode('\\', $path);
  $filename = end($path_parts);
  return $filename;
}


$db = new PDO('sqlite:../fi/documents.db');

// Prepare the query
$stmt = $db->prepare( builder($_POST['ANDs'], $_POST['NOTs'], json_decode($_POST['ORs'])).'  ORDER BY me Desc' );

// Execute the query
$stmt->execute();

// Generate the result links


echo '<ol>';
while ($row = $stmt->fetch()) {
    $path=$row['path'];
    $file=basenameWin($path);
    $ext=pathinfo($file, PATHINFO_EXTENSION);
    $link = '<li><a class="search_item" onclick="efm.app.document(\''.md5($path).'.'.$ext.'\',\''.$file.'\')"><span class="file_date">'.substr($row['datemodified'], 2, 5).'</span> <span class="the_file">'.$file.'</span></a></li>'."\n";
    echo $link;
}
echo '</ol>';

// Close the database connection
$db = null;
?>
