<?php
// Define a class for sending emails with mail merge and multiple attachments
class MailMerge {
    private $imap_server;
    private $imap_username;
    private $imap_password;
    private $smtp_server;
    private $smtp_port;
    private $smtp_username;
    private $smtp_password;

    public function __construct($imap_server, $imap_username, $imap_password, $smtp_server, $smtp_port, $smtp_username, $smtp_password) {
        $this->imap_server = $imap_server;
        $this->imap_username = $imap_username;
        $this->imap_password = $imap_password;
        $this->smtp_server = $smtp_server;
        $this->smtp_port = $smtp_port;
        $this->smtp_username = $smtp_username;
        $this->smtp_password = $smtp_password;
    }

    public function sendMail($to, $subject, $message, $attachments = array()) {
        // Connect to the IMAP server
        $inbox = imap_open($this->imap_server, $this->imap_username, $this->imap_password) or die('Cannot connect to server: ' . imap_last_error());

        // Compose the email message
        $headers = array(
            'From: ' . $this->smtp_username,
            'Reply-To: ' . $this->smtp_username,
            'X-Mailer: PHP/' . phpversion(),
            'Content-type: multipart/mixed; boundary="boundary"'
        );
        $message = "--boundary\r\n" .
                   "Content-Type: text/html; charset=utf-8\r\n" .
                   "Content-Transfer-Encoding: 7bit\r\n\r\n" .
                   wordwrap($message, 70) . "\r\n";

        // Attach files to the email
        foreach ($attachments as $attachment) {
            $file = $attachment['file'];
            $filename = $attachment['name'];
            $filetype = $attachment['type'];

            $data = chunk_split(base64_encode(file_get_contents($file)));
            $message .= "--boundary\r\n" .
                        "Content-Type: $filetype; name=\"$filename\"\r\n" .
                        "Content-Transfer-Encoding: base64\r\n" .
                        "Content-Disposition: attachment; filename=\"$filename\"\r\n\r\n" .
                        "$data\r\n";
        }
        $message .= "--boundary--";

        // Connect to the SMTP server
        $smtp = stream_socket_client($this->smtp_server . ':' . $this->smtp_port, $errno, $errstr, 30);

        if (!$smtp) {
            die('Failed to connect to SMTP server: ' . $errstr);
        }

        // Authenticate with the SMTP server
        fputs($smtp, "EHLO example.com\r\n");
        fputs($smtp, "AUTH LOGIN\r\n");
        fputs($smtp, base64_encode($this->smtp_username) . "\r\n");
        fputs($smtp, base64_encode($this->smtp_password) . "\r\n");

        // Send the email to multiple recipients
        foreach ($to as $recipient) {
            // Replace merge fields in the email message
            foreach ($recipient as $key => $value) {
                $message = str_replace("[$key]", $value, $message);
            }

            // Send the email to the recipient
		    fputs($smtp, "MAIL FROM: <$this->smtp_username>\r\n");
		    fputs($smtp, "RCPT TO: <$recipient[email]>\r\n");
		    fputs($smtp, "DATA\r\n");
		    fputs($smtp, "Subject: $subject\r\n");
		    fputs($smtp, implode("\r\n", $headers) . "\r\n");
		    fputs($smtp, "\r\n");
		    fputs($smtp, "$message\r\n");
		    fputs($smtp, ".\r\n");

            // Save the sent email in the sent folder
            $body = "To: $recipient[email]\r\nSubject: $subject\r\n\r\n$message";
            $result = imap_append($inbox, '{' . $this->imap_server . '/imap/ssl}[Gmail]/Sent Mail', $body);

            if (!$result) {
                die('Failed to save email in sent folder: ' . imap_last_error());
            }
        }

        // Close the SMTP connection
        fputs($smtp, "QUIT\r\n");
        fclose($smtp);

        // Close the IMAP connection
        imap_close($inbox);
    }
}
?>