<?php
include_once 'fn.php';

// Check if a project ID is set
if (isset($_GET['project_id'])) {
  $project_id = $_GET['project_id'];
  
  // Get the project information from the database
  $project = getProject($project_id);
  
  // Check if the project was found
  if ($project) {
    
    // Check if the form was submitted to update the project
    if (isset($_POST['update_project'])) {
      $description = $_POST['description'];
      $files = $_POST['files'];
      $urls = $_POST['urls'];
      $hashtags = $_POST['hashtags'];
      
      // Update the project information in the database
      updateProject($project_id, $description, $files, $urls, $hashtags);
      
      // Get the updated project information
      $project = getProject($project_id);
    }
    
    // Output the project information in a form for editing
    echo '<form method="post">';
    echo '<input type="hidden" name="project_id" value="' . $project_id . '">';
    echo '<label>Description:</label><br>';
    echo '<textarea name="description">' . $project['description'] . '</textarea><br><br>';
    echo '<label>Files:</label><br>';
    echo '<input type="text" name="files" value="' . $project['files'] . '"><br><br>';
    echo '<label>URLs:</label><br>';
    echo '<input type="text" name="urls" value="' . $project['urls'] . '"><br><br>';
    echo '<label>Hashtags:</label><br>';
    echo '<input type="text" name="hashtags" value="' . $project['hashtags'] . '"><br><br>';
    echo '<input type="submit" name="update_project" value="Update Project">';
    echo '</form>';
    
  } else {
    echo 'Project not found.';
  }
} else {
  echo 'Project ID not set.';
}
?>
