#!/usr/bin/python3
#!/usr/bin/env python
import contextlib as __stickytape_contextlib

@__stickytape_contextlib.contextmanager
def __stickytape_temporary_dir():
    import tempfile
    import shutil
    dir_path = tempfile.mkdtemp()
    try:
        yield dir_path
    finally:
        shutil.rmtree(dir_path)

with __stickytape_temporary_dir() as __stickytape_working_dir:
    def __stickytape_write_module(path, contents):
        import os, os.path

        def make_package(path):
            parts = path.split("/")
            partial_path = __stickytape_working_dir
            for part in parts:
                partial_path = os.path.join(partial_path, part)
                if not os.path.exists(partial_path):
                    os.mkdir(partial_path)
                    with open(os.path.join(partial_path, "__init__.py"), "wb") as f:
                        f.write(b"\n")

        make_package(os.path.dirname(path))

        full_path = os.path.join(__stickytape_working_dir, path)
        with open(full_path, "wb") as module_file:
            module_file.write(contents)

    import sys as __stickytape_sys
    __stickytape_sys.path.insert(0, __stickytape_working_dir)

    __stickytape_write_module('_rightThumb/__init__.py', b'\n\n# ## {R2D2919B742E} ##\n# ###########################################################################\n# What if magic existed?\n# What if a place existed where your every thought and dream come to life.\n# There is only one catch: it has to be written down.\n# Such a place exists, it is called programming.\n#    - Scott Taylor Reph, RightThumb.com\n# ###########################################################################\n# ## {C3P0D40fAe8B} ##\n\n\n\n')
    __stickytape_write_module('_rightThumb/_construct/__init__.py', b'#!/usr/bin/python3\n\n# ## {R2D2919B742E} ##\n# ###########################################################################\n# What if magic existed?\n# What if a place existed where your every thought and dream come to life.\n# There is only one catch: it has to be written down.\n# Such a place exists, it is called programming.\n#    - Scott Taylor Reph, RightThumb.com\n# ###########################################################################\n# ## {C3P0D40fAe8B} ##\n\nimport time,signal,sys,platform\ntz = str(time.strftime("%z")).replace(\':\',\'\')\nsignal.signal(signal.SIGINT, lambda x, y: sys.exit(0))\n\ntry:\n    importlib\nexcept Exception as e:\n    importlib = None\n\nautoCreationConfiguration = {\n                            \'backup\': True,\n                            \'logs\': True,\n                            \'folders\': True,\n                            \'created\': { \'_vars\': 0 },\n}\n\nsettings_table = {\n                    \'receipt-log\': True,\n                    \'receipt-file\': True,\n}\n\nclass dot:\n    def __init__( self ):\n        pass\nfn=dot()\n\ndef settings( subjects, d=None, val=\'71e9-a678\' ):\n    results = []\n    for subject in subjects:\n        results.append(  setting( subject, val, d )  )\n    return results\n\ndef setting( subject, val=\'71e9-a678\', d=None, default=None ):\n    global settings_table\n\n    if not default is None:\n        d = default\n\n    if not val == \'71e9-a678\':\n        settings_table[subject] = val\n\n    if not subject in settings_table:\n        return d\n    \n    return settings_table[subject]\n\n\nreleaseAcquiredData = True\n\ntable_b_print = False\n\nswitch_raw = []\n\n\nthisOS = platform.system()\ntheOS = thisOS\nOS = theOS\nwindowsSlash = chr(92)\nunixSlash = chr(47)\n\nif thisOS == \'Windows\':\n    slash = windowsSlash\n    isWin  = True\nelse:\n    slash = unixSlash\n    isWin  = False\n\nclass dot:\n    def __init__( self ):\n        pass\n\nv = dot()\n\nLOOP = {}\n\ndef pathList( *paths ):\n    # os = imp(\'os\')\n    result = os.sep.join(paths)\n    result = result.replace( \'/\', os.sep )\n    result = result.replace( \'\\\\\', os.sep )\n    result = result.replace( os.sep+os.sep, os.sep )\n    result = result.replace( os.sep+os.sep, os.sep )\n    result = result.replace( \'tech\'+os.sep+\'tech\', \'tech\' )\n    return result\n\ndef p( *text, w=\'\' ):\n    texXxt = []\n    for x in text:\n        texXxt.append(str(x))\n    txt = \' \'.join( texXxt )\n    \n    if w:\n        # os = imp(\'os\')\n        if os.path.isfile(w):\n            file1 = open( w , \'a\' )\n            file1.write( txt+\'\\n\' )\n            file1.close()\n        else:\n            file1 = open( w , \'w\' )\n            file1.write( txt+\'\\n\' )\n            file1.close()\n    print(txt)\n\n\n\ndef xit():\n    sys.exit()\n\nspecifications = {}\ndid_table = {}\ndef uuid():\n    UUID = imp(\'uuid\')\n    return str(UUID.uuid4())\n\n\n\ndef dots(path):\n    def _dots_(pth):\n        try: exec(pth); return True;\n        except Exception as e: return False;\n    rts=path.split(\'.\'); exec(\'global \'+rts[0]);\n    if _dots_(path): return eval(rts[0])\n    pre=[]; thp=[];\n    for i,seg in enumerate(rts):\n        pre=thp.copy(); thp.append(seg); npre=\'.\'.join(pre); npath=\'.\'.join(thp)\n        if i == len(rts)-1:\n            exec(\'from 1 import 2\'.replace(\'1\',npre).replace(\'2\',rts[-1]))\n            f=\'3=2\'.replace(\'1\',npre).replace(\'2\',rts[-1]).replace(\'3\',path)\n        else: f=\'1=dot()\'.replace(\'1\',npath);\n\n        if not _dots_(npath):\n            exec(f)\n            if i == len(rts)-1: return eval(rts[0]);\n\n\n\nimp_table = {}\ndef imp( subject, imp_table_testing=False ):\n    # print(subject); sys.exit();\n    if \'.\' in subject and not \'_rightThumb\' in subject: return dots(subject);\n    global imp_table\n    global importlib\n    if importlib is None:\n        import importlib\n        if imp_table_testing:\n            print(\'\\n\\n\\t\\timport importlib\\n\\n\')\n\n    if not subject in imp_table:\n        try:\n            imp_table_tmp\n        except Exception as e:\n            pass\n        else:\n            del imp_table_tmp\n\n\n\n        try:\n            imp_table[subject] = importlib.import_module(subject)\n            if imp_table_testing:\n                print( \'imp.DID\' )\n            return imp_table[subject]\n        except Exception as e:\n            if imp_table_testing:\n                print( \'imp.NO\' )\n            return None\n    if imp_table_testing:\n        print( \'imp.YES\' )\n    return imp_table[subject]\n\n\n\non_exit_subjects = {}\ndef onExit(script,subject=None):\n    global on_exit_subjects\n    if subject is None:\n        subject = uuid()\n    on_exit_subjects[subject] = script\n\ndef isExit():\n    global on_exit_subjects\n    for subject in on_exit_subjects:\n        on_exit_subjects[subject]()\n\n\ndef path( p, ab=True, pop=False, file=False, slash=None, folder=None, fi=None, fo=None ):\n    if not fo is None: pop=True;\n    if not folder is None: pop=True;\n    if not fi is None: file=True;\n\n    # os = vc.FIG.imp(\'os\')\n    # os = imp(\'os\')\n    if slash is None:\n        slash = os.sep\n    if not p:\n        return p.replace(os.sep+os.sep,os.sep)\n    # print(p)\n    p = p.replace( chr(92), slash )\n    p = p.replace( chr(47), slash )\n    while slash+slash in p:\n        p = p.replace(slash+slash,slash)\n    if ab:\n        try:\n            p = os.path.abspath(p)\n        except Exception as e:\n            pass\n    try:\n        p = os.path._getfinalpathname(p).lstrip(r\'\\?\')\n    except Exception as e:\n        pass\n    if type(p) == str and p[1] == \':\':\n        p = p[0].upper() + p[1:]\n    if type(p) == str and ( pop or file ):\n\n        if type(pop) == int:\n            i=0\n            while not i == pop:\n                i+=1\n                p = path( p, pop=True, slash=slash )\n                # print(p)\n            if file:\n                p = path( p, file=True, slash=slash )\n            return p.replace(os.sep+os.sep,os.sep)\n        parts = p.split(slash)\n        parts.reverse()\n        f = parts.pop(0)\n        parts.reverse()\n        p = str(slash).join(parts)\n        if file:\n            p = f\n    return p.replace(os.sep+os.sep,os.sep)\n\ndef file( p ):\n    # os = imp(\'os\')\n    p = p.replace( chr(92), os.sep )\n    p = p.replace( chr(47), os.sep )\n    if not os.sep in p:\n        return p\n    parts = p.split(os.sep)\n    parts.reverse()\n    f = parts.pop(0)\n    return f\n\n\ndef getTable( file ):\n    # os = imp(\'os\')\n    json = imp(\'simplejson\')\n\n    if os.path.isfile(file):\n        with open(file,\'r\', encoding="latin-1") as json_file:\n            json_data = json.load(json_file)\n    else:\n        json_data = data_default(file=file,default=[]).default()\n    return json_data\n\ndef saveTable( data, file, sk=False ):\n    json = imp(\'simplejson\')\n    dataDump = json.dumps(data, indent=4, sort_keys=sk)\n\n    f = open(file,\'w\')\n    f.write(str(dataDump))\n    f.close()\n\n\npre_error = False\nclass Table_Aggregates:\n    def __init__( self ):\n        self.triggers = {}\n    def trigger( self, label, script ):\n        self.triggers[label] = script\n    def run( self, label, data ):\n        return self.triggers[label](data)\ntable_aggregates = Table_Aggregates()\n\n\npayloadCache = None\nvarFoldersCheck = False\nmyFileLocations_SKIP_VALIDATION = False\n\n\n\n\n\n"""\n__.autoCreationConfiguration[\'backup\']\n__.autoCreationConfiguration[\'logs\']\n__.autoCreationConfiguration[\'folders\']\n"""\n\n# import importlib\ntry:\n    startTime\nexcept Exception as e:\n    startTime = time.time()\n    \ntrigger_isPipe = False\nisRequired_Pipe = False\nisRequired_Pipe_or_File = False\nisRequired_or_List = None\nisRequired_index = {}\nswitchList = []\nappRegPipe = None\ncls_process_switches_help = False\n\nstoryboard = []\n# __.sbd( fn=sys._getframe().f_code.co_name, d=\'\' )\ndef sbd( location=1, line=0, fn=\'\', d=\'\' ):\n    # add to auto documentation\n    global storyboard\n    global switchList\n    function = fn\n    activeSwitches = \'\'\n    inactiveSwitches = \'\'\n    documentation = n\n\n    storyboard.append({ \'timestamp\': time.time(), \'function\': function, \'active\': activeSwitches, \'inactive\': inactiveSwitches })\n\n\ndef triggerTest( data ):\n    return \'test\'\n\ndef clearFocus( name, file ):\n    global slash\n    f = file.split(slash)\n    if name == \'__main__\':\n        x = \'__\' + f[len(f)-1].replace(\'.py\',\'\') + \'__\'\n    else:\n        x = f[len(f)-1].replace(\'.py\',\'\')\n    return x\n\ndef thisApp( file ):\n    global slash\n    f = file.split(slash)\n    x = f[len(f)-1].replace(\'.py\',\'\')\n    return x\n\n\n\n\n\n# delimReg = \'_\'\ndelimReg = \'_-_\'\n\nappReg = \'\'\n\nregisteredApps = []\nregisteredAppsAll = []\n\nthreadQueue = {}\n\ndef constructRegistration( file, dba ):\n    global registeredAppsAll\n    shouldAdd = True\n    for ra in registeredAppsAll:\n        if ra[\'dba\'] == dba:\n            shouldAdd = False\n    if shouldAdd:\n        registeredAppsAll.append({ \'file\': file, \'dba\': dba })\n\ndef constructApps():\n    global registeredAppsAll\n    for appreg in registeredAppsAll:\n        print(appreg)\n\ndef appName( appReg, parentApp=\'\', childApp=\'\' ):\n    global delimReg\n    global isRequired_index\n    if not parentApp == \'\':\n        appReg = appReg + delimReg + parentApp\n    if not childApp == \'\':\n        appReg = parentApp + delimReg + appReg\n    isRequired_index[appReg] = []\n    return appReg\n\ndef structure():\n    result = []\n    global registeredAppsAll\n    for raa in registeredAppsAll:\n        if type(raa) == dict:\n            result.append(raa)\n            # print(raa)\n    return result\n\ntheDelim = \'|||\'\nappInfoScan = False # appInfo.py\n\n\n\n# import blank\n# blank.focus(focus())\n# _.load()\n# blank.registerSwitches()\n# _.switches.process()\n# _.switches.fieldSet(\'Input\',\'active\',True)\n# _.switches.fieldSet(\'Input\',\'value\',\'one\')\n\n# _.appInfo[blank.focus(focus())] = _.appInfo[blank.focus()]\n# _.appData[blank.focus(focus())] = _.appData[blank.focus()]\n# __.constructRegistration(_.appInfo[blank.focus(focus())][\'file\'],blank.focus(focus()))\n\n\nclass data_default:\n    # __.data_default(file=theFile,default=[])\n    def __init__( self, file, default ):\n        self.dics = \'index,indexes,dex,ls,hash,hashes,tables,logs,lists,indices,meta,setting,settings,dic,s,fig,conf,cnf\'\n        self.lists = \'table,cache,log,list,json,config\'\n        self.file = file\n        self.default_result = default\n    def default( self ):\n\n        for x in self.dics.split(\',\'):\n            if self.file.lower().endswith( \'.\'+x+\'.json\' ):\n                return {}\n        for x in self.lists.split(\',\'):\n            if self.file.lower().endswith( \'.\'+x+\'.json\' ):\n                return []\n\n        for x in self.dics.split(\',\'):\n            if self.file.lower().endswith( \'.\'+x ):\n                return {}\n        for x in self.lists.split(\',\'):\n            if self.file.lower().endswith( \'.\'+x ):\n                return []\n        return self.default_result\n# return __.data_default(file=theFile,default=[]).default()\n\n\nclass file_headers:\n    # __.data_default(file=theFile,default=[])\n    def __init__( self, path, default=\'\' ):\n        self.watermark = \'\'\'\n## {R2D2919B742E} ##\n###########################################################################\nWhat if magic existed?\nWhat if a place existed where your every thought and dream come to life.\nThere is only one catch: it has to be written down.\nSuch a place exists, it is called programming.\n   - Scott Taylor Reph, RightThumb.com\n###########################################################################\n## {C3P0D40fAe8B} ##\n\n\'\'\'.replace(\'\\r\',\'\')\n        self.path = path\n        self.headers = {\n                            \'functions.php\':  {\'url\':\'https://apps.eyeformeta.com/templates/html/functions.php.txt\'},\n                            \'_functions.php\':  {\'url\':\'https://apps.eyeformeta.com/templates/html/functions.php.txt\'},\n                            \'_fn.php\':  {\'url\':\'https://apps.eyeformeta.com/templates/html/functions.php.txt\'},\n                            \'fn.php\':  {\'url\':\'https://apps.eyeformeta.com/templates/html/functions.php.txt\'},\n                            \'.folder.meta\':  {\'url\':\'https://apps.eyeformeta.com/templates/html/.folder.meta.h\'},\n                            \'.folder.meta.b\':  {\'url\':\'https://apps.eyeformeta.com/templates/html/.folder.meta.b\'},\n                            \'.txt\': \'__________________________________________________________________________________\\n\',\n                            \'.sh\': \'#!/bin/bash\\n\',\n                            \'.py\': \'#!/usr/bin/python3\\n\',\n                            \'.bat\': \'@echo off\\n\',\n                            \'.html\': {\'url\':\'https://apps.eyeformeta.com/templates/html/0.htm\'},\n                            \'.htm\':  {\'url\':\'https://apps.eyeformeta.com/templates/html/1.htm\'},\n                            \'.php\':  {\'url\':\'https://apps.eyeformeta.com/templates/html/0.php.txt\'},\n        }\n        self.comment = {\n                            # \'.js\': \'//\',\n                            \'.sh\': \'#\',\n                            \'.py\': \'#\',\n                            \'.bat\': \'rem\',\n        }\n        # self.nospace=[\'.sh\']\n        self.nospace=[]\n        self.default_result = default\n    def add_watermark(self,code):\n        for ext in self.comment:\n            if self.path.endswith(ext):\n                for line in self.watermark.split(\'\\n\'):\n                    if len( line.replace(\' \',\'\').replace(\'\\t\',\'\') ):\n                        code+=self.comment[ext]+\' \'+line+\'\\n\'\n                    else:\n                        code+=\'\\n\'\n        for ext in self.nospace:\n            if self.path.endswith(ext):\n                import _rightThumb._string as _str\n                code = code.replace(\'\\r\',\'\')\n                code = _str.cleanBE(code,\' \')\n                code = _str.cleanBE(code,\'\\n\')\n                code = _str.replaceDuplicate(code,\'\\n\')\n                code = _str.cleanBE(code,\'\\n\')\n                code = _str.cleanBE(code,\' \')\n                code+=\'\\n\'\n\n        return code.replace(\'\\r\',\'\')\n\n\n    def default( self ):\n        for ext in self.headers:\n            if self.path.endswith(ext):\n                if type(self.headers[ext]) == dict:\n                    try:\n                        import requests\n                        page = requests.get(self.headers[ext][\'url\'])\n                        return page.content.decode("utf-8").replace(\'\\r\',\'\')\n                    except Exception as e:\n                        return self.add_watermark(self.default_result)\n                        \n                return self.add_watermark(self.headers[ext])\n        return self.add_watermark(self.default_result)\n# __.file_headers(path).default()\n\n\nsetting(\'myFileLocations-skip-validation\',False)\nsetting(\'require-pipe\',False)\nsetting(\'require-pipe||file\',False)\nsetting(\'pre-error\',False)\nsetting(\'switch-raw\',[])\nsetting(\'require-list\',[])\nsetting(\'receipt-log\',True)\nsetting(\'receipt-file\',True)\n\n#--> todo#> create app to scan to fix this situation below\n\n\n# import os\n\ndef url( URL, data={}, d=None, raw=False, r=None ):\n    import _rightThumb._string as _str\n    def _url_(data): return _str.do(\'.sh\',data);\n\n    if not r is None: raw=r;\n    if not d is None: data=d;\n    page=imp(\'requests.post\').post(URL, data = data)\n    if raw: return page;\n    result=page.content\n    for encodeing in \'ISO-8859-1 UTF-8 Windows-1251 Windows-1252 GB2312 Shift GBK EUC-KR ISO-8859-9 Windows-1254 EUC-JP Big5\'.lower().split(\' \'):\n        try: return _url_(str(result,encodeing));\n        except Exception as e: pass;\n    return _url_(str(result))\npage=url\n\nprint_=print\ndef getText( theFile, raw=False, clean=False,  e=0, c=0 ):\n    try: _str;\n    except Exception as e:\n        try: import _rightThumb._string as _str;\n        except Exception as e: pass;\n    if os.path.isfile(theFile): vv.opened_file_me[theFile] = os.path.getmtime( theFile );\n    # HD.chmod(theFile)\n    lines = None\n    if os.path.isfile(theFile):\n        try:\n            f = open(theFile, \'r\', encoding=\'utf-8\')\n            lines = f.readlines()\n            f.close()\n        except Exception as e:\n            try:\n                f = open(theFile, \'r\', encoding=\'latin-1\')\n                lines = f.readlines()\n                f.close()\n            except Exception as e:\n                f = open(theFile, \'r\')\n                lines = f.readlines()\n                f.close()\n    else:\n        if not e:\n            return None\n        print_(\'(getText) Error: No File\')\n        sys.exit()\n    if raw:\n        txt = \'\'.join( lines )\n        # txt = txt.replace( _v.slash+\'n\', \'\\n\' )\n\n        if clean:\n            txt = _str.replaceDuplicate( txt, \'\\n\' )\n            txt = _str.cleanBE( txt, \'\\n\' )\n        if clean == 2:\n            txt = txt.replace( \'\\t\', \' \' )\n            txt = _str.replaceDuplicate( txt, \' \' )\n            while \'\\n \\n\' in txt:\n                txt = txt.replace( \'\\n \\n\', \'\\n\' )\n            txt = _str.replaceDuplicate( txt, \'\\n\' )\n            txt = _str.cleanBE( txt, \'\\n\' )\n        return txt\n    elif c > 0:\n        if c > 1:\n            txt = \'\'.join( lines )\n            TXT = \'\'\n            txt = txt.replace( "\'\\"\\"\\"\'", \'\' )\n            if \'"""\' in txt:\n                for i,item in enumerate(txt.split(\'"""\')):\n                    if i % 2 == 0:\n                        TXT+=item\n            elif not \'"""\' in txt:\n                TXT = txt\n            while \'    \' in TXT:\n                TXT = TXT.replace( \'    \', \'\\t\' )\n            while \' (\' in TXT:\n                TXT = TXT.replace( \' (\', \'(\' )\n            while \' =\' in TXT:\n                TXT = TXT.replace( \' =\', \'=\' )\n            while \'= \' in TXT:\n                TXT = TXT.replace( \'= \', \'=\' )\n            while \'def  \' in TXT:\n                TXT = TXT.replace( \'def  \', \'def \' )\n            while \'class  \' in TXT:\n                TXT = TXT.replace( \'class  \', \'class \' )\n            lines = TXT.split(\'\\n\')\n\n        newLines = []\n        for i,row in enumerate(lines):\n            # row = row.replace(\'\\n\',\'\')\n            row = row.replace(\'\\r\',\'\')\n            \n            if not c > 1:\n                newLines.append(row)\n            else:\n                row = row.split(\'#\')[0]\n                test = row\n                # while test.startswith(\' \') or test.startswith(\'\\t\'):\n                #   test = _str.cleanBE( test, \' \' )\n                #   test = _str.cleanBE( test, \'\\t\' )\n                if not test.startswith(\'#\') and len(test):\n                    newLines.append(row)\n\n\n            \n\n\n        return newLines\n\n    elif clean:\n        # lines = _str.replaceDuplicate( lines, \'\\n\' )\n        # lines = _str.cleanBE( lines, \'\\n\' )\n        for i,row in enumerate(lines):\n            row = row.replace( \'\\n\', \'\' )\n            row = row.replace( \'\\r\', \'\' )\n            if type(clean) == int:\n                row = row.replace( \'\\t\', \' \' )\n                row = _str.replaceDuplicate( row, \' \' )\n                row = _str.cleanBE( row, \' \' )\n            if clean == 3:\n                row = \' \' + row + \' \'\n\n            # print_( row )\n            lines[i] = row\n        return lines\n    else:\n        return lines\n\nos = imp(\'os.system\')\nos = imp(\'os.sep\')\nos = imp(\'os.listdir\')\nos = imp(\'os.getcwd\')\nos = imp(\'os.path.abspath\')\nos = imp(\'os.path.isfile\')\nos = imp(\'os.name\')\nos = imp(\'os.stat\')\nsys = imp(\'sys.exit\')')
    __stickytape_write_module('_rightThumb/_string/__init__.py', b'import _rightThumb._construct as __\n# Column\n\n# ## {R2D2919B742E} ##\n# ###########################################################################\n# What if magic existed?\n# What if a place existed where your every thought and dream come to life.\n# There is only one catch: it has to be written down.\n# Such a place exists, it is called programming.\n#    - Scott Taylor Reph, RightThumb.com\n# ###########################################################################\n# ## {C3P0D40fAe8B} ##\n\n# Switch\n# import _rightThumb._string as _str\n\n\'\'\'\n\n        line = cleanFirst(line,\' \')\n        line = cleanLast(line,\' \')\n\nreplaceAll(string,rWhat,rWith)\ncleanAll(string,rWhat,rWith)\nremoveAll(string,rWhat)\n\n\n_str.replaceDuplicate(string,rWhat)\n_str.cleanBE(string,rWhat)\n_str.cleanEnd(string,\' \')\n_str.cleanFirst(string,\' \')\n\nrow = _str.replaceDuplicate( row, \' \' )\nrow = _str.cleanBE( row, \' \' )\n\n\n_str.cleanEnd(string,rWhat)\n\nrow = row.replace( \'\\n\', \'\' )\nrow = row.replace( \'\\r\', \'\' )\nrow = _str.replaceDuplicate( row, \' \' )\nrow = _str.replaceDuplicate( row, \'\\t\' )\nrow = _str.cleanBE( row, \' \' )\nrow = _str.cleanBE( row, \'\\t\' )\nif not row.startswith( \'#\' ):\n\n\n_str.stripNonAlphaNumaric(string)\n_str.charFix(string)\n_str.autoFloatInt(string)\n_str.removeNonNumber(string)\n_str.removeNonAlpha2(string)\n_str.replaceDuplicate(string,rWhat)\n_str.cleanBE(string,rWhat)\n\n\nkeys = \',\'.join(rec.keys())\nquestion_marks = \',\'.join(list(\'?\'*len(rec)))\nvalues = tuple(rec.values())\n\nif len(list( filter(lambda itemX: itemX[\'name\'] == field, theListName) )) == 0:\n\n_str.safeChar\n\nhttps://stackoverflow.com/questions/2049502/what-characters-are-allowed-in-an-email-address\n\n_str.hasAlpha( row )\n\'\'\'\n\nimport platform\nslash = 0\nif platform.system() == \'Windows\':\n    slash = chr(92)\nelse:\n    slash = chr(47)\n\nimport re\n\nupperChar = \'ABCDEFGHIJKLMNOPQRSTUVWXYZ\'\nlowerChar = \'abcdefghijklmnopqrstuvwxyz\'\nalphaChar = \'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\'\nprintable = \' 0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!"#$%&\\\'()*+,-./:;<=>?@[\\\\]^_`{|}~ \\t\\n\\r\\x0b\\x0c\'\nprintable2 = printable + \'\xf0\x9f\xa7\xbb\xf0\x9f\xa7\xaa\xf0\x9f\x92\x80\xf0\x9f\xa6\x86\xf0\x9f\xa6\x89\xf0\x9f\xa5\x93\xf0\x9f\xa6\x84\xf0\x9f\xa6\x80\xf0\x9f\x96\x95\xf0\x9f\x8d\xa3\xf0\x9f\x8d\xa4\xf0\x9f\x8d\xa5\xf0\x9f\x8d\xa1\xf0\x9f\xa5\x83\xf0\x9f\xa5\x9e\xf0\x9f\x90\x95\xf0\x9f\x91\xbe\xf0\x9f\x90\x89\xf0\x9f\x90\x93\xf0\x9f\x90\x8b\xf0\x9f\x90\x8c\xf0\x9f\x90\xa2\xf0\x9f\x91\xbd\xf0\x9f\x91\xbf\xf0\x9f\xa5\x91\xf0\x9f\x90\xa1\xf0\x9f\x90\x97\xf0\x9f\x92\x90\xf0\x9f\x8f\xb9\xf0\x9f\x8e\xa8\xf0\x9f\x90\x94\xf0\x9f\x90\x9b\xf0\x9f\x8e\xaf\xf0\x9f\x8c\xaf\xf0\x9f\x93\xb7\xf0\x9f\x9b\xb6\xf0\x9f\xa5\x95\xf0\x9f\x8d\x92\xf0\x9f\x8d\xb8\xf0\x9f\x8d\xb3\xf0\x9f\x90\xb2\xf0\x9f\x8e\xa3\xf0\x9f\x90\x9f\xf0\x9f\xa6\x85\xf0\x9f\x91\x80\xf0\x9f\x90\xb8\xf0\x9f\xa4\x9e\xf0\x9f\x92\xaa\xf0\x9f\x92\xbe\xf0\x9f\x91\xbb\xf0\x9f\x90\x8a\xf0\x9f\x8d\x94\xf0\x9f\x8c\xad\xf0\x9f\x8d\x80\xf0\x9f\x95\x93\xf0\x9f\xa6\x8a\xf0\x9f\x8d\x9f\xf0\x9f\xa5\x9d\xf0\x9f\x96\x95\xf0\x9f\x90\x92\xf0\x9f\xa5\x9e\xf0\x9f\x90\xbc\xf0\x9f\x93\x8e\xf0\x9f\x90\xa7\xf0\x9f\x92\xa9\xf0\x9f\x8d\x95\xf0\x9f\x8d\x8d\xf0\x9f\xa6\x8f\xf0\x9f\x8d\x97\xf0\x9f\x8c\x88\xf0\x9f\x90\xb3\xf0\x9f\xa6\x91\xf0\x9f\x9a\x80\xf0\x9f\x99\x88\xf0\x9f\x99\x8a\xf0\x9f\x99\x89\xf0\x9f\x8c\xae\xf0\x9f\xa5\x92\xf0\x9f\x90\x85\xf0\x9f\x90\xaf\xf0\x9f\x8d\x89\xf0\x9f\x9a\xbd\xf0\x9f\x8d\x85\xf0\x9f\x91\x85\xf0\x9f\x8e\xa9\xf0\x9f\x8d\xb7\'\nalphanumeric = \' 0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\'\nsafeChar = printable\nvisibleChar = \'0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!"#$%&\\\'()*+,-./:;<=>?@[\\\\]^_`{|}~\'\nnotFilenameSafe = \'/\\\\?%*:|"<>\'\n\n\ndef printClean(text):\n    global printable\n    text = str(text)\n    fix = []\n    for x in text:\n        if x in printable:\n            fix.append(x)\n    return \'\'.join(fix)\n\ndef minimalistClean( row ):\n    global printable\n    result = \'\'\n    for x in row:\n        if not x in printable:\n            result+=\' \'\n        else:\n            result+=x\n    result = replaceDuplicate( result, \' \' )\n    result = cleanBE( result, \' \' )\n    return result\n\n\n\n\ndef hasAlpha( row ):\n    row = str(row)\n    global alphaChar\n    for r in row:\n        for a in alphaChar:\n            if r == a:\n                return True\n    return False\n\ndef totalClean( row ):\n    row = row.replace( \'\\n\', \'\' )\n    row = row.replace( \'\\r\', \'\' )\n    row = replaceDuplicate( row, \' \' )\n    row = replaceDuplicate( row, \'\\t\' )\n    row = cleanBE( row, \' \' )\n    row = cleanBE( row, \'\\t\' )\n    return row\n\n\n\ndef filenameSafe( data ):\n    global printable\n    global notFilenameSafe\n\n    PERMITTED_CHARS = printable\n    data = str( data )\n\n    result = \'\'\n    for d in data:\n        if d in PERMITTED_CHARS and not d in notFilenameSafe:\n            result += d\n        else:\n            result += \' \'\n    result = replaceDuplicate( result, \' \' )\n    result = cleanBE( result, \' \' )\n    return result\n\n\n\ndef hasVisible( data ):\n    global visibleChar\n    for char in data:\n        if char in visibleChar:\n            return True\n    return False\n\ndef removeUnsave( data ):\n    global safeChar\n    result = \'\'\n    for char in data:\n        if char in safeChar:\n            result += char\n    return result\n\ndef spaceba( string, what ):\n    if what in string:\n        string = string.replace( \' \'+what, what )\n        string = string.replace( what+\' \', what )\n    return string\n\n\ndef makePrintable( string, replaceWith=\' \', appropriate=False ):\n    global safeChar\n    if type(appropriate) == bool:\n        appropriate = printable\n    result = \'\'\n\n    for char in string:\n        if char in appropriate:\n            result += char\n        else:\n            result += replaceWith\n    result = replaceDuplicate( result, replaceWith )\n    result = cleanBE( result, replaceWith )\n    return result\n\ndef namespace( app, data ):\n    string = \'0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_.\'\n    data = makePrintable( data, replaceWith=\' \', appropriate=string )\n    result = False\n    # _.pr( type( app ) )\n    for row in data.split(\' \'):\n        if row.startswith( str(app)+\'.\' ):\n            result = row\n    # try:\n    # except Exception as e:\n    #   return app, result\n\n    return result\n\n# import MySQLdb\n\n############################################### ###############################################\n\nLATIN_1_CHARS = (\n    ( \'\\xe2\\x80\\x99\', "\'" ),\n    ( \'\\xc3\\xa9\', \'e\' ),\n    ( \'\\xe2\\x80\\x90\', \'-\' ),\n    ( \'\\xe2\\x80\\x91\', \'-\' ),\n    ( \'\\xe2\\x80\\x92\', \'-\' ),\n    ( \'\\xe2\\x80\\x93\', \'-\' ),\n    ( \'\\xe2\\x80\\x94\', \'-\' ),\n    ( \'\\xe2\\x80\\x94\', \'-\' ),\n    ( \'\\xe2\\x80\\x98\', "\'" ),\n    ( \'\\xe2\\x80\\x9b\', "\'" ),\n    ( \'\\xe2\\x80\\x9c\', \'"\' ),\n    ( \'\\xe2\\x80\\x9c\', \'"\' ),\n    ( \'\\xe2\\x80\\x9d\', \'"\' ),\n    ( \'\\xe2\\x80\\x9e\', \'"\' ),\n    ( \'\\xe2\\x80\\x9f\', \'"\' ),\n    ( \'\\xe2\\x80\\xa6\', \'...\' ),\n    ( \'\\xe2\\x80\\xb2\', "\'" ),\n    ( \'\\xe2\\x80\\xb3\', "\'" ),\n    ( \'\\xe2\\x80\\xb4\', "\'" ),\n    ( \'\\xe2\\x80\\xb5\', "\'" ),\n    ( \'\\xe2\\x80\\xb6\', "\'" ),\n    ( \'\\xe2\\x80\\xb7\', "\'" ),\n    ( \'\\xe2\\x81\\xba\', "+" ),\n    ( \'\\xe2\\x81\\xbb\', "-" ),\n    ( \'\\xe2\\x81\\xbc\', "=" ),\n    ( \'\\xe2\\x81\\xbd\', "( " ),\n    ( \'\\xb3\', \'\' ),\n    ( \'\\xe2\\x81\\xbe\', ")" )\n)\n\ndef xChar( data ):\n    global slash\n    char = \'abcdefghijklmnopqrstuvwxyz0123456789\'\n\n    for x in char:\n        for y in char:\n            data = data.replace( slash+\'x\' + x + y, \' \' )\n    \n    data = replaceDuplicate( data, \' \' )\n    data = cleanBE( data, \' \' )\n\n    return data\n\n\ndef clean_latin1( data ):\n    global LATIN_1_CHARS\n    global slash\n    # data = str( data )\n    data = data.encode(\'latin1\', \'ignore\')\n    data = data.decode(\'latin1\')\n    # Source: https://gist.github.com/tushortz/9fbde5d023c0a0204333267840b592f9\n    # data = data.encode(\'utf-8\')\n    # try:\n    #   pass\n    #   # return data.encode(\'latin1\')\n    #   # return data.encode(\'utf-8\')\n    #   data = data.decode(\'iso-8859-1\')\n    # except UnicodeDecodeError:\n    #   pass\n    for _hex, _char in LATIN_1_CHARS:\n        data = data.replace( _hex, _char )\n    # return data.encode(\'utf8\')\n    # return data.encode(\'latin1\')\n    data = data.replace( \'Alien\\\\xb3\', \'Alien 3\' )\n    if slash+\'x\' in data:\n        data = xChar( data )\n    return data\n\ndef cleanChar( data ):\n    # data = str( data )\n    \n    # Source: https://stackoverflow.com/questions/6539881/python-converting-from-iso-8859-1-latin1-to-utf-8\n\n    # data = data.encode(\'ascii\', \'ignore\') \n    # data = data.decode(\'latin1\').encode(\'utf8\').rstrip()\n    # data = data.decode(\'utf8\').encode(\'latin1\', \'ignore\') \n    # data = str( data )\n    # data = str( data )\n    data = clean_latin1( data )\n    # data = data.encode(\'ascii\', \'ignore\')\n    data = data.encode(\'latin1\', \'ignore\')\n    # data = data.decode(\'latin1\').encode(\'utf8\')\n    # data = data.decode(\'utf8\').encode(\'latin1\', \'ignore\') \n    data = data.decode(\'latin1\')\n    # data = str( data )\n    return data\n\n############################################### ###############################################\n\ndef stripNonAlphaNumaric( data, also=\'\' ):\n    PERMITTED_CHARS = \'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789\' + also\n    data = str( data )\n\n    result = \'\'\n    for d in data:\n        if d in PERMITTED_CHARS:\n            result += d\n        else:\n            result += \' \'\n    result = replaceDuplicate( result, \' \' )\n    result = cleanBE( result, \' \' )\n    return result\n\n\ndef autoFloatInt( data ):\n    if isInt( data ):\n        return int( data )\n    if isFloat( data ):\n        return float( data )\n    return data\n\ndef isInt( data ):\n    data = str( data )\n    d = \'0123456789\'\n    result = True\n    for c in data:\n        if not c in d:\n            result = False\n    return result\n\ndef isFloat( data ):\n    data = str( data )\n    result = True\n    if isInt( data ):\n        result = False\n    else:\n        try:\n            float( data )\n        except Exception as e:\n            result = False\n\n    return result\n\ndef removeNonNumber( string ):\n    PERMITTED_CHARS = \'0123456789\'\n    string = str(string)\n\n    result = \'\'\n\n    for cha in string:\n        if cha in PERMITTED_CHARS:\n            result += cha\n    return result\n\ndef removeNonAlpha( string ):\n    PERMITTED_CHARS = \'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\'\n    string = str(string)\n\n    result = \'\'\n\n    for cha in string:\n        if cha in PERMITTED_CHARS:\n            result += cha\n    return result\n\ndef removeNonAlpha2( string ):\n    PERMITTED_CHARS = \'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ \'\n    string = str(string)\n\n    result = \'\'\n\n    for cha in string:\n        if cha in PERMITTED_CHARS:\n            result += cha\n    return result\n\ndef padZeros(string,count):\n    string = str(string)\n\n    diff = count - len(string)\n    pre = \'\'\n    for x in range(1,diff+1):\n        pre += \'0\'\n    result = pre + string\n    return result\n\n\ndef replaceAll(string,rWhat,rWith):\n    if not len(rWhat): return string;\n    if not rWhat in string:\n        return string\n    tmp = \'{C9DCAA81-3B8A-68E9-E4CF-A405E2199CB9}\'\n\n\n    done=False\n    string = str(string)\n    while done == False:\n        if string.count(str(rWhat)) > 0:\n            string = string.replace(str(rWhat),tmp)\n        else:\n            done=True\n\n\n    done=False\n    string = str(string)\n    while done == False:\n        if string.count(str(rWhat)) > 0:\n            string = string.replace(str(rWhat),tmp)\n        else:\n            done=True\n\n\n\n    done=False\n    while done == False:\n        if string.count(tmp) > 0:\n            string = string.replace(tmp,str(rWith))\n        else:\n            done=True\n\n    string = string.replace(tmp,str(rWith))\n    return string\n# def replaceAll(string,rWhat,rWith):\n#   if not rWhat == rWith:\n#       done=False\n#       while done == False:\n#           if string.count(rWhat) > 0:\n#               string = string.replace(rWhat,rWith)\n#           else:\n#               done=True\n#   return string\n\ndef removeAll(string,rWhat):\n    if not len(rWhat): return string;\n    if not rWhat in string:\n        return string\n    rWith = \'\'\n    return replaceAll(string,rWhat,rWith)\n\ndef replaceDuplicate(string,rWhat):\n    if not len(rWhat): return string;\n    if not rWhat in string:\n        return string\n    rWith = rWhat\n    rWhat = str(rWhat) + str(rWhat)\n    string = replaceAll(string,rWhat,rWith)\n    for x in range(10):\n        string = string.replace( rWhat, rWith )\n    return string\n\ndef cleanBE(string,rWhat):\n    if not len(rWhat): return string;\n    if not rWhat in string:\n        return string\n    string = cleanEnd(string,rWhat)\n    string = cleanFirst(string,rWhat)\n    return string\ndef cleanEnd(string,rWhat):\n    if not rWhat in string:\n        return string\n    string = str(string)\n    rWhat = str(rWhat)\n    # string = replaceDuplicate(string,rWhat)\n    string +=  \'*?*\'\n    string = string.replace(rWhat + \'*?*\', \'\')\n    string = string.replace(\'*?*\', \'\')\n    if string.endswith(rWhat):\n        string = cleanEnd(string,rWhat)\n\n    return string\n\ndef cleanEnd2(string,rWhat):\n    if not len(rWhat): return string;\n    if not rWhat in string:\n        return string\n    string = str(string)\n    rWhat = str(rWhat)\n    string = totalStrip3(string)\n    string = cleanSpecial(string)\n    string = replaceDuplicate(string,rWhat)\n    string +=  \'*?*\'\n    string = string.replace(rWhat + \'*?*\', \'\')\n    string = string.replace(\'*?*\', \'\')\n    return string\n\ndef cleanLast(string,rWhat):\n    if not len(rWhat): return string;\n    if not rWhat in string:\n        return string\n    return cleanEnd(string,rWhat)\n\ndef cleanFirst(string,rWhat):\n    if not len(rWhat): return string;\n    if not rWhat in string:\n        return string\n    string = str(string)\n    rWhat = str(rWhat)\n    # string = replaceDuplicate(string,rWhat)\n    string = \'*?*\' + str(string)\n    string = string.replace(\'*?*\' + rWhat, \'\')\n    string = string.replace(\'*?*\', \'\')\n    if string.startswith(rWhat):\n        string = cleanFirst(string,rWhat)\n    return string\n\ndef cleanAll(string,rWhat,rWith):\n    if not len(rWhat): return string;\n    if not rWhat in string:\n        return string\n    done=False\n    while done == False:\n        if string.count(rWhat) > 0:\n            string = string.replace(rWhat,rWith)\n        else:\n            done=True\n    return string\n\ndef cleanSpecial(line,special1=False):\n    global slash\n    line = str(line)\n    if not special1:\n        line = replaceAll(str(line),slash,\'--/--\')\n        try:\n            pass\n            line = line.encode(\'latin-1\')\n            line = replaceAll(line,slash+\'t\',\' \')\n            line = replaceAll(line,slash+\'xa0\',\' \')\n            line = replaceAll(line,slash+\'xe9\',"\'")\n            line = replaceDuplicate(line,\' \')\n            line = cleanFirst(line,\' \')\n            line = cleanLast(line,\' \')\n        except Exception as e:\n            try:\n                line = line.encode(\'utf-8\')\n                pass\n            except Exception as e:\n                pass\n    else:\n        line = replaceAll(line,\'\\u0092\',"\'")\n    try:\n        line = line.replace(\'\xe2\x80\xa6\',\'...\')\n    except Exception as e:\n        pass\n    i = 0\n    skip = False\n    string = \'\'\n    for char in str(line):\n        # _.pr(item)\n        char = str(char)\n        if char == slash:\n            i = 0\n            skip = True\n        if skip == True:\n            if i == 4:\n                i = 0\n                skip = False\n            else:\n                i += 1\n        if skip == False:\n            string += char\n        else:\n            string += \' \'\n\n    # line = string\n    if not special1:\n        line = replaceAll(str(line),\'--/--\',slash)\n        # line = replaceAll(str(line),\'_-_\',\',\')\n        line = replaceDuplicate(str(line),  \' \')\n        line = cleanEnd(str(line),\'"\')\n        line = cleanEnd(str(line),"\'")\n        line = cleanEnd(str(line),\' \')\n        line = cleanFirst(str(line),"b\'")\n        line = cleanFirst(str(line),\'b"\')\n        line = cleanFirst(str(line),\'.\')\n        # line = line.replace(\'  \',\' \')\n    return line\n\ndef cleanSpecial2(line,special1=False):\n    global slash\n    line = str(line)\n    def cleanup(line):\n        line = replaceAll(line,slash+\'t\',\' \')\n        line = replaceAll(line,slash+\'xc3\',\' \')\n        \n        line = replaceAll(line,slash+\'xb1\',\' \')\n        line = replaceAll(line,slash+\'xf3\',\' \')\n        line = replaceAll(line,slash+\'xf6\',\' \')\n        line = replaceAll(line,slash+\'xe4\',\' \')\n\n        line = replaceAll(line,slash+\'xa0\',\' \')\n        line = replaceAll(line,slash+\'xe9\',"\'")\n        line = replaceAll(line,slash+\'xe2\\\\x80\\\\x93\',\'-\')\n        line = replaceAll(line,slash+\'\\\\xe2\\\\\\\\x80\\\\\\\\x93\',\'-\')\n    if not special1:\n        line = replaceAll(str(line),slash,\'--/--\')\n        try:\n            pass\n            try:\n                line = cleanup(line)\n                line = line.decode(\'utf-8\',\'ignore\')\n            except Exception as e:\n                pass\n            try:\n                line = cleanup(line)\n                line = line.encode(\'utf-8\').decode(\'utf-8\')\n            except Exception as e:\n                pass\n            try:\n                line = cleanup(line)\n                line = line.encode(\'latin-1\')\n            except Exception as e:\n                pass\n            try:\n                line = cleanup(line)\n                line = line.encode(\'latin-1\').decode(\'latin-1\')\n            except Exception as e:\n                pass\n            try:\n                line = cleanup(line)\n            except Exception as e:\n                pass\n\n\n\n            line = replaceDuplicate(line,\' \')\n            line = cleanFirst(line,\' \')\n            line = cleanLast(line,\' \')\n        except Exception as e:\n            try:\n                line = line.encode(\'utf-8\')\n                pass\n            except Exception as e:\n                pass\n    else:\n        line = replaceAll(line,\'\\u0092\',"\'")\n    try:\n        line = line.replace(\'\xe2\x80\xa6\',\'...\')\n    except Exception as e:\n        pass\n    i = 0\n    skip = False\n    string = \'\'\n    for char in str(line):\n        # _.pr(item)\n        char = str(char)\n        if char == slash:\n            i = 0\n            skip = True\n        if skip == True:\n            if i == 4:\n                i = 0\n                skip = False\n            else:\n                i += 1\n        if skip == False:\n            string += char\n        else:\n            string += \' \'\n\n    # line = string\n    if not special1:\n        line = replaceAll(str(line),\'--/--\',slash)\n        # line = replaceAll(str(line),\'_-_\',\',\')\n        line = replaceDuplicate(str(line),  \' \')\n        line = cleanEnd(str(line),\'"\')\n        line = cleanEnd(str(line),"\'")\n        line = cleanEnd(str(line),\' \')\n        line = cleanFirst(str(line),"b\'")\n        line = cleanFirst(str(line),\'b"\')\n        line = cleanFirst(str(line),\'.\')\n        # line = line.replace(\'  \',\' \')\n    return line\n\ndef totalStrip(line):\n    PERMITTED_CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_.,-@:\'#\\""\n    section = \'\'\n    for word in line.split(\' \'):\n        section += \'\'.join(c for c in word if c in PERMITTED_CHARS)\n        section += \' \'\n    line = section + \']\'\n    line = line.replace(\' ]\',\'\')\n    line = line.replace(\']\',\'\')\n    return line\ndef alpha(line):\n    PERMITTED_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\'"\n    section = \'\'\n    for word in line.split(\' \'):\n        section += \'\'.join(c for c in word if c in PERMITTED_CHARS)\n        section += \' \'\n    line = section + \']\'\n    line = line.replace(\' ]\',\'\')\n    line = line.replace(\']\',\'\')\n    return line\ndef totalStrip1b(line,add=\'\'):\n    if add is None: add=\'\';\n    PERMITTED_CHARS = " 0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"+add\n    section = \'\'\n    for word in line.split(\' \'):\n        section += \'\'.join(c for c in word if c in PERMITTED_CHARS)\n        section += \' \'\n    line = section + \']\'\n    line = line.replace(\' ]\',\'\')\n    line = line.replace(\']\',\'\')\n    return line\ndef totalStrip2(line):\n    PERMITTED_CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-" \n    section = \'\'\n    for word in line.split(\' \'):\n        section += \'\'.join(c for c in word if c in PERMITTED_CHARS)\n        section += \' \'\n    line = section + \']\'\n    line = line.replace(\' ]\',\'\')\n    line = line.replace(\']\',\'\')\n    return line\ndef totalStrip2b(line):\n    PERMITTED_CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-_ " \n    section = \'\'\n    for word in line.split(\' \'):\n        section += \'\'.join(c for c in word if c in PERMITTED_CHARS)\n        section += \' \'\n    line = section + \']\'\n    line = line.replace(\' ]\',\'\')\n    line = line.replace(\']\',\'\')\n    return line\ndef totalStrip3(line):\n    PERMITTED_CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-," \n    section = \'\'\n    for word in line.split(\' \'):\n        section += \'\'.join(c for c in word if c in PERMITTED_CHARS)\n        section += \' \'\n    line = section + \']\'\n    line = line.replace(\' ]\',\'\')\n    line = line.replace(\']\',\'\')\n    return line\ndef totalStrip4(line):\n    PERMITTED_CHARS = "0123456789" \n    section = \'\'\n    for word in line.split(\' \'):\n        section += \'\'.join(c for c in word if c in PERMITTED_CHARS)\n        section += \' \'\n    line = section + \']\'\n    line = line.replace(\' ]\',\'\')\n    line = line.replace(\']\',\'\')\n    return line\ndef totalStrip5(line):\n    PERMITTED_CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_.,-@:\'#\\"()"\n    section = \'\'\n    for word in line.split(\' \'):\n        section += \'\'.join(c for c in word if c in PERMITTED_CHARS)\n        section += \' \'\n    line = section + \'\'\n    # line = section + \']\'\n    # line = line.replace(\' ]\',\'\')\n    # line = line.replace(\']\',\'\')\n    return line\ndef totalStrip6(line):\n    line = removeAll(line,\'\\n\')\n    line = removeAll(line,\'\\r\')\n    line = characterClean(line)\n    PERMITTED_CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_.,-@:\'#\\"()"\n    section = \'\'\n    for word in line.split(\' \'):\n        section += \'\'.join(c for c in word if c in PERMITTED_CHARS)\n        section += \' \'\n    line = section + \']\'\n    line = line.replace(\' ]\',\'\')\n    line = line.replace(\']\',\'\')\n    return line\ndef totalStrip9(line):\n    line = removeAll(line,\'\\n\')\n    line = removeAll(line,\'\\r\')\n    line = underscore(line)\n    # line = cleanupString(line)\n    # line = cleanSpecial2(line)\n    # line = characterClean(line)\n    PERMITTED_CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ."\n    section = \'\'\n    for cha in line:\n        if cha in PERMITTED_CHARS:\n            section += cha\n        else:\n            section += \' \'\n    line = section\n    line = cleanBE(line,\' \')\n    line = replaceDuplicate(line,\' \')\n    return line\ndef underscore(line):\n    # http://www.fileformat.info/\n    line = line.replace(\'\\u005F\',\' \')\n    line = line.replace(\'\\uFF3F\',\' \')\n    line = line.replace(\'\\u2017\',\' \')\n    line = line.replace(\'\\u203E\',\' \')\n    line = line.replace(\'\\u0332\',\' \')\n    line = line.replace(\'_\',\' \')\n    return line\n\ndef totalStrip7(line):\n    line = removeAll(line,\'\\n\')\n    line = removeAll(line,\'\\r\')\n    line = underscore(line)\n    # line = cleanupString(line)\n    # line = cleanSpecial2(line)\n    # line = characterClean(line)\n    PERMITTED_CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ."\n    section = \'\'\n    for word in line.split(\' \'):\n        section += \'\'.join(c for c in word if c in PERMITTED_CHARS)\n        section += \' \'\n    line = section\n    line = cleanBE(line,\' \')\n    line = replaceDuplicate(line,\' \')\n    return line\ndef onlyDigits(line):\n    line = removeAll(line,\'\\n\')\n    line = removeAll(line,\'\\r\')\n    line = characterClean(line)\n    PERMITTED_CHARS = "0123456789-"\n    section = \'\'\n    for word in line.split(\' \'):\n        section += \'\'.join(c for c in word if c in PERMITTED_CHARS)\n        section += \' \'\n    line = section + \']\'\n    line = line.replace(\' ]\',\'\')\n    line = line.replace(\']\',\'\')\n    return line\ndef onlyDigits2(line):\n    line = str( line )\n    line = line.replace( \'\xe2\x80\x93\', \'-\' )\n    PERMITTED_CHARS = \'0123456789-\'\n    result = \'\'\n    for char in line:\n        if char in PERMITTED_CHARS:\n            result += char\n    return result\ndef totalStrip8(line):\n    line = removeAll(line,\'\\n\')\n    line = removeAll(line,\'\\r\')\n    line = characterClean(line)\n    PERMITTED_CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_.,-@:\'#\\"()"\n    section = \'\'\n    for word in line.split(\' \'):\n        section += \'\'.join(c for c in word if c in PERMITTED_CHARS)\n        section += \' \'\n    line = section + \']\'\n    line = line.replace(\' ]\',\'\')\n    line = line.replace(\']\',\'\')\n    return line\ndef cleanupString0(string):\n    string = replaceAll(string,\'\\n\',\' \')\n    string = replaceDuplicate(string,\' \')\n    string = cleanLast(string,\' \')\n    string = cleanFirst(string,\' \')\n    string = cleanSpecial(string)\n    string = cleanFirst(string,\' \')\n    return string\ndef cleanupString(string,beforeAfter=True):\n    string = replaceAll(string,\'\\n\',\' \')\n    string = replaceAll(string,\'\\t\',\' \')\n    string = replaceDuplicate(string,\' \')\n    string = cleanLast(string,\' \')\n    string = cleanFirst(string,\' \')\n    string = cleanSpecial(string)\n    string = cleanFirst(string,\' \')\n    string = string.replace(slash+\'xe2\\\\x80\\\\x93\',\'-\')\n    string = string.replace(slash+\'\\\\xe2\\\\\\\\x80\\\\\\\\x93\',\'-\')\n    if beforeAfter:\n        string = string.split(\'(\')[0]\n    else:\n        string = string.split(\'(\')[1]\n    string = string.split(\'/\')[0]\n    return string\n\ndef characterClean(string):\n    global slash\n    string = string.replace(\'\\xe2\\x80\\x9c\',\'"\').replace(\'\\xe2\\x80\\x9d\',\'"\').replace(\'\\xe2\\x80\\x99\',"\'").replace(slash+\'xe2\\\\x80\\\\x93\',\'-\')\n    # string = string.encode(\'latin-1\')\n    return string\n\ndef basic(string):\n    pattern = re.compile(\'([^\\s\\w]|_)+\')\n    string = pattern.sub(\'\', string)\n    string = replaceDuplicate(string,\' \')\n    string = cleanFirst(string,\' \')\n    string = cleanLast(string,\' \')\n\n    return string\n\ndef charFix( string ):\n    global slash\n    global charFixData\n    for ch in charFixData:\n        chs = ch[1].split(\',\')\n        for c in chs:\n            string = string.replace( slash+c, ch[0] )\n    return string\n\ncharFixData = [\'\',\'x00\'],\n[\'\',\'x01\'],\n[\'\',\'x02\'],\n[\'\',\'x03\'],\n[\'\',\'x04\'],\n[\'\',\'x05\'],\n[\'\',\'x06\'],\n[\'\',\'x07\'],\n[\'\',\'x08\'],\n[\'\',\'x09\'],\n[\'\',\'x0a\'],\n[\'\',\'x0b\'],\n[\'\',\'x0c\'],\n[\'\',\'x0d\'],\n[\'\',\'x0e\'],\n[\'\',\'x0f\'],\n[\'\',\'x10\'],\n[\'\',\'x11\'],\n[\'\',\'x12\'],\n[\'\',\'x13\'],\n[\'\',\'x14\'],\n[\'\',\'x15\'],\n[\'\',\'x16\'],\n[\'\',\'x17\'],\n[\'\',\'x18\'],\n[\'\',\'x19\'],\n[\'\',\'x1a\'],\n[\'\',\'x1b\'],\n[\'\',\'x1c\'],\n[\'\',\'x1d\'],\n[\'\',\'x1e\'],\n[\'\',\'x1f\'],\n[\'\',\'x20\'],\n[\'!\',\'x21\'],\n[\'\'\',\'x22\'],\n[\'#\',\'x23\'],\n[\'$\',\'x24\'],\n[\'%\',\'x25\'],\n[\'&\',\'x26\'],\n[\'\'\',\'x27\'],\n[\'(\',\'x28\'],\n[\')\',\'x29\'],\n[\'*\',\'x2a\'],\n[\'+\',\'x2b\'],\n[\',\',\'x2c\'],\n[\'-\',\'x2d\'],\n[\'.\',\'x2e\'],\n[\'/\',\'x2f\'],\n[\'0\',\'x30\'],\n[\'1\',\'x31\'],\n[\'2\',\'x32\'],\n[\'3\',\'x33\'],\n[\'4\',\'x34\'],\n[\'5\',\'x35\'],\n[\'6\',\'x36\'],\n[\'7\',\'x37\'],\n[\'8\',\'x38\'],\n[\'9\',\'x39\'],\n[\':\',\'x3a\'],\n[\';\',\'x3b\'],\n[\'<\',\'x3c\'],\n[\'=\',\'x3d\'],\n[\'>\',\'x3e\'],\n[\'?\',\'x3f\'],\n[\'@\',\'x40\'],\n[\'A\',\'x41\'],\n[\'B\',\'x42\'],\n[\'C\',\'x43\'],\n[\'D\',\'x44\'],\n[\'E\',\'x45\'],\n[\'F\',\'x46\'],\n[\'G\',\'x47\'],\n[\'H\',\'x48\'],\n[\'I\',\'x49\'],\n[\'J\',\'x4a\'],\n[\'K\',\'x4b\'],\n[\'L\',\'x4c\'],\n[\'M\',\'x4d\'],\n[\'N\',\'x4e\'],\n[\'O\',\'x4f\'],\n[\'P\',\'x50\'],\n[\'Q\',\'x51\'],\n[\'R\',\'x52\'],\n[\'S\',\'x53\'],\n[\'T\',\'x54\'],\n[\'U\',\'x55\'],\n[\'V\',\'x56\'],\n[\'W\',\'x57\'],\n[\'X\',\'x58\'],\n[\'Y\',\'x59\'],\n[\'Z\',\'x5a\'],\n[\'[\',\'x5b\'],\n[\'\',\'x5c\'],\n[\']\',\'x5d\'],\n[\'^\',\'x5e\'],\n[\'_\',\'x5f\'],\n[\'`\',\'x60\'],\n[\'a\',\'x61\'],\n[\'b\',\'x62\'],\n[\'c\',\'x63\'],\n[\'d\',\'x64\'],\n[\'e\',\'x65\'],\n[\'f\',\'x66\'],\n[\'g\',\'x67\'],\n[\'h\',\'x68\'],\n[\'i\',\'x69\'],\n[\'j\',\'x6a\'],\n[\'k\',\'x6b\'],\n[\'l\',\'x6c\'],\n[\'m\',\'x6d\'],\n[\'n\',\'x6e\'],\n[\'o\',\'x6f\'],\n[\'p\',\'x70\'],\n[\'q\',\'x71\'],\n[\'r\',\'x72\'],\n[\'s\',\'x73\'],\n[\'t\',\'x74\'],\n[\'u\',\'x75\'],\n[\'v\',\'x76\'],\n[\'w\',\'x77\'],\n[\'x\',\'x78\'],\n[\'y\',\'x79\'],\n[\'z\',\'x7a\'],\n[\'{\',\'x7b\'],\n[\'|\',\'x7c\'],\n[\'}\',\'x7d\'],\n[\'~\',\'x7e\'],\n[\'\',\'x7f\'],\n[\'\',\'xc2,x80\'],\n[\'\',\'xc2,x81\'],\n[\'\',\'xc2,x82\'],\n[\'\',\'xc2,x83\'],\n[\'\',\'xc2,x84\'],\n[\'\',\'xc2,x85\'],\n[\'\',\'xc2,x86\'],\n[\'\',\'xc2,x87\'],\n[\'\',\'xc2,x88\'],\n[\'\',\'xc2,x89\'],\n[\'\',\'xc2,x8a\'],\n[\'\',\'xc2,x8b\'],\n[\'\',\'xc2,x8c\'],\n[\'\',\'xc2,x8d\'],\n[\'\',\'xc2,x8e\'],\n[\'\',\'xc2,x8f\'],\n[\'\',\'xc2,x90\'],\n[\'\',\'xc2,x91\'],\n[\'\',\'xc2,x92\'],\n[\'\',\'xc2,x93\'],\n[\'\',\'xc2,x94\'],\n[\'\',\'xc2,x95\'],\n[\'\',\'xc2,x96\'],\n[\'\',\'xc2,x97\'],\n[\'\',\'xc2,x98\'],\n[\'\',\'xc2,x99\'],\n[\'\',\'xc2,x9a\'],\n[\'\',\'xc2,x9b\'],\n[\'\',\'xc2,x9c\'],\n[\'\',\'xc2,x9d\'],\n[\'\',\'xc2,x9e\'],\n[\'\',\'xc2,x9f\'],\n[\'\',\'xc2,xa0\'],\n[\'\',\'xc2,xa1\'],\n[\'\',\'xc2,xa2\'],\n[\'\',\'xc2,xa3\'],\n[\'-\',\'xc2,xa4\'],\n[\'\',\'xc2,xa5\'],\n[\'\',\'xc2,xa6\'],\n[\'\',\'xc2,xa7\'],\n[\'\',\'xc2,xa8\'],\n[\'(C)\',\'xc2,xa9\'],\n[\'-\',\'xc2,xaa\'],\n[\'-\',\'xc2,xab\'],\n[\'-\',\'xc2,xac\'],\n[\'-\',\'xc2,xad\'],\n[\'-\',\'xc2,xae\'],\n[\'-\',\'xc2,xaf\'],\n[\'-\',\'xc2,xb0\'],\n[\'\',\'xc2,xb1\'],\n[\'\',\'xc2,xb2\'],\n[\'\',\'xc2,xb3\'],\n[\'\xc2\xb4\',\'xc2,xb4\'],\n[\'\',\'xc2,xb5\'],\n[\'\',\'xc2,xb6\'],\n[\'-\',\'xc2,xb7\'],\n[\'\',\'xc2,xb8\'],\n[\'\',\'xc2,xb9\'],\n[\'-\',\'xc2,xba\'],\n[\'-\',\'xc2,xbb\'],\n[\' 1/4\',\'xc2,xbc\'],\n[\' 1/2\',\'xc2,xbd\'],\n[\' 3/4\',\'xc2,xbe\'],\n[\'\',\'xc2,xbf\'],\n[\'\',\'xc3,x80\'],\n[\'\',\'xc3,x81\'],\n[\'\',\'xc3,x82\'],\n[\'\',\'xc3,x83\'],\n[\'\',\'xc3,x84\'],\n[\'\',\'xc3,x85\'],\n[\'\',\'xc3,x86\'],\n[\'\',\'xc3,x87\'],\n[\'\',\'xc3,x88\'],\n[\'\',\'xc3,x89\'],\n[\'\',\'xc3,x8a\'],\n[\'\',\'xc3,x8b\'],\n[\'\',\'xc3,x8c\'],\n[\'\',\'xc3,x8d\'],\n[\'\',\'xc3,x8e\'],\n[\'\',\'xc3,x8f\'],\n[\'\',\'xc3,x90\'],\n[\'\',\'xc3,x91\'],\n[\'\',\'xc3,x92\'],\n[\'\',\'xc3,x93\'],\n[\'\',\'xc3,x94\'],\n[\'\',\'xc3,x95\'],\n[\'\',\'xc3,x96\'],\n[\'x\',\'xc3,x97\'],\n[\'\',\'xc3,x98\'],\n[\'\',\'xc3,x99\'],\n[\'\',\'xc3,x9a\'],\n[\'\',\'xc3,x9b\'],\n[\'\',\'xc3,x9c\'],\n[\'\',\'xc3,x9d\'],\n[\'\',\'xc3,x9e\'],\n[\'\',\'xc3,x9f\'],\n[\'\',\'xc3,xa0\'],\n[\'\',\'xc3,xa1\'],\n[\'\',\'xc3,xa2\'],\n[\'\',\'xc3,xa3\'],\n[\'\',\'xc3,xa4\'],\n[\'\',\'xc3,xa5\'],\n[\'\',\'xc3,xa6\'],\n[\'\',\'xc3,xa7\'],\n[\'\',\'xc3,xa8\'],\n[\'\',\'xc3,xa9\'],\n[\'\',\'xc3,xaa\'],\n[\'\',\'xc3,xab\'],\n[\'\',\'xc3,xac\'],\n[\'\',\'xc3,xad\'],\n[\'\',\'xc3,xae\'],\n[\'\',\'xc3,xaf\'],\n[\'\',\'xc3,xb0\'],\n[\'\',\'xc3,xb1\'],\n[\'\',\'xc3,xb2\'],\n[\'\',\'xc3,xb3\'],\n[\'\',\'xc3,xb4\'],\n[\'\',\'xc3,xb5\'],\n[\'\',\'xc3,xb6\'],\n[\'\xc3\xb7\',\'xc3,xb7\'],\n[\'\',\'xc3,xb8\'],\n[\'\',\'xc3,xb9\'],\n[\'\',\'xc3,xba\'],\n[\'\',\'xc3,xbb\'],\n[\'\',\'xc3,xbc\'],\n[\'\',\'xc3,xbd\'],\n[\'\',\'xc3,xbe\'],\n[\'\',\'xc3,xbf\']\n\ndef clean_filename(filename, dup=False, replace=None, whitelist=None):\n    if not filename:\n        return \'\'\n    unicodedata = __.imp(\'unicodedata\')\n    string = __.imp(\'string\')\n    valid_filename_chars = "-_.() %s%s" % (string.ascii_letters, string.digits)\n    char_limit = 255\n    if whitelist is None: whitelist = valid_filename_chars;\n    if replace is None: replace = \' \';\n    # replace spaces\n    for r in replace:\n        if r:\n            filename = filename.replace(r,replace)\n    \n    # keep only valid ascii chars\n    cleaned_filename = unicodedata.normalize(\'NFKD\', filename).encode(\'ASCII\', \'ignore\').decode()\n    \n    # keep only whitelisted chars\n    cleaned_filename = \'\'.join(c for c in cleaned_filename if c in whitelist)\n    cleaned_filename = cleanBE(cleaned_filename,\' \')\n    if len(cleaned_filename)>char_limit:\n        _.pr("Warning, filename truncated because it was over {}. Filenames may no longer be unique".format(char_limit))\n    if dup:\n        cleaned_filename = do( \'dup\', cleaned_filename, replace )\n    return cleaned_filename[:char_limit]\n\ndef do(what=None,string=\'\',a=None,b=None,c=None,d=None):\n\n    # if what in \'file\'.split(\' \') and not string: _.pr( \'(filename, dup=False, replace=None, whitelist=None)\' );\n    if what in \'an alphan\'.split(\' \'): return totalStrip1b( string, a );\n    if what in \'file\'.split(\' \'): return clean_filename( string, a, b, c );\n\n    if what is None:\n        import _rightThumb._base3 as _\n        _.pv(\'\'\'\n            if what in \'an\'.split(\' \'): return re.sub(r\'[^A-Za-z0-9 ]+\', \'\', string);\n            if what in \'all\'.split(\' \'): return replaceAll(string,a,b);\n            if what in \'cleanAll\'.split(\' \'): return cleanAll(string,a,b);\n            if what in \'dup\'.split(\' \'): return replaceDuplicate(string,a);\n            if what in \'be\'.split(\' \'): return cleanBE(string,a);\n            if what in \'b\'.split(\' \'): return cleanFirst(string,a);\n            if what in \'e\'.split(\' \'): return cleanEnd(string,a);\n            if \'alpha\' in what and \'nu\' in what : return stripNonAlphaNumaric(string);\n            if what in \'n\'.split(\' \'): return removeNonNumber(string);\n            if what in \'ra remove\'.split(\' \'): return removeAll(string,a);\n        \'\'\')\n        sys.exit()\n\n    try:\n        if what in \'an\'.split(\' \'): import re; return re.sub(r\'[^A-Za-z0-9 ]+\', \'\', string);\n    except Exception as e:\n        if what in \'an\'.split(\' \'): return re.sub(r\'[^A-Za-z0-9 ]+\', \'\', string);\n\n    \n    # if what in \'file\'.split(\' \'): import re; return re.sub(r\'[0-9a-zA-Z_\\-+$ ]\', \'\', string);\n    # if what in \'file\'.split(\' \'): import re; return re.sub(r\'^[0-9a-zA-Z_\\-. ]+$\', \'\', string);\n    \n    if what in \'.sh\'.split(\' \'): return sh(string);\n    if what in \'all\'.split(\' \'): return replaceAll(string,a,b);\n    if what in \'cleanAll\'.split(\' \'): return cleanAll(string,a,b);\n    if what in \'dup\'.split(\' \'): return replaceDuplicate(string,a);\n    if what in \'be\'.split(\' \'): return cleanBE(string,a);\n    if what in \'b\'.split(\' \'): return cleanFirst(string,a);\n    if what in \'e\'.split(\' \'): return cleanEnd(string,a);\n    if \'alpha\' in what and \'nu\' in what : return stripNonAlphaNumaric(string);\n    if what in \'n\'.split(\' \'): return removeNonNumber(string);\n    if what in \'ra remove\'.split(\' \'): return removeAll(string,a);\n\ndef sh(string):\n    string=str(string)\n    string=string.replace( chr(10), \'\\n\' ).replace( \'\\r\', \'\' ).replace( chr(27), \'\' ).replace( chr(10), \'\\n\' ).replace( \'\\r\', \'\' ).replace( chr(27), \'\' )\n    while \'\\t\' in string: string = string.replace( \'\\t\', \'    \' );\n    return string\n\nclass st(str):\n    def sh(self): self=do(\'.sh\',self); return string(self);\n    def all(self,a,b): self=do(\'all\',self,a,b); return string(self);\n    def cleanAll(self,a,b): self=do(\'cleanAll\',self,a,b); return string(self);\n    def dup(self,a): self=do(\'dup\',self,a); return string(self);\n    def be(self,a): self=do(\'be\',self,a); return string(self);\n    def b(self,a): self=do(\'b\',self,a); return string(self);\n    def e(self,a): self=do(\'e\',self,a); return string(self);\n    def alpha(self): self=do(\'n\',self); return string(self);\n    def num(self): self=do(\'nu\',self); return string(self);\n    def remove(self,a): self=do(\'remove\',self,a); return string(self);\n    def ra(self,a): self=do(\'remove\',self,a); return string(self);\n    def json(self):\n        simplejson = __.imp(\'simplejson\')\n        json=simplejson.loads(self)\n        isa=\'dic\'\n        if do(\'.sh\',self).replace(\' \',\'\').replace(\'\\n\',\'\').startswith(\'{\'):\n            isa=\'dic\'\n        elif do(\'.sh\',self).replace(\' \',\'\').replace(\'\\n\',\'\').startswith(\'[\'):\n            isa=\'lis\'\n        self=json\n        if isa==\'lis\': return lis(self);\n        if isa==\'dic\': return dic(self);\n        return \n\n\n\nclass dic(dict):\n    def string(self):\n        simplejson = __.imp(\'simplejson\')\n        return string(simplejson.dumps(self, indent=4, sort_keys=False))\n    def inline(self):\n        simplejson = __.imp(\'simplejson\')\n        return string(simplejson.dumps(self))\n\nclass lis(list):\n    def string(self):\n        simplejson = __.imp(\'simplejson\')\n        return string(simplejson.dumps(self, indent=4, sort_keys=False))\n    def inline(self):\n        simplejson = __.imp(\'simplejson\')\n        return string(simplejson.dumps(self))\n')
    __stickytape_write_module('_rightThumb/_base3/__init__.py', b'#!/usr/bin/python3\r\n\r\n\r\n# sudo apt install libpython2.7-stdlib\r\n# import json\r\n\r\n# ## {R2D2919B742E} ##\r\n# ###########################################################################\r\n# What if magic existed?\r\n# What if a place existed where your every thought and dream come to life.\r\n# There is only one catch: it has to be written down.\r\n# Such a place exists, it is called programming.\r\n#    - Scott Taylor Reph, RightThumb.com\r\n# ###########################################################################\r\n# ## {C3P0D40fAe8B} ##\r\nimport glob\r\nimport sys,os,time,datetime,threading\r\n# from os.path import isfile, isdir\r\n# import uuid\r\nfrom operator import itemgetter\r\nfrom datetime import datetime as dt, timedelta\r\nfrom datetime import date\r\n# from threading import Timer\r\n# import simplejson as json\r\n# try:\r\n#   import sqlite3\r\n# except Exception as e:\r\n#   pass\r\n\r\n\'\'\'\r\nsimplejson = __.imp(\'simplejson\')\r\nsimplejson.loads(var)\r\nsimplejson.dumps(rows, indent=4, sort_keys=False)\r\nsimplejson.dumps(rows)\r\n\'\'\'\r\n\r\n\r\n\r\ndef numerate(asset,label=\'one\'):\r\n    row=0\r\n    i=-2\r\n    new=[]\r\n    # print( len(\'\\n\'.join(asset)) )\r\n    # print( \'\\n\'.join(asset).index(\'23\') )\r\n    for ii,ass in enumerate(asset):\r\n        # print(len(ass))\r\n        i+=1\r\n        if ii:\r\n            b=i\r\n        else:\r\n            b=i+1\r\n        e=i+len(ass)\r\n        i=e\r\n        new.append( ( ii,ass,b ) )\r\n    return new\r\n\r\ndef nindex(b,haystack,needle):\r\n    if not needle in haystack: return -1\r\n    if b == 0: return haystack.index(needle);\r\n    else: return haystack.index(needle)+1+b;\r\n\r\n\r\n\r\ndef chScan(i,needle,label=\'one\'):\r\n    global numerate_data\r\n    numerate_data[label]={}\r\n\r\n\r\ndef fometa(path,end=\'\'):\r\n    meta = {}\r\n    if os.path.isdir(path):\r\n        folder = __.path(path)\r\n    elif os.path.isfile(path):\r\n        folder = __.path(path,pop=True)\r\n    else:\r\n        folder = __.path(path)\r\n\r\n    i=0\r\n\r\n    while not os.path.isfile( folder+os.sep+\'.folder.meta\'+end ):\r\n        i+=1\r\n        if i > 100:\r\n            break\r\n        #     e(\'missing folder meta\')\r\n        try:\r\n            folder = __.path(folder,pop=True)\r\n        except Exception as ee:\r\n            break\r\n    if os.path.isfile(folder+os.sep+\'.folder.meta\'+end):\r\n        meta = getTable2( folder+os.sep+\'.folder.meta\'+end )\r\n        meta[\'folder\']=folder\r\n        return meta\r\n    return {}\r\n\r\n\r\ndef json_(data,simp=False,s=None):\r\n    if not s is None: simp=s;\r\n    simplejson = __.imp(\'simplejson\')\r\n    if type(data) == str:\r\n        return simplejson.loads(data)\r\n    if not simp:\r\n        return simplejson.dumps(data, indent=4, sort_keys=False)\r\n    return simplejson.dumps(data)\r\n\r\n\r\ndef print_pr(text):\r\n    if not \'_rightThum\'+\'b._base3 \' in text:\r\n        return text\r\n    text=text.replace(\'\\r\',\'\')\r\n    lines=[]\r\n    for line in text.split(\'\\n\'):\r\n        replace=False\r\n        if line.startswith(\'print(\'):\r\n            replace=True\r\n        elif \'.print(\' in line:\r\n            replace=False\r\n        elif line.startswith(\'def \') or \'\\t def \' in line or \' def \' in line:\r\n            replace=False\r\n        else:\r\n            replace=True\r\n\r\n        \r\n        if replace:\r\n            line=line.replace(\'print(\',\'_.pr(\')\r\n        line=line.replace(\'def _.pr(\', \'def print(\')\r\n        line=line.replace(\'def  _.pr(\', \'def print(\')\r\n        line=line.replace(\'def   _.pr(\', \'def print(\')\r\n        lines.append(line)\r\n    return \'\\n\'.join(lines)\r\n\r\ntry: print_ed;\r\nexcept Exception as e: print_ed=[];\r\nprint_ed_group={}\r\ndef print_(*args,p=None,c=None,pad=3,g=None,end=None):\r\n    global print_ed; global print_ed_group; items=[];\r\n    pre=\'\'\r\n    # if not g is None:\r\n    # print_ed_group\r\n    for arg in args:\r\n        if type(arg) == list:\r\n            tmp=[]\r\n            for rg in arg: tmp.append(str(rg));\r\n            items.append( \' \'.join(tmp) )\r\n        else:\r\n            items.append(str(arg))\r\n    prn=pre+\' \'.join(items)\r\n    if not c is None: prn=cp( prn, c, p=0 );\r\n    if p is None: rint=True;\r\n    elif p: rint=True;\r\n    elif not p: rint=False;\r\n    else: rint=True;\r\n    if rint:\r\n        if not end is None: print( prn, end=end );\r\n        else: print( prn );\r\n    print_ed.append(prn)\r\n    return prn\r\n\r\n\r\n\r\n\r\nfo_fi=[]\r\ndef fo(folder=None,r=False,script=None,first=True):\r\n    if folder is None:\r\n        # try: os=__.imp(\'os.getcwd\');\r\n        # except Exception as e: pass;\r\n        folder=os.getcwd()\r\n    global fo_fi\r\n    if first: fo_fi=[];\r\n    if not os.path.isdir(folder): return fo_fi;\r\n    try:\r\n        files=os.listdir(folder)\r\n    except Exception as e:\r\n        return fo_fi\r\n    for item in files:\r\n        path=folder+os.sep+item\r\n        path=__.path(path)\r\n        if os.path.isfile(path):\r\n            fo_fi.append(path)\r\n            if not script is None: script(path);\r\n        if r and os.path.isdir(path): fo(path,r,script,False);\r\n    return fo_fi\r\n\r\n\r\n\r\ndef printt( table, cols=None, sort=None ):\r\n    if not table: return None;\r\n    global switches\r\n    global tables\r\n    if not sort is None:\r\n        switches.fieldSet( \'Sort\', \'active\', True )\r\n        switches.fieldSet( \'Sort\', \'value\', sort )\r\n        switches.fieldSet( \'Sort\', \'values\', sort.split(\',\') )\r\n    tables.register( \'ea3dfa23ae6d\', table )\r\n    if cols is None: cols=\',\'.join(list(table[0].keys()));\r\n    tables.print( \'ea3dfa23ae6d\', cols )\r\n\r\ndef pa(fi=None,fo=None,dot=\'\',mkdir=True):\r\n    if os.path.isdir(fi): fi=None; fo=fi;\r\n    def _pacl(sub,dot):\r\n        sub=sub.replace(\'\\\\\',os.sep).replace(\'/\',os.sep)\r\n        sub=_str.do(\'dup\',sub,os.sep)\r\n        if dot: sub=sub.replace(dot,os.sep);\r\n        return sub\r\n\r\n    if type(fo) == str: fo=_pacl(fo,dot);\r\n    if type(fi) == str:\r\n        if \'/\' in fi or \'\\\\\' in fi: fo=__.path(_pacl(fi,0),pop=True); fi=__.path(_pacl(fi,0),file=True); fo=_pacl(fo,dot);\r\n    if dot: fo=fo.replace(\'.\',os.sep);\r\n\r\n\r\n    if not fo is None and not fi is None:\r\n        path=fo+os.sep+fi\r\n    elif not fo is None:\r\n        path=fo\r\n        fi=\'\'\r\n    if mkdir:\r\n        if not os.path.isdir(fo):\r\n            _v.mkdir(fo)\r\n    return path\r\n\r\ndef string_preview(string,l=30):\r\n    string=str(string)\r\n    if not string:\r\n        return string\r\n    new=\'\'\r\n    broke=False\r\n    for i,x in enumerate(string):\r\n        if i+1 <= l:\r\n            if x == \'\\t\':\r\n                x=\'\\\\t\'\r\n            if x == \'\\n\':\r\n                x=\'\\\\n\'\r\n            new+=x\r\n        else:\r\n            broke=True\r\n            new+=\'... (\'+addComma(len(string))+\')\'\r\n            break\r\n    return new\r\n\r\n\r\ntinydic_data = []\r\ntinydic_last = {}\r\ntinydic_dic = {}\r\ndef tinydic(data,par=\'\',skim=None, mt=True, lan=\'js\', prev=False, dump=None, dic=False, list0=True):\r\n    if type(dump)==str: dump=[dump];\r\n    global tinydic_data\r\n    global tinydic_last\r\n    global tinydic_dic\r\n    def rents(lan,p,k,islist=False,list0=True):\r\n        p2=None\r\n        if islist and list0:\r\n            k=\'0\'\r\n            p2=p+"[{k}]".replace(\'{k}\',k)\r\n        elif type(k)==int:\r\n            k=str(k)\r\n            p2=p+"[{k}]".replace(\'{k}\',k)\r\n        elif lan == \'py\':\r\n            p2=p+"[\'{k}\']".replace(\'{k}\',k)\r\n        elif lan == \'js\':\r\n            p2=p+".{k}".replace(\'{k}\',k)\r\n        else:\r\n            _.e(\'type(key)\')\r\n        return p2\r\n    if not par:\r\n        # if mt: print_(\'mt\');\r\n        tinydic_data=[]\r\n    if type(data) == list:\r\n        for key, value in enumerate(data):\r\n            par2=rents(lan,par,key,islist=True,list0=list0)\r\n            if dump is None and not prev and skim is None and mt and not par2 in tinydic_data:\r\n                tinydic_data.append(par2)\r\n            if skim is None and not dump is None and (   par2 in dump   ):\r\n                print_(str(key)+\':\',value)\r\n            tinydic(value,par2,skim,mt,lan,prev,dump,dic,list0)\r\n        if dic: return tinydic_dic;\r\n        return tinydic_data\r\n\r\n    if \'items\' in dir(data) and \'builtin_function_or_method\' in str(type(data.items)):\r\n        child=True\r\n    else:\r\n        tinydic_dic[par] = data\r\n        child=False\r\n        if dump is None and prev and skim is None:\r\n            tinydic_data.append(par+\' = \'+string_preview(data))\r\n        elif dump is None and not prev and skim is None and not par in tinydic_data:\r\n            tinydic_data.append(par)\r\n        if not skim is None:\r\n            if showLine(str(data)):\r\n                if not dump is None:\r\n                    for du in dump:\r\n                        if du  in tinydic_last:\r\n                            ump=du+\': \'+ tinydic_last[du]\r\n                            if not ump in tinydic_data:\r\n                                tinydic_data.append(\'\')\r\n                                tinydic_data.append(ump)\r\n                if not par in tinydic_data:\r\n                    if prev:\r\n                        tinydic_data.append(par+\' = \'+string_preview(data))\r\n                    else:\r\n                        tinydic_data.append(par)\r\n                tinydic_last={}\r\n\r\n    if child:\r\n        for key, value in data.items():\r\n            par2=rents(lan,par,key)\r\n            if not skim is None and not dump is None and key in dump:\r\n                for du in dump:\r\n                    if key == du:\r\n                        tinydic_last[du]=value\r\n            if skim is None and not dump is None and (   key in dump   or   par2 in dump   ):\r\n                print_(str(key)+\':\',value)\r\n            if dump is None and not prev and skim is None and mt and not par2 in tinydic_data:\r\n                tinydic_data.append(par2)\r\n            tinydic(value,par2,skim,mt,lan,prev,dump,dic,list0)\r\n    if dic: return tinydic_dic;\r\n    return tinydic_data\r\n\r\n\r\ndef tailpop(subject,delim):\r\n    parts=subject.split(delim)\r\n    parts.reverse()\r\n    e=parts.pop(0)\r\n    parts.reverse()\r\n    return delim.join(parts)\r\n\r\ndef tab(val,n=None, t=\'    \', cnt=False, add=None,  s=False):\r\n\r\n    if n is None and add is None and not s and not cnt:\r\n        n=1\r\n\r\n    def shortest(lines):\r\n        p=None\r\n        for i,line in enumerate(lines):\r\n            l=_str.do(\'be\',line, \' \')\r\n            a=len(line)\r\n            b=len(l)\r\n            d=a-b\r\n            if p is None:\r\n                p=d\r\n            elif b and d < p:\r\n                p=d\r\n        return p\r\n    def shorten(lines):\r\n        p=shortest(lines)\r\n        for i,line in enumerate(lines):\r\n            l=_str.do(\'be\',line, \' \')\r\n            if len(l):\r\n                lines[i] = line[p:]\r\n            else:\r\n                lines[i] = \'\'\r\n        return lines\r\n\r\n\r\n\r\n    val = val.replace(\'\\t\',t)\r\n    val = val.replace(\'\\r\',\'\')\r\n    val = _str.do(\'be\',val, \'\\n\')\r\n    # val = _str.do(\'all\',val, \' \\n\')\r\n    lines = val.split(\'\\n\')\r\n\r\n    if cnt:\r\n        p=shortest(lines)\r\n        \r\n\r\n\r\n\r\n    if s:\r\n        lines=shorten(lines)\r\n\r\n    if not add is None and add:\r\n        for i,line in enumerate(lines):\r\n            l=_str.do(\'be\',line, \' \')\r\n            if len(l):\r\n                lines[i] = t + line\r\n            else:\r\n                lines[i] = \'\'\r\n    if not n is None and n:\r\n        i=0\r\n        pre=\'\'\r\n        while not i == n:\r\n            i+=1\r\n            pre+=t\r\n        print_(\'n\',n,\'|\'+pre+\'|\')\r\n        for i,line in enumerate(lines):\r\n            l=_str.do(\'be\',line, \' \')\r\n            if len(l):\r\n                lines[i] = pre+line\r\n            else:\r\n                lines[i] = \'\'\r\n    return \'\\n\'.join(lines)\r\n\r\ndef ll(subject,d=\' \'): return subject.split(d);\r\n\r\ndef rev(string):\r\n    a=list(string)\r\n    a.reverse()\r\n    a=\'\'.join(a)\r\n    return a\r\n\r\ndef n2w(n,c=None):\r\n    d=None\r\n    s=str(n)\r\n    if \'.\' in s:\r\n        n=int(s.split(\'.\')[0])\r\n        # d=int(s.split(\'.\')[1])\r\n    try:\r\n        import num2word\r\n    except Exception as ee:\r\n        e(ee)\r\n\r\n    r = num2word.word(n)\r\n    if not d is None:\r\n        r += \' and \'+n2w(d).replace(\'Hundred\',\'Hundredth\').replace(\'Thousand\',\'Thousandth\').replace(\'Million\',\'Millionth\').replace(\'Billion\',\'Billionth\').replace(\'Trillion\',\'Trillionth\')\r\n        if not c is None:\r\n            result = colorThis( r, c )\r\n    return r\r\n\r\ndef aiBullet(string,depth=None,d=None):\r\n    if type(string) == int:\r\n        s=depth\r\n        d=string\r\n        string=s\r\n        depth=d\r\n    if not d is None:\r\n        depth=d\r\n    if depth is None:\r\n        return \'\\n                  - \'+string\r\n    code=\'\\n                  \'\r\n    i=0\r\n    while not i==depth:\r\n        i+=1\r\n        code+=\'  \'\r\n    return code+\'- \'+string\r\n\r\ndef aiLine(string,lines=2):\r\n\r\n    if type(string) == int:\r\n        s=lines; l=string;\r\n        string=s; lines=l;\r\n\r\n    if lines==2:\r\n        return \'\\n\\n                \'+string\r\n    else:\r\n        return \'\\n                \'+string\r\n\r\ndef over(txt,note=\'\',r=None,l=None):\r\n    end=False\r\n    if r: end=True;\r\n    # print_(\'note\',note)\r\n    ss=txt\r\n    if len(note):\r\n        if end:\r\n            ss=rev(ss)\r\n            note=rev(note)\r\n\r\n        s=\'\'\r\n        i=0\r\n        nd=len(note)-1\r\n        for ch in ss:\r\n            if i > nd:\r\n                s+=ch\r\n            elif ch in \'{-}\':\r\n                s+=ch\r\n            else:\r\n                s+=note[i]\r\n            \r\n            if not ch in \'{-}\':\r\n                i+=1\r\n        ss=s\r\n        if end:\r\n            ss=rev(ss)\r\n            note=rev(note)\r\n    return ss\r\n\r\n\r\n\r\ndef ddelim( txt=None, what=\'szYZhw\', d=None, indices=None, f=1, r=-1 ):\r\n    if what.lower() in ll(\'uuid guid\'):\r\n        what = \'uuid\'\r\n    def uu(p,r,u):\r\n        if p:\r\n            cp([\'in section\',u,r], \'Background.red\')\r\n        return u\r\n    p=0\r\n    u=0\r\n    ec=\'yellow\'\r\n    ec=\'Background.light_blue\'\r\n    def eeof(u,p,ec,d,r,what,txt,note=None):\r\n        if p:\r\n            if note is None:\r\n                cp([{\'r\':r, \'u\':u, \'p\':p, \'d\':d,\'what\':what}],\'yellow\')\r\n            else:\r\n                cp([{\'*\':note, \'r\':r, \'u\':u, \'p\':p, \'d\':d,\'what\':what}],\'yellow\')\r\n            cp([\'e\',txt],ec)\r\n        return txt\r\n    if txt is None:\r\n        _.cp(\'ddelim( txt=None, indices=[8, 12, 16, 20], d=\'-\' )\',\'yellow\')\r\n        sys.exit()\r\n\r\n    specified=1\r\n    \r\n    if d is None:\r\n        specified=0\r\n        # d=\'-\'\r\n    if indices is None:\r\n        specified=0\r\n        # indices=[8, 12, 16, 20]\r\n    if p:\r\n        print_(1,txt)\r\n    if f:\r\n        txt=_str.stripNonAlphaNumaric(txt,\'.\').replace(\' \',\'\')\r\n    if p:\r\n        cp([\'~\',what,len(txt)],\'cyan\')\r\n        cp( [specified,txt,what,d], \'white\' )\r\n    \r\n    if specified:\r\n        pass\r\n    elif what in \'{} [] () <>\'.split(\' \'):\r\n        u=uu(p,r,1)\r\n        new_string=what[0]+txt+what[1]\r\n        return eeof(u,p,ec,d,r,what,new_string)\r\n\r\n    elif what == \'uuid2\':\r\n        u=uu(p,r,2)\r\n        d=\'-\'; indices=[8, 12, 16, 20];\r\n        txt=ddelim( txt, d=d, indices=indices, f=0, r=u )\r\n        txt=ddelim( txt, what=\'{}\', f=0, r=u )\r\n        return eeof(u,p,ec,d,r,what,txt).replace(\'{\',\'\').replace(\'}\',\'\')\r\n    elif what == \'uuid\':\r\n        u=uu(p,r,2)\r\n        d=\'-\'; indices=[8, 12, 16, 20];\r\n        txt=ddelim( txt, d=d, indices=indices, f=0, r=u )\r\n        txt=ddelim( txt, what=\'{}\', f=0, r=u )\r\n        return eeof(u,p,ec,d,r,what,txt)\r\n    elif what == \'time\':\r\n        u=uu(p,r,3)\r\n        if len(txt) == 6:\r\n            d=\':\'; indices=[2, 4];\r\n        elif len(txt) == 4:\r\n            d=\':\'; indices=[2];\r\n        return eeof(u,p,ec,d,r,what,ddelim( txt, d=d, indices=indices, f=0, r=u ))\r\n\r\n    elif what == \'date\':\r\n        u=uu(p,r,4)\r\n        d=\'-\'; indices=[4, 6];\r\n        return eeof(u,p,ec,d,r,what,ddelim( txt, d=d, indices=indices, f=0, r=u ))\r\n    elif what in \'dt ts timestamp date-time stamp\'.split(\' \'):\r\n        u=uu(p,r,5)\r\n        txtt=ddelim( txt, d=\' \', indices=[8], f=0, r=u )\r\n        if p:\r\n            cp([\'txtt\',txtt],\'darkcyan\')\r\n        # sys.exit()\r\n        a=ddelim( txtt.split(\' \')[0], what=\'date\', f=0, r=u )\r\n        b=ddelim( txtt.split(\' \')[1], what=\'time\', f=0, r=u )\r\n        txt=a+\' \'+b\r\n        return eeof(u,p,ec,d,r,what,txt)\r\n    elif indices is None:\r\n        cp(\'ELSE\',\'red\')\r\n        print_(\'-----------\',what,txt)\r\n        eeof(u,p,ec,d,r,what,txt,note=\'WTF\')\r\n        e(\'ELSE\')\r\n\r\n    # print_(2,txt)\r\n\r\n    original = txt\r\n    delimiter = d\r\n\r\n\r\n    if p and d == \' \':\r\n        cp([\'**\',txt,what,d,indices],\'red\')\r\n\r\n    new_string = \'\'\r\n    for i,ch in enumerate(txt):\r\n        new_string += ch\r\n        if i+1 in indices:\r\n            new_string += d\r\n    return eeof(u,p,ec,d,r,what,new_string)\r\n    return eeof(u,p,ec,d,r,what,new_string)\r\n\r\n\r\n\r\n    prev = 0\r\n    for index in indices:\r\n        if p:\r\n            print_(\'ind\',what,(prev,index),original[prev:index])\r\n        new_string += original[prev:index] + delimiter\r\n        prev = index\r\n    new_string += original[prev:]\r\n    return eeof(u,p,ec,d,r,what,new_string)\r\ndelimiter=ddelim\r\n\r\ndef clear():\r\n    global isWin\r\n    if isWin:\r\n        os.system(\'cls\')\r\n    else:\r\n        os.system(\'clear\')\r\n\r\ndef rstr(code,o,c):\r\n    i=o-1\r\n    txt=\'\'\r\n    while not i == c:\r\n        i+=1\r\n        txt+=code[i]\r\n    return txt\r\n\r\ndef get_supporting_line(data,i,b=\';\',rev={}):\r\n    if type(data) == list:\r\n        data = \'\'.join(data)\r\n    eol=vindex(data,i,n=\'\\n\')\r\n    # print_(\'eol\',eol)\r\n    if eol == {}:\r\n        eol=len(data)\r\n    if eol > len(data)-1:\r\n        eol=len(data)-2\r\n    line = data[ i: eol+1 ].replace(\'\\n\',\'\')\r\n    ii=i-1\r\n    ip=i-1\r\n    pre=\'\'\r\n    # for c in line:\r\n    #   ip+=1\r\n    #   cc=data[ip]\r\n    #   if cc in \'({[\':\r\n    #       break\r\n    #   else:\r\n    #       if cc in \')}]\':\r\n    #           print_(\'rev\',rev)\r\n    #           print_(\'xxxxxxxxxxxxxxxxx\',cc,ip)\r\n    #           print_( ip in rev )\r\n    #           print_( ip+1 in rev )\r\n    #           print_( ip-1 in rev )\r\n    #           print_( ip+2 in rev )\r\n    #           print_( ip-2 in rev )\r\n    #           if ip in rev:\r\n    #               print_(\'here here here here here here here here here here here \')\r\n    #               ipx=vindex(data,rev[ip],n=\'\\n\',r=True)\r\n    #               pre=data[ ipx: ip ]\r\n    #               print_( \'pre pre\', pre )\r\n    #               break\r\n    #           sys.exit()\r\n    #       pre+=cc\r\n    # print_(\'pre\',pre)\r\n    while True:\r\n        ii+=1\r\n        if ii>=len(data): break;\r\n        c=data[ii]\r\n        if c == \'\\n\' or ( len(b) and c == b ): break;\r\n        if c in \'({[\':\r\n            y=vindex(data,ii)\r\n            if ii in y:\r\n                ii=y[ii]\r\n            else:\r\n                iii=ii\r\n                while not iii in y:\r\n                    iii+=1\r\n                    if iii in y:\r\n                        ii=y[iii]\r\n                        if iii >= len(data):\r\n                            ii=len(data)\r\n                # print_(ii,c,y)\r\n                # sys.exit()\r\n        \r\n    return pre+data[i:ii]\r\n\r\n\r\ndef vindex( code, i=0, esc=\'\\\\\', n=\'\', v=True,r=False,both=True, sort=True ):\r\n    def _sort(sort,dic):\r\n        if not sort: return dic;\r\n        ks=list(dic.keys()); ks.sort(); new={};\r\n        for k in ks: new[k]=dic[k];\r\n        return new\r\n\r\n    if type(code)==list:\r\n        code=\'\'.join(code)\r\n    at=i\r\n\r\n        \r\n    table={}\r\n    \r\n    table[\'brackets\'] = {}\r\n    table[\'brackets\'][\'i\']=0\r\n    table[\'brackets\'][\'open\'] = {}\r\n\r\n    table[\'braces\'] = {}\r\n    table[\'braces\'][\'i\']=0\r\n    table[\'braces\'][\'open\'] = {}\r\n\r\n    table[\'par\'] = {}\r\n    table[\'par\'][\'i\']=0\r\n    table[\'par\'][\'open\'] = {}\r\n\r\n\r\n\r\n    index={}\r\n\r\n    i-=1\r\n    while True:\r\n        i+=1\r\n        if i >= len(code):\r\n            break\r\n        c=code[i]\r\n        try:\r\n            c2=c+code[i+1]\r\n        except Exception as e:\r\n            c2=\'\'\r\n        try:\r\n            c3=c2+code[i+2]\r\n        except Exception as e:\r\n            c3=\'\'\r\n        try:\r\n            c4=c3+code[i+3]\r\n        except Exception as e:\r\n            c4=\'\'\r\n        try:\r\n            c5=c4+code[i+4]\r\n        except Exception as e:\r\n            c5=\'\'\r\n        if len(esc) == 1 and c==esc:\r\n            i+=1\r\n        else:\r\n            if len(esc) == 1 and c==esc:\r\n                i+=1\r\n            if n==\'\\n\' and r:\r\n                ii=i\r\n                c=code[i]\r\n                while not ii == 0 and c == \'\\n\':\r\n                    ii-=1\r\n                    c=code[ii]\r\n                    if ii == 0:\r\n                        return 0\r\n                    elif c == \'\\n\':\r\n                        return ii\r\n\r\n            elif len(n) == 1 and c==n:\r\n                return i\r\n            elif len(n) == 2 and c2==n:\r\n                return i+1\r\n            elif len(n) == 3 and c3==n:\r\n                return i+2\r\n            elif len(n):\r\n                pass\r\n            else:\r\n                if not n and c in \'0123456789.\':\r\n                    cx = c\r\n                    ii=i-1\r\n                    while cx in \'0123456789.\':\r\n                        ii+=1\r\n                        try:\r\n                            cx=code[ii]\r\n                        except Exception as e:\r\n                            ii-=1\r\n                            index[i] = ii\r\n                            if both:\r\n                                index[ii] = i\r\n                            break\r\n                    index[i] = ii\r\n                    if both:\r\n                        index[ii] = i\r\n                    i=ii\r\n                elif not n and c in \'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\':\r\n                    cx = c\r\n                    ii=i-1\r\n                    while cx in \'0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ._\':\r\n                        ii+=1\r\n                        try:\r\n                            cx=code[ii]\r\n                        except Exception as e:\r\n                            ii-=1\r\n                            index[i] = ii\r\n                            if both:\r\n                                index[ii] = i\r\n                            break\r\n\r\n                    index[i] = ii\r\n                    if both:\r\n                        index[ii] = i\r\n                    i=ii\r\n                elif not n and c3 == \'"""\':\r\n                    s=vindex(code,i+3,esc,n=\'"""\',v=0)\r\n                    index[i] = s\r\n                    if both:\r\n                        index[s] = i\r\n                    i=s\r\n                elif not n and c3 == "\'\'\'":\r\n                    s=vindex(code,i+3,esc,n="\'\'\'",v=0)\r\n                    index[i] = s\r\n                    if both:\r\n                        index[s] = i\r\n                elif not n and c == "\'":\r\n                    s=vindex(code,i+1,esc,n="\'",v=0)\r\n                    index[i] = s\r\n                    if both:\r\n                        index[s] = i\r\n                    i=s\r\n                elif not n and c == \'"\':\r\n                    s=vindex(code,i+1,esc,n=\'"\',v=0)\r\n                    index[i] = s\r\n                    if both:\r\n                        index[s] = i\r\n                    i = s\r\n                elif not n and c2 == \'/*\':\r\n                    i = vindex(code,i+2,esc,n=\'*/\',v=0)\r\n                elif not n and c2 == \'//\':\r\n                    i = vindex(code,i+2,esc,n=\'\\n\',v=0)+1\r\n\r\n\r\n                elif not n and c == \'{\':\r\n                    table[\'brackets\'][\'i\']+=1\r\n                    table[\'brackets\'][\'open\'][table[\'brackets\'][\'i\']]=i\r\n                elif not n and c == \'}\':\r\n                    try:\r\n                        s=table[\'brackets\'][\'open\'][table[\'brackets\'][\'i\']]\r\n                    except Exception as e:\r\n                        return _sort(sort,index)\r\n                    index[ s ]=i\r\n                    if both:\r\n                        index[ i ]=s\r\n                    table[\'brackets\'][\'i\']-=1\r\n                    if s==at:\r\n                        return _sort(sort,index)\r\n                elif not n and c == \'[\':\r\n                    table[\'braces\'][\'i\']+=1\r\n                    table[\'braces\'][\'open\'][table[\'braces\'][\'i\']]=i\r\n                elif not n and c == \']\':\r\n                    try:\r\n                        s=table[\'braces\'][\'open\'][table[\'braces\'][\'i\']]\r\n                    except Exception as e:\r\n                        return _sort(sort,index)\r\n                    index[ s ]=i\r\n                    if both:\r\n                        index[ i ]=s\r\n                    table[\'braces\'][\'i\']-=1\r\n                    if s==at:\r\n                        return _sort(sort,index)\r\n                elif not n and c == \'(\':\r\n                    table[\'par\'][\'i\']+=1\r\n                    table[\'par\'][\'open\'][table[\'par\'][\'i\']]=i\r\n                elif not n and c == \')\':\r\n                    try:\r\n                        s=table[\'par\'][\'open\'][table[\'par\'][\'i\']]\r\n                    except Exception as e:\r\n                        return _sort(sort,index)\r\n                    index[ s ]=i\r\n                    if both:\r\n                        index[ i ]=s\r\n                    table[\'par\'][\'i\']-=1\r\n                    if s==at:\r\n                        return _sort(sort,index)\r\n    \r\n    return _sort(sort,index)\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\ntry:\r\n    import colorama\r\n    colorama.init()\r\nexcept Exception as e:\r\n    pass\r\n\r\n# from threading import Thread\r\n\r\n\r\nimport _rightThumb._construct as __\r\nimport _rightThumb._vars as _v\r\nimport _rightThumb._string as _str\r\n\r\n__.print_path = False\r\n######################################################\r\n\r\nif os.path.isfile( _v.py+_v.slash+\'thread.py\' ):\r\n    print_( \'rm thread\' )\r\n    os.unlink( _v.py+_v.slash+\'thread.py\' )\r\n\r\n######################################################\r\n\r\ndef find_all(a_str, sub):\r\n    return list(find_all_do(a_str, sub))\r\n\r\ndef find_all_do(a_str, sub):\r\n    start = 0\r\n    while True:\r\n        start = a_str.find(sub, start)\r\n        if start == -1: return\r\n        yield start\r\n        start += len(sub)\r\n\r\n# def substring_range( text, o, c ):\r\n    \r\n\r\n######################################################\r\n\r\n_bm=None\r\ndef bAlias(subject):\r\n    # print_(type(subject))\r\n    if type(subject) == str:\r\n        subjects = [subject]\r\n    elif type(subject) == list:\r\n        subjects = subject\r\n    else:\r\n        print_(type(subject))\r\n        _.e( \'bAlias\', subject )\r\n\r\n    results=[]\r\n\r\n\r\n    for sub in subjects:\r\n        if os.path.isdir(sub):\r\n            results.append(sub)\r\n        else:\r\n            global _bm\r\n            if _bm is None:\r\n                import _rightThumb._bookmarks as _bm\r\n            \r\n            made={}\r\n            if \'wprofile\' in _v.config_hash:\r\n                made[\'h\'] = 1\r\n                h  = _v.config_hash[\'wprofile\']\r\n            if \'ww\' in _v.config_hash:\r\n                made[\'ww\'] = 1\r\n                ww = _v.config_hash[\'ww\']\r\n            # print_(\'made\',made)\r\n            if \'ww\' in made  and \'h\' in made:\r\n                a = ww+os.sep+\'databank\'+os.sep+\'tables\'+os.sep+\'bookmarks.index\'\r\n                b = h+os.sep+\'tables\'+os.sep+\'bookmarks.index\'\r\n                # print_(os.path.isfile(b))\r\n                try:\r\n                    if not os.path.isfile(b) and os.path.isfile(a):\r\n                        from shutil import copyfile\r\n                        copyfile(a,b)\r\n                except Exception as e:\r\n                    pass\r\n            path = _bm.Bookmarks( sub ).get()\r\n            # print_(sub,path)\r\n            if path is None:\r\n                cp( \'Error, Bookmark does not exist\', \'red\' )\r\n                results.append(sub)\r\n            elif os.path.isdir(path):\r\n                if path.count(\':\'):\r\n                    parts = path.split(\':\')\r\n                    parts.reverse()\r\n                    path = path[0]+\':\'+parts[0]\r\n                results.append(path)\r\n                # return path\r\n            else:\r\n                cp( \'Error, Bookmark no longer exists\', \'red\' )\r\n                results.append(sub)\r\n    if type(subject) == str and len(results):\r\n        return results[0]\r\n    elif type(subject) == str and not len(results):\r\n        return subject\r\n    elif type(subject) == list:\r\n        return results\r\n\r\n######################################################\r\n\r\ndef reFormatSize( start ):\r\n    start = start.replace( \' \', \'\' )\r\n    start = start.replace( \',\', \'\' )\r\n    start = start.replace( \'?\', \'\' )\r\n    b = unFormatSize( start )\r\n    end = formatSize( b )\r\n    return end\r\n\r\n######################################################\r\n\r\nclass dot:\r\n    def __init__( self ):\r\n        pass\r\n\r\n__.tableLine = \'\xe2\x80\xbd\'\r\nv = dot()\r\nvv = dot()\r\nv.isData = {}\r\nvv.opened_file_me = {}\r\n__.switch_skimmer = dot()\r\n__.switch_skimmer.scan = [ \'??\',\'-??\',\'--??\',\'/??\' ]\r\n__.switch_skimmer.active = []\r\n\r\n__.aggregate = dot()\r\n__.aggregate.eof = dot()\r\n__.aggregate.eof.storage = {}\r\n__.aggregate.obj = None\r\n__.aggregate.prefixes = {\r\n                            \'eot?\':  1,\r\n                            \'eof?\':  1,\r\n                            \'eog?\':  1,\r\n                            \'bog?\':  1,\r\n                            \'eoga?\': 1,\r\n                            \'run?\':  1,\r\n                        }\r\n\r\n__.aggregate.group_prefixes = {\r\n                            \'eog?\':  1,\r\n                            \'bog?\':  3,\r\n                            \'eoga?\': 1,\r\n                            \'run?\':  2,\r\n                        }\r\n__.aggregate.fn = dot()\r\n# \'?date\' \'?comma\' \'?size\' \'?bytes\'\r\n__.aggregate.fn.format = {\r\n                            \'add\': \'?comma\',\r\n                            \'isDate\': \'?date\',\r\n                        }\r\n__.aggregate.fn.order = {\r\n                            \'isDate\': 1\r\n                        }\r\n\r\n# if self.groupID_KEY in item and item[self.groupID_KEY].endswith(\'-B\'):\r\n\r\n\r\n__.terminal = dot()\r\ntry:\r\n    # cols, rows\r\n    __.terminal.width, __.terminal.height = list( os.get_terminal_size() )\r\nexcept Exception as e:\r\n    # try:\r\n    #   __.terminal.height, __.terminal.width = os.popen(\'stty size\', \'r\').read().split()\r\n    # except Exception as e:\r\n    __.terminal.width = 0\r\n    __.terminal.height = 0\r\n\r\n# print_(__.terminal.width)\r\n\r\n__.terminal.cols = __.terminal.width\r\n\r\n\r\n######################################################\r\n\r\ndef path_sep(subject):\r\n    if type(subject) == list:\r\n        s = []\r\n        for x in subject:\r\n            s.append( path_fix(x) )\r\n        subject = s\r\n    if type(subject) == str:\r\n        subject = subject.replace( os.sep+os.sep, os.sep )\r\n        subject = subject.replace( os.sep+os.sep, os.sep )\r\n    return subject\r\n\r\n######################################################\r\n_bm = None\r\n\r\n\r\ndef stripColor(text):\r\n    if \'0m\' in text and \'[\' in text:\r\n        pass\r\n    else:\r\n        return text\r\n    import re\r\n    ansi_escape = re.compile(r\'\'\'\r\n        \\x1B  # ESC\r\n        (?:   # 7-bit C1 Fe (except CSI)\r\n            [@-Z\\\\-_]\r\n        |     # or [ for CSI, followed by a control sequence\r\n            \\[\r\n            [0-?]*  # Parameter bytes\r\n            [ -/]*  # Intermediate bytes\r\n            [@-~]   # Final byte\r\n        )\r\n    \'\'\', re.VERBOSE)\r\n    return ansi_escape.sub(\'\', text)\r\n\r\n\r\n\r\ndef ordinal(n):\r\n    suf = lambda n: "%d%s"%(n,{1:"st",2:"nd",3:"rd"}.get(n if n<20 else n%10,"th"))\r\n    return suf(n)\r\n\r\n\r\ndef back():\r\n    global _bm\r\n    if _bm is None:\r\n        import _rightThumb._bookmarks as _bm\r\n    return _bm.Bookmarks( \'back\' ).get()\r\nfiles_all=[]\r\ndef files( folder, r=0, first=True ):\r\n    global files_all\r\n    if first:\r\n        files_all = []\r\n    if os.path.isdir(folder):\r\n        dirList = os.listdir(folder)\r\n        for item in dirList:\r\n            path = __.path(folder +_v.slash+ item)\r\n            try:\r\n                if os.path.isfile(path):\r\n                    files_all.append(item)\r\n                if r and os.path.isdir(path):\r\n                    files(path,r=1,first=False)\r\n            except Exception as ee:\r\n                print_(path,ee)\r\n    return files_all\r\n\r\ndef f( search=None, path=False,       p=None, s=None, r=False ):\r\n    if not p is None:\r\n        path = p\r\n    if not s is None:\r\n        search = s\r\n    if r:\r\n        path = r\r\n    records = []\r\n    result = None\r\n    for file in files( back() ):\r\n        if search is None:\r\n            if path:\r\n                if r:\r\n                    return __.path(back()+_v.slash+file)\r\n                records.append(__.path(back()+_v.slash+file))\r\n                result = __.path(back()+_v.slash+file)\r\n            else:\r\n                records.append(file)\r\n                result = file\r\n        elif search.lower() in file.lower():\r\n            if path:\r\n                if r:\r\n                    return __.path(back()+_v.slash+file)\r\n                records.append(__.path(back()+_v.slash+file))\r\n                result = __.path(back()+_v.slash+file)\r\n            else:\r\n                records.append(file)\r\n                result = file\r\n    if not path:\r\n        cp( \' \'.join(records), \'darkcyan\' )\r\n    elif path == 1:\r\n        for record in records:\r\n            cp( record, \'darkcyan\' )\r\n    return result\r\n\r\ndef chmod(path):\r\n    if not __.isWin and os.path.isfile(path):\r\n        try:\r\n            os.chmod( path, 0o777 )\r\n        except Exception as e:\r\n            pass\r\n\r\nclass HD:\r\n\r\n    def chmod(path):\r\n        if not __.isWin and os.path.isfile(path):\r\n            try:\r\n                os.chmod( path, 0o777 )\r\n            except Exception as e:\r\n                pass\r\n\r\ndef printDicFields( dic ):\r\n\r\n    global switches\r\n    if switches.isActive(\'TableJSON\'):\r\n        if len(switches.value(\'TableJSON\')):\r\n            saveTable2( dic, switches.values(\'TableJSON\')[0] )\r\n            cp( [ \'saved:\', switches.values(\'TableJSON\')[0] ], \'green\' )\r\n        else:\r\n            # printVarSimple(self.asset)\r\n            print_( d2json(dic) )\r\n        return None\r\n\r\n    for k in dic:\r\n        fields.register( \'dic\', \'field\', str(k)+\':\' )\r\n        fields.register( \'dic\', \'value\', str(dic[k]) )\r\n\r\n    for k in dic:\r\n        print_( fields.value( \'dic\', \'field\', str(k)+\':\', right=True ), fields.value( \'dic\', \'value\', str(dic[k]) ) )\r\n\r\narrow = None\r\n_tz = None\r\npandas = None\r\n_sd = None\r\n\r\ndef isDate( theDate=None, record={}, tz=None, q=True, f=None,w=None,what=None ):\r\n    # record={}\r\n    if (type(theDate) == int or type(theDate) == float) and theDate < 1:\r\n        return 0\r\n    if theDate is None: theDate=time.time();\r\n    if not w is None: f=w;\r\n    if not what is None: f=what;\r\n\r\n    # theDate = autoDate(theDate)\r\n\r\n    # print_(theDate)\r\n    # sys.exit()\r\n\r\n    global _dir\r\n    if _dir is None:\r\n        import _rightThumb._dir as _dir\r\n\r\n    s = time.time()\r\n    # slow from loading pandas\r\n    if not tz is None and not len(tz):\r\n        tz = None\r\n\r\n\r\n\r\n    local_tz = str(time.strftime("%z")).replace(\':\',\'\')\r\n\r\n\r\n    hasTZ = False\r\n    if type(theDate) == str and len(theDate) > 11:\r\n        if theDate[-6:].startswith(\'+\') or theDate[-6:].startswith(\'-\'):\r\n            hasTZ = theDate[-6:].replace(\':\',\'\')\r\n\r\n    if type(theDate) == str and len(theDate) > 11 and type(hasTZ) == bool:\r\n        if theDate[-5:].startswith(\'+\') or theDate[-5:].startswith(\'-\'):\r\n            hasTZ = theDate[-5:].replace(\':\',\'\')\r\n    epoch = autoDate(theDate)\r\n\r\n\r\n\r\n\r\n\r\n    if f==\'dow\':\r\n        dow=_dir.getDOWromEpochText( epoch ).lower()\r\n        dci = {\r\n                \'monday\': \'mon\',\r\n                \'tuesday\': \'tue\',\r\n                \'wednesday\': \'wed\',\r\n                \'thursday\': \'thu\',\r\n                \'friday\': \'fri\',\r\n                \'saturday\': \'sat\',\r\n                \'sunday\': \'sun\',\r\n        }\r\n        if dow in dci:\r\n            return dci[dow]\r\n        return dow\r\n    def fitem(f):\r\n\r\n        if f==\'ago\': return _dir.dateDiffText(epoch);\r\n        if f==\'friendly\': return friendlyDate( epoch );\r\n        if f==\'friendly\': return friendlyDate( epoch );\r\n        if f==\'iso\': return friendlyDate( epoch ).replace( \' \', \'T\' ) + local_tz;\r\n        if f==\'woy\': return _dir.getWeekAndYear( epoch );\r\n        if f==\'month\': return _dir.getMonthFromEpoch( epoch );\r\n        if f==\'epoch\': return epoch;\r\n        if f==\'ordinal\': return datetime.datetime.fromtimestamp( epoch ).toordinal();\r\n        if f==\'text-date\': return datetime.datetime.fromtimestamp( epoch ).strftime(\'%b, %d %Y\');\r\n        if f==\'text-time\': return datetime.datetime.fromtimestamp( epoch ).strftime(\'%I:%M %p\');\r\n        if f==\'text-datetime\': return datetime.datetime.fromtimestamp( epoch ).strftime(\'%b, %d %Y @ %I:%M %p\');\r\n        if f==\'sdate\': return friendlyDate2( epoch );\r\n        if f==\'strip\': return onlyNumbers_strip(friendlyDate( epoch ).split(\' \')[0]);\r\n        if f==\'stript\': return onlyNumbers_strip(friendlyDate( epoch ));\r\n        if f==\'date\': return friendlyDate( epoch ).split(\' \')[0];\r\n        if f==\'time\': return friendlyDate2( epoch ).split(\' \')[1];\r\n        if f==\'fdate\': return friendlyDate( epoch );\r\n        if f==\'month\': return _dir.getMonthFromEpoch( epoch );\r\n        if f==\'year\': return _dir.getYearFromEpoch( epoch );\r\n        if f==\'woy\': return _dir.getWeekAndYear( epoch );\r\n        if f==\'woy2\': return _dir.getWeekAndYear( epoch ).replace(str(_dir.getYearFromEpoch( epoch ))+\'.\',\'\');\r\n        if f==\'ago\': return _dir.dateDiffText( epoch );\r\n        if f==\'days\': return daysDiff(  epoch, time.time()  );\r\n        if f==\'dow\': return _dir.getDOWromEpochText( epoch );\r\n        if f==\'tz\': return local_tz;\r\n        if f in \'crypt-date crypt-time crypt-epoch appID app crypt-pass\'.split(\' \'):\r\n            try:\r\n                import _rightThumb._nID as _nID\r\n                try:\r\n                    # _keychain = regImp( __.appReg, \'keychain\' )\r\n                    # nID_password = _keychain.imp.key(\'nID\')\r\n                    # _nID.mini.password( nID_password )\r\n                    _nID.mini.password( appID_nID_password() )\r\n                    isPass = \'secure\'\r\n                except Exception as e:\r\n                    _nID.mini.password( \'1970\' )\r\n                    isPass = \'unsecure\'\r\n                eee = \'\'\r\n                try:\r\n                    ee = str(record[\'epoch\'])\r\n                    for c in ee:\r\n                        if \'.\' == c:\r\n                            break\r\n                        eee+=c\r\n                except Exception as e:\r\n                    eee=theDate\r\n                    # print_(f,1,\'err:\', e)\r\n                pass\r\n\r\n                if f==\'crypt-date\': return _nID.mini.gen( record[\'strip\'] );\r\n                if f==\'crypt-time\': return _nID.mini.gen( record[\'stript\'] );\r\n                try:\r\n                    if f==\'crypt-epoch\': return _nID.mini.gen( int(eee) );\r\n                    if f==\'appID\' or f==\'app\': return _nID.mini.gen( int(eee) );\r\n                except Exception as e:\r\n                    print_(f,2,\'err:\', e)\r\n                    sys.exit()\r\n                if f==\'crypt-pass\': return isPass;\r\n            except Exception as e:\r\n                print_(f,3,\'err:\',e)\r\n                pass\r\n        if f==\'stardate\':\r\n            try:\r\n                import _rightThumb._stardate as _sd\r\n                return _sd.gen(  epoch  )\r\n            except Exception as e:\r\n                return None\r\n        if f==\'quarter\':\r\n            dt = friendlyDate( epoch ).split(\' \')[0].split(\'-\')\r\n            try:\r\n                return str(record[\'year\']) +\'.\'+ str(pandas.Timestamp(datetime.date( int(dt[0]) , int(dt[1]), int(dt[2]))).quarter)\r\n            except Exception as e:\r\n                return None\r\n        if f==\'true\': return True;\r\n        return None\r\n\r\n\r\n\r\n    #########################################################\r\n    pass\r\n    if f:\r\n        if type(f)==list:\r\n            f=\' \'.join(f)\r\n        f=f.replace(\',\',\' \')\r\n        if not \' \' in f:\r\n            return fitem(f)\r\n        else:\r\n            j={}\r\n            for q in f.split(\' \'):\r\n                j[q] = fitem(q)\r\n            return j\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n    #########################################################\r\n\r\n    # pv(_v.config_hash)\r\n    if \'noarrow\' in _v.config_hash:\r\n        local_tz = \'\'\r\n    else:\r\n        global _tz\r\n        if _tz is None:\r\n            import _rightThumb._tz as _tz\r\n        \r\n        if not type(hasTZ) == bool:\r\n            if not hasTZ == local_tz:\r\n                epoch = _tz.convert( epoch, hasTZ, local_tz )\r\n        if not tz is None and not local_tz == tz:\r\n            epoch = _tz.convert( epoch, local_tz, tz )\r\n            local_tz = tz\r\n\r\n            if \'/\' in tz:\r\n                global arrow\r\n                if arrow is None:\r\n                    import arrow\r\n                utc = arrow.utcnow()\r\n                theDate = str(utc.to(tz))\r\n                hasTZ = False\r\n                if type(theDate) == str and len(theDate) > 11:\r\n                    if theDate[-6:].startswith(\'+\') or theDate[-6:].startswith(\'-\'):\r\n                        hasTZ = theDate[-6:].replace(\':\',\'\')\r\n\r\n                if type(theDate) == str and len(theDate) > 11 and type(hasTZ) == bool:\r\n                    if theDate[-5:].startswith(\'+\') or theDate[-5:].startswith(\'-\'):\r\n                        hasTZ = theDate[-5:].replace(\':\',\'\')\r\n                local_tz = hasTZ\r\n\r\n    \r\n\r\n    if not epoch:\r\n        return record\r\n\r\n    global pandas\r\n    if pandas is None:\r\n        if q:\r\n            try:\r\n                #  pandas  takes .5 seconds to load \r\n                import pandas\r\n            except Exception as e:\r\n                pass\r\n\r\n    ss = time.time()\r\n\r\n    if type(epoch) == str:\r\n        epoch = autoDate(epoch.replace(\'z\',\'\'))\r\n    record[\'ago\'] = _dir.dateDiffText(epoch)\r\n    record[\'epoch\'] = epoch\r\n    # print_( epoch )\r\n    record[\'ordinal\'] = datetime.datetime.fromtimestamp( epoch ).toordinal()\r\n    # sys.exit()\r\n    record[\'text-date\'] = datetime.datetime.fromtimestamp( epoch ).strftime(\'%b, %d %Y\')\r\n    record[\'text-time\'] = datetime.datetime.fromtimestamp( epoch ).strftime(\'%I:%M %p\')\r\n    record[\'text-datetime\'] = datetime.datetime.fromtimestamp( epoch ).strftime(\'%b, %d %Y @ %I:%M %p\')\r\n    record[\'sdate\'] = friendlyDate2( epoch )\r\n    record[\'strip\'] = onlyNumbers_strip(friendlyDate( epoch ).split(\' \')[0])\r\n    record[\'stript\'] = onlyNumbers_strip(friendlyDate( epoch ))\r\n    record[\'date\'] = friendlyDate( epoch ).split(\' \')[0]\r\n    record[\'time\'] = friendlyDate2( epoch ).split(\' \')[1]\r\n    record[\'fdate\'] = friendlyDate( epoch )\r\n    record[\'month\'] = _dir.getMonthFromEpoch( epoch )\r\n    record[\'year\'] = _dir.getYearFromEpoch( epoch )\r\n    record[\'woy\'] = _dir.getWeekAndYear( epoch )\r\n    record[\'woy2\'] = _dir.getWeekAndYear( epoch ).replace(str(_dir.getYearFromEpoch( epoch ))+\'.\',\'\')\r\n    record[\'dow\'] = _dir.getDOWromEpochText( epoch )\r\n    # record[\'ago\'] = _dir.dateDiffText( epoch )\r\n    record[\'days\'] = daysDiff(  epoch, time.time()  )\r\n    record[\'tz\'] = local_tz\r\n    # record[\'iso\'] = datetime.datetime.fromtimestamp( epoch ).isoformat()\r\n    # record[\'iso\'] = datetime.datetime.fromtimestamp( epoch ).replace(microsecond=0).astimezone().isoformat()\r\n    record[\'iso\'] = record[\'fdate\'].replace( \' \', \'T\' ) + record[\'tz\']\r\n    \r\n    # iso 24\r\n    # pv(_v.config_hash)\r\n    global isWin\r\n    if isWin:\r\n        if \'nocrypt\' in _v.config_hash:\r\n            pass\r\n        else:\r\n            try:\r\n                import _rightThumb._nID as _nID\r\n                try:\r\n                    # _keychain = regImp( __.appReg, \'keychain\' )\r\n                    # nID_password = _keychain.imp.key(\'nID\')\r\n                    # _nID.mini.password( nID_password )\r\n                    _nID.mini.password( appID_nID_password() )\r\n                    isPass = \'secure\'\r\n                except Exception as e:\r\n                    _nID.mini.password( \'1970\' )\r\n                    isPass = \'unsecure\'\r\n                eee = \'\'\r\n                ee = str(record[\'epoch\'])\r\n                for c in ee:\r\n                    if \'.\' == c:\r\n                        break\r\n                    eee+=c\r\n                # record[\'crypt-password\'] = nID_password\r\n                record[\'crypt-date\'] = _nID.mini.gen( record[\'strip\'] )\r\n                record[\'crypt-time\'] = _nID.mini.gen( record[\'stript\'] )\r\n                record[\'crypt-epoch\'] = _nID.mini.gen( int(eee) )\r\n                record[\'appID\'] = _nID.mini.gen( int(eee) )\r\n                record[\'crypt-pass\'] = isPass\r\n            except Exception as e:\r\n                pass\r\n\r\n\r\n        try:\r\n            import _rightThumb._stardate as _sd\r\n            record[\'stardate\'] = _sd.gen(  epoch  )\r\n        except Exception as e:\r\n            pass\r\n\r\n        dt = record[\'fdate\'].split(\' \')[0].split(\'-\')\r\n        try:\r\n            record[\'quarter\'] = str(record[\'year\']) +\'.\'+ str(pandas.Timestamp(datetime.date( int(dt[0]) , int(dt[1]), int(dt[2]))).quarter)\r\n        except Exception as e:\r\n            pass\r\n\r\n    e = time.time()\r\n    # print_( e-s )\r\n    # print_( e-ss )\r\n    return record\r\n\r\n\r\ndef onlyNumbers_strip(n):\r\n    n = str(n)\r\n    t = \'\'\r\n    for c in n:\r\n        if c in \'0123456789\':\r\n            t+=c\r\n    return t\r\n\r\n\r\n\r\ndef tfc(c):\r\n    return c.lower().replace(\' \',\'_\')\r\n\r\n\r\n__.table_prefix_padding = 0\r\n\r\n\r\n# loopPrint(__.table_prefix_padding)\r\nchangeC_rc_path = False\r\nchangeDate_Table = None\r\ntouch_meta = None\r\n_dir = None\r\n# woy_hash_table = None\r\n# def woyTrigger( data ):\r\n#   wks=10000\r\n#   global _dir\r\n#   if _dir is None:\r\n#       import _rightThumb._dir as _dir\r\n#   return _dir.woyTrigger(data)\r\nline_length_hash_table = {}\r\n\r\n_vault = None\r\n_blowfish = None\r\npyAesCrypt = None\r\nshutil = None\r\n_md5 = None\r\nreadline = None\r\n\r\nwin32clipboard = None\r\n__.raw_table = None\r\nclass RawTableLength:\r\n    def __init__( self ):\r\n        self.table = []\r\n        self.last = 0\r\n    def table( asset ):\r\n        self.last = len(asset)\r\n        self.table.append(self.last)\r\n    def length( self ):\r\n        return self.last\r\n# def e( asset ):\r\n#   if __.raw_table is None:\r\n#       __.raw_table = RawTableLength()\r\n#   __.raw_table.table( asset )\r\n#   return enumerate(asset)\r\n# def t( asset ):\r\n#   if __.raw_table is None:\r\n#       __.raw_table = RawTableLength()\r\n#   __.raw_table.table( asset )\r\n#   return asset\r\n\r\n# def txtTable( txt ):\r\n#   table = []\r\n#   for x in range(0,len(txt)):\r\n#       table.append(txt[x])\r\n#   return table\r\n\r\n# def txtTableE( txt ):\r\n#   table = []\r\n#   for x in range(0,len(txt)):\r\n#       table.append(txt[x])\r\n#   return enumerate(table)\r\n\r\ndef code( script, addString=None ):\r\n    global _code\r\n    try:\r\n        __.code\r\n    except Exception as e:\r\n        _code = regImp( __.appReg, \'_rightThumb._auditCodeBase\' )\r\n\r\n    return __.code.process( script, addString=addString )\r\n\r\naggregate_trigger_ran = False\r\ndef aggregate_trigger():\r\n    global aggregate_trigger_ran\r\n    if aggregate_trigger_ran:\r\n        return None\r\n    global switches\r\n    if not switches.isActive(\'Aggregate\'):\r\n        return None\r\n    script = \' \'.join( switches.values(\'Aggregate\') )\r\n    __.aggregate.obj.code( script, isSwitch=True )\r\n    \r\n\r\n\r\n\r\nclass AGGREGATE:\r\n    def __init__( self ):\r\n\r\n        self.records = {}\r\n        self.index = {}\r\n        self.columns = dot()\r\n\r\n        self.columns.table = {}\r\n        self.columns.group = {}\r\n        self.columns.eof = {}\r\n\r\n        self.columns.eot = {}\r\n        self.columns.otherQ = {}\r\n        self.columns.other = {}\r\n\r\n        self.switch = dot()\r\n        self.switch.label = \'--sw--c3p0-r2d2-4life--sw--\'\r\n        self.switch.processed = False\r\n        # eof eot eog bog eogA\r\n\r\n        self.functions = dot()\r\n        self.functions.index = {}\r\n        self.other = dot()\r\n        self.other.index = {}\r\n        self.counter = -1\r\n        self.formating = {}\r\n\r\n        self.cache = dot()\r\n        self.cache.records = {}\r\n        self.cache.formating = {}\r\n        self.last = \'{D346F128-1468-481C-A0C8-FF8C6083EE64}\'\r\n        self.lasting = []\r\n    def code( self, script, label=None, isSwitch=False, addSwitch=False, addAll=False ):\r\n        if script is None:\r\n            return None\r\n        # print_()\r\n        # print_( script )\r\n        # sys.exit()\r\n        self.counter += 1\r\n        if isSwitch:\r\n            label = self.switch.label\r\n            if self.switch.processed:\r\n                return self.records[label]\r\n            self.switch.processed = True\r\n        else:\r\n            if label is None:\r\n                label = \'simple-\' + str(self.counter)\r\n\r\n        self.records[label] = []\r\n        records = code( script=script, addString=[[\'alphaParam\',\'?\']]  )\r\n\r\n        # print_(  )\r\n        # print_( records )\r\n        # print_(  )\r\n        # sys.exit()\r\n        # return None\r\n\r\n        indexes = dot()\r\n        indexes.functions = {}\r\n        indexes.table = []\r\n        indexes.group = []\r\n        indexes.eot = []\r\n        indexes.eof = []\r\n        indexes.otherVar = []\r\n        indexes.otherVarQ = []\r\n        indexes.other = []\r\n\r\n        for fXn in __.aggregate.fn.order:\r\n            indexes.functions[fXn] = []\r\n        indexes.functions[\'other\'] = []\r\n        for rec in records:\r\n            # print_(rec)\r\n            if rec[\'status\'] and \'function\' in rec[\'l\']:\r\n                if rec[\'txt\'] in __.aggregate.fn.order:\r\n                    indexes.functions[rec[\'txt\']].append(rec)\r\n                else:\r\n                    indexes.functions[\'other\'].append(rec)\r\n                \r\n            elif rec[\'status\'] and \'variable\' in rec[\'l\']:\r\n                if not \'?\' in rec[\'txt\'] or ( \'?\' in rec[\'txt\'] and not rec[\'txt\'].lower().split(\'?\')[0]+\'?\' in __.aggregate.prefixes):\r\n                    indexes.table.append( rec )\r\n\r\n                elif rec[\'txt\'].startswith(\'eot?\'):\r\n                    indexes.eot.append( rec )\r\n\r\n                elif rec[\'txt\'].startswith(\'eof?\'):\r\n                    indexes.eof.append( rec )\r\n\r\n                elif rec[\'txt\'].startswith(\'eog?\'):\r\n                    indexes.group.append( rec )\r\n\r\n                elif rec[\'txt\'].startswith(\'bog?\'):\r\n                    indexes.group.append( rec )\r\n\r\n                elif rec[\'txt\'].lower().startswith(\'eoga?\'):\r\n                    indexes.group.append( rec )\r\n\r\n                elif \'?\' in rec[\'txt\']:\r\n                    indexes.otherVarQ.append( rec )\r\n\r\n                else:\r\n                    indexes.otherVar.append( rec )\r\n            else:\r\n                indexes.other.append( rec )\r\n        \r\n        tmp_records = []\r\n        for fXn in __.aggregate.fn.order:\r\n            for rec in indexes.functions[ fXn ]:\r\n                tmp_records.append(rec)\r\n\r\n        for rec in indexes.functions[\'other\']:\r\n            tmp_records.append(rec)\r\n\r\n        for rec in indexes.table:\r\n            tmp_records.append(rec)\r\n        \r\n        for rec in indexes.otherVarQ:\r\n            tmp_records.append(rec)\r\n\r\n        for rec in indexes.otherVar:\r\n            tmp_records.append(rec)\r\n\r\n        for rec in indexes.group:\r\n            tmp_records.append(rec)\r\n\r\n        for rec in indexes.eot:\r\n            tmp_records.append(rec)\r\n\r\n        for rec in indexes.eof:\r\n            tmp_records.append(rec)\r\n\r\n\r\n        for rec in indexes.other:\r\n            tmp_records.append(rec)\r\n\r\n        # for rec in tmp_records:\r\n        #   print_(rec)\r\n\r\n        # sys.exit()\r\n\r\n        for rec in tmp_records:\r\n            self.records[label].append(rec)\r\n\r\n\r\n        table = {}\r\n        for i,rec in enumerate( self.records[label] ):\r\n            # print_( rec )\r\n            table[ str(rec[\'i\']) ] = str(self.counter) +\'-\'+ str(i)\r\n            # print_( i, rec )\r\n        # sys.exit()\r\n        for i,rec in enumerate( self.records[label] ):\r\n            self.records[label][i][\'i\'] = str(self.counter) +\'-\'+ str(i)\r\n            # print_( rec[\'i\'], i )\r\n        # sys.exit()\r\n\r\n        for i,rec in enumerate( self.records[label] ):\r\n            if str( rec[\'rent\'] ) in table:\r\n                self.records[label][i][\'rent\'] = table[ str( rec[\'rent\'] ) ]\r\n            if \'args\' in rec:\r\n                args = []\r\n                for ar in rec[\'args\']:\r\n                    if str(ar) in table:\r\n                        args.append( table[str(ar)] )\r\n                self.records[label][i][\'args\'] = args\r\n            if \'p\' in rec:\r\n                self.records[label][i][\'p\'] = table[ str(rec[\'p\']) ]\r\n            if \'val\' in rec:\r\n                self.records[label][i][\'val\'] = table[ str(rec[\'val\']) ]\r\n\r\n\r\n        for i,rec in enumerate(self.records[label]):\r\n            self.index[rec[\'i\']] = rec\r\n\r\n            if rec[\'status\'] and \'function\' in rec[\'l\']:\r\n                self.functions.index[rec[\'i\']] = rec \r\n                \r\n            elif rec[\'status\'] and \'variable\' in rec[\'l\']:\r\n                if not \'?\' in rec[\'txt\'] or ( \'?\' in rec[\'txt\'] and not rec[\'txt\'].lower().split(\'?\')[0]+\'?\' in __.aggregate.prefixes):\r\n                    self.columns.table[rec[\'i\']] = rec\r\n\r\n\r\n\r\n                elif rec[\'txt\'].startswith(\'eot?\'):\r\n                    self.columns.eot[rec[\'i\']] = rec\r\n\r\n                elif rec[\'txt\'].startswith(\'eof?\'):\r\n                    self.columns.eof[rec[\'i\']] = rec\r\n\r\n                elif rec[\'txt\'].startswith(\'eog?\'):\r\n                    self.columns.group[rec[\'i\']] = rec\r\n\r\n                elif rec[\'txt\'].startswith(\'bog?\'):\r\n                    self.columns.group[rec[\'i\']] = rec\r\n\r\n                elif rec[\'txt\'].lower().startswith(\'eoga?\'):\r\n                    self.columns.group[rec[\'i\']] = rec\r\n\r\n                elif \'?\' in rec[\'txt\']:\r\n                    self.columns.otherQ[rec[\'i\']] = rec\r\n\r\n                else:\r\n                    self.columns.other[rec[\'i\']] = rec\r\n            else:\r\n                self.other.index[rec[\'i\']] = rec\r\n\r\n\r\n        # for rec in self.records[label]:\r\n        #   print_( rec )\r\n\r\n        # sys.exit()\r\n\r\n\r\n        self.cache.records[label] = self.records[label]\r\n        self.last = label\r\n        self.lasting = [label]\r\n        # addSwitch addAll\r\n        if addSwitch or addAll:\r\n            return self.build( label=label, addSwitch=addSwitch, addAll=addAll )\r\n\r\n        return self.records[label]\r\n\r\n\r\n    def build( self, label=None, addSwitch=None, addAll=None, s=None ):\r\n        if not s is None:\r\n            addSwitch = s\r\n        if label is None:\r\n            addAll = True\r\n        \r\n        records = []\r\n        toProcess = []\r\n        if addAll:\r\n            for k in self.records:\r\n                toProcess.append(k)\r\n\r\n        elif addSwitch:\r\n            if self.switch.label in self.records:\r\n                toProcess.append(self.switch.label)\r\n\r\n            if label in self.records:\r\n                toProcess.append(label)\r\n                    # print_(rec)\r\n        self.last = \'<?>\'.join(toProcess)\r\n        self.lasting = toProcess\r\n        if self.last in self.cache.records:\r\n            return self.cache.records[self.last]\r\n\r\n\r\n        for lab in toProcess:\r\n            for rec in self.records[lab]:\r\n                records.append(rec)\r\n\r\n\r\n\r\n        # else:\r\n        #   cp( \'Error: AGGREGATE.build() \', \'red\' )\r\n        #   return []\r\n\r\n        indexes = dot()\r\n        indexes.functions = {}\r\n        indexes.table = []\r\n        indexes.group = []\r\n        indexes.eot = []\r\n        indexes.eof = []\r\n        indexes.otherVar = []\r\n        indexes.otherVarQ = []\r\n        indexes.other = []\r\n\r\n        for fXn in __.aggregate.fn.order:\r\n            indexes.functions[fXn] = []\r\n        indexes.functions[\'other\'] = []\r\n        for rec in records:\r\n            # print_(rec)\r\n            if rec[\'status\'] and \'function\' in rec[\'l\']:\r\n                if rec[\'txt\'] in __.aggregate.fn.order:\r\n                    indexes.functions[rec[\'txt\']].append(rec)\r\n                else:\r\n                    indexes.functions[\'other\'].append(rec)\r\n                \r\n            elif rec[\'status\'] and \'variable\' in rec[\'l\']:\r\n                if not \'?\' in rec[\'txt\'] or ( \'?\' in rec[\'txt\'] and not rec[\'txt\'].lower().split(\'?\')[0]+\'?\' in __.aggregate.prefixes):\r\n                    indexes.table.append( rec )\r\n\r\n                elif rec[\'txt\'].startswith(\'eot?\'):\r\n                    indexes.eot.append( rec )\r\n\r\n                elif rec[\'txt\'].startswith(\'eof?\'):\r\n                    indexes.eof.append( rec )\r\n\r\n                elif rec[\'txt\'].startswith(\'eog?\'):\r\n                    indexes.group.append( rec )\r\n\r\n                elif rec[\'txt\'].startswith(\'bog?\'):\r\n                    indexes.group.append( rec )\r\n\r\n                elif rec[\'txt\'].lower().startswith(\'eoga?\'):\r\n                    indexes.group.append( rec )\r\n\r\n                elif \'?\' in rec[\'txt\']:\r\n                    indexes.otherVarQ.append( rec )\r\n\r\n                else:\r\n                    indexes.otherVar.append( rec )\r\n            else:\r\n                indexes.other.append( rec )\r\n        \r\n        tmp_records = []\r\n\r\n        for fXn in __.aggregate.fn.order:\r\n            for rec in indexes.functions[ fXn ]:\r\n                tmp_records.append(rec)\r\n\r\n        for rec in indexes.functions[\'other\']:\r\n            tmp_records.append(rec)\r\n\r\n        for rec in indexes.table:\r\n            tmp_records.append(rec)\r\n        \r\n        for rec in indexes.otherVarQ:\r\n            tmp_records.append(rec)\r\n\r\n        for rec in indexes.otherVar:\r\n            tmp_records.append(rec)\r\n\r\n        for rec in indexes.group:\r\n            tmp_records.append(rec)\r\n\r\n        for rec in indexes.eot:\r\n            tmp_records.append(rec)\r\n\r\n        for rec in indexes.eof:\r\n            tmp_records.append(rec)\r\n\r\n\r\n        for rec in indexes.other:\r\n            tmp_records.append(rec)\r\n        combine_records = []\r\n        for rec in tmp_records:\r\n            combine_records.append(rec)\r\n        \r\n        # print_()\r\n        # # print_( combine_records )\r\n        # print_()\r\n\r\n        # for rec in combine_records:\r\n        #   print_(rec)\r\n\r\n\r\n        # print_( \'   self.last:\', self.last )\r\n        # print_( \'self.lasting:\', self.lasting )\r\n        # sys.exit()\r\n        self.cache.records[self.last] = combine_records\r\n        \r\n        return combine_records\r\n\r\n\r\n    def formatGen( self, label=None, addSwitch=None, addAll=None, s=None ):\r\n        records = self.build( label=label, addSwitch=addSwitch, addAll=addAll, s=s )\r\n\r\n        if self.last in self.cache.formating:\r\n            return self.cache.formating[self.last]\r\n\r\n\r\n        results = []\r\n        for i,rec in enumerate(records):\r\n            if rec[\'status\'] and \'function\' in rec[\'l\'] and \'format\' == rec[\'txt\']:\r\n                rXy = []\r\n                for arg in rec[\'args\']:\r\n                    rXy.append( self.index[arg][\'txt\'] )\r\n                results.append( rXy )\r\n\r\n            if rec[\'status\'] and \'function\' in rec[\'l\'] and rec[\'txt\'] in __.aggregate.fn.format:\r\n                rXy = []\r\n                for arg in rec[\'args\']:\r\n                    rXy.append( self.index[arg][\'txt\'] )\r\n\r\n                rXy.append( __.aggregate.fn.format[rec[\'txt\']] )\r\n                results.append( rXy )\r\n\r\n            if rec[\'status\'] and \'variable\' in rec[\'l\']:\r\n                child = self.index[rec[\'val\']]\r\n                if \'function\' in child[\'l\'] and child[\'txt\'] in __.aggregate.fn.format:\r\n                    # print_( \'here\' )\r\n                    rXy = []\r\n                    if \'?\' in rec[\'txt\'] and rec[\'txt\'].lower().split(\'?\')[0]+\'?\' in __.aggregate.group_prefixes:\r\n                        gc = rec[\'txt\'].split(\'?\')[2]\r\n                        rXy.append( gc )\r\n                    else:\r\n                        rXy.append( rec[\'txt\'] )\r\n\r\n                    rXy.append( __.aggregate.fn.format[child[\'txt\']] )\r\n                    results.append( rXy )\r\n\r\n        formating = {}\r\n        for rXy in results:\r\n            fields = []\r\n            cmds = {}\r\n\r\n            for res in rXy:\r\n                if not res.startswith(\'?\'):\r\n                    fields.append( tfc(res) )\r\n                elif res.startswith(\'?\') and not res.startswith(\'??\') and not res.startswith(\'???\'):\r\n                    last = res\r\n                    if not res in cmds:\r\n                        cmds[res] = {}\r\n                elif res.startswith(\'???\'):\r\n                    cmds[last][last2][res] = {}\r\n                elif res.startswith(\'??\'):\r\n                    last2 = res\r\n                    cmds[last][res] = {}\r\n\r\n            \r\n            for f in fields:\r\n                if not f in formating:\r\n                    formating[f] = {}\r\n                for c in cmds:\r\n                    if not c in formating[f]:\r\n                        formating[f][c] = {}\r\n                    for p in cmds[c]:\r\n                        if not p in formating[f][c]:\r\n                            formating[f][c][p] = {}\r\n                        for pp in cmds[c]:\r\n                            if not pp in formating[f][c][p]:\r\n                                formating[f][c][p][pp] = {}\r\n        # printVarSimple( formating )\r\n        # sys.exit()\r\n        self.cache.formating[self.last] = formating\r\n        pass\r\n        return formating\r\n\r\n    def format( self, fields, data, label=None, addSwitch=None, addAll=None, s=None ):\r\n        formating = self.formatGen( label=label, addSwitch=addSwitch, addAll=addAll, s=s )\r\n        if not type(fields) is list:\r\n            fields = [fields]\r\n        \r\n        try:\r\n            \r\n\r\n\r\n\r\n\r\n            for field in fields:\r\n                f = tfc(field)\r\n                # print_( formating[f] )\r\n                if f in formating:\r\n                    if \'?date1\' in formating[f]:\r\n                        return friendlyDate( data )\r\n                    if \'?date\' in formating[f]:\r\n                        return friendlyDate2( data )\r\n                    if \'?size\' in formating[f]:\r\n                        data = str(data).replace( \',\', \'\' ).replace( \' \', \'\' )\r\n                        # print_(\'here                                               xx\')\r\n                        if formating[f][\'?size\']:\r\n                            fm = list(formating[f][\'?size\'].keys())[0]\r\n                            return reFormatSize( str(data)+fm )\r\n                        \r\n                        # print_( formatSize( int(data) ) )\r\n                        return formatSize( int(data) )\r\n                    if \'?bytes\' in formating[f]:\r\n                        return unFormatSize( data )\r\n        \r\n                    if \'?comma\' in formating[f]:\r\n                        return addComma( data )\r\n\r\n\r\n\r\n        except Exception as e:\r\n            return data\r\n                    \r\n\r\n        \r\n\r\n        return data\r\n\r\n\r\n__.aggregate.obj = AGGREGATE()\r\n\r\ndef autoWrapText( text, length=None, txt=False, prefix=\'\', breakOn=None, pre_skip_0=False ):\r\n    if type(prefix) == int:\r\n        n = \'\'\r\n        i=0\r\n        while i < prefix:\r\n            n += \' \'\r\n            i+=1\r\n        prefix=n\r\n    if length is None:\r\n        length = __.terminal.cols-5\r\n    # -copy\r\n    if not pre_skip_0:\r\n        length = length - len(prefix)\r\n    text = str(text)\r\n    if len(text) <= length:\r\n        if not pre_skip_0:\r\n            return prefix+text\r\n        else:\r\n            return text\r\n    if breakOn is None:\r\n        breakAfter = \' ,;(+)\\\\/.?*&@!_{-}:=`"<~>\\\'| !"#$%&\\\'()*+,-./:;<=>?@[\\\\]^_`{|}~ \\t\\n\\r\\x0b\\x0c\'\r\n    else:\r\n        breakAfter = breakOn\r\n    broken = []\r\n    parts = []\r\n    flag = None\r\n    i = 0\r\n    last = -1\r\n    ii = 0\r\n    while i <= len(text)-1:\r\n        ii+=1\r\n        if text[i] in breakAfter:\r\n            flag = i\r\n        if ii > length:\r\n            if not flag is None:\r\n                prt = text[ last+1 : flag+1 ]\r\n                i = flag\r\n                last = flag\r\n            else:\r\n                prt = text[ last+1 : i ]\r\n                last = i-1\r\n            if pre_skip_0 and not parts:\r\n                parts.append(prt)\r\n            else:\r\n                parts.append(prefix+prt)\r\n            flag = None\r\n            ii=0\r\n        i+=1\r\n    if not last == i:\r\n        prt = text[ last+1 : i ]\r\n        if pre_skip_0 and not parts:\r\n            parts.append(prt)\r\n        else:\r\n            parts.append(prefix+prt)\r\n\r\n    if txt:\r\n        return \'\\n\'.join(parts)\r\n\r\n    return parts\r\n\r\ndef which(file):\r\n    for path in os.environ["PATH"].split(os.pathsep):\r\n        if os.path.exists(os.path.join(path, file)):\r\n                return os.path.join(path, file)\r\n\r\n    return None\r\n\r\n\r\npyperclip = None\r\ndef setClip(data):\r\n    global pyperclip\r\n    if pyperclip is None:\r\n        import pyperclip\r\n    pyperclip.copy( stripColor(cleanString(data)) )\r\ndef getClip():\r\n    global pyperclip\r\n    if pyperclip is None:\r\n        import pyperclip\r\n    return cleanString( pyperclip.paste() )\r\n\r\ndef cleanString(data):\r\n    data = cleanStringA(data)\r\n    data = cleanStringA(data)\r\n    data = cleanStringA(data)\r\n    data = cleanStringA(data)\r\n    data = cleanStringA(data)\r\n    return data\r\n\r\ndef cleanStringA(data):\r\n    data = _str.cleanBE(data,\'\\r\')\r\n    data = _str.cleanBE(data,\'\\n\')\r\n    data = _str.cleanBE(data,\'\\r\')\r\n    data = _str.cleanBE(data,\'\\t\')\r\n    data = _str.cleanBE(data,\' \')\r\n    return data\r\n\r\n\r\ndef path2url(path):\r\n    import pathlib\r\n    return pathlib.Path(os.path.abspath(path)).as_uri()\r\n\r\ndef autoComplete( table, prompt=\'> \' ):\r\n    tableX = []\r\n    for x in table:\r\n        x = x.replace( \' \', \'_\' )\r\n        x = x.replace( \'@\', \'-AT-\' )\r\n        tableX.append(x)\r\n\r\n\r\n\r\n    global readline\r\n    if readline is None:\r\n        import readline\r\n\r\n    # addrs = [\'angela_domain.com\', \'angela_gmail.com\', \'michael@domain.com\', \'david@test.com\']\r\n\r\n    def completer(text, state):\r\n        options = [x for x in tableX if x.startswith(text)]\r\n        try:\r\n            return options[state]\r\n        except IndexError:\r\n            return None\r\n\r\n    readline.set_completer(completer)\r\n    readline.parse_and_bind("tab: complete")\r\n    result = input( prompt )\r\n\r\n    found = []\r\n    for x in result.split(\' \'):\r\n        if x in tableX:\r\n            found.append( table[tableX.index(x)] )\r\n        else:\r\n            found.append( x )\r\n\r\n    return found\r\n\r\n\r\n\r\n\r\ndef getCryptTable( theFile, db=False, bank=False, index=False, temp=False, free=False, password=None ):\r\n    if os.path.isfile(theFile): vv.opened_file_me[theFile] = os.path.getmtime( theFile );\r\n    simplejson = __.imp(\'simplejson\')\r\n    global _vault\r\n    global shutil\r\n    global _md5\r\n    global pyAesCrypt\r\n    if _md5 is None:\r\n        import _rightThumb._md5 as _md5\r\n    if shutil is None:\r\n        import shutil\r\n    if pyAesCrypt is None:\r\n        import pyAesCrypt\r\n    if password is None:\r\n        if _vault is None:\r\n            import _rightThumb._vault as _vault\r\n        password =  _md5.md5( _vault.key() )\r\n\r\n    the_temp_file = _v.stmp +_v.slash+ \'_-cryptTable-\'+genUUID()\r\n\r\n    # defaults to myTables\r\n\r\n    if free:\r\n        file0 = theFile\r\n    elif temp:\r\n        file0 = _v.stmp + _v.slash + theFile\r\n    elif db or bank:\r\n        file0 = _v.dbTables + _v.slash + theFile\r\n    elif index:\r\n        file0 = _v.myIndexes + _v.slash + theFile\r\n    else:\r\n        file0 = _v.myTables + _v.slash + theFile\r\n\r\n\r\n    if not os.path.isfile(file0):\r\n        file0 = theFile\r\n    if os.path.isfile(file0):\r\n        bufferSize = 64 * 1024\r\n        encFileSize = os.stat(  file0  ).st_size\r\n        with open(  file0, \'rb\'  ) as fIn:\r\n            try:\r\n                with open(  the_temp_file , \'wb\'  ) as fOut:\r\n                    # decrypt file stream\r\n                    pyAesCrypt.decryptStream(fIn, fOut, password, bufferSize, encFileSize)\r\n            except ValueError:\r\n                print_(\'Err:\', 0)\r\n                if os.path.isfile( the_temp_file ):\r\n                    print_(\'Err:\', 1)\r\n                    os.remove( the_temp_file )\r\n                    time.sleep(.2)\r\n\r\n\r\n        # print_( \'theFile\', theFile )\r\n        # print_( \'file0\', file0 )\r\n        # import bigjson\r\n        with open(the_temp_file,\'r\', encoding="latin-1") as json_file:\r\n            json_data = simplejson.load(json_file)\r\n        \r\n        shutil.copyfile( file0, the_temp_file )\r\n        os.unlink(the_temp_file)\r\n        \r\n        return json_data\r\n\r\n\r\n\r\n        # with open( file0, \'rb\' ) as f:\r\n            # json_data = bigjson.load(f)\r\n            # json_data = bigjson.load(json_file)\r\n            # json_data = json.load(json_file, object_pairs_hook=OrderedDict)\r\n    else:\r\n        return __.data_default(file=theFile,default=[]).default()\r\n\r\n\r\n\r\ndef saveCryptTable( rows, theFile, db=False, bank=False, index=False, temp=False, free=False, indentCode=True, sort_keys=False, archive=False, p=1, password=None, me=0 ):\r\n    HD.chmod(theFile)\r\n\r\n    simplejson = __.imp(\'simplejson\')\r\n    global _vault\r\n    global shutil\r\n    global _md5\r\n    global pyAesCrypt\r\n    if _md5 is None:\r\n        import _rightThumb._md5 as _md5\r\n    if shutil is None:\r\n        import shutil\r\n    if pyAesCrypt is None:\r\n        import pyAesCrypt\r\n    if password is None:\r\n        if _vault is None:\r\n            import _rightThumb._vault as _vault\r\n        password =  _md5.md5( _vault.key() )\r\n\r\n    the_temp_file = _v.stmp +_v.slash+ \'_-cryptTable-\'+genUUID()\r\n\r\n\r\n\r\n    # defaults to myTables\r\n    px = \'\'\r\n    if theFile.startswith(\'temp\'+_v.slash):\r\n        theFile = theFile.replace( \'temp\'+_v.slash, \'\' )\r\n        file0 = _v.stmp + _v.slash + theFile\r\n        px = file0\r\n    elif db or bank:\r\n        theFile = _v.dbTables + _v.slash + theFile\r\n        px = theFile\r\n    elif index:\r\n        theFile = _v.myIndexes + _v.slash + theFile\r\n        px = theFile\r\n    elif free:\r\n            file0 = theFile\r\n            px = theFile\r\n    else:\r\n        if not temp:\r\n            file0 = _v.myTables + _v.slash + theFile\r\n            px = theFile\r\n        else:\r\n            file0 = _v.stmp + _v.slash + theFile\r\n            px = file0\r\n\r\n    if indentCode:\r\n        dataDump = simplejson.dumps(rows, indent=4, sort_keys=sort_keys)\r\n    else:\r\n        dataDump = simplejson.dumps(rows)\r\n    \r\n    if archive:\r\n        import _rightThumb._md5 as _md5\r\n\r\n        theFileLabel = theFile\r\n        if _v.slash in theFileLabel:\r\n            global appInfo\r\n            tfl = theFileLabel.split(_v.slash)\r\n            tfl.reverse()\r\n            theFileLabel = str(appInfo[__.appReg][\'liveAppName\']) + \'__\' + tfl[0]\r\n        theFileLabel = theFileLabel.replace( \'.json\', \'\' )\r\n        theFileLabel = theFileLabel.replace( \'.JSON\', \'\' )\r\n\r\n        lastMD5 = None\r\n        if os.path.isfile( file0 ):\r\n            lastMD5 = _md5.md5File( file0 )\r\n\r\n            backupFile = _v.stmp + _v.slash+\'__archive_temp__\' + theFileLabel + \'__\' + genUUID() + \'.json\'\r\n            \r\n\r\n\r\n\r\n\r\n\r\n    f = open(the_temp_file,\'w\')\r\n    f.write( str(dataDump) )\r\n    f.close()\r\n    HD.chmod(theFile)\r\n    bufferSize = 64 * 1024\r\n    # encFileSize = os.stat(  file0  ).st_size\r\n    with open( the_temp_file, \'rb\' ) as fIn:\r\n        with open( file0 , \'wb\' ) as fOut:\r\n            pyAesCrypt.encryptStream(fIn, fOut, password, bufferSize)\r\n    \r\n    shutil.copyfile( file0, the_temp_file )\r\n    os.unlink(the_temp_file)\r\n\r\n    if archive:\r\n        shouldDocument = False\r\n\r\n        if os.path.isfile( file0 ):\r\n            thisMD5 = _md5.md5File( file0 )\r\n        if lastMD5 is None:\r\n            shouldDocument = True\r\n        else:\r\n            if not lastMD5 == thisMD5:\r\n                shouldDocument = True\r\n\r\n        if not shouldDocument:\r\n            if os.path.isfile( backupFile ):\r\n                os.remove( backupFile )\r\n        \r\n        if shouldDocument:\r\n            md5Table = getTable( \'table_archive_log.json\' )\r\n            found = False\r\n            for i,record in enumerate(md5Table):\r\n                if theFileLabel == record[\'name\']:\r\n                    found = True\r\n\r\n            theFileLabel\r\n            theFile\r\n            fileDate( theData )\r\n\r\n\r\n    if p:\r\n        printBold(\'Saved: \' + px, \'blue\')\r\n    if me and theFile in vv.opened_file_me: changeM( theFile, vv.opened_file_me[theFile] );\r\n    return file0\r\n\r\n\r\n\r\ndef hex2ascii( hx ):\r\n    if type(hx) == str:\r\n        hx = hx.replace(\' \',\'\')\r\n        return \'\'.join([chr(int(\'\'.join(c), 16)) for c in zip(hx[0::2],hx[1::2])])\r\n\r\n    elif not type(hx) == str:\r\n        print_(\'hex2ascii error\')\r\n        sys.exit()\r\n\r\n\r\n\r\ndef loopPrint(  length=5, txt=\' \', p=0 ):\r\n    if not length:\r\n        return \'\'\r\n    i=0\r\n    result = \'\'\r\n    while not i == length:\r\n        result += txt\r\n        i+=1\r\n    if p:\r\n        print_(result)\r\n    return result\r\n\r\nlp = loopPrint\r\ndef linePrint(  label=None, text=None, txt=\'_\', mn=50, add=5, p=2, c=\'\', x=None,pre=\'\',length=None, center=None ):\r\n    color=c\r\n    if not length is None:\r\n        mn=length\r\n    ln = mn\r\n    if text is None and label is None:\r\n        if length is None and __.terminal.width:\r\n            ln = __.terminal.width\r\n            add = 0\r\n\r\n    if not x is None:\r\n        ln=int(ln*x)\r\n    if not label is None:\r\n        global line_length_hash_table\r\n        if not label in line_length_hash_table:\r\n            line_length_hash_table[label] = ln\r\n        else:\r\n            ln = line_length_hash_table[label]\r\n        if not text is None:\r\n            if not p == True and not p == 1:\r\n                p = 0\r\n            if type(text) == str:\r\n                t = len( str(text) )\r\n                if t > ln:\r\n                    ln = t\r\n                    line_length_hash_table[label] = ln\r\n            elif type(text) == list:\r\n                for texty in text:\r\n                    t = len( str(texty) )\r\n                    if t > ln:\r\n                        ln = t\r\n                        line_length_hash_table[label] = ln\r\n\r\n    if not center is None:\r\n        if not ln % 2==0:\r\n            ln-=1\r\n        ln=ln/2\r\n\r\n    if text is None and ln > 0:\r\n        i = 0\r\n        result = \'\'\r\n        if add:\r\n            add+=1\r\n        ln += add\r\n        # while not i == ln:\r\n        #     result += txt\r\n        #     i+=1\r\n\r\n\r\n        r=[]\r\n        # while not i == ln:\r\n        while len(result) < ln:\r\n            result += txt\r\n            r.append(txt)\r\n            i+=1\r\n        if len(result) > ln:\r\n            r.pop(0)\r\n            result=\'\'.join(r)\r\n        res=\'\'\r\n        for i,r in enumerate(result):\r\n            try:\r\n                res+=pre[i]\r\n            except Exception as e:\r\n                res+=result[i]\r\n        result=res\r\n\r\n\r\n        if not center is None:\r\n            result = result+\' \'+center+\' \'+result\r\n\r\n\r\n\r\n\r\n        if p:\r\n            if color:\r\n                cp( result, color )\r\n            else:\r\n                print_( result )\r\n        if color:\r\n            result=cp( result, color, p=0 )\r\n        return result\r\n\r\n\r\n\r\ndef dic_key_sort( table, n=False ):\r\n    saveTable( table, \'-tmp-dic_key_sort.json\', tableTemp=True, printThis=False,  sort_keys=True )\r\n    return getTable( \'-tmp-dic_key_sort.json\', tableTemp=True )\r\n    # dataDump = json.dumps(table, indent=4, sort_keys=True)\r\n    # print_(dataDump)\r\n    # sys.exit()\r\n    # return json.load( str(dataDump) )\r\n\r\n\r\n\r\ndef dic_key_sort2( table, n=False, ip=False, r=False ):\r\n\r\n\r\n    keys = list( table.keys() )\r\n    dic = {}\r\n    theData = []\r\n    if ip:\r\n        fields.register( \'cnt-ip\', \'val\', 7, m=3 )\r\n        for x in keys:\r\n\r\n            if not x.count(\'.\') == 3:\r\n                theData.append( x )\r\n            else:\r\n                zZz = []\r\n\r\n                for y in x.split(\'.\'):\r\n                    xXx = fields.padZeros( \'cnt-ip\', \'val\', int(y) )\r\n                    # print_(xXx)\r\n\r\n                    zZz.append( xXx )\r\n                theData.append( \'.\'.join(zZz) )\r\n        theData.sort()\r\n        if r:\r\n            theData.reverse()\r\n        for x in theData:\r\n            y = \'\'\r\n            zZz = []\r\n            if not x.count(\'.\') == 3:\r\n                y = x\r\n            elif x.count(\'.\') == 3:\r\n                for y in x.split(\'.\'):\r\n                    # print_(y)\r\n                    zZz.append( str(int(y)) )\r\n                y = \'.\'.join(zZz)\r\n                # print_(y)\r\n            if y in table:\r\n                dic[y] = table[y]\r\n        # print_(theData)\r\n        # printVarSimple(dic)\r\n        # print_()\r\n        return dic\r\n\r\n\r\n\r\n    if not n:\r\n        keys.sort()\r\n        if r:\r\n            keys.reverse()\r\n\r\n        for x in keys:\r\n            dic[x] = table[x]\r\n        return dic\r\n    else:\r\n        nKeys = []\r\n        fields.register( \'cnt-n\', \'val\', 7, m=40 )\r\n        for k in keys:\r\n            nKeys.append(  fields.padZeros( \'cnt-n\', \'val\', int(k) )  )\r\n        nKeys.sort()\r\n        if r:\r\n            nKeys.reverse()\r\n\r\n        for x in nKeys:\r\n            dic[  str(int(x))  ] = table[str(int(x))]\r\n        return dic\r\ndef isCrypt(filepath):\r\n    if " ".join([\'{:02X}\'.format(byte) for byte in     open( filepath, \'rb\' ).read(32)    ]).startswith( \'41 45 53 02 00 00 1B\' ):\r\n        return True\r\n    else:\r\n        return False\r\n\r\ndef isGz(filepath):\r\n    if " ".join([\'{:02X}\'.format(byte) for byte in     open( filepath, \'rb\' ).read(32)    ]).startswith( \'1F 8B 08 08\' ):\r\n        return True\r\n    else:\r\n        return False\r\n\r\ndef isBz2(filepath):\r\n    if " ".join([\'{:02X}\'.format(byte) for byte in     open( filepath, \'rb\' ).read(32)    ]).startswith( \'42 5A 68\' ):\r\n        return True\r\n    else:\r\n        return False\r\n\r\n\r\nisTar = dot()\r\nisTar.gz = isGz\r\nisTar.bz2 = isBz2\r\n\r\ndef sdFile(f):\r\n    return secureDeleteFile(f)\r\n\r\ndef secureDeleteFile(f):\r\n    result = -1\r\n    if os.path.isfile(f):\r\n        result = 0\r\n        try:\r\n            saveText( zeros(f), f )\r\n            result = 1\r\n        except Exception as e:\r\n            pass\r\n\r\n        try:\r\n            os.remove(f)\r\n            result = 2\r\n        except Exception as e:\r\n            pass\r\n    if not result == 2:\r\n        colorThis( [ \'Error: secureDeleteFile\', result ], \'red\' )\r\n\r\n    return result\r\n\r\ndef zeros2(n,c):\r\n    result = \'\'\r\n    a = len(str(n))\r\n    while not len(result)+a == c:\r\n        result += \'0\'\r\n    result += str(n)\r\n    return result\r\n\r\ndef zeros(n,z=\'0\'):\r\n    if os.path.isfile(fIn):\r\n        n = os.stat(  f  ).st_size\r\n\r\n    if not type(n) == int:\r\n        colorThis( "zeros(n,z=\'0\')", \'red\' )\r\n        sys.exit()\r\n    x=\'\'\r\n    x+=z\r\n    x+=z\r\n    if n == 0:\r\n        return x\r\n    while not len(x) == n:\r\n        x+=z\r\n    x+=z\r\n    x+=z\r\n    return x\r\n\r\ndef replaceFile( fIn, fOut ):\r\n    if _v.slash in fOut:\r\n        return fOut\r\n\r\n    if fIn == fOut:\r\n        return fOut\r\n\r\n    if os.path.isfile(fIn):\r\n        fIn = os.path.abspath( fIn )\r\n\r\n    if not _v.slash in fIn:\r\n        return fOut\r\n\r\n    parts = fIn.split(_v.slash)\r\n    parts.reverse()\r\n    parts.pop(0)\r\n    parts.reverse()\r\n    return _v.slash.join( parts )+_v.slash+fOut\r\n\r\ndef patternDiff(a,b):\r\n    # print_(\'here\')\r\n    # a = \'gensslkey\'\r\n    # b = \'gensslkey\'\r\n    # b = \'gensslkeyz\'\r\n    # b = \'ssl_socket_bridge_client_user_administrator_logs_b\'\r\n    a = a.lower()\r\n    b = b.lower()\r\n    testing = 0\r\n\r\n    if testing:\r\n        print_()\r\n        print_()\r\n        print_(\'________________________________________________________\')\r\n        print_()\r\n        print_()\r\n        print_( a,b )\r\n    x = patternMatch( a, b )\r\n    d = get_change( len(a),len(b) )\r\n    e = get_change( x, d )\r\n    # e = get_change( d, x )\r\n    if testing:\r\n        print_(\'x\',x)\r\n        print_( \'d\',d )\r\n        print_( \'e,f\',e )\r\n    f = int(100-e)\r\n    f =e\r\n    # print_( \'f\',f )\r\n    if f == 0:\r\n        f = 100\r\n    # dd = d\r\n    dd = int(100-d)\r\n    if dd == 0:\r\n        dd = 100\r\n    if testing:\r\n        print_( \'dd\',dd )\r\n    # if d <= f:\r\n    if d >= f:\r\n        aa = dd\r\n        bb = f\r\n    else:\r\n        aa = f\r\n        bb = dd\r\n    alphaTest = \'b\'\r\n    if alphaTest == \'a\':\r\n        kAA = {}\r\n        kAB = {}\r\n        kBA = {}\r\n        kBB = {}\r\n        for ch0 in a:\r\n            if not ch0 in kAA:\r\n                kAA[ch0] = 0\r\n                kAB[ch0] = 0\r\n            if ch0 in b:\r\n                kAA[ch0] += 1\r\n                for ch1 in b:\r\n                    kAB[ch0] += 1\r\n\r\n        for ch0 in b:\r\n            if not ch0 in kBA:\r\n                kBA[ch0] = 0\r\n                kBB[ch0] = 0\r\n            if ch0 in a:\r\n                kBA[ch0] += 1\r\n                for ch1 in a:\r\n                    kBB[ch0] += 1\r\n\r\n\r\n        theSetA = []\r\n        theSetB = []\r\n        for kk in kAA:\r\n            theSetA.append( percentageDiffIntAuto( kAA[kk], kAB[kk] ) )\r\n        for kk in kAA:\r\n            try:\r\n                theSetB.append( percentageDiffIntAuto( kBA[kk], kBB[kk] ) )\r\n            except Exception as e:\r\n                print_()\r\n                sys.exit()\r\n\r\n        # pp = av(theSet)\r\n        pA = av(theSetA)\r\n        pB = av(theSetB)\r\n\r\n    elif alphaTest == \'b\':\r\n        tA = 0\r\n        tB = 0\r\n        for ch0 in a:\r\n            if ch0 in b:\r\n                tA += 1\r\n\r\n        for ch0 in b:\r\n            if ch0 in a:\r\n                tB += 1\r\n        pA = percentageDiffIntAuto( tA, len(a) )\r\n        pB = percentageDiffIntAuto( tB, len(b) )\r\n\r\n    if testing:\r\n        print_( \'pA\', pA )\r\n        print_( \'pB\', pB )\r\n\r\n    zz = xMultiply(  [aa,100], [bb,0]  )\r\n    if zz > 100:\r\n        zz = xMultiply(  [bb,100], [aa,0]  )\r\n\r\n    if testing:\r\n        print_([aa,100], [bb,0])\r\n        print_(  \'diff\', zz )\r\n        print_( [aa,bb, pA,pB] )\r\n        print_(  \'av\', av([aa,bb, pA,pB])  )\r\n    ww = av([aa,bb, pA,pB])\r\n    # if pA > pB:\r\n    #   if pA < ww\r\n    # print_( int(ww), [aa,bb, pA,pB], a, b,  )\r\n    return ww\r\n\r\ndef av( ds ):\r\n    total = 0\r\n    for x in ds:\r\n        total+=x\r\n    return total / len(ds)\r\n\r\ndef xMultiply( a, b ):\r\n    fail = False\r\n    if not type(a) == list or not type(b) == list or not len(a) == 2 or not len(b) == 2:\r\n        fail=True\r\n\r\n    if not b[1]:\r\n        z = (a[1] * b[0]) / a[0]\r\n    elif not b[0]:\r\n        z = (a[0] * b[1]) / a[1]\r\n    elif not a[1]:\r\n        z = (a[0] * b[1]) / a[0]\r\n    elif not a[0]:\r\n        z = (a[1] * b[0]) / a[1]\r\n    else:\r\n        fail=True\r\n    if fail:\r\n        colorThis( \'Error: xMultiply\' )\r\n        colorThis( \'\\texpected:\', \'yellow\' )\r\n        colorThis( [\'\\t\\t\', str([960,540]), str([480,0])], \'yellow\' )\r\n        colorThis( \'\\t\\t         or\' )\r\n        colorThis( [\'\\t\\t\', str([960,540]), str([0,270])], \'yellow\' )\r\n        colorThis( \'\\t\\t         or\' )\r\n        colorThis( [\'\\t\\t\', str([480,270]), str([960,0])], \'yellow\' )\r\n        colorThis( \'\\t\\t         or\' )\r\n        colorThis( [\'\\t\\t\', str([480,270]), str([0,540])], \'yellow\' )\r\n        colorThis( \'fail\' )\r\n        sys.exit()\r\n    if str(z).endswith(\'.0\'):\r\n        return int(z)\r\n    else:\r\n        return z\r\n\r\n\r\ndef get_change(current, previous):\r\n\r\n    if current == previous:\r\n        return 100.0\r\n\r\n    if current < previous:\r\n        c = current\r\n        p = previous\r\n    else:\r\n        p = current\r\n        c = previous     \r\n\r\n    try:\r\n        return (abs(c - p) / p) * 100.0\r\n    except ZeroDivisionError:\r\n        return 0\r\n\r\n\r\ndef days_math( epoch, days=1, do=\'+\'):\r\n    if do == \'+\':\r\n        now = autoDate( friendlyDate( autoDate(epoch) ).split(\' \')[0] ) + (  86400*days  )\r\n    elif do == \'-\':\r\n        now = autoDate( friendlyDate( autoDate(epoch) ).split(\' \')[0] ) - (  86400*days  )\r\n    else:\r\n        print_(\'Error: \', "days_math( epoch, days=1, do=\'+\')")\r\n        sys.exit()\r\n    tdy0 = autoDate(friendlyDate( now ).split(\' \')[0])\r\n    return tdy0\r\n\r\n\r\ndef time_ago(epoch):\r\n    return dateDiffText( epoch )\r\n    global _dir\r\n    if _dir is None:\r\n        import _rightThumb._dir as _dir\r\n    return _dir.time_diff(autoDate(epoch))\r\n\r\ndef time_diff(epoch):\r\n    return dateDiffText( epoch )\r\n    global _dir\r\n    if _dir is None:\r\n        import _rightThumb._dir as _dir\r\n    return _dir.time_diff(autoDate(epoch))\r\n\r\ndef printText(text,p=1):\r\n    result = str([text])[2:][:-2]\r\n    if p:\r\n        print_( result )\r\n    return result\r\n\r\n\r\n\r\ndef changeM( path, stampM, stampA=None, meta=False, p=0 ):\r\n    if p:\r\n        mn = \'\'\r\n        if time_diff(stampM) == \'today\':\r\n            mn = \', \'+str(int((time.time() - stampM) /60)) + \' min\'\r\n            if mn == \'0 min\':\r\n                mn = \', just now\'\r\n        print_( friendlyDate(stampM), colorThis( [time_diff(stampM)+ mn], \'yellow\', p=0 ), path )\r\n    if stampA is None:\r\n        stampA = stampM\r\n    # print_(stampM)\r\n    # print_(stampA)\r\n    global changeDate_Table\r\n    global _dir\r\n    global touch_meta\r\n\r\n\r\n\r\n    if _dir is None:\r\n        import _rightThumb._dir as _dir\r\n\r\n    if meta:\r\n        touch_meta = getTable( \'touch.meta\' )\r\n        if not path in touch_meta:\r\n            touch_meta[path] = {}\r\n        if not \'epoch\' in touch_meta[path]:\r\n            touch_meta[path][\'epoch\'] = {}\r\n        touch_meta[path][\'epoch\'][\'me\'] = stampM\r\n        touch_meta[path][\'epoch\'][\'ae\'] = stampA\r\n        saveTable( touch_meta, \'touch.meta\', p=0 )\r\n\r\n    if not meta:\r\n        if changeDate_Table is None:\r\n            changeDate_Table = getTable( \'touch.index\' )\r\n        try:\r\n            path = os.path.abspath(path)\r\n        except Exception as e:\r\n            pass\r\n        if os.path.isfile(path):\r\n            if not path in changeDate_Table:\r\n                changeDate_Table[path] = _dir.info(path)\r\n                saveTable( changeDate_Table, \'touch.index\', p=0 )\r\n            try:\r\n                os.utime(path,(stampA, stampM))\r\n            except Exception as e:\r\n                pass\r\ndef changeC( path, stampC, meta=False, p=0 ):\r\n    if p:\r\n        mn = \'\'\r\n        if time_diff(stampC) == \'today\':\r\n            mn = str(int((time.time() - stampC) /60)) + \' min\'\r\n        print_( friendlyDate(stampC), colorThis( [time_diff(stampC), mn], \'yellow\', p=0 ), path )\r\n    global changeC_rc_path\r\n    global changeDate_Table\r\n    global _dir\r\n    global touch_meta\r\n\r\n    if _dir is None:\r\n        import _rightThumb._dir as _dir\r\n\r\n\r\n\r\n    if meta:\r\n        touch_meta = getTable( \'touch.meta\' )\r\n        if not path in touch_meta:\r\n            touch_meta[path] = {}\r\n        if not \'epoch\' in touch_meta[path]:\r\n            touch_meta[path][\'epoch\'] = {}\r\n        touch_meta[path][\'epoch\'][\'ce\'] = stampC\r\n        saveTable( touch_meta, \'touch.meta\', p=0 )\r\n\r\n\r\n\r\n\r\n    if not meta:\r\n        if changeDate_Table is None:\r\n            changeDate_Table = getTable( \'touch.index\' )\r\n\r\n        if not changeC_rc_path:\r\n            PowerShell_bashrc_name_break()\r\n        # return None\r\n        try:\r\n            path = os.path.abspath(path)\r\n        except Exception as e:\r\n            pass\r\n        if os.path.isfile(path):\r\n            import subprocess\r\n            if not path in changeDate_Table:\r\n                changeDate_Table[path] = _dir.info(path)\r\n                saveTable( changeDate_Table, \'touch.index\', p=0 )\r\n            # if __.isWin:\r\n            #   do = [\'powershell.exe\', \'$(Get-Item "\'+path+\'").CreationTime=("\'+modify_timestamp(stampC)+\'")\']\r\n            #   print_(do)\r\n            #   # p = subprocess.Popen([do], stdout=sys.stdout)\r\n            #   p = subprocess.Popen([\'powershell.exe\', \'$(Get-Item "\'+path+\'").CreationTime=("\'+modify_timestamp(stampC)+\'")\'], stdout=sys.stdout)\r\n            try:\r\n\r\n                if __.isWin:\r\n                    if os.path.isdir( \'C:\\\\Windows\\\\System32\\\\WindowsPowerShell\' ):\r\n                        # do = [\'powershell.exe\', \'$(Get-Item "\'+path+\'").CreationTime=("\'+modify_timestamp(stampC)+\'")\']\r\n                        # print_( do )\r\n                        # p = subprocess.Popen([do], stdout=sys.stdout)\r\n                        p = subprocess.Popen([\'powershell.exe\', \'$(Get-Item "\'+path+\'").CreationTime=("\'+modify_timestamp(stampC)+\'")\'], stdout=sys.stdout)\r\n                else:\r\n                    return None\r\n                    if os.path.isfile(\'/snap/bin/pwsh\'):\r\n                        p = subprocess.Popen([\'/snap/bin/pwsh\', \'$(Get-Item "\'+path+\'").CreationTime=("\'+modify_timestamp(stampC)+\'")\'], stdout=sys.stdout)\r\n                    elif os.path.isfile(\'/usr/bin/pwsh\'):\r\n                        p = subprocess.Popen([\'/usr/bin/pwsh\', \'$(Get-Item "\'+path+\'").CreationTime=("\'+modify_timestamp(stampC)+\'")\'], stdout=sys.stdout)\r\n                    elif os.path.isfile(\'/opt/pwsh\'):\r\n                        p = subprocess.Popen([\'/opt/pwsh\', \'$(Get-Item "\'+path+\'").CreationTime=("\'+modify_timestamp(stampC)+\'")\'], stdout=sys.stdout)\r\n            except Exception as e:\r\n                colorThis( path, \'red\' )\r\n                time.sleep(.5)\r\n                pass\r\n\r\ndef modify_timestamp( stamp ):\r\n    d = friendlyDate(stamp).replace(\'-\',\'/\')\r\n    parts = d.split(\' \')\r\n    day = parts[0]\r\n    tip = parts[1].split(\':\')\r\n    \r\n    if int(tip[0]) > 12:\r\n        tip[0] = int(tip[0]) - 12\r\n        ap = \'PM\'\r\n    else:\r\n        ap = \'AM\'\r\n    if not len(tip)> 2:\r\n        f = day + \' \' + str(tip[0])+\':\'+str(tip[1])+ \' \'+ ap\r\n    else:\r\n        f = day + \' \' + str(tip[0])+\':\'+str(tip[1])+\':\'+str(tip[2])+ \' \'+ ap\r\n    return f\r\n    \r\ndef changeC_END():\r\n    PowerShell_bashrc_name_break_fix()\r\ndef changeC_START():\r\n    PowerShell_bashrc_name_break()\r\n\r\n######################################################\r\n\r\ndef PowerShell_bashrc_name_break():\r\n    global changeC_rc_path\r\n\r\n    changeC_rc_path = True\r\n    psA = _v.home + _v.slash + _v.slash.join( [\'Documents\',\'WindowsPowerShell\',\'Microsoft.PowerShell_profile.ps1\'] )\r\n    psB = _v.home + _v.slash + _v.slash.join( [\'Documents\',\'WindowsPowerShell\',\'00000_Microsoft.PowerShell_profile.ps1\'] )\r\n    if os.path.isfile(psA):\r\n        os.rename( psA , psB )\r\n        time.sleep(.2)\r\n        # print_(psA)\r\n        # print_(psB)\r\n\r\ndef PowerShell_bashrc_name_break_fix():\r\n    global changeC_rc_path\r\n    changeC_rc_path = False\r\n    time.sleep(.2)\r\n    psA = _v.home + _v.slash + _v.slash.join( [\'Documents\',\'WindowsPowerShell\',\'Microsoft.PowerShell_profile.ps1\'] )\r\n    psB = _v.home + _v.slash + _v.slash.join( [\'Documents\',\'WindowsPowerShell\',\'00000_Microsoft.PowerShell_profile.ps1\'] )\r\n    if os.path.isfile(psB):\r\n        os.rename( psB , psA )\r\n######################################################\r\n\r\ndef year(theDate):\r\n    return datetime.datetime.fromtimestamp( int(theDate) ).isocalendar()[0]\r\n\r\ndef woy(theDate):\r\n    return datetime.datetime.fromtimestamp( int(theDate) ).isocalendar()[1]\r\n\r\ndef getDOWromEpoch(theDate):\r\n    return datetime.datetime.fromtimestamp( int(theDate) ).isocalendar()[2]\r\n\r\ndef dow(theDate):\r\n    return dowConvert(getDOWromEpoch(theDate))\r\n    \r\ndef dowConvert(dow):\r\n    result = \'\'\r\n    if dow == 1:\r\n        result = \'Monday\'\r\n    if dow == 2:\r\n        result = \'Tuesday\'\r\n    if dow == 3:\r\n        result = \'Wednesday\'\r\n    if dow == 4:\r\n        result = \'Thursday\'\r\n    if dow == 5:\r\n        result = \'Friday\'\r\n    if dow == 6:\r\n        result = \'Saturday\'\r\n    if dow == 7:\r\n        result = \'Sunday\'\r\n    return resultz\r\n\r\n\r\n__.nc_histrory = []\r\nclass NC:\r\n\r\n    def build( self, x, y=None ):\r\n        __.nc_histrory.append(x)\r\n        if not y == None:\r\n            exec( \'self.\' +x+ \' = y\' )\r\n        else:\r\n            exec( \'self.\' +x+ \' = NC()\' )\r\n\r\n    def child( self, xx, y=None ):\r\n        xx = xx.replace( \' \', \'\' )\r\n        for x in xx.split(\',\'):\r\n            if \'.\' in x:\r\n                z = x.split(\'.\')\r\n                b = \'\'\r\n                for w in z:\r\n                    b += \'.\'+w\r\n                    b = _str.cleanBE(b,\'.\')\r\n                    if not b in __.nc_histrory:\r\n                        # print_(b)\r\n                        self.build(b)\r\n\r\n\r\n            self.build(x,y)\r\n\r\n\r\nnc = NC()\r\n"""\r\npp nx_test\r\n    _.nc.child( \'tables\' )\r\n    _.nc.tables.a = \'a.index\'\r\n    _.nc.tables.b = \'a.hash\'\r\n    _.nc.tables.c = \'c.json\'\r\n\r\n    _.nc.child( \'a.b.c , a.s.d.f\' )\r\n    _.nc.a.s.d.f = 42\r\n\r\n    _.nc.child( \'x.y.z\', 123 )\r\n\r\n"""\r\n\r\n\r\n######################################################\r\n\r\n\r\n# for x in sys.modules:\r\n#     print_(x)\r\n\r\nimport _rightThumb._profileVariables as _profile\r\ncolorama_loaded = False\r\n_dir = None\r\n_code = None\r\n\r\nisWin = __.isWin\r\nthisOS = __.thisOS\r\n\r\n\r\n\r\ndef dicString( var, path ):\r\n    return var + "[\'" + "\'][\'".join( path.split(\'.\') )+"\']"\r\n\r\n# def file_language(file):\r\n    \r\n\r\n# import inspect\r\n# x = inspect.getargspec(SSHTunnelForwarder)\r\n\r\n\r\ndef check_field_match( actual, search ):\r\n    if actual.lower() == search.lower() or actual.lower() == tfc(search):\r\n        return True\r\n    return False\r\n\r\n\r\n\r\n\r\ndef fileLabel(path):\r\n    print_(path)\r\n    global _dir\r\n    if _dir is None:\r\n        import _rightThumb._dir as _dir\r\n    f = _dir.info( path )\r\n    label = f[\'name_\'].replace( \'.\'+f[\'ext\'], \'\' )\r\n    print_( label )\r\n    return label\r\n\r\ndef getTablesProject( project ):\r\n    folder = _v.projectData(project)\r\n    # color( [project, folder], \'yellow\' )\r\n    files = []\r\n    for file in os.listdir(folder):\r\n        path = folder + _v.slash + file\r\n        files.append( path )\r\n    return files\r\n\r\n\r\ndef color( strings=\'\', c=\'?\', b=None, shouldPrint=True, attr=None,       p=None ):\r\n    global switches\r\n    if switches.isActive( \'NoColor\' ):\r\n        if shouldPrint:\r\n\r\n            print_(str(strings))\r\n            return strings\r\n        else:\r\n            return strings\r\n    result = \'\'\r\n    # https://pypi.org/project/colorama/\r\n    # https://pypi.org/project/termcolor/\r\n\r\n    if not p is None:\r\n        shouldPrint=False\r\n\r\n\r\n    if c == \'?\':\r\n        print_("""\r\n\r\n    Text colors:\r\n        grey\r\n        red\r\n        green\r\n        yellow\r\n        blue\r\n        magenta\r\n        cyan\r\n        white\r\n\r\n\r\n    Text highlights:\r\n        on_grey\r\n        on_red\r\n        on_green\r\n        on_yellow\r\n        on_blue\r\n        on_magenta\r\n        on_cyan\r\n        on_white\r\n\r\n\r\n    Attributes:\r\n        bold\r\n        dark\r\n        underline\r\n        blink\r\n        reverse\r\n        concealed\r\n\r\n        """)\r\n        sys.exit()\r\n    background = None\r\n    if b is None:\r\n        cx = c.split(\',\')\r\n        if len(cx) > 1:\r\n            background = cx[1]\r\n            if not background.startswith(\'on_\'):\r\n                background = \'on_\'+background\r\n\r\n        forground = cx[0]\r\n    elif not b is None:\r\n        forground = c\r\n        background = b\r\n        if not background.startswith(\'on_\'):\r\n            background = \'on_\'+background\r\n\r\n    global colorama_loaded\r\n    global colored\r\n    if not colorama_loaded:\r\n        colorama_loaded = True\r\n        from termcolor import colored\r\n\r\n    if type(strings) == list:\r\n\r\n\r\n        for i,x in enumerate(strings):\r\n\r\n            strings[i] = str( x )\r\n\r\n        string = \' \'.join( strings )\r\n    else:\r\n        string = str(strings)\r\n\r\n    if not background is None:\r\n        if not attr is None:\r\n            result = colored( string , forground, background, attrs=attr.split(\',\') )\r\n        else:\r\n            result = colored( string , forground, background)\r\n    elif background is None:\r\n        if not attr is None:\r\n            result = colored( string , forground, attrs=attr.split(\',\') )\r\n        else:\r\n            result = colored( string , forground )\r\n\r\n    if shouldPrint:\r\n        try:\r\n            print_( result )\r\n        except Exception as e:\r\n\r\n            try:\r\n                result = str(result,\'utf-8\')\r\n            except Exception as e:\r\n                try:\r\n                    result = str(result,\'iso-8859-1\')\r\n                except Exception as e:\r\n                    result = result.encode(\'utf-8\')\r\n            result = str(result,\'iso-8859-1\')\r\n\r\n    return result\r\n    \r\n\r\ndef factor( data, f=None, threshold=51, count=1 ):\r\n    records = flattenInt(data,r=1,end=\'cnt\')\r\n    single = {}\r\n    factors = {}\r\n    for x in records:\r\n        # print_( x, records[x] )\r\n        if not x in single:\r\n            single[x] = {\r\n                            \'len\': x,\r\n                            \'count\': len(records[x]),\r\n                            \'first\': None,\r\n                            \'last\': None,\r\n                            \'diff_fl\': None,\r\n                            \'threshold\': threshold,\r\n                            \'drop_val\': 100,\r\n                            \'drop_id\': None,\r\n                            \'relevant\': [],\r\n                            # \'records\': records[x],\r\n\r\n            }\r\n        \r\n        \r\n        single[x][\'last\'] = percentageDiffAuto( records[x][0][\'value\'], records[x][  len(records[x])-1  ][\'value\'], isFloat=True, rnd=2 )\r\n        # print_( "single[x][\'last\']", single[x][\'last\'] )\r\n        # sys.exit()\r\n        relevant = []\r\n        # single[x][\'relevant\'].append({ \'drop\': 0, \'id\': 0, \'diff\': 0, \'diff_0\': 0, \'diff_0p\': 0 })\r\n        single[x][\'relevant\'].append({ \'drop\': 0, \'id\': 0, \'diff\': 0, \'diff_0\': 0, \'diff_0p\': 0 })\r\n        drop = 1\r\n        last = records[x][0][\'value\']\r\n        for i,y in enumerate(records[x]):\r\n\r\n            if i:\r\n                drop = percentageDiffAuto( records[x][i][\'value\'], last, isFloat=True, rnd=2 )\r\n                # asdf = last-records[x][i][\'value\']\r\n                # dLast = percentageDiffSmaller( last, asdf , isFloat=True, rnd=2 )\r\n                # print_( dLast, \'\\t\', last, \'\\t\', asdf )\r\n                # print_( records[x][i] )\r\n                if drop <= single[x][\'drop_val\'] and drop <= threshold:\r\n                    single[x][\'drop_val\'] = drop\r\n                    single[x][\'drop_id\'] = i\r\n                    if records[x][i][\'value\'] >= count:\r\n                        single[x][\'relevant\'].append({ \'drop\': drop, \'id\': i, \'diff\': last-records[x][i][\'value\'], \'diff_0\': records[x][0][\'value\']- records[x][i][\'value\'] ,\'diff_0p\': percentageDiffAuto( records[x][0][\'value\'], records[x][i][\'value\'], isFloat=True, rnd=2 ) })\r\n                    # else:\r\n                    #     print_( records[x][i][\'value\'], count )\r\n                if i==1:\r\n                    single[x][\'first\'] = percentageDiffAuto( records[x][0][\'value\'], records[x][i][\'value\'], isFloat=True, rnd=2 )\r\n                    single[x][\'diff_fl\'] = percentageDiffAuto( single[x][\'first\'], records[x][i][\'value\'], isFloat=True, rnd=2 )\r\n                    # print_( "single[x][\'first\']", single[x][\'first\'] )\r\n                    # print_( "single[x][\'diff_fl\']", single[x][\'diff_fl\'] )\r\n                \r\n                last = records[x][i][\'value\']\r\n            # lastD = drop\r\n            # print_(y)\r\n        # single[x][\'relevant\'] = sort( single[x][\'relevant\'], \'drop\' )\r\n        # printVar( single[x] )\r\n    factors[\'single\'] = single\r\n    if f is None:\r\n        return { \'factors\': factors, \'records\': records }\r\n\r\n    elif not factors is None:\r\n        pass\r\n\r\n\r\ndef flattenInt( data, end=False, reverse=False, r=0, delineator=\'.\' ):\r\n\r\n    if r:\r\n        reverse = True\r\n    xyz = traverse(data, config={\'delineator\':delineator})\r\n    # colorThis(  len( list( xyz[\'type\'][\'int\'].keys() ) ), \'red\'  )\r\n    if not end:\r\n        records = []\r\n        del records\r\n        records = []\r\n\r\n        for x in xyz[\'type\'][\'int\']:\r\n            y = "[\'"+"\'][\'".join( x.split(delineator) )+"\']"\r\n            records.append({ \'path\': x, \'build\': y, \'value\': eval( \'data\'+y ) })\r\n        result = sort( records, \'value\' )\r\n        if reverse:\r\n            result.reverse()\r\n    elif end:\r\n        # sys.exit()\r\n        records = {}\r\n        del records\r\n        records = {}\r\n        for x in xyz[\'type\'][\'int\']:\r\n            if x.endswith(delineator+\'\'+end):\r\n                ln = x.count(delineator)\r\n                c = x.split(delineator)\r\n                y = "[\'"+"\'][\'".join( c )+"\']"\r\n                if not ln in records:\r\n                    records[ln] = []\r\n                c.pop()\r\n                yy = "[\'"+"\'][\'".join( c )+"\']"\r\n                records[ln].append({ \'path\': x, \'buildA\': y, \'buildB\': yy, \'value\': eval( \'data\'+y ) })\r\n        result = {}\r\n        for ln in records:\r\n            result[ln] = sort( records[ln], \'value\' )\r\n            if reverse:\r\n                result[ln].reverse()\r\n\r\n\r\n    return result\r\n\r\n# _.colorThis( [ \'\\t\', part_profile  ], \'yellow\', simpleDic=True, colorProfile=[ { \'t\': \'i/dict\', \'color\': \'red\', \'field\': \'match\'  } ] )\r\n\r\n# {7DB6A001-0637-4F13-B328-2B17A481CF35}\r\n\r\n# traverse_dic traverse_dic_research theFields\r\n# pp multi_dic_test\r\n\r\nclass dt:\r\n    def __init__( self, d ):\r\n        self.d = d\r\n        self.load()\r\n    def load( self, d=None ):\r\n        if d is None:\r\n            d = self.d\r\n        self.epoch = autoDate(d)\r\n        self.friendly = friendlyDate(self.epoch)\r\n        self.text = self.friendly\r\n        self.print = self.friendly\r\n        self.stamp = self.friendly\r\n        self.timestamp = self.friendly\r\n        self.date = self.friendly.split(\' \')[0]\r\n        self.time = self.friendly.split(\' \')[1]\r\n        self.object = datetime.datetime.fromtimestamp(self.epoch)\r\n\r\n\r\n    def add( self, duration, months=False, years=False ):\r\n        if months:\r\n            return self.addMonths(duration)\r\n        if years:\r\n            return self.addYears(duration)\r\n        result = str( dateAdd( self.date, \'-\', duration ) )\r\n        self.load( result+\'@\'+self.time )\r\n        return self\r\n    \r\n    def subtract( self, duration, months=False, years=False ):\r\n        if months:\r\n            return self.subtractMonths(duration)\r\n        if years:\r\n            return self.subtractYears(duration)\r\n        result = str( dateSub( self.date, \'-\', duration ) )\r\n        self.load( result+\'@\'+self.time )\r\n        return self\r\n        # dateAdd dateSub\r\n        # theDate,delim,addDays\r\n\r\n    def addMonths( self, months ):\r\n        sp = self.date.split(\'-\')\r\n        y = int(sp[0])\r\n        m = int(sp[1])\r\n        i=0\r\n        while not i==months:\r\n            i+=1\r\n            if m+1 > 12:\r\n                m = 1\r\n                y+=1\r\n            else:\r\n                m+=1\r\n        mm = str(m)\r\n        if len(mm) == 1:\r\n            mm = \'0\'+mm\r\n        result = str(y)+\'-\'+mm+\'-\'+sp[2]\r\n        self.load( result+\'@\'+self.time )\r\n        return self\r\n\r\n    def subtractMonths( self, months ):\r\n        sp = self.date.split(\'-\')\r\n        y = int(sp[0])\r\n        m = int(sp[1])\r\n        i=0\r\n        while not i==months:\r\n            i+=1\r\n            if m-1 < 1:\r\n                m = 12\r\n                y-=1\r\n            else:\r\n                m-=1\r\n        mm = str(m)\r\n        if len(mm) == 1:\r\n            mm = \'0\'+mm\r\n        result = str(y)+\'-\'+mm+\'-\'+sp[2]\r\n        try:\r\n            pass\r\n            self.load( result+\'@\'+self.time )\r\n        except Exception as e:\r\n            print_(\'result\',result)\r\n            sys.exit()\r\n            # raise e\r\n        return self\r\n\r\n    def addYears( self, years ):\r\n        sp = self.date.split(\'-\')\r\n        y = int(sp[0])+years\r\n        result = str(y)+\'-\'+sp[1]+\'-\'+sp[2]\r\n        self.load( result+\'@\'+self.time )\r\n        return self\r\n\r\n    def subtractYears( self, years ):\r\n        sp = self.date.split(\'-\')\r\n        y = int(sp[0])-years\r\n        result = str(y)+\'-\'+sp[1]+\'-\'+sp[2]\r\n        self.load( result+\'@\'+self.time )\r\n        return self\r\n\r\n\r\ndef isData( data=None, focus=None, pipeClean=True, required=False,     r=None, c=None ):\r\n    def _isData_(tst):\r\n        global myFileLocation_Files\r\n        if not tst: return myFileLocation_Files;\r\n        return tst\r\n\r\n    def isData_path_list(stuff,dAta=[]):\r\n        for f in stuff:\r\n            f = __.path(f)\r\n            if os.path.isfile(f):\r\n                dAta.append(f)\r\n        return dAta\r\n    if not c is None: pipeClean=c;\r\n    if not r is None: required = r;\r\n    if data is None:\r\n        if pipeClean:\r\n            pipeCleaner(0)\r\n        global appData\r\n        if focus is None:\r\n            focus = __.appReg\r\n        data = appData[focus][\'pipe\']\r\n\r\n    if not data:\r\n        data=[]\r\n        global switches\r\n        isClean=False\r\n        # print_(\'v.isData\',v.isData,__.appReg)\r\n        for name in v.isData:\r\n            # print_(\'val\',switches.values(name),len(switches.values(name)),name)\r\n            if len(switches.values(name)):\r\n                for isD in v.isData[name].split(\',\'):\r\n                    # print_(\'isD\',isD)\r\n                    if isD == \'clean\':\r\n                        isClean=True\r\n                    elif isD == \'name\':\r\n                        for n in switches.values(name):\r\n                            data.append(name)\r\n                    elif isD == \'glob\' and \'data\' in v.isData[name]:\r\n                        for n in switches.values(name):\r\n                            # for f in glob.glob( n ):\r\n                            for f in isData_path_list( glob.glob( n ) ):\r\n                                for xXx in getText( f, raw=True ).split(\'\\n\'):\r\n                                    data.append(xXx)\r\n                    elif isD == \'glob\':\r\n                        # print_(\'9e1647494350\')\r\n                        for n in switches.values(name):\r\n                            # print_(\'3e1647480669\',n)\r\n                            # print_(\'n\',n)\r\n                            # sys.exit()\r\n                            if type(n) == list:\r\n                                stuff = n\r\n                            if type(n) == str:\r\n                                stuff = glob.glob( n )\r\n                            if not stuff is None:\r\n                                data=isData_path_list(stuff,data)\r\n\r\n\r\n                    elif isD == \'data\':\r\n                        tData=[]\r\n                        for n in switches.values(name):\r\n                            tData.append(getText(n,raw=True))\r\n                        # print_(tData[0])\r\n                        data = \'\\n\'.join(tData)\r\n                        # print_(data)\r\n                        # print_(type(data))\r\n                        # sys.exit()\r\n                        # return data\r\n                        # sys.exit()\r\n\r\n        if data:\r\n            # print_(\'here\')\r\n            # sys.exit()\r\n            if False and not isClean:\r\n                return _isData_(data)\r\n            elif type(data)==str:\r\n                # print_(\'here\')\r\n                # sys.exit()\r\n                newData=\'\'\r\n                data = data.replace(\'\\r\',\'\')\r\n                # data = _str.replaceDuplicate( data, \'\\n\' )\r\n                # for row in data.split(\'\\n\'):\r\n                #   row = _str.cleanBE( row, \' \' )\r\n                #   row = _str.cleanBE( row, \'\\t\' )\r\n                #   newData+=row+\'\\n\'\r\n                # return newData\r\n                # print_(\'here\')\r\n                # sys.exit()\r\n                return _isData_(data.split(\'\\n\'))\r\n            elif type(data)==list:\r\n                newData=[]\r\n                for row in data:\r\n                    row = row.replace(\'\\r\',\'\')\r\n                    row = row.replace(\'\\n\',\'\')\r\n                    row = _str.replaceDuplicate( row, \' \' )\r\n                    row = _str.cleanBE( row, \' \' )\r\n                    row = _str.cleanBE( row, \'\\t\' )\r\n                    newData.append(row)\r\n                return _isData_(newData)\r\n\r\n\r\n\r\n\r\n\r\n\r\n            \r\n    if r:\r\n        if type(data) == bool:\r\n            help()\r\n            return _isData_(None)\r\n        if not data:\r\n            help()\r\n            return _isData_(None)\r\n    else:\r\n        if type(data) == bool:\r\n            return _isData_([])\r\n        if not data:\r\n            return _isData_([])\r\n    \r\n    return _isData_(data)\r\n\r\ndef payloadCache( data, file=None, theFocus=None ):\r\n    # _.payloadCache( saveFile, __file__, focus() )\r\n    \r\n    if theFocus is None:\r\n        theFocus = __.appReg\r\n    if file is None:\r\n        appDBA = __.thisApp( __.postLoadFile )\r\n    else:\r\n        appDBA = __.thisApp( file )\r\n    releaseAcquiredData( appDBA, theFocus, data )\r\n\r\n__.appInfoScan = None\r\n\r\ndomainIndex = None\r\n\r\ndef json_clean(obj):\r\n    if hasattr(obj, \'__class__\') and \'.\'  in str(obj.__class__):\r\n        obj = dict((name, getattr(obj, name)) for name in dir(obj) if not name.startswith(\'__\'))\r\n        obj = prep4JSON(obj)\r\n    return obj\r\n\r\n\r\ndef prep4JSON(d, to_delete=None):\r\n    # remove keys from multidimensional dicts and lists\r\n    def autoFindKeys(d):\r\n        # removes functions and methods\r\n        global autoFindKeys_temp\r\n        if isinstance(d, dict):\r\n            for k in d.keys():\r\n                t = type( d[k] )\r\n                if \'function\' in str(t):\r\n                    autoFindKeys_temp.append( k )\r\n                elif \'method\' in str(t):\r\n                    autoFindKeys_temp.append( k )\r\n                \r\n            for k, v in d.items():\r\n                autoFindKeys(v)\r\n        elif isinstance(d, list):\r\n            for i in d:\r\n                autoFindKeys(i)\r\n        return d\r\n\r\n    if to_delete is None:\r\n        global autoFindKeys_temp\r\n        autoFindKeys_temp = []\r\n        autoFindKeys(d)\r\n        return prep4JSON(d, to_delete=autoFindKeys_temp)\r\n\r\n    if isinstance(to_delete, str):\r\n        to_delete = [to_delete]\r\n    if isinstance(d, dict):\r\n        for single_to_delete in set(to_delete):\r\n            if single_to_delete in d:\r\n                d[single_to_delete] = \' ** removed ** \'\r\n        for k, v in d.items():\r\n            prep4JSON(v, to_delete)\r\n    elif isinstance(d, list):\r\n        for i in d:\r\n            prep4JSON(i, to_delete)\r\n    return d\r\n\r\ndef delete_keys_from_dict(d, to_delete=None):\r\n    # remove keys from multidimensional dicts and lists\r\n    def autoFindKeys(d):\r\n        # removes functions and methods\r\n        global autoFindKeys_temp\r\n        if isinstance(d, dict):\r\n            for k in d.keys():\r\n                t = type( d[k] )\r\n                if \'function\' in str(t):\r\n                    autoFindKeys_temp.append( k )\r\n                elif \'method\' in str(t):\r\n                    autoFindKeys_temp.append( k )\r\n                \r\n            for k, v in d.items():\r\n                autoFindKeys(v)\r\n        elif isinstance(d, list):\r\n            for i in d:\r\n                autoFindKeys(i)\r\n        return d\r\n\r\n    if to_delete is None:\r\n        global autoFindKeys_temp\r\n        autoFindKeys_temp = []\r\n        autoFindKeys(d)\r\n        return delete_keys_from_dict(d, to_delete=autoFindKeys_temp)\r\n\r\n    if isinstance(to_delete, str):\r\n        to_delete = [to_delete]\r\n    if isinstance(d, dict):\r\n        for single_to_delete in set(to_delete):\r\n            if single_to_delete in d:\r\n                del d[single_to_delete]\r\n        for k, v in d.items():\r\n            delete_keys_from_dict(v, to_delete)\r\n    elif isinstance(d, list):\r\n        for i in d:\r\n            delete_keys_from_dict(i, to_delete)\r\n    return d\r\n\r\n\r\ndef help():\r\n    global switches\r\n    switches.help()\r\n\r\ndef internet_domains(text):\r\n    global domainIndex\r\n    if domainIndex is None:\r\n        domainIndex = getTableDB( \'domains.index\' )\r\n    results = []\r\n    for domain in domainIndex.keys():\r\n        minus = \'www\'+domain\r\n        # minus = []\r\n        # minus.append( \'www\'+domain )\r\n        # for x in _str.alphanumeric:\r\n        #     minus.append( domain+x )\r\n\r\n        for thisDomain in caseUnspecific( text, domain, isPlus=False, minus=minus ):\r\n            results.append( thisDomain )\r\n    return results\r\n\r\ndef fileFolder( path, slash = _v.slash, py=False ):\r\n    if not slash in path:\r\n        try:\r\n            path = os.path.abspath(path)\r\n        except Exception as e:\r\n            return path\r\n\r\n    p = path.split(slash)\r\n    file = p.pop()\r\n    if py and ( file == \'__init__.py\' or file == \'__init__.pyc\' ):\r\n        file = p.pop()\r\n        \r\n    return { \'file\': file, \'folder\': slash.join(p) }\r\n\r\n\r\ndef stringType( string, mini=True ):\r\n    if not type(string) == str:\r\n        if mini:\r\n            return None\r\n        else:\r\n            return str( type(string) ).split("\'")[1]\r\n            return type(string)\r\n\r\n    upperC = \'ABCDEFGHIJKLMNOPQRSTUVWXYZ\'\r\n    lowerC = \'abcdefghijklmnopqrstuvwxyz\'\r\n    numberC = \'0123456789\'\r\n\r\n    if mini:\r\n        total = \'t\'\r\n        upper = \'u\'\r\n        lower = \'l\'\r\n        number = \'n\'\r\n        special = \'s\'\r\n        count = \'c\'\r\n        percentage = \'p\'\r\n    elif not mini:\r\n        total = \'total\'\r\n        upper = \'upper\'\r\n        lower = \'lower\'\r\n        number = \'number\'\r\n        special = \'special\'\r\n        count = \'count\'\r\n        percentage = \'percentage\'\r\n\r\n    result = {\r\n                total: 0,\r\n                upper: { count: 0, percentage: 0 },\r\n                lower: { count: 0, percentage: 0 },\r\n                number: { count: 0, percentage: 0 },\r\n                special: { count: 0, percentage: 0 },\r\n    }\r\n    for c in string:\r\n        result[total] += 1\r\n        if c in upperC:\r\n            result[upper][count] += 1\r\n        elif c in lowerC:\r\n            result[lower][count] += 1\r\n        elif c in numberC:\r\n            result[number][count] += 1\r\n        else:\r\n            result[special][count] += 1\r\n    \r\n    result[upper][percentage] = percentageDiffIntAuto( result[upper][count], result[total] )\r\n    result[lower][percentage] = percentageDiffIntAuto( result[lower][count], result[total] )\r\n    result[number][percentage] = percentageDiffIntAuto( result[number][count], result[total] )\r\n    result[special][percentage] = percentageDiffIntAuto( result[special][count], result[total] )\r\n\r\n\r\n    return result\r\n\r\ndef unixAutoColumns( asset, columns, focus=None ):\r\n    if not len(asset):\r\n        return asset\r\n        # return columns\r\n    asset = asset.copy()\r\n    # if __.thisOS == \'Windows\':\r\n\r\n    if not __.terminal.width:\r\n        return columns\r\n\r\n    cols = __.terminal.width\r\n    if focus is None:\r\n        focus = __.appReg\r\n    global appInfo\r\n    rec = {}\r\n    for k in asset[0].keys():\r\n        rec[k]=k\r\n    asset.append( rec )\r\n        # cols = 102\r\n    reg = appInfo[focus][\'columns\'].copy()\r\n    reg.reverse()\r\n    importance = []\r\n    for x in reg:\r\n        importance.append(x[\'name\'])\r\n    # importance = [\r\n    #               \'date_accessed\',\r\n    #               \'week_of_year\',\r\n    #               \'date_created\',\r\n    #               \'date_modified\',\r\n    #               \'ext\',\r\n    #               \'size\',\r\n    # ]\r\n    fields.asset( \'asset\', asset )\r\n    lengths = fields.lengths( \'asset\' )\r\n\r\n    # printVarSimple( lengths )\r\n\r\n    total = 3\r\n    for col in columns.split(\',\'):\r\n        total+=3\r\n        for key in lengths:\r\n            if col.lower() == key.lower():\r\n                total += lengths[key]\r\n    # print_( total, columns )\r\n    # print_( cols, type(cols) )\r\n    nextDel = 0\r\n    done = False\r\n    newList = []\r\n    while total > cols and not done:\r\n        total = 3\r\n        newCols = []\r\n        for col in columns.split(\',\'):\r\n            if col == importance[nextDel]:\r\n                if not col in newList:\r\n                    newList.append(col)\r\n            if not col == importance[nextDel]:\r\n                newCols.append(col)\r\n                total+=3\r\n                for key in lengths:\r\n                    if col.lower() == key.lower():\r\n                        total += lengths[key]\r\n            columns = \',\'.join(newCols)\r\n        nextDel += 1\r\n        if not len(newCols):\r\n            done=True\r\n    pass\r\n    if not len(columns):\r\n        columns = newList[ len(newList)-1 ]\r\n    # print_( total, columns )\r\n\r\n\r\n    # print_( \'total:\', total )\r\n\r\n    # sys.exit()\r\n    return columns\r\n\r\n\r\ndef callers( i=1 ):\r\n    callersX = []\r\n    error=False\r\n\r\n    while not error:\r\n        try:\r\n            try:\r\n                x = sys._getframe(i).f_back.f_code\r\n            except Exception as e:\r\n                x = None\r\n            try:\r\n                xxx = str(sys._getframe(i).f_code.co_name)\r\n            except Exception as e:\r\n                xxx = \'_bootstrap\'\r\n            # print_(x)\r\n            # print_(xxx)\r\n            if \'_bootstrap\' in xxx or \'<module>\' in xxx:\r\n                error=True\r\n            else:\r\n                if not x is None:\r\n                    # print_(x)\r\n                    callersX.append(x)\r\n                else:\r\n                    error=True\r\n        except Exception as e:\r\n            error=True\r\n\r\n        i+=1\r\n    # print_(callersX)\r\n    return callersX\r\n\r\ndef epochDiff( a, b, isInt=None, isText=None, isFloat=None, isHR=None, isDays=None,      isD=None, isH=None, isI=None, isT=None, isF=None, txt=None ):\r\n    # epochDiff( a, b, isH=1, isF=1 )\r\n    if not isI is None:\r\n        isInt = isI\r\n    if not isT is None:\r\n        isText = isT\r\n    if not isF is None:\r\n        isFloat = isF\r\n    if not isH is None:\r\n        isHR = isH\r\n    if not isD is None:\r\n        isDays = isD\r\n\r\n\r\n    if txt is None:\r\n        if isDays:\r\n            txt = \' day\'\r\n        else:\r\n            txt = \' hr\'\r\n    elif not txt is None:\r\n        isText = True\r\n        if \'h\' in txt.lower():\r\n            isHR = True\r\n        else:\r\n            isDays = True\r\n\r\n        txt = txt.replace( \' \', \'\' )\r\n        txt = txt.replace( \'s\', \'\' )\r\n        txt = \' \'+txt\r\n\r\n    if isHR is None and isDays is None:\r\n        isDays = True\r\n    if isHR is isInt and isText is None and isFloat is None:\r\n        isInt = True\r\n\r\n\r\n    if a>b:\r\n        start = b\r\n        end = a\r\n    else:\r\n        start = a\r\n        end = b\r\n    diff = end - start\r\n    result = round(  (diff/60)/60, 2  )\r\n\r\n    if isHR:\r\n        if result > 1:\r\n            theTXT = txt+\'s\'\r\n        else:\r\n            theTXT = txt\r\n        if isFloat and not isText:\r\n            return result\r\n        elif isFloat and isText:\r\n            return str(result)+theTXT\r\n\r\n        elif isInt and not isText:\r\n            return int( str(result).split(\'.\')[0] )\r\n        elif isInt and isText:\r\n            return str(result).split(\'.\')[0]+theTXT\r\n    elif isDays:\r\n        result = round(  result/24, 2  )\r\n        if result > 1:\r\n            theTXT = txt+\'s\'\r\n        else:\r\n            theTXT = txt\r\n        if isFloat and not isText:\r\n            return result\r\n        elif isFloat and isText:\r\n            return str(result)+theTXT\r\n\r\n        elif isInt and not isText:\r\n            return int( str(result).split(\'.\')[0] )\r\n        elif isInt and isText:\r\n            return str(result).split(\'.\')[0]+theTXT\r\n    return None\r\n\r\n\r\n\r\n\r\ndef getDriveID( drive, fail_isLetter=False ):\r\n    drive = drive.upper()\r\n    # print_(drive)\r\n\r\n    def getDriveID_clean( driveID ):\r\n        \r\n        driveID = driveID.replace(\' \',\'\')\r\n        driveID = driveID.replace(\'\\n\',\'\')\r\n        driveID = driveID.replace(\'\\r\',\'\')\r\n        return driveID\r\n\r\n    driveID = None\r\n    if not fail_isLetter:\r\n        driveID = None\r\n    else:\r\n        driveID = drive\r\n    if __.isWin:\r\n        if os.path.isdir(drive+\':\'+_v.slash):\r\n            idFile = drive + \':\'+_v.slash+\'drive.id.sys\'\r\n            if os.path.isfile(idFile):\r\n                # os._exit(0)\r\n                initiated = os.path.getctime(idFile)\r\n                driveID = open( idFile, \'r\' ).read()\r\n                driveID = getDriveID_clean(driveID)\r\n\r\n    elif not __.isWin:\r\n        idFileA = drive+\'/.drive-id\'\r\n        idFileB = drive+\'/opt/tech/.drive-id\'\r\n        if os.path.isfile(idFileA):\r\n            initiated = os.path.getctime(idFileA)\r\n            driveID = open( idFileA, \'r\' ).read()\r\n            driveID = getDriveID_clean(driveID)\r\n        if os.path.isfile(idFileB):\r\n            initiated = os.path.getctime(idFileB)\r\n            driveID = open( idFileB, \'r\' ).read()\r\n            driveID = getDriveID_clean(driveID)\r\n        # else:\r\n            # print_(\'Error\')\r\n            # os._exit(0)\r\n    return driveID\r\n\r\ndef folderProfileAttribute( folder, info ):\r\n\r\n    epoch = time.time()\r\n\r\n    driveID = getDriveID( folder[0], fail_isLetter=True )\r\n    # print_(driveID)\r\n    # sys.exit()\r\n    # file_drives = \'indexTable_drives-\' + _v.getMachineID() + \'.json\'\r\n    folders = folder[3:].replace( _v.slash, \'((-f-))\' )\r\n    fld = _v.databank+_v.slash+\'profiles\'+_v.slash+\'folders\'+_v.slash+driveID\r\n    saveTo = fld + _v.slash + folders+\'.json\'\r\n    if not os.path.isdir( fld ):\r\n        os.mkdir(fld)\r\n\r\n\r\n    app = info[\'app\']\r\n\r\n    if info[\'recursive\']:\r\n        what = \'recursive\'\r\n    elif not info[\'recursive\']:\r\n        what = \'self\'\r\n\r\n\r\n\r\n    if not os.path.isfile( saveTo ):\r\n        record = {\r\n                    \'self\': {},\r\n                    \'recursive\': {},\r\n        }\r\n        record[what][app] = {}\r\n        record[what][app][epoch] = info\r\n        saveTable2( record, saveTo )\r\n    elif os.path.isfile( saveTo ):\r\n        # print_(saveTo)\r\n        try:\r\n            record = getTable2( saveTo )\r\n        except Exception as e:\r\n            if os.path.isfile(saveTo):\r\n                os.unlink(saveTo)\r\n            folderProfileAttribute( folder, info )\r\n            return None\r\n            \r\n\r\n        if record[what] == {}:\r\n            record[what][app] = {}\r\n            record[what][app][epoch] = info\r\n            saveTable2( record, saveTo )\r\n\r\n        if not app in record[what].keys():\r\n            record[what][app] = {}\r\n            record[what][app][epoch] = info\r\n            saveTable2( record, saveTo )\r\n            \r\n        else:\r\n            for key in list( record[what][app].keys() ):\r\n                same = False\r\n                failed = False\r\n                for fKey in list( info.keys() ):\r\n                    if not fKey == \'factors\':\r\n                        if fKey in record[what][app][key] and info[fKey]  ==  record[what][app][key][fKey]:\r\n                            \r\n                            same = True\r\n                        else:\r\n                            # print_( \'failed\', fKey )\r\n                            failed = True\r\n\r\n\r\n                        if not fKey in record[what][app][key]:\r\n                            failed = True\r\n                            # print_( \'missing\', fKey )\r\n                if same and not failed:\r\n                    same = False\r\n                    failed = False\r\n                    for fKey in list( info[\'factors\'].keys() ):\r\n                        if fKey in record[what][app][key][\'factors\'] and info[\'factors\'][fKey]  ==  record[what][app][key][\'factors\'][fKey]:\r\n                            same = True\r\n                            # print_( \'Same\' )\r\n                        else:\r\n                            # print_( \'failed\', fKey )\r\n                            failed = True\r\n\r\n\r\n                        if not fKey in record[what][app][key][\'factors\'] :\r\n                            failed = True\r\n                            # print_( \'missing\', fKey )\r\n                # print_()\r\n                # print_( \'same\', same )\r\n                # print_( \'failed\', failed )\r\n                if same and not failed:\r\n                    pass\r\n                else:\r\n                    record[what][app][epoch] = info\r\n                    saveTable2( record, saveTo )\r\n\r\n\r\n\r\n\r\n    pass\r\n"""\r\n{\r\n    \'factors\': {\r\n                    \r\n                    \'Text\': False,\r\n                    \'Binary\': False,\r\n                    \'Extensions\': False,\r\n                    \'Type\': [],\r\n\r\n\r\n                    \'PlusOr\': False,\r\n                    \'PlusClose\': False,\r\n                    \'Plus\': False,\r\n                    \'Minus\': False,\r\n                    \r\n                    \'Pluses\': [],\r\n                    \'Minuses\': [],\r\n    },\r\n    \'percentage\': _.pDiff( len(files), i, use=\'less\' ),\r\n    \'type\': _.switches.value(\'Extensions\'),\r\n    \'count\': len(files),\r\n    \'files\': i ,\r\n    recursive\': False,\r\n\r\n}\r\n"""\r\n\r\n\r\ndef getBin( file ):\r\n    theFile=file\r\n    if os.path.isfile(theFile): vv.opened_file_me[theFile] = os.path.getmtime( theFile );\r\n    f = open( file, \'rb\' )\r\n    data = f.read()\r\n    f.close()\r\n    return data\r\n\r\ndef getBin_list( file ):\r\n    f = open( file, \'rb\' )\r\n    data = list( f.read() )\r\n    f.close()\r\n    return data\r\n\r\ndef saveBin( data, file, me=0 ):\r\n    theFile=file\r\n    HD.chmod(file)\r\n    def splitNumber (num):\r\n        lst = []\r\n        while num > 0:\r\n            lst.append(num & 0xFF)\r\n            num >>= 8\r\n        return lst[::-1]\r\n    try:\r\n        f=open( file, \'wb\' )\r\n        f.write(data)\r\n        f.close()\r\n    except Exception as e:\r\n        try:\r\n            with open(file, \'br+\') as f:\r\n                f.write(data)\r\n        except Exception as e:\r\n            try:\r\n                with open(file, \'br+\') as f:\r\n                    for number in data:\r\n                        f.write(bytes(splitNumber(number)))\r\n            except Exception as e:\r\n                colorThis( \'Error: bin save\', \'red\' )\r\n    HD.chmod(file)\r\n    if me and theFile in vv.opened_file_me: changeM( theFile, vv.opened_file_me[theFile] );\r\n\r\ndef pDiff( one, two, use=None ):\r\n    if not use is None:\r\n        use = use.lower()\r\n    a = percentageDiffInt(one,two)\r\n    b = percentageDiffInt(two, one)\r\n    if use == None:\r\n        return str(a)+\'%, \'+str(b)+\'%\'\r\n    if a > b:\r\n        g = a\r\n        l = b\r\n    else:\r\n        l = a\r\n        g = b\r\n\r\n    if \'g\' in use:\r\n        return g\r\n    elif \'l\' in use:\r\n        return l\r\n    elif \'1\' in use or \'f\' in use or \'a\' in use or \'one\' in use:\r\n        return a\r\n    elif \'3\' in use or \'s\' in use or \'b\' in use or \'two\' in use:\r\n        return b\r\n\r\n\r\n\r\n\r\n    \r\ndef clean_dic( dic, omit ):\r\n    global traverse_dic_research\r\n    if not type(omit) == list:\r\n        omit = [omit]\r\n    traverse_dic_research[\'key_has\'] = []\r\n    traverse_dic( dic, config={ \'key_has\': omit } )\r\n    \r\n    print_( \'key_has len:\', len(traverse_dic_research[\'key_has\']) )\r\n    for x in traverse_dic_research[\'key_has\']:\r\n        print_(x)\r\n    if not len(traverse_dic_research[\'key_has\']):\r\n        fields = \'\'\r\n        for x in traverse_dic_research[\'all\']:\r\n            fields += x[\'field\'] + \'; \'\r\n            # print_(x)\r\n        print_(fields)\r\n    sys.exit()\r\ntraverse_dic_research = {}\r\n\r\ndef traverse( data=None, config={} ):\r\n    global traverse_dic_research\r\n    del traverse_dic_research\r\n    traverse_dic( data, config )\r\n    return traverse_dic_research\r\ndef traverse_dic( data=None, config={} ):\r\n    global traverse_dic_research\r\n    # if hasattr(data, \'__class__\'):\r\n        # data = dict((name, getattr(data, name)) for name in dir(data) if not name.startswith(\'__\'))\r\n    # del traverse_dic_research\r\n    traverse_dic_research = {  \'return\': None, \'index\': {}, \'fields\': [], \'spent\': [], \'type\': {}  }\r\n    \r\n    if \'inDic\' in config:\r\n        traverse_dic_research[\'inDic\'] = []\r\n\r\n        config[\'inDic\'] = config[\'inDic\'].lower()\r\n    if \'inDicI\' in config:\r\n        traverse_dic_research[\'inDicI\'] = []\r\n        config[\'inDicI\'] = config[\'inDicI\'].lower()\r\n\r\n    if data is None:\r\n        print_(\'traverse_dic_research\', traverse_dic_research)\r\n        sys.exit()\r\n    if not \'i_default\' in config.keys():\r\n        config[\'i_default\'] = \'-i-\'\r\n    traverse_obj( data, config )\r\n    return traverse_dic_research\r\n\r\ndef traverse_obj( data=None, config={}, parents=[], parentsI=[],  ):\r\n    global traverse_dic_research\r\n    if not traverse_dic_research[\'return\'] is None:\r\n        return traverse_dic_research[\'return\']\r\n    if hasattr(data, \'__class__\') and \'.\'  in str(data.__class__):\r\n        data = dict((name, getattr(data, name)) for name in dir(data) if not name.startswith(\'__\'))\r\n\r\n\r\n\r\n    if type(data) == list:\r\n    # if hasattr(data, \'__iter__\') and not isinstance(data, (str, bytes, bytearray)):\r\n        for i,row in enumerate(data):\r\n            if \'i_label\' in config.keys():\r\n                np = parents + [ config[\'i_label\'].replace(\'ID\',str(i)) ]\r\n\r\n\r\n            else:\r\n                np = parents + [config[\'i_default\']]\r\n            npi = parentsI + [str(i)]\r\n\r\n\r\n\r\n\r\n            \r\n            traverse_obj( row, config, np, npi )\r\n    elif type(data) == dict:\r\n        for key in data.keys():\r\n            shouldAdd = True\r\n            if key not in traverse_dic_research[\'index\'].keys():\r\n                traverse_dic_research[\'index\'][key] = []\r\n            else:\r\n                if parents in traverse_dic_research[\'index\'][key]:\r\n                    shouldAdd = False\r\n\r\n            if shouldAdd:\r\n                traverse_dic_research[\'index\'][key].append( parents )\r\n                traverse_dic_research[\'fields\'].append({ \'type\': str(type(data[key])).split("\'")[1] , \'field\': key, \'parents\': parents })\r\n                typeX = str(type(data[key])).split("\'")[1]\r\n                if not \'delineator\' in config:\r\n                    TeMP = \'.\'.join( parents+[key] )\r\n                else:\r\n                    TeMP = config[\'delineator\'].join( parents+[key] )\r\n                if not typeX in traverse_dic_research[\'type\']:\r\n                    traverse_dic_research[\'type\'][typeX] = {}\r\n                if not TeMP in traverse_dic_research[\'type\'][typeX]:\r\n                    traverse_dic_research[\'type\'][typeX][TeMP] = {}\r\n            np = parents + [key]\r\n            npi = parentsI + [key]\r\n            \r\n\r\n\r\n            if \'inDicI\' in config.keys() and  type(data[key]) == str and config[\'inDicI\'] in data[key].lower():\r\n                traverse_dic_research[\'inDicI\'].append( parentsI + [key] )\r\n\r\n            if \'inDicI\' in config.keys() and  type(data[key]) == list and len(data[key]) and type(data[key][0]) == str:\r\n                for x in data[key]:\r\n                    if showLine( x, config[\'inDicI\'].lower() ):\r\n                        traverse_dic_research[\'inDicI\'].append( parentsI + [key] )\r\n\r\n\r\n            if \'inDic\' in config.keys() and  type(data[key]) == str and config[\'inDic\'] in data[key].lower():\r\n                \r\n                if not str(np) in traverse_dic_research[\'inDic_spent\']:\r\n                    traverse_dic_research[\'inDic_spent\'].append(str(np))\r\n                    traverse_dic_research[\'inDic\'].append( parents + [key] )\r\n                    print_(key)\r\n\r\n\r\n            if \'returnField\' in config.keys() and  config[\'returnField\'] == np:\r\n                traverse_dic_research[\'returnField\'].append({  \'data\':  data[key], \'parents\': np, \'parentsI\': npi,  })\r\n            elif \'returnFields\' in config.keys() and  key in config[\'returnFields\'].keys():\r\n                # print_(\'here\')\r\n                for parent in config[\'returnFields\'][key]:\r\n                    if parent == np:\r\n                        traverse_dic_research[\'returnFields\'].append({  \'data\':  data[key], \'parents\': np, \'parentsI\': npi,  })\r\n                \r\n\r\n            if \'find_field\' in config.keys() and  config[\'find_field\'] == key:\r\n                traverse_dic_research[\'return\'] = data[key]\r\n                return traverse_dic_research[\'return\']\r\n\r\n            if \'find_fields\' in config.keys() and  config[\'find_fields\'] == key:\r\n                if not \'find_fields\' in traverse_dic_research:\r\n                    traverse_dic_research[\'find_fields\'] = []\r\n                traverse_dic_research[\'find_fields\'].append({ \'path\': parents + [key], \'data\': data[key] })\r\n\r\n            if \'find_path\' in config.keys():\r\n                thePath = \'.\'.join(np).replace( \'-i-\', \'i\' )\r\n                if config[\'find_path\'] == thePath:\r\n                    if not \'find_path\' in traverse_dic_research:\r\n                        traverse_dic_research[\'find_path\'] = []\r\n                    traverse_dic_research[\'find_path\'].append( data[key] )\r\n                \r\n\r\n            if \'find_parents\' in config.keys() and  config[\'find_parents\'] == key:\r\n                traverse_dic_research[ config[\'requests\'] ] = np\r\n                return np\r\n                break\r\n            \r\n            if \'key_has\' in config.keys():\r\n                found = False\r\n                if not type(config[\'key_has\']) == list:\r\n                    config[\'key_has\'] = list(config[\'key_has\'])\r\n                for x in config[\'key_has\']:\r\n                    if x.lower() in key.lower():\r\n                        found = True\r\n                if found:\r\n                    if \'requests\' in config.keys():\r\n\r\n                        try:\r\n                            traverse_dic_research[ config[\'requests\'] ].append(np)\r\n                        except Exception as e:\r\n                            traverse_dic_research[ config[\'requests\'] ] = []\r\n                            traverse_dic_research[ config[\'requests\'] ].append(np)\r\n                    else:\r\n                        try:\r\n                            traverse_dic_research[ \'key_has\' ].append(np)\r\n                        except Exception as e:\r\n                            traverse_dic_research[ \'key_has\' ] = []\r\n                            traverse_dic_research[ \'key_has\' ].append(np)\r\n\r\n\r\n\r\n        \r\n            traverse_obj( data[key], config, np, npi )\r\n    # pass\r\n\r\n    # elif hasattr(data, \'__dict__\'):\r\n    #     np = parents + [\'__dict__\']\r\n    #     npi = parentsI + [\'__dict__\']\r\n    #     traverse_obj( data.__dict__, config, np, npi )\r\n    else:\r\n        pass\r\n        try:\r\n            field = parents.pop()\r\n        except Exception as e:\r\n            field = \'\'\r\n        if type(field) == int:\r\n            traverse_dic_research[\'fields\'].append({ \'type\': str(type(data)).split("\'")[1], \'field\': field, \'parents\': parents })\r\n\r\n\r\n\r\n        if \'find_path\' in config.keys():\r\n            thePath = \'.\'.join(parents).replace( \'-i-\', \'i\' )\r\n            # print_(config[\'find_path\'],thePath)\r\n            if config[\'find_path\'].lower() == thePath.lower():\r\n                # print_(thePath)\r\n                if not \'find_path\' in traverse_dic_research:\r\n                    traverse_dic_research[\'find_path\'] = []\r\n                traverse_dic_research[\'find_path\'].append( data )\r\n\r\n        if \'inDicI\' in config.keys() and  type(data) == str and config[\'inDicI\'] in data.lower():\r\n            traverse_dic_research[\'inDicI\'].append( parentsI )\r\n\r\ndef clean_dic_keys( dic, omit ):\r\n    index = { \'A\':{}, \'B\':{} }\r\n    for k in dic.keys():\r\n        u = genUUID()\r\n        index[\'A\'][k] = u\r\n        index[\'B\'][u] = k\r\n        dic[u] = dic[k]\r\n        del dic[k]\r\n    for k in dic.keys():\r\n        n = index[\'B\'][k]\r\n        for o in omit:\r\n            n = n.replace(o,\'\')\r\n\r\n        dic[n] = dic[k]\r\n        del dic[k]\r\n\r\n\r\n\r\ndef justTime(theDate):\r\n    clock = friendlyDate( theDate ).split(\' \')[1]\r\n    clock_parts = clock.split(\':\')\r\n    am_pm = \' AM\'\r\n    if int(clock_parts[0]) > 12:\r\n        am_pm = \' PM\'\r\n        clock_parts[0] = str(  int(clock_parts[0])-12  )\r\n    else:\r\n        clock_parts[0] = str(  int(clock_parts[0])  )\r\n    clock_parts.pop(2)\r\n    clock = \':\'.join(clock_parts)\r\n    return clock+am_pm\r\n    \r\n\r\n\r\ndef wrapText( data, length=150, pre_space=\'    \', scan=[], bold=\'yellow\', s=\' \', p=True ):\r\n    currentLength = len(pre_space)\r\n    theText = \'\'\r\n    data = pre_space + data\r\n    dice_scan = [  ]\r\n    for word in data.split(s):\r\n        if len(scan):\r\n            for sn in scan:\r\n                if sn.lower() in word.lower():\r\n                    word = colorThis( word, bold, p=0 )\r\n\r\n        if \'\\n\' in word:\r\n            word = word.replace( \'\\n\', \'\\n\'+pre_space )\r\n\r\n        if currentLength + len(word) > length:\r\n            theText += \'\\n\'+pre_space\r\n            currentLength = len(pre_space)\r\n\r\n        currentLength += len(word)\r\n        theText += word + s\r\n        if \'\\n\' in word or currentLength > length:\r\n            currentLength = len(pre_space)\r\n    if not theText is None:\r\n        if theText[-2:] == s+s and not data[-2:] == s+s and data[-1:] == s:\r\n            theText = theText[:-1]\r\n        elif theText[-1:] == s and not data[-1:] == s:\r\n            theText = theText[:-1]\r\n        data = \'\'\r\n        pre_space = \'\'\r\n        if p:\r\n            print_( theText )\r\n        else:\r\n            # print_( \'\\n\\ntheText:\', theText, \'\\n\\n\' )\r\n            return theText\r\n\r\n\r\ndef simpleDic( dic ):\r\n    txt = str(dic)\r\n    txt = txt.replace( \'{\', \'\' )\r\n    txt = txt.replace( \'}\', \'\' )\r\n    txt = txt.replace( \'"\', \'\' )\r\n    txt = txt.replace( "\'", \'\' )\r\n    txt = txt.replace( \'_\', \' \' )\r\n    txt = txt.title()\r\n    return txt\r\ndef simpleDic2( dic ):\r\n    txt = str(dic)\r\n    # print_( txt )\r\n    txt = txt.replace( ", \'", ",\\n\'" )\r\n    txt = txt.replace( \'{\', \'\' )\r\n    txt = txt.replace( \'}\', \'\' )\r\n    txt = txt.replace( \'"\', \'\' )\r\n    txt = txt.replace( "\'", \'\' )\r\n    txt = txt.replace( \'_\', \' \' )\r\n    txt = txt.title()\r\n    return txt\r\n\r\ndef lastBackup( file, backup=0 ):\r\n    backupLog = tables.returnSorted( \'backupLog\', \'d.timestamp\', getTable(\'fileBackup.json\') )\r\n    path = os.path.abspath(file)\r\n    # print_( \'path:\', path )\r\n    if backup == \'?\':\r\n\r\n        i = 0\r\n        for record in backupLog:\r\n            if record[\'file\'] == path:\r\n                i+=1\r\n        part = path.split( _v.slash )\r\n        part.reverse()\r\n        label = part[0]\r\n        colorThis( [ \'\\n\\ttotol of\', i , \'backups for \', label ], \'yellow\' )\r\n        sys.exit()\r\n\r\n    else:\r\n        i = 0\r\n        for record in backupLog:\r\n            if record[\'file\'] == path:\r\n                # printTest( record )\r\n                # print_( friendlyDate(record[\'timestamp\']) )\r\n                if i == backup:\r\n                    return record[\'backup\']\r\n                i+=1\r\n\r\n\r\n        i = 0\r\n        for record in backupLog:\r\n            if record[\'file\'] == path:\r\n                i+=1\r\n        part = path.split( _v.slash )\r\n        part.reverse()\r\n        label = part[0]\r\n        colorThis( [ \'\\n\\ttotol of\', i , \'backups for \', label ], \'yellow\' )\r\n        sys.exit()\r\n\r\n        # id timestamp file backup status version flag\r\n\r\n\r\n    return None\r\n\r\ndef textClean( txt ):\r\n    clean = 2\r\n    \r\n    if clean:\r\n        txt = _str.replaceDuplicate( txt, \'\\n\' )\r\n        txt = _str.cleanBE( txt, \'\\n\' )\r\n    if clean == 2:\r\n        txt = txt.replace( \'\\t\', \' \' )\r\n        txt = _str.replaceDuplicate( txt, \' \' )\r\n        while \'\\n \\n\' in txt:\r\n            txt = txt.replace( \'\\n \\n\', \'\\n\' )\r\n        txt = _str.replaceDuplicate( txt, \'\\n\' )\r\n        txt = _str.cleanBE( txt, \'\\n\' )\r\n    return txt\r\n\r\ndef get_size(obj, seen=None):\r\n    # return 0\r\n    if obj is None:\r\n        return 0\r\n    \r\n    # function source documentation:\r\n    #   searched for: python how much memory usage of list of dict\r\n    #   https://goshippo.com/blog/measure-real-size-any-python-object/\r\n\r\n    """Recursively finds size of objects"""\r\n    size = sys.getsizeof(obj)\r\n    if seen is None:\r\n        seen = set()\r\n    obj_id = id(obj)\r\n    if obj_id in seen:\r\n        return 0\r\n    # Important mark as seen *before* entering recursion to gracefully handle\r\n    # self-referential objects\r\n    seen.add(obj_id)\r\n    if isinstance(obj, dict):\r\n        size += sum([get_size(v, seen) for v in obj.values()])\r\n        size += sum([get_size(k, seen) for k in obj.keys()])\r\n    elif hasattr(obj, \'__dict__\'):\r\n        size += get_size(obj.__dict__, seen)\r\n    elif hasattr(obj, \'__iter__\') and not isinstance(obj, (str, bytes, bytearray)):\r\n        size += sum([get_size(i, seen) for i in obj])\r\n    return size\r\n\r\n\r\nbmIndex = []\r\n""" {7DB6A001-0637-4F13-B328-2B17A481CF35}\r\nprocessWordStem = None\r\ndef wordStem(word):\r\n    global processWordStem\r\n    if processWordStem is None:\r\n        import nltk\r\n        from nltk.stem import PorterStemmer\r\n        from nltk.tokenize import word_tokenize\r\n        processWordStem = PorterStemmer()\r\n    return processWordStem.stem(word)\r\n"""\r\n\r\n\r\n\r\nclass CacheManager:\r\n# get_size()\r\n\r\n    def __init__( self ):\r\n        pass\r\n\r\n    def load( self, config ):\r\n        return None\r\n\r\n    def save( self, data, config ):\r\n        return data\r\n\r\n    # def \r\n\r\n\r\n\r\n# __.app = CacheManager()\r\n\r\ndef genSerial( subject ):\r\n    serial_no = getText( _v.myVars + _v.slash+\'sequence-\'+subject+\'.serial\', clean=2, raw=1 )\r\n    if serial_no is None:\r\n        serial_no = 12345\r\n    else:\r\n        serial_no = int(serial_no)+1\r\n    saveText( str(serial_no), _v.myVars + _v.slash+\'sequence-\'+subject+\'.serial\' )\r\n    return serial_no\r\n\r\n\r\ndef extTrigger__File_TYPE__( data ):\r\n    data = data.lower()\r\n    archive = [\r\n                \'*.7z\',\r\n                \'*.s7z\',\r\n                \'*.ace\',\r\n                \'*.afa\',\r\n                \'*.alz\',\r\n                \'*.apk\',\r\n                \'*.arc\',\r\n                \'*.ark\',\r\n                \'*.cdx\',\r\n                \'*.arj\',\r\n                \'*.b1\',\r\n                \'*.b6z\',\r\n                \'*.ba\',\r\n                \'*.bh\',\r\n                \'*.cab\',\r\n                \'*.car\',\r\n                \'*.cfs\',\r\n                \'*.cpt\',\r\n                \'*.dar\',\r\n                \'*.dd\',\r\n                \'*.dgc\',\r\n                \'*.dmg\',\r\n                \'*.ear\',\r\n                \'*.gca\',\r\n                \'*.ha\',\r\n                \'*.hki\',\r\n                \'*.ice\',\r\n                \'*.jar\',\r\n                \'*.kgb\',\r\n                \'*.lzh\',\r\n                \'*.lha\',\r\n                \'*.lzx\',\r\n                \'*.pak\',\r\n                \'*.partimg\',\r\n                \'*.paq6\',\r\n                \'*.paq7\',\r\n                \'*.paq8\',\r\n                \'*.pea\',\r\n                \'*.pim\',\r\n                \'*.pit\',\r\n                \'*.qda\',\r\n                \'*.rar\',\r\n                \'*.rk\',\r\n                \'*.sda\',\r\n                \'*.sea\',\r\n                \'*.sen\',\r\n                \'*.sfx\',\r\n                \'*.shk\',\r\n                \'*.sit\',\r\n                \'*.sitx\',\r\n                \'*.sqx\',\r\n                \'*.tar\',\r\n                \'*.tar.gz\',\r\n                \'*.tgz\',\r\n                \'*.tar.Z\',\r\n                \'*.tar.bz2\',\r\n                \'*.tbz2\',\r\n                \'*.tar.lzma\',\r\n                \'*.tlz.\',\r\n                \'*.tar.xz\',\r\n                \'*.txz\',\r\n                \'*.uc\',\r\n                \'*.uc0\',\r\n                \'*.uc2\',\r\n                \'*.ucn\',\r\n                \'*.ur2\',\r\n                \'*.ue2\',\r\n                \'*.uca\',\r\n                \'*.uha\',\r\n                \'*.war\',\r\n                \'*.wim\',\r\n                \'*.xar\',\r\n                \'*.xp3\',\r\n                \'*.yz1\',\r\n                \'*.zip\',\r\n                \'*.zipx\',\r\n                \'*.zoo\',\r\n                \'*.zpaq\',\r\n                \'*.zz\'\r\n            ]\r\n\r\n    office = [\r\n                \'*.doc\',\r\n                \'*.dot\',\r\n                \'*.wbk\',\r\n                \'*.docx\',\r\n                \'*.docm\',\r\n                \'*.dotx\',\r\n                \'*.dotm\',\r\n                \'*.docb\',\r\n                \'*.xls\',\r\n                \'*.xlt\',\r\n                \'*.xlm\',\r\n                \'*.xlsx\',\r\n                \'*.xlsm\',\r\n                \'*.xltx\',\r\n                \'*.xltm\',\r\n                \'*.xlsb\',\r\n                \'*.xla\',\r\n                \'*.xlam\',\r\n                \'*.xll\',\r\n                \'*.xlw\',\r\n                \'*.ppt\',\r\n                \'*.pot\',\r\n                \'*.pps\',\r\n                \'*.pptx\',\r\n                \'*.pptm\',\r\n                \'*.potx\',\r\n                \'*.potm\',\r\n                \'*.ppam\',\r\n                \'*.ppsx\',\r\n                \'*.ppsm\',\r\n                \'*.sldx\',\r\n                \'*.sldm\',\r\n                \'*.pub\',\r\n                \'*.xps\'\r\n            ]\r\n    pass\r\n    # archive\r\n    # office\r\n    \r\n\r\n\r\ndef urlTrigger(url):\r\n    if not \'.\' in url:\r\n        url = \'http://\' + url + \'.com\'\r\n    elif not url.startswith(\'http\'):\r\n        url = \'http://\' + url\r\n    return url\r\n\r\ndef myFolderLocations( data ):\r\n    return data\r\n    # print_(data)\r\n    if type(data) == list:\r\n        for i,d in enumerate(data):\r\n            data[i] = myFolderLocations(d)\r\n        return data\r\n\r\n    if os.path.isdir(data):\r\n        return os.path.abspath(data)\r\n    \r\n\r\n    global bmIndex\r\n    \r\n    if not len(bmIndex):\r\n        bmIndex = getTable( \'bookmarks.index\' )\r\n\r\n    # print_( bmIndex )\r\n    if data in bmIndex[\'labels\']:\r\n        return _v.resolveFolderIDs(bmIndex[\'labels\'][data])\r\n    if data.lower() in bmIndex[\'labels\']:\r\n        return _v.resolveFolderIDs(bmIndex[\'labels\'][data.lower()])\r\n    if data.upper() in bmIndex[\'labels\']:\r\n        return _v.resolveFolderIDs(bmIndex[\'labels\'][data.upper()])\r\n    if data.title() in bmIndex[\'labels\']:\r\n        return _v.resolveFolderIDs(bmIndex[\'labels\'][data.title()])\r\n\r\n\r\n    return data\r\n\r\ndef mod(path):\r\n    return os.path.getmtime(path)\r\n\r\n\r\n\r\ndef colorPlus( data, color=\'green\' ):\r\n    for search in switches.values(\'Plus\'):\r\n        for subject in caseUnspecific( data, search, isPlus=True ):\r\n\r\n            if type( subject ) == str:\r\n                data = data.replace( subject, colorThis( subject, color, p=0 ) )\r\n            else:\r\n                if subject[\'pos\'] == \'first\':\r\n                    data = nth_repl(data, subject[\'data\'], colorThis( subject[\'data\'], color, p=0 ), 1)\r\n                else:\r\n                    cx = data.count( subject[\'data\'] )\r\n                    data = nth_repl(data, subject[\'data\'], colorThis( subject[\'data\'], color, p=0 ), cx)\r\n    return data\r\n\r\ndef plusColor( row, color=\'green\' ):\r\n    # row = thePrintLine\r\n\r\n    if switches.isActive(\'Plus\'):\r\n        thePrintLine = row\r\n        for plusSearchX in switches.values(\'Plus\'):\r\n            plusSearchX = ci( plusSearchX )\r\n\r\n            for subject in caseUnspecific( row, plusSearchX ):\r\n                row = thePrintLine.replace( subject, colorThis( subject, color , p=0 ) )\r\n\r\n    return row\r\n\r\ndef caseUnspecific( data, subject, isPlus=False, minus=None ):\r\n\r\n    if not minus is None:\r\n        if type(minus) == list:\r\n            for remove in minus:\r\n                for deleteThis in caseUnspecific( data, remove.lower(), isPlus=False ):\r\n                    data = data.replace( deleteThis, \'\' )\r\n        elif type(minus) == str:\r\n            for deleteThis in caseUnspecific( data, minus.lower(), isPlus=False ):\r\n                data = data.replace( deleteThis, \'\' )\r\n\r\n    results = []\r\n    subject = subject.lower()\r\n    if isPlus:\r\n        if \'*\' in subject and len(subject) > 1:\r\n            if subject.startswith(\'*\'):\r\n                subject = subject.replace( \'*\', \'\' )\r\n                subject = ci(subject)\r\n                if data.lower().endswith( subject ):\r\n                    return [{ \'data\': data[-len(subject):], \'pos\': \'last\' }]\r\n                return []\r\n            if subject.endswith(\'*\'):\r\n                subject = subject.replace( \'*\', \'\' )\r\n                subject = ci(subject)\r\n                if data.lower().startswith( subject ):\r\n                    return [{ \'data\': data[:len(subject)], \'pos\': \'first\' }]\r\n                return []\r\n        subject = ci(subject)\r\n            \r\n\r\n    while data.lower().find( subject ) > -1:\r\n        scanning = data.lower().find( subject )\r\n        subjectY = \'\'\r\n        scanComplete = False\r\n        while not scanComplete:\r\n            if len(subjectY) == len(subject):\r\n                scanComplete = True\r\n            elif scanning > len(data)-1:\r\n                scanComplete = True\r\n            else:\r\n                subjectY += data[ scanning ]\r\n            scanning += 1\r\n        if not subjectY in results:\r\n            results.append( subjectY )\r\n        data = data.replace( subjectY, \'\' )\r\n    return results\r\n\r\ndef nth_repl(s, sub, repl, nth):\r\n\r\n    # first and only thing a got online\r\n\r\n    find = s.find(sub)\r\n    # if find is not p1 we have found at least one match for the substring\r\n    i = find != -1\r\n    # loop util we find the nth or we find no match\r\n    while find != -1 and i != nth:\r\n        # find + 1 means we start at the last match start index + 1\r\n        find = s.find(sub, find + 1)\r\n        i += 1\r\n    # if i  is equal to nth we found nth matches so replace\r\n    if i == nth:\r\n        return s[:find]+repl+s[find + len(sub):]\r\n    return s\r\n\r\n\r\ndef shuffle( myList ):\r\n    result = []\r\n    data = []\r\n    for x in myList:\r\n        data.append({ \'data\': x, \'sortBy\': genUUID() })\r\n\r\n    for record in tables.returnSorted( genUUID(), \'d.sortBy\', data ):\r\n        result.append( record[\'data\'] )\r\n    return result\r\n\r\n\r\n\r\n# oc = list(filter(lambda data: data[\'open\'] == pos, record[\'oc\']))\r\n__.loadingVar = {\r\n                    \'hasLoaded\': False,\r\n                    \'hasCleared\': False,\r\n                    \'isRunning\': False,\r\n                    \'done\': False,\r\n}\r\n\r\n\r\n__.loadingVar[\'hasLoaded\'] = False\r\n__.loadingVar[\'hasCleared\'] = False\r\n__.loadingVar[\'isRunning\'] = False\r\n\r\ndef listColor( text, rows, color=\'green\' ):\r\n    return text\r\n    r = text\r\n\r\n    # print_( \'HERE\', r )\r\n    txtCNT = text.lower()\r\n    for row in rows:\r\n\r\n        loc = txtCNT.find( row )\r\n        if row in txtCNT:\r\n            print_( \'loc:\', loc )\r\n            if loc:\r\n                r = \'\'\r\n                for i,char in enumerate(text):\r\n                    if i >= loc and i <= len(row)-1:\r\n                        print_( char )\r\n                        r += colorThis( char, color, p=0 )\r\n                    else:\r\n                        r+=char\r\n    return r\r\n\r\n\r\n\r\ndef LoadingDone(done=None):\r\n    if not done is None:\r\n        __.loadingVar[\'done\'] = done\r\n    __.loadingVar[\'hasLoaded\'] = True\r\n    \r\n    global threads\r\n    while not __.loadingVar[\'hasCleared\']:\r\n        time.sleep( .2 )\r\n    time.sleep( .7 )\r\n    print_( \'                                                        \', end=\'\\r\' )\r\n    time.sleep( 2 )\r\n    __.loadingVar[\'hasCleared\'] = False\r\n    __.loadingVar[\'hasLoaded\'] = False\r\n    __.loadingVar[\'isRunning\'] = False\r\n    del threads\r\n    threads = Queue()\r\n\r\ndef loadingAnimation(loading=\'Searching\',done=\'Found\' ):\r\n    __.loadingVar[\'done\'] = done\r\n    if not __.loadingVar[\'isRunning\']:\r\n        __.loadingVar[\'isRunning\'] = True\r\n        global threads\r\n        theID = \'loadingAnimation_\'+loading+\'_\' + genUUID()\r\n        threads.add( theID ) # kwargs \r\n        threads.maxThreadsSafe = 225\r\n        threads.autoLoadedAfter = .1\r\n        threads.scheduleLoop = .01\r\n        threads.auditLoop = .1\r\n        threads.projectDataMaxLen = 500\r\n        threads.report = False\r\n        threads.auditPrint = False\r\n        threads.add( theID, loadingGif, [loading] )\r\n\r\n\r\ndef loadingGif(loading, qID=False):\r\n    \r\n    gif = [\r\n            \'       *\',\r\n            \'      **\',\r\n            \'     ***\',\r\n            \'    *** \',\r\n            \'   ***  \',\r\n            \'  ***   \',\r\n            \' ***    \',\r\n            \'***     \',\r\n            \'**      \',\r\n            \'*       \',\r\n            \'**      \',\r\n            \'***     \',\r\n            \' ***    \',\r\n            \'  ***   \',\r\n            \'   ***  \',\r\n            \'    *** \',\r\n            \'     ***\',\r\n            \'      **\',\r\n    ]\r\n    while not __.loadingVar[\'hasLoaded\']:\r\n        print_( \'                                                                                                   \', end=\'\\r\' )\r\n        for x in gif:\r\n            animate = colorThis( x, \'red\', p=0 )\r\n            print_( \'\\t\\t{\' + animate + \'} \'+loading+\'...\', end=\'\\r\' )\r\n            time.sleep( .4 )\r\n        print_( \'                                                                                                   \', end=\'\\r\' )\r\n    print_( \'                                                                                                   \', end=\'\\r\' )\r\n    print_( \'\\t\\t\'+colorThis( __.loadingVar[\'done\'], \'green\', p=0 ), end=\'\\r\' )\r\n    if not type(qID) == bool:\r\n        global threads\r\n        threads.spent( qID, sys.getsizeof( \'obj\') )\r\n    __.loadingVar[\'hasCleared\'] = True\r\n\r\n        \r\ndef loadingGifX(loading):\r\n    \r\n    gif = [\r\n            \'       *\',\r\n            \'      **\',\r\n            \'     ***\',\r\n            \'    *** \',\r\n            \'   ***  \',\r\n            \'  ***   \',\r\n            \' ***    \',\r\n            \'***     \',\r\n            \'**      \',\r\n            \'*       \',\r\n            \'**      \',\r\n            \'***     \',\r\n            \' ***    \',\r\n            \'  ***   \',\r\n            \'   ***  \',\r\n            \'    *** \',\r\n            \'     ***\',\r\n            \'      **\',\r\n    ]\r\n    while not __.loadingVar[\'hasLoaded\']:\r\n        print_( \'                                                                                                   \', end=\'\\r\' )\r\n        for x in gif:\r\n            animate = colorThis( x, \'red\', p=0 )\r\n            print_( \'\\t\\t{\' + animate + \'} \'+loading+\'...\', end=\'\\r\' )\r\n            time.sleep( .4 )\r\n        print_( \'                                                                                                   \', end=\'\\r\' )\r\n    print_( \'                                                                                                   \', end=\'\\r\' )\r\n    print_( \'\\t\\t\'+colorThis( __.loadingVar[\'done\'], \'green\', p=0 ), end=\'\\r\' )\r\n\r\n    __.loadingVar[\'hasLoaded\'] = False\r\n\r\n\r\n\r\nserver_proxy = []\r\nserver_proxy.append( \'\' )\r\nserver_proxy.append( \'http://www.rightthumb.com/projects/widget/proxy.php?p=\' )\r\nserver_proxy.append( \'http://rephrecruiting.com/proxy.php?p=\' )\r\nserver_proxy.append( \'http://www.pillerbeauty.com/proxy.php?p=\' )\r\nserver_proxy.append( \'http://signaturemassageandfacialspa.com/p.php?p=\' )\r\nserver_proxy.append( \'https://signaturemassagetampa.com/payroll/p.php?p=\' )\r\n\r\nappProxy = \'appProxy.json\'\r\n\r\nipsum = None\r\ndef ipsumSentence():\r\n    global ipsum\r\n    if ipsum is None:\r\n        ipsum = getText( _v.ipsum, raw=True, clean=2 )\r\n    ipsum = ipsum.replace( \'\\n\', \' \' )\r\n    sentences = []\r\n    for sentence in ipsum.split(\'.\'):\r\n        sentence = _str.replaceDuplicate( sentence, \' \' )\r\n        sentence = _str.cleanBE( sentence, \' \' )\r\n        sentence = sentence + \'.\'\r\n        sentences.append({ \'sentence\': sentence, \'sortBy\': genUUID() })\r\n\r\n    randomized = tables.returnSorted( \'data\', \'d.sortBy\', sentences )\r\n    return randomized[0][\'sentence\']\r\n\r\ndef ipsumParagraph( count=1, shouldPrint=False, returnList=False, lorem=True ):\r\n    global ipsum\r\n    if ipsum is None:\r\n        ipsum = getText( _v.ipsum, raw=True, clean=2 )\r\n    paragraphs = []\r\n    for item in ipsum.split(\'\\n\'):\r\n        item = _str.replaceDuplicate( item, \' \' )\r\n        item = _str.cleanBE( item, \' \' )\r\n        item = item + \'.\'\r\n        item = _str.replaceDuplicate( item, \'.\' )\r\n        paragraphs.append({ \'paragraph\': item, \'sortBy\': genUUID() })\r\n\r\n    randomized = tables.returnSorted( \'data\', \'d.sortBy\', paragraphs )\r\n\r\n    result = []\r\n\r\n    i=0\r\n    while not i == count:\r\n        result.append( randomized[i][\'paragraph\'] )\r\n        i+=1\r\n\r\n    if lorem:\r\n        result[0] = \'Lorem ipsum \' + result[0][0].lower() + result[0][1:]\r\n\r\n    \r\n\r\n    if shouldPrint:\r\n        data = \'\\n\\n\'.join( result )\r\n        print_( data )\r\n\r\n    if returnList:\r\n        return result\r\n    else:\r\n        return \'\\n\\n\'.join( result )\r\n\r\ndef saveCSV( data, file, printThis=True,                p=None, me=0 ):\r\n    theFile=file\r\n    HD.chmod(file)\r\n    if not p is None:\r\n        printThis = p\r\n\r\n\r\n    import csv\r\n    px = \'\'\r\n    if file.startswith(\'temp\'+_v.slash):\r\n        file = file.replace( \'temp\'+_v.slash, \'\' )\r\n        theFile = _v.stmp + _v.slash + file\r\n        px = theFile\r\n    elif _v.slash in file:\r\n        theFile = file\r\n        px = theFile\r\n    else:\r\n        theFile = _v.myTables + _v.slash + file\r\n        px = file\r\n\r\n\r\n    with open( theFile , mode=\'w\') as csv_file:\r\n        fields = list(data[0].keys())\r\n        writer = csv.DictWriter(csv_file, fieldnames=fields)\r\n\r\n        writer.writeheader()\r\n        for record in data:\r\n            writer.writerow( record )\r\n    cleanFile = getText( theFile, raw=True )\r\n    cleanFile = _str.replaceDuplicate( cleanFile, \'\\n\' )\r\n    saveText( cleanFile, theFile )\r\n    if printThis:\r\n        printBold(\'Saved: \' + px, \'blue\')\r\n    if me and theFile in vv.opened_file_me: changeM( theFile, vv.opened_file_me[theFile] );\r\n\r\ndef getCSV( file, save=False, json_file=\'\', printThis=True ):\r\n    theFile=file\r\n    if os.path.isfile(theFile): vv.opened_file_me[theFile] = os.path.getmtime( theFile );\r\n    if file.startswith(\'temp\'+_v.slash):\r\n        file = file.replace( \'temp\'+_v.slash, \'\' )\r\n        theFile = _v.stmp + _v.slash + file\r\n    elif _v.slash in file:\r\n        theFile = file\r\n    else:\r\n        theFile = _v.myTables + _v.slash + file\r\n\r\n    return csv( file=theFile, save=save, json_file=json_file, printThis=printThis )\r\n\r\ndef csvTXT( data ):\r\n    import csv\r\n    csv_rows = []\r\n    reader = csv.DictReader(data)\r\n    title = reader.fieldnames\r\n    for row in reader:\r\n        csv_rows.extend([{title[i]:row[title[i]] for i in range(len(title))}])\r\n    return csv_rows\r\ndef csv( file, save=False, json_file=\'\',printThis=True ):\r\n    import csv\r\n    if type(save) == str:\r\n        json_file = save\r\n        save = True\r\n\r\n    elif len(json_file):\r\n        save = True\r\n    elif save and json_file == \'\':\r\n        json_file = changeExtension( row, \'json\' )\r\n    csv_rows = []\r\n    # with open(file, \'r\', encoding=\'utf-8\') as csvfile:\r\n    # with open(file, \'r\', encoding=\'utf-8\', errors="surrogateescape") as csvfile:\r\n    # with open(file, \'r\', encoding=\'ascii\', errors="replace") as csvfile:\r\n    with open( file, \'r\', encoding=\'ascii\', errors=\'ignore\' ) as csvfile:\r\n    # with open(file) as csvfile:\r\n        reader = csv.DictReader(csvfile)\r\n        title = reader.fieldnames\r\n        # print_( title )\r\n        # for t in title:\r\n        #   print_( t )\r\n        for row in reader:\r\n            csv_rows.extend([{title[i]:row[title[i]] for i in range(len(title))}])\r\n        csv_rows = convertTimestamp( csv_rows )\r\n        if save:\r\n            saveTable2(csv_rows,json_file)\r\n            if printThis:\r\n                printBold( json_file, \'green\' )\r\n        fixField = False\r\n        \r\n        # if False:\r\n        if True:\r\n            try:\r\n                for field in csv_rows[0].keys():\r\n                    if \'"\' in field:\r\n                        fixField = True\r\n            except Exception as e:\r\n                pass\r\n            if fixField:\r\n                for record in csv_rows:\r\n                    for field in record.keys():\r\n                        if \'"\' in field:\r\n                            tmpF = field.split(\'"\')\r\n                            record[ tmpF[1] ] = record[field]\r\n                            del record[field]\r\n        return csv_rows\r\n    return False\r\n\r\ndef csv2( data, file, printThis=True, p=None ):\r\n    if not p is None:\r\n        printThis = p\r\n    saveText(csvText( data ),file)\r\n    if printThis:\r\n        printBold( file, \'green\' )\r\n\r\ndef csvText( data ):\r\n    if not type(data) == list:\r\n        cp( \'Error: csvText, expected list\', \'red\' )\r\n    if not len(data):\r\n        return \'\'\r\n\r\n    alphanumeric = \' 0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!#$%&\\\'()*+-./:;<=>?@[\\\\]^_`{|}~\'\r\n\r\n\r\n    records = []\r\n    line = []\r\n    keys = []\r\n    for field in data[0].keys():\r\n        keys.append(field)\r\n        subject = field\r\n        isAlpha = True\r\n        for s in subject:\r\n            if not s in alphanumeric:\r\n                isAlpha = False\r\n        if not isAlpha:\r\n            subject = \'"\'+str( [field] )[2:-2]+\'"\'\r\n        line.append( subject )\r\n        \r\n    records.append( \',\'.join(line) )\r\n\r\n    for record in data:\r\n        line = []\r\n        for f in keys:\r\n            subject = record[f]\r\n            isAlpha = True\r\n            for s in subject:\r\n                if not s in alphanumeric:\r\n                    isAlpha = False\r\n            if not isAlpha:\r\n                subject = \'"\'+str( [subject] )[2:-2]+\'"\'\r\n            line.append( subject )\r\n        records.append( \',\'.join(line) )\r\n\r\n\r\n    return \'\\n\'.join( records )\r\n    # return records\r\n\r\n    # sys.exit()\r\n\r\n\r\ndef convertTimestamp( data ):\r\n    if not len( data ):\r\n        return data\r\n    if not \'timestamp\' in data[0].keys():\r\n        return data\r\n    if \'datetime\' in data[0].keys():\r\n        hasDateTime = True\r\n    else:\r\n        hasDateTime = False\r\n    for i,record in enumerate(data):\r\n        try:\r\n            if len( record[\'timestamp\'] ):\r\n                if isFloat( str(record[\'timestamp\']) ):\r\n                    if not hasDateTime:\r\n                        data[i][\'datetime\'] = resolveEpoch( data[i][\'timestamp\'] )\r\n                    else:\r\n                        return data\r\n                else:\r\n                    data[i][\'timestamp\'] = autoDate( record[\'timestamp\'] )\r\n                    if not hasDateTime:\r\n                        data[i][\'datetime\'] = resolveEpoch( data[i][\'timestamp\'] )\r\n        except Exception as e:\r\n            return data\r\n    return data\r\n\r\ndef changeExtension( file, ext ):\r\n    f = removeExtension( file )\r\n    if not \'.\' in ext:\r\n        return f + \'.\' + ext\r\n    else:\r\n        return f + ext\r\n\r\ndef getExtension(string):\r\n\r\n    ext0 = string.split(\'.\')\r\n    extId = len(ext0) - 1\r\n    if extId > 0:\r\n        ext = ext0[extId]\r\n    else:\r\n        ext = \'\'\r\n    return ext\r\ndef removeExtension(string):\r\n    if not \'.\' in string:\r\n        return string\r\n    ext = getExtension(string)\r\n    sl = len(string)\r\n    el = len(ext)\r\n    dl = (sl - el) - 1\r\n    file = \'\'\r\n    for i,n in enumerate(string):\r\n        if i < dl:\r\n            file += n\r\n\r\n    return file\r\n\r\n\r\ndef registerSpent( app, spentID ):\r\n    global appProxy\r\n    data = getTable( appProxy )\r\n    for i,record in enumerate(data):\r\n        if record[\'app\'] == app:\r\n            pass\r\n    saveTable( appProxy )\r\n\r\n# colorizeRow\r\n# printBold\r\n\r\n__.color_palette = 0\r\n\r\n# from timeout import timeout\r\nplusClose = 70\r\nautoBackupData = False\r\nautoLoadData = False\r\n\r\nidResolution = []\r\n\r\ntheExtensionsList = []\r\nrelevantFolders = []\r\nsetPipeDataRan = False\r\n\r\n__.columnAbbreviations = 1\r\n\r\n# print_( \'make pattern algorithm for pattern IDs\' )\r\n\r\n# def testPatterns( two, one ):\r\n\r\ndef saveData( rows, theFile, printThis=True ):\r\n    HD.chmod(theFile)\r\n    if theFile.lower().endswith( \'.json\' ):\r\n        if _v.slash in theFile:\r\n            saveTable2( rows, theFile, printThis )\r\n            if printThis:\r\n                print_( \'Saved: \', theFile )\r\n        else:\r\n            saveTable( rows, theFile, printThis )\r\n        return True\r\n\r\n    if theFile.lower().endswith( \'.txt\' ):\r\n        if _v.slash in theFile:\r\n            saveText( rows, theFile )\r\n            if printThis:\r\n                print_( \'Saved: \', theFile )\r\n        else:\r\n            if os.path.isfile( _v.myTables + _v.slash + theFile ):\r\n                saveText( rows, _v.myTables + _v.slash + theFile )\r\n            else:\r\n                saveText( rows, _v.myTables + _v.slash + theFile )\r\n            if printThis:\r\n                print_( \'Saved: \', _v.myTables + _v.slash + theFile )\r\n        return True\r\n\r\n    location = theFile\r\n    if os.path.isfile( theFile ):\r\n        found = True\r\n    \r\n    if not os.path.isfile( theFile ):\r\n        found = False\r\n        if not _v.slash in theFile:\r\n            if not \'.\' in theFile:\r\n                if os.path.isfile( _v.myTables + _v.slash + theFile + \'.json\' ):\r\n                    found = True\r\n                    location = _v.myTables + _v.slash + theFile + \'.json\'\r\n                elif os.path.isfile( _v.myTables + _v.slash + theFile + \'.txt\' ):\r\n                    found = True\r\n                    location = _v.myTables + _v.slash + theFile + \'.txt\'\r\n                elif os.path.isfile( _v.myTables + _v.slash + theFile + \'.txt\' ):\r\n                    found = True\r\n                    location = _v.myTables + _v.slash + theFile + \'.txt\'\r\n            else:\r\n                if os.path.isfile( _v.myTables + _v.slash + theFile ):\r\n                    found = True\r\n                    location = _v.myTables + _v.slash + theFile\r\n                elif os.path.isfile( _v.myTables + _v.slash + theFile ):\r\n                    found = True\r\n                    location = _v.myTables + _v.slash + theFile\r\n\r\n\r\n    if found:\r\n        if location.lower().endswith( \'.json\' ):\r\n            saveTable2( rows, location, printThis )\r\n            if printThis:\r\n                print_( \'Saved: \', location )\r\n            return True\r\n\r\n        if location.lower().endswith( \'.txt\' ):\r\n            saveText( rows, location )\r\n            if printThis:\r\n                print_( \'Saved: \', location )\r\n            return True\r\n\r\n\r\n    t = type( rows )\r\n    if t == str:\r\n        location = _v.myTables + _v.slash + theFile + \'.txt\'\r\n        saveText( rows, location )\r\n        if printThis:\r\n            print_( \'Saved: \', location )\r\n        return True\r\n\r\n    if t == dict:\r\n        saveTable( rows, theFile+\'.json\', printThis )\r\n        return True\r\n    if t == list:\r\n        if len(rows) == 0:\r\n            print_( \'Error: no data to save\' )\r\n            return False\r\n\r\n        t = type( rows[0] )\r\n        if t == dict:\r\n            saveTable( rows, theFile+\'.json\', printThis )\r\n            return True\r\n        pass\r\n        if t == str:\r\n            location = _v.myTables + _v.slash + theFile + \'.txt\'\r\n            saveText( rows, location )\r\n            if printThis:\r\n                print_( \'Saved: \', location )\r\n            return True\r\n\r\n    print_( \'Error: unable to save file\' )\r\n    return False\r\n\r\n\r\n\r\ndef getData( theFile, exitOnError=False ):\r\n    if os.path.isfile(theFile): vv.opened_file_me[theFile] = os.path.getmtime( theFile );\r\n    location = theFile\r\n    if os.path.isfile( theFile ):\r\n        found = True\r\n    \r\n    if not os.path.isfile( theFile ):\r\n        found = False\r\n        if not _v.slash in theFile:\r\n            if not \'.\' in theFile:\r\n                if os.path.isfile( _v.myTables + _v.slash + theFile + \'.json\' ):\r\n                    found = True\r\n                    location = _v.myTables + _v.slash + theFile + \'.json\'\r\n                elif os.path.isfile( _v.myTXT + _v.slash + theFile + \'.txt\' ):\r\n                    found = True\r\n                    location = _v.myTXT + _v.slash + theFile + \'.txt\'\r\n                elif os.path.isfile( _v.myTables + _v.slash + theFile + \'.txt\' ):\r\n                    found = True\r\n                    location = _v.myTables + _v.slash + theFile + \'.txt\'\r\n            else:\r\n                if os.path.isfile( _v.myTables + _v.slash + theFile ):\r\n                    found = True\r\n                    location = _v.myTables + _v.slash + theFile\r\n                elif os.path.isfile( _v.myTXT + _v.slash + theFile ):\r\n                    found = True\r\n                    location = _v.myTXT + _v.slash + theFile\r\n\r\n        if not found:\r\n            print_( \'Error: unable to locate file\' )\r\n            if exitOnError:\r\n                sys.exit()\r\n            return []\r\n\r\n\r\n\r\n    if not os.path.isfile( theFile ):\r\n        if location.lower().endswith( \'.json\' ):\r\n            return getTable2( location )\r\n\r\n\r\n\r\n    file = getText( location, raw=True, clean=1 )\r\n    textList = file.split(\'\\n\')\r\n    if \'[\' in textList or \'{\' in textList:\r\n        data = eval( file )\r\n    else:\r\n        data = textList\r\n    return data\r\n\r\n\r\n\r\nclass ColorBold:\r\n    gray = \'\\033[1;30;40m\'\r\n    red = \'\\033[1;31;40m\'\r\n    green = \'\\033[1;32;40m\'\r\n    yellow = \'\\033[1;33;40m\'\r\n    blue = \'\\033[1;34;40m\'\r\n    magenta = \'\\033[1;35;40m\'\r\n    cyan = \'\\033[1;36;40m\'\r\n    white = \'\\033[1;37;40m\'\r\n    underline = \'\\033[4m\'\r\n    end = \'\\033[0m\'\r\n\r\n\r\nclass Color:\r\n    purple = \'\\033[95m\'\r\n    cyan = \'\\033[96m\'\r\n    darkcyan = \'\\033[36m\'\r\n    blue = \'\\033[94m\'\r\n    green = \'\\033[92m\'\r\n    yellow = \'\\033[93m\'\r\n    red = \'\\033[91m\'\r\n    bold = \'\\033[1m\'\r\n    underline = \'\\033[4m\'\r\n    end = \'\\033[0m\'\r\n\r\n\r\nclass Background:\r\n    red = \'\\033[1;37;41m\'\r\n    green = \'\\033[1;37;42m\'\r\n    yellow = \'\\033[1;37;43m\'\r\n    blue = \'\\033[1;37;44m\'\r\n    purple = \'\\033[1;37;45m\'\r\n    light_blue = \'\\033[1;37;46m\'\r\n    grey = \'\\033[1;37;47m\'\r\n    black = \'\\033[1;37;48m\'\r\n    end = \'\\033[0m\'\r\n\r\nclass BackgroundGrey:\r\n    black = \'\\033[0;30;47m\'\r\n    red = \'\\033[0;31;47m\'\r\n    green = \'\\033[0;32;47m\'\r\n    brown = \'\\033[0;33;47m\'\r\n    blue = \'\\033[0;34;47m\'\r\n    magenta = \'\\033[0;35;47m\'\r\n    cyan = \'\\033[0;36;47m\'\r\n    gray = \'\\033[0;37;40m\'\r\n    end = \'\\033[0m\'\r\n    \r\nclass BackgroundGreyBold:\r\n    black = \'\\033[1;30;47m\'\r\n    red = \'\\033[1;31;47m\'\r\n    green = \'\\033[1;32;47m\'\r\n    brown = \'\\033[1;33;47m\'\r\n    blue = \'\\033[1;34;47m\'\r\n    magenta = \'\\033[1;35;47m\'\r\n    cyan = \'\\033[1;36;47m\'\r\n    gray = \'\\033[1;37;40m\'\r\n    end = \'\\033[0m\'\r\n    \r\n\r\n\r\nrow_colors = []\r\n\r\nrow_colors.append([ 0, Background.blue ])\r\nrow_colors.append([ 0, Background.light_blue ])\r\nrow_colors.append([ 0, Background.purple ])\r\n\r\nrow_colors.append([ 1, BackgroundGrey.red ])\r\nrow_colors.append([ 1, BackgroundGrey.brown ])\r\nrow_colors.append([ 1, BackgroundGrey.blue ])\r\n\r\nrow_colors.append([ 2, Color.cyan ])\r\nrow_colors.append([ 2, Color.green ])\r\n\r\nrow_colors_ID = 0\r\n\r\ncolorHelp_colorList = [\r\n    "ColorBold.gray",\r\n    "ColorBold.red",\r\n    "ColorBold.green",\r\n    "ColorBold.yellow",\r\n    "ColorBold.blue",\r\n    "ColorBold.magenta",\r\n    "ColorBold.cyan",\r\n    "ColorBold.white",\r\n\r\n    "",\r\n\r\n    "Color.purple",\r\n    "Color.cyan",\r\n    "Color.darkcyan",\r\n    "Color.blue",\r\n    "Color.green",\r\n    "Color.yellow",\r\n    "Color.red",\r\n    "Color.bold",\r\n    \r\n    "",\r\n\r\n    "Background.red",\r\n    "Background.green",\r\n    "Background.yellow",\r\n    "Background.blue",\r\n    "Background.purple",\r\n    "Background.light_blue",\r\n    "Background.grey",\r\n    "Background.black",\r\n\r\n    "",\r\n\r\n    "BackgroundGrey.black",\r\n    "BackgroundGrey.red",\r\n    "BackgroundGrey.green",\r\n    "BackgroundGrey.brown",\r\n    "BackgroundGrey.blue",\r\n    "BackgroundGrey.magenta",\r\n    "BackgroundGrey.cyan",\r\n    "BackgroundGrey.gray",\r\n\r\n    "",\r\n\r\n    "BackgroundGreyBold.black",\r\n    "BackgroundGreyBold.red",\r\n    "BackgroundGreyBold.green",\r\n    "BackgroundGreyBold.blue",\r\n    "BackgroundGreyBold.magenta",\r\n    "BackgroundGreyBold.cyan",\r\n    "BackgroundGreyBold.gray"\r\n]\r\n\r\ndef colorHelp( ipsum=False ):\r\n    global colorHelp_colorList\r\n    for sample in colorHelp_colorList:\r\n        if not len( sample ):\r\n            print_()\r\n        else:\r\n            result = eval( sample + \'+ "THE_TEXT" + Color.end\' )\r\n            if ipsum:\r\n                result = result.replace( \'THE_TEXT\', ipsumSentence() )\r\n            else:\r\n                result = result.replace( \'THE_TEXT\', sample )\r\n            \r\n            print_( result )\r\n    sys.exit()\r\n\r\n\r\ndef buldColorTable( tableID ):\r\n    global row_colors\r\n    newColorTable = []\r\n    for row in row_colors:\r\n        if row[0] == tableID:\r\n            newColorTable.append( row[1] )\r\n    return newColorTable\r\n\r\ndef colorNext( tableID ):\r\n    row_colors = buldColorTable( tableID )\r\n    global row_colors_ID\r\n    row_colors_ID += 1\r\n    # if row_colors_ID == len(row_colors):\r\n    if row_colors_ID % len(row_colors) == 0:\r\n        row_colors_ID = 0\r\n\r\ndef colorID( tableID, up=True ):\r\n    row_colors = buldColorTable( tableID )\r\n    global row_colors_ID\r\n    result = row_colors[row_colors_ID]\r\n    if up:\r\n        colorNext( tableID )\r\n    return result\r\n\r\ncolorizeRow_last = None\r\ndef colorizeRow( row, tableID=False, prefix=\'\', prefixColor=\'\', haltColorShift=False, pipe_break=True ):\r\n    global colorizeRow_last\r\n    if len(prefix) and len(prefixColor):\r\n        prefix = colorThis( prefix, prefixColor, p=0 )\r\n    global switches\r\n    if switches.isActive( \'NoColor\' ):\r\n        print_( row )\r\n        return False\r\n\r\n    if type(tableID) == bool:\r\n        tableID = __.color_palette\r\n    if not type(row) == str:\r\n        row = str(row)\r\n    if type(tableID) == bool:\r\n        print_( row )\r\n    else:\r\n        if _str.hasVisible(row):\r\n            up =True\r\n        else:\r\n            up =False\r\n        # print_( \'tableID:\', tableID, colorID( tableID ) )\r\n        # print_( str(len(row))+colorID( tableID, up ) + row + Background.end )\r\n        if colorizeRow_last is None or not haltColorShift:\r\n            colorizeRow_last = colorID( tableID, up )\r\n        if not pipe_break or not __.tableLine in row:\r\n            print_( prefix + colorizeRow_last + row + Background.end )\r\n        else:\r\n            sep = colorThis( \' \', \'red\', p=0 )\r\n            line = prefix + sep\r\n            parts=[]\r\n            for part in row.split(__.tableLine):\r\n                parts.append( colorizeRow_last + part + Background.end )\r\n                \r\n            line += sep.join(parts) + sep\r\n            print_(line)\r\n\r\n\r\n\r\n\r\napp_full_color_index = None\r\ndef generateColorIndex():\r\n    global app_full_color_index\r\n    if not app_full_color_index is None:\r\n        return app_full_color_index\r\n    colorClasses = \'ColorBold Color Background BackgroundGrey BackgroundGreyBold\'\r\n    list_of_colors = []\r\n    test = 0\r\n    if test == 0:\r\n        for cc in colorClasses.split(\' \'):\r\n            for x in dir(  eval(  \'_.\'+cc  )  ):\r\n                if not x.startswith(\'_\'):\r\n                    \r\n                    subject = x\r\n                    subject = subject.lower()\r\n                    if not subject in list_of_colors:\r\n                        list_of_colors.append( subject )\r\n\r\n                    subject = cc+\'.\'+x\r\n                    subject = subject.lower()\r\n                    if not subject in list_of_colors:\r\n                        list_of_colors.append( subject )\r\n\r\n\r\n    test = 1\r\n    if test == 1:\r\n        for x in _.colorHelp_colorList:\r\n            if \'.\' in x:\r\n                p = x.split(\'.\')\r\n                a = p[0]+\'.\'\r\n                aa = a.lower()\r\n                b = p[1]\r\n                bb = b.lower()\r\n\r\n                subject = bb\r\n                if not subject in list_of_colors:\r\n                    list_of_colors.append( subject )\r\n\r\n                subject = x.lower()\r\n                if not subject in list_of_colors:\r\n                    list_of_colors.append( subject )\r\n\r\n\r\n    app_full_color_index = []\r\n\r\n    for x in list_of_colors:\r\n        if not \'.\' in x:\r\n            app_full_color_index.append( x )\r\n\r\n    for x in list_of_colors:\r\n        if \'.\' in x:\r\n            app_full_color_index.append( x )\r\n\r\n    return app_full_color_index\r\n\r\n\r\n\r\n# _.colorThis( [ \'\\t\', part_profile  ], \'yellow\', simpleDic=True, colorProfile=[  ] )\r\n\r\n# simpleDic=True, simpleDicColor=[ [ \'match\', \'red\' ] ]\r\ndef colorThis( strings=\'\', color=\'red\', notBold=False, shouldPrint=True, ipsum=False, simpleDic=False, colorProfile=None,      p=None, c=None, sd=None, isError=False ):\r\n\r\n    if isError:\r\n        color = \'red\'\r\n\r\n    if not c is None:\r\n        color = c\r\n    if not sd is None:\r\n        simpleDic = sd\r\n\r\n    if not p is None:\r\n        shouldPrint = p\r\n\r\n    if simpleDic and type(strings) == dict:\r\n        newString = \'\'\r\n        for k in strings.keys():\r\n            newString += \' \' + k + \': \' + str(strings[k]) + \' \'\r\n        strings = newString\r\n\r\n    if simpleDic and type(strings) == list:\r\n        for i,thisItem in enumerate(strings):\r\n            if type(thisItem) == dict:\r\n                newString = \'\'\r\n                for k in thisItem.keys():\r\n                    newString += \' \' + k + \': \' + str(thisItem[k]) + \' \'\r\n                strings[i] = newString\r\n\r\n# [ { \'color\': \'red\', \'field\': \'match\', \'i\': 0  } ]\r\n# [ { \'color\': \'red\', \'field\': \'match\' } ]\r\n# [ { \'color\': \'red\', \'i\': 0  } ]\r\n# { \'color\': \'red\', \'i\': 0  }\r\n# [\'red\',1]\r\n# [2,\'red\']\r\n# [\'name\',\'yellow\']\r\n# \'red,green\'\r\n# \'red,green:*\'\r\n# \'*red,green\'\r\n# \'green,red,green:*\'\r\n# \'green:2,red:*,green\'\r\n\r\n# topic_index\r\n#   \'float,2\'\r\n\r\n\r\n# ColorBold Color Background BackgroundGrey BackgroundGreyBold\r\n\r\n    \r\n    # color_index = generateColorIndex()\r\n    # colorProfileTmp = []\r\n    # index = {\r\n    #             \'i\': [],\r\n    #             \'keys\': [],\r\n    #             \'data\': {},\r\n    # }\r\n    # if not colorProfile is None:\r\n    #     if type(colorProfile) == str:\r\n    #         if type(strings) == list and \',\' in colorProfile:\r\n    #             if colorProfile.count(\'*\') > 1:\r\n    #                 print_( \' only 1 * \' )\r\n    #             new_CP = []\r\n    #             cp = colorProfile.split(\',\')\r\n    #             end = len(strings)-1\r\n    #             leftC = len(cp)-1\r\n    #             leftL = end\r\n\r\n\r\n    #             for i,xx in enumerate(strings):\r\n\r\n\r\n\r\n    #     if type(colorProfile) == list:\r\n    #         for i,record in enumerate(colorProfile):\r\n    #             if type(record) == dict:\r\n    #                 record[\'id\'] = i\r\n    #                 if \'c\' in record.keys():\r\n    #                     record[\'color\'] = record[\'c\']\r\n    #                     del record[\'c\']\r\n\r\n    #                 if \'f\' in record.keys():\r\n    #                     record[\'field\'] = record[\'f\']\r\n    #                     del record[\'f\']\r\n\r\n    #                 if \'column\' in record.keys():\r\n    #                     record[\'field\'] = record[\'column\']\r\n    #                     del record[\'column\']\r\n\r\n\r\n    #                 if \'i\' in record.keys():\r\n    #                     index[\'i\'].append( record[\'i\'] )\r\n    #                     index[\'data\'][i] = record\r\n                    \r\n    #                 if \'field\' in record.keys():\r\n    #                     if \',\' in record[\'field\']:\r\n    #                         for ef in record[\'field\'].split(\',\'):\r\n    #                             index[\'keys\'].append( ef )\r\n    #                             index[\'data\'][ ef ] = record\r\n    #                     else:\r\n    #                         index[\'keys\'].append( record[\'field\'] )\r\n    #                         index[\'data\'][record[\'field\']] = record\r\n    #                 colorProfileTmp.append( record )\r\n                    \r\n    #             if type(record) == list:\r\n    #                 if len(record) == 2:\r\n    #                     newRecord = { \'id\': i }\r\n\r\n\r\n    #                     if type( record[0] ) == int:\r\n    #                         newRecord[\'i\'] = record[0]\r\n    #                         newRecord[\'color\'] = record[1]\r\n\r\n    #                     elif type( record[1] ) == int:\r\n    #                         newRecord[\'i\'] = record[1]\r\n    #                         newRecord[\'color\'] = record[0]\r\n    #                     else:\r\n    #                         if record[0].lower() in color_index:\r\n    #                             newRecord[\'field\'] = record[0]\r\n    #                             newRecord[\'color\'] = record[1]\r\n    #                         if record[1].lower() in color_index:\r\n    #                             newRecord[\'field\'] = record[1]\r\n    #                             newRecord[\'color\'] = record[0]\r\n\r\n    #                     if \'color\' in newnewRecord.keys():\r\n\r\n    #                         if \'i\' in newRecord.keys():\r\n    #                             index[\'i\'].append( newRecord[\'i\'] )\r\n    #                             index[\'data\'][i] = newRecord\r\n                            \r\n    #                         if \'field\' in newRecord.keys():\r\n    #                             if \',\' in newRecord[\'field\']:\r\n    #                                 for ef in newRecord[\'field\'].split(\',\'):\r\n    #                                     index[\'keys\'].append( ef )\r\n    #                                     index[\'data\'][ ef ] = newRecord\r\n    #                             else:\r\n    #                                 index[\'keys\'].append( newRecord[\'field\'] )\r\n    #                                 index[\'data\'][newRecord[\'field\']] = newRecord\r\n    #                         colorProfileTmp.append( newRecord )\r\n\r\n\r\n\r\n    #     if type(colorProfile) == dict:\r\n    #         record = colorProfile\r\n    #         if \'c\' in record.keys():\r\n    #             colorProfile[i][\'color\'] = record[\'c\']\r\n    #             record[\'color\'] = record[\'c\']\r\n    #         if \'f\' in record.keys():\r\n    #             colorProfile[i][\'field\'] = record[\'f\']\r\n    #             record[\'field\'] = record[\'f\']\r\n    #         if \'column\' in record.keys():\r\n    #             colorProfile[i][\'field\'] = record[\'column\']\r\n    #             record[\'field\'] = record[\'column\']\r\n\r\n\r\n    #         if \'i\' in record.keys():\r\n    #             index[\'i\'].append( record[\'i\'] )\r\n            \r\n    #         if \'field\' in record.keys():\r\n    #             index[\'keys\'].append( record[\'field\'] )\r\n    #         colorProfile = [record]\r\n\r\n\r\n\r\n\r\n    if type(strings) == list:\r\n\r\n        for i,x in enumerate(strings):\r\n\r\n            strings[i] = str( x )\r\n\r\n        string = \' \'.join( strings )\r\n    else:\r\n        string = str(strings)\r\n\r\n    global switches\r\n    if switches.isActive( \'NoColor\' ):\r\n        if shouldPrint:\r\n            print_(string)\r\n            return string\r\n        else:\r\n            return string\r\n\r\n    if ipsum:\r\n        string = ipsumSentence()\r\n\r\n    found = False\r\n\r\n    if color == \'help\':\r\n        print_()\r\n        print_()\r\n        print_( "_.colorThis( strings=\'\', color=\'red\', notBold=False, shouldPrint=True, ipsum=False )" )\r\n        print_()\r\n        print_()\r\n        colorHelp( ipsum )\r\n\r\n\r\n    pass \r\n    aaPre=\'\'\r\n    ws=ws_sep(string)\r\n    aaPre=ws[0]\r\n    string=ws[1]\r\n    result=\'\'\r\n\r\n\r\n    if \'.\' in color:\r\n\r\n        try:\r\n            result = eval( color + \'+ string + Color.end\')\r\n        except Exception as e:\r\n            pass\r\n        else:\r\n            found = True\r\n\r\n    else:\r\n        color = color.lower()\r\n\r\n\r\n    if not found and notBold:\r\n        try:\r\n            result = eval( \'Color.\' + color + \'+ string + Color.end\')\r\n        except Exception as e:\r\n            pass\r\n        else:\r\n            found = True\r\n\r\n\r\n    if not found:\r\n        try:\r\n            result = eval( \'ColorBold.\' + color + \'+ string + ColorBold.end\')\r\n        except Exception as e:\r\n            pass\r\n        else:\r\n            found = True\r\n\r\n\r\n    if not found:\r\n        try:\r\n            result = eval( \'Color.\' + color + \'+ string + Color.end\')\r\n        except Exception as e:\r\n            pass\r\n        else:\r\n            found = True\r\n\r\n\r\n    if not found:\r\n        try:\r\n            result = eval( \'Background.\' + color + \'+ string + Background.end\')\r\n        except Exception as e:\r\n            pass\r\n        else:\r\n            found = True\r\n\r\n\r\n    if not found:\r\n        try:\r\n            result = eval( \'BackgroundGrey.\' + color + \'+ string + BackgroundGrey.end\')\r\n        except Exception as e:\r\n            pass\r\n        else:\r\n            found = True\r\n\r\n\r\n    if not found:\r\n        try:\r\n            result = eval( \'BackgroundGreyBold.\' + color + \'+ string + BackgroundGreyBold.end\')\r\n        except Exception as e:\r\n            pass\r\n        else:\r\n            found = True\r\n\r\n    result = aaPre+result\r\n    \r\n    if not found:\r\n        printBold( \'Error: _.colorThis: color not found \' + str(color), \'red\' )\r\n        print_()\r\n        print_( strings )\r\n        print_()\r\n        colorHelp( ipsum )\r\n\r\n        sys.exit()\r\n\r\n\r\n\r\n    if shouldPrint:\r\n        try:\r\n            print_( result )\r\n        except Exception as e:\r\n\r\n            try:\r\n                result = str(result,\'utf-8\')\r\n            except Exception as e:\r\n                try:\r\n                    result = str(result,\'iso-8859-1\')\r\n                except Exception as e:\r\n                    result = result.encode(\'utf-8\')\r\n            result = str(result,\'iso-8859-1\')\r\n        if isError:\r\n            sys.exit()\r\n        return None\r\n\r\n\r\n\r\n    return result\r\n\r\ndef ws_sep(string):\r\n    a=\'\'\r\n    b=\'\'\r\n    done=False\r\n    for ch in string:\r\n        if done:\r\n            b+=ch\r\n        elif ch in \' \\t\':\r\n            a+=ch\r\n        else:\r\n            b+=ch\r\n            done=True\r\n    return a,b\r\n\r\n\r\ndef inlineColor( string, color=\'red\' ):\r\n\r\n    global switches\r\n    if switches.isActive( \'NoColor\' ):\r\n        return string\r\n\r\n    color = color.lower()\r\n    if not type(string) == str:\r\n        string = str(string)\r\n    if color == \'red\':\r\n        return Color.red + string + Color.end\r\n    elif color == \'cyan\':\r\n        return Color.cyan + string + Color.end\r\n    elif color == \'darkcyan\' or color == \'grey\':\r\n        return Color.darkcyan + string + Color.end\r\n    elif color == \'blue\':\r\n        return Color.blue + string + Color.end\r\n    elif color == \'green\':\r\n        return Color.green + string + Color.end\r\n    elif color == \'yellow\':\r\n        return Color.yellow + string + Color.end\r\n    elif color == \'underline\':\r\n        return Color.underline + string + Color.end\r\n\r\n\r\ndef printColor( string, color=\'red\' ):\r\n\r\n    global switches\r\n    if switches.isActive( \'NoColor\' ):\r\n        print_( string )\r\n        return False\r\n\r\n    color = color.lower()\r\n    if not type(string) == str:\r\n        string = str(string)\r\n    if color == \'red\':\r\n        print_( Color.red + string + Color.end )\r\n    elif color == \'cyan\':\r\n        print_( Color.cyan + string + Color.end )\r\n    elif color == \'darkcyan\' or color == \'grey\':\r\n        print_( Color.darkcyan + string + Color.end )\r\n    elif color == \'blue\':\r\n        print_( Color.blue + string + Color.end )\r\n    elif color == \'green\':\r\n        print_( Color.green + string + Color.end )\r\n    elif color == \'yellow\':\r\n        print_( Color.yellow + string + Color.end )\r\n    elif color == \'underline\':\r\n        print_( Color.underline + string + Color.end )\r\n\r\n# def formatData( result ):\r\n#     try:\r\n#         result = str(result,\'utf-8\')\r\n#     except Exception as e:\r\n#         try:\r\n#             result = str(result,\'iso-8859-1\')\r\n#         except Exception as e:\r\n#             result = result.encode(\'utf-8\')\r\n#     return result\r\n\r\ndef printBold( string, color=\'white\', prefix=\'\' ):\r\n    \r\n    if \'\\n\' in string:\r\n        string = string.replace( \'\\n\', \'\\n\'+prefix )\r\n    else:\r\n        string = prefix + string\r\n    \r\n    global switches\r\n    if switches.isActive( \'NoColor\' ):\r\n        print_( string )\r\n        return False\r\n\r\n    color = color.lower()\r\n    if not type(string) == str:\r\n        string = str(string)\r\n    if color == \'white\':\r\n        print_( ColorBold.white + string + ColorBold.end )\r\n    elif color == \'red\':\r\n        print_( ColorBold.red + string + ColorBold.end )\r\n    elif color == \'gray\' or color == \'grey\':\r\n        print_( ColorBold.gray + string + ColorBold.end )\r\n    elif color == \'green\':\r\n        print_( ColorBold.green + string + ColorBold.end )\r\n    elif color == \'yellow\':\r\n        print_( ColorBold.yellow + string + ColorBold.end )\r\n    elif color == \'blue\':\r\n        print_( ColorBold.blue + string + ColorBold.end )\r\n    elif color == \'magenta\':\r\n        print_( ColorBold.magenta + string + ColorBold.end )\r\n    elif color == \'cyan\':\r\n        print_( ColorBold.cyan + string + ColorBold.end )\r\n\r\n\r\ndef inlineColorGroup( row, tableID=False ):\r\n\r\n    global switches\r\n    if switches.isActive( \'NoColor\' ):\r\n        return row\r\n\r\n    if not type(row) == str:\r\n        row = str(row)\r\n    if type(tableID) == bool:\r\n        tableID = __.color_palette\r\n    if not type(row) == str:\r\n        row = str(row)\r\n    if type(tableID) == bool:\r\n        print_( row )\r\n    else:\r\n        if _str.hasVisible(row):\r\n            up =True\r\n        else:\r\n            up =False\r\n        # print_( \'tableID:\', tableID, colorID( tableID ) )\r\n        return colorID( tableID, up ) + row + Background.end\r\n\r\n\r\ndef inlineBold( string, color=\'white\' ):\r\n    global switches\r\n    if switches.isActive( \'NoColor\' ):\r\n        return string\r\n    \r\n    string = str(string)\r\n    color = color.lower()\r\n    if not type(string) == str:\r\n        string = str(string)\r\n    if color == \'white\':\r\n        return ColorBold.white + string + ColorBold.end \r\n    elif color == \'red\':\r\n        return ColorBold.red + string + ColorBold.end \r\n    elif color == \'gray\' or color == \'grey\':\r\n        return ColorBold.gray + string + ColorBold.end \r\n    elif color == \'green\':\r\n        return ColorBold.green + string + ColorBold.end \r\n    elif color == \'yellow\':\r\n        return ColorBold.yellow + string + ColorBold.end \r\n    elif color == \'blue\':\r\n        return ColorBold.blue + string + ColorBold.end \r\n    elif color == \'magenta\':\r\n        return ColorBold.magenta + string + ColorBold.end \r\n    elif color == \'cyan\':\r\n        return ColorBold.cyan + string + ColorBold.end\r\n    elif color == \'underline\':\r\n        return ColorBold.underline + string + ColorBold.end\r\n\r\ndef patternMatch( one, two, best=True, simple=True, both=False, unsorted=False ):\r\n    # simple=True\r\n    result = []\r\n    result.append( testPatterns( one, two, simple ) )\r\n    result.append( testPatterns( two, one, simple ) )\r\n    if type(both) == int and both == 2:\r\n        return result\r\n    if not both:\r\n        if best:\r\n            return max(result)\r\n        else:\r\n            return min(result)\r\n    else:\r\n        if unsorted:\r\n            return result\r\n\r\n        if not simple:\r\n            if result[0][0] > result[1][0]:\r\n                return result[0],result[1]\r\n            else:\r\n                return result[1],result[0]\r\n        else:\r\n            if result[0] > result[1]:\r\n                return result[0],result[1]\r\n            else:\r\n                return result[1],result[0]\r\n        \r\ndef testPatterns( one, two, simple=True ):\r\n\r\n    test = False\r\n    spent = []\r\n    patterns = []\r\n    matches = []\r\n    def tempDataset( datasetX ):\r\n        newDataset = []\r\n        for dat in datasetX:\r\n            newDataset.append( dat )\r\n        return newDataset\r\n    def genChars( datasetY, x=False ):\r\n        chars = []\r\n        for d in datasetY:\r\n            chars.append( one[d] )\r\n            if x:\r\n                print_( one[d], d )\r\n        return \'\'.join( chars )\r\n    def addSpent( datasetY ):\r\n        for d in datasetY:\r\n            spent.append( d )\r\n\r\n    def addMatch( datasetY ):\r\n        for d in datasetY:\r\n            if not d in matches:\r\n                matches.append( d )\r\n\r\n    def testSpent( datasetX ):\r\n        for d in datasetX:\r\n            if d in spent:\r\n                return False\r\n        return True\r\n\r\n    def expandTest( datasetX ):\r\n        if testSpent( datasetX ):\r\n            first = datasetX[0]\r\n            last = datasetX[len(datasetX)-1]\r\n            theLast = len(datasetX)-1\r\n            theMax = len(one)-1\r\n\r\n            datasetY = tempDataset( datasetX )\r\n            if not datasetX[0] == 0:\r\n                nextFirst = int(first)\r\n                for x in range(1,100000):\r\n                    nextFirst = first - 1\r\n                    if nextFirst >= 0:\r\n                        datasetY.append( nextFirst )\r\n                        datasetY.sort()\r\n                        if not genChars( datasetY ) in two:\r\n                            datasetY.pop(0)\r\n                            break\r\n                    else:\r\n                        break\r\n            if not datasetY[len(datasetY)-1] == theMax:\r\n                nextLast = int(datasetY[len(datasetY)-1])\r\n                # print_()\r\n                # print_( \'nextLast:\', nextLast )\r\n                for x in range(1,100000):\r\n                    # print_()\r\n                    # print_( nextLast, x, nextLast + x )\r\n                    nextLast = nextLast + 1\r\n                    if nextLast <= theMax:\r\n                        datasetY.append( nextLast )\r\n                        datasetY.sort()\r\n                        if not genChars( datasetY, x=False ) in two:\r\n                            datasetY.reverse()\r\n                            datasetY.pop(0)\r\n                            datasetY.reverse()\r\n                            addSpent( datasetY )\r\n                            addMatch( datasetY )\r\n                            patterns.append( genChars( datasetY ) )\r\n                            # print_( \'\\t1\' )\r\n                            break\r\n                    else:\r\n                        addSpent( datasetY )\r\n                        addMatch( datasetY )\r\n                        patterns.append( genChars( datasetY ) )\r\n                        # print_( \'\\t2\' )\r\n                        break\r\n            else:\r\n                addSpent( datasetY )\r\n                addMatch( datasetY )\r\n                patterns.append( genChars( datasetY ) )\r\n                # print_( \'\\t3\' )\r\n\r\n    def runTest( patternLength ):\r\n        data = generatePatterns2( one, 2 )\r\n        # data = generatePatterns( one, 2 )\r\n        # print_( len(data) )\r\n        i = 0\r\n        ii = 0\r\n        for dataset in data:\r\n            x = genChars( dataset )\r\n            if x in two:\r\n                addMatch( dataset )\r\n                expandTest( dataset )\r\n                # print_( x )\r\n                if test:\r\n                    print_( x )\r\n                i += 1\r\n            else:\r\n                ii += 1\r\n\r\n        result = percentageDiffInt( i, len(data) )\r\n        return result\r\n    resultX = []\r\n\r\n    for x in range(2,10):\r\n        if len( one ) > x:\r\n            resultX.append( runTest( x ) )\r\n\r\n\r\n    newResult = percentageDiffInt( len(matches), len(one) )\r\n    # print_( patterns )\r\n    # print_( newResult )\r\n    if simple:\r\n        return newResult\r\n    else:\r\n        return newResult, tuple(patterns)\r\n\r\n\r\n\r\ndef generatePatterns( string, patternLength=2 ):\r\n\r\n    def genP( by ):\r\n        \r\n        offset = 0\r\n        dataset = []\r\n        for offset in range(0,by):\r\n            # print_( offset )\r\n            ix = False\r\n            for i,char in enumerate(string):\r\n                if i >= offset:\r\n                    ix = ( i + offset )\r\n                    \r\n                if not type(ix) == bool:\r\n                    # dataset.append( char )\r\n                    dataset.append( i )\r\n                    if len(dataset) % by == 0:\r\n                        if len( dataset ):\r\n                            dataset.sort()\r\n                            data.append( dataset )\r\n                            # print_( \'\'.join( dataset ) )\r\n                        dataset = []\r\n\r\n\r\n    l = len( string )\r\n    data = []\r\n    genP( patternLength )\r\n    return data\r\n\r\ndef generatePatterns2( data, patternLength=2 ):\r\n    records = []\r\n    m = len(data)\r\n    for n in range(0,len(data)):\r\n        # a = n-1\r\n        good = True\r\n        pl = 0\r\n        rec = []\r\n        new = n\r\n        while not pl == patternLength:\r\n            if not new < m:\r\n                good = False\r\n            rec.append( new )\r\n            new+=1\r\n            pl+=1\r\n        b = n\r\n        c = n+1\r\n        # if a > -1:\r\n        #   records.append([ a,b ])\r\n        # if c < m:\r\n        if good:\r\n            records.append( rec )\r\n    return records\r\n\r\n\r\ndef stringDiff( one, two ):\r\n    one = one.lower()\r\n    two = two.lower()\r\n    appropriate = \' 0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\'\r\n\r\n    if len(one) > len(two):\r\n        a = len(one)\r\n        b = len(two)\r\n    else:\r\n        b = len(one)\r\n        a = len(two)\r\n    d = a - b\r\n    # if d > 2:\r\n    #   return False\r\n    setA = 0\r\n    theTotal_one = 0\r\n    theTotal_two = 0\r\n    for x in appropriate:\r\n        if x in two:\r\n            theTotal_two += 1\r\n        if x in one:\r\n            theTotal_one += 1\r\n        if x in one and x in two:\r\n            setA += 1\r\n\r\n    resultX = []\r\n    resultX.append(percentageDiffInt( setA, theTotal_one ))\r\n    resultX.append(percentageDiffInt( theTotal_one, theTotal_two ))\r\n    resultX.append(percentageDiffInt( theTotal_one, theTotal_two ))\r\n    resultX.append( testPatterns( one, two ) )\r\n    result = max(resultX)\r\n    \r\n    # resultY = []\r\n    # resultY.append(min(resultX))\r\n    # resultY.append(patternMatch( one, two ))\r\n    # result = max(resultY)\r\n    # print_()\r\n    # print_( setA, theTotal_one )\r\n    # print_( resultX, one, two )\r\n\r\n    return result\r\n\r\n\r\n\r\ndef fromEpoch( epoch ):\r\n    return datetime.datetime.fromtimestamp(epoch).strftime(\'%c\')\r\n\r\ndef postLoad( file, epoch=0, theFocus=False ):\r\n    __.postLoadFile = file\r\n    global autoLoadData\r\n    global switches\r\n    global appData\r\n    \r\n\r\n\r\n    try:\r\n        __.appInfoScan\r\n    except Exception as e:\r\n        pass\r\n    if not type( theFocus ) == bool:\r\n        theFocus = theFocus\r\n    else:\r\n        theFocus = __.appReg\r\n\r\n        # print_( \'theFocus:\', theFocus )\r\n        # printVar( appData )\r\n        if  theFocus in appData:\r\n            if type( appData[theFocus][\'pipe\'] ) == bool:\r\n                hasPipeData = False\r\n            else:\r\n                hasPipeData = True\r\n        else:\r\n            hasPipeData = False\r\n\r\n\r\n\r\n        # print_( type( appData[theFocus][\'pipe\'] ) )\r\n\r\n\r\n        # print_( appData[theFocus][\'pipe\'] )\r\n\r\n\r\n        if type( myFileLocation_File ) == bool:\r\n            hasFile = False\r\n        else:\r\n            hasFile = True\r\n        \r\n        # if __.isRequired_Pipe_or_File and not hasFile and not hasPipeData:\r\n        #     if __.pre_error:\r\n        #         print_(  )\r\n        #         print_( inlineBold(\'Error:\',\'red\')+inlineBold(\' Pipe\')+\' data or \'+inlineBold(\'File\')+\' is required\' )\r\n        #         print_(  )\r\n        #         sys.exit()\r\n\r\n        # if __.isRequired_Pipe and not hasPipeData:\r\n        #     if __.pre_error:\r\n        #         print_(  )\r\n        #         print_( \'Error: Pipe data is required\' )\r\n        #         print_(  )\r\n        #         sys.exit()\r\n\r\n        on = switches.records( formating=\'dic_on-off-v\', appReg=theFocus )[\'on\']\r\n        # printVarSimple(on)\r\n        metCriteria = True\r\n        if __.isRequired_or_List is None:\r\n            if __.isRequired_Pipe:\r\n                __.isRequired_or_List = [\'Pipe\']\r\n            if __.isRequired_Pipe_or_File:\r\n                __.isRequired_or_List = [\'Pipe\',\'Files\']\r\n\r\n\r\n        if not __.isRequired_or_List is None:\r\n            if __.pre_error:\r\n                fnd = False\r\n                if not metCriteria:\r\n                    if not hasPipeData and \'Pipe\' in __.isRequired_or_List:\r\n                        metCriteria = False\r\n                if not metCriteria:\r\n                    for x in __.isRequired_or_List:\r\n                        if not x == \'Pipe\':\r\n                            if x in on:\r\n                                fnd = True\r\n                    if not fnd:\r\n                        metCriteria = False\r\n                \r\n                if not metCriteria:\r\n                    help()\r\n        if metCriteria:\r\n            if len( __.isRequired_index[theFocus] ):\r\n                fnd = False\r\n                for x in __.isRequired_index[theFocus]:\r\n                    if not x == \'Pipe\':\r\n                        if x in on:\r\n                            fnd = True\r\n                if not fnd:\r\n                    metCriteria = False\r\n            \r\n            if not metCriteria:\r\n                help()\r\n\r\n        # if metCriteria:\r\n\r\n\r\n        # if not type( __.isRequired_or_List ) == bool and __.registeredApps[0] == __.appReg:\r\n        #     meetsRequirements = False\r\n\r\n\r\n        #     if \'Pipe\' in __.isRequired_or_List:\r\n        #         if hasPipeData:\r\n        #             meetsRequirements = True\r\n        #         if not hasFile and not hasPipeData:\r\n        #             pass\r\n        #         else:\r\n        #             meetsRequirements = True\r\n        #     if not meetsRequirements:\r\n        #         for check in __.isRequired_or_List:\r\n        #             if switches.isActive(check):\r\n        #                 meetsRequirements = True\r\n        #         if not meetsRequirements:\r\n        #             if __.pre_error:\r\n        #                 print_(  )\r\n        #                 print_( inlineBold( \'Error:\', \'red\' ) + \' One of the following is required:\', \', \'.join( __.isRequired_or_List ) )\r\n        #                 print_(  )\r\n\r\n        #                 # print_( __.registeredApps )\r\n\r\n        #                 sys.exit()\r\n\r\n\r\n    appDBA = __.thisApp( file )\r\n\r\n    if switches.isActive( \'LoadEpoch\' ):\r\n        if \'.\' in switches.value( \'LoadEpoch\' ):\r\n            autoLoadData = True\r\n            epoch = float( switches.value( \'LoadEpoch\' ) )\r\n    if autoLoadData and epoch == 0:\r\n        if type( autoLoadData ) == str:\r\n            if \'.\' in autoLoadData:\r\n                epoch = float( autoLoadData )\r\n        if type( autoLoadData ) == float:\r\n            epoch = autoLoadData\r\n\r\n        if epoch == 0:\r\n            autoLoadData = False\r\n\r\n\r\n    if autoLoadData:\r\n        reclaimAcquiredData( appDBA, epoch, theFocus )\r\n    else:\r\n        releaseAcquiredData( appDBA, theFocus )\r\n\r\n\r\n\r\ndef releaseAcquiredData( appDBA, theFocus, payload=None ):\r\n    l_registerSwitches_vars()\r\n    if appDBA == \'__init__\':\r\n        return None\r\n    if not __.releaseAcquiredData:\r\n        return None\r\n    if not os.name == \'nt\':\r\n        return None\r\n    global autoBackupData\r\n    global switches\r\n    global appData\r\n    global myFileLocation_Files\r\n    global switches\r\n    global print_ed\r\n\r\n\r\n    log = _v.appLogs() + _v.slash+\'execution_receipt-\' + appDBA + \'-\' + str( __.startTime ) + \'.json\'\r\n    rebuiltCommandRaw = theCommand( appDBA, printThis=False, separate=True )\r\n    if len( rebuiltCommandRaw[1] ):\r\n        rebuiltCommand = rebuiltCommandRaw[0] + \' \' + rebuiltCommandRaw[1]\r\n        rebuiltCommandEpoch = rebuiltCommandRaw[0] + \' -loadEpoch \' + str( __.startTime ) + \' \' + rebuiltCommandRaw[1]\r\n    else:\r\n        rebuiltCommand = rebuiltCommandRaw[0]\r\n        rebuiltCommandEpoch = rebuiltCommandRaw[0] + \' -loadEpoch \' + str( __.startTime ) \r\n    # print_( log )\r\n    # print_( rebuiltCommandRaw )\r\n\r\n\r\n    # autoBackupData = True\r\n\r\n\r\n\r\n    info = {\r\n                \'epoch\': __.startTime,\r\n                \'app\': appDBA,\r\n                \'session\': _v.session(),\r\n                \'rebuiltCommand\': rebuiltCommand,\r\n                \'rebuiltCommandEpoch\': rebuiltCommandEpoch,\r\n                \'files\': [],\r\n                \'switches\': switches.getTable(),\r\n                \'errors\': [],\r\n                \'printed\': print_ed,\r\n    }\r\n    if not payload is None:\r\n        info[\'payload\'] = payload\r\n\r\n    # if not autoBackupData:\r\n    saveTable2( info, log )\r\n\r\n    if autoBackupData:\r\n        if len( myFileLocation_Files ):\r\n            for i,file in enumerate(myFileLocation_Files):\r\n                if os.path.isfile(file):\r\n                    thisName = \'files-\' + appDBA + \'-\' + str( __.startTime ) + \'_file\' + str(i) + \'.cache\'\r\n                    import _rightThumb._dir as _dir\r\n                    dirRecord = _dir.info( file, mime=True )\r\n                    info[\'errors\'] = []\r\n                    fileError = \'Error: File is \' + dirRecord[\'mime\'] + \' and \' + dirRecord[\'size\']\r\n                    try:\r\n                        if dirRecord[\'mime\'] == \'Text\' and dirRecord[\'bytes\'] < 5242880:\r\n                            tmpData = getText( file )\r\n                            saveText( tmpData, _v.myAppLogs + _v.slash + thisName )\r\n                            info[\'files\'].append( thisName )\r\n                        else:\r\n                            info[\'errors\'].append({ \'error\': fileError, \'file\': _v.myAppLogs + _v.slash + thisName })\r\n                            saveText( fileError, _v.myAppLogs + _v.slash + thisName )\r\n                            \r\n\r\n                    except Exception as e:\r\n                        info[\'errors\'].append({ \'error\': fileError, \'file\': _v.myAppLogs + _v.slash + thisName })\r\n\r\n        # print_( theFocus, type( appData[theFocus][\'pipe\'] ) )\r\n        # print_(\'theFocus\',theFocus)\r\n        if not type( appData[theFocus][\'pipe\'] ) == bool:\r\n            thisName = \'files-\' + appDBA + \'-\' + str( __.startTime ) + \'_pipe\' + \'.cache\'\r\n            saveText( appData[theFocus][\'pipe\'], _v.myAppLogs + _v.slash + thisName )\r\n            # print_(info)\r\n            info[\'files\'].append( thisName )\r\n            \r\n        \r\n\r\n        saveTable2( info, log )\r\n\r\n        # print_()\r\n        # print_()\r\n        # printVar( info )\r\n\r\n    # \r\n# _.theCommand( __file__ )\r\n# file0 = _v.myTables + _v.slash+\'applogs\'+_v.slash + log\r\n\r\ndef reclaimAcquiredData( appDBA, epoch, theFocus=False ):\r\n    print_( \'reclaimAcquiredData\' )\r\n    global switches\r\n    if not type( theFocus ) == bool:\r\n        appReg = theFocus\r\n    else:\r\n        appReg = __.appReg\r\n\r\n    log = _v.appLogs() + _v.slash+\'execution_receipt-\' + appDBA + \'-\' + str( epoch ) + \'.json\'\r\n    print_(  os.path.isfile(log), log )\r\n    if not os.path.isfile(log):\r\n        cp( \'Error: please select a valid backup\', \'error\' )\r\n        sys.exit()\r\n    info = getTable2( log )\r\n    __.payloadCache = None\r\n    if \'payload\' in info:\r\n        __.payloadCache = info[\'payload\']\r\n\r\n\r\n    # print_( log )\r\n    # print_( info )\r\n    # printVar( info )\r\n\r\n    def pipeFile():\r\n        for file in info[\'files\']:\r\n            if \'pipe\' in file:\r\n                return _v.myAppLogs + _v.slash + file\r\n        return False\r\n\r\n    def theFiles():\r\n        theFiles = []\r\n        for file in info[\'files\']:\r\n            if not \'pipe\' in file:\r\n                theFiles.append( _v.myAppLogs + _v.slash + file )\r\n        return theFiles\r\n\r\n    def rebuildSwitches( switchData ):\r\n        # printVar( switchData )\r\n        for i,switch in enumerate(switchData):\r\n            if switch[\'name\'] == \'File\' or switch[\'name\'] == \'Files\':\r\n                switchData[i][\'values\'] = []\r\n                for file in info[\'files\']:\r\n                    if not \'pipe\' in file:\r\n                        switchData[i][\'values\'].append( _v.myAppLogs + _v.slash + file )\r\n                switchData[i][\'value\'] = \',\'.join( switchData[i][\'values\'] )\r\n        return switchData\r\n\r\n    def rebuildFiles( switchData ):\r\n        data = []\r\n        for i,switch in enumerate(switchData):\r\n            if switch[\'name\'] == \'File\' or switch[\'name\'] == \'Files\':\r\n                switchData[i][\'values\'] = []\r\n                for file in info[\'files\']:\r\n                    if not \'pipe\' in file:\r\n                        switchData[i][\'values\'].append( _v.myAppLogs + _v.slash + file )\r\n                switchData[i][\'value\'] = \',\'.join( switchData[i][\'values\'] )\r\n                data.append( switchData[i] )\r\n        return data\r\n    def rebuildFiles( switchData ):\r\n        for i,switch in enumerate(switchData):\r\n            if switch[\'name\'] == \'File\' or switch[\'name\'] == \'Files\':\r\n                switchData[i][\'values\'] = []\r\n                for file in info[\'files\']:\r\n                    if not \'pipe\' in file:\r\n                        switchData[i][\'values\'].append( _v.myAppLogs + _v.slash + file )\r\n                switchData[i][\'value\'] = \',\'.join( switchData[i][\'values\'] )\r\n                data.append( switchData[i] )\r\n        return data\r\n\r\n    pass\r\n    if \'printed\' in info:\r\n        # cp( \'\' )\r\n        for line in info[\'printed\']:\r\n            print(line)\r\n\r\n    else:\r\n\r\n        if switches.onlyLoadEpoch( theFocus=appReg ):\r\n            switchData = rebuildSwitches( info[\'switches\'] )\r\n        else:\r\n            switchData = rebuildFiles( info[\'switches\'] )\r\n        # printVar( switchData )\r\n        switches.loadTable( switchData, theFocus=appReg )\r\n        # print_( \'theFocus:\', theFocus )\r\n\r\n        if not type( pipeFile() ) == bool:\r\n            appData[appReg][\'pipe\'] = getText( pipeFile() )\r\n\r\n\r\n\r\ndef theCommand( file=\'\', theFocus=False, printThis=True, justSwitches=False, separate=False ):\r\n    global switches\r\n    # _.theCommand( __file__, theFocus=False, printThis=True, justSwitches=False  )\r\n    \r\n    if not type( theFocus ) == bool:\r\n        appReg = theFocus\r\n    else:\r\n        appReg = __.appReg\r\n    if len( file ):\r\n        if _v.slash in file or \'.py\' in file.lower():\r\n            appDBA = __.thisApp( file )\r\n        else:\r\n            appDBA = file\r\n    else:\r\n        appDBA = \'\'\r\n    theSwitchInfo = switches.rebuild()\r\n    if justSwitches:\r\n        result = theSwitchInfo\r\n    else:\r\n        result = \'p \' + appDBA + \' \' + theSwitchInfo\r\n    if printThis:\r\n        print_( result )\r\n    if separate:\r\n        return [ \'p \' + appDBA, theSwitchInfo ]\r\n\r\n    return result\r\n\r\ndef triggerSpace( data ):\r\n    data = data.replace( \',\', \' \' )\r\n    return data\r\n\r\ndef longDashAdd( data ):\r\n    data = _str.clean_latin1( data )\r\n    data = data.replace( \' :\', \':\' )\r\n    data = data.replace( \'-\', \'\xe2\x80\x94\' )\r\n    return data\r\n\r\ndef longDashRemove( data ):\r\n    data = data.replace( \'\xe2\x80\x94\', \'-\' )\r\n    return data\r\n\r\n\r\ndef inRelevantFolder( file ):\r\n    # if __.myFileLocations_SKIP_VALIDATION:\r\n    #   return file\r\n    found = inRelevantFolderSearch( file )\r\n    if type( found ) == bool:\r\n        return file\r\n    if os.path.isfile( found ):\r\n        myFileLocation_Files.append( found )\r\n    return found\r\ndef inRelevantFolderSearch( file ):\r\n    # if __.myFileLocations_SKIP_VALIDATION:\r\n    #   return file\r\n    if os.path.isfile( file ):\r\n        return os.getcwd() +_v.slash+ file\r\n\r\n    probableLocations = [\r\n        "_v.py + _v.slash+\'\'+_v.slash + \'*THEFILENAME*\' + \'.py\'",\r\n        "_v.py + _v.slash+\'\'+_v.slash + \'*THEFILENAME*\'",\r\n        "_v.myTables + _v.slash+\'\'+_v.slash + \'*THEFILENAME*\'",\r\n        "_v.myApps + _v.slash+\'batch\'+_v.slash + \'*THEFILENAME*\'",\r\n        "_v.myApps + _v.slash+\'batch\'+_v.slash + \'*THEFILENAME*\' + \'.bat\'",\r\n        "_v.myDatabases + _v.slash+\'\'+_v.slash + \'*THEFILENAME*\'",\r\n        "os.environ[\'USERPROFILE\'] + _v.slash+\'Desktop\'+_v.slash + \'*THEFILENAME*\'",\r\n        "os.environ[\'USERPROFILE\'] + _v.slash+\'Documents\'+_v.slash + \'*THEFILENAME*\'",\r\n        "os.environ[\'USERPROFILE\'] + _v.slash+\'Downloads\'+_v.slash + \'*THEFILENAME*\'",\r\n        "_v.myTXT + _v.slash+\'\'+_v.slash + \'*THEFILENAME*\'",\r\n        "_v.myTXT + _v.slash+\'\'+_v.slash + \'*THEFILENAME*\'",\r\n        "_v.myApps + _v.slash+\'exe\'+_v.slash + \'*THEFILENAME*\'",\r\n        "_v.myApps + _v.slash+\'php\'+_v.slash + \'*THEFILENAME*\'",\r\n        "_v.myApps + _v.slash+\'php\'+_v.slash + \'*THEFILENAME*\' + \'.php\'",\r\n        "_v.myApps + _v.slash+\'powershell\'+_v.slash + \'*THEFILENAME*\'",\r\n        "_v.myApps + _v.slash+\'vbs\'+_v.slash + \'*THEFILENAME*\'",\r\n    ]\r\n\r\n    for test in probableLocations:\r\n        f = test.replace( \'*THEFILENAME*\', file )\r\n        if os.path.isfile( f ):\r\n            return f\r\n\r\n\r\n\r\n    global relevantFolders\r\n    if not len( relevantFolders ):\r\n        rf = getText( _v.relevant_folders, raw=True, clean=2 )\r\n        relevantFolders = rf.split(\'\\n\')\r\n    # \r\n\r\n    for folder in relevantFolders:\r\n        f = folder +_v.slash+ file\r\n        if os.path.isfile( f ):\r\n            return f\r\n    return False\r\n\r\n\r\ndef hasExtion( data, wild=False, free=False ):\r\n    global theExtensionsList\r\n    if not len( theExtensionsList ):\r\n        if not wild and not free:\r\n            ext = getText( _v.myTables + _v.slash+\'extensions.txt\', raw=True, clean=2 )\r\n        elif free:\r\n            ext = getText( _v.myTables + _v.slash+\'extensions_free.txt\', raw=True, clean=2 )\r\n        else:\r\n            ext = getText( _v.myTables + _v.slash+\'extensions_wild.txt\', raw=True, clean=2 )\r\n        theExtensionsList = ext.split(\'\\n\')\r\n    if not free:\r\n        if \'.\' in data:\r\n            end0 = data[(-4):]\r\n            end1 = data[(-5):]\r\n            if \'.\' == end0[0] or \'.\' == end1[0]:\r\n                testX = data.split(\'.\')\r\n                test = testX[len(testX)-1].lower()\r\n                if test in theExtensionsList:\r\n                    return True\r\n    else:\r\n        for ext in theExtensionsList:\r\n            if data.lower().endswith( \'.\'+ext ):\r\n                return True\r\n\r\n    return False\r\n\r\n\r\n\r\ndef popDelim( data, delim, pop=1 ):\r\n    data = str( data )\r\n    dataX = data.split( delim )\r\n    i = 0\r\n    while not i == pop:\r\n        dataX.pop()\r\n        i+=1\r\n    return delim.join( dataX )\r\n\r\n\r\ndef addComma( data ):\r\n    test = 0\r\n    try:\r\n        int(data)\r\n        test+=1\r\n    except Exception as e:\r\n        pass\r\n    try:\r\n        float(data)\r\n        test+=1\r\n    except Exception as e:\r\n        pass\r\n    \r\n    if not test:\r\n        return data\r\n\r\n    txt = str( data )\r\n    if \'.\' in txt:\r\n        txt = txt.split( \'.\' )[0]\r\n    n = []\r\n    for x in txt:\r\n        n.append( x )\r\n    n.reverse()\r\n    y = []\r\n    for i,x in enumerate(n):\r\n        y.append( x )\r\n        if ((i+1)%3==0):\r\n            y.append( \',\' )\r\n    y.reverse()\r\n    result = \'\'.join( y )\r\n    result = _str.cleanBE( result, \',\' )\r\n    return result\r\n\r\n\r\n\r\ndef genAppName( file ):\r\n    if file.lower().endswith( \'.py\' ):\r\n        x = file.split( \'.\' )\r\n        x.pop( len(x)-1 )\r\n        result = \'.\'.join( x )\r\n    else:\r\n        result = file\r\n    return result\r\n\r\ndef printFields( data, depth=1 ):\r\n    if depth == 1:\r\n        print_()\r\n    def tabLoop( depth ):\r\n        result = \'\'\r\n        i=0\r\n        while not i == depth:\r\n            i+=1\r\n            result += \'\\t\'\r\n        return result\r\n    if type( data ) == list:\r\n\r\n        if len(data) and type(data[0]) == dict:\r\n            for row in data[0].keys():\r\n                print_( tabLoop( depth ), row )\r\n                printFields( data[0][row], depth+1 )\r\n    elif type( data ) == dict:\r\n        for row in data.keys():\r\n            print_( tabLoop( depth ), row )\r\n            printFields( data[row], depth+1 )\r\n\r\ndef removeReturn( data ):\r\n    for i,row in enumerate(data):\r\n        data[i] = data[i].replace( \'\\n\', \'\' )\r\n    return data\r\n\r\ndef flattenList( data ):\r\n    result = \'\'\r\n    for row in data:\r\n        row = row.replace( \'\\n\', \'\' )\r\n        result += row + \'\\n\'\r\n    result = _str.cleanBE( result, \'\\n\' )\r\n    return result\r\n\r\ndef resolveIDs( data ):\r\n    global idResolution\r\n    data = str(data)\r\n    # if len( idResolution ) == 0:\r\n    if not len( idResolution ):\r\n        idResolution = getTable(\'idResolution.json\')\r\n    # idResolution = getTable(\'idResolution.json\')\r\n    for idx in idResolution:\r\n        if data in idx[\'id\']:\r\n            return \' ** \' + idx[\'name\'] + \' ** \'\r\n    return data\r\n\r\ndef printSafe( data ):\r\n    data = str( data )\r\n    result = \'\'\r\n    for ch in data:\r\n        if ch in _v.safeChar:\r\n            result += ch\r\n    return result\r\n\r\ndef setUmlData( data, openUML=True ):\r\n    saveTable2( data, _v.umlJson )\r\n\r\n    with open(_v.umlJson, \'r+\') as f:\r\n        content = f.read()\r\n        f.seek(0, 0)\r\n        f.write("theData=" + content)\r\n\r\n    # f=open(_v.umlJson,\'a\')\r\n    # f.seek(0,0)\r\n    # f.write("theData=")\r\n    # f.close()\r\n\r\n    if openUML:\r\n        import webbrowser\r\n        webbrowser.open( _v.umlHtml, new=2)\r\ndef setPipeData( data, theFocus=False, clean=True ):\r\n    global appData\r\n    if type( theFocus ) == bool:\r\n        theFocus = __.appReg\r\n    # _.appData[__.appReg][\'pipe\'] = list(data)\r\n    if len(data) > 0:\r\n        appData[theFocus][\'pipe\'] = []\r\n        if not clean:\r\n            appData[theFocus][\'pipe\'].append(\'\')\r\n        for pd in data:\r\n            if clean:\r\n                pd = pd.replace(\'\\n\',\'\')\r\n                pd = pd.replace(\'\\r\',\'\')\r\n                if not pd == \'\':\r\n                    appData[theFocus][\'pipe\'].append(pd)\r\n            else:\r\n                appData[theFocus][\'pipe\'].append(pd)\r\n        setPipeDataRan = True\r\n\r\n\r\n\r\ndef pipeCleaner(clean=0):\r\n    def pipeCleanerDeep(p):\r\n        while p.startswith(\' \'):\r\n            p = p[1:]\r\n\r\n        while p.endswith(\' \'):\r\n            p = p[:-1]\r\n\r\n\r\n\r\n        while p.startswith(\'\\r\'):\r\n            p = p[1:]\r\n\r\n        while p.endswith(\'\\r\'):\r\n            p = p[:-1]\r\n\r\n\r\n\r\n        while p.startswith(\'\\n\'):\r\n            p = p[1:]\r\n\r\n        while p.endswith(\'\\n\'):\r\n            p = p[:-1]\r\n\r\n\r\n\r\n        while p.startswith(\'\\t\'):\r\n            p = p[1:]\r\n\r\n        while p.endswith(\'\\t\'):\r\n            p = p[:-1]\r\n        return p\r\n\r\n\r\n    global appData\r\n    try:\r\n        if not appData[__.appReg][\'pipe\'][0][0] in _str.safeChar:\r\n            appData[__.appReg][\'pipe\'][0] = appData[__.appReg][\'pipe\'][0][1:]\r\n    except Exception as e:\r\n        pass\r\n    try:\r\n        for i,pipeData in enumerate(appData[__.appReg][\'pipe\']):\r\n            p = appData[__.appReg][\'pipe\'][i].replace(\'\\n\',\'\')\r\n            if clean:\r\n                while p.startswith(\' \'):\r\n                    p = p[1:]\r\n\r\n                while p.endswith(\' \'):\r\n                    p = p[:-1]\r\n            if type(clean) == int and clean > 1:\r\n                p = pipeCleanerDeep(p)\r\n                p = pipeCleanerDeep(p)\r\n                p = pipeCleanerDeep(p)\r\n\r\n\r\n            appData[__.appReg][\'pipe\'][i] = p\r\n    except Exception as e:\r\n        pass\r\n    return appData[__.appReg][\'pipe\']\r\n\r\n""" {7DB6A001-0637-4F13-B328-2B17A481CF35}\r\ndef copyVar( data ):\r\n    import pyperclip\r\n    return pyperclip.copy( str(data) )\r\n"""\r\n""" {7DB6A001-0637-4F13-B328-2B17A481CF35}\r\ndef openURL( data ):\r\n    import webbrowser\r\n    webbrowser.open( data, new=2 )\r\n\r\ndef copyDicAsJSON( data, openUML=False ):\r\n    txt = copyVar( d2json( data ) )\r\n    if openUML:\r\n        import webbrowser\r\n        webbrowser.open(\'https://vanya.jp.net/vtree/\', new=2)\r\n    return txt\r\n"""\r\n\r\ndef cleanDic( data ):\r\n    nowJSON_TXT = d2json( data )\r\n    nowDic = json2d( nowJSON_TXT, True )\r\n\r\ndef d2json( data, sort_keys=False ):\r\n    simplejson = __.imp(\'simplejson\')\r\n    # saveTable2( data, _v.json_temp )\r\n    # txt = getText( _v.json_temp, raw=True )\r\n\r\n    return simplejson.dumps(data, indent=4, sort_keys=sort_keys)\r\n\r\ndef printVar1( data ):\r\n    print_( d2json( data ) )\r\n\r\n\r\ndef printVar( data, sort_keys=False, isDic=None ):\r\n    data = json_clean(data)\r\n    if not isDic is None and isDic and type(data) == str:\r\n        saveText( data, _v.myTemp + _v.slash+\'printVar.json\' )\r\n        data = getTable2( _v.myTemp + _v.slash+\'printVar.json\' )\r\n        result = d2json( data, sort_keys )\r\n    else:\r\n        result = data\r\n    # saveTable2( data, _v.json_temp )\r\n    # result = getText( _v.json_temp, raw=True )\r\n    # result = type( result )\r\n    result = printVarColor( result )\r\n    print_(  )\r\n\r\ndef printTest( data, color=\'white\', line=None, isPrint=1, shouldExit=1, validate=1, raw=0, profile=False, sort_keys=False, pause=None,    r=0, v=1, val=1, l=None, x=1, s=False, sk=False, p=None ):\r\n\r\n    data = json_clean(data)\r\n\r\n    if not p is None:\r\n        pause = p\r\n\r\n    if s or sk:\r\n        sort_keys = True\r\n\r\n    if not x:\r\n        shouldExit = 0\r\n\r\n\r\n    if r:\r\n        raw = True\r\n    if not l is None:\r\n        line = l\r\n    if not v or not val:\r\n        validate = False\r\n    if raw:\r\n        validate = False\r\n    isCode = False\r\n\r\n    if p is None:\r\n        pause = p\r\n\r\n    shouldPause = False\r\n    if not pause is None:\r\n        shouldPause = True\r\n        shouldExit = 0\r\n\r\n    if not line is None:\r\n        colorThis( [ \'Line:\', line ], \'green\' )\r\n    if type( data ) == dict:\r\n        isCode = True\r\n    elif type( data ) == list and len(data) and type( data[0] ) == dict:\r\n        isCode = True\r\n    elif type( data ) == list and not isPrint:\r\n        isCode = True\r\n    elif type( data ) == list and isPrint:\r\n        isCode = False\r\n    else:\r\n        isCode = False\r\n\r\n    if not validate:\r\n        isCode = False\r\n\r\n    if profile:\r\n        import _rightThumb._profileVariables as _profile\r\n        profile = _profile.records.audit( \'printTest_profile\', data )\r\n        data = profile\r\n        isCode = True\r\n    \r\n\r\n\r\n    if isCode:\r\n        if validate:\r\n            printVar( data, sort_keys )\r\n        else:\r\n            printVarSimple( data, sort_keys )\r\n    else:\r\n        if raw:\r\n            colorThis( str(data), color )\r\n        else:\r\n            colorThis( data, color )\r\n\r\n    if shouldPause:\r\n        print_(\'pause doesnt work\')\r\n        sys.exit()\r\n\r\n        pause=input(\' - \')\r\n    elif shouldExit:\r\n        # print_(\'shouldExit\')\r\n        sys.exit()\r\n\r\n\r\ndef printVar2( data, sort_keys=False ):\r\n    printVarOld( data, sort_keys )\r\n    \r\ndef printVarSimple( data, sort_keys=False, isDic=None, prefix=None, remove=None, d=None, p=True ):\r\n    simplejson = __.imp(\'simplejson\')\r\n    dump=simplejson.dumps(data, indent=4, sort_keys=sort_keys)\r\n    if d:\r\n        if p:\r\n            print_(dump)\r\n        return dump \r\n    data = json_clean(data)\r\n    if not isDic is None and isDic and type(data) == str:\r\n        # saveText( data, _v.myTemp + _v.slash+\'printVarSimple.json\' )\r\n        # data = getTable2( _v.myTemp + _v.slash+\'printVarSimple.json\' )\r\n        data = dump\r\n    printVarOld( data, sort_keys, prefix=prefix, remove=remove )\r\n\r\ndef printVarSimple2( data, sort_keys=False, isDic=None ):\r\n\r\n    result = d2json( data, sort_keys )\r\n    result = result.replace( \'"\', \'\' )\r\n    result = result.replace( \',\', \'\' )\r\n    result = printVarColor_OLD( result )\r\n    print_( result )\r\n\r\n\r\ndef printVarSimpleFake( data ):\r\n    result = printVarColor_OLD( data )\r\n    print_( result )\r\ndef printVarOld( data, sort_keys=False, prefix=None, remove=None ):\r\n    result = d2json( data, sort_keys )\r\n    # result = type( result )\r\n    result = printVarColor_OLD( result )\r\n    if not remove is None:\r\n        for x in remove:\r\n            result = result.replace(x,\'\')\r\n    if prefix is None:\r\n        print_( result )\r\n    else:\r\n        for x in result.split(\'\\n\'):\r\n            print_( prefix+x )\r\n\r\ndef printVarSimplePostReplace( data, string, newString, sort_keys=False ):\r\n    result = d2json( data, sort_keys )\r\n    # result = type( result )\r\n    result = printVarColor_OLD( result )\r\n    result = result.replace( string, newString )\r\n    print_( result )\r\n\r\n\r\ndef printVar2( data, sort_keys=False ):\r\n    result = d2json( data, sort_keys )\r\n    result = printVarColor_OLD( result )\r\n    print_( result )\r\n\r\n\r\ndef printVarColor( data ):\r\n    _code = regImp( __.appReg, \'_rightThumb._auditCodeBase\' )\r\n    validator = _code.imp.Validator()\r\n\r\n    # index = validator.createIndex( data, \'javascript\' )\r\n    # validator.colorPrint_old()\r\n    # print_(data)\r\n    index = validator.createIndex( data, \'javascript\', skipLoad=True, simple=False, A=None, B=True, C=None )\r\n    # printVarSimple(validator.identity)\r\n    # index = validator.createIndex( data, \'javascript\', simple=False, B=True )\r\n    validator.colorPrint()\r\n    \r\ndef printVarSimpleSTR(data):\r\n    print_( printVarColor_OLD( data ) )\r\n\r\ndef printVarColor_OLD( code ):\r\n    result = \'\'\r\n    i=-1\r\n    while True:\r\n        i+=1\r\n        if i == len(code): return result;\r\n        c=code[i]\r\n        if c == "\'":\r\n            ii = vindex(code,i+1,n="\'",v=0)\r\n            txt=\'\'\r\n            txt+=Color.darkcyan+"\'"+Color.end\r\n            # txt+=inlineBold( \'"\', \'darkcyan\' )\r\n            txt+=inlineBold( code[i+1:ii], \'cyan\' )\r\n            txt+=Color.darkcyan+"\'"+Color.end\r\n            # print_(ii,c,)\r\n            result += txt\r\n            i = ii\r\n        elif c == \'"\':\r\n            ii = vindex(code,i+1,n=\'"\',v=0)\r\n            txt=\'\'\r\n            txt+=Color.darkcyan+\'"\'+Color.end\r\n            # txt+=inlineBold( \'"\', \'darkcyan\' )\r\n            txt+=inlineBold( code[i+1:ii], \'cyan\' )\r\n            txt+=Color.darkcyan+\'"\'+Color.end\r\n            # print_(ii,c,)\r\n            result += txt\r\n            i = ii\r\n        else:\r\n            result += printVarColorChar( c )\r\n\r\n    return result\r\n\r\n\r\n    # Gray = \'\\033[1;30;40m\'\r\n    # Red = \'\\033[1;31;40m\'\r\n    # Green = \'\\033[1;32;40m\'\r\n    # Yellow = \'\\033[1;33;40m\'\r\n    # Blue = \'\\033[1;34;40m\'\r\n    # Magenta = \'\\033[1;35;40m\'\r\n    # Cyan = \'\\033[1;36;40m\'\r\n    # White = \'\\033[1;37;40m\'\r\n    # END = \'\\033[0m\'\r\n\r\n\r\n# def inlineColor( string, color=\'RED\' ):\r\n#   color = color.upper()\r\n#   if not type(string) == str:\r\n#       string = str(string)\r\n#   if color == \'RED\':\r\n#       return Color.RED + string + Color.END\r\n#   elif color == \'CYAN\':\r\n#       return Color.CYAN + string + Color.END\r\n#   elif color == \'DARKCYAN\' or color == \'grey\':\r\n#       return Color.DARKCYAN + string + Color.END\r\n#   elif color == \'BLUE\':\r\n#       return Color.BLUE + string + Color.END\r\n#   elif color == \'GREEN\':\r\n#       return Color.GREEN + string + Color.END\r\n#   elif color == \'YELLOW\':\r\n#       return Color.YELLOW + string + Color.END\r\n#   elif color == \'UNDERLINE\':\r\n#       return Color.UNDERLINE + string + Color.END\r\n\r\n\r\ndef printVarColorChar( data ):\r\n\r\n\r\n    what = \'(\'\r\n    color = \'Background.red\'\r\n    if data == what:\r\n        return data.replace( what, colorThis( what, color, shouldPrint=False ) )\r\n\r\n    what = \')\'\r\n    color = \'Background.red\'\r\n    if data == what:\r\n        return data.replace( what, colorThis( what, color, shouldPrint=False ) )\r\n\r\n\r\n    what = \'{\'\r\n    color = \'green\'\r\n    if data == what:\r\n        return data.replace( what, inlineBold( what, color ) )\r\n    \r\n    what = \'}\'\r\n    color = \'green\'\r\n    if data == what:\r\n        return data.replace( what, inlineBold( what, color ) )\r\n    \r\n    what = \'[\'\r\n    color = \'YELLOW\'\r\n    if data == what:\r\n        return data.replace( what, inlineColor( what, color ) )\r\n\r\n    what = \']\'\r\n    color = \'YELLOW\'\r\n    if data == what:\r\n        return data.replace( what, inlineBold( what, color ) )\r\n\r\n    what = \'"\'\r\n    color = \'white\'\r\n    if data == what:\r\n        return data.replace( what, inlineBold( what, color ) )\r\n\r\n    what = "\'"\r\n    color = \'white\'\r\n    if data == what:\r\n        return data.replace( what, inlineBold( what, color ) )\r\n\r\n    what = \':\'\r\n    color = \'red\'\r\n    if data == what:\r\n        return data.replace( what, inlineBold( what, color ) )\r\n\r\n    what = \',\'\r\n    color = \'Magenta\'\r\n    if data == what:\r\n        return data.replace( what, inlineBold( what, color ) )\r\n\r\n    what = \'=\'\r\n    color = \'red\'\r\n    if data == what:\r\n        return data.replace( what, inlineBold( what, color ) )\r\n\r\n    return data\r\n\r\n\r\n\r\ndef class2Dic( data ):\r\n    saveTable2( data, _v.json_temp )\r\n    txt = getTable2( _v.json_temp )\r\n    return txt\r\n\r\n""" {7DB6A001-0637-4F13-B328-2B17A481CF35}\r\ndef json2d( data, formatOnline=False ):\r\n    saveText( data, _v.json_temp )\r\n    dic = getTable2( _v.json_temp )\r\n    if formatOnline:\r\n        copyVar( dic )\r\n        \r\n        import webbrowser\r\n        webbrowser.open(\'https://beautifier.io/\', new=2)\r\n    return dic\r\n"""\r\n\r\nmyFileLocation_Print = True\r\nmyFileLocation_File = False\r\nmyFileLocation_Files = []\r\nmyFileLocation_Pipe = []\r\nbackup_subject_files = True\r\n\r\ndef myFileLocationsXYZ( file, silent=False, currentBaseVersion=3 ):\r\n    global appData\r\n    global myFileLocation_Files\r\n    global myFileLocation_Pipe\r\n    myFileLocationsABC( file, silent=silent, currentBaseVersion=currentBaseVersion )\r\n    if not __.myFileLocations_SKIP_VALIDATION:\r\n        if type(appData[__.appReg][\'pipe\']) == list:\r\n            for i,f in enumerate(appData[__.appReg][\'pipe\']):\r\n                appData[__.appReg][\'pipe\'][i] = __.path(f)\r\n    for i,f in enumerate(myFileLocation_Files):\r\n        myFileLocation_Files[i] = __.path(f)\r\n    for i,f in enumerate(myFileLocation_Pipe):\r\n        myFileLocation_Pipe[i] = __.path(f)\r\n    if type(appData[__.appReg][\'pipe\']) == list and len(appData[__.appReg][\'pipe\']):\r\n        # print_(\'here a\')\r\n        return appData[__.appReg][\'pipe\']\r\n    else:\r\n        # print_(\'here b\')\r\n        # print_(type(myFileLocation_Files[0]))\r\n        if len(myFileLocation_Files):\r\n            return myFileLocation_Files[0]\r\n        else:\r\n            return myFileLocation_Files\r\n\r\ndef myFileLocations_add_file(path):\r\n    global appData\r\n    global myFileLocation_Files\r\n    if __.myFileLocations_SKIP_VALIDATION:\r\n        if type( appData[__.appReg][\'pipe\'] ) == bool:\r\n            appData[__.appReg][\'pipe\'] = []\r\n        if isFirst:\r\n            isFirst=False\r\n        else:\r\n            appData[__.appReg][\'pipe\'].append( path )\r\n    if  not path in myFileLocation_Files:\r\n        myFileLocation_Files.append( path )\r\n\r\ndef _mfl(file):\r\n    if type(file) == str: file=file.replace(os.sep+os.sep,os.sep);\r\n    if type(file) == list and len(file) and type(file[0]) == str:\r\n        for i,f in enumerate(file):\r\n            if type(f) == str: file[i]=file[i].replace(os.sep+os.sep,os.sep);\r\n    return file\r\n\r\nisFirst=True\r\ndef myFileLocations( file, silent=False, currentBaseVersion=3 ):\r\n    if __.isRequired_Pipe_or_File:\r\n        return file\r\n    # return file\r\n    global appData\r\n    global isFirst\r\n    if \'*\' in file:\r\n        __.trigger_isPipe = \'glob\'\r\n    if os.path.isfile(file):\r\n        myFileLocations_add_file(file)\r\n\r\n    # print_(\'here\')\r\n    try:\r\n        __.myFileLocations_processed\r\n    except Exception as e:\r\n        __.myFileLocations_processed = False\r\n    # print_(\'__.trigger_isPipe\',__.trigger_isPipe)\r\n    # print_(__.trigger_isPipe)\r\n    # if \'glob\' in __.trigger_isPipe:\r\n    #     import glob\r\n    #     g = glob.glob(file)\r\n    #     print_(\'g\',g,__.myFileLocations_processed)\r\n    #     return g\r\n\r\n    if not __.myFileLocations_processed and not type( __.trigger_isPipe ) == bool:\r\n        __.myFileLocations_processed = True\r\n        if \'glob\' in __.trigger_isPipe:\r\n            # cp(\'__.trigger_isPipe=glob\',\'purple\')\r\n            appData[__.appReg][\'pipe\'] = \'\'\r\n            # __.trigger_isPipe = False\r\n            # glob = __.imp(\'glob\')\r\n            import glob\r\n            g = glob.glob(file)\r\n            for f in g:\r\n                # f = __.path(f)\r\n                # FX = getText( f, raw=True )\r\n                # print_(\'_____________________\')\r\n                # print_(f,FX)\r\n                # print_(\'_____________________\')\r\n                # sys.exit()\r\n                # appData[__.appReg][\'pipe\'] += FX + \'\\n\'\r\n                myFileLocations( f, silent, currentBaseVersion )\r\n            file = g\r\n            # print_(g)\r\n            # return g\r\n            # appData[__.appReg][\'pipe\'] = appData[__.appReg][\'pipe\'].split(\'\\n\')\r\n            # print_("appData[__.appReg][\'pipe\']",appData[__.appReg][\'pipe\'])\r\n            return _mfl(file)\r\n            try:\r\n                return _mfl(f)\r\n            except Exception as e:\r\n                return _mfl(file)\r\n\r\n    # print_(__.myFileLocations_SKIP_VALIDATION)\r\n    # print_(os.path.isdir(file))\r\n    # print_(file)\r\n    # sys.exit()\r\n\r\n    # print_( \'HERE HERE HERE HERE \', file )\r\n    if \'*\' in file:\r\n        import glob\r\n        if not type(appData[__.appReg][\'pipe\']) == list: appData[__.appReg][\'pipe\']=[];\r\n        for path in glob.glob(file):\r\n            appData[__.appReg][\'pipe\'].append(path)\r\n        return _mfl(appData[__.appReg][\'pipe\'])\r\n\r\n\r\n\r\n    global myFileLocation_File\r\n    global backup_subject_files\r\n    if type(__.myFileLocations_SKIP_VALIDATION) == bool and __.myFileLocations_SKIP_VALIDATION:\r\n        # print_(\'here\')\r\n        # sys.exit()\r\n        if not type(appData[__.appReg][\'pipe\']) == list:\r\n            appData[__.appReg][\'pipe\']=[]\r\n            return _mfl(None)\r\n        if isFirst:\r\n            isFirst=False\r\n        else:\r\n            appData[__.appReg][\'pipe\'].append( file )\r\n        return _mfl(None)\r\n    # if \',\' in file and not os.path.isfile( file ):\r\n    #   nFiles = []\r\n    #   for f in file.split(\',\'):\r\n    #       nFiles.append( myFileLocations2( f, silent, currentBaseVersion ) )\r\n    #   file = \',\'.join( nFiles )\r\n        \r\n    # else:\r\n    #   myFileLocation_File = myFileLocations2( file, silent, currentBaseVersion )\r\n\r\n    myFileLocation_File = myFileLocations2( file, silent, currentBaseVersion )\r\n    if  not myFileLocation_File in myFileLocation_Files:\r\n        myFileLocation_Files.append( myFileLocation_File )\r\n    try:\r\n        autoAbbreviations()\r\n    except Exception as e:\r\n        pass\r\n    if len( myFileLocation_Files ):\r\n        # print_(\'xxx\')\r\n    # if len( myFileLocation_Files ) and type( appData[__.appReg][\'pipe\'] ) == bool:\r\n        if not type( __.trigger_isPipe ) == bool:\r\n            # print_( \'HERE\', myFileLocation_Files )\r\n            __.appRegPipe = __.appReg\r\n\r\n            if \'name\' in __.trigger_isPipe:\r\n                justNames = True\r\n            else:\r\n                justNames = False\r\n\r\n            tmpFiles = []\r\n            hasFiles = False\r\n            if justNames:\r\n                # print_( \'HERE\' )\r\n                # setPipeData( myFileLocation_Files, __.appReg )\r\n\r\n                if type( appData[__.appReg][\'pipe\'] ) == bool:\r\n                    appData[__.appReg][\'pipe\'] = []\r\n                for thisFile in myFileLocation_Files:\r\n                    # if os.path.isfile( thisFile ):\r\n                    if not thisFile in myFileLocation_Pipe:\r\n                        myFileLocation_Pipe.append( thisFile )\r\n                        if isFirst:\r\n                            isFirst=False\r\n                        else:\r\n                            appData[__.appReg][\'pipe\'].append( thisFile )\r\n            else:\r\n                for thisFile in myFileLocation_Files:\r\n                    if os.path.isfile( thisFile ):\r\n                        hasFiles = True\r\n                        if not thisFile in myFileLocation_Pipe:\r\n                            myFileLocation_Pipe.append( thisFile )\r\n                            if type( appData[__.appReg][\'pipe\'] ) == bool:\r\n                                appData[__.appReg][\'pipe\'] = []\r\n                            if \'clean\' in __.trigger_isPipe:\r\n                                for row in getText( thisFile, raw=True, clean=True ).split(\'\\n\'):\r\n                                    if isFirst:\r\n                                        isFirst=False\r\n                                    else:\r\n                                        appData[__.appReg][\'pipe\'].append( row )\r\n                                    # tmpFiles.append( row )\r\n                            else:\r\n                                for row in getText( thisFile, raw=True ).split(\'\\n\'):\r\n                                    if isFirst:\r\n                                        isFirst=False\r\n                                    else:\r\n                                        if type(appData[__.appReg][\'pipe\']) == list:\r\n                                            appData[__.appReg][\'pipe\'].append( row )\r\n                                    # tmpFiles.append( row )\r\n            # if hasFiles:\r\n            #   if \'clean\' in __.trigger_isPipe:\r\n            #       setPipeData( tmpFiles, __.appReg, clean=True )\r\n            #   else:\r\n            #       setPipeData( tmpFiles, __.appReg, clean=False )\r\n            if not hasFiles:\r\n                if type( appData[__.appReg][\'pipe\'] ) == bool:\r\n                    appData[__.appReg][\'pipe\'] = []\r\n                    for row in myFileLocation_Files:\r\n                        if isFirst:\r\n                            isFirst=False\r\n                        else:\r\n                            appData[__.appReg][\'pipe\'].append( row )\r\n\r\n\r\n\r\n    return _mfl(myFileLocation_File)\r\ndef myFileLocations2( file, silent=False, currentBaseVersion=3 ):\r\n    if __.myFileLocations_SKIP_VALIDATION:\r\n        return _mfl(file)\r\n    # global myFileLocation_Print\r\n    # silentSetTo = myFileLocation_Print\r\n    silentSetTo = l.conf(\'myFileLocation_Print\',d=False)\r\n    if silent:\r\n        silentSetTo = silent\r\n\r\n    if os.path.isfile( file ):\r\n        return _mfl(file)\r\n\r\n    if \'tmpf\' in file.lower():\r\n        fx = file.lower()\r\n        if \'tmpf\' == fx:\r\n            return _mfl(_v.tmpf)\r\n        elif \'tmpf0\' == fx:\r\n            return _mfl(_v.tmpf0)\r\n        elif \'tmpf1\' == fx:\r\n            return _mfl(_v.tmpf1)\r\n        elif \'tmpf2\' == fx:\r\n            return _mfl(_v.tmpf2)\r\n        elif \'tmpf3\' == fx:\r\n            return _mfl(_v.tmpf3)\r\n        elif \'tmpf4\' == fx:\r\n            return _mfl(_v.tmpf4)\r\n        elif \'tmpf5\' == fx:\r\n            return _mfl(_v.tmpf5)\r\n        elif \'tmpf6\' == fx:\r\n            return _mfl(_v.tmpf6)\r\n        elif \'tmpf7\' == fx:\r\n            return _mfl(_v.tmpf7)\r\n        elif \'tmpf8\' == fx:\r\n            return _mfl(_v.tmpf8)\r\n        elif \'tmpf9\' == fx:\r\n            return _mfl(_v.tmpf9)\r\n        return _mfl(file)\r\n\r\n    probableLocations = [\r\n        "_v.py + _v.slash+\'_rightThumb\'+_v.slash + \'_\' + \'*THEFILENAME*\' + _v.slash+\'__init__.py\'",\r\n        "_v.py + _v.slash+\'\'+_v.slash + \'*THEFILENAME*\' + \'.py\'",\r\n        "_v.py + _v.slash+\'\'+_v.slash + \'*THEFILENAME*\'",\r\n        "_v.myTables + _v.slash+\'\'+_v.slash + \'*THEFILENAME*\'",\r\n        "_v.myApps + _v.slash+\'batch\'+_v.slash + \'*THEFILENAME*\'",\r\n        "_v.myApps + _v.slash+\'batch\'+_v.slash + \'*THEFILENAME*\' + \'.bat\'",\r\n        "_v.myDatabases + _v.slash+\'\'+_v.slash + \'*THEFILENAME*\'",\r\n\r\n        "os.environ[\'USERPROFILE\'] + _v.slash+\'Desktop\'+_v.slash + \'*THEFILENAME*\'",\r\n        "os.environ[\'USERPROFILE\'] + _v.slash+\'Documents\'+_v.slash + \'*THEFILENAME*\'",\r\n        "os.environ[\'USERPROFILE\'] + _v.slash+\'Downloads\'+_v.slash + \'*THEFILENAME*\'",\r\n\r\n        "os.environ[\'HOME\'] + _v.slash+\'Desktop\'+_v.slash + \'*THEFILENAME*\'",\r\n        "os.environ[\'HOME\'] + _v.slash+\'Documents\'+_v.slash + \'*THEFILENAME*\'",\r\n        "os.environ[\'HOME\'] + _v.slash+\'Downloads\'+_v.slash + \'*THEFILENAME*\'",\r\n        \r\n        "_v.myTXT + _v.slash+\'\'+_v.slash + \'*THEFILENAME*\'",\r\n        "_v.myTXT + _v.slash+\'\'+_v.slash + \'*THEFILENAME*\'",\r\n        "_v.myApps + _v.slash+\'exe\'+_v.slash + \'*THEFILENAME*\'",\r\n        "_v.myApps + _v.slash+\'php\'+_v.slash + \'*THEFILENAME*\'",\r\n        "_v.myApps + _v.slash+\'php\'+_v.slash + \'*THEFILENAME*\' + \'.php\'",\r\n        "_v.myApps + _v.slash+\'powershell\'+_v.slash + \'*THEFILENAME*\'",\r\n        "_v.myApps + _v.slash+\'vbs\'+_v.slash + \'*THEFILENAME*\'",\r\n    ]\r\n\r\n    if file == \'base\':\r\n        file = \'base\' + str( currentBaseVersion )\r\n\r\n    if True:\r\n        for testThis in probableLocations:\r\n            try:\r\n                theTest = eval( testThis )\r\n                # print_()\r\n                # print_(theTest)\r\n                theTest = theTest.replace( \'*THEFILENAME*\', file )\r\n                # print_(os.path.isfile( theTest ),theTest)\r\n                if os.path.isfile( theTest ):\r\n                    if silentSetTo:\r\n                        \r\n                        print_()\r\n                        print_( \'File not here but in:\', theTest )\r\n                        print_()\r\n                    # print(theTest)\r\n                    # return theTest\r\n                    return _mfl(theTest)\r\n\r\n            except Exception as e:\r\n                pass\r\n    \r\n    if not os.path.isfile( _v.relevant_folders ) and __.isWin:\r\n        print_( \'generateRelevantFolders\' )\r\n        import generateRelevantFolders\r\n        generateRelevantFolders.action()\r\n\r\n    if os.path.isfile( _v.relevant_folders ):\r\n        for fld in getText( _v.relevant_folders, raw=True, clean=1 ).split(\'\\n\'):\r\n            if os.path.isfile( fld  +_v.slash+  file ):\r\n                return _mfl(fld  +_v.slash+  file)\r\n            if \'ext\' in __.specifications:\r\n                if os.path.isfile( fld  +_v.slash+  file+ __.specifications[\'ext\'] ):\r\n                    return _mfl(fld  +_v.slash+  file)\r\n            # print_(fld)\r\n\r\n    return _mfl(file)\r\n\r\n\r\n\r\ndef cleanList( data ):\r\n    for i,d in enumerate(data):\r\n        data[i] = data[i].replace( \'\\n\', \'\' )\r\n    return data\r\n\r\nadminStatus = \'\'\r\ndef isAdmin():\r\n    global adminStatus\r\n    if type(adminStatus) == str:\r\n        tempFile = _v.stmp + _v.slash + genUUID()\r\n        do = \'echo %isAdmin%>\'+tempFile\r\n        test = os.system(\'"\' + do + \'"\')\r\n        isAdmin0 = getText(tempFile)\r\n        isAdmin1 = isAdmin0[0].replace(\'\\n\',\'\')\r\n        os.remove(tempFile)\r\n        if \'True\' in isAdmin1:\r\n            adminStatus = True\r\n        else:\r\n            adminStatus = False\r\n    return adminStatus\r\n\r\ndef autoDate( theDate ):\r\n    # if type(theDate) == float or type(theDate) == int:\r\n    #   return theDate\r\n    import _rightThumb._date as _date\r\n    return _date.autoDate( theDate )\r\n\r\ndef friendlyDate2( theDate ):\r\n    fd = friendlyDate( theDate )\r\n    if type(fd) == str and len(fd):\r\n        fd = fd[:-3][2:]\r\n        # if fd.startswith(\'21-\'):\r\n        #   fd = fd[3:]\r\n    return fd\r\n\r\ndef friendlyDate( theDate ):\r\n    import _rightThumb._date as _date\r\n    return _date.friendlyDate( theDate )\r\ndef friendlyDateTouch( theDate ):\r\n    import _rightThumb._date as _date\r\n    return _date.friendlyDateTouch( theDate )\r\n\r\ndef resolveEpoch( theDate, test=1, showPrint=False, showPrintTry=False, onlyEpoch=True, delim=\'-\', falseBlank=False ):\r\n    return resolveEpochTest( theDate, test, showPrint, showPrintTry, onlyEpoch, delim, falseBlank )\r\n\r\ndef resolveEpochTest( theDate, test=1, showPrint=False, showPrintTry=False, onlyEpoch=True, delim=\'-\', falseBlank=False ):\r\n    import _rightThumb._date as _date\r\n    return _date.resolveEpoch( theDate, test, showPrint, showPrintTry, onlyEpoch, delim, falseBlank )\r\n\r\ndef fileDate( theDate ):\r\n    friendly = friendlyDate( theDate )\r\n    friendly = friendly.replace( \' \', \'_\' )\r\n    friendly = friendly.replace( \':\', \'-\' )\r\n    return friendly\r\n\r\ndef dateAdd2( theDate, addDays, delim=\'-\' ):\r\n    \r\n    theDate = str( theDate )\r\n\r\n    if not delim in theDate:\r\n        try:\r\n            float( theDate )\r\n            theDate = resolveEpochTest( theDate, onlyEpoch=\'day\', delim=delim )\r\n            if type(theDate) == bool:\r\n                print_( \'Error:\', theDate )\r\n                sys.exit()\r\n        except Exception as e:\r\n            printBold( \'Error: \'+ theDate, \'red\' )\r\n            sys.exit()\r\n\r\n    fdtl0 = theDate.split(delim)\r\n    date0 = datetime.date(int(fdtl0[0]), int(fdtl0[1]), int(fdtl0[2]))\r\n    return date0 + datetime.timedelta(days=addDays)\r\n\r\ndef dateMathEpoch( epoch, theDays, do=\'+\' ):\r\n    # print_(epoch, theDays)\r\n    epoch = autoDate(epoch)\r\n    # if do == \'+\':\r\n    #   return epoch + ( theDays*86400 )\r\n    # elif do == \'-\':\r\n    #   return epoch - ( theDays*86400 )\r\n\r\n\r\n    date0 = datetime.datetime.fromtimestamp((epoch))\r\n    if do == \'+\':\r\n        date1 = date0 + datetime.timedelta(days=theDays)\r\n    elif do == \'-\':\r\n        date1 = date0 - datetime.timedelta(days=theDays)\r\n    else:\r\n        print_( "dateMathEpoch( epoch, theDays, do=\'+\' )" )\r\n        sys.exit()\r\n    # print_(date1.timestamp())\r\n    return autoDate((date1.timestamp()))\r\n\r\n\r\ndef txt2Date(text):\r\n    # _.switches.trigger(\'Watched\', _.txt2Date)\r\n\r\n    try:\r\n        if not type(text) == str:\r\n            text = \'\'\r\n    except Exception as e:\r\n        text = \'\'\r\n\r\n    if text == \'\':\r\n        theDate = datetime.date.today()\r\n        result = str( theDate ).split()[0]\r\n    elif \'-\' in text:\r\n        if text.count(\'-\') == 2:\r\n            try:\r\n                textSplit = text.split(\'-\')\r\n                # print_(textSplit)\r\n                theDate = datetime.datetime( int(textSplit[0]), int(textSplit[1]), int(textSplit[2]), 0, 0 )\r\n                result = str( theDate ).split()[0]\r\n            except Exception as e:\r\n                printBold(\'Date error: using today\\\'s date\',\'red\')\r\n                theDate = datetime.date.today()\r\n                result = str( theDate ).split()[0]\r\n        else:\r\n            print_(\'Date error: using today\\\'s date\')\r\n            theDate = datetime.date.today()\r\n            result = str( theDate ).split()[0]\r\n    else:\r\n        fnd = \'ymwd\'\r\n        do = text.lower().replace(\' \',\'\')\r\n        nmb = do\r\n        for t in fnd:\r\n            nmb = nmb.replace(t,\'\')\r\n        if len(nmb) == 0:\r\n            nmb = 1\r\n        try:\r\n            nmb = int(nmb)\r\n        except Exception as e:\r\n            nmb = 1\r\n        if \'y\' in do:\r\n            theDate = datetime.date.today() + datetime.timedelta(-365 * nmb)\r\n        if \'m\' in do:\r\n            theDate = datetime.date.today() + datetime.timedelta(-30 * nmb)\r\n        if \'w\' in do:\r\n            theDate = datetime.date.today() + datetime.timedelta(-7 * nmb)\r\n        if \'d\' in do:\r\n            theDate = datetime.date.today() + datetime.timedelta(-1 * nmb)\r\n        result = str( theDate ).split()[0]\r\n    return result\r\n\r\n\r\n\r\n## UUID ## START ############################################################################################################################\r\n\r\n\r\ndef uuidEpoc( uuid, f=\'iso\' ):\r\n    uuid = _str.do(\'an\',uuid)\r\n    if \'epoc\' in uuid:\r\n        d=int(uuid.split(\'epoc\')[1][:10])\r\n        return _.isDate( d, f=f)\r\n    return None\r\n\r\ndef genUUID( project=\'\', label=\'\', uniqueTimestamp=False, note=None, r=None, e=None, n=None, c=False, epoch=None,    small=None, t=None, tiny=None ):\r\n    if not tiny is None: small=tiny;    #KEEP 1ST\r\n    if not t is None: small=t;          #KEEP 2ND\r\n    if small: return miniUUID();        #KEEP 3RD\r\n    if not e is None: epoch=e;\r\n    if not n is None:  note=n;\r\n    if not r is None: small=None; end=r;\r\n\r\n    if epoch:\r\n        dec=2\r\n        if type(epoch) == int and not epoch==1:\r\n            dec=epoch\r\n\r\n        ee=time.time()\r\n        ea=str(ee).split(\'.\')[0]\r\n        eb=str(ee).split(\'.\')[1]\r\n        ec=str(ee).replace(\'.\',\'d\')\r\n        ad=ea\r\n        i=0\r\n        while not i == dec:\r\n            ad += eb[i]\r\n            i+=1\r\n        end=True\r\n        note=\'epoc\'+ad\r\n\r\n\r\n\r\n\r\n    global appData\r\n    global appInfo\r\n    def rev(string):\r\n        l=list(string)\r\n        l.reverse()\r\n        return \'\'.join(l)\r\n    uuid = __.imp(\'uuid\')\r\n    string = uuid.uuid4()\r\n    string = str(string)\r\n    # return string\r\n    ss=string\r\n    if note:\r\n        if end:\r\n            r=1\r\n        else:\r\n            r=0\r\n        ss=over(ss,note,r=r)\r\n    if c:\r\n        string = ss\r\n    else:\r\n        string = \'{\' + ss + \'}\'\r\n    try:\r\n        type(appData[__.appReg][\'uuid\'])\r\n        good = True\r\n    except Exception as e:\r\n        good = False\r\n    if good:\r\n\r\n        try:\r\n            timestamp = appData[__.appReg][\'start\']\r\n        except Exception as e:\r\n            timestamp = time.time()\r\n\r\n        if not project == \'\' or not label == \'\':\r\n            if type(appData[__.appReg][\'uuid\']) == str:\r\n                # print_()\r\n                # print_( \'__.appReg\', __.appReg )\r\n                # print_()\r\n                # print_(d2json( appData ))\r\n                # print_()\r\n                appData[__.appReg][\'uuid\'] = {}\r\n                # print_(appInfo[__.appReg][\'file\'])\r\n                # sys.exit()\r\n                appData[__.appReg][\'uuid\'][\'app\'] = appInfo[__.appReg][\'file\']\r\n\r\n            if not type(appData[__.appReg][\'uuid\']) == str:\r\n                \r\n                appData[__.appReg][\'uuid\'][\'uuid\'] = string\r\n                appData[__.appReg][\'uuid\'][\'timestamp\'] = timestamp\r\n                appData[__.appReg][\'uuid\'][\'project\'] = \'\'\r\n                appData[__.appReg][\'uuid\'][\'label\'] = \'\'\r\n\r\n                if uniqueTimestamp:\r\n                    appData[__.appReg][\'uuid\'][\'timestamp\'] = time.time()\r\n\r\n                if not project == \'\':\r\n                    appData[__.appReg][\'uuid\'][\'project\'] = project\r\n\r\n                if not label == \'\':\r\n                    appData[__.appReg][\'uuid\'][\'label\'] = label\r\n                    \r\n                uuidLog = getTable(\'uuid_log.json\')\r\n                uuidLog.append(appData[__.appReg][\'uuid\'])\r\n                saveTable(uuidLog,\'uuid_log.json\',printThis=False)\r\n            # appData[__.appReg][\'uuid\'] = { \'uuid\': theID, \'timestamp\': time.time(), \'project\': theProject, \'app\': \'guid\' }\r\n    return string\r\n\r\n\r\ndef miniUUID(epoch=None):\r\n    u = genUUID()\r\n    u = u.replace( \'{\',\'\' ).replace( \'-\',\'\' )\r\n    result = \'{\' + u[:12] + \'}\'\r\n    if epoch is None:\r\n        return result\r\n    else:\r\n        return UUID_Epoch(result)\r\n\r\n\r\ndef UUID_Epoch(vVv,dec=2,epoch=None):\r\n\r\n    if \'{\' in vVv:\r\n        hasBr=True\r\n    else:\r\n        hasBr=False\r\n\r\n\r\n    vVv=vVv.replace(\'{\',\'\').replace(\'}\',\'\')\r\n    i=0\r\n    indices=[]\r\n    for c in vVv:\r\n        if c == \'-\':\r\n            indices.append(i)\r\n        if not c == \'-\':\r\n            i+=1\r\n    vVv = _str.do(\'an\',vVv)\r\n    if epoch is None:\r\n        e=time.time()\r\n    else:\r\n        e=epoch\r\n    ea=str(e).split(\'.\')[0]\r\n    eb=str(e).split(\'.\')[1]\r\n    if len(eb) == 1:\r\n        eb+=\'0\'\r\n    ec=str(e).replace(\'.\',\'d\')\r\n    ad=ea\r\n    if not dec is None:\r\n        dec=int(dec)\r\n    else:\r\n        dec=2\r\n    pre=\'epoc\'\r\n    if len(vVv) == 12 or len(vVv) == 14:\r\n        from random import randrange\r\n        dec=0\r\n        pre=str(randrange(10))+\'e\'\r\n    i=0\r\n    while not i == dec:\r\n        ad += eb[i]\r\n        i+=1\r\n\r\n    # vVv = _.over(vVv,   ea+\'e\'  )\r\n    vVv = over(vVv,   pre+ad , r=1   )\r\n    if indices:\r\n        vVv = ddelim(vVv,d=\'-\',indices=indices)\r\n    if hasBr and not \'{\' in vVv:\r\n        vVv = \'{\'+vVv+\'}\'\r\n\r\n    return vVv\r\n\r\n\r\n\r\nUUID=genUUID\r\nguid=genUUID\r\n\r\nUUIDm=miniUUID\r\nUUIDM=miniUUID\r\nMUUID=miniUUID\r\nmUUID=miniUUID\r\n\r\nUUIDE=UUID_Epoch\r\nguidE=UUID_Epoch\r\nuuidE=UUID_Epoch\r\n\r\nUUIDe=uuidEpoc\r\nuuide=uuidEpoc\r\n\r\n## UUID ## END ############################################################################################################################\r\n\r\n\r\n__.fn.saveText = False\r\ndef saveText( rows, theFile, errors=True, me=0, test=None ):\r\n    # print_(rows)\r\n    ty9=type(rows)\r\n    if not test is None:\r\n        __.fn.saveText = test\r\n    test=0\r\n    if __.fn.saveText:\r\n        cp( [ \'saveText\', __.appReg, type(rows), theFile ], \'cyan\' )\r\n    HD.chmod(theFile)\r\n    # print_(type(rows))\r\n    try:\r\n        if type(rows) == bytes:\r\n            rows = str(rows,\'utf-8\')\r\n        f = open(theFile,\'w\', encoding=\'utf-8\')\r\n        # if type(rows) == str:\r\n\r\n        # print_(type(rows))\r\n        # f.write(str(rows))\r\n        # rows = [unicode(x.strip()) if x is not None else u\'\' for x in rows]\r\n        # f.write(rows)\r\n        # f.write(rows.encode("iso-8859-1", "replace"))\r\n\r\n        # print_(type(rows))\r\n        if type(rows) == str:\r\n            # print_(rows)\r\n            f.write(rows)\r\n            if __.fn.saveText:\r\n                print_(1111111,0)\r\n        else:\r\n            if __.fn.saveText:\r\n                print_(1111111,1)\r\n            # if ty9 == str:\r\n            #     f.write(str(rows))\r\n            # elif ty9 == list:\r\n            for i,row in enumerate(rows):\r\n                # f.write(str(row) + os.linesep)\r\n                if i == 0:\r\n                    if len(str(row)) > 0:\r\n                        f.write(str(row) + \'\\n\')\r\n                else:\r\n                    f.write(str(row) + \'\\n\')\r\n        f.close()\r\n        \r\n            \r\n    except Exception as e:\r\n        if type(rows) == list:\r\n            result = \'\'\r\n            for i,row in enumerate(rows):\r\n                # f.write(str(row) + os.linesep)\r\n                if i == 0:\r\n                    if len(str(row)) > 0:\r\n                        result += str(row) + \'\\n\'\r\n                else:\r\n                    result += str(row) + \'\\n\'\r\n\r\n            rows = result\r\n        try:\r\n            open(theFile, \'wb\').write(rows)\r\n            if __.fn.saveText:\r\n                print_(2222222)\r\n        except Exception as e:\r\n            try:\r\n                open(theFile, \'w\').write(rows)\r\n                if __.fn.saveText:\r\n                    print_(3333333)\r\n            except Exception as e:\r\n                new_text = \'\'\r\n                for x in rows:\r\n                    if x in _str.printable:\r\n                        new_text+=x\r\n                open(theFile, \'w\', encoding=\'utf-8\').write(new_text)\r\n                if __.fn.saveText:\r\n                    print_(4444444)\r\n        HD.chmod(theFile)\r\n        # if errors:\r\n        #   print_( \'Auto correction when saving text\' )\r\n    if me and theFile in vv.opened_file_me: changeM( theFile, vv.opened_file_me[theFile] );\r\n\r\ndef getText( theFile, raw=False, clean=False,  e=0, c=0 ):\r\n    try:\r\n        del os\r\n    except Exception as e:\r\n        pass\r\n\r\n    try:\r\n        import os\r\n    except Exception as e:\r\n        pass\r\n    if os.path.isfile(theFile): vv.opened_file_me[theFile] = os.path.getmtime( theFile );\r\n    HD.chmod(theFile)\r\n    lines = None\r\n    if os.path.isfile(theFile):\r\n        try:\r\n            f = open(theFile, \'r\', encoding=\'utf-8\')\r\n            lines = f.readlines()\r\n            f.close()\r\n        except Exception as e:\r\n            try:\r\n                f = open(theFile, \'r\', encoding=\'latin-1\')\r\n                lines = f.readlines()\r\n                f.close()\r\n            except Exception as e:\r\n                f = open(theFile, \'r\')\r\n                lines = f.readlines()\r\n                f.close()\r\n    else:\r\n        if not e:\r\n            return None\r\n        print_(\'(getText) Error: No File\')\r\n        sys.exit()\r\n    if raw:\r\n        txt = \'\'.join( lines )\r\n        # txt = txt.replace( _v.slash+\'n\', \'\\n\' )\r\n\r\n        if clean:\r\n            txt = _str.replaceDuplicate( txt, \'\\n\' )\r\n            txt = _str.cleanBE( txt, \'\\n\' )\r\n        if clean == 2:\r\n            txt = txt.replace( \'\\t\', \' \' )\r\n            txt = _str.replaceDuplicate( txt, \' \' )\r\n            while \'\\n \\n\' in txt:\r\n                txt = txt.replace( \'\\n \\n\', \'\\n\' )\r\n            txt = _str.replaceDuplicate( txt, \'\\n\' )\r\n            txt = _str.cleanBE( txt, \'\\n\' )\r\n        return txt\r\n    elif c > 0:\r\n        if c > 1:\r\n            txt = \'\'.join( lines )\r\n            TXT = \'\'\r\n            txt = txt.replace( "\'\\"\\"\\"\'", \'\' )\r\n            if \'"""\' in txt:\r\n                for i,item in enumerate(txt.split(\'"""\')):\r\n                    if i % 2 == 0:\r\n                        TXT+=item\r\n            elif not \'"""\' in txt:\r\n                TXT = txt\r\n            while \'    \' in TXT:\r\n                TXT = TXT.replace( \'    \', \'\\t\' )\r\n            while \' (\' in TXT:\r\n                TXT = TXT.replace( \' (\', \'(\' )\r\n            while \' =\' in TXT:\r\n                TXT = TXT.replace( \' =\', \'=\' )\r\n            while \'= \' in TXT:\r\n                TXT = TXT.replace( \'= \', \'=\' )\r\n            while \'def  \' in TXT:\r\n                TXT = TXT.replace( \'def  \', \'def \' )\r\n            while \'class  \' in TXT:\r\n                TXT = TXT.replace( \'class  \', \'class \' )\r\n            lines = TXT.split(\'\\n\')\r\n\r\n        newLines = []\r\n        for i,row in enumerate(lines):\r\n            # row = row.replace(\'\\n\',\'\')\r\n            row = row.replace(\'\\r\',\'\')\r\n            \r\n            if not c > 1:\r\n                newLines.append(row)\r\n            else:\r\n                row = row.split(\'#\')[0]\r\n                test = row\r\n                # while test.startswith(\' \') or test.startswith(\'\\t\'):\r\n                #   test = _str.cleanBE( test, \' \' )\r\n                #   test = _str.cleanBE( test, \'\\t\' )\r\n                if not test.startswith(\'#\') and len(test):\r\n                    newLines.append(row)\r\n\r\n\r\n            \r\n\r\n\r\n        return newLines\r\n\r\n    elif clean:\r\n        # lines = _str.replaceDuplicate( lines, \'\\n\' )\r\n        # lines = _str.cleanBE( lines, \'\\n\' )\r\n        for i,row in enumerate(lines):\r\n            row = row.replace( \'\\n\', \'\' )\r\n            row = row.replace( \'\\r\', \'\' )\r\n            if type(clean) == int:\r\n                row = row.replace( \'\\t\', \' \' )\r\n                row = _str.replaceDuplicate( row, \' \' )\r\n                row = _str.cleanBE( row, \' \' )\r\n            if clean == 3:\r\n                row = \' \' + row + \' \'\r\n\r\n            # print_( row )\r\n            lines[i] = row\r\n        return lines\r\n    else:\r\n        return lines\r\n\r\ndef getSize(fileobject):\r\n    try:\r\n        fileobject.seek(0,2) # move the cursor to the end of the file\r\n        size = fileobject.tell()\r\n        return size\r\n    except Exception as e:\r\n        try:\r\n            return get_size( fileobject )\r\n        except Exception as e:\r\n            return None\r\n\r\n# def formatSize(size):\r\n#   result = \'\'\r\n#   if size == None:\r\n#       result = \'\'\r\n#   elif size < 1024:\r\n#       result = str(size) + \' B\'\r\n#   elif size > 1024 and size < 1048576:\r\n#       num = round(size / 1024, 2)\r\n#       result = str(num) + \' KB\'\r\n#   elif size > 1048576 and size < 1073741824:\r\n#       num = round(size / 1048576, 2)\r\n#       result = str(num) + \' MB\'\r\n#   elif size > 1073741824 and size < 137438953472:\r\n#       num = round(size / 1073741824, 2)\r\n#       result = str(num) + \' GB\'\r\n#   # if size < 1:\r\n#   #   result = \'\'\r\n#   return result\r\n\r\ndef monthByNumber(month):\r\n    result = \'\'\r\n    if str(month) == \'01\':\r\n        result = \'Jan\'\r\n    if str(month) == \'02\':\r\n        result = \'Feb\'\r\n    if str(month) == \'03\':\r\n        result = \'Mar\'\r\n    if str(month) == \'04\':\r\n        result = \'Apr\'\r\n    if str(month) == \'05\':\r\n        result = \'May\'\r\n    if str(month) == \'06\':\r\n        result = \'Jun\'\r\n    if str(month) == \'07\':\r\n        result = \'Jul\'\r\n    if str(month) == \'08\':\r\n        result = \'Aug\'\r\n    if str(month) == \'09\':\r\n        result = \'Sep\'\r\n    if str(month) == \'10\':\r\n        result = \'Oct\'\r\n    if str(month) == \'11\':\r\n        result = \'Nov\'\r\n    if str(month) == \'12\':\r\n        result = \'Dec\'\r\n    return result\r\n\r\ndef weeks_between(start_date, end_date):\r\n    import math\r\n    start_date = datetime.date(int(formatDateYear(start_date)),int(formatDateMonth(start_date)),int(formatDateDay(start_date)))\r\n    start_date_monday = (start_date - datetime.timedelta(days=start_date.weekday()))\r\n    end_date = datetime.date(int(formatDateYear(end_date)),int(formatDateMonth(end_date)),int(formatDateDay(end_date)))\r\n    num_of_weeks = math.ceil((end_date - start_date_monday).days / 7.0)\r\n    return num_of_weeks - 1\r\ndef months_between(start_date, end_date):\r\n    # start_date = int(start_date)\r\n    # end_date = int(end_date)\r\n    # st = str(formatDateYear(start_date)) + \'-\' + str(formatDateMonth(start_date)) + \'-\' +  str(formatDateDay(start_date)) \r\n    # en = str(formatDateYear(end_date)) + \'-\' + str(formatDateMonth(end_date)) + \'-\' +  str(formatDateDay(end_date))\r\n    start = datetime.date(int(formatDateYear(start_date)), int(formatDateMonth(start_date)), int(formatDateDay(start_date)) )\r\n    end = datetime.date(int(formatDateYear(end_date)), int(formatDateMonth(end_date)), int(formatDateDay(end_date)) )\r\n    months = calculate_monthdelta(start, end)\r\n    return months\r\n""" {7DB6A001-0637-4F13-B328-2B17A481CF35}\r\ndef calculate_monthdelta(date1, date2):\r\n    import calendar\r\n    def is_last_day_of_the_month(date):\r\n        days_in_month = calendar.monthrange(date.year, date.month)[1]\r\n        return date.day == days_in_month\r\n    imaginary_day_2 = 31 if is_last_day_of_the_month(date2) else date2.day\r\n    monthdelta = (\r\n        (date2.month - date1.month) +\r\n        (date2.year - date1.year) * 12 +\r\n        (-1 if date1.day > imaginary_day_2 else 0)\r\n        )\r\n    # print monthdelta\r\n    return monthdelta\r\n"""\r\n\r\n# def timeout(start,t):\r\n\r\n#     # os._exit(0)\r\n#     # print_(\'loop\')\r\n#     global completed\r\n#     global killTime\r\n#     global timeoutKill\r\n#     ts = dt.now()\r\n\r\n#     if start == \'start\':\r\n#         timeoutKill = False\r\n#         completed = False\r\n#         killTime = ts + timedelta(seconds=int(t))\r\n\r\n#     if completed == False and ts < killTime:\r\n#         x = Timer(0.0, timeout, (\'loop\',t))\r\n#         x.start()\r\n#     elif completed == False:\r\n#         timeoutKill = True\r\n#         completed = True\r\n#         print_(\'\\n*** Timeout ***()\')\r\n#         # os._exit(0)\r\n\r\n# def processTimeout():\r\n#     global switches\r\n#     global defaultTimeout\r\n#     if switches.isActive(\'Timeout\') == True:\r\n#         try:\r\n#             defaultTimeout = int(switches.value(\'Timeout\'))\r\n#         except Exception as e:\r\n#             errors.append({\'id\': 18, \'function\': \'parent\', \'cnt\': 1, \'location\': "defaultTimeout = int(switches.value(\'Timeout\'))", \'vars\': [{\'name\': \'timeout\', \'value\': switches.value(\'Timeout\')}], \'error\': e})\r\n#             printBold(\'Error:\',\'red\')\r\n#             print_(\'\\tBad timeout value.\')\r\n#             os._exit(0)\r\n\r\n#     # print_(defaultTimeout)\r\n#     x = Timer(0.0, timeout, (\'start\',defaultTimeout))\r\n#     x.start()\r\n\r\n\r\ndef showLine( string, plus = \'\', minus = \'\',plusOr = False, end=None,isSub=False, OR=None ):\r\n    # print_(plus)\r\n    # print_(string)\r\n    global switches\r\n    # print_(switches.isActive(\'Plus\'))\r\n    # print_(switches.values(\'Plus\'))\r\n    # sys.exit()\r\n    if plus is None :\r\n        result = True\r\n    else:\r\n        if switches.isActive(\'Plus\') or not plus == \'\':\r\n            # print_(\'asdf\')\r\n            result = positiveResults(string,plus,plusOr,end,OR=OR)\r\n            if not result and switches.isActive(\'PlusClose\'):\r\n                result = closeResults( string )\r\n\r\n            if result and not isSub and switches.isActive(\'Plus-Sub\'):\r\n                result = False\r\n                for xXx in switches.values(\'Plus-Sub\'):\r\n                    if xXx.lower() in string.lower():\r\n                        result = True\r\n                        break\r\n\r\n\r\n        else:\r\n            result = True\r\n    if result == True and  (switches.isActive(\'Minus\') or not minus == \'\'):\r\n        result = minusResults(string,minus)\r\n    # print_(result)\r\n    return result\r\ndef closeResults( string ):\r\n    global switches\r\n    global plusClose\r\n    \r\n    if len( switches.value(\'PlusClose\') ):\r\n        try:\r\n            plusClose = float( switches.value(\'PlusClose\') )\r\n        except Exception as e:\r\n            pass\r\n\r\n    test = patternDiff( string, switches.value(\'Plus\') )\r\n    # print_( int(test), string, switches.value(\'Plus\') )\r\n    if test >= plusClose:\r\n        # print_( test, string )\r\n        return True\r\n    else:\r\n        return False\r\n\r\n\r\n\r\ndef positiveResults(string,plus=\'\',plusOr=False,end=None,OR=None):\r\n    global switches\r\n\r\n    if plusOr or switches.isActive(\'PlusOr\'):\r\n        plusOr = True\r\n    \r\n    if not OR is None:\r\n        plusOr=OR\r\n    if not plus == \'\':\r\n        plusInput = plus\r\n    else:\r\n        plusInput = switches.values(\'Plus\').copy()\r\n    if not end is None:\r\n        if type( plusInput ) == str:\r\n            plusInput += end\r\n        else:\r\n            for i,yh in enumerate(plusInput):\r\n                plusInput[i] += end\r\n    \r\n    pi = []\r\n    for x in plusInput:\r\n        pi.append( ci(x) )\r\n    plusInput = pi\r\n    del pi\r\n    if type( plusInput ) == str:\r\n        if not switches.isActive(\'StrictCase\'):\r\n            plusInput = plusInput.lower()\r\n        plusList = plusInput.split(\',\')\r\n    else:\r\n        for i,row in enumerate(plusInput):\r\n            if not switches.isActive(\'StrictCase\'):\r\n                plusInput[i] = plusInput[i].lower()\r\n        plusList = plusInput\r\n    length = len(plusList)\r\n    cnt = 0\r\n    result = False\r\n    if not switches.isActive(\'StrictCase\'):\r\n        string = string.lower()\r\n    # print_( plusList )\r\n    # sys.exit()\r\n    for s in plusList:\r\n        if not switches.isActive(\'StrictCase\'):\r\n            s = s.lower()\r\n        \r\n        if len(s) > 1 and s[0] == \'!\':\r\n            s=s[1:]\r\n            if string == s:\r\n                cnt += 1\r\n        elif len(s) > 1 and s[0] == \'*\':\r\n            s = s.replace(\'*\',\'\')\r\n            if string.endswith(s):\r\n                cnt += 1\r\n        elif len(s) > 1 and s[-1] == \'*\':\r\n            s = s.replace(\'*\',\'\')\r\n            if string.startswith(s):\r\n                cnt += 1\r\n        elif not switches.isActive(\'PlusDuplicate\') and (  not string.find(ci(s)) == -1 or s in string  ):\r\n            cnt += 1\r\n        elif switches.isActive(\'PlusDuplicate\') and (  string.count(ci(s)) > 1 or string.count(s) > 1 ):\r\n            cnt += 1\r\n        # if \'opus\' in string:\r\n        #   print_(cnt, string)\r\n        if length == cnt:\r\n            result = True\r\n            break\r\n        if plusOr:\r\n            if cnt > 0:\r\n                result = True\r\n    # if result:\r\n    #     print_(string,plus)\r\n    return result\r\n\r\ndef minusResults(string,minus=\'\'):\r\n    global switches\r\n    if not switches.isActive(\'StrictCase\'):\r\n        string = string.lower()\r\n    result = True\r\n    if not minus == \'\':\r\n        minusInput = minus\r\n    else:\r\n        minusInput = switches.values(\'Minus\')\r\n    if type( minusInput ) == str:\r\n        if not switches.isActive(\'StrictCase\'):\r\n            minusInput = minusInput.lower()\r\n        else:\r\n            minusInput = minusInput\r\n        minusList = minusInput.split(\',\')\r\n    else:\r\n        for i,row in enumerate(minusInput):\r\n            if not switches.isActive(\'StrictCase\'):\r\n                minusInput[i] = minusInput[i].lower()\r\n\r\n        minusList = minusInput\r\n\r\n    try:\r\n        for s in minusList:\r\n            if not switches.isActive(\'StrictCase\'):\r\n                s = s.lower()\r\n            if len(s) > 1 and s[0] == \'!\':\r\n                s=s[1:]\r\n                if string == s:\r\n                    result = False\r\n                    break\r\n            elif len(s) > 1 and s[0] == \'*\':\r\n                s = s.replace(\'*\',\'\')\r\n                if string.endswith(s):\r\n                    result = False\r\n                    break\r\n            elif len(s) > 1 and s[-1] == \'*\':\r\n                s = s.replace(\'*\',\'\')\r\n                if string.startswith(s):\r\n                    result = False\r\n                    break\r\n            if not string.find(ci(s)) == -1 or s in string:\r\n                result = False\r\n                break\r\n    except Exception as e:\r\n        pass\r\n    return result\r\n\r\ndef saveLog( logname, rows=[], focus=True, printThis=True ):\r\n    simplejson = __.imp(\'simplejson\')\r\n    global appInfo\r\n    global appData\r\n    \r\n    indentCode = True\r\n    log = \'app_audit_log_TIMESTAMP__FILENAME__LOGNAME__INSTANCE.json\'\r\n\r\n    if type(focus) == bool:\r\n        focus = __.appReg\r\n        \r\n    if not len(rows) and logname == \'threads\':\r\n        global threads\r\n        rows = threads.log()\r\n        # print_( rows )\r\n        # sys.exit()\r\n    if not len(rows) and logname == \'audit\':\r\n        for ad in __.structure():\r\n            if len(appData[ad][\'audit\']) > 0:\r\n                rows.append( { \'app\': appInfo[ad][\'file\'], \'focus\': ad, \'records\': appData[ad][\'audit\'] } )\r\n    try:\r\n        if len(appInfo[focus][\'instance\']) > 0:\r\n            log = log.replace(\'INSTANCE\',appInfo[focus][\'instance\'])\r\n        else:\r\n            log = log.replace(\'__INSTANCE\',\'\')\r\n    except Exception as e:\r\n        log = log.replace(\'__INSTANCE\',\'\')\r\n    \r\n    log = log.replace(\'TIMESTAMP\',str(appData[focus][\'start\']))\r\n    log = log.replace(\'FILENAME\',appInfo[focus][\'file\'])\r\n    log = log.replace(\'LOGNAME\',logname)\r\n    \r\n    file0 = _v.myTables + _v.slash+\'applogs\'+_v.slash + log\r\n\r\n    if indentCode:\r\n        dataDump = simplejson.dumps(rows, indent=4, sort_keys=True)\r\n    else:\r\n        dataDump = simplejson.dumps(rows)\r\n    f = open(file0,\'w\')\r\n    f.write(str(dataDump))\r\n    f.close()\r\n    HD.chmod(file0)\r\n    if printThis:\r\n        print_(\'Saved: \' + file0)\r\n\r\ndef saveTable( rows, theFile, tableTemp=False, printThis=True, indentCode=True, sort_keys=False, archive=False,                k=0,s=0,tmp=None,here=None,h=None,    p=1, me=0   ):\r\n    HD.chmod(theFile)\r\n    simplejson = __.imp(\'simplejson\')\r\n    if not h is None: here = True;\r\n    if not here is None: saveTable2( rows, theFile ); return None;\r\n    if not tmp is None: tableTemp = True;\r\n    if k or s: sort_keys = True;\r\n    if not p: printThis = False;\r\n        \r\n\r\n       \r\n\r\n\r\n    # defaults to myTables\r\n    px = \'\'\r\n    if theFile.startswith(\'temp\'+_v.slash):\r\n        theFile = theFile.replace( \'temp\'+_v.slash, \'\' )\r\n        file0 = _v.stmp + _v.slash + theFile\r\n        px = file0\r\n    else:\r\n        if not tableTemp:\r\n            file0 = _v.myTables + _v.slash + theFile\r\n            px = theFile\r\n        else:\r\n            file0 = _v.stmp + _v.slash + theFile\r\n            px = file0\r\n\r\n    if __.print_path:\r\n        print_(file0)\r\n    if indentCode:\r\n        dataDump = simplejson.dumps(rows, indent=4, sort_keys=sort_keys)\r\n    else:\r\n        dataDump = simplejson.dumps(rows)\r\n    \r\n    if archive:\r\n        import _rightThumb._md5 as _md5\r\n\r\n        theFileLabel = theFile\r\n        if _v.slash in theFileLabel:\r\n            global appInfo\r\n            tfl = theFileLabel.split(_v.slash)\r\n            tfl.reverse()\r\n            theFileLabel = str(appInfo[__.appReg][\'liveAppName\']) + \'__\' + tfl[0]\r\n        theFileLabel = theFileLabel.replace( \'.json\', \'\' )\r\n        theFileLabel = theFileLabel.replace( \'.JSON\', \'\' )\r\n\r\n        lastMD5 = None\r\n        if os.path.isfile( file0 ):\r\n            lastMD5 = _md5.md5File( file0 )\r\n\r\n            backupFile = _v.stmp + _v.slash+\'__archive_temp__\' + theFileLabel + \'__\' + genUUID() + \'.json\'\r\n            \r\n\r\n    f = open(file0,\'w\')\r\n    f.write(str(dataDump))\r\n    f.close()\r\n    HD.chmod(theFile)\r\n\r\n    if archive:\r\n        shouldDocument = False\r\n\r\n        if os.path.isfile( file0 ):\r\n            thisMD5 = _md5.md5File( file0 )\r\n        if lastMD5 is None:\r\n            shouldDocument = True\r\n        else:\r\n            if not lastMD5 == thisMD5:\r\n                shouldDocument = True\r\n\r\n        if not shouldDocument:\r\n            if os.path.isfile( backupFile ):\r\n                os.remove( backupFile )\r\n        \r\n        if shouldDocument:\r\n            md5Table = getTable( \'table_archive_log.json\' )\r\n            found = False\r\n            for i,record in enumerate(md5Table):\r\n                if theFileLabel == record[\'name\']:\r\n                    found = True\r\n\r\n            theFileLabel\r\n            theFile\r\n            fileDate( theData )\r\n\r\n\r\n    if printThis:\r\n        printBold(\'Saved: \' + px, \'blue\')\r\n    if me and theFile in vv.opened_file_me: changeM( theFile, vv.opened_file_me[theFile] );\r\n    return file0\r\n\r\n\r\ndef getTable( theFile, tableTemp=False,      isDic=None, isList=None,      tmp=None ):\r\n    if os.path.isfile(theFile): vv.opened_file_me[theFile] = os.path.getmtime( theFile );\r\n    simplejson = __.imp(\'simplejson\')\r\n    # defaults to myTables\r\n    if not type( tableTemp ) == bool:\r\n        if tableTemp == \'split\':\r\n            file0 = _v.myTables + _v.slash+\'tablesets\'+_v.slash + theFile\r\n    else:\r\n        if tableTemp == True:\r\n            file0 = _v.stmp + _v.slash + theFile\r\n        else:\r\n            file0 = _v.myTables + _v.slash + theFile\r\n\r\n\r\n    if not os.path.isfile(file0):\r\n        file0 = theFile\r\n    if os.path.isfile(file0):\r\n        # print_( \'theFile\', theFile )\r\n        # print_( \'file0\', file0 )\r\n        # import bigjson\r\n        with open(file0,\'r\', encoding="latin-1") as json_file:\r\n            json_data = simplejson.load(json_file)\r\n        return json_data\r\n        # with open( file0, \'rb\' ) as f:\r\n            # json_data = bigjson.load(f)\r\n            # json_data = bigjson.load(json_file)\r\n            # json_data = simplejson.load(json_file, object_pairs_hook=OrderedDict)\r\n    else:\r\n        return __.data_default(file=theFile,default=[]).default()\r\n\r\ndef getTable3(theFile):\r\n    if os.path.isfile(theFile): vv.opened_file_me[theFile] = os.path.getmtime( theFile );\r\n    simplejson = __.imp(\'simplejson\')\r\n    if os.path.isfile(theFile) == True:\r\n        with open(theFile,\'r\') as json_file:\r\n            json_data = simplejson.load(json_file)\r\n            # json_data = simplejson.load(json_file, object_pairs_hook=OrderedDict)\r\n        return json_data\r\n    return __.data_default(file=theFile,default=[]).default()\r\n\r\ndef getTable2( theFile,     isDic=None, isList=None ):\r\n    if os.path.isfile(theFile): vv.opened_file_me[theFile] = os.path.getmtime( theFile );\r\n    simplejson = __.imp(\'simplejson\')\r\n    if theFile.lower().endswith(\'.index\') or theFile.lower().endswith(\'.indexes\'):\r\n        isDic = True\r\n    if os.path.isfile(theFile):\r\n        with open(theFile,\'r\', encoding="latin-1") as json_file:\r\n            json_data = simplejson.load(json_file)\r\n            # json_data = simplejson.load(json_file, object_pairs_hook=OrderedDict)\r\n        return json_data\r\n    else:\r\n        return __.data_default(file=theFile,default=[]).default()\r\n\r\ndef getTableBIG( theFile,     isDic=None, isList=None ):\r\n    if os.path.isfile(theFile): vv.opened_file_me[theFile] = os.path.getmtime( theFile );\r\n    simplejson = __.imp(\'simplejson\')\r\n    import pandas as pd\r\n    if theFile.lower().endswith(\'.index\') or theFile.lower().endswith(\'.indexes\'):\r\n        isDic = True\r\n    if os.path.isfile(theFile):\r\n        # https://pandas.pydata.org/docs/reference/api/pandas.DataFrame.to_dict.html\r\n        df = pd.read_json(theFile)\r\n        try:\r\n            json_data = df.to_dict(\'series\')\r\n        except Exception as e:\r\n            try:\r\n                json_data = df.to_dict(\'records\')\r\n            except Exception as e:\r\n                raise e\r\n\r\n        # with open(theFile) as f:\r\n        #   json_data = pd.DataFrame(simplejson.loads(line) for line in f)\r\n\r\n        # with open(theFile,\'r\', encoding="latin-1") as json_file:\r\n        #   json_data = simplejson.load(json_file)\r\n            # json_data = simplejson.load(json_file, object_pairs_hook=OrderedDict)\r\n        return json_data\r\n    else:\r\n        return __.data_default(file=theFile,default=[]).default()\r\n\r\n_tar = None\r\ndef getTableDB( theFile,     isDic=None, isList=None ):\r\n    if os.path.isfile(theFile): vv.opened_file_me[theFile] = os.path.getmtime( theFile );\r\n    simplejson = __.imp(\'simplejson\')\r\n    theFile = _v.dbTables + _v.slash + theFile\r\n    if os.path.isfile(theFile):\r\n        if isTar.bz2(theFile) or isTar.gz(theFile):\r\n            global _tar\r\n            if _tar is None:\r\n                import _rightThumb._tar as _tar\r\n                _tar.unzip( theFile )\r\n\r\n\r\n        with open(theFile,\'r\', encoding="latin-1") as json_file:\r\n            json_data = simplejson.load(json_file)\r\n            # json_data = simplejson.load(json_file, object_pairs_hook=OrderedDict)\r\n        return json_data\r\n    else:\r\n        return __.data_default(file=theFile,default=[]).default()\r\n\r\n\r\ndef getTableProject( project, theFile,     isDic=None, isList=None, path=False ):\r\n    if os.path.isfile(theFile): vv.opened_file_me[theFile] = os.path.getmtime( theFile );\r\n    simplejson = __.imp(\'simplejson\')\r\n    theFile = _v.projectData(project) + theFile\r\n    if path:\r\n        print_(theFile)\r\n        return None\r\n    # print_(theFile)\r\n    # print_(theFile)\r\n    # print_(theFile)\r\n    # print_(theFile)\r\n    if os.path.isfile(theFile) == True:\r\n        with open(theFile,\'r\', encoding="latin-1") as json_file:\r\n            json_data = simplejson.load(json_file)\r\n            # json_data = simplejson.load(json_file, object_pairs_hook=OrderedDict)\r\n        return json_data\r\n    else:\r\n        return __.data_default(file=theFile,default=[]).default()\r\n\r\n\r\ndef saveTableProject( project, rows=[], theFile=\'\', printThis=False, sort_keys=False, indentCode=True,  p=None, me=0, path=False ):\r\n    HD.chmod(theFile)\r\n    simplejson = __.imp(\'simplejson\')\r\n    # print_(\'*******************\',theFile)\r\n    theFile = _v.projectData(project) + theFile\r\n    if __.print_path:\r\n        print_(theFile)\r\n    if path:\r\n        print_(theFile)\r\n        return None\r\n    if indentCode:\r\n        dataDump = simplejson.dumps(rows, indent=4, sort_keys=sort_keys)\r\n    else:\r\n        dataDump = simplejson.dumps(rows)\r\n\r\n    # dataDump = simplejson.dumps(rows, indent=4, sort_keys=sort_keys)\r\n    f = open(theFile,\'w\')\r\n    f.write(str(dataDump))\r\n    f.close()\r\n    HD.chmod(theFile)\r\n    if printThis:\r\n        print_(\'Saved: \' + theFile)\r\n    if me and theFile in vv.opened_file_me: changeM( theFile, vv.opened_file_me[theFile] );\r\n\r\ndef saveTableDB( rows, theFile, printThis=False, sort_keys=False, indentCode=True,  p=None, me=0 ):\r\n    HD.chmod(theFile)\r\n    simplejson = __.imp(\'simplejson\')\r\n\r\n    # print_(\'*******************\',theFile)\r\n    theFile = _v.dbTables + _v.slash + theFile\r\n    if __.print_path:\r\n        print_(theFile)\r\n    if indentCode:\r\n        dataDump = simplejson.dumps(rows, indent=4, sort_keys=sort_keys)\r\n    else:\r\n        dataDump = simplejson.dumps(rows)\r\n\r\n    # dataDump = simplejson.dumps(rows, indent=4, sort_keys=sort_keys)\r\n    f = open(theFile,\'w\')\r\n    f.write(str(dataDump))\r\n    f.close()\r\n    HD.chmod(theFile)\r\n    if printThis:\r\n        print_(\'Saved: \' + theFile)\r\n    if me and theFile in vv.opened_file_me: changeM( theFile, vv.opened_file_me[theFile] );\r\n\r\n\r\ndef saveTable2( rows, theFile, printThis=False, sort_keys=False, indentCode=True, p=None, me=0 ):\r\n    HD.chmod(theFile)\r\n    simplejson = __.imp(\'simplejson\')\r\n    if not p is None:\r\n        printThis = p\r\n    # print_(\'*******************\',theFile)\r\n    if theFile.startswith(\'temp\'+_v.slash):\r\n        theFile = theFile.replace( \'temp\'+_v.slash, \'\' )\r\n        theFile = _v.stmp + _v.slash + theFile\r\n\r\n    if indentCode:\r\n        dataDump = simplejson.dumps(rows, indent=4, sort_keys=sort_keys)\r\n    else:\r\n        dataDump = simplejson.dumps(rows)\r\n\r\n    # dataDump = simplejson.dumps(rows, indent=4, sort_keys=sort_keys)\r\n    f = open(theFile,\'w\')\r\n    f.write(str(dataDump))\r\n    f.close()\r\n    HD.chmod(theFile)\r\n    if printThis:\r\n        print_(\'Saved: \' + theFile)\r\n    if me and theFile in vv.opened_file_me: changeM( theFile, vv.opened_file_me[theFile] );\r\n\r\ndef saveTable3( rows, theFile, printThis=False, me=0 ):\r\n    HD.chmod(theFile)\r\n    simplejson = __.imp(\'simplejson\')\r\n    # print_(\'*******************\',theFile)\r\n    dataDump = simplejson.dumps(rows)\r\n    f = open(theFile,\'w\')\r\n    f.write(str(dataDump))\r\n    f.close()\r\n    HD.chmod(theFile)\r\n    if printThis:\r\n        print_(\'Saved: \' + theFile)\r\n    if me and theFile in vv.opened_file_me: changeM( theFile, vv.opened_file_me[theFile] );\r\n\r\n\r\ndef tempFile(rows,theFile):\r\n    file0 = _v.stmp + _v.slash + theFile\r\n    file = open(file0,\'w\')\r\n    for r in rows:\r\n        if not \'\\n\' in r:\r\n            file.write(r+\'\\n\')\r\n        else:\r\n            file.write(r)\r\n    file.close()\r\n\r\ndef stamp2Date(ts):\r\n    # print_(ts)\r\n    # print_(datetime.datetime.fromtimestamp(int(ts) / 1e3))\r\n    return datetime.datetime.fromtimestamp(int(ts) / 1e3)\r\ndef float2Date(ts):\r\n    import _rightThumb._date as _date\r\n    auto = _date.autoDate( ts )\r\n    if type(ts) == str:\r\n        ts = ts.replace(\'_\',\'.\')\r\n        if \'.\' in ts:\r\n            ts = float(ts)\r\n        else:\r\n            ts = int(ts)\r\n        # print_(type(ts))\r\n        # print_( stamp2Date(ts) )\r\n    return stamp2Date(ts)\r\ndef float2Date2(ts):\r\n    if type(ts) == str:\r\n        ts = ts.replace(\'_\',\'.\')\r\n        if \'.\' in ts:\r\n            ts = float(ts)\r\n        else:\r\n            ts = int(ts)\r\n        # print_(type(ts))\r\n    return str(datetime.datetime.fromtimestamp(ts)).split(\'.\')[0]\r\n    # return str(datetime.datetime.fromtimestamp(ts / 1e3))\r\n    # return str(ts)\r\n    # return str(datetime.datetime.fromtimestamp(ts)).split(\'.\')[0] + \'\\t\' + str(ts)\r\n    # return str(ts).split(\'.\')[0] + \'\\t\' + str(datetime.datetime.fromtimestamp(ts)).split(\'.\')[0]\r\ndef float2Date3(ts):\r\n    return str(datetime.datetime.fromtimestamp(float(ts)).strftime(\'%Y-%m-%d %H:%M:%S\'))\r\ndef float2Date3B(ts,isJson = True):\r\n    stmp = float2Date3(ts)\r\n    dtx = stmp.split(\' \')[0]\r\n    preResult = {\'year\': dtx.split(\'-\')[0],\'month\': dtx.split(\'-\')[1],\'day\': dtx.split(\'-\')[2]}\r\n    if isJson:\r\n        result = preResult\r\n    else:\r\n        result = str(preResult[\'year\']) + \'-\' + str(preResult[\'month\']) + \'-\' + str(preResult[\'day\'])\r\n\r\n    return result\r\n\r\ndef expireCheck(theDate,delim):\r\n    now = datetime.datetime.now()\r\n    today = now.strftime("%Y-%m-%d")\r\n    fdtl = theDate.split(delim)\r\n    foundDate = datetime.date(int(fdtl[0]), int(fdtl[1]), int(fdtl[2]))\r\n    td = str(today).split(\'-\')\r\n    tdd = datetime.date(int(td[0]), int(td[1]), int(td[2]))\r\n    diff = tdd - foundDate\r\n    return int(diff.days)\r\n\r\ndef dateDiff( theDate0, theDate1, delim=\'-\' ):\r\n    theDate0 = str(theDate0)\r\n    theDate1 = str(theDate1)\r\n\r\n\r\n    if not delim in theDate0:\r\n        try:\r\n            theDate0 = resolveEpochTest( theDate0, onlyEpoch=\'day\', delim=delim )\r\n            if type(theDate0) == bool:\r\n                printBold( \'Error: _.dateDiff \'+ str(theDate0), \'red\' )\r\n                sys.exit()\r\n        except Exception as e:\r\n            printBold( \'Error: _.dateDiff \'+ str(theDate0), \'red\' )\r\n            sys.exit()\r\n\r\n\r\n    if not delim in theDate1:\r\n        try:\r\n            theDate1 = resolveEpochTest( theDate1, onlyEpoch=\'day\', delim=delim )\r\n            if type(theDate1) == bool:\r\n                printBold( \'Error: _.dateDiff \'+ str(theDate1), \'red\' )\r\n                sys.exit()\r\n        except Exception as e:\r\n            printBold( \'Error: _.dateDiff \'+ str(theDate1), \'red\' )\r\n            sys.exit()\r\n\r\n    # print_(theDate0,theDate1,delim)\r\n    # sys.exit()\r\n    fdtl0 = theDate0.split(delim)\r\n    date0 = datetime.date(int(fdtl0[0]), int(fdtl0[1]), int(fdtl0[2]))\r\n\r\n    fdtl1 = theDate1.split(delim)\r\n    date1 = datetime.date(int(fdtl1[0]), int(fdtl1[1]), int(fdtl1[2]))\r\n\r\n    diff = date1 - date0\r\n    return (int(diff.days))\r\n    \r\ndef dateDiffX( theDate0, theDate1, delim=\'-\' ):\r\n    theDate0 = str(theDate0)\r\n    theDate1 = str(theDate1)\r\n\r\n\r\n    if not delim in theDate0:\r\n        theDate0 = resolveEpochTest( theDate0, onlyEpoch=\'day\', delim=delim )\r\n\r\n\r\n\r\n    if not delim in theDate1:\r\n        theDate1 = resolveEpochTest( theDate1, onlyEpoch=\'day\', delim=delim )\r\n\r\n\r\n\r\n    # print_(theDate0,theDate1,delim)\r\n    # sys.exit()\r\n    fdtl0 = theDate0.split(delim)\r\n    date0 = datetime.date(int(fdtl0[0]), int(fdtl0[1]), int(fdtl0[2]))\r\n\r\n    fdtl1 = theDate1.split(delim)\r\n    date1 = datetime.date(int(fdtl1[0]), int(fdtl1[1]), int(fdtl1[2]))\r\n\r\n    diff = date1 - date0\r\n    return (int(diff.days))\r\n\r\ndef dateAdd(theDate,delim,addDays):\r\n    fdtl0 = theDate.split(delim)\r\n    date0 = datetime.date(int(fdtl0[0]), int(fdtl0[1]), int(fdtl0[2]))\r\n    return date0 + datetime.timedelta(days=addDays)\r\n\r\ndef dateSub(theDate,delim,addDays):\r\n    fdtl0 = theDate.split(delim)\r\n    date0 = datetime.date(int(fdtl0[0]), int(fdtl0[1]), int(fdtl0[2]))\r\n    return date0 - datetime.timedelta(days=addDays)\r\n\r\ndef listAverage(theList):\r\n    total = 0\r\n    for item in theList:\r\n        total += item\r\n    try:\r\n        result =  total / len(theList)\r\n    except Exception as e:\r\n        result = 0\r\n    return result \r\ndef date2epoch(theDate,delim=\'-\'):\r\n    theDate = str(theDate)\r\n    if len( theDate ) == 0:\r\n        return \'\'\r\n    theDate = theDate.replace(delim,\'-\')\r\n    fdtl = theDate.split(\' \')[0].split(\'-\')\r\n    if \':\' in theDate:\r\n        theDate = theDate.replace(\'.\',\':\')\r\n        if theDate.count(\':\') == 2:\r\n            stmp = dt.strptime(theDate, \'%Y-%m-%d %H:%M:%S\')\r\n        elif theDate.count(\':\') == 1:\r\n            stmp = dt.strptime(theDate, \'%Y-%m-%d %H:%M\')\r\n        elif theDate.count(\':\') == 3:\r\n            stmp = dt.strptime(theDate, \'%Y-%m-%d %H:%M:%S:%f\')\r\n        else:\r\n            print_(\'Error: date2epoch\')\r\n            sys.exit()\r\n\r\n    else:\r\n        stmp = datetime.date(int(fdtl[0]), int(fdtl[1]), int(fdtl[2]))\r\n    # stmp = datetime.datetime.strptime(theDate, \'%Y-%m-%d\')\r\n    return float(time.mktime(stmp.timetuple()))\r\n\r\ndef validateEmail(data):\r\n    data = _str.removeAll(data,\' \')\r\n    data = _str.totalStrip(data)\r\n    good = True\r\n    # if not \'@\' in data:\r\n    if not data.count(\'@\') == 1:\r\n        good = False\r\n    if good:\r\n        if not \'.\' in data.split(\'@\')[1]:\r\n            good = False\r\n    # if data.count(\'@\') == 1:\r\n    if not good and len(data) > 0:\r\n        data = \' ___________ * BAD * ___________\'\r\n    return data\r\n\r\ndef figureOutDate(theDate, theFormat):\r\n    theFormat = str(theFormat)\r\n    theFormat = _str.replaceDuplicate(theFormat,\' \')\r\n    theFormat = _str.cleanBE(theFormat,\' \')\r\n    theFormat = theFormat.lower()\r\n\r\n    theFormatExp = \'dmy\'\r\n    if not len(theFormat) == 3:\r\n        print_(\'format error, expected: dmy, ymd\')\r\n        sys.exit()\r\n    if theFormat[0] in theFormatExp and theFormat[1] in theFormatExp and theFormat[2] in theFormatExp:\r\n        pass\r\n    else:\r\n        print_(\'format error, expected: dmy, ymd\')\r\n        sys.exit()\r\n    # theFormat = \'dmy\'\r\n    theDate = str(theDate)\r\n    theDate = _str.replaceDuplicate(theDate,\' \')\r\n    theDate = _str.cleanBE(theDate,\' \')\r\n\r\n    \r\n    n = \'0123456789\'\r\n    a = \'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\'\r\n    \r\n    autoDelim = \'\'\r\n    for d in theDate:\r\n        if d in n:\r\n            pass\r\n        elif d in a:\r\n            pass\r\n        else:\r\n            autoDelim = d\r\n            break\r\n\r\n    theDateDe = theDate.split(autoDelim)\r\n    info = {}\r\n\r\n    info[theFormat[0]] = theDateDe[0]\r\n    info[theFormat[1]] = theDateDe[1]\r\n    info[theFormat[2]] = theDateDe[2]\r\n    if info[\'m\'][0] in a:\r\n        m = info[\'m\']\r\n        m = m.lower()\r\n        found = False\r\n        for monththeDate in getMonthData():\r\n            # print_(monththeDate)\r\n            # sys.exit()\r\n            full = monththeDate[\'month\']\r\n            abbrev = monththeDate[\'abbrev\']\r\n            mNumber = monththeDate[\'number\']\r\n            full = full.lower()\r\n            abbrev = abbrev.lower()\r\n            if m == full or m == abbrev:\r\n                found = True\r\n                info[\'m\'] = mNumber\r\n        if not found:\r\n            ans = input(\'What Month? \')\r\n            if len(ans) == 0:\r\n                print_(\'Month error\')\r\n                sys.exit()\r\n            try:\r\n                int(ans)\r\n            except Exception as e:\r\n                printBold(\'Month error\',\'red\')\r\n                sys.exit()\r\n            if len(ans) == 1:\r\n                 info[\'m\'] = 0 + ans\r\n            elif len(ans) == 2:\r\n                 info[\'m\'] = ans\r\n            else:\r\n                printBold(\'Month error\',\'red\')\r\n                sys.exit()\r\n\r\n    ifoy = info[\'y\']\r\n    ifom = info[\'m\']\r\n    ifod = info[\'d\']\r\n    pResult = info[\'y\'] + \'-\' + info[\'m\'] + \'-\' + info[\'d\']\r\n    hasDup = False\r\n    if pResult.count(ifoy) > 1:\r\n        hasDup = True\r\n    if pResult.count(ifom) > 1:\r\n        hasDup = True\r\n    if pResult.count(ifod) > 1:\r\n        hasDup = True\r\n\r\n\r\n    changed = []\r\n    def test(l):\r\n        result = \'\'\r\n        if int(l) > 1000:\r\n            result = \'y\'\r\n        elif int(l) > 12:\r\n            result = \'d\'\r\n        return result\r\n    fList = \'\'\r\n    if test(ifom) == \'y\':\r\n        fList += \'y\'\r\n        info[\'y\'] = ifom\r\n        # info[\'m\'] = ifoy\r\n    if test(ifod) == \'y\':\r\n        fList += \'y\'\r\n        info[\'y\'] = ifod\r\n        # info[\'d\'] = ifoy\r\n    if test(ifod) == \'d\':\r\n        fList += \'d\'\r\n    if test(ifoy) == \'d\':\r\n        fList += \'d\'\r\n        info[\'d\'] = ifoy\r\n    if test(ifom) == \'d\':\r\n        fList += \'d\'\r\n        info[\'d\'] = ifom\r\n    if test(ifoy) == \'\' and \'d\' in fList:\r\n        fList += \'m\'\r\n        info[\'m\'] = ifoy\r\n    if test(ifoy) == \'\' and \'d\' in fList:\r\n        fList += \'m\'\r\n        info[\'m\'] = ifoy\r\n    if test(ifoy) == \'d\':\r\n        fList += \'d\'\r\n        info[\'d\'] = ifoy\r\n    if test(ifod) == \'\' and \'d\' in fList:\r\n        info[\'m\'] = ifod\r\n    # print_(test(ifoy))\r\n    # print_(fList)\r\n\r\n    result = info[\'y\'] + \'-\' + info[\'m\'] + \'-\' + info[\'d\']\r\n    # print_(result)\r\n    if not hasDup:\r\n        hasDup = False\r\n        if result.count(ifoy) > 1:\r\n            hasDup = True\r\n        if result.count(ifom) > 1:\r\n            hasDup = True\r\n        if result.count(ifod) > 1:\r\n            hasDup = True\r\n        if hasDup:\r\n            print_(\'Error please specify format: ymd\')\r\n            sys.exit()\r\n    else:\r\n        if result.count(info[\'y\']) > 1:\r\n            print_(\'Error please specify format: ymd\')\r\n            sys.exit()\r\n\r\n    print_(result)\r\n    sys.exit()\r\n    return result\r\n\r\n\r\n\r\ndef getMonthData():\r\n    monthData = getText(_v.myTables + _v.slash+\'month.txt\')\r\n    monthList = []\r\n    for md in monthData:\r\n        md = md.replace(\'\\n\',\'\')\r\n        mds = md.split(\',\')\r\n        monthList.append({\'month\': mds[0], \'abbrev\': mds[1], \'number\': mds[2]})\r\n    return monthList\r\n\r\n\r\n\r\ndef formatPhone00(data):\r\n    data = _str.removeAll(data,\' \')\r\n    data = _str.totalStrip4(data)\r\n    data = _str.cleanBE(data,\'.\')\r\n    return data\r\n\r\ndef formatPhone0(data):\r\n    data = _str.removeAll(data,\' \')\r\n    data = _str.totalStrip4(data)\r\n\r\n    newData = \'(\' + data[0] + data[1] + data[2] + \') \' + data[3] + data[4] + data[5] + \'-\' + data[6] + data[7] + data[8] + data[9]\r\n    if not len(data) == 10:\r\n        newData = \'generic error\'\r\n    if len(data) == 0:\r\n        newData = \'\'\r\n    return newData\r\n\r\ndef formatPhone1(data):\r\n    data = _str.removeAll(data,\' \')\r\n    data = _str.totalStrip4(data)\r\n\r\n    newData = data[0] + data[1] + data[2] + \'-\' + data[3] + data[4] + data[5] + \'-\' + data[6] + data[7] + data[8] + data[9]\r\n    if not len(data) == 10:\r\n        newData = \'generic error\'\r\n    if len(data) == 0:\r\n        newData = \'\'\r\n    return newData\r\n\r\ndef formatPhone2(data):\r\n    data = _str.removeAll(data,\' \')\r\n    data = _str.totalStrip4(data)\r\n\r\n    newData = data[0] + data[1] + data[2] + \'.\' + data[3] + data[4] + data[5] + \'.\' + data[6] + data[7] + data[8] + data[9]\r\n    if not len(data) == 10:\r\n        newData = \'generic error\'\r\n    if len(data) == 0:\r\n        newData = \'\'\r\n    return newData\r\n\r\nupdateLine_disable = False\r\n\r\n\r\ndef updateLine( string, clear=True, color=None, sleep=None ):\r\n    global updateLine_disable\r\n    if updateLine_disable:\r\n        clear = False\r\n    if type(string) == list:\r\n        for i,s in enumerate(string):\r\n            string[i]=str(s)\r\n        string = \' \'.join(string)\r\n    a=None\r\n    b=None\r\n    c=None\r\n    if type(clear) == str:\r\n        b = clear\r\n    if type(color) == bool:\r\n        a = color\r\n    if type(clear) == int or type(clear) == float:\r\n        c = clear\r\n    if type(color) == int or type(color) == float:\r\n        c = color\r\n\r\n    if not a is None:\r\n        clear = a\r\n    if not b is None:\r\n        color = b\r\n    if not c is None:\r\n        sleep = c\r\n\r\n\r\n    if type(color) == str:\r\n        string = cp( string, color, p=0 )\r\n\r\n    if clear:\r\n        txt = linePrint(txt=\' \',p=0)\r\n        updateLine(txt,clear=False)\r\n\r\n\r\n    if updateLine_disable:\r\n        print_(string)\r\n    else:\r\n        print_(\'{}\\r\'.format(string), end="")\r\n\r\n\r\n    if not sleep is None:\r\n        time.sleep(sleep)\r\n\r\n\r\n\r\n\r\ndef getLastTableSplit(theFile,tableTemp = \'split\'):\r\n    if os.path.isfile(theFile): vv.opened_file_me[theFile] = os.path.getmtime( theFile );\r\n    if tableTemp == \'split\':\r\n        basePath = _v.myTables + _v.slash+\'tablesets\'\r\n    else:\r\n        basePath = _v.stmp\r\n    # print_(basePath)\r\n    dirList = os.listdir(basePath)\r\n    fileList = []\r\n    for d in dirList:\r\n        if d.startswith(theFile):\r\n            fileList.append(d)\r\n    # print_(fileList)\r\n    fileList.sort()\r\n    # print_(fileList)\r\n    # print_()\r\n    # print_(fileList[len(fileList)-1])\r\n    # print_(fileList)\r\n    # file0 = basePath + _v.slash + fileList[len(fileList)-1]\r\n    # print_(file0)\r\n    return getTable(fileList[len(fileList)-1],tableTemp)\r\n\r\ndef saveTableSplitNew( rows,theFile,tableTemp = True,printThis = True, project=False, me=0 ):\r\n    HD.chmod(theFile)\r\n    # defaults to myTables\r\n    print_( \'save size:\', len(rows))\r\n    if tableTemp:\r\n        file0 = _v.myTables + _v.slash+\'tablesets\' + _v.slash + theFile\r\n    elif project:\r\n        file0 = _v.myTables + _v.slash+\'projects\' + _v.slash + theFile\r\n\r\n    else:\r\n        file0 = _v.stmp + _v.slash + theFile\r\n\r\n    def count(cnt):\r\n        char = 6\r\n        cnt = str(cnt)\r\n        lencnt = len(cnt)\r\n        if lencnt == 1:\r\n            cnt = \'00000\' + cnt\r\n        if lencnt == 2:\r\n            cnt = \'0000\' + cnt\r\n        if lencnt == 3:\r\n            cnt = \'000\' + cnt\r\n        if lencnt == 4:\r\n            cnt = \'00\' + cnt\r\n        if lencnt == 5:\r\n            cnt = \'0\' + cnt\r\n        cnt = \'_\' + cnt\r\n        return cnt\r\n\r\n    suffix = \'.json\'\r\n    cnt = 0\r\n    path = file0 + count(cnt) + suffix\r\n    while os.path.isfile(path) == True:\r\n        cnt += 1\r\n        path = file0 + count(cnt) + suffix\r\n    simplejson = __.imp(\'simplejson\')\r\n    dataDump = simplejson.dumps(rows, indent=4, sort_keys=True)\r\n    f = open(path,\'w\')\r\n    f.write(str(dataDump))\r\n    f.close()\r\n    HD.chmod(path)\r\n    if printThis:\r\n        print_(\'Saved: \' + path)\r\n    if me and theFile in vv.opened_file_me: changeM( theFile, vv.opened_file_me[theFile] );\r\n\r\ndef sort(rows, name):\r\n    global errors\r\n    tempFields = []\r\n    sortBy = {}\r\n    name = name.replace(\'.\',\':\')\r\n    sortList = name.split(\',\')\r\n    sortList.reverse()\r\n\r\n    ### Check for bad sort input\r\n    for item in sortList:\r\n        item = item\r\n        try:\r\n            if item.count(\':\') > 0:\r\n                sb = item.split(\':\')[1]\r\n            else:\r\n                sb = item\r\n        except Exception as e:\r\n            errors.append({\'id\': 16, \'function\': \'sortThis()\', \'cnt\': 1, \'location\': \'rows[0][sb]\', \'vars\': [{\'name\': \'rows\', \'value\': \'nope to that, to big\'}, {\'name\': \'name\', \'value\': name}], \'error\': e})\r\n\r\n\r\n    # itemgetter = __.imp(\'operator.itemgetter\')\r\n    for item in sortList:\r\n        try:\r\n            direction = item.split(\':\')[0]\r\n            sb = item.split(\':\')[1]\r\n            if direction == \'asc\':\r\n            # if direction.find(\'a\') == 0:\r\n                rows = sorted(rows, key=itemgetter(sb))\r\n            else:\r\n                rows = sorted(rows, key=itemgetter(sb), reverse=True)\r\n        except Exception as e:\r\n            try:\r\n                pass\r\n                rows = sorted(rows, key=itemgetter(item))\r\n            except Exception as e:\r\n                errors.append({\'id\': 17, \'function\': \'sortThis()\', \'cnt\': 2, \'location\': \'rows = sorted(rows, key=itemgetter(sb))\', \'vars\': [{\'name\': \'rows\', \'value\': \'nope to that, to big\'}, {\'name\': \'name\', \'value\': name}], \'error\': e})\r\n            \r\n        uuid = __.imp(\'uuid\')\r\n        sortBy[item] = str(uuid.uuid4())\r\n        tempFields.append( sortBy[item] )\r\n        i = 0\r\n        for row in rows:\r\n            rows[i][sortBy[item]] = i\r\n            i += 1\r\n\r\n    # rows = sorted(rows, key=lambda d: (-d[\'typesort\'], d[\'ext\'], d[\'name\']))\r\n\r\n    sortCode = \'rows = sorted(rows, key=lambda d: (\'\r\n    for item in sortList:\r\n        sortCode += "d[\'" + str(sortBy[item]) + "\'],"\r\n    sortCode = sortCode[:-1]\r\n    sortCode += \'))\'\r\n    exec(sortCode)\r\n    if len( tempFields ):\r\n        # print_( tempFields )\r\n        for ix,r in enumerate(rows):\r\n            for tmp in tempFields:\r\n                try:\r\n                    del rows[ix][tmp]\r\n                except Exception as e:\r\n                    pass\r\n\r\n    return rows\r\n\r\ndef blank_script_trigger(data):\r\n    return data\r\n\r\nclass Switch:\r\n\r\n    def __init__(self, name, switch, expected_input_example, description, space):\r\n        self.appReg = __.appReg\r\n        self.name = name\r\n        self.switch = switch\r\n        self.pos = 0\r\n        self.active = False\r\n        self.value = None\r\n        self.values = []\r\n        self.expected_input_example = expected_input_example\r\n        self.documentation = { \'description\': description, \'examples\': [], \'required\': [], \'related\': [] }\r\n        self.space = space\r\n        self.vs = False\r\n        self.script_trigger_alt = None\r\n        self.script=blank_script_trigger\r\n        \r\n    def trigger(self,script,vs=False,alt=None):\r\n        if not alt is None:\r\n            self.script_trigger_alt = alt\r\n            vs = True\r\n        self.vs = vs\r\n        self.script_trigger = script\r\n        self.script = script\r\n\r\n\r\n\r\nclass Switches:\r\n\r\n    def __init__(self):\r\n        self.switches = []\r\n        self.index = {}\r\n        self.appRegDefault = None\r\n        self.appReg = __.appReg\r\n        self.hasRequired = []\r\n        self.isRequired = {}\r\n        self.postScripts = []\r\n        self.dex = {}\r\n\r\n\r\n    def all( self, appReg=None, omit=None, omitDefaults=True,             od=1 ):\r\n        if not od:\r\n            omitDefaults = False\r\n        if omitDefaults:\r\n            omitList = [ \'Help\', \'Column\', \'Sort\', \'Debug\', \'Errors\', \'Timeout\', \'GroupBy\', \'ShortenColumn\', \'Long\', \'Length\', \'Report\', \'Plus\', \'Minus\', \'PlusOr\', \'PlusClose\', \'PrintAutoAbbreviations\', \'LoadEpoch\', \'NoColor\', \'Clean\', \'NoCount\', \'Count\' ]\r\n        else:\r\n            omitList = []\r\n\r\n        if not  omit is None:\r\n            if type(omit) == str:\r\n                omit = omit.replace(  \' \', \'\' )\r\n                omit = omit.split(\',\')\r\n            for x in omit:\r\n                omitList.append( x )\r\n\r\n\r\n        # appReg values expected: None, 1, true, \'all\'\r\n        if appReg is None:\r\n            appReg = __.appReg\r\n\r\n        result = []\r\n        for i,row in enumerate(self.switches):\r\n            if not row.name in omitList:\r\n                if row.active:\r\n                    shouldAdd = True\r\n                    if type( appReg ) == str:\r\n                        if not appReg == \'all\':\r\n                            if not row.appReg == appReg:\r\n                                shouldAdd = False\r\n\r\n                    if shouldAdd:\r\n                        result.append({\r\n                                            \'active\': row.active,\r\n                                            \'name\': row.name,\r\n                                            \'value\': row.value,\r\n                                            \'values\': row.values,\r\n                                            \'appReg\': row.appReg,\r\n                        })\r\n        return result\r\n\r\n\r\n\r\n    def records( self, formating=None, appReg=None ):\r\n        if formating is None:\r\n            colorThis( \'formating options:\', \'bold\' )\r\n            colorThis( [ \'\\t\', \'list\' ], \'yellow\' )\r\n            colorThis( [ \'\\t\', \'dic_a-v\', \'\\t\', "{ \'isActive\': {}, \'values\': {} }" ], \'yellow\' )\r\n            colorThis( [ \'\\t\', \'dic_on-off-v\', \'\\t\', "{ \'on\': [], \'off\': [], \'values\': {} }" ], \'yellow\' )\r\n            colorThis( [ \'\\t\', \'dump\' ], \'yellow\' )\r\n            sys.exit()\r\n\r\n            colorThis(  )\r\n        if appReg is None:\r\n            appReg = __.appReg\r\n\r\n\r\n        records = {\r\n                        \'list\': [],\r\n                        \'dic_a-v\': { \'active\': self.active(), \'isActive\': {}, \'values\': {} },\r\n                        \'dic_on-off-v\': { \'on\': [], \'off\': [], \'values\': {} },\r\n                        \'dump\': [],\r\n        }\r\n\r\n\r\n        for i,switch in enumerate(self.switches):\r\n\r\n            if self.switches[i].appReg == appReg:\r\n                records[\'list\'].append({ \'name\': switch.name, \'values\': switch.values })\r\n\r\n\r\n                records[\'dic_a-v\'][\'isActive\'][switch.name] = switch.active\r\n                records[\'dic_a-v\'][\'values\'][switch.name] = switch.values\r\n\r\n\r\n                records[\'dump\'] = dict((name, getattr(switch, name)) for name in dir(switch) if not name.startswith(\'__\'))\r\n\r\n\r\n                records[\'dic_on-off-v\'][\'values\'][switch.name] = switch.values\r\n                if switch.active:\r\n                    records[\'dic_on-off-v\'][\'on\'].append( switch.name )\r\n                else:\r\n                    records[\'dic_on-off-v\'][\'off\'].append( switch.name )\r\n\r\n        return records[ formating ]\r\n    def documentation( self, name, data ):\r\n        result = False\r\n        try:\r\n            for i,row in enumerate(self.switches):\r\n                if row.name == name:\r\n                    # print_( \'SET\' )\r\n                    if self.switches[i].appReg == __.appReg:\r\n\r\n                        try:\r\n                            if len( data[\'description\'] ):\r\n                                self.switches[i].documentation[\'description\'] = data[\'description\']\r\n                        except Exception as e:\r\n                            pass\r\n\r\n                        try:\r\n                            if len( data[\'examples\'] ):\r\n                                self.switches[i].documentation[\'examples\'] = data[\'examples\']\r\n                        except Exception as e:\r\n                            pass\r\n\r\n                        try:\r\n                            if len( data[\'required\'] ):\r\n                                self.switches[i].documentation[\'required\'] = []\r\n                                self.switches[i].documentation[\'related\'] = []\r\n                                for record in data[\'required\']:\r\n                                    if record == \'Pipe\':\r\n                                        __.isRequired_Pipe = True\r\n                                    else:\r\n                                        self.switches[i].documentation[\'required\'].append( record )\r\n                                        self.switches[i].documentation[\'related\'].append( record )\r\n                                        if not name in self.hasRequired:\r\n                                            self.hasRequired.append( name )\r\n                                \r\n\r\n                        except Exception as e:\r\n                            pass\r\n\r\n                        try:\r\n                            if len( data[\'related\'] ):\r\n                                for record in data[\'related\']:\r\n                                    self.switches[i].documentation[\'related\'].append( record )\r\n                        except Exception as e:\r\n                            pass\r\n\r\n                        try:\r\n                            if type( data[\'isRequired\'] ) == bool:\r\n                                if data[\'isRequired\']:\r\n                                    if not name in self.isRequired[__.appReg]:\r\n                                        self.isRequired[__.appReg].append( name )\r\n                        except Exception as e:\r\n                            pass\r\n\r\n\r\n\r\n        except Exception as e:\r\n            result = False\r\n        return result\r\n\r\n\r\n    def record( self, name ):\r\n        result = False\r\n        try:\r\n            for i,row in enumerate(self.switches):\r\n                if self.switches[i].appReg == __.appReg:\r\n                    if row.name == name:\r\n                        return i\r\n        except Exception as e:\r\n            result = False\r\n        return result\r\n\r\n    def dumpSwitches(self,includeBlank=False):\r\n        data = []\r\n        for i,row in enumerate(self.switches):\r\n            # if not row.value is None:\r\n            if includeBlank:\r\n                data.append({ \'name\': row.name, \'value\': row.value, \'appreg\': row.appReg })\r\n            else:\r\n                if not row.value is None or row.active:\r\n                    data.append({ \'name\': row.name, \'value\': row.value, \'appreg\': row.appReg })\r\n            # print_(row.name,\'\\t\',row.value,\'\\t\',row.appReg)\r\n        tables.register(\'data\',data)\r\n        tables.print(\'data\',\'appreg,name,value\')\r\n\r\n    def register(self, name, switch, expected_input_example = None, isRequired=False, isPipe=None, isData=None, description=\'\', space=False):\r\n\r\n        if not isPipe is None:\r\n            __.trigger_isPipe = isPipe\r\n\r\n        if not isData is None:\r\n            __.trigger_isPipe = isData\r\n            isPipe=isData\r\n        i=len(self.switches)\r\n\r\n        if not __.appReg in self.dex:\r\n            self.dex[__.appReg]={}\r\n        self.dex[__.appReg][name]=i\r\n\r\n        self.switches.append(Switch(name, switch, expected_input_example, description, space))\r\n\r\n        try:\r\n            if not type(self.isRequired[__.appReg]) == list:\r\n                self.isRequired[__.appReg] = []\r\n        except Exception as e:\r\n            self.isRequired[__.appReg] = []\r\n        \r\n        \r\n\r\n        switch = switch.replace( \' \', \'\' )\r\n\r\n        \r\n        if not isPipe is None:\r\n            if type(isPipe) == bool and isPipe:\r\n                isPipe = \'data\'\r\n            v.isData[name]=isPipe\r\n\r\n            if \'name\' in isPipe and ( \'data\' in isPipe or \'clean\' in isPipe ):\r\n                pass\r\n            elif \'name\' in isPipe:\r\n                __.trigger_isPipe = \'name\'\r\n            elif \'data\' in isPipe or \'clean\' in isPipe:\r\n                if \'clean\' in isPipe:\r\n                    __.trigger_isPipe = \'data,clean\'\r\n                else:\r\n                    __.trigger_isPipe = \'data\'\r\n        elif isPipe:\r\n            __.trigger_isPipe = \'data\'\r\n\r\n        if isRequired:\r\n            __.isRequired_index[__.appReg].append( name )\r\n            if not name in self.isRequired[__.appReg]:\r\n                self.isRequired[__.appReg].append( name )\r\n\r\n\r\n\r\n    def fieldSet( self, name, column, value, theFocus=False, runTrigger=True ):\r\n        if name == \'Sort\':\r\n            if column == \'value\':\r\n                if type(value) == str:\r\n                    if value.startswith(\'a.\'):\r\n                        value = \'a:\' + value[2:]\r\n                    if \',a.\' in value:\r\n                        value = value.replace( \',a.\', \',a:\' )\r\n\r\n                    if value.startswith(\'d.\'):\r\n                        value = \'d:\' + value[2:]\r\n                    if \',d.\' in value:\r\n                        value = value.replace( \',d.\', \',d:\' )\r\n            if column == \'values\':\r\n                if type(value) == list:\r\n                    for i,asdf in enumerate(value):\r\n                        if value[i].startswith(\'a.\'):\r\n                            value[i] = \'a:\' + value[i][2:]\r\n                        if value[i].startswith(\'d.\'):\r\n                            value[i] = \'d:\' + value[i][2:]\r\n\r\n\r\n        if type( theFocus ) == bool:\r\n            theFocus = __.appReg\r\n\r\n        if column == \'values\':\r\n            if type(value) == str:\r\n                value = [value]\r\n            values = []\r\n            valuesV = []\r\n            if not runTrigger:\r\n                for x in value:\r\n                    values.append( x )\r\n            elif runTrigger:\r\n                if self.fieldExists( name, \'script_trigger\', theFocus ):\r\n                    for x in value:\r\n                        values.append( self.scriptTrigger( name, x, theFocus  ) )\r\n\r\n                elif self.fieldExists( name, \'script_trigger\', theFocus ) == True:    \r\n                    for x in value:\r\n                        script = \'{}(\\\'{}\\\',\\\'{}\\\')\'.format(self.fieldGet(name,\'script_trigger\'),name,x)# script_trigger_external\r\n                        values.append( eval(script) )\r\n                else:\r\n                    for x in value:\r\n                        values.append( x )\r\n            for x in values:\r\n                if type(x) == str:\r\n                    valuesV.append( x.replace(\',\',\';;\') )\r\n        if column == \'value\':\r\n            if runTrigger:\r\n                if self.fieldExists( name, \'script_trigger\', theFocus ):\r\n                    value = self.scriptTrigger( name, value, theFocus  )\r\n                    # self.fieldGet(name,\'script_trigger\')(value)\r\n                elif self.fieldExists( name, \'script_trigger\', theFocus ) == True:\r\n                    script = \'{}(\\\'{}\\\',\\\'{}\\\')\'.format(self.fieldGet(name,\'script_trigger\'),name,value)# script_trigger_external\r\n                    value = eval(script)\r\n        # print_( name, column, value )\r\n        # sys.exit()\r\n        for i,row in enumerate(self.switches):\r\n            if self.switches[i].appReg == theFocus:\r\n                if row.name == name:\r\n                    if column == \'active\':\r\n                        if value == True:\r\n                            self.switches[i].active = True\r\n                        else:\r\n                            self.switches[i].active = False\r\n                    elif column == \'value\':\r\n                        if value == True:\r\n                            self.switches[i].value = True\r\n                        elif value == False:\r\n                            self.switches[i].value = False\r\n                        else:\r\n                            self.switches[i].value = value\r\n                    elif column == \'values\':\r\n                        self.switches[i].values = values\r\n                        self.switches[i].value = \',\'.join(valuesV)\r\n\r\n                    else:\r\n                        # self.switches[i][column] = value\r\n                        exec(\'self.switches[i].\' + column + \'= value\')\r\n                        # value = str(value)\r\n                        # try:\r\n                        #   exec(\'self.switches[i].\' + column + \'=str(\\\'\' + value + \'\\\')\')\r\n                        # except Exception as e:\r\n                        #   exec(\'self.switches[i].\' + column + \'=\\\'\' + value + \'\\\'\')\r\n            \r\n        return \'\'\r\n\r\n\r\n\r\n    def fieldExists( self, name, column, theFocus=False ):# doesFieldExist\r\n        result = False\r\n        try:\r\n            for i,row in enumerate(self.switches):\r\n                if self.switches[i].appReg == __.appReg:\r\n                    if row.name == name:\r\n                        eval(\'row.\' + column)\r\n                        result = True\r\n        except Exception as e:\r\n            result = False\r\n        return result\r\n    def scriptTrigger( self, name, value, theFocus=False, cc=False ):# externalScriptTrigger\r\n        for i,s in enumerate(self.switches):\r\n            if self.switches[i].appReg == __.appReg:\r\n                if name == self.switches[i].name:\r\n                    if not cc:\r\n                        value = self.switches[i].script_trigger(value)# script_trigger_external\r\n                    elif cc:\r\n                        if not self.switches[i].vs:\r\n                            value = self.switches[i].script_trigger(value)# script_trigger_external\r\n                        elif not self.switches[i].script_trigger_alt is None:\r\n                            value = self.switches[i].script_trigger_alt(value)# script_trigger_external\r\n\r\n\r\n\r\n        return value\r\n\r\n    def fieldGet2(self,name,column):# getSwitchField\r\n        # print_(name,column)\r\n        result = \'\'\r\n        for i,row in enumerate(self.switches):\r\n            if row.name == name:\r\n                result = eval(\'row.\' + column)\r\n        return result\r\n\r\n    def fieldGet( self, name, column, theFocus=False ):# getSwitchField\r\n        # print_(name,column)\r\n        result = \'\'\r\n        if not column == \'pos\':\r\n\r\n            if name == \'NoColor\' and column == \'active\':\r\n\r\n                found = False\r\n\r\n                for i,row in enumerate(self.switches):\r\n                    if row.name == name:\r\n                        # print_( row.name, row.active )\r\n                        if row.active:\r\n                            found = True\r\n\r\n                result = found\r\n                        \r\n                # print_( \'here\', name, found )\r\n                # sys.exit()\r\n\r\n\r\n            else:\r\n\r\n\r\n                i = self.searchIndex( name, theFocus )\r\n                if i is None:\r\n\r\n                    if column == \'active\':\r\n                        return False\r\n\r\n                    if column == \'value\':\r\n                        return \'\'\r\n\r\n                    if column == \'values\':\r\n                        return []\r\n\r\n                    printBold( \'Error: Nonexistent Switch\', \'red\' )\r\n                    print_( name, column, theFocus )\r\n                    printVar( self.index )\r\n                    sys.exit()\r\n                row = self.switches[i]\r\n                result = eval(\'row.\' + column)\r\n\r\n        else:\r\n            if type( theFocus ) == bool:\r\n                theFocus = __.appReg\r\n            for i,row in enumerate(self.switches):\r\n                if self.switches[i].appReg == theFocus:\r\n                    if row.name == name:\r\n                        result = eval(\'row.\' + column)\r\n        return result\r\n\r\n    def isActive( self, name, theFocus=False ):# isSwitchActive\r\n        return self.fieldGet( name, \'active\', theFocus )\r\n\r\n    def getField( self, name, field, theFocus=False ):\r\n        return self.fieldGet( name, field, theFocus )\r\n\r\n    def value( self, name, theFocus=False ):# getSwitchValue\r\n        result = self.fieldGet( name, \'value\', theFocus )\r\n        if result is None:\r\n            result = \'\'\r\n        return result\r\n\r\n    def values( self, name, theFocus=False ):# getSwitchValue\r\n        result = self.fieldGet( name, \'values\', theFocus )\r\n        if result is None:\r\n            result = []\r\n        return result\r\n\r\n\r\n    def trigger( self, name, script, vs=False, alt=None ):\r\n        for i,s in enumerate(self.switches):\r\n            if self.switches[i].appReg == __.appReg:\r\n                if name == self.switches[i].name:\r\n                    self.switches[i].trigger(script,vs,alt)\r\n    \r\n    def simpleTrigger( self, name, value ):\r\n        return self.switches[self.dex[__.appReg][name]].script(value)\r\n                    \r\n\r\n    def value2(self,name):\r\n        # return \',\'.join( self.value3(name) )\r\n        # return \',\'.join(  self.value3(name)  )\r\n\r\n\r\n        switchInput = sys.argv\r\n\r\n        try:\r\n            switchInput[self.fieldGet(name,\'pos\') + 1]\r\n            result = \'\'\r\n\r\n            i = 0\r\n            for a in switchInput:\r\n                if i > self.fieldGet(name,\'pos\'):\r\n                    if self.isSwitch(switchInput[i]) == True:\r\n                        break\r\n                    else:\r\n                        if not name in __.switch_raw:\r\n                            if switchInput[i] == \':\':\r\n                                switchInput[i] = switchInput[i].replace(\':\',\'_;192B;_\')\r\n                            if switchInput[i] == \',\':\r\n                                switchInput[i] = switchInput[i].replace(\',\',\'_;192A;_\')\r\n                        result += str(switchInput[i]) + \',\'\r\n                i += 1\r\n            result = result[:-1]\r\n            if not name in __.switch_raw:\r\n                result = _str.cleanAll(result,\'"\',\'\')\r\n                result = _str.cleanAll(result,\':,\',\':\')\r\n                result = _str.cleanAll(result,\',,\',\',\')\r\n\r\n        except Exception as e:\r\n            result = \'\'\r\n        if not name in __.switch_raw:\r\n            return result\r\n            # return _str.cleanBE( result, \' \' )\r\n        else:\r\n            return result\r\n\r\n    def value3(self,name):\r\n        switchInput = sys.argv\r\n        data = []\r\n        try:\r\n            switchInput[self.fieldGet(name,\'pos\') + 1]\r\n            result = \'\'\r\n\r\n            for i,a in enumerate(switchInput):\r\n                # a=self.simpleTrigger(name,a)\r\n                if i > self.fieldGet(name,\'pos\'):\r\n                    if self.isSwitch(switchInput[i]) == True:\r\n                        break\r\n                    else:\r\n                        if not a == \' \':\r\n                            if not name in __.switch_raw:\r\n                                data.append(a)\r\n                                # data.append( _str.cleanBE( a, \' \' ) )\r\n                            else:\r\n                                data.append( a )\r\n                        else:\r\n                            data.append( a )\r\n\r\n\r\n        except Exception as e:\r\n            data = []\r\n        return data\r\n\r\n    def isSwitch(self,string):# checkIfSwitch\r\n        result = False\r\n        for i,a in enumerate(self.switches):\r\n            if self.switches[i].appReg == __.appReg:\r\n                for b in a.switch.split(\',\'):\r\n                    if b == string:\r\n                        result = True\r\n                    # print_(b,result)\r\n        return result\r\n\r\n    def format(self,name):# processSwitchFormatting\r\n        value = self.value2(name)\r\n        if self.fieldExists(name,\'script_trigger\'):\r\n            value = self.scriptTrigger(name,value,cc=True)\r\n        elif self.fieldExists(name,\'script_trigger\'):\r\n            script = \'{}(\\\'{}\\\',\\\'{}\\\')\'.format(self.fieldGet(name,\'script_trigger\'),name,value)\r\n            value = eval(script)\r\n        return value\r\n\r\n    def format2( self, name ):\r\n        values = self.value3(name)\r\n        # if name ==\'Plus\':\r\n        #     print_(values)\r\n        if values is None:\r\n            values = []\r\n        else:\r\n            for i,value in enumerate(values):\r\n                if self.fieldExists(name,\'script_trigger\'):\r\n                    values[i] = self.scriptTrigger(name,value)\r\n                elif self.fieldExists(name,\'script_trigger\'):\r\n                    script = \'{}(\\\'{}\\\',\\\'{}\\\')\'.format(self.fieldGet(name,\'script_trigger\'),name,value)\r\n                    values[i] = eval(script)\r\n        return values\r\n\r\n    def exists(self,name):# checkSwitchExist\r\n        result = False\r\n        for i,sw in enumerate(self.switches):\r\n            if self.switches[i].appReg == __.appReg:\r\n                if sw.name == name:\r\n                    result = True\r\n        return result\r\n    def help(self):\r\n        if self.value(\'Help\') == \'x\' or self.value(\'Help\') == \'cls\' or self.value(\'Help\') == \'clear\':\r\n            if __.isWin:\r\n                os.system(\'cls\')\r\n            else:\r\n                os.system(\'clear\')\r\n        # print_(__.registeredApps)\r\n        # print_(__.appReg)\r\n        # sys.exit()\r\n        if len(__.registeredApps) > 1:\r\n            # print_(__.appReg)\r\n            if __.appReg == \'__init__\' or __.appReg == \'cryptFile\':\r\n                return None\r\n        if __.appInfoScan:\r\n            return None\r\n        # self.help()\r\n        global appInfo\r\n        global fields\r\n        self.fieldSet(\'Long\',\'active\',True)\r\n        if __.cls_process_switches_help or \'cls\' in self.value(\'Help\'):\r\n            os.system(\'cls\')\r\n        # os.system(\'cls\')\r\n        print_()\r\n        print_()\r\n        filename = colorThis(  [ \'Program:  \\t\' ], \'bold\', p=0  )\r\n        try:\r\n            filename += colorThis(  [ appInfo[__.appReg][\'liveAppName\'] ], \'yellow\', p=0  )\r\n        except Exception as e:\r\n            filename += colorThis(  [ appInfo[__.appReg][\'file\'].replace(\'.py\',\'\') ], \'yellow\', p=0  )\r\n        print_()\r\n        print_( filename )\r\n        print_()\r\n\r\n        try:\r\n            if type( appInfo[__.appReg][\'description\'] ) == list:\r\n                print_( inlineBold(\'Description:   \'))\r\n                for x in appInfo[__.appReg][\'description\']:\r\n                    print_( \'                 - \', x )\r\n                print_()\r\n            else:\r\n                print_( inlineBold(\'Description:   \'), appInfo[__.appReg][\'description\'] + \'\\n\')\r\n            configured = True\r\n        except Exception as e:\r\n            configured = False\r\n            \r\n        try:\r\n            # print_( inlineBold(\'Categories:    \'), \', \'.join( appInfo[__.appReg][\'categories\'] ) + \'\\n\')\r\n            print_( inlineBold(\'Tags:          \'), \'(\',\', \'.join( appInfo[__.appReg][\'categories\'] ), \')\' + \'\\n\')\r\n            # print_( inlineBold(\'          Tags:\'), \', \'.join( appInfo[__.appReg][\'categories\'] ) + \'\\n\')\r\n            pass\r\n        except Exception as e:\r\n            pass\r\n\r\n        try:\r\n            if len(appInfo[__.appReg][\'prerequisite\']) > 0:\r\n                printBold(\'Prerequisite:\')\r\n                for docItem in appInfo[__.appReg][\'prerequisite\']:\r\n                    if type(docItem) == list:\r\n                        colorThis( \'\\t\\t\'+docItem[0], docItem[1]  )\r\n                    else:\r\n                        colorizeRow( \'\\t\\t\'+ docItem , 2)\r\n                    # colorizeRow(\'\\t\' + prereq,2)\r\n                print_(\'\\n\')\r\n        except Exception as e:\r\n            pass\r\n        try:\r\n            if len(appInfo[__.appReg][\'relatedapps\']) > 0:\r\n                printBold(\'Related Apps:\')\r\n                for docItem in appInfo[__.appReg][\'relatedapps\']:\r\n                    if type(docItem) == list:\r\n                        colorThis( \'\\t\\t\'+docItem[0], docItem[1]  )\r\n                    else:\r\n                        colorizeRow( \'\\t\\t\'+ docItem , 2)\r\n                print_(\'\\n\')\r\n        except Exception as e:\r\n            pass\r\n        if configured:\r\n            quit_early = False\r\n            if len(appInfo[__.appReg][\'examples\']) > 0:\r\n                printBold(\'Examples:\')\r\n                IDs = {}\r\n                ei = 1\r\n                for docItem in appInfo[__.appReg][\'examples\']:\r\n                    if not docItem is None:\r\n                        prei = str(ei)\r\n                        if len(self.value(\'Help\')) and self.value(\'Help\') == prei:\r\n                            prei = \'*\'\r\n                        elif not \'id\' in self.value(\'Help\') and not \'c\' in self.value(\'Help\') :\r\n                            prei = \'\'\r\n                        else:\r\n                            quit_early = True\r\n                        if type(docItem) == list:\r\n                            if not len(docItem[0]):\r\n                                prei = \'\'\r\n                            else:\r\n                                ei+=1\r\n                            if prei == \'*\':\r\n                                setClip(docItem[0])\r\n                                quit_early= True\r\n                            if len(prei):\r\n                                IDs[prei] = docItem[0]\r\n                            colorThis( \'\\t\'+prei+\'\\t\'+docItem[0], docItem[1]  )\r\n                        else:\r\n                            if not len(docItem):\r\n                                prei = \'\'\r\n                            else:\r\n                                ei+=1\r\n\r\n                            if len(prei):\r\n                                IDs[prei] = docItem\r\n                            if prei == \'*\':\r\n                                setClip(docItem)\r\n                                quit_early = True\r\n                            colorizeRow( \'\\t\'+prei+\'\\t\'+ docItem , 2)\r\n            if \'id\' in self.value(\'Help\') or \'c\' in self.value(\'Help\') or \'ask\' in self.value(\'Help\'):\r\n                askID = input( \'?> : \' )\r\n                if askID in IDs:\r\n                    setClip(IDs[askID])\r\n                    cp(  [ \'\\n\\nCopied:\\n\\t\', IDs[askID], \'\\n\\n\' ], \'green\'  )\r\n            if quit_early:\r\n                sys.exit()\r\n                    # colorizeRow(\'\\t\' + ex,2)\r\n                print_(\'\\n\')\r\n            if len(appInfo[__.appReg][\'columns\']) > 0:\r\n                printBold(\'Columns and abbreviations:\')\r\n                result = \'\'\r\n                if len( appInfo[__.appReg][\'columns\'] ):\r\n                    # fields.register( \'columns\', \'name,abbreviation\', script=__.triggerTest )\r\n                    fields.asset( \'columns\', appInfo[__.appReg][\'columns\'] )\r\n                    print_()\r\n\r\n                if __.columnAbbreviations == 0:\r\n                    for col in appInfo[__.appReg][\'columns\']:\r\n                        if not col[\'name\'] == col[\'abbreviation\']:\r\n                            result += col[\'name\'] + \'(\' + col[\'abbreviation\'] + \'), \'\r\n                    result = result[:-2]\r\n                    colorizeRow(\'\\t\' + result + \'\\n\',2)\r\n\r\n                if __.columnAbbreviations == 1:\r\n                    for col in appInfo[__.appReg][\'columns\']:\r\n                        if not col[\'name\'] == col[\'abbreviation\']:\r\n                            abbreviation =  fields.value( \'columns\', \'abbreviation\', col[\'abbreviation\'] )\r\n                            name =          fields.value( \'columns\', \'name\', col[\'name\'] )\r\n                            colorizeRow( \'\\t\' + abbreviation + \'\\t\' + name )\r\n                        # print_( \'\\t\', col[\'abbreviation\'], \'\\t\', col[\'name\']  )\r\n\r\n                if len( appInfo[__.appReg][\'columns\'] ):\r\n                    print_()\r\n                    print_()\r\n                # print_(\'\\n\')\r\n        pass\r\n        print_()\r\n        print_()\r\n        # def linePrint(  label=None, text=None, txt=\'_\', mn=50, add=5, p=2, c=\'\', half=False, h=None )\r\n        linePrint(txt=\'+\',c=\'yellow\',x=.5)\r\n        # colorThis(\'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\',\'yellow\')\r\n        printBold( \'Requirements:\' )\r\n        print_()\r\n        hasRequirements = False\r\n        # if __.isRequired_Pipe_or_File:\r\n        #     hasRequirements = True\r\n        #     colorThis(  [  \'  !! Required Pipe or Files\'  ]  , \'red\' )\r\n\r\n        # if len( self.isRequired[__.appReg] ):\r\n        #     for x in self.isRequired[__.appReg]:\r\n        #         hasRequirements = True\r\n        #         colorThis(  [  \'  !! Required Switch:\', x  ]  , \'red\' )\r\n\r\n        if __.isRequired_Pipe:\r\n            hasRequirements = True\r\n            colorThis(  [  \'  !! Required Pipe data\' ]  , \'red\' )\r\n        \r\n        if __.isRequired_Pipe_or_File:\r\n            hasRequirements = True\r\n            colorThis(  [  \'  !! Required Pipe data or Files switch\' ]  , \'red\' )\r\n\r\n        if len(self.isRequired[__.appReg]):\r\n            hasRequirements = True\r\n            colorThis(  [  \'  !! Required \' + \' and \'.join(self.isRequired[__.appReg])  ]  , \'red\' )\r\n\r\n\r\n        if not __.isRequired_or_List is None:\r\n            # for x in __.isRequired_or_List:\r\n            hasRequirements = True\r\n            colorThis(  [  \'  !! Required \' + \' or \'.join(__.isRequired_or_List)  ]  , \'red\' )\r\n\r\n\r\n        for switch in self.switches:\r\n            # print_( dir(switch) )\r\n            # print_( switch.__dict__ )\r\n            if len(switch.documentation[\'required\']) :\r\n                print_()\r\n                print_()\r\n                print_( colorThis( \'  !! If using switch:\' , \'bold\', p=0 ), colorThis( switch.name , \'yellow\', p=0 ), colorThis( \'the following is required:\' , \'bold\', p=0 ) )\r\n                for x in switch.documentation[\'required\']:\r\n                    hasRequirements = True\r\n                    colorThis(  [ \'\\t\', x  ]  , \'red\' )\r\n\r\n\r\n            if len(switch.documentation[\'related\']) :\r\n                print_()\r\n                print_()\r\n                print_( colorThis( \'  If using switch:\' , \'bold\', p=0 ), colorThis( switch.name , \'yellow\', p=0 ), colorThis( \'the following is related:\' , \'bold\', p=0 ) )\r\n                for x in switch.documentation[\'related\']:\r\n                    hasRequirements = True\r\n                    colorThis(  [ \'\\t\', x  ]  , \'yellow\' )\r\n\r\n                # del switch.script_trigger\r\n                # del switch.__dict__.script_trigger\r\n                # print_( dict( str(switch.__dict__) ) )\r\n                # printVar( dict(switch.__dict__) )\r\n            # sys.exit()\r\n        if not hasRequirements:\r\n            colorThis( [ \'\\t\', \'No requirements\' ], \'green\' )\r\n        print_()\r\n        linePrint(txt=\'+\',c=\'yellow\',x=.5)\r\n        # colorThis(\'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\',\'yellow\')\r\n        print_()\r\n        print_()\r\n        self.print()\r\n        if \'notes\' in appInfo[__.appReg]:\r\n            if len( appInfo[__.appReg][\'notes\'] ):\r\n                print_()\r\n                print_()\r\n                printBold( \'Notes:\' )\r\n                for col in appInfo[__.appReg][\'notes\']:\r\n                    print_()\r\n                    printVarSimple( col, prefix=\'                \', remove=\'"\' )\r\n                    print_()\r\n\r\n        # for x in sys.modules:\r\n        #     print_(x)\r\n        sys.exit()\r\n        raise SystemExit\r\n        os._exit(0)\r\n        sys.exit(1)\r\n        os._exit(os.EX_OK)\r\n\r\n\r\n\r\n            \r\n    def process( self, helpx=False ):\r\n        \r\n\r\n        load()\r\n        global customHelp\r\n        global argvProcess\r\n        global printAutoAbbreviations_scheduled\r\n        for ii,sw in enumerate(self.switches):\r\n            if self.switches[ii].appReg == __.appReg:\r\n                self.switches[ii].pos = None\r\n                self.switches[ii].active = False\r\n                self.switches[ii].value = None\r\n                try:\r\n                    __.trigger_isPipe = self.switches[ii].isData\r\n                except Exception as e:\r\n                    pass\r\n\r\n        switchHelp = []\r\n        isActiveList = []\r\n        hasActiveRequireList = []\r\n        isActiveRequireList = []\r\n\r\n        if argvProcess:\r\n            for i,a in enumerate(sys.argv):\r\n                if a in __.switch_skimmer.scan:\r\n                    __.switch_skimmer.active.append( a )\r\n                a = a.replace(\':\',\'\')\r\n                for ii,sw in enumerate(self.switches):\r\n                    for s in sw.switch.split(\',\'):\r\n                        if s.lower() == a.lower():\r\n                            if self.switches[ii].appReg == __.appReg:\r\n                                self.switches[ii].pos = i\r\n                                self.switches[ii].active = True\r\n                                self.switches[ii].value = self.format(self.switches[ii].name)\r\n                                self.switches[ii].values = self.format2(self.switches[ii].name)\r\n\r\n                                isActiveList.append( ii )\r\n                                if self.switches[ii].name in self.hasRequired:\r\n                                    hasActiveRequireList.append( ii )\r\n                                if self.switches[ii].name in self.isRequired[__.appReg]:\r\n                                    isActiveRequireList.append( ii )\r\n\r\n                                if type( self.switches[ii].value ) == str:\r\n                                    if \'-??\' in self.switches[ii].value:\r\n                                        switchHelp.append(ii)\r\n\r\n        if self.exists(\'_Raw\') == True:\r\n            # print_(\'test\')\r\n            self.fieldSet(\'_Raw\',\'pos\',1)\r\n            self.fieldSet(\'_Raw\',\'active\',True)\r\n            self.fieldSet(\'_Raw\',\'value\',self.format(\'_Raw\'))\r\n\r\n\r\n        for i,record in enumerate(self.switches):\r\n            if self.appRegDefault is None:\r\n                self.appRegDefault = self.switches[i].appReg\r\n            self.index[ self.switches[i].appReg ] = {}\r\n        for i,record in enumerate(self.switches):\r\n            self.index[ self.switches[i].appReg ][self.switches[i].name] = i\r\n\r\n\r\n\r\n        if len( switchHelp ):\r\n            if __.cls_process_switches_help:\r\n                os.system(\'cls\')\r\n\r\n            somethingPrinted = False\r\n            for i in switchHelp:\r\n                if len( self.switches[i].documentation[\'description\'] ):\r\n                    somethingPrinted = True\r\n                    print_()\r\n                    print_( inlineBold(\'Description:\\t\'), self.switches[i].documentation[\'description\'] )\r\n                    print_()\r\n                if len( self.switches[i].documentation[\'examples\'] ):\r\n                    printBold( \'Examples:\' )\r\n                    for example in self.switches[i].documentation[\'examples\']:\r\n                        if type(example) == list:\r\n                            _.colorThis( \'\\t\\t\'+example[0], example[1]  )\r\n                        else:\r\n                            colorizeRow( \'\\t\\t\'+ example , 2)\r\n\r\n\r\n\r\n            if somethingPrinted:\r\n                sys.exit()\r\n\r\n        if self.isActive(\'Help\') or helpx:\r\n            self.help()\r\n\r\n\r\n\r\n        if len( self.isRequired[__.appReg] ):\r\n            allSatisfied = True\r\n            \r\n            for req in self.isRequired[__.appReg]:\r\n                satisfied = False\r\n                for i in isActiveRequireList:\r\n                    if self.switches[i].name.lower() == req.lower():\r\n                        satisfied = True\r\n\r\n                try:\r\n                    __.appInfoScan\r\n                except Exception as e:\r\n                    if not satisfied:\r\n                        allSatisfied = False\r\n                        print_()\r\n                        print_( colorThis( \'Error:\', \'red\', p=0 ) + \' missing required switch:\', req )\r\n                        sys.exit()\r\n\r\n\r\n        if len( hasActiveRequireList ):\r\n            allSatisfied = True\r\n            for i in hasActiveRequireList:\r\n                satisfied = False\r\n                for r in self.switches[i].documentation[\'required\']:\r\n                    for ia in isActiveList:\r\n                        if self.switches[i].name.lower() == r.lower():\r\n                            satisfied = True\r\n                if not satisfied:\r\n                    if not i in switchHelp:\r\n                        switchHelp.append( i )\r\n                        print_()\r\n                        print_( \'Error:\\t\\t missing required switch\' )\r\n                    allSatisfied = False\r\n\r\n\r\n\r\n        if self.isActive(\'Debug\') == True or self.isActive(\'Errors\') == True:\r\n            # self.print()\r\n            self.printStatus()\r\n            sys.exit()\r\n        \r\n        if printAutoAbbreviations_scheduled:\r\n            printAutoAbbreviations()\r\n\r\n        if self.isActive(\'TableProfile\') and len(self.value(\'TableProfile\')):\r\n            global TableProfile_Config\r\n\r\n            TableProfile_Config = {}\r\n\r\n            values = self.values(\'TableProfile\')\r\n            value  = self.value(\'TableProfile\')\r\n\r\n            if not \',\' in value and not \';\' in value:\r\n                tpv = value\r\n\r\n\r\n                if tpv == \'gs\' or tpv == \'groupspaces\' or tpv == \'groupspace\':\r\n                    try:\r\n                        TableProfile_Config[\'ALLTABLES\'][\'GroupSpaces\'] = True\r\n                    except Exception as e:\r\n                        TableProfile_Config[\'ALLTABLES\'] = {}\r\n                        TableProfile_Config[\'ALLTABLES\'][\'GroupSpaces\'] = True\r\n                elif tpv == \'hl\':\r\n                    try:\r\n                        TableProfile_Config[\'_header_\'][\'alignment\'] = \'left\'\r\n                    except Exception as e:\r\n                        TableProfile_Config[\'_header_\'] = {}\r\n                        TableProfile_Config[\'_header_\'][\'alignment\'] = \'left\'\r\n\r\n\r\n\r\n            else:\r\n                for tpv in value.split(\',\'):\r\n                    if not \';\' in tpv:\r\n\r\n\r\n\r\n                        if tpv == \'gs\' or tpv == \'groupspaces\' or tpv == \'groupspace\':\r\n                            try:\r\n                                TableProfile_Config[\'ALLTABLES\'][\'GroupSpaces\'] = True\r\n                            except Exception as e:\r\n                                TableProfile_Config[\'ALLTABLES\'] = {}\r\n                                TableProfile_Config[\'ALLTABLES\'][\'GroupSpaces\'] = True\r\n                        elif tpv == \'hl\':\r\n                            try:\r\n                                TableProfile_Config[\'_header_\'][\'alignment\'] = \'left\'\r\n                            except Exception as e:\r\n                                TableProfile_Config[\'_header_\'] = {}\r\n                                TableProfile_Config[\'_header_\'][\'alignment\'] = \'left\'\r\n\r\n\r\n                    elif \';\' in tpv and tpv.count(\';\') == 1:\r\n\r\n\r\n                        tpvX = tpv.split(\';\')\r\n                        if tpvX[1] == \'l\' or tpvX[1] == \'left\' or tpvX[1] == \'r\' or tpvX[1] == \'right\' or tpvX[1] == \'c\' or tpvX[1] == \'center\':\r\n                            if tpvX[0] == \'header\' or tpvX[0] == \'h\':\r\n                                tpvX[0] = \'_header_\'\r\n                            if tpvX[1] == \'l\': tpvX[1] = \'left\';\r\n                            if tpvX[1] == \'r\': tpvX[1] = \'right\';\r\n                            if tpvX[1] == \'c\': tpvX[1] = \'center\';\r\n                            try:\r\n                                TableProfile_Config[  tpvX[0]  ][\'alignment\'] = tpvX[1]\r\n                            except Exception as e:\r\n                                TableProfile_Config[  tpvX[0]  ] = {}\r\n                                TableProfile_Config[  tpvX[0]  ][\'alignment\'] = tpvX[1]\r\n\r\n                            # printVarSimple( TableProfile_Config )\r\n\r\n        # theErrors()\r\n        pass\r\n        pass\r\n        # for i,record in enumerate(self.switches):\r\n        #   self.index[ self.switches[i].name +\'._.\'+ self.switches[i].appReg ] = i\r\n\r\n        if len( self.postScripts ):\r\n            for childScript in self.postScripts:\r\n                if \'function\' in str(type(childScript)):\r\n                    childScript()\r\n        \r\n        \r\n    def searchIndex( self, name, appReg ):\r\n        if type(appReg) == bool or appReg is None:\r\n            appReg = __.appReg\r\n        try:\r\n            result = self.index[ appReg ][ name ]\r\n            \r\n            # result = self.index[ name +\'._.\'+ appReg ]\r\n        except Exception as e:\r\n            try:\r\n                result = self.index[ self.appRegDefault ][ name ]\r\n            except Exception as e:\r\n                # print_( name, appReg, self.appRegDefault )\r\n                result = None\r\n\r\n        return result\r\n\r\n\r\n    def print(self):\r\n        switch = []\r\n        global tables\r\n        for i,sw in enumerate(self.switches):\r\n            if self.switches[i].appReg == __.appReg:\r\n                switch.append({\'name\':sw.name ,\'switch\':sw.switch,\'expected_input_example\': sw.expected_input_example})\r\n        # def test(value):\r\n        #   value = value + \'_V_\'\r\n        #   return value\r\n        tables.register(\'switches\',switch)\r\n        # tables.trigger(\'switches\',\'switch,name\',test,True)\r\n        tables.print(\'switches\',\'name,switch,expected_input_example\')\r\n    def printStatus(self):\r\n        switch = []\r\n        global tables\r\n        for i,sw in enumerate(self.switches):\r\n            if self.switches[i].appReg == __.appReg:\r\n                if sw.active:\r\n                    active = \'True\'\r\n                else:\r\n                    active = \'\'\r\n                value = sw.value\r\n                if sw.value == True:\r\n                    value = \'True\'\r\n                elif sw.value == False:\r\n                    value = \'\'\r\n\r\n                switch.append({\'name\':sw.name ,\'active\':active,\'value\': value})\r\n        # def test(value):\r\n        #   value = value + \'_V_\'\r\n        #   return value\r\n        tables.register(\'switches\',switch)\r\n        # tables.trigger(\'switches\',\'switch,name\',test,True)\r\n        tables.print(\'switches\',\'name,active,value\')\r\n    def active(self,theFocus=None):\r\n        if theFocus is None:\r\n            theFocus = __.appReg\r\n        table = []\r\n        for i,sw in enumerate(self.switches):\r\n            if self.switches[i].appReg == theFocus:\r\n                # print_( type(sw.active), sw.active )\r\n                if sw.active:\r\n                    table.append(sw.name)\r\n        return table\r\n\r\n\r\n    def length(self,theFocus=None):\r\n        if theFocus is None:\r\n            theFocus = __.appReg\r\n        ii = 0\r\n        for i,sw in enumerate(self.switches):\r\n            if self.switches[i].appReg == theFocus:\r\n                ii += 1\r\n        return ii\r\n\r\n    def rebuild( self, theFocus=False ):\r\n        if not type( theFocus ) == bool:\r\n            appReg = theFocus\r\n        else:\r\n            appReg = __.appReg\r\n\r\n\r\n        data = []\r\n        for i,row in enumerate(self.switches):\r\n            # if not row.value is None:\r\n            if row.appReg == appReg:\r\n                if row.active:\r\n                    sX = row.switch.split(\',\')\r\n                    if row.value is None:\r\n                        r = sX[0]\r\n                    else:\r\n                        r = sX[0] + \' \' + str(row.value)\r\n                    data.append( r )\r\n            # print_(row.name,\'\\t\',row.value,\'\\t\',row.appReg)\r\n        return \' \'.join( data )\r\n    def getTable( self, theFocus=False ):\r\n        if not type( theFocus ) == bool:\r\n            appReg = theFocus\r\n        else:\r\n            appReg = __.appReg\r\n\r\n\r\n        data = []\r\n        for i,row in enumerate(self.switches):\r\n            if row.appReg == appReg:\r\n                if row.active:\r\n\r\n                    info = {\r\n                                \'name\': row.name,\r\n                                \'value\': row.value,\r\n                                \'values\': row.values,\r\n                    }\r\n\r\n                    data.append( info )\r\n        return data\r\n\r\n\r\n    def loadTable( self, data, theFocus=False ):\r\n        if not type( theFocus ) == bool:\r\n            appReg = theFocus\r\n        else:\r\n            appReg = __.appReg\r\n\r\n\r\n        for i,row in enumerate(self.switches):\r\n            for info in data:\r\n                if row.appReg == appReg:\r\n                    if row.name == info[\'name\']:\r\n\r\n                        self.switches[i].value = info[\'value\']\r\n                        self.switches[i].values = info[\'values\']\r\n                        self.switches[i].active = True\r\n\r\n    def onlyLoadEpoch( self, theFocus=False ):\r\n        if not type( theFocus ) == bool:\r\n            appReg = theFocus\r\n        else:\r\n            appReg = __.appReg\r\n\r\n\r\n        for i,row in enumerate(self.switches):\r\n            if row.appReg == appReg:\r\n                if row.active and not row.name == \'LoadEpoch\':\r\n                    return False\r\n\r\n\r\n        return True\r\n\r\n\r\n\r\n#   def getSelf(self,name):\r\n#       result = \'\'\r\n#       for sw in self.switches:\r\n#           if sw.name == name:\r\n#               result = sw\r\n#       return result\r\n# def getSwitchSelf(name):\r\n#   global switches\r\n#   return switches.getSelf(name)\r\ndef ci2(string):\r\n    string = ci(string)\r\n    string = _str.replaceAll(string,\',\',\' \')\r\n    return string\r\n\r\nclass TableView:\r\n\r\n    def __init__(self,name,table,fields,sort):\r\n        self.name = name\r\n        self.fields = fields\r\n        self.sort = sort\r\n        self.table = table\r\n        # print_(self.name)\r\n\r\n\r\nTableProfile_Config = {}\r\nclass Table:\r\n\r\n    def __init__( self, name, asset=[], group_space=True, tab=\'\', webtable=None ):\r\n        global switches\r\n        global _dir\r\n        \r\n\r\n        self.webtable = webtable\r\n        self.group_space = group_space\r\n        self.name = name\r\n        self.asset = asset\r\n        self.fields = []\r\n        self.views = []\r\n        self.spaces = {}\r\n        self.maxNameLength = 35\r\n        if switches.isActive(\'Long\'):\r\n            try:\r\n                self.maxNameLength = int(switches.value(\'Long\'))\r\n            except Exception as e:\r\n                self.maxNameLength = 35\r\n        self.columnTab = \'   \'\r\n        self.groupSeparator = \'_\'\r\n        self.tableProfile = []\r\n        self.tableProfileDefaultAlignment = \'left\'\r\n        self.tableProfileDefaultAlignmentHeader = \'\'\r\n        self.tableProfileDefaultAlignmentChanged = False\r\n        self.tableProfileDefaultAlignment = False\r\n        self.tableProfileDefaultSupersedes = False\r\n        self.views = []\r\n        self.universalSpacing = False\r\n\r\n        self.wrapTableKey = \'Da529801Ef674997B9f3382B3eD2b93F\'\r\n        self.backup = dot()\r\n        self.backup.asset = asset.copy()\r\n        self.aggregate_processed = False\r\n        self.isWrap = False\r\n        self.hasAggregate = False\r\n        self.hasGroups = False\r\n        self.backup.fields = {}\r\n        self.backup.allfields = {}\r\n        self.backup.NGfields = {}\r\n        self.groupID_KEY = genUUID()\r\n        if len( self.asset ):\r\n            for r in self.asset:\r\n                for k in r:\r\n                    if not k in self.backup.fields:\r\n                        self.backup.fields[k] = 1\r\n                        self.backup.allfields[ tfc(k) ] = k\r\n                        self.backup.NGfields[ tfc(k) ] = k\r\n\r\n\r\n        self.tab_color = \'\'\r\n        if type(tab) == list:\r\n            self.tab_color = tab[1]\r\n            tab = tab[0]\r\n\r\n        tabH = \'\'\r\n        i=0\r\n        while not i == len(tab):\r\n            i+=1\r\n            tabH+=\' \'\r\n\r\n        self.tab = { \'header\': tabH, \'table\': tab }\r\n\r\n    def registerView(self,name,fields,sort = \'\'):\r\n        self.views.append(TableView(name,self.name,fields,sort))\r\n\r\n    def printView(self,name):\r\n        global switches\r\n        i=0\r\n        for tp in self.views:\r\n            # print_()\r\n            # for x in dir(self.views[i]):\r\n            #   print_(x)\r\n\r\n            if self.views[i].name == name:\r\n                # print_(\'found\')\r\n                switches.fieldSet(\'Sort\',\'active\',True)\r\n                switches.fieldSet(\'Sort\',\'value\',str(self.views[i].sort))\r\n                # print_(switches.value(\'Sort\'))\r\n                # try:\r\n                    \r\n                # except Exception as e:\r\n                #   pass\r\n                # print_(\'name:\',name)\r\n                self.print(self.views[i].fields)\r\n            i += 1\r\n\r\n    # def trigger(self,field,script,includes):\r\n    #   self.views.append({\'name\': field, \'script_trigger\': script , \'includes\': includes })\r\n\r\n\r\n    def nameLength(self,string,suffix):\r\n        result = \'\'\r\n        toLong = False\r\n        if switches.isActive(\'Length\'):\r\n            result = self.nameLengthFix(string,switches.value(\'Length\'),\'\')\r\n        else:\r\n            try:\r\n                i = 0\r\n                for L in string:\r\n                    if i <= self.maxNameLength:\r\n                        result += L\r\n                    else:\r\n                        toLong = True\r\n                    i += 1\r\n                if toLong == True:\r\n                    result += \'...\'\r\n                    if len(suffix) > 0:\r\n                        result += \'  .\' + suffix\r\n            except Exception as e:\r\n                result = string\r\n        return result\r\n\r\n    def nameLengthFix(self,string,change,suffix):\r\n        result = \'\'\r\n        toLong = False\r\n        change = change.lower()\r\n        old = self.maxNameLength\r\n        if \'x\' in change:\r\n            change = change.replace(\'x\',\'\')\r\n            newLength = self.maxNameLength * int(change)\r\n        else:\r\n            newLength = self.maxNameLength + int(change)\r\n        try:\r\n            i = 0\r\n            for L in string:\r\n                if i <= newLength:\r\n                    result += L\r\n                else:\r\n                    toLong = True\r\n                i += 1\r\n            if toLong == True:\r\n                result += \'...\'\r\n                if len(suffix) > 0:\r\n                    result += \'  .\' + suffix\r\n        except Exception as e:\r\n            result = string\r\n        return result\r\n\r\n    def tabGetMaxSpace(self,name):\r\n        global errors\r\n        global switches\r\n        rows = self.asset\r\n        spacer = 1\r\n        # print_(\'*** \' + name)\r\n        size = len(name) + spacer\r\n        \r\n        # print_(name,00)\r\n        # rows[0][name]\r\n        try:\r\n            pass\r\n            if name in rows[0]:\r\n                rows[0][name]\r\n            else:\r\n                # print_(  \'rows[0]["\' + \'"]["\'.join(name.split(\'.\')) + \'"]\'  )\r\n                eval(  \'rows[0]["\' + \'"]["\'.join(name.split(\'.\')) + \'"]\'  )\r\n        except Exception as e:\r\n            errors.append({\'id\': 9, \'function\': \'tabGetMaxSpace()\', \'cnt\': 1, \'location\': \'rows[0][name]\', \'vars\': [{\'name\': \'rows\', \'value\': \'nope to that, to big\'}, {\'name\': \'name\', \'value\': name}], \'error\': e})\r\n            printBold(\'Error:\',\'red\')\r\n            printBold(\'\\tBad column input.\')\r\n            print_(9)\r\n            print_(name)\r\n            print_(  \'rows[0]["\' + \'"]["\'.join(name.split(\'.\')) + \'"]\'  )\r\n            printVarSimple(rows[0])\r\n            printBold(\'record sample\',\'red\')\r\n            os._exit(0)\r\n        # print_(name)\r\n        for item in rows:\r\n            shorten = True\r\n            if switches.isActive(\'Long\') == True:\r\n                shorten = False\r\n                if switches.isActive(\'ShortenColumn\') == True:\r\n                    shortenColumn = switches.value(\'ShortenColumn\')\r\n                    for sc in shortenColumn.split(\',\'):\r\n                        if sc == name:\r\n                            shorten = True\r\n            \r\n            if name in item:\r\n                thisData = item[name]\r\n            elif name.split(\'.\')[0] in item:\r\n                thisData = eval(  \'item["\' + \'"]["\'.join(name.split(\'.\')) + \'"]\'  )\r\n\r\n\r\n            if shorten == True and not switches.isActive(\'Length\'):\r\n                try:\r\n                    text = self.nameLength( str(self.scriptTriggerField(name,thisData)) ,\'\')\r\n                except Exception as e:\r\n                    text = self.nameLength(str(thisData),\'\')\r\n            else:\r\n                if switches.isActive(\'Length\'):\r\n                    # print_(\'asdf\')\r\n                    # sys.exit()\r\n                    try:\r\n                        \r\n                        text = self.nameLengthFix(  str(self.scriptTriggerField(name,thisData)) ,switches.value(\'Length\'),\'\')\r\n                    except Exception as e:\r\n                        text = self.nameLengthFix(str(thisData),switches.value(\'Length\'),\'\')\r\n                else:\r\n                    # sys.exit()\r\n                    # if type(thisData) == int or type(thisData) == float:\r\n                    #     text = thisData\r\n                    # else:\r\n                    try:\r\n                        text = self.scriptTriggerField(name,thisData)\r\n                    except Exception as e:\r\n                        text = thisData\r\n                            \r\n            \r\n            itemSize = len(str(text)) + spacer\r\n            if itemSize > size:\r\n                size = itemSize\r\n            # print_(item)\r\n        return size\r\n\r\n    def addSpace(self,string,max):\r\n        dif = int(max) - len(string)\r\n        build = \'\'\r\n        for x in range(dif):\r\n            build = build + \' \'\r\n        return build\r\n    def addSpace2(self,max):\r\n        dif = int(max)\r\n        build = \'\'\r\n        for x in range(dif):\r\n            build = build + \' \'\r\n        return build\r\n    def scriptTriggerField(self,field,value):\r\n        i = 0\r\n        for s in self.tableProfile:\r\n            try:\r\n                if self.tableProfile[i][\'includes\'] == True:\r\n                    if \',\' in self.tableProfile[i][\'name\']:\r\n                        found = False\r\n                        for n in self.tableProfile[i][\'name\'].split(\',\'):\r\n                            if n in field:\r\n                                found = True\r\n                        if found:\r\n                            value = self.tableProfile[i][\'script_trigger\'](value)\r\n                    else:\r\n                        if self.tableProfile[i][\'name\'] in field:\r\n                            value = self.tableProfile[i][\'script_trigger\'](value)\r\n                else:\r\n                    if field == self.tableProfile[i][\'name\']:\r\n                        value = self.tableProfile[i][\'script_trigger\'](value)\r\n            except Exception as e:\r\n                pass\r\n            i += 1\r\n        return value\r\n    def triggerExecute(self,field,value):\r\n        i = 0\r\n        for s in self.tableProfile:\r\n            if self.tableProfile[i][\'name\'] == field:\r\n                try:\r\n                    value = self.tableProfile[i][\'trigger\'](value)\r\n                except Exception as e:\r\n                    pass\r\n            else:\r\n                if type(value) == int:\r\n                    value = addComma( str(value) )\r\n            i += 1\r\n        return value\r\n\r\n    def fieldProfileSet(self,field,propertyName,value):\r\n        field = field.lower()\r\n        if field == \'*\' and propertyName == \'alignment\':\r\n            self.tableProfileDefaultAlignment = value\r\n            self.tableProfileDefaultAlignmentChanged = True\r\n        if field == \'_header_\' and propertyName == \'alignment\':\r\n            self.tableProfileDefaultAlignmentHeader = value\r\n        else:\r\n            if \',\' in field:\r\n                for n in field.split(\',\'):\r\n                    self.fieldProfileSet(n,propertyName,value)\r\n\r\n            found = False\r\n            i = 0\r\n            for s in self.tableProfile:\r\n                if self.tableProfile[i][\'name\'] == field:\r\n                    found = True\r\n                    self.tableProfile[i][propertyName] = value\r\n                i += 1\r\n\r\n            if not found:\r\n                item = len(self.tableProfile)\r\n                self.tableProfile.append({\'name\': field, propertyName: value})\r\n\r\n    def fieldProfileGet(self,field,propertyName,isHeader = False):\r\n        # print_(\'ran\')\r\n        field = field.lower()\r\n        i = 0\r\n        value = \'\'\r\n        if isHeader and \'_header_\' in TableProfile_Config.keys() and propertyName in TableProfile_Config[\'_header_\'].keys():\r\n            return TableProfile_Config[\'_header_\'][propertyName]\r\n        elif not isHeader and field in TableProfile_Config.keys() and propertyName in TableProfile_Config[field].keys():\r\n            return TableProfile_Config[field][propertyName]\r\n        elif \'*\' in TableProfile_Config.keys() and propertyName in TableProfile_Config[\'*\'].keys():\r\n            return TableProfile_Config[\'*\'][propertyName]\r\n\r\n        if propertyName == \'alignment\':\r\n            value = self.tableProfileDefaultAlignment\r\n\r\n        for s in self.tableProfile:\r\n            if self.tableProfile[i][\'name\'] == field:\r\n                try:\r\n                    value = self.tableProfile[i][propertyName]\r\n                except Exception as e:\r\n                    pass\r\n            i += 1\r\n\r\n\r\n        if self.tableProfileDefaultAlignmentChanged and self.tableProfileDefaultSupersedes:\r\n            value = self.tableProfileDefaultAlignment\r\n        if isHeader and len(self.tableProfileDefaultAlignmentHeader) > 0:\r\n            value = self.tableProfileDefaultAlignmentHeader\r\n\r\n        elif isHeader:\r\n            value = \'center\'\r\n        if propertyName == \'alignment\' and value == \'\':\r\n            value = \'left\'\r\n        return value\r\n    def showColumn(self,column,i,columnHeaderLength):\r\n        # print_(column)\r\n        global errors\r\n        global lastGroup\r\n        global switches\r\n        def test(one,two):\r\n            # print_(one,two)\r\n            if (one) == (two):\r\n                return True\r\n            else:\r\n                return False\r\n        groupByList = self.groupByList\r\n        rows = self.asset\r\n        # print_(rows)\r\n\r\n        columnList = column\r\n        if column in rows[i]:\r\n            value = str(self.triggerExecute(column,rows[i][column]))\r\n        elif column.split(\'.\')[0] in rows[i]:\r\n            value = str(self.triggerExecute(column,  eval(  \'rows[i]["\' + \'"]["\'.join(column.split(\'.\')) + \'"]\'  )  ) )\r\n\r\n        # value = rows[i][column]\r\n        # print_(column,value)\r\n        value = value.replace(\'\\n\',\'\')\r\n        # value = self.scriptTriggerField(column,rows[i][column])\r\n        try:\r\n            pass\r\n        except Exception as e:\r\n            pass\r\n\r\n        shorten = True\r\n        if switches.isActive(\'Long\') == True:\r\n            shorten = False\r\n            if switches.isActive(\'ShortenColumn\') == True:\r\n                shortenColumn = switches.value(\'ShortenColumn\')\r\n                for sc in shortenColumn.split(\',\'):\r\n                    if sc == column:\r\n                        shorten = True\r\n        text = str(value)\r\n        if shorten == True:\r\n            text = self.nameLength(str(value),\'\')\r\n        else:\r\n            text = str(value)\r\n\r\n\r\n        groupBy = switches.value(\'GroupBy\')\r\n        try:\r\n            tabFix = self.spaces[column]\r\n        except Exception as e:\r\n            # errors.append({\'id\': 10, \'function\': \'showColumn()\', \'cnt\': 1, \'location\': \'tabFix = spaces[column]\', \'vars\': [{\'name\': \'rows\', \'value\': \'nope to that, to big\'}, {\'name\': \'column\', \'value\': column}, {\'name\': \'i\', \'value\': i}], \'error\': e})\r\n            tabFix = self.tabGetMaxSpace(column)\r\n            self.spaces[column] = tabFix\r\n\r\n        if switches.isActive(\'GroupBy\') == True:\r\n            for gb in groupBy.split(\',\'):\r\n                gb = str(gb)\r\n                if column == gb:\r\n                    # print_(\'- -\',last,text)\r\n                    if not test(groupByList[gb],text) == True:\r\n                        if groupBy.split(\',\')[0] == column:\r\n                            pass\r\n                            if self.group_space:\r\n                                print_(self.groupLine(columnList,columnHeaderLength))\r\n                            if not self.isExtraRecord:\r\n                                for g in groupBy.split(\',\'):\r\n                                    groupByList[g] = \'\'\r\n                        else:\r\n                            pass\r\n                            if self.group_space:\r\n                                print_(\'\')\r\n                         \r\n\r\n                        if not self.isExtraRecord:\r\n                            groupByList[gb] = text\r\n                        else:\r\n                            if self.isExtraRecord_000x.split(\'-\')[0] in self.isExtraRecord_0001:\r\n                                text = \'\'\r\n\r\n                        # else:\r\n                        #   print_(text)\r\n                    else:\r\n                        pass\r\n                         \r\n                        if len(self.isExtraRecord_000x):\r\n                            self.isExtraRecord_0001[ self.isExtraRecord_000x.split(\'-\')[0] ] = 1\r\n                        text = \'\'\r\n                        \r\n        alignment = self.fieldProfileGet(column,\'alignment\')\r\n        # print_(alignment)\r\n        # if alignment == \'left\':\r\n        result = text + self.addSpace(text,tabFix)\r\n        if alignment == \'left\':\r\n            result = text + self.addSpace(text,tabFix)\r\n        if alignment == \'right\':\r\n            result = self.addSpace(text,tabFix) + text\r\n        if alignment == \'center\':\r\n            totalSpace = int(tabFix) - len(text)\r\n            if totalSpace > 0:\r\n                if totalSpace % 2 == 0:\r\n                    div2 = totalSpace/2\r\n                    theLeft = div2\r\n                    theRight = div2\r\n                else:\r\n                    divTMP = totalSpace - 1\r\n                    div2 = divTMP/2\r\n                    theLeft = div2 + 1\r\n                    theRight = div2\r\n            else:\r\n                theLeft = 0\r\n                theRight = 0\r\n            result = self.addSpace2(theLeft) + text + self.addSpace2(theRight)\r\n            # print_(column,theLeft,theRight,\'0\' + result + \'0\')\r\n            # print_(totalSpace,theLeft,theRight)\r\n        #   result = theLeft + text + theRight\r\n        return result\r\n\r\n    def groupLine(self,columnList,columnHeaderLength):\r\n        columnNumber = len(columnList.split(\',\'))\r\n        loop = 0\r\n        result = \'\'\r\n        while loop < columnHeaderLength + (columnNumber * 4):\r\n            result += self.groupSeparator\r\n            loop += 1\r\n        return result\r\n\r\n    def showColumnHeader(self,column):\r\n        # rows = self.asset\r\n        result = \' \'\r\n        if type(self.universalSpacing) == dict:\r\n            self.spaces = self.universalSpacing\r\n        for c in column.split(\',\'):\r\n            try:\r\n                tabFix = self.spaces[c]\r\n            except Exception as e:\r\n                # errors.append({\'id\': 11, \'function\': \'showColumn()\', \'cnt\': 2, \'location\': \'tabFix = spaces[c]\', \'vars\': [{\'name\': \'rows\', \'value\': \'nope to that, to big\'}, {\'name\': \'column\', \'value\': column}], \'error\': e})\r\n                tabFix = self.tabGetMaxSpace(c)\r\n                self.spaces[c] = tabFix\r\n                # print_(tabFix)\r\n            # x\r\n            # alignment = \'center\'\r\n            alignment = self.fieldProfileGet(c,\'alignment\',isHeader=True)\r\n            alignment=\'left\'\r\n            if alignment == \'\':\r\n                ########## Default Alignment ##########\r\n                alignment = \'left\'\r\n\r\n            if switches.isActive(\'YesTableLines\'):\r\n                result+=\'|\'\r\n            else:\r\n                result+=\' \'\r\n\r\n            if alignment == \'center\':\r\n                totalSpace = int(tabFix) - len(c)\r\n                if totalSpace > 0:\r\n                    if totalSpace % 2 == 0:\r\n                        div2 = totalSpace/2\r\n                        theLeft = div2\r\n                        theRight = div2\r\n                    else:\r\n                        divTMP = totalSpace - 1\r\n                        div2 = divTMP/2\r\n                        theLeft = div2 + 1\r\n                        theRight = div2\r\n                else:\r\n                    theLeft = 0\r\n                    theRight = 0\r\n                result += self.addSpace2(theLeft) + c.replace(\'_\',\' \').upper() + self.addSpace2(theRight) + self.columnTab\r\n            if alignment == \'left\':\r\n                result += c.replace(\'_\',\' \').upper() + self.addSpace(c,tabFix) + self.columnTab\r\n            if alignment == \'right\':\r\n                result += self.addSpace(c,tabFix) + c.replace(\'_\',\' \').upper() + self.columnTab\r\n            # else:\r\n                # result += c.replace(\'_\',\' \').upper() + self.addSpace(c,tabFix) + self.columnTab\r\n        \r\n        if switches.isActive(\'YesTableLines\'):\r\n            result += \'|\'\r\n            if len(switches.value(\'YesTableLines\')):\r\n                newResult = \'\\n\'\r\n                for x in result.replace(\' |\',\'| \'):\r\n                    if x == \'|\':\r\n                        newResult+=x\r\n                    else:\r\n                        newResult+=\'-\'\r\n                newResult = _str.cleanEnd(newResult,\'-\')\r\n                result+=newResult\r\n\r\n                # for c in column.split(\',\'):\r\n                    # result += \'|\'+self.addSpace(c,tabFix).replace(\' \',\'-\') + self.columnTab.replace(\' \',\'-\')\r\n                    # result += \'|\'+self.addSpace(c,tabFix).replace(\' \',\'-\')\r\n\r\n\r\n        if switches.isActive(\'YesTableLines\'):\r\n            result = result.replace(\' |\',\'| \')\r\n        else:\r\n            result += \'\\n\'\r\n        return \'\\n\'+result\r\n\r\n    def findColumName( self, column ):\r\n        for k in self.asset[0].keys():\r\n            if k.lower() == column.lower():\r\n                return k\r\n        for k in self.asset[0].keys():\r\n            if k.lower() == column.split(\'.\')[0].lower():\r\n                return column\r\n\r\n\r\n\r\n\r\n    def prefixSize( self ):\r\n        pre = \'\'\r\n        for x in self.tab[\'table\']+loopPrint(__.table_prefix_padding):\r\n            if x == \'\\t\':\r\n                pre += \'    \'\r\n            else:\r\n                pre += x\r\n        return len(pre)\r\n\r\n\r\n    def wrapTable( self, cols=None ):\r\n        # return None\r\n\r\n        if not __.terminal.width:\r\n            return None\r\n\r\n        cols = __.terminal.width\r\n        cols -= 8\r\n        spaces = []\r\n        theKeys = []\r\n        for c in self.spaces:\r\n            theKeys.append(c)\r\n            spaces.append({ \'c\': c, \'s\': self.spaces[c] })\r\n\r\n        spaces = sorted(spaces, key=lambda d: (d[\'s\']))\r\n        spaces.reverse()\r\n\r\n        fieldsToShorten = []\r\n\r\n        if not len(switches.value(\'WrapTable\')):\r\n            fieldsToShorten.append( spaces[0][\'c\'] )\r\n            if len( self.spaces.keys() ) > 1:\r\n                diff = percentageDiffIntAuto( spaces[0][\'s\'], spaces[1][\'s\'] )\r\n                if diff >= 50:\r\n                    fieldsToShorten.append( spaces[1][\'c\'] )\r\n                # print_( \'diff:\', diff )\r\n\r\n                if len( self.spaces.keys() ) > 2:\r\n                    diff = percentageDiffIntAuto( spaces[0][\'s\'], spaces[2][\'s\'] )\r\n                    if diff >= 50:\r\n                        fieldsToShorten.append( spaces[2][\'c\'] )\r\n                    # print_( \'diff:\', diff )\r\n        elif len(switches.value(\'WrapTable\')):\r\n            done = False\r\n            if len(switches.values(\'WrapTable\')) == 1:\r\n                done = False\r\n                wrapBy = switches.value(\'WrapTable\')\r\n                if wrapBy in self.asset[0].keys():\r\n                    done = True\r\n                if not done:\r\n                    if formatColumns(wrapBy) in self.asset[0].keys():\r\n                        wrapBy = formatColumns(wrapBy)\r\n                        done = True\r\n\r\n                if not done:\r\n                    wrapBy = 0\r\n                    try:\r\n                        wrapBy = int(switches.value(\'WrapTable\'))\r\n                    except Exception as e:\r\n                        wrapBy = 0\r\n                    if wrapBy > 0:\r\n                        done = True\r\n            elif len(switches.values(\'WrapTable\')) > 1:\r\n                wrapBy = []\r\n                for xx in switches.values(\'WrapTable\'):\r\n                    y = formatColumns(xx)\r\n                    if y in self.asset[0].keys():\r\n                        wrapBy.append(y)\r\n                        done = True\r\n\r\n            if done:\r\n                if type(wrapBy) == str:\r\n                    fieldsToShorten.append( wrapBy )\r\n                if type(wrapBy) == list:\r\n                    for yy in wrapBy:\r\n                        fieldsToShorten.append( yy )\r\n                if type(wrapBy) == int:\r\n                    for isp, itx in enumerate(spaces):\r\n                        fieldsToShorten.append( itx[\'c\'] )\r\n                        \r\n                        if isp+1 == wrapBy:\r\n                            break\r\n\r\n                # print_(type(wrapBy))\r\n                # print_(wrapBy)\r\n                # sys.exit()\r\n\r\n                    \r\n\r\n\r\n        # print_(fieldsToShorten)\r\n        # sys.exit()\r\n\r\n        maxLen = self.maxNameLength\r\n        total = self.prefixSize()\r\n        for c in self.spaces:\r\n            total += self.spaces[c]\r\n            total += len(self.columnTab)\r\n        \r\n        tempSpaces = self.spaces.copy()\r\n        for c in tempSpaces:\r\n            if tempSpaces[c] > maxLen:\r\n                if not c in fieldsToShorten:\r\n                    fieldsToShorten.append(c)\r\n\r\n        while total > cols:\r\n            hasGrtMax = False\r\n\r\n            for fs in fieldsToShorten:\r\n                if tempSpaces[fs] > maxLen:\r\n                    hasGrtMax = True\r\n                    tempSpaces[fs] -=1\r\n            if not hasGrtMax:\r\n                for fs in fieldsToShorten:\r\n                    tempSpaces[fs] -=1\r\n\r\n            total = self.prefixSize()\r\n            for c in tempSpaces:\r\n                total += tempSpaces[c]\r\n                total += len(self.columnTab)\r\n        \r\n\r\n\r\n        # percentageDiffIntAuto\r\n        # printVarSimple( self.spaces )\r\n        # print_( \'---------\' )\r\n        # printVarSimple( tempSpaces )\r\n        # for x in spaces:\r\n        #   print_(x)\r\n\r\n        wrapTableKey = self.wrapTableKey\r\n        \r\n        counter = 0\r\n        global fields\r\n        fields.register( wrapTableKey+\'-b\', \'val\', 4, m=4 )\r\n        fields.register( wrapTableKey, \'val\', 7, m=12 )\r\n        test = fields.padZeros( wrapTableKey, \'val\', 5 )\r\n        test = fields.padZeros( wrapTableKey+\'-b\', \'val\', 5 )\r\n        letters = {}\r\n        \r\n\r\n        # print_(letterSet)\r\n        # sys.exit()\r\n        def letterBoost( i ):\r\n            if not str(i) in letters:\r\n                letters[str(i)] = \'a\'\r\n        \r\n\r\n        recordsToAdd = []\r\n        for i,record in enumerate(self.asset):\r\n            letters[ str(i) ] = \'a\'\r\n            recordKey = 1\r\n            \r\n\r\n            this_key = fields.padZeros( wrapTableKey, \'val\', i+1 )\r\n            this_key_B = fields.padZeros( wrapTableKey+\'-b\', \'val\', recordKey )\r\n\r\n            \r\n            self.asset[i][wrapTableKey+\'-sort\'] = this_key+\'-\'+this_key_B\r\n            rec = {}\r\n            rec_last = {}\r\n            for c in tempSpaces:\r\n\r\n                if c in record and len( str(record[c]) ) > tempSpaces[c]:\r\n                    # rec[c] = {}\r\n                    recordKey = 1\r\n                    # cs = fields.padZeros( wrapTableKey+\'-b\', \'val\', recordKey )\r\n                    # # print_(cs)\r\n                    # if not cs in rec:\r\n                    #   rec[cs] = {}\r\n                    # if not c in rec[cs]:\r\n                    #   rec[cs][c] = \'\'\r\n                    \r\n                    rec_parts = autoWrapText( str(record[c]), length=tempSpaces[c] )\r\n\r\n                    # print_(\'_________________________________________\')\r\n                    # print_()\r\n                    # print_(record[c])\r\n                    # print_()\r\n                    # print_(rec_parts)\r\n                    # print_()\r\n                    # print_(\'_________________________________________\')\r\n                    rp = \'\'\r\n                    last_rp = \'\'\r\n                    for rp in rec_parts:\r\n                        if len(rp) and not last_rp == rp:\r\n                            last_rp = rp\r\n                            cs = fields.padZeros( wrapTableKey+\'-b\', \'val\', recordKey )\r\n                            recordKey += 1\r\n                            if not cs in rec:\r\n                                rec[cs] = {}\r\n                            if not cs in rec_last:\r\n                                rec_last[cs] = {}\r\n                            # if not c in rec[cs]:\r\n                                # rec[cs][c] = \'\'\r\n                            \r\n                            # if c in rec_last[cs]:\r\n                            #   if \r\n                            rec[cs][c] = rp\r\n                    rp = \'\'\r\n\r\n                    # for x in record[c]:\r\n                    #   rec[cs][c] += x\r\n                    #   if len( rec[cs][c] ) > tempSpaces[c]:\r\n                    #       recordKey += 1\r\n                    #       cs = fields.padZeros( wrapTableKey+\'-b\', \'val\', recordKey )\r\n                    #       # print_(cs)\r\n                    #       if not cs in rec:\r\n                    #           rec[cs] = {}\r\n                    #       if not c in rec[cs]:\r\n                    #           rec[cs][c] = \'\'\r\n                    # printVarSimple(rec)\r\n                    # sys.exit()\r\n            if rec:\r\n                for iii,xXx in enumerate(rec):\r\n                    if xXx == \'0001\':\r\n                        for c in rec[xXx]:\r\n                            self.asset[i][c] = rec[xXx][c]\r\n                    else:\r\n                        # print_(xXx)\r\n                        rec[xXx][wrapTableKey+\'-sort\'] = this_key +\'-\'+ xXx\r\n                        recordsToAdd.append(rec[xXx])\r\n                    # print_(rec[x])\r\n                # print_(rec)\r\n\r\n        for rec in recordsToAdd:\r\n            self.asset.append(rec)\r\n            # print_(rec)\r\n        # sys.exit()\r\n        self.spaces = {}\r\n\r\n\r\n        groupBy = switches.values(\'GroupBy\')\r\n        last = {}\r\n        for gb in groupBy:\r\n            last[gb] = \'{7270D97A-CC1D-4365-9545-87CA34F2F026}\'\r\n\r\n\r\n\r\n        for i,record in enumerate(self.asset):\r\n            ks = list(record.keys())\r\n            for k in theKeys:\r\n                if not k in ks:\r\n                    self.asset[i][k] = \'\'\r\n            for k in theKeys:\r\n                if not k in self.spaces:\r\n                    self.spaces[k] = 0\r\n                if len(str(record[k])) > self.spaces[k]:\r\n                    self.spaces[k] = len(str(record[k]))\r\n\r\n\r\n        # for i,record in enumerate(self.asset):\r\n        #   for gb in groupBy:\r\n        #       if gb in self.asset[i]:\r\n        #           if self.asset[i][gb] == last[gb]:\r\n        #               self.asset[i][gb] = \'\'\r\n        #           else:\r\n        #               last[gb] = self.asset[i][gb]\r\n        self.asset = sorted(self.asset, key=lambda d: (d[wrapTableKey+\'-sort\']))\r\n\r\n\r\n        # for x in self.asset:\r\n        #   print_()\r\n        #   print_(x)\r\n        #   print_()\r\n\r\n\r\n\r\n\r\n        # for i,record in enumerate(self.asset):\r\n        #   print_( record[wrapTableKey+\'-sort\'] )\r\n        # sys.exit()\r\n        # print_(self.asset)\r\n        # for x in self.asset:\r\n        #   print_()\r\n        #   print_(x)\r\n        #   print_()\r\n        # sys.exit()\r\n        \r\n        self.print(\r\n                    column=self.print_backup[\'column\'],\r\n                    fieldLengths=self.print_backup[\'fieldLengths\'],\r\n                    pc=self.print_backup[\'pc\'],\r\n                    printColumns=self.print_backup[\'printColumns\'],\r\n                    force=True\r\n        )\r\n\r\n\r\n\r\n\r\n    def aggregateRecord( self, i ):\r\n        # print_()\r\n        \r\n        for c in self.aggregates.columns:\r\n            if not c in self.asset[i]:\r\n                self.asset[i][c] = \'\'\r\n\r\n        for seg in self.aggregates.segments:\r\n            if seg[\'status\']:\r\n                record = self.aggregate_record_process( i, seg[\'i\'] )\r\n\r\n\r\n    def aggregateTop( self, s ):\r\n        ss = str(s)\r\n        if self.aggregates.index[ss][\'rent\'] >= 0:\r\n            return self.aggregateTop(self.aggregates.index[ss][\'rent\'])\r\n        else:\r\n            return self.aggregates.index[ss]\r\n\r\n\r\n    def aggregateItemValue( self, v, f ):\r\n        if not \'params\' in v:\r\n            v[\'params\'] = {}\r\n        if not \'fields\' in v:\r\n            v[\'fields\'] = {}\r\n        if not \'data\' in v:\r\n            v[\'data\'] = []\r\n\r\n        # print_( self.aggregate_backtrack )\r\n\r\n        if \'data\' in f:\r\n            v[\'data\'].append( f[\'data\'] )\r\n        if \'fields\' in f:\r\n            if not \'fields\' in v:\r\n                v[\'fields\'] = {}\r\n            for k in f[\'fields\']:\r\n                v[\'fields\'][k] = f[\'fields\'][k]\r\n        elif \'params\' in f:\r\n            if not \'params\' in v:\r\n                v[\'params\'] = {}\r\n            for k in f[\'params\']:\r\n                v[\'params\'][k] = f[\'params\'][k]\r\n        return v\r\n\r\n    def aggregate_record_process_group( self, i, s ):\r\n        ss = str(s)\r\n        seg = self.aggregates.index[ss]\r\n        if \'variable\' in seg[\'l\']:\r\n            alpha = seg[\'l\']\r\n            if \'?\' in seg[\'txt\'] and seg[\'txt\'].lower().split(\'?\')[0]+\'?\' in __.aggregate.group_prefixes:\r\n                txtParts = seg[\'txt\'].split(\'?\')\r\n                grp = txtParts[0]+\'?\'\r\n                fld = txtParts[1]\r\n                lbl = txtParts[2]\r\n                if not lbl in self.aggregates.group_storage:\r\n                    self.aggregates.group_storage[lbl] = 0\r\n\r\n\r\n                data = self.aggregate_record_process( i, seg[\'val\'] )\r\n                child = self.aggregates.index[ str(seg[\'val\']) ]\r\n                do = None\r\n                if \'function\' in child[\'l\']:\r\n                    do = child[\'txt\']\r\n                    done = False\r\n                    if do == \'max\':\r\n                        done = True;\r\n                        try:\r\n                            if data[\'data\'] > self.aggregates.group_storage[lbl]:\r\n                                self.aggregates.group_storage[lbl] = data[\'data\']\r\n                        except Exception as e: cp(\'Error: group max variable\', \'red\');\r\n\r\n                    if do == \'add\':\r\n                        done = True;\r\n                        try:\r\n                            self.aggregates.group_storage[lbl] += data[\'data\']\r\n                        except Exception as e: cp(\'Error: group add variable\', \'red\');\r\n                    \r\n                    # if not done:\r\n                    #   self.aggregates.group_storage[lbl] = data[\'data\']\r\n\r\n                pass\r\n\r\n\r\n                \r\n                pass\r\n\r\n                if i in self.aggregates.groups[fld][\'e\']:\r\n                    if  __.aggregate.group_prefixes[  seg[\'txt\'].lower().split(\'?\')[0]+\'?\'  ] == 3:\r\n                        self.asset[  self.aggregates.groups[fld][\'e\'][i]  ][lbl] = addComma( self.aggregates.group_storage[lbl] )\r\n                    else:\r\n                        if tfc(lbl) in self.backup.NGfields:\r\n                            if not str(i) in self.aggregates.agroupsADD:\r\n                                self.aggregates.agroupsADD[ str(i) ] = {}\r\n                            self.aggregates.agroupsADD[ str(i) ][lbl] = self.aggregates.group_storage[lbl]\r\n                        else:           \r\n                            self.asset[i][lbl] = addComma( self.aggregates.group_storage[lbl] )\r\n                    if not __.aggregate.group_prefixes[  seg[\'txt\'].lower().split(\'?\')[0]+\'?\'  ] == 2:\r\n                        self.aggregates.group_storage[lbl] = 0\r\n            \r\n\r\n\r\n        # if self.aggregates.groups:\r\n        #   printVarSimple(self.aggregates.groups)\r\n        #   print_( list( self.asset[0].keys() ) )\r\n        #   sys.exit()\r\n\r\n\r\n    def aggregate_record_process( self, i, s ):\r\n\r\n        ss = str(s)\r\n        if True:\r\n            seg = self.aggregates.index[ss]\r\n            # print_(seg)\r\n            \r\n            # self.aggregate_backtrack = { \'i\': i, \'s\': s, \'seg\': seg }\r\n\r\n\r\n            if \'alpha\' in seg[\'l\'] and \'arg\' in seg[\'l\'] :\r\n                simple_keys = {}\r\n                for key in list(self.asset[i].keys()):\r\n                    simple_keys[ tfc(key) ] = key\r\n                if tfc(formatColumns( seg[\'txt\'] )) in simple_keys:\r\n                    vXv = simple_keys[tfc(formatColumns( seg[\'txt\'] ))]\r\n                    return { \'fields\': { vXv: self.asset[i][vXv] }, \'data\': self.asset[i][vXv] }\r\n\r\n                elif formatColumns( seg[\'txt\'] ) in self.asset[i]:\r\n                    return { \'fields\': { formatColumns( seg[\'txt\'] ): self.asset[i][formatColumns( seg[\'txt\'] )] }, \'data\': self.asset[i][formatColumns( seg[\'txt\'] )] }\r\n                return { \'params\': { seg[\'txt\']: 1 } }\r\n\r\n\r\n\r\n            if \'variable\' in seg[\'l\']:\r\n                alpha = seg[\'l\']\r\n                isOF = False\r\n                data = self.aggregate_record_process( i, seg[\'val\'] )\r\n                if \'?\' in seg[\'txt\'] and  seg[\'txt\'].lower().split(\'?\')[0]+\'?\' in __.aggregate.prefixes:\r\n                    isOF = True\r\n                    if \'?\' in seg[\'txt\'] and seg[\'txt\'].lower().split(\'?\')[0]+\'?\' in __.aggregate.group_prefixes:\r\n                        return None\r\n                    if seg[\'txt\'].startswith(\'eot?\'):\r\n                        if not seg[\'txt\'] in self.aggregates.storage:\r\n                            self.aggregates.storage[ seg[\'txt\'] ] = {}\r\n                        if not alpha in self.aggregates.storage[seg[\'txt\']]:\r\n                            self.aggregates.storage[seg[\'txt\']][alpha] = {}\r\n                            self.aggregates.storage[seg[\'txt\']][alpha][\'data\'] = 0\r\n                            self.aggregates.storage[seg[\'txt\']][alpha][\'settings\'] = {}\r\n                    if seg[\'txt\'].startswith(\'eof?\'):\r\n                        # print_( seg[\'txt\'] ); sys.exit();\r\n                        if not seg[\'txt\'] in __.aggregate.eof.storage:\r\n                            __.aggregate.eof.storage[ seg[\'txt\'] ] = {}\r\n                        if not alpha in __.aggregate.eof.storage[seg[\'txt\']]:\r\n                            __.aggregate.eof.storage[seg[\'txt\']][alpha] = {}\r\n                            __.aggregate.eof.storage[seg[\'txt\']][alpha][\'data\'] = 0\r\n                            __.aggregate.eof.storage[seg[\'txt\']][alpha][\'settings\'] = {}\r\n                    \r\n                    \r\n                    # print_(isOF, seg[\'txt\'])\r\n\r\n                \r\n                    child = self.aggregates.index[ str(seg[\'val\']) ]\r\n                    do = None\r\n                    if \'function\' in child[\'l\']:\r\n                        do = child[\'txt\']\r\n\r\n\r\n                    if seg[\'txt\'].startswith(\'eot?\'):\r\n                        done = False\r\n                        if do == \'max\':\r\n                            done = True;\r\n                            try:\r\n                                if data[\'data\'] > self.aggregates.storage[seg[\'txt\']][alpha][\'data\']:\r\n                                    self.aggregates.storage[seg[\'txt\']][alpha][\'data\'] = data[\'data\']\r\n                            except Exception as e: cp(\'Error: max variable\', \'red\');\r\n\r\n                        if do == \'add\':\r\n                            done = True;\r\n                            try:\r\n                                self.aggregates.storage[seg[\'txt\']][alpha][\'data\'] += data[\'data\']\r\n                            except Exception as e: cp(\'Error: add variable\', \'red\');\r\n\r\n                        \r\n                        if not done:\r\n                            self.aggregates.storage[seg[\'txt\']][alpha][\'data\'] = data[\'data\']\r\n                            \r\n                    elif seg[\'txt\'].startswith(\'eof?\'):\r\n                        done = False\r\n                        if do == \'max\':\r\n                            done = True;\r\n                            try:\r\n                                if data[\'data\'] > __.aggregate.eof.storage[seg[\'txt\']][alpha][\'data\']:\r\n                                    __.aggregate.eof.storage[seg[\'txt\']][alpha][\'data\'] = data[\'data\']\r\n                            except Exception as e: cp(\'Error: max variable\', \'red\');\r\n\r\n                        if do == \'add\':\r\n                            done = True;\r\n                            try:\r\n                                __.aggregate.eof.storage[seg[\'txt\']][alpha][\'data\'] += data[\'data\']\r\n                            except Exception as e: cp(\'Error: add variable\', \'red\');\r\n                        \r\n                        if not done:\r\n                            __.aggregate.eof.storage[seg[\'txt\']][alpha][\'data\'] = data[\'data\']\r\n                \r\n                else:\r\n                    # print_( i, seg[\'txt\'], data[\'data\'] )\r\n                    self.asset[i][seg[\'txt\']] = data[\'data\']\r\n\r\n                    \r\n\r\n                    return data\r\n                return { \'data\': \'\' }\r\n            if \'function\' in seg[\'l\']:\r\n                ###########################################################################################################\r\n                if seg[\'txt\'] == \'trigger\':\r\n                    pass\r\n\r\n                # { \'fields\': {  \'field\': 123, \'data\': 123 } }  { \'params\': {  \'param\': 1  } }\r\n                if seg[\'txt\'] == \'add\':\r\n                    result = 0; v = {};\r\n                    for s in seg[\'args\']:\r\n                        f = self.aggregate_record_process( i, s ); v = self.aggregateItemValue( v, f );\r\n                    if \'data\' in v:\r\n                        if type(v[\'data\']) == list:\r\n                            for d in v[\'data\']:\r\n                                try:\r\n                                    result += float( d )\r\n                                except Exception as e: pass;\r\n                        else:\r\n                            try:\r\n                                result += float( v[\'data\'] )\r\n                            except Exception as e: pass;\r\n                    if str(result).endswith(\'.0\'):\r\n                        result = int(result)\r\n                    return { \'data\': result }\r\n\r\n\r\n\r\n                # { \'fields\': {  \'field\': 123, \'data\': 123 } }  { \'params\': {  \'param\': 1  } }\r\n                if seg[\'txt\'] == \'int\':\r\n                    result = 0; v = {};\r\n                    for s in seg[\'args\']:\r\n                        f = self.aggregate_record_process( i, s ); v = self.aggregateItemValue( v, f );\r\n                    if \'data\' in v:\r\n                        nX = []\r\n                        if type(v[\'data\']) == list:\r\n                            for d in v[\'data\']:\r\n                                for cn in str(d):\r\n                                    if cn in \'0123456789.\':\r\n                                        nX.append(cn)\r\n                        else:\r\n                            for cn in str(v[\'data\']):\r\n                                if cn in \'0123456789.\':\r\n                                    nX.append(cn)\r\n                    result = float(\'\'.join(nX))\r\n                    if str(result).endswith(\'.0\'):\r\n                        result = int(result)\r\n                    # print_(result)\r\n                    return { \'data\': result }\r\n\r\n\r\n\r\n                # { \'fields\': {  \'field\': 123, \'data\': 123 } }  { \'params\': {  \'param\': 1  } }\r\n                if seg[\'txt\'] == \'len\':\r\n                    result = 0; v = {};\r\n                    for s in seg[\'args\']:\r\n                        f = self.aggregate_record_process( i, s ); v = self.aggregateItemValue( v, f );\r\n                    if \'data\' in v:\r\n                        if type(v[\'data\']) == list:\r\n                            for d in v[\'data\']:\r\n                                # print_( \'len-d:\', d )\r\n                                result += len( str( d ) )\r\n                        else:\r\n                            # print_( \'len-vd:\', v[\'data\'] )\r\n                            result += len( str( v[\'data\'] ) )\r\n                    # print_( \'len-v\', v )\r\n                    if str(result).endswith(\'.0\'):\r\n                        result = int(result)\r\n                    return { \'data\': result }\r\n\r\n\r\n\r\n                # { \'fields\': {  \'field\': 123, \'data\': 123 } }  { \'params\': {  \'param\': 1  } }\r\n                if seg[\'txt\'] == \'max\':\r\n                    result = []; v = {};\r\n                    for s in seg[\'args\']:\r\n                        f = self.aggregate_record_process( i, s ); v = self.aggregateItemValue( v, f ); \r\n                    for d in v[\'data\']:\r\n                        if \'?date\' in v[\'params\']:\r\n                            try:\r\n                                ad = autoDate( d )\r\n                            except Exception as e: ad = 0;\r\n                            result.append(ad)\r\n                        else:\r\n                            try:\r\n                                ad = float( d )\r\n                            except Exception as e: ad = 0;\r\n                            result.append(ad)\r\n                    result.sort()\r\n                    result.reverse()\r\n\r\n                    return { \'data\': result[0] }\r\n\r\n\r\n                if seg[\'txt\'] == \'config\':\r\n                    result = []; v = {};\r\n                    for s in seg[\'args\']:\r\n                        f = self.aggregate_record_process( i, s ); v = self.aggregateItemValue( v, f ); \r\n                    for par in v[\'params\']:\r\n                        result.append(par)\r\n                    suffix = \'\'\r\n                    for par in result:\r\n                        suff = "[\'"+par+"\']"\r\n                        suffix += suff\r\n                        try:\r\n                            eval( \'__.aggregate.config\'+suffix  )\r\n                        except Exception as e:\r\n                            exec( \'__.aggregate.config\'+suffix+\' = { }\'  )\r\n                    # printVarSimple(__.aggregate.config)\r\n                    # sys.exit()\r\n\r\n                pass\r\n                if seg[\'txt\'] == \'format\':\r\n                    result = []; v = {};\r\n                    for s in seg[\'args\']:\r\n                        f = self.aggregate_record_process( i, s ); v = self.aggregateItemValue( v, f ); \r\n                    for par in v[\'params\']:\r\n                        result.append(par)\r\n                    suffix = \'\'\r\n                    for par in result:\r\n                        suff = "[\'"+par+"\']"\r\n                        suffix += suff\r\n                        # print_( \'suffix:\', suffix )\r\n                        try:\r\n                            eval( \'__.aggregate.format\'+suffix  )\r\n                        except Exception as e:\r\n                            exec( \'__.aggregate.format\'+suffix+\' = { }\'  )\r\n\r\n\r\n\r\n                # { \'fields\': {  \'field\': 123, \'data\': 123 } }  { \'params\': {  \'param\': 1  } }\r\n                if seg[\'txt\'] == \'isDate\':\r\n                    result = None; v = {};\r\n                    for s in seg[\'args\']:\r\n                        f = self.aggregate_record_process( i, s ); v = self.aggregateItemValue( v, f );\r\n                    if \'data\' in v:\r\n                        if type(v[\'data\']) == list:\r\n                            for d in v[\'data\']:\r\n                                try:\r\n                                    result = autoDate( d )\r\n                                except Exception as e: pass;\r\n                        else:\r\n                            try:\r\n                                result = autoDate( v[\'data\'] )\r\n                            except Exception as e: pass;\r\n                    \r\n                    if not result is None:\r\n                        try:\r\n                            global _dir\r\n                        except Exception as e:\r\n                            pass\r\n                        if _dir is None:\r\n                            import _rightThumb._dir as _dir\r\n                        # print_( result )\r\n                        # self.asset[i][\'month\'] = _dir.getMonthFromEpoch( result )\r\n                        # self.asset[i][\'year\'] = _dir.getYearFromEpoch( result )\r\n                        # self.asset[i][\'woy\'] = _dir.getWeekAndYear( result )\r\n                        # self.asset[i][\'dow\'] = _dir.getDOWromEpochText( result )\r\n                        # self.asset[i][\'ago\'] = _dir.dateDiffText( result )\r\n                        self.asset[i] = isDate( result, self.asset[i] )\r\n                        \r\n                        # month year woy dow ago\r\n                         \r\n\r\n                        month = _dir.getMonthFromEpoch\r\n                        # year = _dir.getYearFromEpoch\r\n                        # woy = _dir.getWOYFromEpoch\r\n                        # dow = _dir.getDOWromEpochText\r\n                        # ago = _dir.dateDiffText\r\n                    return { \'data\': None }\r\n\r\n\r\n\r\n                # { \'fields\': {  \'field\': 123, \'data\': 123 } }  { \'params\': {  \'param\': 1  } }\r\n                if seg[\'txt\'] == \'file\':\r\n                    result = \'\'; v = {};\r\n                    for s in seg[\'args\']:\r\n                        f = self.aggregate_record_process( i, s ); v = self.aggregateItemValue( v, f );\r\n                    if \'data\' in v:\r\n                        if type(v[\'data\']) == list:\r\n                            for d in v[\'data\']:\r\n                                try:\r\n                                    result = d\r\n                                except Exception as e: pass;\r\n                        else:\r\n                            try:\r\n                                result = v[\'data\']\r\n                            except Exception as e: pass;\r\n\r\n\r\n                    # global _dir\r\n                    if _dir is None:\r\n                        import _rightThumb._dir as _dir\r\n                    # info = _dir.info( _str.cleanBE( result, \' \' ).replace( \'\\t\', \'\' ) )\r\n                    # print_( info )\r\n                    try:\r\n                        info = _dir.info( _str.cleanBE( result, \' \' ).replace( \'\\t\', \'\' ) )\r\n                    except Exception as e:\r\n                        info = {\r\n                                    "path": "",\r\n                                    "name_": "",\r\n                                    "name": "",\r\n                                    "folder": "",\r\n                                    "bytes": 0,\r\n                                    "size": "",\r\n                                    "date_created_raw": 0,\r\n                                    "date_modified_raw": 0,\r\n                                    "date_created": "",\r\n                                    "date_modified": "",\r\n                                    "type": "File",\r\n                                    "typesort": 1,\r\n                                    "ext": "txt",\r\n                                    "week_of_year": "",\r\n                                    "week_of_year_": 0,\r\n                                    "day_of_the_week": "",\r\n                                    "month": "",\r\n                                    "friendly_week": "",\r\n                                    "friendly_month": "",\r\n                                    "md5": "",\r\n                                    "year": 2021,\r\n                                    "accessed_raw": 0,\r\n                                    "date_accessed": "",\r\n                                    "ce": 0,\r\n                                    "me": 0,\r\n                                    "ae": 0,\r\n                                    "meta": {},\r\n                                    "ago": "",\r\n                                    "header": "",\r\n                                    "error": 0\r\n                                }\r\n                    \r\n                    for k in info:\r\n                        if not k in self.asset[i]:\r\n                            self.asset[i][k] = info[k]\r\n\r\n                    return { \'data\': result }\r\n\r\n\r\n\r\n\r\n                # { \'fields\': {  \'field\': 123, \'data\': 123 } }  { \'params\': {  \'param\': 1  } }\r\n                ###########################################################################################################\r\n\r\n\r\n\r\n    def aggregateBuild( self ):\r\n        if self.aggregate_processed:\r\n            return None\r\n        \r\n        self.aggregate_processed = True\r\n\r\n\r\n        a = \' \'.join( switches.values(\'Aggregate\') )\r\n        # print_( a )\r\n\r\n        \r\n        self.aggregates = dot()\r\n\r\n        \r\n        self.aggregates.storage = {}\r\n        self.aggregates.group_storage = {}\r\n        # self.aggregates.segments = __.code.process( a, addString=[[\'alphaParam\',\'?\']] )\r\n        # self.aggregates.segments = __.aggregate.data.records\r\n        self.aggregates.segments = __.aggregate.obj.build( self.name, addSwitch=True )\r\n\r\n        self.aggregates.index = {}\r\n\r\n        self.aggregates.groups = {}\r\n        self.aggregates.agroups = {}\r\n        self.aggregates.agroupsADD = {}\r\n        self.aggregates.columns = []\r\n        for rec in self.aggregates.segments:\r\n            self.aggregates.index[ str(rec[\'i\']) ] = rec\r\n            if rec[\'status\'] and rec[\'l\'] == \'variable\':\r\n                # if not rec[\'txt\'].startswith(\'eot?\'):\r\n                # if not rec[\'txt\'].startswith(\'eot?\') and not rec[\'txt\'].startswith(\'eof?\') and not rec[\'txt\'].startswith(\'eog?\') and  not rec[\'txt\'].startswith(\'bog?\') and  not rec[\'txt\'].lower().startswith(\'eoga?\'):\r\n                if not \'?\' in rec[\'txt\'] or ( \'?\' in rec[\'txt\'] and not rec[\'txt\'].lower().split(\'?\')[0]+\'?\' in __.aggregate.prefixes):\r\n                    self.aggregates.columns.append( rec[\'txt\'] )\r\n                    if not rec[\'txt\'] in self.backup.allfields:\r\n                        self.backup.allfields[ rec[\'txt\'] ] = rec[\'txt\']\r\n                        self.backup.NGfields[ rec[\'txt\'] ] = rec[\'txt\']\r\n        for rec in self.aggregates.segments:\r\n            if rec[\'status\'] and rec[\'l\'] == \'variable\':\r\n                if not \'?\' in rec[\'txt\'] or ( \'?\' in rec[\'txt\'] and not rec[\'txt\'].lower().split(\'?\')[0]+\'?\' in __.aggregate.prefixes):\r\n                    pass\r\n                elif \'?\' in rec[\'txt\'] and rec[\'txt\'].lower().split(\'?\')[0]+\'?\' in __.aggregate.group_prefixes:\r\n                # elif \'g?\' in rec[\'txt\']:\r\n                    self.aggregates.agroups[ rec[\'i\'] ] = rec\r\n                    \r\n                    try:\r\n                        gc = rec[\'txt\'].split(\'?\')[2]\r\n\r\n                    except Exception as e:\r\n                        cp( \'Error: aggregates, group split\', \'red\' )\r\n                        sys.exit()\r\n                    else:\r\n                        self.aggregates.columns.append( gc )\r\n                    if not gc in self.backup.allfields:\r\n                        self.backup.allfields[ rec[\'txt\'] ] = gc\r\n\r\n        # self.hasGroups\r\n\r\n        pass\r\n        # print_( self.aggregates.columns )\r\n        # sys.exit()\r\n\r\n\r\n\r\n        # sys.exit()\r\n        # for x in segments:\r\n        #   if x[\'status\']:\r\n        #       cp( x, \'green\' )\r\n        #   else:\r\n        #       cp( x, \'cyan\' )\r\n        #       # print_( x )\r\n\r\n        for i,record in enumerate(self.asset):\r\n            self.aggregateRecord( i )\r\n\r\n\r\n        # sys.exit()\r\n        __.aggregate.storage = self.aggregates.storage\r\n        return self.aggregates.columns\r\n\r\n\r\n    def aggregateRecordGroups( self, i ):\r\n        # print_()\r\n\r\n        for seg in self.aggregates.segments:\r\n            if seg[\'status\']:\r\n                # record = self.aggregate_record_process_group( i, seg[\'i\'] )\r\n                try:\r\n                    record = self.aggregate_record_process_group( i, seg[\'i\'] )\r\n                except Exception as e:\r\n                    cp( \'Error: aggregate, group error\', \'red\' )\r\n                    cp( \'\\t expected:\', \'yellow\' )\r\n                    cp( \'\\t\\t eog?level?group-len=add(len)\', \'green\' )\r\n                    print_()\r\n                    cp( [ \'Specifically:\', e ], \'red\' )\r\n                    print_()\r\n                    sys.exit()\r\n\r\n\r\n\r\n\r\n    def aggregateGroup( self ):\r\n        # NOTE: reprocess after aggregates added        \r\n        for ix in self.aggregates.agroups:\r\n            seg = self.aggregates.agroups[ix]\r\n            q = seg[\'txt\'].split(\'?\')\r\n            subject = q[1]\r\n            # print_( self.asset[0].keys() )\r\n            # print_(subject); sys.exit();\r\n            if subject in self.asset[0] and not subject in self.aggregates.groups:\r\n                self.aggregates.groups[subject] = {}\r\n                self.aggregates.groups[subject][\'b\'] = {}\r\n                self.aggregates.groups[subject][\'e\'] = {}\r\n                lastQ = \'\'\r\n                lastID = -1\r\n                for i,record in enumerate(self.asset):\r\n                    # print_(subject)\r\n                    if subject in record:\r\n                        # print_( record[subject] )\r\n                        if not record[subject] == lastQ:\r\n                            if not lastID == -1:\r\n                                self.aggregates.groups[subject][\'b\'][lastID] = i\r\n                                self.aggregates.groups[subject][\'e\'][i] = lastID\r\n                            lastQ = record[subject]\r\n                            lastID = i\r\n                self.aggregates.groups[subject][\'b\'][lastID] = len(self.asset)-1\r\n                self.aggregates.groups[subject][\'e\'][len(self.asset)-1] = lastID\r\n\r\n        # if self.aggregates.groups:\r\n        #   printVarSimple(self.aggregates.groups)\r\n        #   print_( list( self.asset[0].keys() ) )\r\n        #   sys.exit()\r\n\r\n    def aggregate( self, script ):\r\n        self.hasAggregate = True\r\n        __.aggregate.obj.code( script, label=self.name )\r\n\r\n    def aggregateBuildGroup( self ):\r\n        self.aggregateGroup()\r\n        for i,record in enumerate(self.asset):\r\n            self.aggregateRecordGroups( i )\r\n\r\n        if self.aggregates.agroupsADD:\r\n            \r\n\r\n            fields.register( self.groupID_KEY, \'val\', 7, m=6 )\r\n            test = fields.padZeros( self.groupID_KEY, \'val\', 5 )\r\n            newRecords = []\r\n            for i,record in enumerate(self.asset):\r\n                ii = str(i)\r\n                ix = fields.padZeros( self.groupID_KEY, \'val\', i )\r\n                record[ self.groupID_KEY ] = ix + \'-A\'\r\n                newRecords.append(record)\r\n                if ii in self.aggregates.agroupsADD:\r\n                    rec = self.aggregates.agroupsADD[ii]\r\n                    rec[ self.groupID_KEY ] = ix + \'-B\'\r\n                    for k in self.backup.allfields:\r\n                        if not self.backup.allfields[k] in rec:\r\n                            rec[ self.backup.allfields[k] ] = \'\'\r\n                    newRecords.append(rec)\r\n            self.asset = newRecords\r\n    def print( self, column, fieldLengths=False, pc=None, printColumns=True, force=False, l=None, p=None ):\r\n        global switches\r\n\r\n        if switches.isActive(\'TableJSON\'):\r\n            if len(switches.value(\'TableJSON\')):\r\n                saveTable2( self.asset, switches.values(\'TableJSON\')[0] )\r\n                cp( [ \'saved:\', switches.values(\'TableJSON\')[0] ], \'green\' )\r\n            else:\r\n                # printVarSimple(self.asset)\r\n                print_( d2json(self.asset) )\r\n            return None\r\n\r\n\r\n        if not p is None:\r\n            self.tab[\'table\'] = p\r\n\r\n        if not type(self.asset) == list or len(self.asset) == 0:\r\n            print_(\'Null Set\')\r\n            sys.exit()\r\n\r\n\r\n\r\n\r\n        if not force:\r\n            if not switches.isActive(\'Help\'):\r\n                if switches.isActive(\'Column\'):\r\n                    column = switches.value(\'Column\')\r\n            \r\n                if switches.isActive(\'Sort\'):\r\n                    self.asset = self.sort()\r\n                elif switches.isActive(\'GroupBy\'):\r\n                    \r\n                    switches.fieldSet(\'Sort\',\'active\',True)\r\n                    switches.fieldSet(\'Sort\',\'value\',switches.value(\'GroupBy\'))\r\n                    self.asset = self.sort()\r\n\r\n            pass\r\n            __.aggregate.storage = {}\r\n            __.aggregate.config = {}\r\n            __.aggregate.format = {}\r\n            __.aggregate.prefix = self.tab[\'table\']+loopPrint(__.table_prefix_padding)\r\n            if switches.isActive(\'Aggregate\') or self.hasAggregate:\r\n                aggregate_columns = self.aggregateBuild()\r\n                if  type(aggregate_columns) == list:\r\n                    columns = column.split(\',\')\r\n                    for ac in aggregate_columns:\r\n                        if not ac in columns:\r\n                            columns.append(ac)\r\n                    column = \',\'.join(columns)\r\n                __.aggregate.columns = columns\r\n\r\n                shouldSortAgain = False\r\n                if switches.isActive(\'Sort\'):\r\n                    for sxy in switches.values(\'Sort\'):\r\n                        if sxy in aggregate_columns:\r\n                            shouldSortAgain = True\r\n\r\n                    if shouldSortAgain:\r\n                        self.asset = self.sort()\r\n                self.aggregateBuildGroup()\r\n                for i,record in enumerate(self.asset):\r\n                    for c in record:\r\n                        nw = __.aggregate.obj.format( c, record[c] )\r\n                        if not nw == record[c]:\r\n                            self.asset[i][c] = nw\r\n            pass\r\n            for i,record in enumerate( self.asset ):\r\n                for k in record:\r\n                    if record[k] is None:\r\n                        self.asset[i][k] = \'\'\r\n\r\n\r\n\r\n        if self.webtable and switches.isActive(\'WebTable\') and len(switches.value(\'WebTable\')):\r\n            asset = []\r\n            for record in self.asset:\r\n                rec = {}\r\n                for k in column.split(\',\'):\r\n                    rec[k] = record[k]\r\n                asset.append(rec)\r\n            saveTable( asset, \'web-tmp-\'+switches.values(\'WebTable\')[0]+\'.json\' )\r\n\r\n\r\n        self.isExtraRecord = False\r\n        if force:\r\n            self.isWrap = True\r\n        self.print_backup = {\r\n                                \'column\': column,\r\n                                \'fieldLengths\': fieldLengths,\r\n                                \'pc\': pc,\r\n                                \'printColumns\': printColumns,\r\n        }\r\n        self.isExtraRecord_0001 = {}\r\n        self.isExtraRecord_000x = \'\'\r\n        # print_(\'here\',column)\r\n        if not pc is None:\r\n            printColumns = pc\r\n        self.groupByTrigger()\r\n        if type(fieldLengths) == dict:\r\n            self.universalSpacing = fieldLengths\r\n        # print_(column)\r\n        # print_(self.assets)\r\n        # rows = self.asset\r\n        if not type(self.asset) == list or len(self.asset) == 0:\r\n            print_(\'Null Set\')\r\n            sys.exit()\r\n        global errors\r\n        global switchDefault\r\n        column = column.lower()\r\n        columnSearch = column\r\n        column = \'\'\r\n        for cs in columnSearch.split(\',\'):\r\n            try:\r\n                column += self.findColumName(cs.split(\'=\')[0]) + \',\'\r\n            except Exception as e:\r\n                column += cs + \',\'\r\n                # print_( \'Error: print column\', cs )\r\n                # sys.exit()\r\n            # print_(cs.split(\'=\')[0])\r\n        column = _str.cleanBE(column,\',\')\r\n        # print_(column)\r\n        newData = []\r\n        oldData = []\r\n        if \':\' in column or \'=\' in columnSearch:\r\n            oldData = self.asset\r\n        if \':\' in column:\r\n            depth = []\r\n            flat = []\r\n            for c in column.split(\',\'):\r\n                if not \':\' in c:\r\n                    flat.append(c)\r\n                else:\r\n                    try:\r\n                        found = False\r\n                        i=0\r\n                        for dp in depth:\r\n                            if depth[i][\'parent\'] == c.split(\':\')[0]:\r\n                                found = True\r\n                                dpID = i\r\n                            i+=1\r\n                    except Exception as e:\r\n                        found = False\r\n                    if found:\r\n                        depth[dpID][\'children\'].append(c.split(\':\')[1])\r\n                    else:\r\n                        depth.append({\'parent\': c.split(\':\')[0],\'children\': [c.split(\':\')[1]]})\r\n            \r\n            i = 0\r\n            for data in self.asset:\r\n                r = {}\r\n                for f in flat:\r\n                    r[f] = data[f]\r\n                x = []\r\n                hasRecords = False\r\n                for dp in depth:\r\n                    if len(data[dp[\'parent\']]) > 0:\r\n                        hasRecords = True\r\n                        for dpi in data[dp[\'parent\']]:\r\n                            y = {}\r\n                            hasData = False\r\n                            for dpic in dp[\'children\']:\r\n                                try:\r\n                                    if len(str(dpi[dpic])) > 1:\r\n                                        hasData = True\r\n                                except Exception as e:\r\n                                    pass\r\n                                try:\r\n                                    y[str(dp[\'parent\']) + \':\' + str(dpic)] = dpi[dpic]\r\n                                except Exception as e:\r\n                                    pass\r\n                            for f in flat:\r\n                                y[f] = r[f]\r\n                            if hasData:\r\n                                newData.append(y)\r\n                if not hasRecords:\r\n                    for dpi in data[dp[\'parent\']]:\r\n                        for dpic in dp[\'children\']:\r\n                            r[str(dp[\'parent\']) + \':\' + str(dpic)] = \'\'\r\n                    newData.append(r)\r\n                i+=1\r\n            self.asset = newData\r\n            # print_(newData)\r\n            # print_(\'dasfdasdfasdfadsf\')\r\n\r\n\r\n        newData = []\r\n        if \'=\' in columnSearch:\r\n            for data in self.asset:\r\n                rowInclude = True\r\n                for c in columnSearch.split(\',\'):\r\n                    if rowInclude:\r\n                        if \'=\' in c:\r\n                            cc = c.split(\'=\')\r\n                            string = data[cc[0]]\r\n                            string = _str.cleanBE(string.lower(),\' \')\r\n                            cc[1] = _str.cleanBE(cc[1],\' \')\r\n                            try:\r\n                                dataYes = _str.cleanBE(cc[1].split(\'-\')[0],\' \')\r\n                            except Exception as e:\r\n                                dataYes = \'\'\r\n                            try:\r\n                                dataNo = _str.cleanBE(cc[1].split(\'-\')[1],\' \')\r\n                            except Exception as e:\r\n                                dataNo = \'\'\r\n                            if len(dataYes) > 0:\r\n                                # print_(\'IS\')\r\n                                # print_(dataYes)\r\n                                length = 0\r\n\r\n                                for s in dataYes.split(\' \'):\r\n                                    if rowInclude:\r\n                                        rowInclude = False\r\n                                        if len(s) > 0:\r\n                                            length += 1\r\n                                            # print_(string)\r\n                                            s = s.lower()\r\n                                            cnt = 0\r\n                                            if len(s) > 1 and s[0] == \'*\':\r\n                                                s = s.replace(\'*\',\'\')\r\n                                                if string.endswith(s):\r\n                                                    cnt += 1\r\n                                                    rowInclude = True\r\n                                            elif len(s) > 1 and s[-1] == \'*\':\r\n                                                s = s.replace(\'*\',\'\')\r\n                                                if string.startswith(s):\r\n                                                    # print_(s,string)\r\n                                                    cnt += 1\r\n                                                    rowInclude = True\r\n                                            elif s in string:\r\n                                                cnt += 1\r\n                                                rowInclude = True\r\n                                # print_(length,cnt)\r\n                                # if length == cnt:\r\n                                # if cnt > 0:\r\n                                    # rowInclude = True\r\n                                        # if switches.isActive(\'PlusOr\') == True:\r\n                                        #   if cnt > 0:\r\n                                        #       rowInclude = True\r\n                            if len(dataNo) > 0 and rowInclude:\r\n                                # print_(\'ISNOT\')\r\n                                rowInclude = True\r\n                                try:\r\n                                    for s in dataNo.split(\' \'):\r\n                                        if len(s) > 0:\r\n                                            s = s.lower()\r\n                                            cnt = 0\r\n                                            if len(s) > 1 and s[0] == \'*\':\r\n                                                s = s.replace(\'*\',\'\')\r\n                                                if string.endswith(s):\r\n                                                    cnt += 1\r\n                                            elif len(s) > 1 and s[-1] == \'*\':\r\n                                                s = s.replace(\'*\',\'\')\r\n                                                if string.startswith(s):\r\n                                                    cnt += 1\r\n                                            elif not string.find(ci(s)) == -1:\r\n                                                cnt += 1\r\n                                            # if not string.find(ci(s)) == -1:\r\n                                            if cnt > 0:\r\n                                                rowInclude = False\r\n                                                break\r\n                                except Exception as e:\r\n                                    pass\r\n                if rowInclude:\r\n                    newData.append(data)\r\n            self.asset = newData\r\n            # print_(self.asset)\r\n\r\n\r\n\r\n\r\n\r\n        # if not len(groupByList):\r\n\r\n\r\n        # if not column == False:\r\n            # switches.fieldSet(\'Column\',\'value\',column)\r\n            # column = switches.value(\'Column\')\r\n\r\n        # print_(\'-\',column)\r\n        columnHeader = self.showColumnHeader(column)\r\n        columnHeaderLength = len(columnHeader)\r\n        # print_(columnHeader)\r\n\r\n\r\n        self.groupByList = {}\r\n        try:\r\n            for gb in switches.value(\'GroupBy\').split(\',\'):\r\n                self.groupByList[str(gb)] = \'\'\r\n        except Exception as e:\r\n            pass\r\n\r\n\r\n\r\n        if not force and not switches.isActive(\'NoWrapTable\'):\r\n\r\n            if __.terminal.width:\r\n                maxSize = 0\r\n                i=0\r\n                for item in self.asset:\r\n                    result = \'\'\r\n                    for c in column.split(\',\'):\r\n                        try:\r\n                            result += self.showColumn(c,i,columnHeaderLength) + self.columnTab\r\n                        except Exception as e:\r\n                            pass\r\n                    # print_(result)\r\n                    maxSize = len(result)+self.prefixSize()\r\n                    i+=1\r\n\r\n\r\n                # print_( maxSize )\r\n                if maxSize > __.terminal.width and not switches.isActive(\'NoWrapTable\'):\r\n                    self.wrapTable(__.terminal.width)\r\n                    # print_( \'error\' )\r\n                    # sys.exit()\r\n                    return None\r\n\r\n\r\n        pass\r\n        self.groupByList = {}\r\n        try:\r\n            for gb in switches.value(\'GroupBy\').split(\',\'):\r\n                self.groupByList[str(gb)] = \'\'\r\n        except Exception as e:\r\n            pass\r\n\r\n\r\n        if printColumns:\r\n            if switches.isActive(\'YesTableLines\'):\r\n                columnHeader = self.tab[\'table\']+loopPrint(__.table_prefix_padding) + columnHeader\r\n            else:\r\n                columnHeader = self.tab[\'table\']+loopPrint(__.table_prefix_padding) + columnHeader.replace( \'\\n\', \'\' )\r\n            print_()\r\n            printBold( columnHeader )\r\n            # printBold( columnHeader, prefix=self.tab[\'header\'] )\r\n            if not len(switches.value(\'YesTableLines\')):\r\n                print_()\r\n        i = 0\r\n        # print_(self.asset)\r\n        self.isExtraRecord_0001 = {}\r\n        self.isExtraRecord_000x = \'\'\r\n        tableLine = __.tableLine\r\n        if switches.isActive(\'YesTableLines\'):\r\n            tableLine = \'|\'\r\n\r\n        if l is None:\r\n            if switches.isActive(\'NoTableLines\'):\r\n                tableLine = \'\'\r\n        elif not l:\r\n            tableLine = \'\'\r\n\r\n        for item in self.asset:\r\n            # print_(item)\r\n            result = \'\'\r\n            for c in column.split(\',\'):\r\n                try:\r\n                    pass\r\n                    # result += self.showColumn(c,i,columnHeaderLength) + self.columnTab\r\n                except Exception as e:\r\n                    pass\r\n                # print_(result)\r\n                self.isExtraRecord = False\r\n                \r\n                \r\n                # if self.wrapTableKey+\'-sort\' in item:\r\n                    # print_(  item[self.wrapTableKey+\'-sort\']  )\r\n                    # print_(    )\r\n\r\n                if self.wrapTableKey+\'-sort\' in item:\r\n                    self.isExtraRecord_000x = item[self.wrapTableKey+\'-sort\']\r\n\r\n                if self.wrapTableKey+\'-sort\' in item and not item[self.wrapTableKey+\'-sort\'].endswith(\'-0001\'):\r\n                    self.isExtraRecord = True\r\n                try:\r\n                    pass\r\n                    result += self.showColumn(c,i,columnHeaderLength) + self.columnTab+tableLine\r\n                except Exception as e:\r\n                    errors.append({\'id\': 12, \'function\': \'print()\', \'cnt\': 1, \'location\': "result += showColumn(rows,c,i) + _v.slash+\'t\'", \'vars\': [{\'name\': \'folder\', \'value\': \'folder\'}, {\'name\': \'column\', \'value\': column}], \'error\': e})\r\n                    printBold(\'Error:\',\'red\')\r\n                    printBold(\'\\tBad column input.\')\r\n                    print_(12)\r\n                    print_(c)\r\n                    print_(12)\r\n                    os._exit(0)\r\n            # print_(_str.totalStrip5(result)) #TESTING\r\n            \r\n            maxSize = len(result)+self.prefixSize()\r\n            if maxSize > __.terminal.width and not switches.isActive(\'NoWrapTable\'):\r\n                ToDo = " result = \'\'   "\r\n                ToDo = \' for sult in self.wrapTable2(i):  \'\r\n                ToDo = \'     result += sult  \'\r\n            else:\r\n                ToDo = \' the below if will be under this else \'\r\n\r\n            if len(result) > 0:\r\n                # print_(result)\r\n                shouldPrint = True\r\n                if self.isExtraRecord_000x.split(\'-\')[0] in self.isExtraRecord_0001:\r\n                    testResult = result\r\n                    testResult = testResult.replace( \' \', \'\' ).replace( \'\\t\', \'\' )\r\n                    if not len(testResult):\r\n                        shouldPrint = False\r\n                # if self.isExtraRecord:\r\n                #   print_( self.isExtraRecord )\r\n\r\n                if shouldPrint:\r\n                    if self.groupID_KEY in item and item[self.groupID_KEY].endswith(\'-B\'):\r\n                        cp( [ self.tab[\'table\']+loopPrint(__.table_prefix_padding) + result ], \'BackgroundGrey.blue\' )\r\n                    else:\r\n                        colorizeRow( tableLine+result, prefix=self.tab[\'table\']+loopPrint(__.table_prefix_padding), prefixColor=self.tab_color, haltColorShift=self.isExtraRecord )\r\n            i += 1\r\n            if \'expected_input_example\' in column and \'switch\' in column and  switchDefault == i:\r\n                # if \'??\' in __.switch_skimmer.active:\r\n                if __.switch_skimmer.active:\r\n                    sys.exit()\r\n                pass\r\n                print_(\'\')\r\n        # if len(oldData) > 0:\r\n        #   self.asset = oldData\r\n        self.asset = self.backup.asset.copy()\r\n        self.aggregate_processed = False\r\n        # print_( \'recovered\' )\r\n\r\n\r\n        footer = {}\r\n        aSettings = {}\r\n        for k in __.aggregate.storage:\r\n            if k.startswith(\'eot?\'):\r\n                f = k[len(\'eot?\'):]\r\n                for y in __.aggregate.storage[k]:\r\n                    for sv in __.aggregate.storage[k][y][\'settings\']:\r\n                        aSettings[sv] = __.aggregate.storage[k][y][\'settings\'][sv]\r\n\r\n                    if \'?date\' in __.aggregate.storage[k][y][\'settings\']:\r\n                        __.aggregate.storage[k][y][\'data\'] = friendlyDate( __.aggregate.storage[k][y][\'data\'] )\r\n                    theKey = f \r\n                    special = {}\r\n\r\n                    kk = k\r\n                    var = \'var\'\r\n                    if \'var\' in __.aggregate.config:\r\n                        var = \'var\'\r\n                    if \'?var\' in __.aggregate.config:\r\n                        var = \'?var\'\r\n                    if \'var?\' in __.aggregate.config:\r\n                        var = \'var?\'\r\n\r\n                    if var in __.aggregate.config and kk in __.aggregate.config[var]:\r\n                        for spK in __.aggregate.config[var][kk]:\r\n                            special[spK] = __.aggregate.config[var][kk][spK]\r\n                    kk = \'?all\'\r\n                    if var in __.aggregate.config and kk in __.aggregate.config[var]:\r\n                        for spK in __.aggregate.config[var][kk]:\r\n                            special[spK] = __.aggregate.config[var][kk][spK]\r\n\r\n                    kk = \'all?\'\r\n                    if var in __.aggregate.config and kk in __.aggregate.config[var]:\r\n                        for spK in __.aggregate.config[var][kk]:\r\n                            special[spK] = __.aggregate.config[var][kk][spK]\r\n\r\n                    kk = \'eot?\'\r\n                    if var in __.aggregate.config and kk in __.aggregate.config[var]:\r\n                        for spK in __.aggregate.config[var][kk]:\r\n                            special[spK] = __.aggregate.config[var][kk][spK]\r\n                        \r\n\r\n                    if \'?fl\' in special:\r\n                        theKey = f + \' \'+ y\r\n                    if \'?first\' in special:\r\n                        theKey = f\r\n                    elif \'?second\' in special:\r\n                        theKey = y\r\n\r\n\r\n                    # for fo in __.aggregate.format:\r\n                    #   if fo == k or fo == y:\r\n                    #       if \'?date\' in __.aggregate.format[fo]:\r\n                    #           __.aggregate.storage[k][y][\'data\'] = friendlyDate( __.aggregate.storage[k][y][\'data\'] )\r\n                    #       if \'?comma\' in __.aggregate.format[fo]:\r\n                    #           __.aggregate.storage[k][y][\'data\'] = addComma( __.aggregate.storage[k][y][\'data\'] )\r\n                    # # print_(  )\r\n                    # footer[ theKey ] = __.aggregate.storage[k][y][\'data\']\r\n                    footer[ theKey ] = __.aggregate.obj.format( [k,y], __.aggregate.storage[k][y][\'data\'] )\r\n        if footer:\r\n            print_()\r\n            # print_()\r\n            footer_txt = []\r\n            footer_txt.append( __.aggregate.prefix )\r\n\r\n            for k in footer:\r\n                footer_txt.append( k+\':\' ) \r\n                footer_txt.append( footer[k] ) \r\n                footer_txt.append( \'  \' )\r\n            cp( footer_txt, \'cyan\' ) \r\n            # print_( __.aggregate.config )\r\n            print_()\r\n                    # print_( f, y, __.aggregate.storage[k][y][\'data\'] )\r\n            # print_( k )\r\n            # sys.exit()\r\n\r\n    def sort(self,fields=\'\'):# sortThis\r\n        rows = self.asset\r\n\r\n        if not len(self.asset):\r\n            return None\r\n\r\n        if self.wrapTableKey+\'-sort\' in self.asset[0]:\r\n            return rows\r\n        \r\n\r\n        global errors\r\n        global switches\r\n        # self.sort = name\r\n        tempFields = []\r\n        delim = \':\'\r\n        if fields == \'\':\r\n            name = switches.value(\'Sort\')\r\n        else:\r\n            name = fields\r\n        name = name.replace(\':\',delim)\r\n        # if not name:\r\n        sortBy = {}\r\n        sortList = name.split(\',\')\r\n        sortList.reverse()\r\n\r\n        ### Check for bad sort input\r\n        for item in sortList:\r\n            item = item\r\n            try:\r\n                if item.count(delim) > 0:\r\n                    sb = item.split(delim)[1]\r\n                else:\r\n                    sb = item\r\n            except Exception as e:\r\n                errors.append({\'id\': 16, \'function\': \'sortThis()\', \'cnt\': 1, \'location\': \'rows[0][sb]\', \'vars\': [{\'name\': \'rows\', \'value\': \'nope to that, to big\'}, {\'name\': \'name\', \'value\': name}], \'error\': e})\r\n\r\n        # itemgetter = __.imp(\'operator.itemgetter\')\r\n        for item in sortList:\r\n            try:\r\n                direction = item.split(delim)[0]\r\n                sb = self.findColumName(item.split(delim)[1])\r\n                if \'a\' in direction:\r\n                # if direction.find(\'a\') == 0:\r\n                    self.asset = sorted(self.asset, key=itemgetter(sb))\r\n                else:\r\n                    self.asset = sorted(self.asset, key=itemgetter(sb), reverse=True)\r\n            except Exception as e:\r\n                try:\r\n                    pass\r\n                    self.asset = sorted(self.asset, key=itemgetter(self.findColumName(item)))\r\n                except Exception as e:\r\n                    errors.append({\'id\': 17, \'function\': \'sortThis()\', \'cnt\': 2, \'location\': \'rows = sorted(rows, key=itemgetter(sb))\', \'vars\': [{\'name\': \'rows\', \'value\': \'nope to that, to big\'}, {\'name\': \'name\', \'value\': name}], \'error\': e})\r\n                \r\n            uuid = __.imp(\'uuid\')\r\n            sortBy[item] = str(uuid.uuid4())\r\n            tempFields.append( sortBy[item] )\r\n            i = 0\r\n            for row in self.asset:\r\n                self.asset[i][sortBy[item]] = i\r\n                i += 1\r\n\r\n        # rows = sorted(rows, key=lambda d: (-d[\'typesort\'], d[\'ext\'], d[\'name\']))\r\n\r\n        sortCode = \'rows = sorted(rows, key=lambda d: (\'\r\n        for item in sortList:\r\n            sortCode += "d[\'" + str(sortBy[item]) + "\'],"\r\n        sortCode = sortCode[:-1]\r\n        sortCode += \'))\'\r\n        exec(sortCode)\r\n        if len( tempFields ):\r\n            # print_( tempFields )\r\n            for ix,r in enumerate(rows):\r\n                for tmp in tempFields:\r\n                    try:\r\n                        del rows[ix][tmp]\r\n                    except Exception as e:\r\n                        pass\r\n        return self.asset\r\n\r\n    def countThis(self):\r\n        rows = self.asset\r\n        i = 0\r\n        for x in self.asset:\r\n            i += 1\r\n        return i\r\n\r\n    def file(self,file):\r\n        self.file = file\r\n\r\n    def save(self,theFile = \'\',tableTemp = True,printThis = True, me=0):\r\n        HD.chmod(theFile)\r\n        simplejson = __.imp(\'simplejson\')\r\n        if theFile == \'\':\r\n            theFile = str(self.file)\r\n        self.file = theFile\r\n        # print_(theFile)\r\n    # def saveTable(rows,theFile,tableTemp = True,printThis = True):\r\n        # defaults to myTables\r\n        if tableTemp == True:\r\n            file0 = str(_v.myTables) + str(_v.slash) + str(theFile)\r\n        else:\r\n            file0 = _v.stmp + _v.slash + theFile\r\n        dataDump = simplejson.dumps(self.asset, indent=4, sort_keys=True)\r\n        f = open(file0,\'w\')\r\n        f.write(str(dataDump))\r\n        f.close()\r\n        HD.chmod(theFile)\r\n        if printThis:\r\n            print_(\'Saved: \' + file0)\r\n        if me and theFile in vv.opened_file_me: changeM( theFile, vv.opened_file_me[theFile] );\r\n    def get(self,theFile = \'\',tableTemp = True,printThis = False):\r\n        if os.path.isfile(theFile): vv.opened_file_me[theFile] = os.path.getmtime( theFile );\r\n        simplejson = __.imp(\'simplejson\')\r\n        if theFile == \'\':\r\n            theFile = self.file\r\n        self.file = theFile\r\n        # defaults to myTables\r\n        if tableTemp == True:\r\n            file0 = _v.myTables + _v.slash + theFile\r\n        else:\r\n            file0 = _v.stmp + _v.slash + theFile\r\n        if printThis:\r\n            print_(\'Loaded: \' + file0)\r\n        if os.path.isfile(file0) == True:\r\n            with open(file0,\'r\', encoding="latin-1") as json_file:\r\n                json_data = simplejson.load(json_file)\r\n                # json_data = simplejson.load(json_file, object_pairs_hook=OrderedDict)\r\n        else:\r\n            json_data = []\r\n        self.asset = json_data\r\n        return json_data\r\n\r\n    def assets(self):\r\n        return self.asset\r\n\r\n    def set(self,asset):\r\n        self.asset = asset\r\n        return self.asset\r\n\r\n    def groupByTrigger( self ):\r\n        try:\r\n            if switches.isActive(\'GroupBy\') and len(self.asset):\r\n                newValues = []\r\n                keys = []\r\n                for key in self.asset[0].keys():\r\n                    keys.append( key )\r\n                for val in switches.value(\'GroupBy\').split( \',\' ):\r\n                    for key in keys:\r\n                        if key.lower() == val.lower():\r\n                            newValues.append( key )\r\n                if len(newValues):\r\n                    switches.fieldSet( \'GroupBy\', \'value\', \',\'.join(newValues) )\r\n        except Exception as e:\r\n            pass\r\n\r\n\r\n\r\nclass Tables:\r\n\r\n    def __init__(self):\r\n        self.tables = []\r\n        self.index = {}\r\n        self.maxNameLength = 35\r\n        self.columnTab = \'\\t\'\r\n        self.groupSeparator = \'_\'\r\n        self.group_space = False\r\n\r\n\r\n\r\n    def aggregate( self, name=None, code=None ):\r\n        if code is None:\r\n            return None\r\n        if name is None:\r\n            name = self.tables[ len(self.tables)-1 ].name\r\n        \r\n        self.tables[ self.index[name] ].aggregate( code )\r\n\r\n\r\n    def rprint( self, asset, columns=None, name=None, n=None, sc=True, printColumns=True, h=None, l=None, p=None ):\r\n        if columns is None:\r\n            columns = \',\'.join(list(asset[0].keys()))\r\n        \r\n\r\n        if not h is None:\r\n            printColumns = h\r\n        if not n is None:\r\n            name = n\r\n        if name is None:\r\n            name = genUUID()\r\n        self.register( name, asset )\r\n        if sc and switches.isActive(\'Column\'):\r\n            columns = switches.value(\'Column\')\r\n        self.print( name, columns, printColumns=printColumns, l=l, p=p )\r\n\r\n\r\n\r\n    def rsort( self, asset, columns, name=None, n=None ):\r\n        if not n is None:\r\n            name = n\r\n        if name is None:\r\n            name = genUUID()\r\n        self.register( name, asset )\r\n        return self.returnSorted( name,columns,asset )\r\n        # return self.sort( name, columns )\r\n\r\n\r\n    def register( self, name=None, asset = [], group_space=True, tab=\'\',    gs=None, t=None, n=None, w=True ):\r\n        global TableProfile_Config\r\n        if not n is None:\r\n            name = n\r\n        if name is None:\r\n            name = genUUID()\r\n        if not __.table_b_print:\r\n            for i,record in enumerate(asset):\r\n                for field in record.keys():\r\n                    if str( record[field] ) == \'b\':\r\n                        asset[i][field] = \'\'\r\n\r\n\r\n        found = False\r\n        thisID = False\r\n        if not gs is None:\r\n            group_space = gs\r\n        elif \'ALLTABLES\' in TableProfile_Config.keys() and \'GroupSpaces\' in TableProfile_Config[\'ALLTABLES\'].keys():\r\n            group_space = TableProfile_Config[\'ALLTABLES\'][\'GroupSpaces\']\r\n        else:\r\n            group_space = switches.isActive(\'GroupSpaces\')\r\n        if not t is None:\r\n            tab = t\r\n        for i,t in enumerate(self.tables):\r\n            if t.name == name:\r\n                thisID = i\r\n                found = True\r\n                self.tables[i].maxNameLength = self.maxNameLength\r\n                if len(asset) > 0:\r\n                    self.tables[i].set(asset)\r\n        if found:\r\n            self.tables.pop( thisID )\r\n            found = False\r\n\r\n        if not found:\r\n            self.tables.append(Table( name, asset, group_space, tab, w ))\r\n            self.tables[ len( self.tables )-1 ].maxNameLength = self.maxNameLength\r\n            self.index[name] = len( self.tables )-1\r\n        return name\r\n\r\n    def trigger(self,name,field,script,includes = False):\r\n        i = 0\r\n        for t in self.tables:\r\n            if t.name == name:\r\n                self.tables[i].trigger(field,script,includes)\r\n            i += 1\r\n\r\n    def registerView(self,table,name,fields,sort):\r\n        i = 0\r\n        for t in self.tables:\r\n            if t.name == table:\r\n                self.tables[i].registerView(name,fields,sort)\r\n            i += 1\r\n\r\n    def fieldProfileSet(self,table,field,propertyName,value):\r\n        i = 0\r\n        found = False\r\n        for t in self.tables:\r\n            if t.name == table:\r\n                found = True\r\n                self.tables[i].fieldProfileSet(field,propertyName,value)\r\n            i += 1\r\n        if not found:\r\n            self.tables.append(Table(table,[]))\r\n            i = 0\r\n            for t in self.tables:\r\n                if t.name == table:\r\n                    self.tables[i].fieldProfileSet(field,propertyName,value)\r\n                i += 1\r\n\r\n    def print(self,name,fields,fieldLengths=False, pc=None, printColumns=True, h=None, l=None, p=None ):\r\n        if not h is None:\r\n            printColumns = h\r\n        global switches\r\n        if not \',\' in fields:\r\n            pc = False\r\n\r\n        xXx = switches.records(\'dic_on-off-v\')\r\n        if \'Sort\' in xXx[\'on\']:\r\n            sortBy = xXx[\'values\'][\'Sort\']\r\n            self.sort( name, \',\'.join( sortBy ) )\r\n            # print_( sortBy )\r\n            # sys.exit()\r\n        if not pc is None:\r\n            printColumns = pc\r\n        # print_(name,fields)\r\n        sI = None\r\n        i = 0\r\n        for t in self.tables:\r\n            if t.name == name:\r\n                if len(self.tables[i].asset) > 0:\r\n                    if not \',\' in fields:\r\n                        printColumns = False\r\n                    self.tables[i].print(fields,fieldLengths,printColumns=printColumns, l=l, p=p)\r\n                    sI = i\r\n                else:\r\n                    print_(\'Null Set\')\r\n            i += 1\r\n        if switches.isActive(\'FieldTotal\'):\r\n            fieldTotals = {}\r\n            for field in switches.values(\'FieldTotal\'):\r\n                fieldTotals[field] = { \'actual\': None, \'total\': 0 }\r\n                for rec in self.tables[sI].asset:\r\n                    for key in rec.keys():\r\n                        if check_field_match( key, field ):\r\n                            fieldTotals[field][\'actual\'] = key\r\n                            thisFieldA = str(rec[key])\r\n                            thisFieldB = []\r\n                            for char in thisFieldA:\r\n                                if char in \'0123456789\':\r\n                                    thisFieldB.append(char)\r\n                            thisFieldC = int(\'\'.join(thisFieldB))\r\n                            fieldTotals[field][\'total\'] += thisFieldC\r\n            print_()\r\n            print_()\r\n            for field in fieldTotals:\r\n                print_( addComma(fieldTotals[field][\'total\']),\'\\t\', fieldTotals[field][\'actual\'] )\r\n\r\n\r\n\r\n\r\n    def sort(self,name,fields):\r\n        fields = fields.replace(\'.\',\':\')\r\n        i = 0\r\n        for t in self.tables:\r\n            if t.name == name:\r\n                self.tables[i].sort(fields)\r\n            i += 1\r\n\r\n    def returnSorted(self,name,fields,asset = []):\r\n        fields = fields.replace(\'.\',\':\')\r\n        if len(asset) > 0:\r\n            self.register(name,asset)\r\n\r\n        result = []\r\n        i = 0\r\n        for t in self.tables:\r\n            if t.name == name:\r\n                self.tables[i].sort(fields)\r\n                result = self.tables[i].asset\r\n            i += 1\r\n        return result\r\n    def view(self,table,name):\r\n        i = 0\r\n        for t in self.tables:\r\n            if t.name == table:\r\n                try:\r\n                    self.tables[i].printView(name)\r\n                except Exception as e:\r\n                    pass\r\n            i += 1\r\n\r\n    def save(self,table,theFile = \'\',tableTemp = True,printThis = True, me=0):\r\n        HD.chmod(theFile)\r\n        theFile = str(theFile)\r\n        if not theFile == \'\' and not \'.json\' in theFile:\r\n            theFile = theFile + \'.json\'\r\n        i = 0\r\n        for t in self.tables:\r\n            if t.name == table:\r\n                self.tables[i].save(theFile,tableTemp,printThis)\r\n            i += 1\r\n        HD.chmod(theFile)\r\n        if me and theFile in vv.opened_file_me: changeM( theFile, vv.opened_file_me[theFile] );\r\n\r\n    def get(self,table,theFile = \'\',tableTemp = True,printThis = False):\r\n        if os.path.isfile(theFile): vv.opened_file_me[theFile] = os.path.getmtime( theFile );\r\n        theFile = str(theFile)\r\n        if not theFile == \'\' and not \'.json\' in theFile:\r\n            theFile = theFile + \'.json\'\r\n        i = 0\r\n        for t in self.tables:\r\n            if t.name == table:\r\n                return self.tables[i].get(theFile,tableTemp,printThis)\r\n            i += 1\r\n\r\n    def asset(self,table):\r\n        i = 0\r\n        for t in self.tables:\r\n            if t.name == table:\r\n                return self.tables[i].assets()\r\n            i += 1\r\n\r\n    def file(self,table,theFile):\r\n        i = 0\r\n        for t in self.tables:\r\n            if t.name == table:\r\n                return self.tables[i].file(theFile)\r\n            i += 1\r\n\r\n    def set(self,table,asset):\r\n        i = 0\r\n        for t in self.tables:\r\n            if t.name == table:\r\n                return self.tables[i].set(asset)\r\n            i += 1\r\n\r\n    def alignmentMasterSupersedes(self,table,value):\r\n        i = 0\r\n        for t in self.tables:\r\n            if t.name == table:\r\n                self.tables[i].tableProfileDefaultSupersedes = value\r\n            i += 1\r\n        \r\n    def getLength(self,name,fields):\r\n        i = 0\r\n        for t in self.tables:\r\n            if t.name == name:\r\n                self.tables[i].showColumnHeader(fields)\r\n                result = self.tables[i].spaces\r\n            i += 1\r\n        total = 0\r\n        for r in result.keys():\r\n            total += result[r]\r\n            total += 5\r\n        # print_(result)\r\n        return total\r\n\r\n    def getFieldLengths(self,name,fields):\r\n        i = 0\r\n        for t in self.tables:\r\n            if t.name == name:\r\n                self.tables[i].showColumnHeader(fields)\r\n                result = self.tables[i].spaces\r\n            i += 1\r\n        ###### How it works:\r\n        # totalColumnWidth = 0\r\n        # for m in self.meta[\'data\']:\r\n        #   tables.register(m[\'table\'],m[\'fields\'])\r\n        #   spaces = tables.getLength(m[\'table\'],\'type,field,max,min,average\')\r\n        #   if spaces > totalColumnWidth:\r\n        #       totalColumnWidth = spaces\r\n\r\n\r\n        # fieldLengths = 0\r\n        # for m in self.meta[\'data\']:\r\n        #   tables.register(m[\'table\'],m[\'fields\'])\r\n        #   data = tables.getFieldLengths(m[\'table\'],\'type,field,max,min,average\')\r\n        #   if not type(fieldLengths) == dict:\r\n        #       fieldLengths = data\r\n        #   for name in fieldLengths.keys():\r\n        #       if data[name] > fieldLengths[name]:\r\n        #           fieldLengths[name] = data[name]\r\n\r\n\r\n\r\n        # for m in self.meta[\'data\']:\r\n        #   genLine(totalColumnWidth,\'=\')\r\n        #   print_(\'Table:\\t\',m[\'table\'])\r\n        #   print_(\'Parent:\\t\',m[\'parent\'])\r\n        #   print_(\'Records:\',m[\'count\'])\r\n        #   print_()\r\n        #   tables.register(m[\'table\'],m[\'fields\'])\r\n        #   tables.fieldProfileSet(m[\'table\'],\'*\',\'alignment\',\'center\')\r\n        #   tables.print(m[\'table\'],\'type,field,max,min,average\',fieldLengths)\r\n\r\n        #   genLine(totalColumnWidth,\'=\')\r\n        # print_()\r\n        # print_(\'Records:\',self.meta[\'records\'])\r\n        # print_()\r\n        # print_(\'Errors:\')\r\n        # for e in self.meta[\'errors\']:\r\n        #   print_(\'\\t\',e)\r\n\r\n        return result\r\n\r\n\r\n\r\n    def eof( self ):\r\n        try:\r\n            __.aggregate.eof.storage\r\n        except Exception as e:\r\n            shouldPrint = False\r\n        else:\r\n            shouldPrint = True\r\n\r\n        if not __.aggregate.eof.storage:\r\n            shouldPrint = False\r\n\r\n        if shouldPrint:\r\n            print_()\r\n            print_()\r\n\r\n            linePrint()\r\n\r\n            # print_()\r\n            # printVarSimple( __.aggregate.eof.storage )\r\n\r\n\r\n        footer = {}\r\n        aSettings = {}\r\n\r\n        for k in __.aggregate.eof.storage:\r\n            if k.startswith(\'eof?\'):\r\n                f = k[len(\'eof?\'):]\r\n                for y in __.aggregate.eof.storage[k]:\r\n                    for sv in __.aggregate.eof.storage[k][y][\'settings\']:\r\n                        aSettings[sv] = __.aggregate.eof.storage[k][y][\'settings\'][sv]\r\n\r\n                    if \'?date\' in __.aggregate.eof.storage[k][y][\'settings\']:\r\n                        __.aggregate.eof.storage[k][y][\'data\'] = friendlyDate( __.aggregate.eof.storage[k][y][\'data\'] )\r\n                    theKey = f +\' \'+ y\r\n                    special = {}\r\n\r\n                    kk = k\r\n                    var = \'var\'\r\n                    if \'var\' in __.aggregate.config:\r\n                        var = \'var\'\r\n                    if \'?var\' in __.aggregate.config:\r\n                        var = \'?var\'\r\n                    if \'var?\' in __.aggregate.config:\r\n                        var = \'var?\'\r\n\r\n                    if var in __.aggregate.config and kk in __.aggregate.config[var]:\r\n                        for spK in __.aggregate.config[var][kk]:\r\n                            special[spK] = __.aggregate.config[var][kk][spK]\r\n                    kk = \'?all\'\r\n                    if var in __.aggregate.config and kk in __.aggregate.config[var]:\r\n                        for spK in __.aggregate.config[var][kk]:\r\n                            special[spK] = __.aggregate.config[var][kk][spK]\r\n\r\n                    kk = \'all?\'\r\n                    if var in __.aggregate.config and kk in __.aggregate.config[var]:\r\n                        for spK in __.aggregate.config[var][kk]:\r\n                            special[spK] = __.aggregate.config[var][kk][spK]\r\n\r\n                    kk = \'eof?\'\r\n                    if var in __.aggregate.config and kk in __.aggregate.config[var]:\r\n                        for spK in __.aggregate.config[var][kk]:\r\n                            special[spK] = __.aggregate.config[var][kk][spK]\r\n                        \r\n\r\n                    if \'?first\' in special:\r\n                        theKey = f\r\n                    elif \'?second\' in special:\r\n                        theKey = y\r\n\r\n                    # print_( \'format:\', __.aggregate.format )\r\n                    # print_( \'k y:\', k, y  )\r\n\r\n                    # for fo in __.aggregate.format:\r\n                    #   if fo == k or fo == y:\r\n                    #       if \'?date\' in __.aggregate.format[fo]:\r\n                    #           __.aggregate.eof.storage[k][y][\'data\'] = friendlyDate( __.aggregate.eof.storage[k][y][\'data\'] )\r\n                    #       if \'?comma\' in __.aggregate.format[fo]:\r\n                    #           __.aggregate.eof.storage[k][y][\'data\'] = addComma( __.aggregate.eof.storage[k][y][\'data\'] )\r\n\r\n\r\n\r\n                    # # print_(  )\r\n                    # footer[ theKey ] = __.aggregate.eof.storage[k][y][\'data\']\r\n                    footer[ theKey ] = __.aggregate.obj.format( [k,y], __.aggregate.eof.storage[k][y][\'data\'] )\r\n        if footer:\r\n            print_()\r\n            # print_()\r\n            footer_txt = []\r\n            footer_txt.append( __.aggregate.prefix )\r\n\r\n            for k in footer:\r\n                footer_txt.append( k+\':\' ) \r\n                footer_txt.append( footer[k] ) \r\n                footer_txt.append( \'  \' )\r\n            cp( footer_txt, \'cyan\' ) \r\n            # print_( __.aggregate.config )\r\n            print_()\r\n                    # print_( f, y, __.aggregate.storage[k][y][\'data\'] )\r\n            # print_( k )\r\n\r\n\r\n\r\n\r\n\r\n\r\n###########################################################################################\r\ndef md5(fname):\r\n    hash_md5 = hashlib.md5()\r\n    with open(fname, "rb") as f:\r\n        for chunk in iter(lambda: f.read(4096), b""):\r\n            hash_md5.update(chunk)\r\n    return hash_md5.hexdigest()\r\n    return hash_md5.hexdigest()\r\n\r\n\r\ndef formatSize(size,what=None):\r\n    try:\r\n        size = int(size)\r\n    except Exception as e:\r\n        size = float(size)\r\n    result = \'\'\r\n    if what is None:\r\n\r\n        if size == None:\r\n            result = \'\'\r\n        elif size < 1024:\r\n            result = str(size) + \' B\'\r\n        elif size >= 1024 and size < 1048576:\r\n            num = round(size / 1024, 2)\r\n            result = str(num) + \' KB\'\r\n        elif size >= 1048576 and size < 1073741824:\r\n            num = round(size / 1048576, 2)\r\n            result = str(num) + \' MB\'\r\n        elif size >= 1073741824 and size < 1099511627776 :\r\n            num = round(size / 1073741824, 2)\r\n            result = str(num) + \' GB\'\r\n        elif size >= 1099511627776 and size < 1125899906842624 :\r\n            num = round(size / 1099511627776, 2)\r\n            result = str(num) + \' TB\'\r\n        elif size >= 1125899906842624 and size < 1152921504606847000 :\r\n            num = round(size / 1125899906842624, 2)\r\n            result = str(num) + \' PB\'\r\n        elif size >= 1152921504606847000 and size < 1180591620717411303424 :\r\n            num = round(size / 1152921504606847000, 2)\r\n            result = str(num) + \' EB\'\r\n        elif size >= 1180591620717411303424 and size < 1208925819614629174706176 :\r\n            num = round(size / 1180591620717411303424, 2)\r\n            result = str(num) + \' ZB\'\r\n        else:\r\n            num = round(size / 1208925819614629174706176, 2)\r\n            result = str(num) + \' YB\'\r\n    \r\n    elif not what is None:\r\n        what=what.upper()\r\n        if size == None:\r\n            result = \'\'\r\n        elif what == \'B\':\r\n            result = str(size) + \' B\'\r\n        elif what == \'KB\':\r\n            num = size / 1024\r\n            test = str(num)\r\n            if \'.\' in test:\r\n                roun=2\r\n                x=test.split(\'.\')[1]\r\n                for y in x:\r\n                    if y == \'0\':\r\n                        roun+=1\r\n                    else:\r\n                        break\r\n                pass\r\n                num=round(num,roun)\r\n            result = str(num) + \' KB\'\r\n        elif what == \'MB\':\r\n            num = size / 1048576\r\n            test = str(num)\r\n            if \'.\' in test:\r\n                roun=2\r\n                x=test.split(\'.\')[1]\r\n                for y in x:\r\n                    if y == \'0\':\r\n                        roun+=1\r\n                    else:\r\n                        break\r\n                pass\r\n                num=round(num,roun)\r\n            result = str(num) + \' MB\'\r\n        elif what == \'GB\':\r\n            num = size / 1073741824\r\n            test = str(num)\r\n            if \'.\' in test:\r\n                roun=2\r\n                x=test.split(\'.\')[1]\r\n                for y in x:\r\n                    if y == \'0\':\r\n                        roun+=1\r\n                    else:\r\n                        break\r\n                pass\r\n                num=round(num,roun)\r\n            result = str(num) + \' GB\'\r\n        elif what == \'TB\':\r\n            num = size / 1099511627776\r\n            test = str(num)\r\n            if \'.\' in test:\r\n                roun=2\r\n                x=test.split(\'.\')[1]\r\n                for y in x:\r\n                    if y == \'0\':\r\n                        roun+=1\r\n                    else:\r\n                        break\r\n                pass\r\n                num=round(num,roun)\r\n            result = str(num) + \' TB\'\r\n        elif what == \'PB\':\r\n            num = size / 1125899906842624\r\n            test = str(num)\r\n            if \'.\' in test:\r\n                roun=2\r\n                x=test.split(\'.\')[1]\r\n                for y in x:\r\n                    if y == \'0\':\r\n                        roun+=1\r\n                    else:\r\n                        break\r\n                pass\r\n                num=round(num,roun)\r\n            result = str(num) + \' PB\'\r\n        elif what == \'EB\':\r\n            num = size / 1152921504606847000\r\n            test = str(num)\r\n            if \'.\' in test:\r\n                roun=2\r\n                x=test.split(\'.\')[1]\r\n                for y in x:\r\n                    if y == \'0\':\r\n                        roun+=1\r\n                    else:\r\n                        break\r\n                pass\r\n                num=round(num,roun)         \r\n            result = str(num) + \' EB\'\r\n        elif what == \'ZB\':\r\n            num = size/1180591620717411303424\r\n            test = str(num)\r\n            if \'.\' in test:\r\n                roun=2\r\n                x=test.split(\'.\')[1]\r\n                for y in x:\r\n                    if y == \'0\':\r\n                        roun+=1\r\n                    else:\r\n                        break\r\n                pass\r\n                num=round(num,roun)\r\n            result = str(num) + \' ZB\'\r\n        elif what == \'YB\':\r\n            num = size / 1208925819614629174706176\r\n            test = str(num)\r\n            if \'.\' in test:\r\n                roun=2\r\n                x=test.split(\'.\')[1]\r\n                for y in x:\r\n                    if y == \'0\':\r\n                        roun+=1\r\n                    else:\r\n                        break\r\n                pass\r\n                num=round(num,roun)\r\n            result = str(num) + \' YB\'\r\n        else:\r\n            result = str(size) + \' B\'\r\n    return result\r\n\r\ndef unFormatSize(size):\r\n    size = str(size)\r\n    size = size.upper()\r\n    factor = \'\'\r\n    # 1152921504606846976\r\n    if False:\r\n        pass\r\n\r\n\r\n\r\n    elif \'YB\' in size:\r\n        factor = 1208925819614629174706176\r\n    elif \'ZB\' in size:\r\n        factor = 1180591620717411303424\r\n    elif \'EB\' in size:\r\n        factor = 1152921504606847000\r\n    elif \'PB\' in size:\r\n        factor = 1125899906842624\r\n    elif \'TB\' in size:\r\n        factor = 1099511627776\r\n    elif \'GB\' in size:\r\n        factor = 1073741824\r\n    elif \'MB\' in size:\r\n        factor = 1048576\r\n    elif \'KB\' in size:\r\n        factor = 1024\r\n\r\n    else:\r\n        factor = 1\r\n    size2 = \'\'\r\n    for c in size:\r\n        if c in \'0123456789.\':\r\n            size2+=c\r\n    size = size2\r\n    # size = size.replace(\'X\',\'\')\r\n    # size = size.replace(\'Y\',\'\')\r\n    # size = size.replace(\'Z\',\'\')\r\n    # size = size.replace(\'E\',\'\')\r\n    # size = size.replace(\'P\',\'\')\r\n    # size = size.replace(\'T\',\'\')\r\n    # size = size.replace(\'B\',\'\')\r\n    # size = size.replace(\'M\',\'\')\r\n    # size = size.replace(\'K\',\'\')\r\n    # size = size.replace(\'G\',\'\')\r\n    size = float(size)\r\n    if str(size).endswith(\'.0\'):\r\n        size = int(size)\r\n\r\n    result = round(size * factor,0)\r\n    # print_( size, factor )\r\n    # result = size * factor\r\n    return result\r\n\r\ndef unFormatSize2(size):\r\n    size = str(size)\r\n    # size = size.upper()\r\n    factor = \'\'\r\n    # 1152921504606846976\r\n\r\n    bity=False\r\n    if False:\r\n        pass\r\n\r\n\r\n\r\n    elif \'YB\' in size or \'yB\' in size:\r\n        factor = 1208925819614629174706176\r\n    elif \'ZB\' in size or \'zB\' in size:\r\n        factor = 1180591620717411303424\r\n    elif \'EB\' in size or \'eB\' in size:\r\n        factor = 1152921504606847000\r\n    elif \'PB\' in size or \'pB\' in size:\r\n        factor = 1125899906842624\r\n    elif \'TB\' in size or \'tB\' in size:\r\n        factor = 1099511627776\r\n    elif \'GB\' in size or \'gB\' in size:\r\n        factor = 1073741824\r\n    elif \'MB\' in size or \'mB\' in size:\r\n        factor = 1048576\r\n    elif \'KB\' in size or \'kB\' in size:\r\n        factor = 1024\r\n\r\n\r\n\r\n\r\n    elif \'Yb\' in size or \'yb\' in size or \'ybit\' in size.lower():\r\n        bity=True\r\n        factor = 1000000000000000000000000\r\n    elif \'Zb\' in size or \'zb\' in size or \'zbit\' in size.lower():\r\n        bity=True\r\n        factor = 1000000000000000000000\r\n    elif \'Eb\' in size or \'eb\' in size or \'ebit\' in size.lower():\r\n        bity=True\r\n        factor = 1000000000000000000\r\n    elif \'Pb\' in size or \'pb\' in size or \'pbit\' in size.lower():\r\n        bity=True\r\n        factor = 1000000000000000\r\n    elif \'Tb\' in size or \'tb\' in size or \'tbit\' in size.lower():\r\n        bity=True\r\n        factor = 1000000000000\r\n    elif \'Gb\' in size or \'gb\' in size or \'gbit\' in size.lower():\r\n        bity=True\r\n        factor = 1000000000\r\n    elif \'Mb\' in size or \'mb\' in size or \'mbit\' in size.lower():\r\n        bity=True\r\n        factor = 1000000\r\n    elif \'Kb\' in size or \'kb\' in size or \'kbit\' in size.lower():\r\n        bity=True\r\n        factor = 1000\r\n\r\n    else:\r\n        factor = 1\r\n    size2 = \'\'\r\n    for c in size:\r\n        if c in \'0123456789.\':\r\n            size2+=c\r\n    size = size2\r\n    # size = size.replace(\'X\',\'\')\r\n    # size = size.replace(\'Y\',\'\')\r\n    # size = size.replace(\'Z\',\'\')\r\n    # size = size.replace(\'E\',\'\')\r\n    # size = size.replace(\'P\',\'\')\r\n    # size = size.replace(\'T\',\'\')\r\n    # size = size.replace(\'B\',\'\')\r\n    # size = size.replace(\'M\',\'\')\r\n    # size = size.replace(\'K\',\'\')\r\n    # size = size.replace(\'G\',\'\')\r\n    size = float(size)\r\n    if str(size).endswith(\'.0\'):\r\n        size = int(size)\r\n\r\n    result = round(size * factor,0)\r\n    if 0 and bity:\r\n        result = result /8\r\n    # print_( size, factor )\r\n    # result = size * factor\r\n    rt = str(result)\r\n    if rt.endswith(\'.0\'):\r\n        return int(result)\r\n    return result\r\nisTime = False\r\n\r\ntimeAgoBase = []\r\ntimeAgoBaseCount = 0\r\ndef timeAgo( do=\'\', startDate=None,epoch=None, d=None ):\r\n    if not epoch is None:\r\n        startDate = epoch\r\n    if not d is None:\r\n        startDate = d\r\n\r\n    try:\r\n        do = float(do)\r\n        return do\r\n    except Exception as e:\r\n        pass\r\n\r\n    global timeAgoBase\r\n    global timeAgoBaseCount\r\n    if not len(timeAgoBase) and timeAgoBaseCount == 0:\r\n        if \',\' in do:\r\n            timeAgoBase = do.split(\',\')\r\n            # print_(do)\r\n            # sys.exit()\r\n    timeAgoBaseCount += 1\r\n    # print_( do, friendlyDate(startDate) )\r\n    if len(do) == 19 and do.count(\'-\') == 2 and do.count(\':\') == 2:\r\n        return autoDate( do )\r\n    if len(do) == 16 and do.count(\'-\') == 2 and do.count(\':\') == 1:\r\n        return autoDate( do )\r\n    if len(do) == 21 and do.count(\'-\') == 4:\r\n        result = []\r\n        for x in do.split(\',\'):\r\n            result.append( timeAgo( x, startDate ) )\r\n            # result.append( timeAgo_do( x, startDate ) )\r\n        return result\r\n    if len(do) == 10 and do.count(\'-\') == 2:\r\n        ts = autoDate( do )\r\n    else:\r\n        # ts = timeAgo_do( do, startDate)\r\n        if not do.startswith(\'+\'):\r\n            ts = timeAgo_past(do,startDate)\r\n        elif do.startswith(\'+\'):\r\n            ts = timeFuture(do,startDate)\r\n\r\n\r\n    if len(timeAgoBase) > 1 and do == timeAgoBase[1]:\r\n        if timeAgoBaseCount == 3 or timeAgoBaseCount == 5 :\r\n            pass\r\n            ts += 86400-1\r\n    # print_( timeAgoBaseCount, ts )\r\n    return ts\r\n\r\ndef timeCalc(do, epoch=None):\r\n    global epoch_times_dic\r\n    et=epoch_times_dic\r\n    k=list(et.keys())\r\n    k.reverse()\r\n    for t in et:\r\n        do=do.replace(t,t+\',\')\r\n        do=_str.do(\'be\',do,\',\')\r\n    print_(do)\r\n    sys.exit()\r\n    if epoch is None:\r\n        epoch = time.time()\r\n\r\n\r\ndef timeAgo_past(do=\'\', startDate=None):\r\n    if startDate is None:\r\n        startDate  = time.time()\r\n    # start_date = isDate(startDate,f=\'date\')\r\n    # start_date = [time.time()]\r\n    global isTime\r\n    # return do\r\n    if \'.\' in do:\r\n        dos = do.split(\'.\')\r\n        e = timeAgo( dos[0], startDate )\r\n        # return e\r\n        for di,ds in enumerate(dos):\r\n            if di:\r\n                e = timeAgo( dos[di], e )\r\n        return e\r\n    if do.startswith(\'-\'):\r\n        do = do[1:]\r\n    if do is None:\r\n        colorThis( \'\\t Error: Ago is Missing parameters\', \'red\' )\r\n        sys.exit()\r\n    if type(do) == float:\r\n        return do\r\n    if do.lower() == \'r\':\r\n        return \'resent\'\r\n    if \'re\' in do.lower():\r\n        return \'resent\'\r\n    if \'a\' in do.lower():\r\n        return \'a\'\r\n    if \'cd\' in do:\r\n        return do.lower()\r\n    if \'md\' in do:\r\n        return do.lower()\r\n    if \'mod\' in do.lower():\r\n        return \'md\'\r\n    if \'crea\' in do.lower():\r\n        return \'cd\'\r\n    if \'o\' in do.lower():\r\n        return \'one\'\r\n\r\n    if len(do) == 0:\r\n        do = switches.values(\'Ago\')[0]\r\n    do = do.lower()\r\n\r\n    if \'t\' in do:\r\n        one = resolveEpochTest( startDate )\r\n        two = autoDate( one.split(\' \')[0] )\r\n        return two\r\n    if isTime:\r\n        if \'m\' in do:\r\n            each = 60\r\n            units = do\r\n            units = units.replace( \'m\', \'\' )\r\n            units = int( units )\r\n            remove = units * each\r\n            return startDate - remove  \r\n    if \'mm\' in do or \'min\' in do:\r\n        each = 60\r\n        units = do\r\n        units = units.replace( \'min\', \'\' )\r\n        units = units.replace( \'m\', \'\' )\r\n        units = int( units )\r\n        remove = units * each\r\n        return startDate - remove  \r\n\r\n    if \'h\' in do:\r\n        each = 3600\r\n        units = do\r\n        units = units.replace( \'h\', \'\' )\r\n        units = int( units )\r\n        remove = units * each\r\n        return startDate - remove  \r\n\r\n\r\n    fnd = \'ymwd\'\r\n    nmb = do\r\n    for t in fnd:\r\n        nmb = nmb.replace(t,\'\')\r\n    if len(nmb) == 0:\r\n        nmb = 1\r\n    try:\r\n        nmb = int(nmb)\r\n    except Exception as e:\r\n        nmb = 1\r\n    if \'y\' in do:\r\n        # start_date = datetime.date.today() + datetime.timedelta(-365 * nmb)\r\n        # start_date = dateMathEpoch( startDate, 365 * nmb, \'-\' )\r\n        return yearMath( startDate, nmb, do=\'-\' )\r\n    if \'m\' in do:\r\n        # start_date = datetime.date.today() + datetime.timedelta(-30 * nmb)\r\n        # start_date = dateMathEpoch( startDate, 30 * nmb, \'-\' )\r\n        return monthMath( startDate, nmb, do=\'-\' )\r\n\r\n        print(\'asdf\',start_date)\r\n    if \'w\' in do:\r\n        # start_date = datetime.date.today() + datetime.timedelta(-7 * nmb)\r\n        return dateMathEpoch( startDate, 7 * nmb, \'-\' )\r\n    if \'d\' in do:\r\n        # start_date = datetime.date.today() + datetime.timedelta(-1 * nmb)\r\n        return dateMathEpoch( startDate, nmb, \'-\' )\r\n    return time.time()\r\n    # dTx = str(start_date)\r\n    # print_(dT)\r\n    # print_(dT)\r\n    # print_(dT)\r\n    # print_(dT)\r\n    # d = dTx.split(\'-\')\r\n    # result = datetime.datetime(int(d[0]),int(d[1]),int(d[2]),0,0).timestamp()\r\n\r\n    # print_(start_date)\r\n    # print_(result)]\r\n    # print_(result)\r\n    # return result\r\n\r\ndef epoch_math(epoch, d=None,w=None,m=None,y=None,    h=None,mm=None,s=None, add=None, sub=None):\r\n    if add is None and sub is None: add=True;\r\n    if sub: add = False;\r\n\r\n\r\n    def em_years(sourcedate, years, add=None):\r\n        if add: years_to_add = sourcedate.year + years;\r\n        if not add: years_to_add = sourcedate.year - years;\r\n        return sourcedate.replace(year=years_to_add)\r\n\r\n    def em_months(sourcedate, months, add=None):\r\n        from dateutil.relativedelta import relativedelta\r\n        if add: return sourcedate + relativedelta(months=months);\r\n        if not add: return sourcedate - relativedelta(months=months);\r\n\r\n    orig = datetime.datetime.fromtimestamp(epoch)\r\n\r\n    if add:\r\n        if not w is None: orig = orig + datetime.timedelta(days=w*7);\r\n        if not d is None: orig = orig + datetime.timedelta(days=d);\r\n    else:\r\n        if not w is None: orig = orig - datetime.timedelta(days=w*7);\r\n        if not d is None: orig = orig - datetime.timedelta(days=d);\r\n\r\n    if not m is None: orig = em_months(orig, m, add);\r\n    if not y is None: orig = em_years(orig, y, add);\r\n    epoch = orig.timestamp()\r\n\r\n    if add:\r\n        if not h is None: epoch+=(h*3600);\r\n        if not mm is None: epoch+=(mm*60);\r\n        if not s is None: epoch+=s;\r\n    else:\r\n        if not h is None: epoch-=(h*3600);\r\n        if not mm is None: epoch-=(mm*60);\r\n        if not s is None: epoch-=s;\r\n\r\n    return epoch\r\n\r\ndef timeAgo_do( do, epoch):\r\n    # print_(do)\r\n    def d486(yolo):\r\n        return int(yolo)\r\n        return float(yolo)\r\n\r\n    dic={}\r\n    if not do:\r\n        return do\r\n    \r\n    add=False\r\n    builder=\'\'\r\n    i=-1\r\n    while True:\r\n        i+=1\r\n        try:\r\n            c=do[i]\r\n        except Exception as e:\r\n            return epoch\r\n        if c == \'+\' or c == \'-\':\r\n            builder=\'\'\r\n            if c == \'+\':\r\n                add=True\r\n            elif c == \'-\':\r\n                add=False\r\n        elif c in \'0123456789.\':\r\n            builder+=c\r\n        elif c == \'m\':\r\n            ghost=False\r\n            try:\r\n                if do[i+1] == \'i\' and do[i+2] == \'n\': ghost=True;\r\n            except Exception as e:\r\n                pass\r\n            if ghost:\r\n                i+=2\r\n                epoch = epoch_math(epoch, mm=d486(builder), add=add)\r\n\r\n            else:\r\n                epoch = epoch_math(epoch, m=d486(builder), add=add)\r\n            builder=\'\'\r\n        elif c == \'y\': epoch = epoch_math(epoch, y=d486(builder), add=add); builder=\'\';\r\n        elif c == \'s\': epoch += s; builder=\'\';\r\n    return epoch\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\ndef timeFuture(do=\'\', startDate=None):\r\n    if startDate is None:\r\n        startDate = time.time()\r\n    global isTime\r\n\r\n    if \'.\' in do:\r\n        dos = do.split(\'.\')\r\n        e = timeAgo( dos[0], startDate )\r\n        # return e\r\n        for di,ds in enumerate(dos):\r\n            if di:\r\n                e = timeAgo( dos[di], e )\r\n        return e\r\n    if do.startswith(\'+\'):\r\n        do = do[1:]\r\n    if do is None:\r\n        colorThis( \'\\t Error: Ago is Missing parameters\', \'red\' )\r\n        sys.exit()\r\n    if type(do) == float:\r\n        return do\r\n    if do.lower() == \'r\':\r\n        return \'resent\'\r\n    if \'re\' in do.lower():\r\n        return \'resent\'\r\n    if \'a\' in do.lower():\r\n        return \'a\'\r\n    if \'cd\' in do:\r\n        return do.lower()\r\n    if \'md\' in do:\r\n        return do.lower()\r\n    if \'mod\' in do.lower():\r\n        return \'md\'\r\n    if \'crea\' in do.lower():\r\n        return \'cd\'\r\n    if \'o\' in do.lower():\r\n        return \'one\'\r\n\r\n    if len(do) == 0:\r\n        do = switches.values(\'Ago\')[0]\r\n    do = do.lower()\r\n\r\n    if \'t\' in do:\r\n        one = resolveEpochTest( startDate )\r\n        two = autoDate( one.split(\' \')[0] )\r\n        return two\r\n    if \'mm\' in do or \'min\' in do:\r\n        each = 60\r\n        units = do\r\n        units = units.replace( \'min\', \'\' )\r\n        units = units.replace( \'m\', \'\' )\r\n        units = int( units )\r\n        remove = units * each\r\n        return startDate + remove  \r\n    if isTime:\r\n        if \'m\' in do:\r\n            each = 60\r\n            units = do\r\n            units = units.replace( \'m\', \'\' )\r\n            units = int( units )\r\n            remove = units * each\r\n            return startDate + remove  \r\n\r\n    if \'h\' in do:\r\n        each = 3600\r\n        units = do\r\n        units = units.replace( \'h\', \'\' )\r\n        units = int( units )\r\n        remove = units * each\r\n        return startDate + remove  \r\n    if \'s\' in do:\r\n        units = do\r\n        units = units.replace( \'s\', \'\' )\r\n        units = int( units )\r\n        return startDate + units\r\n\r\n\r\n    fnd = \'ymwd\'\r\n    nmb = do\r\n    for t in fnd:\r\n        nmb = nmb.replace(t,\'\')\r\n    if len(nmb) == 0:\r\n        nmb = 1\r\n    try:\r\n        nmb = int(nmb)\r\n    except Exception as e:\r\n        nmb = 1\r\n\r\n    if \'y\' in do:\r\n        # start_date = dateMathEpoch( startDate, 365 * nmb, \'+\' )\r\n        # start_date = dateMathEpoch( startDate, 365 * nmb, \'+\' )\r\n        start_date = yearMath( startDate, nmb, do=\'+\' )\r\n    if \'m\' in do:\r\n        # start_date = dateMathEpoch( startDate, 30 * nmb, \'+\' )\r\n        start_date = monthMath( startDate, nmb, do=\'+\' )\r\n    if \'w\' in do:\r\n        start_date = dateMathEpoch( startDate, 7 * nmb, \'+\' )\r\n    if \'d\' in do:\r\n        start_date = dateMathEpoch( startDate, nmb, \'+\' )\r\n    return start_date\r\n\r\n\r\ndef monthsDiff( one, two ):\r\n    one = friendlyDate( autoDate( one ) ).split(\' \')[0]\r\n    two = friendlyDate( autoDate( two ) ).split(\' \')[0]\r\n\r\n    # print_( \'here\' )\r\n    # print_( \'one\', one )\r\n    # print_( \'two\', two )\r\n    oneB = one.split(\'-\')\r\n    twoB = two.split(\'-\')\r\n    # print_( \'here\' )\r\n\r\n    oneA = float( oneB[0]+\'.\'+oneB[1] )\r\n    twoA = float( twoB[0]+\'.\'+twoB[1] )\r\n\r\n    if oneA == twoA:\r\n        return 0\r\n    elif oneA < twoA:\r\n        do = \'-\'\r\n    else:\r\n        do = \'+\'\r\n\r\n    oneB[0] = int(oneB[0])\r\n    oneB[1] = int(oneB[1])\r\n\r\n    twoB[0] = int(twoB[0])\r\n    twoB[1] = int(twoB[1])\r\n    i=0\r\n    # print_(  )\r\n    # print_(\' i\',i, do)\r\n    done = False\r\n    while  not done:\r\n        if oneB[0] == twoB[0] and  oneB[1] == twoB[1]:\r\n            done = True\r\n        if not done:\r\n            i+=1\r\n            if do == \'+\':\r\n                twoB[1]+=1\r\n                if twoB[1] == 13:\r\n                    twoB[1] = 1\r\n                    twoB[0] += 1\r\n            elif do == \'-\':\r\n                twoB[1]-=1\r\n                if twoB[1] == 0:\r\n                    twoB[1] = 12\r\n                    twoB[0] -= 1\r\n    #   print_(\'i\',i, twoB[0], twoB[1])\r\n    # print_(\' i\',i, do, oneB[0], oneB[1], \'|\', twoB[0], twoB[1] )\r\n    return i\r\ncal_days = None\r\ndef days_in_month( m, y=None ):\r\n    global cal_days\r\n    if cal_days is None:\r\n        cal_days = getTableDB( \'cal-days.hash\' )\r\n    if m == 2:\r\n        if y is None:\r\n            return 28\r\n        elif not y is None:\r\n            if isLeapYear( y ):\r\n                return 29\r\n            else:\r\n                return 28\r\n    return cal_days[str(m)]\r\n\r\n\r\ndef isLeapYear( year ):\r\n    global leap_years_table\r\n    if leap_years_table is None:\r\n        leap_years_table = getTableDB( \'leap-years.list\' )\r\n\r\n    if year in leap_years_table:\r\n        return True\r\n    return False\r\n\r\n\r\ndef dateDiffDic( one, two ):\r\n\r\n    oA = autoDate( friendlyDate( autoDate(one) ).split(\' \') )\r\n    tA = autoDate( friendlyDate( autoDate(two) ).split(\' \') )\r\n    if oA > tA:\r\n        o = oA\r\n        t = tA\r\n    else:\r\n        o = tA\r\n        t = oA\r\n\r\n\r\n\r\n    md1 = monthsDiff( one, two )\r\n    # md1 = autoDate( friendlyDate( autoDate(md1) ).split(\' \') )\r\n    print_( \'md1\', md1 )\r\n    md2 = md1\r\n    mx1 = monthMath( t, md1, do=\'+\' )\r\n    print_( \'mx1\', friendlyDate(mx1) )\r\n    mx1 = autoDate( friendlyDate( autoDate(mx1) ).split(\' \') )\r\n    print_( \'mx1\', friendlyDate(mx1) )\r\n    # if mx1 > t:\r\n    if abs(mx1 - o) > 86420:\r\n        print_( \'error a\' )\r\n        print_( \'-\', abs(mx1 - o) )\r\n        print_( friendlyDate(mx1), friendlyDate(o) )\r\n        print_( (mx1), (o) )\r\n        print_( \'error a\' )\r\n        md1-=1\r\n        mx1 = monthMath( o, md1-1, do=\'+\' )\r\n    d1 = abs(daysDiff( o, mx1 ))\r\n\r\n    # mx2 = monthMath( o, md2, do=\'+\' )\r\n    # mx2 = autoDate( friendlyDate( autoDate(mx2) ).split(\' \') )\r\n    # # if mx2 > o:\r\n    # if abs(mx2 - t) > 86420:\r\n\r\n    #   print_( \'error b\' )\r\n    #   print_( \'-\', abs(mx2 - t) )\r\n    #   print_( friendlyDate(mx2), friendlyDate(t) )\r\n    #   print_( (mx2), (t) )\r\n\r\n    #   print_( \'error b\' )\r\n    #   md2-=1\r\n    #   mx2 = monthMath( t, md2, do=\'+\' )\r\n    # d2 = daysDiff( t, mx2 )\r\n\r\n\r\n    return md1, d1\r\n\r\n    # one = friendlyDate( autoDate( one ) ).split(\' \')[0]\r\n    # two = friendlyDate( autoDate( two ) ).split(\' \')[0]\r\n\r\n    # # print_( \'here\' )\r\n    # # print_( \'one\', one )\r\n    # # print_( \'two\', two )\r\n    # oneB = one.split(\'-\')\r\n    # twoB = two.split(\'-\')\r\n    # # print_( \'here\' )\r\n\r\n    # oneA = float( oneB[0]+\'.\'+oneB[1] )\r\n    # twoA = float( twoB[0]+\'.\'+twoB[1] )\r\n\r\n    # if oneA == twoA:\r\n    #   return 0\r\n    # elif oneA < twoA:\r\n    #   do = \'-\'\r\n    # else:\r\n    #   do = \'+\'\r\n\r\n    # oneB[0] = int(oneB[0])\r\n    # oneB[1] = int(oneB[1])\r\n    # oneB[2] = int(oneB[2])\r\n\r\n    # twoB[0] = int(twoB[0])\r\n    # twoB[1] = int(twoB[1])\r\n    # twoB[2] = int(twoB[2])\r\n\r\n    # cnt = {\r\n    #           \'y\': 0,\r\n    #           \'m\': 0,\r\n    #           \'d\': 0,\r\n    # }\r\n    # # print_(  )\r\n    # # print_(\' i\',i, do)\r\n    # done = False\r\n\r\n    # done = False\r\n\r\n    # # print_(  )\r\n\r\n\r\n\r\n    # while  not done:\r\n    #   print_( oneB, twoB )\r\n    #   if oneB[0] == twoB[0] and  oneB[1] == twoB[1]  and  oneB[2] == twoB[2] :\r\n    #       done = True\r\n    #   if not done:\r\n    #       twoB[2]+=1\r\n    #       cnt[\'d\'] += 1\r\n    #       if twoB[2] > days_in_month( twoB[1], twoB[0] ):\r\n    #           twoB[2] = 1\r\n    #           twoB[1] += 1\r\n    #           cnt[\'d\'] = 0\r\n    #           cnt[\'m\'] += 1\r\n\r\n    #       if twoB[1] == 13:\r\n                \r\n    #           twoB[1] = 1\r\n    #           twoB[0] += 1\r\n    cnt[\'y\'] = int(str( cnt[\'m\']/12 ).split(\'.\')[0])\r\n    cnt[\'m\'] = cnt[\'m\'] - ( cnt[\'y\']*12 )\r\n    return cnt\r\n# def dateDiffDic( one, two ):\r\n    # one = friendlyDate( autoDate( one ) ).split(\' \')[0]\r\n    # two = friendlyDate( autoDate( two ) ).split(\' \')[0]\r\n\r\n    # # print_( \'here\' )\r\n    # # print_( \'one\', one )\r\n    # # print_( \'two\', two )\r\n    # oneB = one.split(\'-\')\r\n    # twoB = two.split(\'-\')\r\n    # # print_( \'here\' )\r\n\r\n    # oneA = float( oneB[0]+\'.\'+oneB[1] )\r\n    # twoA = float( twoB[0]+\'.\'+twoB[1] )\r\n\r\n    # if oneA == twoA:\r\n    #   return 0\r\n    # elif oneA < twoA:\r\n    #   do = \'-\'\r\n    # else:\r\n    #   do = \'+\'\r\n\r\n    # oneB[0] = int(oneB[0])\r\n    # oneB[1] = int(oneB[1])\r\n    # oneB[2] = int(oneB[2])\r\n\r\n    # twoB[0] = int(twoB[0])\r\n    # twoB[1] = int(twoB[1])\r\n    # twoB[2] = int(twoB[2])\r\n\r\n    # i=0\r\n    # # print_(  )\r\n    # # print_(\' i\',i, do)\r\n    # done = False\r\n#   while  not done:\r\n#       if oneB[0] == twoB[0] and  oneB[1] == twoB[1]:\r\n#           done = True\r\n#       if not done:\r\n#           i+=1\r\n#           if do == \'+\':\r\n#               twoB[1]+=1\r\n#               if twoB[1] == 13:\r\n#                   twoB[1] = 1\r\n#                   twoB[0] += 1\r\n#           elif do == \'-\':\r\n#               twoB[1]-=1\r\n#               if twoB[1] == 0:\r\n#                   twoB[1] = 12\r\n#                   twoB[0] -= 1\r\n    \r\n#   # md = days_in_month( twoB[1], twoB[0] )\r\n#   # if twoB[2] > md:\r\n#   #   dif = twoB[2] - md\r\n#   #   twoB[2] = dif\r\n#   #   twoB[1] += 1\r\n#   #   i+=1\r\n#   days = oneB[2] - twoB[2]\r\n#   if days < 0:\r\n\r\n#       bb = str(twoB[1])\r\n#       cc = str(twoB[2])\r\n#       # print_( \'048b\' )\r\n#       if twoB[1] < 10:\r\n#           bb = \'0\'+bb\r\n#       if twoB[2] < 10:\r\n#           cc = \'0\'+cc\r\n#       text = str(twoB[0])+\'-\'+bb+\'-\'+cc\r\n#       result = autoDate(  text  )\r\n\r\n#   tMs = int(str(tMsZ).split(\'.\')[0])\r\n#   y = int(str( i/12 ).split(\'.\')[0])\r\n#   i = i - ( y*12 )\r\n\r\n#   return { \'y\': y, \'m\': i }\r\n\r\n\r\n\r\ndef woy_from_year_week( y, w ):\r\n    return str(round(w * 0.01,2) + y)\r\n\r\ndef woy2dates( woy ):\r\n    s = woy2date( woy ) \r\n    e = days_math( s, 7, \'+\' )-1\r\n    return [s, e]\r\n\r\ndef woy2datesFriendly( woy ):\r\n    es = woy2dates( woy )\r\n    return friendlyDate(es[0]), friendlyDate(es[1])\r\n\r\ndef woy2date( woy ):\r\n    d = "2013-W26"\r\n    d = woy.split(\'.\')[0]\r\n    d += \'-\'\r\n    d += \'W\' + str(int(woy.split(\'.\')[1]))\r\n    return autoDate(str(datetime.datetime.strptime(d + \'-1\', "%Y-W%W-%w")).split(\' \')[0])\r\n\r\ndef dateDiffText( theDate, epoch=None ):\r\n\r\n    y=0\r\n    m=0\r\n    w=0\r\n\r\n    theDate = autoDate( theDate )\r\n    if epoch is None:\r\n        epoch = time.time()\r\n    # woy = getWOY( theDate )\r\n    days = abs(daysDiff( theDate, epoch ))\r\n    \r\n    if theDate < epoch:\r\n        end = \'<\'\r\n    else:\r\n        end = \'>\'\r\n\r\n    msDiff = epoch - theDate\r\n\r\n    if msDiff > 0 and msDiff <= 86400:\r\n        return \'today\'\r\n    elif msDiff > 0 and msDiff <= 82800:\r\n        return \'today\'\r\n    elif msDiff > 0 and msDiff <= 169200:\r\n        return \'yesterday\'\r\n    elif msDiff > 0 and msDiff <= 604801:\r\n        return \'this week\'\r\n\r\n\r\n\r\n    # print_( theDate, days, theDate < epoch, theDate > epoch, epoch, time.time() )\r\n    if days == 0:\r\n        return \'today\'\r\n    elif theDate < epoch:\r\n        if days == 1:\r\n            return \'yesterday\'\r\n        elif days < 7:\r\n            return \'this week\'\r\n    elif theDate > epoch:\r\n        if days == 1:\r\n            return \'tommorow\'\r\n        elif days < 7:\r\n            return \'next week\'\r\n\r\n    if days >= 365:\r\n        tmp = float(days / 365)\r\n        y = int(str(tmp).split(\'.\')[0])\r\n        days = days - ( y*365 )\r\n    if days >= 30:\r\n        tmp = float(days / 30)\r\n        m = int(str(tmp).split(\'.\')[0])\r\n        days = days - ( m*30 )\r\n    if days >= 7:\r\n        tmp = float(days / 7)\r\n        w = int(str(tmp).split(\'.\')[0])\r\n        days = days - ( w*7 )\r\n\r\n    result = []\r\n    if y:\r\n        result.append( str(y)+\'y\' )\r\n    if m:\r\n        result.append( str(m)+\'m\' )\r\n    if w:\r\n        result.append( str(w)+\'w\' )\r\n    result.append( end )\r\n    return \' \'.join( result )\r\n\r\ndef getWOY( theDate ):\r\n    theDate = autoDate( theDate )\r\n    woy = getWOYFromEpoch(theDate)\r\n    year = getYearFromEpoch(theDate)\r\n    weekAndYear = round(woy * 0.01,2) + year\r\n    weekAndYear = str(weekAndYear)\r\n    if len(weekAndYear) == 6:\r\n        weekAndYear += \'0\' \r\n    return weekAndYear\r\n\r\ndef getYearFromEpoch(theDate):\r\n    theDate = autoDate(theDate)\r\n    return datetime.datetime.fromtimestamp( int(theDate) ).isocalendar()[0]\r\n\r\ndef getWOYFromEpoch(theDate):\r\n    # print_(\'theDate:\',theDate)\r\n    theDate = autoDate(theDate)\r\n\r\n    try:\r\n        return datetime.datetime.fromtimestamp( theDate ).isocalendar()[1]\r\n    except Exception as e:\r\n        print_( \'Error:\', theDate )\r\n        sys.exit()\r\n\r\n\r\ndate_datetime = None\r\ndef daysDiff( one, two ):\r\n    global date_datetime\r\n    oneA = autoDate( one )\r\n    twoB = autoDate( two )\r\n    g = 1\r\n    if two > one:\r\n        g = 2\r\n\r\n    if one == two:\r\n        return 0\r\n    elif one > two:\r\n        one = friendlyDate( oneA ).split(\' \')[0]\r\n        two = friendlyDate( twoB ).split(\' \')[0]\r\n    else:\r\n        one = friendlyDate( twoB ).split(\' \')[0]\r\n        two = friendlyDate( oneA ).split(\' \')[0]\r\n\r\n\r\n    # print_( \'090\', one, two )\r\n\r\n    oneB = one.split(\'-\')\r\n    twoB = two.split(\'-\')\r\n    if date_datetime is None:\r\n        from datetime import date as date_datetime\r\n    d0 = date_datetime(int(oneB[0]), int(oneB[1]), int(oneB[2]))\r\n    # print_( \'080\', twoB )\r\n    d1 = date_datetime(int(twoB[0]), int(twoB[1]), int(twoB[2]))\r\n    delta = d1 - d0\r\n    dd = delta.days\r\n    if g == 1:\r\n        dd = abs(dd)\r\n    return dd\r\n\r\n\r\ndef yearMath( thisDate, years, do=\'+\' ):\r\n    theDateParts = friendlyDate( autoDate( thisDate ) ).split(\' \')\r\n    theDate = theDateParts[0]\r\n    parts = theDate.split(\'-\')\r\n    parts[0] = int(parts[0])\r\n    i = 0\r\n    while not i == years:\r\n        if do == \'+\':\r\n            parts[0] += 1\r\n        elif do == \'-\':\r\n            parts[0] -= 1\r\n        i+=1\r\n                \r\n\r\n    return autoDate(  str(parts[0])+\'-\'+parts[1]+\'-\'+parts[2] +\' \'+ theDateParts[1] )\r\n\r\n\r\ndef monthMath( thisDate, months, do=\'+\' ):\r\n    months = abs(months)\r\n    # print_( \'040\', thisDate, autoDate( thisDate ), friendlyDate(thisDate) )\r\n    theDateParts = friendlyDate( autoDate( thisDate ) ).split(\' \')\r\n    theDate = theDateParts[0]\r\n    parts = theDate.split(\'-\')\r\n    parts[0] = int(parts[0])\r\n    parts[1] = int(parts[1])\r\n    parts[2] = int(parts[2])\r\n    i = 0\r\n    while not i == months:\r\n        # print_( months, 1, parts )\r\n        if do == \'+\':\r\n            parts[1]+=1\r\n            if parts[1] == 13:\r\n                parts[1] = 1\r\n                parts[0] += 1\r\n        elif do == \'-\':\r\n            parts[1]-=1\r\n            if parts[1] == 0:\r\n                parts[1] = 12\r\n                parts[0] -= 1\r\n        i+=1\r\n    # print_( \'048a\' )\r\n    bb = str(parts[1])\r\n    cc = str(parts[2])\r\n    # print_( \'048b\' )\r\n    if parts[1] < 10:\r\n        bb = \'0\'+bb\r\n    if parts[2] < 10:\r\n        cc = \'0\'+cc\r\n    # print_( \'048c\' )\r\n    text = str(parts[0])+\'-\'+bb+\'-\'+cc +\' \'+ theDateParts[1]\r\n    # print_( \'049\', text )\r\n    result = autoDate(  text  )\r\n    # print_( \'050a\', text, type( result ) )\r\n    while type( result ) == bool:\r\n\r\n        parts[2]-=1\r\n\r\n        bb = str(parts[1])\r\n        cc = str(parts[2])\r\n        if parts[1] < 10:\r\n            bb = \'0\'+bb\r\n        if parts[2] < 10:\r\n            cc = \'0\'+cc\r\n        text = str(parts[0])+\'-\'+bb+\'-\'+cc +\' \'+ theDateParts[1]\r\n        result = autoDate(  text  )\r\n        # print_( \'050b\', text, type( result ) )\r\n\r\n\r\n\r\n    # print_( \'050c\', text )\r\n    # print_( \'060\', result )\r\n    return result\r\n\r\ndef epoch(string,end=False):\r\n    string = str(string)\r\n    if \'.\' in string:\r\n        d = string.split(\'.\')\r\n    elif _v.slash in string:\r\n        d = string.split(_v.slash)\r\n    elif \'-\' in string:\r\n        d = string.split(\'-\')\r\n    elif len(string) == 6:\r\n        t = string[:4] + \'-\' + string[-2:]\r\n        d = t.split(\'-\')\r\n    elif len(string) == 8:\r\n        x = string[-4:]\r\n        t = string[:4] + \'-\' + x[:2] + \'-\' + x[-2:]\r\n        d = t.split(\'-\')\r\n\r\n    if not len(d) == 3:\r\n        day = 1\r\n    else:\r\n        day = d[2]\r\n    # print_(d)\r\n    # sys.exit()\r\n    if end:\r\n        y = int(d[0])\r\n        m = int(d[1])\r\n        if m == 12:\r\n            y += 1\r\n            m = 1\r\n        else:\r\n            m += 1\r\n        start_date = datetime.datetime(y,m,1,0,0) + datetime.timedelta(-1)\r\n        result = start_date.timestamp()\r\n    else:\r\n        result = datetime.datetime(int(d[0]),int(d[1]),int(day),0,0).timestamp()\r\n    # result = d\r\n    return result\r\ndef isNu(string):\r\n    result = True\r\n    for s in string:\r\n        try:\r\n            int(s)\r\n        except Exception as e:\r\n            result = False\r\n    return result\r\ndef isNu2(string):\r\n    result = True\r\n    string = str(string).replace(\'.\',\'\').replace(\'-\',\'\').replace(_v.slash,\'\').replace(\'/\',\'\')\r\n    try:\r\n        try:\r\n            int(string)\r\n        except Exception as e:\r\n            float(string)\r\n    except Exception as e:\r\n        result = False\r\n    return result\r\ndef number2Words(n):\r\n    global numberWords\r\n    try:\r\n        numberWords\r\n        if len(numberWords) == 0:\r\n            numberWords = getText(_v.myTables + _v.slash+\'numberWords.txt\')\r\n    except Exception as e:\r\n        numberWords = getText(_v.myTables + _v.slash+\'numberWords.txt\')\r\n    numberWords = getText(_v.myTables + _v.slash+\'numberWords.txt\')\r\n    if type(n) == int:\r\n        result = numberWords[n].replace(\' \',\'_\').replace(\'-\',\'_\').replace(\'\\n\',\'\')\r\n    else:\r\n        result = n.replace(\' \',\'_\')\r\n    return result\r\n###########################################################################################\r\n###########################################################################################\r\ndef checkKey(dict, key):\r\n    if key in dict.keys():\r\n        return True\r\n    else:\r\n        return False\r\n\r\nclass Databases:\r\n\r\n# FOREIGN KEY (project_id) REFERENCES projects (id)\r\n\r\n    def __init__( self ):\r\n        \r\n        self.databases = []\r\n\r\n\r\n    def register( self, name=False, file=False, table=False, records=False, fields=False, delete=False, description=False, project=False, auto=False, printFileActivity=False ):\r\n\r\n        idx = len( self.databases )\r\n        self.databases.append( Database( name=name, file=file, table=table, records=records, fields=fields, delete=delete, description=description, project=project, auto=auto, printFileActivity=printFileActivity ) )\r\n\r\n\r\n    def search( self, name=False, info=False ):\r\n        for i,d in enumerate(self.databases):\r\n            if self.databases[i].name == name:\r\n                return self.databases[i].search( info )\r\n\r\n    def getFields( self, name=False, table=False, exclude=False ):\r\n        for i,d in enumerate(self.databases):\r\n            if self.databases[i].name == name:\r\n                return self.databases[i].getFields( table, exclude )\r\n\r\n    def update( self, name=False, info=False ):\r\n        for i,d in enumerate(self.databases):\r\n            if self.databases[i].name == name:\r\n                return self.databases[i].update( info )\r\n\r\n    def add( self, name=False, info=False ):\r\n        for i,d in enumerate(self.databases):\r\n            if self.databases[i].name == name:\r\n                return self.databases[i].add( info )\r\n\r\n    def insertRecords( self, name, table, records ):\r\n        for i,d in enumerate(self.databases):\r\n            if self.databases[i].name == name:\r\n                return self.databases[i].insertRecords( table=table, records=records )\r\n                            \r\n    def trigger( self, name, table, field, trigger ):\r\n        for i,d in enumerate(self.databases):\r\n            if self.databases[i].name == name:\r\n                return self.databases[i].addTrigger( table, field, trigger )\r\n\r\n\r\nclass Database:\r\n    \r\n    def __init__( self, name=False, file=False, table=False, records=False, fields=False, delete=False, description=False, project=False, auto=False, printFileActivity=False ):\r\n        self.initialized = []\r\n        self.initializedDB = False\r\n        self.tableInfo = []\r\n        self.tables = []\r\n        self.relationships = []\r\n\r\n        self.name = name\r\n        self.file = _v.myDatabases + _v.slash + file\r\n        self.delete = delete\r\n        self.printFileActivity = printFileActivity\r\n\r\n        self.project = project\r\n        self.description = description\r\n        self.apps = False\r\n\r\n        self.table = table\r\n        self.records = records\r\n        \r\n        self.fieldsManual = fields\r\n        self.fields = {}\r\n\r\n        if type( table ) == bool:\r\n            auto = True\r\n        if not type( self.records ) == bool:\r\n            for i,r in enumerate(self.records):\r\n                self.records[i][\'date_created\'] = time.time()\r\n                self.records[i][\'date_modified\'] = \'\'\r\n                # print_( self.records[i] )\r\n\r\n        if self.delete and os.path.isfile( self.file ):\r\n            os.unlink( self.file )\r\n            if self.printFileActivity:\r\n                print_( \' file deleted \')\r\n        if os.path.isfile( self.file ):\r\n            if self.printFileActivity:\r\n                print_( \' file exists \')\r\n\r\n        if auto and os.path.isfile( self.file ):\r\n            self.genInfo( process=True )\r\n        else:\r\n            if not type( table ) == bool:\r\n                if not type( self.records ) == bool:\r\n                    self.insertRecords( table )\r\n                    \r\n\r\n\r\n    def generateStructure( self, table ):\r\n        if not table in self.initialized:\r\n            self.initialized.append( table )\r\n            if os.path.isfile( self.file ):\r\n                self.genInfo( process=True )\r\n            else:\r\n                fieldsData = self.processRecords()\r\n                self.create( table, fieldsData )\r\n\r\n                self.genInfo( process=True )\r\n\r\n            \r\n\r\n    def addTrigger( self, table, field, trigger ):\r\n        for i,r in enumerate(self.tables):\r\n            if self.tables[i].table == table:\r\n                for ii,fieldX in enumerate(self.tables[i].fields):\r\n                    if fieldX.name == field:\r\n                        self.tables[i].fields[ii].info[\'trigger\'] = trigger\r\n\r\n\r\n\r\n    def updateFieldInfo( self, table, field, label, data ):\r\n        for i,r in enumerate(self.tables):\r\n            if self.tables[i].table == table:\r\n                for ii,fieldX in enumerate(self.tables[i].fields):\r\n                    if fieldX.name == field:\r\n                        self.tables[i].fields[ii].info[\'label\'] = data\r\n    def updateManualFieldInfo( self ):\r\n        if not type( self.fieldsManual ) == bool:\r\n            for i,f in enumerate(self.fieldsManual):\r\n                for k in f.keys():\r\n                    if not k == \'name\' and not k == \'type\' and not k == \'table\':\r\n                        self.updateFieldInfo( f[\'table\'], f[\'name\'], k, f[k] )\r\n\r\n    def getFields( self, table, exclude=False ):\r\n        result = []\r\n        for i,r in enumerate(self.tables):\r\n            if self.tables[i].table == table:\r\n                for field in self.tables[i].fields:\r\n                    add = True\r\n                    if not type( exclude ) == bool:\r\n\r\n                        if type( exclude ) == str:\r\n                            ex = exclude.split(\',\')\r\n                        else:\r\n                            ex = exclude\r\n\r\n                        for x in ex:\r\n                            if len( x ) > 0:\r\n                                if x in field.name:\r\n                                    add = False\r\n                    if add:\r\n                        result.append( field.name )\r\n\r\n        return result\r\n\r\n    def getFieldType( self, table, field ):\r\n        result = \'\'\r\n        for i,r in enumerate(self.tables):\r\n            if self.tables[i].table == table:\r\n                for fieldX in self.tables[i].fields:\r\n                    if fieldX.name == field:\r\n                        result = fieldX.info[\'type\']\r\n        return result\r\n\r\n    # def update( self, info ):\r\n\r\n    #   sql = "update "+info[\'table\']+" set [x] where " + info[\'update\'] + " "\r\n    #   u = \'\'\r\n    #   for f in info[\'record\'].keys():\r\n    #       t = self.getFieldType( info[\'table\'], f )\r\n    #       if \'int\' in t:\r\n    #           u += f + " = " + str(info[\'record\'][f]) + ","\r\n    #       else:\r\n    #           u += f + " = \'" + str(info[\'record\'][f]) + "\',"\r\n    #   u = _str.cleanBE( u, \',\' )\r\n\r\n    #   sql = sql.replace( \'[x]\', u )\r\n\r\n    #   conn = sqlite3.connect( self.file )\r\n    #   cursor = conn.cursor()\r\n    #   tables = []\r\n    #   rows = cursor.execute( sql )\r\n\r\n    #   fields = self.getFields( info[\'table\'] )\r\n    #   results = []\r\n    #   for row in (rows):\r\n    #       d = {}\r\n    #       for i,column in enumerate(row):\r\n    #           d[ fields[i] ] = row[i]\r\n    #       results.append( d )\r\n    #   conn.commit()\r\n    #   conn.close()\r\n\r\n    def update( self, info ):\r\n        sqlite3 = __.imp(\'sqlite3\')\r\n        sql = "update "+info[\'table\']+" set [x] where " + info[\'update\'] + " "\r\n        u = \'\'\r\n        for f in info[\'record\'].keys():\r\n            t = self.getFieldType( info[\'table\'], f )\r\n            if \'int\' in t:\r\n                u += f + " = " + str(info[\'record\'][f]) + ","\r\n            else:\r\n                u += f + " = \'" + str(info[\'record\'][f]) + "\',"\r\n        u = _str.cleanBE( u, \',\' )\r\n\r\n        sql = sql.replace( \'[x]\', u )\r\n\r\n        conn = sqlite3.connect( self.file )\r\n        cursor = conn.cursor()\r\n        tables = []\r\n        rows = cursor.execute( sql )\r\n\r\n        fields = self.getFields( info[\'table\'] )\r\n        results = []\r\n        for row in (rows):\r\n            d = {}\r\n            for i,column in enumerate(row):\r\n                d[ fields[i] ] = row[i]\r\n            results.append( d )\r\n        conn.commit()\r\n        conn.close()\r\n\r\n    def search( self, info ):\r\n        sqlite3 = __.imp(\'sqlite3\')\r\n        if not self.initializedDB:\r\n            print_( \'no data\' )\r\n            sys.exit()\r\n\r\n        if not type( info[\'custom\'] ) == bool and not info[\'force\']:\r\n            sql = "select * from "+info[\'table\']+" where "+info[\'custom\']\r\n        elif info[\'force\'] and not type( info[\'custom\'] ) == bool:\r\n            sql = info[\'custom\']\r\n        else:\r\n            if info[\'type\'] == \'text\':\r\n                sql = "select * from "+info[\'table\']+" where "+info[\'field\']+" like \'"+info[\'search\']+"\'"\r\n            else:\r\n                sql = "select * from "+info[\'table\']+" where "+info[\'field\']+" "+info[\'search\']\r\n\r\n        conn = sqlite3.connect( self.file )\r\n        cursor = conn.cursor()\r\n        tables = []\r\n        rows = cursor.execute( sql )\r\n\r\n        fields = self.getFields( info[\'table\'] )\r\n        results = []\r\n        for row in (rows):\r\n            d = {}\r\n            for i,column in enumerate(row):\r\n                # d[ fields[i] ] = row[i]\r\n                d[ fields[i] ] = self.trigger( info[\'table\'], fields[i], row[i] )\r\n            results.append( d )\r\n\r\n        conn.close()\r\n\r\n        return results\r\n        # print_( info )\r\n    def trigger( self, table, field, data ):\r\n        result = data\r\n        if field == \'date_created\':\r\n            return resolveEpochTest( data )\r\n        for i,r in enumerate(self.tables):\r\n            if self.tables[i].table == table:\r\n                for fieldX in self.tables[i].fields:\r\n                    if fieldX.name == field:\r\n                        if not type( fieldX.info[\'trigger\'] ) == bool:\r\n                            result = fieldX.info[\'trigger\']( data )\r\n        return result\r\n\r\n\r\n    def insertRecords( self, table, records=[] ):\r\n        sqlite3 = __.imp(\'sqlite3\')\r\n        if len( records ) > 0:\r\n            self.records = records\r\n            for i,r in enumerate(self.records):\r\n                self.records[i][\'date_created\'] = time.time()\r\n                self.records[i][\'date_modified\'] = \'\'\r\n        self.generateStructure( table )\r\n\r\n        conn = sqlite3.connect(self.file)\r\n        cursor = conn.cursor()\r\n        for record in self.records:\r\n            # self.records[i][\'date_created\'] = time.time()\r\n            record[\'date_created\'] = time.time()\r\n            record[\'date_modified\'] = \'\'\r\n            sql = self.genRecordInsert( table, record )\r\n            # n = \'\'\r\n\r\n            # for field in fields:\r\n            #   n += field[\'name\'] + \' \' + field[\'type\'] + \',\'\r\n\r\n            # n = _str.cleanBE( n, \',\' )\r\n            # sql = sql.replace( \'[n]\', n )\r\n\r\n\r\n            cursor.execute( sql )\r\n            conn.commit()\r\n        conn.close()\r\n\r\n\r\n\r\n    def genRecordInsert( self, table, record ):\r\n        b = "\'insert into [table] ( [names] ) values ( [dataDel] )\'.format( [data] )"\r\n        n = \'\'\r\n        dd = \'\'\r\n        d = \'\'\r\n        b = b.replace( \'[table]\', table )\r\n        x = []\r\n\r\n        for k in record.keys():\r\n            n += k + \',\'\r\n            d += "record[\'"+k+"\'],"\r\n            dd += \'"{}",\'\r\n            x.append( record[k] )\r\n        n = _str.cleanBE( n, \',\' )\r\n        dd = _str.cleanBE( dd, \',\' )\r\n        d = _str.cleanBE( d, \',\' )\r\n\r\n        b = b.replace( \'[names]\', n )\r\n        b = b.replace( \'[dataDel]\', dd )\r\n        b = b.replace( \'[data]\', d )\r\n        # print_( b )\r\n        return eval( b )\r\n\r\n\r\n    def genInfo( self, process=False ):\r\n        sqlite3 = __.imp(\'sqlite3\')\r\n        if os.path.isfile( self.file ) and not self.initializedDB:\r\n            self.initializedDB = True\r\n            self.tableInfo = []\r\n            sql = "select name from sqlite_master where type = \'table\'"\r\n\r\n            conn = sqlite3.connect( self.file )\r\n            cursor = conn.cursor()\r\n            tables = []\r\n            tablesRaw = cursor.execute( sql )\r\n            for table in tablesRaw:\r\n                for data in table:\r\n                    if len( data ) > 1 and not \'sqlite\' in data:\r\n                        tables.append( data )\r\n\r\n            # print_( tables )\r\n\r\n            for table in tables:\r\n                sql = \'PRAGMA table_info(\'+table+\')\'\r\n                fieldsRaw = cursor.execute( sql )\r\n                fields = []\r\n                for fieldsX in fieldsRaw:\r\n\r\n                    if not type( self.fieldsManual ) == bool:\r\n                        data = list(filter(lambda itemX: itemX[\'name\'] == fieldsX[1], self.fieldsManual))\r\n                        if len( data ) > 0:\r\n                            data[0][ \'type\' ] = fieldsX[2]\r\n                            fields.append( data[0] )\r\n                        else:\r\n                            fields.append({ \'name\': fieldsX[1], \'type\': fieldsX[2],  })\r\n                    else:\r\n                        fields.append({ \'name\': fieldsX[1], \'type\': fieldsX[2],  })\r\n\r\n                    \r\n                \r\n                self.tableInfo.append({ \'name\': table, \'fields\': fields })\r\n\r\n            conn.close()\r\n            if process:\r\n                self.addGeneratedTables()\r\n            return self.tableInfo\r\n\r\n    def addGeneratedTables( self ):\r\n        dataOK = True\r\n        if not type( self.records ) == bool:\r\n\r\n            for record in self.processRecords():\r\n                found = False\r\n                for table in self.tableInfo:\r\n                    for field in table[\'fields\']:\r\n                        if record[\'name\'] == field:\r\n                            found = True\r\n                if not found:\r\n                    dataOK = False\r\n            \r\n        for table in self.tableInfo:\r\n            self.tables.append( DatabaseTables( table[\'name\'], table[\'fields\'] ) )\r\n            self.updateManualFieldInfo()\r\n\r\n    def processRecords( self ):\r\n        autoFieldType = []\r\n        for record in self.records:\r\n\r\n            for field in record.keys():\r\n                if len(list(filter(lambda itemX: itemX[\'name\'] == field, autoFieldType))) == 0:\r\n                    if isText( record[ field ] ):\r\n                        t = \'text\'\r\n                        if \'date_\' in field:\r\n                            t = \'date\'\r\n                        if not type( self.fieldsManual ) == bool:\r\n                            data = list(filter(lambda itemX: itemX[\'name\'] == field, self.fieldsManual))\r\n                            if len( data ) > 0:\r\n                                data[0][ \'type\' ] = t\r\n                                autoFieldType.append( data[0] )\r\n                            else:\r\n                                autoFieldType.append({ \'name\': field, \'type\': t })\r\n                        else:\r\n                            autoFieldType.append({ \'name\': field, \'type\': t })\r\n                    if isNum( record[ field ] ):\r\n                        t = \'integer\'\r\n                        if \'date_\' in field:\r\n                            t = \'date\'\r\n                        if not type( self.fieldsManual ) == bool:\r\n                            data = list(filter(lambda itemX: itemX[\'name\'] == field, self.fieldsManual))\r\n                            if len( data ) > 0:\r\n                                data[0][ \'type\' ] = t\r\n                                autoFieldType.append( data[0] )\r\n                            else:\r\n                                autoFieldType.append({ \'name\': field, \'type\': t })\r\n                        else:\r\n                            autoFieldType.append({ \'name\': field, \'type\': t })\r\n                    if isFloat( record[ field ] ):\r\n                        t = \'real\'\r\n                        if \'date_\' in field:\r\n                            t = \'date\'\r\n                        if not type( self.fieldsManual ) == bool:\r\n                            data = list(filter(lambda itemX: itemX[\'name\'] == field, self.fieldsManual))\r\n                            if len( data ) > 0:\r\n                                data[0][ \'type\' ] = t\r\n                                autoFieldType.append( data[0] )\r\n                            else:\r\n                                autoFieldType.append({ \'name\': field, \'type\': t })\r\n                        else:\r\n                            autoFieldType.append({ \'name\': field, \'type\': t })\r\n\r\n\r\n        return autoFieldType\r\n\r\n    def fieldInfo( self, table, field, fType ):\r\n        self.fields[ field ] = fType\r\n\r\n    def create( self, table=False, fields=False ):\r\n        sqlite3 = __.imp(\'sqlite3\')\r\n        if os.path.isfile(self.file):\r\n            print_( \'Database exists\' )\r\n        else:\r\n            conn = sqlite3.connect(self.file)\r\n            cursor = conn.cursor()\r\n            # sql =  \'CREATE TABLE \'+table+\' ([n])\'\r\n            sql =  \'CREATE TABLE \'+table+\' (id integer primary key autoincrement not null, [n])\'\r\n            n = \'\'\r\n            nn = \'\'\r\n            for field in fields:\r\n                n += field[\'name\'] + \' \' + field[\'type\'] + \',\'\r\n                if not \'date_modified\' == field[\'name\']:\r\n                    nn += field[\'name\'] + \',\'\r\n\r\n            n = _str.cleanBE( n, \',\' )\r\n            nn = _str.cleanBE( nn, \',\' )\r\n            sql = sql.replace( \'[n]\', n )\r\n            cursor.execute( sql )\r\n            sql =   "CREATE TRIGGER UpdateLastTime UPDATE OF "+nn+" ON "+table+" "\\\r\n                    " BEGIN"\\\r\n                    "  UPDATE "+table+" SET date_modified=datetime(\'now\',\'localtime\') WHERE id=old.id;"\\\r\n                    " END;"\r\n            cursor.execute( sql )\r\n\r\n            conn.close()\r\n\r\n\r\n\r\nclass DatabaseTables:\r\n    def __init__( self, table=False, fields=False ):\r\n        \r\n        self.fields = []\r\n\r\n        self.table = table\r\n\r\n        if not type( fields ) == bool:\r\n            for i,field in enumerate(fields):\r\n                idx = len( self.fields )\r\n                self.fields.append( DatabaseFields( field[\'name\'], field[\'type\'] ) )\r\n                for label in field.keys():\r\n                    if not label == \'name\' and not label == \'type\' and not label == \'table\':\r\n                        self.fields[ idx ].addFieldInfo( label, field[ label ] )\r\n\r\n    def setInfo( self, field, label, info ):\r\n        for i,row in enumerate(self.fields):\r\n            if self.fields[i].name == field:\r\n                self.fields[i].info[ label ] = info\r\n\r\n\r\n    def setFields( self, fields=False ):\r\n        if not type( fields ) == bool:\r\n            for i,field in enumerate(fields):\r\n                idx = len( self.fields )\r\n                self.fields.append( DatabaseFields( field[\'name\'], field[\'type\'] ) )\r\n                for label in field.keys():\r\n                    if not label == \'name\' and not label == \'type\' and not label == \'table\':\r\n                        self.fields[ idx ].addFieldInfo( label, field[ label ] )\r\n\r\n    def updateFieldInfo( self, field, label, data ):\r\n        for i,f in enumerate(self.fields):\r\n            if self.fields[i].name == field:\r\n                self.fields[i].info[ label ] = data\r\n\r\n\r\nclass DatabaseFields:\r\n    def __init__( self, name=False, fieldType=\'text\' ):\r\n        self.name = name\r\n\r\n        self.info = {\r\n                        \'name\': name,\r\n                        \'type\': fieldType,\r\n                        \'trigger\': False,\r\n                        \'default\': False,\r\n        }\r\n\r\n    def addFieldInfo( self, label, info ):\r\n        self.info[ label ] = info\r\n\r\n    def fieldInfo( self, label ):\r\n        if label in list( self.info.keys() ):\r\n            return self.info[ label ]\r\n        else:\r\n            return False\r\n\r\n\r\n\r\n###########################################################################################\r\n###########################################################################################\r\n\r\nclass Database2:\r\n\r\n    def __init__(self, data):\r\n\r\n        appDB = \'_Generated_App_Database.db\'\r\n        appJSON = \'_Generated_App_Database_Config.json\'\r\n        appPyRaw = \'_Gen_App_Database_Data\'\r\n        appPy = appPyRaw + \'.py\'\r\n        self.appPyDefault = _v.myDatabases + _v.slash+\'_default.py\'\r\n\r\n\r\n        self.data = {}\r\n        self.tables = []\r\n        self.name = data.replace(appDB,\'\').replace(appJSON,\'\').replace(appPy,\'\').replace(\'.json\',\'\')\r\n        if os.path.isfile(self.name + appDB):\r\n            self.appDB =   self.name + appDB\r\n            self.appJSON = self.name + appJSON\r\n            self.appPy =   self.name + appPy\r\n\r\n        else:\r\n            self.appDB = _v.myDatabases + _v.slash + self.name + appDB\r\n            self.appJSON = _v.myDatabases + _v.slash + self.name + appJSON\r\n            self.appPy = _v.myDatabases + _v.slash + self.name + appPy\r\n        self.appPyRaw = self.name + appPyRaw\r\n\r\n        self.tableDelim = \'_x_\'\r\n\r\n        self.meta = []\r\n\r\n    def registerTable(self, name):\r\n        self.tables.append(TablesDB(name))\r\n\r\n    def TableFieldCount(self):\r\n        result = 0\r\n        for i,ci in enumerate(self.tables):\r\n            if ci.name == name:\r\n                result = self.tables[i].getCount()\r\n        return result\r\n# {\r\n#   \'table\': \'table,name\',\r\n#   \'fields\': [\r\n#       {\'names\': \'one,two\'},\r\n#       {\'names\': \'three\', \'table\': \'name\', \'as\': \'threeish\'}\r\n#   ],\r\n#   \'action\': [\r\n#       { \'type\': \'text\', \'names\': \'field\', \'table\': \'your_mom\', \'search\': \'*.txt,desktop\'},\r\n#       { \'type\': \'text\', \'names\': \'testy\', \'and_or\': \'or\', \'table\': \'or_test\', \'search\': \'*.py,*.txt\'},\r\n#       { \'type\': \'field_type(text)\', \'table\': \'name\', \'names\': \'field,names\', \'and_or\': \'and\',  \'search\': \'*.py,tech\'},\r\n#       { \'type\': \'field_type(number)\', \'names\': \'field,names\', \'search\': \'1000,2000\'},\r\n#       { \'type\': \'field_type(number)\', \'names\': \'field,names\', \'search\': \'g,1000\'},\r\n#       { \'type\': \'field_type(number)\', \'names\': \'field,names\', \'search\': \'l,1000\'},\r\n#       { \'type\': \'field_type(number)\', \'names\': \'field,names\', \'search\': \'str(ago(2000))\'},\r\n#       { \'type\': \'field_type(number)\', \'names\': \'field,names\', \'search\': \'str(epoch(2018.07))\'},\r\n#       { \'type\': \'field_type(number)\', \'names\': \'field,names\', \'search\': \'str(epoch(2018.07)),str(epoch(\'2018.10\',True))\'},\r\n#       { \'type\': \'field_type(sort)\', \'names\': \'field\', \'order\': \'asc\'},\r\n#       { \'type\': \'field_type(sort)\', \'names\': \'field\', \'order\': \'desc\'},\r\n#   ]\r\n# } \r\n\r\n    def queryBuilder(self,data): # queryBuilder\r\n        self.data = data\r\n        # print_(data[\'fields\'])\r\n        # sys.exit()\r\n        self.qbFields = []\r\n        tbls = data[\'table\'].split(\',\')\r\n        if len(tbls) > 1:\r\n            multi_Table = True\r\n        else:\r\n            multi_Table = False\r\n        if multi_Table:\r\n            sql = \'SELECT \'\r\n            # print_(data[\'fields\'])\r\n            for field in data[\'fields\']:\r\n                for name in field[\'names\'].split(\',\'):\r\n                    thisT = \'\'\r\n                    try:\r\n                        thisT = field[\'table\']\r\n                    except Exception as e:\r\n                        thisT =  tbls[0]\r\n                    try:\r\n                        asF = field[\'as\']\r\n                    except Exception as e:\r\n                        asF =  name\r\n                    name = "" + thisT + \'.\' + name + " AS " + asF\r\n                    self.qbFields.append(asF)\r\n                    sql += name + \', \'\r\n            sql = _str.cleanLast(sql,\', \')\r\n            sql += \' FROM \' + tbls[0] + \' \'\r\n            for iJ,tJ in enumerate(tbls):\r\n                if iJ > 0:\r\n                    sql += \' JOIN \' + tJ + \' ON \' + tJ + \'.id_parent = \' + tbls[0] + \'.id_uuid \'\r\n                \r\n            sql += \' WHERE \'\r\n        else:\r\n            sql = \'SELECT \'\r\n            for field in data[\'fields\']:\r\n                for name in field[\'names\'].split(\',\'):\r\n                    thisT = \'\'\r\n                    try:\r\n                        thisT = field[\'table\']\r\n                    except Exception as e:\r\n                        thisT =  tbls[0]\r\n                    try:\r\n                        asF = field[\'as\']\r\n                    except Exception as e:\r\n                        asF =  name\r\n                    name = "" + thisT + \'.\' + name + " AS " + asF\r\n                    self.qbFields.append(asF)\r\n                    sql += name + \', \'\r\n            sql = _str.cleanLast(sql,\', \')\r\n            sql += \' FROM \' + tbls[0] + \' WHERE \'\r\n        # JOIN albums ON albums.albumid = tracks.albumid\r\n        orderBy = False\r\n        for i,action in enumerate(data[\'action\']):\r\n            if action[\'type\'] == \'text\':\r\n                sql += \'(\'\r\n                for name in action[\'names\'].split(\',\'):\r\n                    if multi_Table:\r\n                        try:\r\n                            thisT =  action[\'table\']\r\n                        except Exception as e:\r\n                            thisT =  tbls[0]\r\n                        name = "" + thisT + \'.\' + name + ""\r\n                    try:\r\n                        and_or = action[\'and_or\']\r\n                    except Exception as e:\r\n                        and_or =  \'and\'\r\n                    for tv in action[\'search\'].split(\',\'):\r\n                        if tv.startswith(\'*\'):\r\n                            tv = tv.replace(\'*\',\'\')\r\n                            sql += \' \' + name + " like \'%" + tv + "\' " + and_or + \' \'\r\n                        elif tv.endswith(\'*\'):\r\n                            tv = tv.replace(\'*\',\'\')\r\n                            sql += \' \' + name + " like \'" + tv + "%\' " + and_or + \' \'\r\n                        else:\r\n                            sql += \' \' + name + " like \'%" + tv + "%\' " + and_or + \' \'\r\n                sql = _str.replaceDuplicate(sql,\' \')\r\n                sql = _str.cleanLast(sql,\' and \')\r\n                sql = _str.cleanLast(sql,\' or \')\r\n                sql += \') and \'\r\n            sql = sql.replace(\'WHERE and \',\'WHERE \')\r\n            if action[\'type\'] == \'number\':\r\n                for name in action[\'names\'].split(\',\'):\r\n                    if multi_Table:\r\n                        try:\r\n                            thisT =  action[\'table\']\r\n                        except Exception as e:\r\n                            thisT =  tbls[0]\r\n                        name = "\'" + thisT + \'.\' + name + "\'"\r\n\r\n                    coin = action[\'search\'].split(\',\')\r\n                    if not len(coin) == 2:\r\n                        print_(\'bad input\')\r\n                        sys.exit()\r\n                    if isNu(coin[0]):\r\n                        do = \'b\'\r\n                    else:\r\n                        do = coin[0]\r\n                    if do == \'b\':\r\n                        sql += name + \' > \' + str(coin[0]) + " and " + name + " < " + str(coin[1]) + \' and \'\r\n                    if do == \'l\':\r\n                        sql += name + \' < \' + str(coin[1]) + \' and \'\r\n                    if do == \'g\':\r\n                        sql += name + \' > \' + str(coin[1]) + \' and \'\r\n\r\n\r\n\r\n            if action[\'type\'] == \'date\':\r\n                for name in action[\'names\'].split(\',\'):\r\n                    if multi_Table:\r\n                        try:\r\n                            thisT =  action[\'table\']\r\n                        except Exception as e:\r\n                            thisT =  tbls[0]\r\n                        name = "\'" + thisT + \'.\' + name + "\'"\r\n\r\n                    coin = action[\'search\'].split(\',\')\r\n                    if not len(coin) == 2:\r\n                        if isNu2(coin[0]):\r\n                            sql += name + \' > \' + str(epoch(coin[0])) + \' and \'\r\n                        else:\r\n                            sql += name + \' > \' + str(timeAgo(coin[0])) + \' and \'\r\n                    else:\r\n                        if isNu2(coin[0]):\r\n                            do = \'b\'\r\n                        else:\r\n                            do = coin[0]\r\n                        if do == \'b\':\r\n                            sql += name + \' > \' + str(epoch(coin[0])) + " and " + name + " < " + str(epoch(coin[1],True)) + \' and \'\r\n                        if do == \'l\':\r\n                            sql += name + \' < \' + str(epoch(coin[1])) + \' and \'\r\n                        if do == \'g\':\r\n                            sql += name + \' > \' + str(epoch(coin[1])) + \' and \'\r\n\r\n\r\n\r\n            if action[\'type\'] == \'bytes\':\r\n                for name in action[\'names\'].split(\',\'):\r\n                    if multi_Table:\r\n                        try:\r\n                            thisT =  action[\'table\']\r\n                        except Exception as e:\r\n                            thisT =  tbls[0]\r\n                        name = "\'" + thisT + \'.\' + name + "\'"\r\n\r\n                    coin = action[\'search\'].split(\',\')\r\n                    if coin[0] == \'l\':\r\n                        sql += name + \' < \' + str(unFormatSize(coin[1])) + \' and \'\r\n                    elif coin[0] == \'g\':\r\n                        sql += name + \' > \' + str(unFormatSize(coin[1])) + \' and \'\r\n                    else:\r\n                        sql += name + \' > \' + str(unFormatSize(coin[0])) + " and " + name + " < " + str(unFormatSize(coin[1])) + \' and \'\r\n\r\n\r\n\r\n            if action[\'type\'] == \'sort\':\r\n                orderBy = True\r\n        sql = _str.cleanLast(sql,\' and \')\r\n        sql = _str.cleanLast(sql,\' or \')\r\n        if orderBy:\r\n            sql += \' ORDER BY \'\r\n            for i,action in enumerate(data[\'action\']):\r\n                if action[\'type\'] == \'sort\':\r\n                    try:\r\n                        if \'a\' in action[\'order\'].lower():\r\n                            order = \'ASC\'\r\n                        else:\r\n                            order = \'DESC\'\r\n                    except Exception as e:\r\n                        order = \'ASC\'\r\n                    for name in action[\'names\'].split(\',\'):\r\n                        if multi_Table:\r\n                            try:\r\n                                thisT =  action[\'table\']\r\n                            except Exception as e:\r\n                                thisT =  tbls[0]\r\n                            name = "\'" + thisT + \'.\' + name + "\'"\r\n                        sql += name + \' \' + order + \', \'\r\n\r\n        sql = _str.cleanLast(sql,\' and \')\r\n        sql = _str.cleanLast(sql,\' or \')\r\n        sql = _str.cleanLast(sql,\', \')\r\n        sql = _str.replaceDuplicate(sql,\' \')\r\n        sql = _str.cleanLast(sql,\' \')\r\n        sql += \';\'\r\n        sql = sql.replace(\'WHERE;\',\';\')\r\n        return sql\r\n    def metaGen(self):\r\n        sqlite3 = __.imp(\'sqlite3\')\r\n        import re\r\n        # import numpy as np\r\n        meta = []\r\n        con = sqlite3.connect(self.appDB)\r\n        for line in con.iterdump():\r\n            if \'CREATE TABLE\' in line and not \'INSERT INTO\' in line:\r\n                # print_(line)\r\n                one = line.split(\'CREATE TABLE \')[1]\r\n                two = one.split(\' (\')\r\n                table = two[0]\r\n                # print_(table)\r\n                fieldRaw = two[1].split(\')\')[0]\r\n                f = []\r\n                for field in fieldRaw.split(\', \'):\r\n                    # print_(\'\\t\',field)\r\n                    fd = field.split(\' \')\r\n                    f.append({\'type\': fd[1], \'field\': fd[0], \'max\': 0, \'min\': 0, \'average\': 0})\r\n\r\n\r\n                if self.tableDelim in table:\r\n                    parent = \'\'\r\n                    mx = len(table.split(self.tableDelim))-1\r\n                    for iT,tX in enumerate(table.split(self.tableDelim)):\r\n                        if iT < mx:\r\n                            parent += tX + self.tableDelim\r\n                    parent = _str.cleanLast(parent,self.tableDelim)\r\n                else:\r\n                    parent = \'\'\r\n\r\n\r\n                meta.append({\'table\': table, \'parent\': parent, \'fields\': f})\r\n            elif \'INSERT INTO\' in line:\r\n                pass\r\n                # break\r\n        average = {}\r\n        for im,m in enumerate(meta):\r\n            sql = \'SELECT * FROM \' + m[\'table\']\r\n            conn = sqlite3.connect(self.appDB)\r\n            c = conn.cursor()\r\n            c.execute(sql)\r\n            rows = c.fetchall()\r\n            for row in rows:\r\n                # print_(row)\r\n                for fi,field in enumerate(m[\'fields\']):\r\n                    # print_(field[\'field\'],row[fi])\r\n                    aKey = str(m[\'table\']) + \'-\' + str(number2Words(field[\'field\']))\r\n                    # print_(aKey)\r\n                    \r\n                    try:\r\n                        if not type(average[aKey][\'datapoints\']) == list:\r\n                            average[aKey] = {\'max\': 0, \'min\': \'first\', \'average\': 0, \'datapoints\': [], \'count\': 0}\r\n\r\n                        # print_(type())                     \r\n                    except Exception as e:\r\n                        average[aKey] = {\'max\': 0, \'min\': \'first\', \'average\': 0, \'datapoints\': [], \'count\': 0}\r\n                    average[aKey]\r\n                    # print_(aKey)\r\n                    if field[\'type\'] == \'int\':\r\n                        if type(row[fi]) == int:\r\n                            size = row[fi]\r\n                        else:\r\n                            string = re.sub(\'[^0-9]\', \'\', str(row[fi]))\r\n                            # print_(type(string),string)\r\n                            # print_(string)\r\n                            if len(string) == 0:\r\n                                size = 0\r\n                            else:\r\n                                size = int(string)\r\n                    if field[\'type\'] == \'str\':\r\n                        size = len(str(row[fi]))\r\n                    # print_()\r\n                    # print_(type(average[aKey][\'max\']),average[aKey][\'max\'])\r\n                    # print_(type(size),size)\r\n                    if average[aKey][\'max\'] < size:\r\n                        average[aKey][\'max\'] = size\r\n                    if average[aKey][\'min\'] == \'first\':\r\n                        average[aKey][\'min\'] = size\r\n                    elif average[aKey][\'min\'] > size:\r\n                        average[aKey][\'min\'] = size\r\n                    average[aKey][\'datapoints\'].append(size)\r\n\r\n        errors = []\r\n        totalCount = 0\r\n        for im,m in enumerate(meta):\r\n\r\n            for row in rows:\r\n                # print_(row)\r\n                for fi,field in enumerate(m[\'fields\']):\r\n                    # print_(meta[im][\'fields\'][fi][\'max\'])\r\n                    aKey = m[\'table\'] + \'-\' + number2Words(field[\'field\'])\r\n                    # print_(aKey)\r\n                    try:\r\n                        # print_(average[aKey][\'max\'])\r\n                        meta[im][\'fields\'][fi][\'max\'] = average[aKey][\'max\']\r\n                        meta[im][\'fields\'][fi][\'min\'] = average[aKey][\'min\']\r\n                        # meta[im][\'fields\'][fi][\'average\'] = int(np.mean(average[aKey][\'datapoints\']))\r\n                        meta[im][\'count\'] = len(average[aKey][\'datapoints\'])\r\n                        total = meta[im][\'count\']\r\n                    except Exception as e:\r\n                        errors.append(aKey)\r\n                totalCount += total\r\n\r\n        self.meta = {\'data\': meta, \'records\': totalCount, \'errors\': errors}\r\n        saveTable2(meta,\'database_meta.json\')\r\n\r\n        return meta\r\n    def metaPrint(self):\r\n        if self.meta == []:\r\n            self.metaGen()\r\n\r\n        totalColumnWidth = 0\r\n        for m in self.meta[\'data\']:\r\n            tables.register(m[\'table\'],m[\'fields\'])\r\n            spaces = tables.getLength(m[\'table\'],\'type,field,max,min,average\')\r\n            if spaces > totalColumnWidth:\r\n                totalColumnWidth = spaces\r\n\r\n\r\n\r\n        # fieldLengths = 0\r\n        # for m in self.meta[\'data\']:\r\n        #   tables.register(m[\'table\'],m[\'fields\'])\r\n        #   data = tables.getFieldLengths(m[\'table\'],\'type,field,max,min,average\')\r\n        #   if not type(fieldLengths) == dict:\r\n        #       fieldLengths = data\r\n        #   for name in fieldLengths.keys():\r\n        #       if data[name] > fieldLengths[name]:\r\n        #           fieldLengths[name] = data[name]\r\n\r\n\r\n\r\n        for m in self.meta[\'data\']:\r\n            genLine(totalColumnWidth,\'=\')\r\n            print_(\'Table:\\t\',m[\'table\'])\r\n            print_(\'Parent:\\t\',m[\'parent\'])\r\n            print_(\'Records:\',m[\'count\'])\r\n            print_()\r\n            tables.register(m[\'table\'],m[\'fields\'])\r\n            # tables.fieldProfileSet(m[\'table\'],\'*\',\'alignment\',\'center\')\r\n            # tables.print(m[\'table\'],\'type,field,max,min,average\',fieldLengths)\r\n            tables.print(m[\'table\'],\'type,field,max,min,average\')\r\n\r\n            genLine(totalColumnWidth,\'=\')\r\n        print_()\r\n        print_(\'Records:\',self.meta[\'records\'])\r\n        print_()\r\n        print_(\'Errors:\')\r\n        for e in self.meta[\'errors\']:\r\n            print_(\'\\t\',e)\r\n        print_()\r\n        print_()\r\n        print_(\'Example:\')\r\n        print_(\'\\t p dba -app\',self.name)\r\n        print_()\r\n        print_()\r\n    def findParent(self,table):\r\n        # parent = \'Error\'\r\n        # for m in self.meta[\'data\']:\r\n        #   if m[\'table\'] == table:\r\n        #       parent = m[\'parent\']\r\n        #       break\r\n        if self.tableDelim in table:\r\n            parent = \'\'\r\n            mx = len(table.split(self.tableDelim))-1\r\n            for iT,tX in enumerate(table.split(self.tableDelim)):\r\n                if iT < mx:\r\n                    parent += tX + self.tableDelim\r\n            parent = _str.cleanLast(parent,self.tableDelim)\r\n        else:\r\n            parent = \'\'\r\n        return parent\r\n\r\n    def findChildren(self,table):\r\n        if self.meta == []:\r\n            self.metaGen()\r\n        children = []\r\n        for m in self.meta[\'data\']:\r\n            if m[\'parent\'] == table:\r\n                children.append(m[\'table\'])\r\n\r\n        return children\r\n\r\n    def findType(self,column):\r\n        mainTable = self.data[\'table\'].split(\',\')[0]\r\n        found = False\r\n        nm = \'\'\r\n        result = \'\'\r\n\r\n        for action in self.data[\'fields\']:\r\n            for name in action[\'names\'].split(\',\'):\r\n                if name == column:\r\n                    try:\r\n                        if action[\'type\'] == \'date\' or \'byte\' in action[\'type\']:\r\n                            result = action[\'type\']\r\n                    except Exception as e:\r\n                        pass\r\n\r\n        if len(result) == 0:\r\n            for action in self.data[\'action\']:\r\n                for name in action[\'names\'].split(\',\'):\r\n                    if name == column:\r\n                        if action[\'type\'] == \'date\' or \'byte\' in action[\'type\']:\r\n                            result = action[\'type\']\r\n\r\n        if len(result) == 0:\r\n            for field in self.data[\'fields\']:\r\n                try:\r\n                    table = field[\'table\']\r\n                except Exception as e:\r\n                    table = mainTable\r\n                if \',\' in field[\'names\']:\r\n                    for name in field[\'names\'].split(\',\'):\r\n                        if name == column:\r\n                            nm = name\r\n                            found = True\r\n                else:\r\n                    try:\r\n                        newName = field[\'as\']\r\n                    except Exception as e:\r\n                        newName = field[\'names\']\r\n                    if newName == column:\r\n                        nm = newName\r\n                        found = True\r\n                # print_(field)\r\n                if found:\r\n                    break\r\n\r\n            result = self.checkConfig(table,nm)\r\n        # print_(mainTable)\r\n        return result\r\n    def checkConfig(self,tbl,nm):\r\n        self.appJSON\r\n        # print_(self.appJSON)\r\n        # print_(tbl,nm)\r\n        structure = getTable2(self.appJSON)\r\n        result = \'\'\r\n        if tbl == structure[\'name\']:\r\n            for zs in structure[\'zstructure\']:\r\n                if zs[\'field\'] == nm:\r\n                    result = zs[\'type\']\r\n                    break\r\n        return result\r\n\r\n    def executeSQL(self,sql,group=0):\r\n        sqlite3 = __.imp(\'sqlite3\')\r\n        conn = sqlite3.connect(self.appDB)\r\n        c = conn.cursor()\r\n        c.execute(sql)\r\n        all_rows = c.fetchall()\r\n        records = []\r\n        for f in all_rows:\r\n            row = {}\r\n            for ic,c in enumerate(self.qbFields):\r\n                row[c] = f[ic]\r\n\r\n            records.append(row)\r\n        col = \'\'\r\n        for c in self.qbFields:\r\n            col += c + \',\'\r\n        col = _str.cleanLast(col,\',\')\r\n        tables.register(\'sql\',records)\r\n        for ic,c in enumerate(self.qbFields):\r\n            if self.findType(c) == \'date\':\r\n                tables.fieldProfileSet(\'sql\',c,\'trigger\',float2Date2)\r\n            if \'byte\' in self.findType(c):\r\n                tables.fieldProfileSet(\'sql\',c,\'trigger\',formatSize)\r\n            if self.findType(c) == \'bytes\':\r\n                tables.fieldProfileSet(\'sql\',c,\'trigger\',formatSize)\r\n            # print_(self.findType(c))\r\n        tables.print(\'sql\',col)\r\n\r\n\r\n\r\nclass TablesDB:\r\n\r\n    def __init__(self):\r\n        self.columns = []\r\n\r\n    def register(self, name):\r\n        self.columns.append(ColumnsDB(name))\r\n        self.fieldCount = len(self.columns)\r\n\r\n    def getCount(self):\r\n        return self.fieldCount\r\n\r\n\r\nclass ColumnsDB:\r\n\r\n    def __init__(self, name, kind):\r\n        self.name = name\r\n        self.active = False\r\n        self.kind = kind\r\n\r\n    # def trigger(self,script):\r\n    #   self.script_trigger = script\r\n\r\n    # def changeStatus(self,newStatus):\r\n    #   self.active = newStatus\r\n\r\n    # def print(self):\r\n    #   childItems = []\r\n    #   for ci in self.columns:\r\n    #       childItems.append({\'name\':ci.name})\r\n    #   tables.register(\'childClassItems\',childItems)\r\n    #   # tables.trigger(\'switches\',\'switch,name\',test,True)\r\n    #   tables.print(\'childClassItems\',\'name\')\r\n\r\n\r\n    #       childItems.append({\'name\':ci.name ,\'active\':active,\'value\': value})\r\n    #   tables.register(\'childClassItems\',childItems)\r\n    #   tables.print(\'childClassItems\',\'name,active,value\')\r\n\r\n    # def status(self,name,newStatus):\r\n    #   for i,ci in enumerate(self.columns):\r\n    #       if ci.name == name:\r\n    #           self.columns[i].changeStatus(newStatus)\r\n\r\n\r\n###########################################################################################\r\ndef get_size2(obj, seen=None):\r\n    # https://medium.com/@alexmaisiura/python-how-to-reduce-memory-consumption-by-half-by-adding-just-one-line-of-code-56be6443d524\r\n    # From https://goshippo.com/blog/measure-real-size-any-python-object/\r\n    # Recursively finds size of objects\r\n    size = sys.getsizeof(obj)\r\n    if seen is None:\r\n        seen = set()\r\n    obj_id = id(obj)\r\n    if obj_id in seen:\r\n        return 0\r\n\r\n\r\n###########################################################################################\r\ndef genLine(count,what, p=1):\r\n    count = int(count)\r\n    what = str(what)\r\n    cnt = 0\r\n    result = \'\'\r\n    while cnt < count:\r\n        result += what\r\n        cnt += 1\r\n    if p:\r\n        print_(result)\r\n    return result\r\n\r\n\r\ndef ci(string): \r\n    #switchValueClean\r\n    global ciData\r\n    # print_( ciData )\r\n    # sys.exit()\r\n    for cx in ciData:\r\n        if cx[0] in string:\r\n            # print_( \'HERE\', cx )\r\n            string = string.replace( cx[0], cx[1] )\r\n    \r\n    string = string.replace( \';d;\', __.theDelim )\r\n    string = string.replace( \';delim;\', __.theDelim )\r\n    string = string.replace( \';thedelim;\', __.theDelim )\r\n    string = string.replace( \';theDelim;\', __.theDelim )\r\n\r\n\r\n\r\n    return string\r\n\r\n\r\n""" {7DB6A001-0637-4F13-B328-2B17A481CF35}\r\ndef randomTrueFalse(fix=2):\r\n    import random\r\n\r\n    global randomTrueFalseLast\r\n    global randomTrueFalseCount\r\n    global randomTrueFalseSame\r\n    try:\r\n        randomTrueFalseLast\r\n    except Exception as e:\r\n        randomTrueFalseLast = True\r\n        randomTrueFalseSame = 0\r\n        randomTrueFalseCount = 0\r\n\r\n    ran = random.randint(1,101)\r\n    result = ran % 2 == 0\r\n    i = 0\r\n    while i < fix:\r\n        i+=1\r\n        if result == randomTrueFalseLast:\r\n            ran = random.randint(1,101)\r\n            result = ran % 2 == 0\r\n\r\n    if result == randomTrueFalseLast:\r\n        randomTrueFalseSame += 1\r\n    randomTrueFalseCount += 1\r\n    randomTrueFalseLast = result\r\n    return result\r\ndef randomizeCase(string):\r\n    import random\r\n\r\n    result = \'\'\r\n    for ch in string:\r\n        if ch.isalnum():\r\n            try:\r\n                int(ch)\r\n            except Exception as e:\r\n                ran = random.randint(1,101)\r\n                test = ran % 2 == 0\r\n                if randomTrueFalse():\r\n                    ch = ch.lower()\r\n                else:\r\n                    ch = ch.upper()\r\n        result += ch\r\n    return result\r\n"""\r\n\r\n\r\ndef onlyAlpha(string):\r\n    result = \'\'\r\n    for ch in string:\r\n        if ch.isalnum():\r\n            try:\r\n                int(ch)\r\n            except Exception as e:\r\n                result += ch\r\n    return result\r\n\r\ndef onlyNumbers(string):\r\n    result = \'\'\r\n    for ch in string:\r\n        if ch.isalnum():\r\n            try:\r\n                int(ch)\r\n                result += ch\r\n            except Exception as e:\r\n                pass\r\n    return result\r\ndef onlyAlphaNumeric(string):\r\n    result = \'\'\r\n    for ch in string:\r\n        if ch.isalnum():\r\n            result += ch\r\n    return result\r\ndef longID(howMany=2):\r\n    result = \'\'\r\n    i = 0\r\n    while i < howMany:\r\n        result += genUUID()\r\n        i += 1\r\n    result = result.replace(\'}{\',\'-\')\r\n    return result\r\n\r\n\r\n# def resolveLocal(file):\r\n#   if os.path.isfile(file):\r\n# %python%\\%*.py\r\n# %phpFiles%\\%*.php\r\n# %scriptroot%\\%*.bat\r\n# %powershell%\\%*.ps1\r\n# D:\\_Scott\\S_Documents\\Projects\\self\\Powershell\\%*.ps1\r\n# %myPhp%\\%*.php\r\n# %myPowershell%\\%*.ps1\r\n# %myPython%\\%*.py\r\n# %myTables%\\%*\r\n# %myTables%\\%*.json\r\n# %myDatabases%\\%*\r\n# %myWebApp%\\%*\r\n# %USERPROFILE%\\Desktop\\%*\r\n\r\ndef formatColumns_OLD(columns):\r\n    # print_(__.appReg)\r\n    # print_(columns)\r\n    result = \'\'\r\n    if columns is None:\r\n        result = columns\r\n    else:\r\n        for c in columns.split(\',\'):\r\n            hasPre = False\r\n            if \'.\' in c or \':\' in c:\r\n                hasPre = True\r\n                c = c.replace(\':\',\'.\')\r\n                preDataR = c.split(\'.\')\r\n                preData = preDataR[0]\r\n                c = preDataR[1]\r\n\r\n            for col in appInfo[__.appReg][\'columns\']:\r\n                for a in col[\'abbreviation\'].split(\',\'):\r\n                    if a.lower() == c.lower():\r\n                        c = col[\'name\']\r\n            if hasPre:\r\n                c = preData + \'.\' + c\r\n            result += c + \',\'\r\n        result = result[:-1]\r\n    # print_(result)\r\n    return result\r\n\r\ndef formatColumns(columns):\r\n    # print_(__.appReg)\r\n    # print_(columns)\r\n    result = \'\'\r\n    if columns is None:\r\n        result = columns\r\n    else:\r\n        for c in columns.split(\',\'):\r\n            hasPre = False\r\n            if \':\' in c:\r\n                hasPre = True\r\n                # c = c.replace(\':\',\'.\')\r\n                preDataR = c.split(\':\')\r\n                preData = preDataR[0]\r\n                c = preDataR[1]\r\n\r\n            for col in appInfo[__.appReg][\'columns\']:\r\n                for a in col[\'abbreviation\'].split(\',\'):\r\n                    if a.lower() == c.lower():\r\n                        # print_(a,c)\r\n                        # sys.exit()\r\n                        c = col[\'name\']\r\n            if hasPre:\r\n                c = preData + \':\' + c\r\n            result += c + \',\'\r\n        result = result[:-1]\r\n    # print_(result)\r\n    return result\r\n\r\n\r\ndef formatColumnsSort(columns):\r\n\r\n    if type(columns) == str:\r\n        if columns.startswith(\'a.\'):\r\n            columns = \'a:\' + columns[2:]\r\n        if \',a.\' in columns:\r\n            columns = columns.replace( \',a.\', \',a:\' )\r\n\r\n        if columns.startswith(\'d.\'):\r\n            columns = \'d:\' + columns[2:]\r\n        if \',d.\' in columns:\r\n            columns = columns.replace( \',d.\', \',d:\' )\r\n\r\n\r\n    # print_(__.appReg)\r\n    # print_(columns)\r\n    result = \'\'\r\n    if columns is None:\r\n        result = columns\r\n    else:\r\n        for c in columns.split(\',\'):\r\n            hasPre = False\r\n            if \':\' in c:\r\n                hasPre = True\r\n                # c = c.replace(\':\',\'.\')\r\n                preDataR = c.split(\':\')\r\n                preData = preDataR[1]\r\n                c = preDataR[0]\r\n\r\n            for col in appInfo[__.appReg][\'columns\']:\r\n                if \'sort\' in list(col.keys()) and len(col[\'sort\']):\r\n                    for a in col[\'abbreviation\'].split(\',\'):\r\n                        if a.lower() == c.lower():\r\n                            # print_(a,c)\r\n                            # sys.exit()\r\n                            c = col[\'sort\']\r\n                else:\r\n                    for a in col[\'abbreviation\'].split(\',\'):\r\n                        if a.lower() == c.lower():\r\n                            # print_(a,c)\r\n                            # sys.exit()\r\n                            c = col[\'name\']\r\n            if hasPre:\r\n                c = preData + \':\' + c\r\n                # c = c + \'.\' + preData\r\n\r\n            result += c + \',\'\r\n        result = result[:-1]\r\n    # print_( result )\r\n    return result\r\n\r\n\r\ndef formatColumnsSortOld(columns):\r\n    # print_(__.appReg)\r\n    # print_(columns)\r\n    result = \'\'\r\n    if columns is None:\r\n        result = columns\r\n    else:\r\n        for c in columns.split(\',\'):\r\n            hasPre = False\r\n            if \'.\' in c or \':\' in c:\r\n                hasPre = True\r\n                c = c.replace(\':\',\'.\')\r\n                preDataR = c.split(\'.\')\r\n                preData = preDataR[1]\r\n                c = preDataR[0]\r\n\r\n            for col in appInfo[__.appReg][\'columns\']:\r\n                if \'sort\' in list(col.keys()) and len(col[\'sort\']):\r\n                    for a in col[\'abbreviation\'].split(\',\'):\r\n                        if a.lower() == c.lower():\r\n                            c = col[\'sort\']\r\n                else:\r\n                    for a in col[\'abbreviation\'].split(\',\'):\r\n                        if a.lower() == c.lower():\r\n                            c = col[\'name\']\r\n            if hasPre:\r\n                c = preData + \'.\' + c\r\n                # c = c + \'.\' + preData\r\n\r\n            result += c + \',\'\r\n        result = result[:-1]\r\n    # print_( result )\r\n    return result\r\n\r\ndef plusCloseClean(data):\r\n    return data.replace( \'%\',\'\' )\r\n\r\ndefaultScriptTriggers_run = False\r\n\r\ndef defaultScriptTriggers():\r\n    global defaultScriptTriggers_run\r\n    defaultScriptTriggers_run = True\r\n    __.appReg_bk = __.appReg\r\n\r\ndef print_epoch_trigger(item):\r\n    print_( \'epoch:\', __.startTime  )\r\n\r\ndefault_switch_trigger_index={}\r\ndef default_switch_trigger(name,script):\r\n    global default_switch_trigger_index\r\n    default_switch_trigger_index[name]=script\r\n\r\ndef defaultScriptTriggers_do():\r\n    global defaultScriptTriggers_run\r\n    global default_switch_trigger_index\r\n    for name in default_switch_trigger_index:\r\n        switches.trigger(name,default_switch_trigger_index[name])\r\n\r\n    if defaultScriptTriggers_run:\r\n        if len(appInfo[__.appReg_bk][\'columns\']) > 0:\r\n\r\n            switches.trigger(\'Column\',formatColumns)\r\n            switches.trigger(\'Sort\',formatColumnsSort)\r\n            switches.trigger(\'GroupBy\',formatColumns)\r\n        switches.trigger(\'PlusClose\',plusCloseClean)\r\n        switches.trigger(\'Ago\',timeAgo)\r\n        switches.trigger(\'PrintEpoch\',print_epoch_trigger)\r\n        # switches.trigger(\'Aggregate\',aggregate_trigger)\r\n        switches.postScripts.append( aggregate_trigger )\r\n\r\n\r\nprintAutoAbbreviations_scheduled = False\r\ndef autoAbbreviations():\r\n    global printAutoAbbreviations_scheduled\r\n    # return False\r\n    global myFileLocation_File\r\n    if not type( myFileLocation_File ) == bool:\r\n        if not len( appInfo[__.appReg][\'columns\'] ) and myFileLocation_File.lower().endswith(\'.json\'):\r\n            \r\n            printAutoAbbreviations_scheduled = True\r\n            data = []\r\n            groups = {}\r\n            myFileLocation_File_Data = getTable2( myFileLocation_File )\r\n            if type( myFileLocation_File_Data ) == dict:\r\n                myFileLocation_File_Data = [myFileLocation_File_Data]\r\n            for i,key in enumerate( myFileLocation_File_Data[0].keys()):\r\n                # print_( key )\r\n                record = {}\r\n                record[\'id\'] = i\r\n                record[\'key\'] = key\r\n                record[\'first\'] = key[:1].lower()\r\n                record[\'second\'] = key[:2].lower()\r\n                record[\'third\'] = key[:3].lower()\r\n                wf = \'\'\r\n                for w in key.replace( \'_\', \' \' ).split( \' \' ):\r\n                    wf += w[:1].lower()\r\n                record[\'firstofword\'] = wf\r\n\r\n\r\n                for k in record.keys():\r\n                    try:\r\n                        if not type(groups[ k ]) == dict:\r\n                            groups[ k ] = {}\r\n                    except Exception as e:\r\n                        groups[ k ] = {}\r\n\r\n                    try:\r\n                        if not type(groups[ k ][ record[k] ]) == dict:\r\n                            groups[ k ][ record[k] ] = {}\r\n                    except Exception as e:\r\n                        groups[ k ][ record[k] ] = {}\r\n                        groups[ k ][ record[k] ][\'ids\'] = []\r\n\r\n\r\n                for k in record.keys():\r\n                    groups[ k ][ record[k] ][\'ids\'].append( i )\r\n                \r\n                data.append( record )\r\n\r\n\r\n            approvedAbbreviations= []\r\n            flag = False\r\n            flagged= []\r\n\r\n            for k in groups[\'first\'].keys():\r\n                approvedAbbreviations.append({ \'key\': data[groups[\'first\'][k][\'ids\'][0]][\'key\'], \'abbreviations\': k })\r\n                if not len(groups[\'first\'][k][\'ids\']) == 1:\r\n                    flag = True\r\n                    for i,idx in enumerate(groups[\'first\'][k][\'ids\']):\r\n                        if not i == 0:\r\n                            flagged.append({ \'first\': k, \'id\': idx, \'assigned\': False })\r\n\r\n            \r\n            if flag:\r\n                flagsResolved = 0\r\n                for k in groups[\'firstofword\'].keys():\r\n                    if len(k) > 1:\r\n                        for x in groups[\'firstofword\'][k][\'ids\']:\r\n                            for i,f in enumerate(flagged):\r\n                                if not flagged[i][\'assigned\']:\r\n                                    if flagged[i][\'id\'] == x:\r\n                                        flagsResolved += 1\r\n                                        flagged[i][\'assigned\'] = True\r\n                                        approvedAbbreviations.append({ \'key\': data[x][\'key\'], \'abbreviations\': k })\r\n\r\n                if not flagsResolved == len(flagged):\r\n                    for k in groups[\'second\'].keys():\r\n                        for x in groups[\'second\'][k][\'ids\']:\r\n                            for i,f in enumerate(flagged):\r\n                                if not flagged[i][\'assigned\']:\r\n                                    if flagged[i][\'id\'] == x:\r\n                                        flagsResolved += 1\r\n                                        flagged[i][\'assigned\'] = True\r\n                                        approvedAbbreviations.append({ \'key\': data[x][\'key\'], \'abbreviations\': k })\r\n\r\n                if not flagsResolved == len(flagged):\r\n                    for k in groups[\'third\'].keys():\r\n                        for x in groups[\'third\'][k][\'ids\']:\r\n                            for i,f in enumerate(flagged):\r\n                                if not flagged[i][\'assigned\']:\r\n                                    if flagged[i][\'id\'] == x:\r\n                                        flagsResolved += 1\r\n                                        flagged[i][\'assigned\'] = True\r\n                                        approvedAbbreviations.append({ \'key\': data[x][\'key\'], \'abbreviations\': k })         \r\n\r\n                if not flagsResolved == len(flagged):\r\n                    for i,f in enumerate(flagged):\r\n                        if not flagged[i][\'assigned\']:\r\n                            print_( \'Error: abbreviation\', data[flagged[i][\'id\']][\'key\'] )\r\n\r\n\r\n            # printVar( groups )\r\n            # printVar( data )\r\n\r\n            for aa in approvedAbbreviations:\r\n                appInfo[__.appReg][\'columns\'].append({\'name\': aa[\'key\'], \'abbreviation\': aa[\'abbreviations\']})\r\n            if switches.isActive(\'PrintAutoAbbreviations\'):\r\n                print_()\r\n                print_(\'Columns and abbreviations:\')\r\n                result = \'\'\r\n                for col in appInfo[__.appReg][\'columns\']:\r\n                    result += col[\'name\'] + \'(\' + col[\'abbreviation\'] + \'), \'\r\n                result = result[:-2]\r\n                print_(\'\\t\' + result + \'\\n\')\r\n                print_()\r\n\r\n            defaultScriptTriggers()\r\n            # sys.exit()\r\n            # print_(first)\r\n\r\n\r\ndef printAutoAbbreviations():\r\n    global printAutoAbbreviations_scheduled\r\n    if printAutoAbbreviations_scheduled and switches.isActive(\'PrintAutoAbbreviations\'):\r\n        print_()\r\n        print_(\'Columns and abbreviations:\')\r\n        result = \'\'\r\n        for col in appInfo[__.appReg][\'columns\']:\r\n            result += col[\'name\'] + \'(\' + col[\'abbreviation\'] + \'), \'\r\n        result = result[:-2]\r\n        print_(\'\\t\' + result + \'\\n\')\r\n        print_()\r\n\r\n\r\n\r\n#########################################################################################################################################################\r\n\r\n\r\nclass ThisThread( threading.Thread ):\r\n    \r\n    \r\n    def __init__( self, name, fn=None, a=None, t=None, k=None, timeout=120, start=True, qID=None ):\r\n        threading.Thread.__init__(self)\r\n        self.qID = qID\r\n        self.name = name\r\n        self.fn = fn\r\n        self.arg = a\r\n        self.kwargs = k\r\n\r\n        if not t is None:\r\n            timeout = t\r\n\r\n        self.killOn = timeout\r\n\r\n\r\n        self.epoch = 0\r\n        self.endTime = None\r\n        self.duration = None\r\n\r\n        self.wasKilled = False\r\n\r\n        self.log = {}\r\n        self._stop_event = threading.Event()\r\n        self.target = self.run\r\n        if start:\r\n            # print_( \'pre start\' )\r\n            # self.run()\r\n            self.start()\r\n            # print_( \'post start\' )\r\n\r\n\r\n\r\n    def run( self ):\r\n        # for x in dir(self):\r\n        #   print_(x)\r\n        # print_(\'run\')\r\n        # print_(\'xx\',self.isAlive())\r\n        self.epoch = time.time()\r\n        completed = False\r\n        error = False\r\n        try:\r\n            if not self.arg is None:\r\n                self.fn(self.arg)\r\n            else:\r\n                if self.kwargs is None:\r\n                    self.fn()\r\n                elif type(self.kwargs) == dict:\r\n                    self.fn(**self.kwargs)\r\n                elif type(self.kwargs) == list or type(self.kwargs) == tuple:\r\n                    self.fn(*self.kwargs)\r\n                elif type(self.kwargs) == str:\r\n                    self.fn(self.kwargs)\r\n            completed = True\r\n        except Exception as e:\r\n            error = True\r\n        finally:\r\n            self.endTime = time.time()\r\n            self.duration = self.endTime - self.epoch\r\n            # print_()\r\n            # _.colorThis(  [ self.tID, \'ended\' ], \'red\'  )\r\n            ended = \'\'\r\n            if self.wasKilled:\r\n                ended += \' killed \'\r\n            if error:\r\n                ended += \' error \'\r\n            if completed:\r\n                ended += \' completed \'\r\n\r\n            self.log = {\r\n                                \'id\': self.getID(),\r\n                                \'qID\': self.qID,\r\n                                \'name\': self.name,\r\n                                \'start\': self.epoch,\r\n                                \'end\': self.endTime,\r\n                                \'duration\': self.duration,\r\n                                \'ended\': ended,\r\n            }\r\n\r\n    def getID( self ):\r\n\r\n        for id, thread in threading._active.items():\r\n            if thread is self:\r\n                return id\r\n \r\n    def kill( self ):\r\n        # print_( \'kill started\' )\r\n        self.wasKilled = True\r\n        self._stop_event.set()\r\n        # thread_id = self.getID()\r\n        # """ {7DB6A001-0637-4F13-B328-2B17A481CF35} """\r\n        # import ctypes\r\n        # # print_( \'kill id\', thread_id )\r\n        # res = ctypes.pythonapi.PyThreadState_SetAsyncExc(thread_id,\r\n        #     ctypes.py_object(SystemExit))\r\n        # if res > 1:\r\n        #   ctypes.pythonapi.PyThreadState_SetAsyncExc(thread_id, 0)\r\n        # print_( \'kill complete\' )\r\n        # raise Exception(\'My error!\')\r\n        \r\n\r\n\r\n\r\n#########################################################################################################################################################\r\n\r\nclass Threads:\r\n    # Threads.openCnt\r\n    # Threads.closedCnt\r\n    openCnt = 0\r\n    closedCnt = 0\r\n    def __init__( self, name=None, func=None, arg=None, kwargs=None, focus=None, qID=None, addID=None, pID=None, timeout=None ):\r\n        global appInfo\r\n        if name is None:\r\n            name = __.uuid()\r\n        # Threads.openCnt += 1\r\n        self.active = False\r\n        \r\n        self.created = time.time()\r\n        if focus is None:\r\n            focus = __.appReg\r\n        self.app = appInfo[focus][\'file\']\r\n        self.name = name\r\n        self.func = func\r\n        self.focus = focus\r\n        self.arg = arg\r\n        self.kwargs = kwargs\r\n        self.qID = qID\r\n        self.addID = addID\r\n        self.created = time.time()\r\n        self.status = True\r\n        self.instance = \'\'\r\n        self.bottom = False\r\n        self.timeout = timeout\r\n        self.hasTimedOut = 0\r\n        self.pID = pID\r\n        self.sstatus = 2\r\n\r\n\r\n\r\n        self.data = False\r\n        # self.trigger = False\r\n        # self.triggerArg = False\r\n        self.executed = False\r\n        self.triggerError = False\r\n        \r\n        self.thisThread = None\r\n\r\n        __.threadActivity[self.qID] = {}\r\n        __.threadActivity[self.qID][\'error\'] = False\r\n        __.threadActivity[self.qID][\'activity\'] = time.time()\r\n        __.threadActivity[self.qID][\'log\'] = False\r\n\r\n        # try:\r\n        #   self.instance = appInfo[focus][\'instance\']\r\n        # except Exception as e:\r\n            \r\n\r\n\r\n        self.log = { \r\n                        \'id\':       self.qID,\r\n                        \'parent\':   self.pID,\r\n                        \'app\':      self.app,\r\n                        \'func\':     \'unknown\',\r\n                        \'arg\':      \'unknown\',\r\n                        \'instance\': self.instance,\r\n                        \'focus\':    self.focus,\r\n                        \'start\':    0,\r\n                        \'end\':      0,\r\n                        \'runtime\':  0,\r\n                        \'mem\':      0,\r\n                        \'lines\':      0,\r\n                        \'wait\':     0,\r\n                        \'qcount\':   0\r\n        }\r\n        try:\r\n            self.log[\'func\'] = self.func.__name__\r\n        except Exception as e:\r\n            pass\r\n\r\n        self.log[\'arg\'] = _profile.records.audit(  self.name+\' - \'+str(self.qID)  , self.arg )\r\n        # if not type(self.arg) == str and not type(self.arg) == list and not type(self.arg) == dict and not type(self.arg) == int and not type(self.arg) == float and not type(self.arg) == tuple:\r\n        #     try:\r\n        #         self.log[\'arg\'] = str(self.arg)\r\n        #     except Exception as e:\r\n        #         pass\r\n        # else:\r\n\r\n\r\n\r\n        try:\r\n            self.argID = self.arg\r\n            self.argID.append( self.qID )\r\n        except Exception as e:\r\n            self.argID = False\r\n        self.open()\r\n    def getLog( self ):\r\n        self.log[\'error\'] = __.threadActivity[self.qID][\'error\']\r\n        self.log[\'activity\'] = __.threadActivity[self.qID][\'activity\']\r\n        self.log[\'errorlog\'] = __.threadActivity[self.qID][\'log\']\r\n        if self.thisThread is None:\r\n            self.log[\'thisThread\'] = None\r\n        else:\r\n            self.log[\'thisThread\'] = self.thisThread.log\r\n        # try:\r\n        # except Exception as e:\r\n        #     pass\r\n        return self.log\r\n\r\n        \r\n\r\n    def open( self ):\r\n        # print_(\'open 0\')\r\n        self.sstatus = 1\r\n        __.queueLastActivity = time.time()\r\n        self.active = True\r\n        self.log[\'start\'] = time.time()\r\n        self.log[\'qcount\'] = __.queueCount\r\n\r\n        if self.kwargs:\r\n            if self.addID:\r\n                data = [{ \'func\': self.func, \'args\': self.arg[:-1] }]\r\n                data[0][\'args\'][0][\'qID\']=self.qID\r\n                self.thisThread = ThisThread(\r\n                                                qID = self.qID,\r\n                                                name = self.name+\' - \'+str(self.qID),\r\n                                                fn = self.func,\r\n                                                k = data[0][\'args\'][0],\r\n                                                t = self.timeout,\r\n                                                start = True,\r\n                )\r\n                # threadTimer( .0001, threadKwargs, data, qID=self.qID )\r\n            else:\r\n                data = [[{ \'func\': self.func, \'args\': self.arg }]]\r\n                self.thisThread = ThisThread(\r\n                                                qID = self.qID,\r\n                                                name = self.name+\' - \'+str(self.qID),\r\n                                                fn = self.func,\r\n                                                k = self.arg,\r\n                                                t = self.timeout,\r\n                                                start = True,\r\n                )\r\n                # threadTimer( .0001, threadKwargs, data, qID=self.qID )\r\n        else:\r\n            if self.addID:\r\n                self.thisThread = ThisThread(\r\n                                                qID = self.qID,\r\n                                                name = self.name+\' - \'+str(self.qID),\r\n                                                fn = self.func,\r\n                                                a = self.qID,\r\n                                                t = self.timeout,\r\n                                                start = True,\r\n                )\r\n                # threadTimer( .0001, self.func, self.argID, qID=self.qID )\r\n            else:\r\n                self.thisThread = ThisThread(\r\n                                                qID = self.qID,\r\n                                                name = self.name+\' - \'+str(self.qID),\r\n                                                fn = self.func,\r\n                                                a = self.arg,\r\n                                                t = self.timeout,\r\n                                                start = True,\r\n                )\r\n                # threadTimer( .0001, self.func, self.arg, qID=self.qID )\r\n        # print_(\'open 1\')\r\n\r\n    def close( self, mem=0, data=False, trigger=False, triggerArg=False, kwargs=False, lines=0 ):\r\n        self.sstatus = 0\r\n        __.queueLastActivity = time.time()\r\n        if not type(trigger) == bool:\r\n            try:\r\n                triggerName = trigger.__name__\r\n            except Exception as e:\r\n                triggerName = \'\'\r\n\r\n            try:\r\n\r\n\r\n\r\n                if type(data) == bool and type(triggerArg) == bool:\r\n                    threadTimer( .0001, trigger )\r\n                elif not type(data) == bool and type(triggerArg) == bool:\r\n                    threadTimer( .0001, trigger, data )\r\n                elif type(data) == bool and not type(triggerArg) == bool:\r\n                    threadTimer( .0001, trigger, triggerArg )\r\n                elif not type(data) == bool and not type(triggerArg) == bool and kwargs:\r\n                    args = [{ \'func\': trigger, \'args\': triggerArg }]\r\n                    args[0][\'args\'][0][\'data\'] = data\r\n                    threadTimer( .0001, threadKwargs, args )\r\n                elif not type(data) == bool and not type(triggerArg) == bool and not kwargs:\r\n                    try:\r\n                        triggerArg.append(data)\r\n                        threadTimer( .0001, threadKwargs, triggerArg )\r\n                    except Exception as e:\r\n                        try:\r\n                            triggerArg[0].append(data)\r\n                            threadTimer( .0001, threadKwargs, triggerArg )\r\n                        except Exception as e:\r\n                            printBold(\'close trigger error \'+str(self.focus)+\' \'+ str(self.name) +\' \'+ str(self.func)+\' \'+ str(triggerName), \'red\' )\r\n                            self.triggerError = True\r\n\r\n\r\n                self.executed = True\r\n                if self.triggerError:\r\n                    self.executed = False\r\n            except Exception as e:\r\n                printBold(\'close trigger error \'+str(self.focus)+\' \'+ str(self.name) +\' \'+ str(self.func)+\' \'+ str(triggerName), \'red\')\r\n                self.triggerError = True\r\n\r\n        \r\n\r\n        # Threads.closedCnt += 1\r\n        # print_(\'Closed:\',self.qID,\'\\tTotal Closed:\',Threads.newCounter,\'\\tScheduler:\',__.queueCountScheduleAudit,__.queueCountSchedule,\'\\tTimers:\',__.queueCountTimer)\r\n        self.status = False\r\n        self.log[\'end\'] = time.time()\r\n        self.log[\'runtime\'] = self.log[\'end\'] - self.log[\'start\']\r\n        self.log[\'mem\'] = mem\r\n        self.log[\'lines\'] = lines\r\n        if not type(data) == bool:\r\n            self.data = data\r\n        return self.qID\r\n\r\n    def openCnt( self ):\r\n        return Threads.openCnt\r\n\r\n    def closedCnt( self ):\r\n        return Threads.closedCnt\r\n#########################################################################################################################################################\r\nclass Queue:\r\n\r\n    def __init__( self ):\r\n\r\n        self.created = time.time()\r\n        self.loadedBy = 0\r\n        self.loadTime = 0\r\n        self.completionTime = 0\r\n        self.lastActivity = 0\r\n        self.lastActivityEach = {}\r\n        \r\n        # self.qID_index = {}\r\n\r\n        self.records = {}\r\n        self.nextID = 0\r\n        self.opened = 0\r\n        self.closed = 0\r\n        self.notstarted = 0\r\n        self.maxInQueue = 0\r\n        self.maxThreads = 100\r\n        self.maxThreadsSafe = 100\r\n        self.minThreads = 50\r\n        self.table = {\'focus\': [], \'name\': []}\r\n        self.schedulerInitialized = False\r\n\r\n\r\n        self.auditPrint = True\r\n        self.maxThreadsAuto = True\r\n        self.auditInitialized = False\r\n        self.auditPercentChangeMax = 30\r\n        self.auditPercentChangeMin = 10\r\n        self.auditPercentReduceBy = 5\r\n        self.auditPercentReduceByDrastic = 15\r\n        self.auditPercentDrasticThreshold = 3\r\n        self.auditWatchMax = 5\r\n        self.auditPercentSample = 10\r\n        self.auditMaxFailuresBeforeAction = 3\r\n        self.auditLogInternal = []\r\n        self.auditLogExternal = []\r\n        self.auditAutoAdjust = False\r\n\r\n\r\n        ##\r\n        self.scheduleLoop = .01\r\n        self.auditLoop = .1\r\n        self.autoLoadedAfter = 5\r\n        self.statusTotal = 0\r\n        self.prefix = False\r\n        ##\r\n\r\n\r\n        self.autoLoaded = True\r\n\r\n        self.report = False\r\n        self.reportPrinted = False\r\n\r\n\r\n        self.timeout = False\r\n        self.timeoutAsk = False\r\n\r\n\r\n        self.saveLog = True\r\n        self.isLoaded = False\r\n\r\n        self.appStructure = __.structure()\r\n\r\n        __.totalTask = 0\r\n        __.queueCount = 0\r\n        __.queueCountSchedule = 0\r\n        __.queueCountAudit = 0\r\n        __.queueCountScheduleAudit = 0\r\n        __.queueCountAuditAudit = 0\r\n        __.queueLastActivity = time.time()\r\n        __.queueCountTimer = 0\r\n\r\n        __.threadActivity = {}\r\n\r\n        self.projectDataMaxLen = 2000\r\n        self.projectDataDetected = False\r\n        __.datadumps = 0\r\n        __.projectData = {}\r\n        __.pdID = {}\r\n        __.saveInitiated = False\r\n\r\n        self.listeningFor = False\r\n\r\n\r\n\r\n    def killAll( self ):\r\n\r\n\r\n\r\n        for focus in self.records.keys():\r\n            for i, threads in enumerate( self.records[focus][\'threads\'] ):\r\n                if not threads.thisThread is None and threads.sstatus == 1:\r\n\r\n                    name = self.records[focus][\'threads\'][i].name\r\n                    qID = self.records[focus][\'threads\'][i].qID\r\n\r\n                    self.records[focus][\'threads\'][i].hasTimedOut = 1\r\n                    self.records[focus][\'threads\'][i].thisThread.kill()\r\n                    self.spent( qID, 0 )\r\n\r\n        self.isLoaded = True\r\n        for focus in self.records.keys():\r\n            for name in self.records[focus][\'names\'].keys():\r\n                self.records[focus][\'names\'][name][\'loaded\'] = True\r\n                self.spendFocus( name, focus, 99 )\r\n\r\n\r\n\r\n# func=False, arg=False, kwargs=False, focus=False , addID=True , \r\n# loaded=False,\r\n# , pID=False\r\n\r\n\r\n    \r\n    def register( self, name, trigger=None, triggerArg=False, triggerKwargs=False,  timeout=False, database=False, focus=None,      completed=None, onComplete=None,      oc=None, c=None, a=None, k=None, t=None, d=None  ):\r\n        if not completed is None:\r\n            trigger = completed\r\n        if not onComplete is None:\r\n            trigger = onComplete\r\n        if not oc is None:\r\n            trigger = oc\r\n        if not c is None:\r\n            trigger = c\r\n\r\n        if not a is None:\r\n            triggerArg = a\r\n        if not k is None:\r\n            triggerKwargs = k\r\n        if not t is None:\r\n            timeout = t\r\n        if not d is None:\r\n            database = d\r\n\r\n\r\n\r\n        loaded = False\r\n\r\n\r\n\r\n        # print_(\'arg:\',arg)\r\n        # print_( name, type( trigger ) )\r\n        # sys.exit()\r\n        nextID = False\r\n        global appInfo\r\n        self.lastActivity = time.time()\r\n\r\n        if focus is None:\r\n            focus = __.appReg\r\n        pass\r\n\r\n        try:\r\n            self.lastActivityEach[focus][name] = time.time()\r\n        except Exception as e:\r\n            self.lastActivityEach[focus] = {}\r\n            self.lastActivityEach[focus][name] = time.time()\r\n\r\n\r\n\r\n        try:\r\n            __.projectData[focus]\r\n        except Exception as e:\r\n            __.projectData[focus] = {}\r\n\r\n        __.projectData[focus][name] = {}\r\n        # if not \'folder\' in name:\r\n        #   print_( \'zero\' )\r\n        #   sys.exit()\r\n\r\n        __.projectData[focus][name][0] = {}\r\n        __.projectData[focus][name][0][\'saveInitiated\'] = False\r\n        # print_( \'check3:\', focus, name, 0 )\r\n        __.projectData[focus][name][0][\'data\'] = []\r\n\r\n        __.projectData[focus][name][1] = {}\r\n        __.projectData[focus][name][1][\'saveInitiated\'] = False\r\n        # print_( \'check4:\', focus, name, 1 )\r\n        __.projectData[focus][name][1][\'data\'] = []\r\n\r\n        try:\r\n            __.pdID[focus]\r\n        except Exception as e:\r\n            __.pdID = {}\r\n            __.pdID[focus] = {}\r\n\r\n\r\n        __.pdID[focus][name] = 0\r\n\r\n        if self.maxThreadsAuto:\r\n            maxThreads = self.maxThreadsSafe\r\n        else:\r\n            maxThreads = self.maxThreads\r\n        if trigger is None:\r\n            trigger = False\r\n\r\n        try:\r\n            self.records[focus][\'names\'][name] = {\r\n                                                    \'timeout\': timeout,\r\n                                                    \'loaded\': loaded,\r\n                                                    \'trigger\': trigger,\r\n                                                    \'maxThreads\': maxThreads,\r\n                                                    \'failure\': 0,\r\n                                                    \'changes\': 0,\r\n                                                    \'watch\': 0,\r\n                                                    \'closed\': 0,\r\n                                                    \'database\': database,\r\n                                                    \'executed\': False,\r\n                                                    \'projectSaveInitiated\': False,\r\n                                                }\r\n        except Exception as e:\r\n            self.records[focus] = {\r\n                                        \'threads\': [],\r\n                                        \'open\': 0,\r\n                                        \'app\': appInfo[focus][\'file\'],\r\n                                        \'names\': {\r\n                                                name: {\r\n                                                    \'timeout\': timeout,\r\n                                                    \'loaded\': loaded,\r\n                                                    \'trigger\': trigger,\r\n                                                    \'maxThreads\': maxThreads,\r\n                                                    \'failure\': 0,\r\n                                                    \'changes\': 0,\r\n                                                    \'watch\': 0,\r\n                                                    \'closed\': 0,\r\n                                                    \'database\': database,\r\n                                                    \'executed\': False,\r\n                                                    \'projectSaveInitiated\': False,\r\n                                                }\r\n                                        }\r\n            }\r\n\r\n\r\n\r\n        pass\r\n        self.isLoaded = False\r\n        self.records[focus][\'names\'][name][\'loaded\'] = loaded\r\n        if not self.auditAutoAdjust:\r\n            # print_(focus,name)\r\n            if self.maxThreadsAuto:\r\n                self.records[focus][\'names\'][name][\'maxThreads\'] = self.maxThreadsSafe\r\n            else:\r\n                self.records[focus][\'names\'][name][\'maxThreads\'] = self.maxThreads\r\n\r\n\r\n        if not loaded:\r\n            self.records[focus][\'names\'][name][\'loaded\'] = False\r\n\r\n        if not trigger is None:\r\n            self.records[focus][\'names\'][name][\'trigger\'] = trigger\r\n            if not triggerArg is None:\r\n                self.records[focus][\'names\'][name][\'triggerArg\'] = triggerArg\r\n            else:\r\n                self.records[focus][\'names\'][name][\'triggerArg\'] = False\r\n\r\n\r\n\r\n        if not self.auditInitialized and self.maxThreadsAuto:\r\n            self.auditInitialized = True\r\n            threadTimer( self.auditLoop, threadAudit )\r\n            # Timer( .3, threadAudit ).start()\r\n\r\n        return nextID\r\n\r\n\r\n\r\n    def add( self, name, func=False, arg=False, kwargs=False, focus=False , addID=True , trigger=False, triggerArg=False, triggerKwargs=False, loaded=False, timeout=False, database=False, pID=False ):\r\n        # print_(\'arg:\',arg)\r\n        # print_( name, type( trigger ) )\r\n        # sys.exit()\r\n        nextID = False\r\n        global appInfo\r\n        self.lastActivity = time.time()\r\n\r\n        if type(focus) == bool:\r\n            focus = __.appReg\r\n\r\n        try:\r\n            self.lastActivityEach[focus][name] = time.time()\r\n        except Exception as e:\r\n            self.lastActivityEach[focus] = {}\r\n            self.lastActivityEach[focus][name] = time.time()\r\n\r\n        try:\r\n            self.records[focus][\'threads\']\r\n            self.records[focus][\'names\'][name][\'loaded\'] = loaded\r\n        except Exception as e:\r\n\r\n            try:\r\n                __.projectData[focus]\r\n            except Exception as e:\r\n                __.projectData[focus] = {}\r\n\r\n            __.projectData[focus][name] = {}\r\n            # if not \'folder\' in name:\r\n            #   print_( \'zero\' )\r\n            #   sys.exit()\r\n\r\n            __.projectData[focus][name][0] = {}\r\n            __.projectData[focus][name][0][\'saveInitiated\'] = False\r\n            # print_( \'check3:\', focus, name, 0 )\r\n            __.projectData[focus][name][0][\'data\'] = []\r\n\r\n            __.projectData[focus][name][1] = {}\r\n            __.projectData[focus][name][1][\'saveInitiated\'] = False\r\n            # print_( \'check4:\', focus, name, 1 )\r\n            __.projectData[focus][name][1][\'data\'] = []\r\n\r\n            try:\r\n                __.pdID[focus]\r\n            except Exception as e:\r\n                __.pdID = {}\r\n                __.pdID[focus] = {}\r\n\r\n\r\n            __.pdID[focus][name] = 0\r\n\r\n            if self.maxThreadsAuto:\r\n                maxThreads = self.maxThreadsSafe\r\n            else:\r\n                maxThreads = self.maxThreads\r\n            try:\r\n                self.records[focus][\'names\'][name] = {\r\n                                                        \'timeout\': timeout,\r\n                                                        \'loaded\': loaded,\r\n                                                        \'trigger\': trigger,\r\n                                                        \'maxThreads\': maxThreads,\r\n                                                        \'failure\': 0,\r\n                                                        \'changes\': 0,\r\n                                                        \'watch\': 0,\r\n                                                        \'closed\': 0,\r\n                                                        \'database\': database,\r\n                                                        \'executed\': False,\r\n                                                        \'projectSaveInitiated\': False,\r\n                                                    }\r\n            except Exception as e:\r\n                self.records[focus] = {\r\n                                            \'threads\': [],\r\n                                            \'open\': 0,\r\n                                            \'app\': appInfo[focus][\'file\'],\r\n                                            \'names\': {\r\n                                                    name: {\r\n                                                        \'timeout\': timeout,\r\n                                                        \'loaded\': loaded,\r\n                                                        \'trigger\': trigger,\r\n                                                        \'maxThreads\': maxThreads,\r\n                                                        \'failure\': 0,\r\n                                                        \'changes\': 0,\r\n                                                        \'watch\': 0,\r\n                                                        \'closed\': 0,\r\n                                                        \'database\': database,\r\n                                                        \'executed\': False,\r\n                                                        \'projectSaveInitiated\': False,\r\n                                                    }\r\n                                            }\r\n                }\r\n\r\n\r\n        if type(timeout) == bool:\r\n            timeout = self.records[focus][\'names\'][name][\'timeout\']\r\n\r\n\r\n        self.isLoaded = False\r\n        self.records[focus][\'names\'][name][\'loaded\'] = loaded\r\n        if not self.auditAutoAdjust:\r\n            # print_(focus,name)\r\n            if self.maxThreadsAuto:\r\n                self.records[focus][\'names\'][name][\'maxThreads\'] = self.maxThreadsSafe\r\n            else:\r\n                self.records[focus][\'names\'][name][\'maxThreads\'] = self.maxThreads\r\n\r\n\r\n        if not loaded:\r\n            self.records[focus][\'names\'][name][\'loaded\'] = False\r\n\r\n        if not type(trigger) == bool:\r\n            self.records[focus][\'names\'][name][\'trigger\'] = trigger\r\n            if not type(triggerArg) == bool:\r\n                self.records[focus][\'names\'][name][\'triggerArg\'] = triggerArg\r\n            else:\r\n                self.records[focus][\'names\'][name][\'triggerArg\'] = False\r\n\r\n        if not type(func) == bool:\r\n            self.table[\'focus\'].append(focus)\r\n            # self.table[\'name\'].append(name)\r\n            nextID = self.nextID\r\n            # self.qID_index[ (qID) ] = { \'focus\': focus, \'name\': name }\r\n            self.records[focus][\'threads\'].append( Threads( name, func, arg, kwargs, focus, nextID, addID, pID=pID, timeout=timeout ) )\r\n\r\n            shouldOpen = False\r\n            if not self.records[focus][\'names\'][name][\'maxThreads\']:\r\n                shouldOpen = True\r\n            elif self.opened > self.records[focus][\'names\'][name][\'maxThreads\']:\r\n                shouldOpen = True\r\n            if not shouldOpen:\r\n                self.notstarted += 1\r\n            else:\r\n                pass\r\n                # self.records[focus][\'threads\'][nextID].open()\r\n                # self.cnt( focus, True )\r\n            self.nextID += 1\r\n            if not self.schedulerInitialized and True:\r\n                self.schedulerInitialized = True\r\n                threadTimer( self.scheduleLoop, threadSchedule )\r\n                # Timer( self.scheduleLoop, threadSchedule ).start()\r\n\r\n        if not self.auditInitialized and self.maxThreadsAuto:\r\n            self.auditInitialized = True\r\n            threadTimer( self.auditLoop, threadAudit )\r\n            # Timer( .3, threadAudit ).start()\r\n\r\n        return nextID\r\n\r\n    def loadedGroup( self, name=False , focus=False ):\r\n\r\n        if self.autoLoaded:\r\n\r\n            if type(focus) == bool:\r\n                focus = __.appReg\r\n\r\n\r\n            hasChildren = False\r\n            for rec in self.records[focus][\'threads\']:\r\n                if rec.focus == focus and rec.name == name:\r\n                    # if name == \'processMovies\':\r\n                    #     colorThis( [ \'processMovies\' ], \'red\' )\r\n                    hasChildren = True\r\n\r\n\r\n            if hasChildren:\r\n                self.records[focus][\'names\'][name][\'loaded\'] = True\r\n\r\n\r\n\r\n    def loaded( self, name=False , focus=False ):\r\n\r\n\r\n        if self.autoLoaded:\r\n\r\n            if type(focus) == bool:\r\n                focus = __.appReg\r\n\r\n\r\n            hasChildren = False\r\n            for rec in self.records[focus][\'threads\']:\r\n                if rec.focus == focus and rec.name == name:\r\n                    # if name == \'processMovies\':\r\n                    #     colorThis( [ \'processMovies\' ], \'red\' )\r\n                    hasChildren = True\r\n\r\n\r\n            if hasChildren:\r\n                # self.isLoaded = True\r\n                if not type(name) == bool:\r\n                    self.records[focus][\'names\'][name][\'loaded\'] = True\r\n                    # name = str(list(self.records[focus][\'names\'].keys())[0])\r\n                else:\r\n                    for f in self.records.keys():\r\n                        for n in self.records[f][\'names\'].keys():\r\n                            if not self.records[f][\'names\'][n][\'loaded\']:\r\n                                self.records[f][\'names\'][n][\'loaded\'] = True\r\n\r\n\r\n        pass\r\n        allComplete = True\r\n        for f in self.records.keys():\r\n            for n in self.records[f][\'names\'].keys():\r\n                if not self.records[f][\'names\'][n][\'loaded\']:\r\n                    allComplete = False\r\n        if allComplete:\r\n            self.isLoaded = True\r\n\r\n\r\n    def spent( self, qID, mem=0, data=False, trigger=False, triggerArg=False, kwargs=False, lines=0 ):\r\n        qID = int(qID)\r\n        focus = False\r\n        result = False\r\n        for i,t in enumerate(self.records[self.table[\'focus\'][qID]][\'threads\']):\r\n            if self.records[ self.table[\'focus\'][qID] ][\'threads\'][i].qID == qID:\r\n                result = self.records[self.table[\'focus\'][qID]][\'threads\'][i].close( mem, data, trigger, triggerArg, kwargs, lines )\r\n                focus = self.table[\'focus\'][qID]\r\n                name = self.records[self.table[\'focus\'][qID]][\'threads\'][i].name\r\n        if not type(focus) == bool:\r\n            self.cnt( focus, False )\r\n\r\n            # if self.isEverythingLoadedEach(  focus,  name  ) and self.notstarted == 0:\r\n            if self.isEverythingLoadedEach(  focus,  name  ) and self.isEverythingClosedEach( focus, name ):\r\n                self.spendFocus( name, focus, 1 )\r\n                self.printReport()\r\n        return result\r\n\r\n\r\n\r\n    def printReport( self ):\r\n        if not self.reportPrinted:\r\n            self.completionTime = time.time() - self.created\r\n            if self.report:\r\n                self.reportPrinted = True\r\n                print_(\'__________________________________________\')\r\n                print_()\r\n                print_(\'opened:\',self.opened)\r\n                # print_(\'records open:\',self.records[focus][\'open\'])\r\n                print_(\'isEverythingLoaded:\',time.time()-self.loadedBy,time.time()-self.lastActivity)\r\n                print_(\'spendFocus\')\r\n                print_(\'queueCountSchedule:\',__.queueCountSchedule)\r\n                print_(\'queueCountAudit:\',__.queueCountAudit)\r\n                print_(\'audit:\',__.queueCountAudit)\r\n                print_()\r\n                print_(\'load time:\\t\', int(self.loadTime))\r\n                print_(\'time after load:\\t\', int(time.time()-self.loadedBy))\r\n                print_()\r\n                print_(\'app time:\\t\', int(self.completionTime))\r\n                print_()\r\n                print_(\'maxInQueue:\',self.maxInQueue)\r\n                # str((self.completionTime/1000)%60)\r\n                print_()\r\n                print_(\'timeouts:\',self.timeoutCount())\r\n                # print_("Average of the list =", round(average, 2)) \r\n                print_()\r\n                print_(\'__________________________________________\')\r\n            elif self.statusTotal > 0:\r\n                cTime = round(self.completionTime,2)\r\n                if cTime > 60:\r\n                    ncTime = str(round((self.completionTime/60),2)) + \' min\'\r\n                else:\r\n                    ncTime = str(round(self.completionTime,2)) + \' sec\'\r\n                print_(\'App time: \' + str(ncTime), end=\'\\r\', flush=True)\r\n                # sys.stdout.flush()\r\n\r\n    def spendFocus( self, name, focus, which ):\r\n\r\n\r\n        # print_( \'spendFocus which:\', which )\r\n\r\n        # print_( \'HERE: 0\' )\r\n        self.saveData()\r\n        # print_( \'HERE: 1\' )\r\n\r\n        if not self.records[focus][\'names\'][name][\'executed\']:\r\n            if not type( self.records[focus][\'names\'][name][\'trigger\'] ) == bool:\r\n                if not type( self.records[focus][\'names\'][name][\'triggerArg\'] ) == bool:\r\n                    # Timer(.0001, self.records[focus][\'names\'][name][\'trigger\'], self.records[focus][\'names\'][name][\'triggerArg\']).start()\r\n                    # print_( \'\\trunning 0\' )\r\n                    self.records[focus][\'names\'][name][\'trigger\'](**self.records[focus][\'names\'][name][\'triggerArg\'])\r\n\r\n                else:\r\n                    # print_( \'\\trunning 1\' )\r\n                    self.records[focus][\'names\'][name][\'trigger\']()\r\n            self.records[focus][\'names\'][name][\'executed\'] = True\r\n        # print_( \'HERE: 2\' )\r\n\r\n\r\n    def log( self, name=False, focus=False ):\r\n        if type(focus) == bool:\r\n            focus = __.appReg\r\n        log = []\r\n        if not type(name) == bool:\r\n            for i,t in enumerate(self.records[focus][\'threads\']):\r\n                if self.records[focus][\'threads\'][i].name == name:\r\n                    log.append(self.records[focus][\'threads\'][i].getLog())\r\n        else:\r\n            for i,t in enumerate(self.records[focus][\'threads\']):\r\n                for n in self.records[focus][\'names\']:\r\n                    if self.records[focus][\'threads\'][i].name == n:\r\n                        log.append(self.records[focus][\'threads\'][i].getLog())\r\n\r\n        for f in self.records:\r\n            self.records[f][\'threads\'] = False\r\n            for n in self.records[f][\'names\']:\r\n                if not type(self.records[f][\'names\'][n][\'trigger\']) == bool:\r\n                    self.records[f][\'names\'][n][\'trigger\'] = True\r\n\r\n\r\n\r\n        return {\r\n                    \'session\': _v.session(),\r\n                    \'created\': self.created,\r\n                    \'loadedby\': self.loadedBy,\r\n                    \'loadtime\': self.loadTime,\r\n                    \'lastactivity\': self.lastActivity,\r\n                    \'completiontime\': self.completionTime,\r\n                    \'nextid\': self.nextID,\r\n                    \'maxinqueue\': self.maxInQueue,\r\n                    \'totaltask\': __.totalTask,\r\n                    \'records\': self.records,\r\n                    \'maxthreadssafe\': self.maxThreadsSafe,\r\n                    \'projectdatamaxlen\': self.projectDataMaxLen,\r\n                    \'datadumps\': __.datadumps,\r\n                    \'appstructure\': __.structure(),\r\n                    \'threadlog\': log\r\n        }\r\n\r\n    def cnt( self, focus, up ):\r\n        # self.maxThreadsSafe\r\n        # self.maxThreads\r\n        if up:\r\n            if self.opened > self.maxInQueue:\r\n                self.maxInQueue = self.opened\r\n            self.lastActivity = time.time()\r\n            self.records[focus][\'open\'] += 1\r\n            self.opened += 1\r\n            __.queueCount += 1\r\n        else:\r\n            self.closed += 1\r\n            self.records[focus][\'open\'] -= 1\r\n            self.opened -= 1\r\n            __.queueCount -= 1\r\n\r\n    def schedule( self ):\r\n        Timer = __.imp(\'threading.Timer\')\r\n        __.queueCountSchedule += 1\r\n        __.queueCountScheduleAudit -= 1\r\n\r\n\r\n\r\n        if self.opened > self.maxThreads and self.notstarted > 0:\r\n            pass\r\n            time.sleep(.02)\r\n            # Timer( self.scheduleLoop, threadSchedule ).start()\r\n        else:\r\n\r\n            i = 0 \r\n            while self.opened < self.maxThreads-10 and i < self.notstarted:\r\n                # time.sleep(.02)\r\n                # print_( \'open:\', self.opened, \'max:\', self.maxThreads )\r\n                # if self.opened < self.maxThreads-10 and i < self.notstarted:\r\n                chosen = self.nextInQueue()\r\n                if type(chosen) == bool:\r\n                        return False\r\n                else:\r\n                    try:\r\n                        self.records[chosen[\'focus\']][\'threads\'][chosen[\'qID\']].open()\r\n                        self.notstarted -= 1\r\n                        self.cnt( chosen[\'focus\'], True )\r\n                        i += 1\r\n                    except Exception as e:\r\n                        time.sleep(.2)\r\n                        try:\r\n                            self.records[chosen[\'focus\']][\'threads\'][chosen[\'qID\']].open()\r\n                            self.notstarted -= 1\r\n                            self.cnt( chosen[\'focus\'], True )\r\n                            i += 1\r\n                        except Exception as e:\r\n                            time.sleep(.2)\r\n                            try:\r\n                                self.records[chosen[\'focus\']][\'threads\'][chosen[\'qID\']].open()\r\n                                self.notstarted -= 1\r\n                                self.cnt( chosen[\'focus\'], True )\r\n                                i += 1\r\n                            except Exception as e:\r\n                                pass\r\n\r\n\r\n        if self.notstarted > 0:\r\n            try:\r\n                Timer( self.scheduleLoop, threadSchedule ).start()\r\n            except Exception as e:\r\n                time.sleep(.2)\r\n                try:\r\n                    Timer( self.scheduleLoop, threadSchedule ).start()\r\n                except Exception as e:\r\n                    time.sleep(.2)\r\n                    try:\r\n                        Timer( self.scheduleLoop, threadSchedule ).start()\r\n                    except Exception as e:\r\n                        time.sleep(.2)\r\n                        try:\r\n                            Timer( self.scheduleLoop, threadSchedule ).start()\r\n                        except Exception as e:\r\n                            pass\r\n\r\n\r\n\r\n\r\n    def nextInQueue( self ):\r\n        chosen = False\r\n        try:\r\n            for key in self.records.keys():\r\n                for i,q in enumerate(self.records[key][\'threads\']):\r\n                    if not self.records[key][\'threads\'][i].active:\r\n                        chosen = { \'focus\': key, \'qID\': self.records[key][\'threads\'][i].qID }\r\n            if type(chosen) == bool:\r\n                # print_(\'active:\',self.checkActive())\r\n                return False\r\n        except Exception as e:\r\n            chosen = False\r\n        return chosen\r\n\r\n    def checkActive( self ):\r\n        active = 0\r\n        for key in self.records.keys():\r\n            for i,q in enumerate(self.records[key][\'threads\']):\r\n                if not self.records[key][\'threads\'][i].active:\r\n                    active += 1\r\n        return active\r\n\r\n    def isEverythingLoaded( self ):\r\n        loaded = True\r\n        shouldRun = True\r\n        if self.loadedBy > 0:\r\n            if self.loadedBy > self.lastActivity:\r\n                shouldRun = False\r\n        \r\n        if shouldRun:\r\n            for f in self.records.keys():\r\n                for n in self.records[f][\'names\'].keys():\r\n                    if not self.records[f][\'names\'][n][\'loaded\']:\r\n                        loaded = False\r\n            if loaded:\r\n                self.loadedBy = time.time()\r\n                self.loadTime = self.loadedBy - self.created\r\n                # self.isLoaded = True\r\n        return loaded\r\n\r\n    def isEverythingClosedEach( self, focus, name ):\r\n\r\n        closed = 0\r\n        total = 0\r\n        for key in self.records.keys():\r\n            for i,q in enumerate(self.records[key][\'threads\']):\r\n                if self.records[key][\'threads\'][i].name == name and self.records[key][\'threads\'][i].focus == focus:\r\n                    total += 1\r\n                    if self.records[key][\'threads\'][i].sstatus == 0:\r\n                        closed += 1\r\n        if total and closed and total == closed:\r\n            return True\r\n        return False\r\n\r\n    def isEverythingLoadedEach( self, focus, name ):\r\n        f = focus\r\n        n = name\r\n\r\n\r\n\r\n        hasChildren = False\r\n        for rec in self.records[focus][\'threads\']:\r\n            if rec.focus == focus and rec.name == name:\r\n                # if name == \'processMovies\':\r\n                #     colorThis( [ \'processMovies\' ], \'red\' )\r\n                hasChildren = True\r\n\r\n\r\n        if not hasChildren:\r\n            loaded = False\r\n        if hasChildren:\r\n\r\n\r\n\r\n            diff = int(time.time() - self.lastActivityEach[focus][name])\r\n            if diff > self.autoLoadedAfter:\r\n                self.loadedGroup( name=name , focus=focus )\r\n\r\n\r\n            loaded = True\r\n            shouldRun = True\r\n            # if self.loadedBy > 0:\r\n            #     if self.loadedBy > self.lastActivityEach[focus][name]:\r\n            #         shouldRun = False\r\n            \r\n            if shouldRun:\r\n\r\n                if not self.records[f][\'names\'][n][\'loaded\']:\r\n                    loaded = False\r\n\r\n                if loaded:\r\n                    self.loadedBy = time.time()\r\n                    self.loadTime = self.loadedBy - self.created\r\n                    # self.isLoaded = True\r\n\r\n\r\n\r\n            allComplete = True\r\n            for f in self.records.keys():\r\n                for n in self.records[f][\'names\'].keys():\r\n                    if not self.records[f][\'names\'][n][\'loaded\']:\r\n                        allComplete = False\r\n            if allComplete:\r\n                self.isLoaded = True\r\n\r\n\r\n        return loaded\r\n\r\n\r\n\r\n    def getRuntimeMemoryFocus( self, focus ):\r\n        runtime = []\r\n        memory = []\r\n        runtimeMemory = []\r\n        for i,q in enumerate(self.records[focus][\'threads\']):\r\n            if not self.records[key][\'threads\'][i].status:\r\n                run = self.records[focus][\'threads\'][i].log[\'runtime\']\r\n                mem = self.records[focus][\'threads\'][i].log[\'mem\']\r\n                runtime.append( run )\r\n                memory.append( mem )\r\n                runtimeMemory.append({ \'runtime\': run, \'mem\': mem })\r\n\r\n        return { \'runtime\': runtime, \'mem\': memory, \'runmem\': runtimeMemory, \'averagemem\': self.calcAverage(memory), \'averageruntime\': self.calcAverage(runtime)  }\r\n\r\n    def getRuntimeMemoryNameFocus( self, name, focus ):\r\n        runtime = []\r\n        runtimebottom = []\r\n        memory = []\r\n        runtimeMemory = []\r\n        self.numberClosed()\r\n        if self.records[focus][\'names\'][name][\'closed\'] < 5:\r\n            return False\r\n\r\n        for i,q in enumerate(self.records[focus][\'threads\']):\r\n            if not self.records[focus][\'threads\'][i].status and self.records[focus][\'threads\'][i].name == name:\r\n                run = self.records[focus][\'threads\'][i].log[\'runtime\']\r\n                mem = self.records[focus][\'threads\'][i].log[\'mem\']\r\n                runtime.append( run )\r\n                memory.append( mem )\r\n                runtimeMemory.append({ \'runtime\': run, \'mem\': mem })\r\n            if not self.records[focus][\'threads\'][i].status and self.records[focus][\'threads\'][i].name == name and not self.records[focus][\'threads\'][i].bottom:\r\n                self.records[focus][\'threads\'][i].bottom = True\r\n                runtimebottom.append( run )\r\n\r\n            if len(runtime) == 0 or len(memory) == 0 or len(runtimebottom) == 0 :\r\n                return False\r\n\r\n        try:\r\n\r\n            data = {\r\n                    \'runtime\': runtime,\r\n                    \'runtimebottom\': runtimebottom,\r\n                    \'mem\': memory,\r\n                    \'runmem\': runtimeMemory,\r\n                    \'averagemem\': self.calcAverage(memory),\r\n                    \'averageruntime\': self.calcAverage(runtime)\r\n        }\r\n\r\n        except Exception as e:\r\n            data = False\r\n            # print_(memory)\r\n\r\n        return data\r\n\r\n    def getRuntimeMemoryReport( self ):\r\n        self.runtime = []\r\n        self.mem = []\r\n        self.runtimeMemory = []\r\n        self.averagemem = 0\r\n        self.averageruntime = 0\r\n        for key in self.records.keys():\r\n            for i,q in enumerate(self.records[key][\'threads\']):\r\n                if not self.records[key][\'threads\'][i].status:\r\n                    run = self.records[key][\'threads\'][i].log[\'runtime\']\r\n                    mem = self.records[key][\'threads\'][i].log[\'mem\']\r\n\r\n                    self.runtime.append( run )\r\n                    self.mem.append( mem )\r\n                    self.runtimeMemory.append({ \'runtime\': runtime, \'mem\': mem })\r\n\r\n        self.averagemem = self.calcAverage(mem)\r\n        self.averageruntime = self.calcAverage(runtime)\r\n        return { \'runtime\': runtime, \'mem\': mem, \'runmem\': self.runtimeMemory, \'averagemem\': self.averagemem, \'averageruntime\': self.averageruntime }\r\n\r\n\r\n    def calcAverage( data ):\r\n        return round(data, 2)\r\n\r\n    def saveData( self ):\r\n\r\n        sqlite3 = __.imp(\'sqlite3\')\r\n        for focus in __.projectData:\r\n            try:\r\n                del __.projectData[focus][0]\r\n            except Exception as e:\r\n                pass\r\n            for name in __.projectData[focus].keys():\r\n                logName = \'auto_\' + self.records[focus][\'app\'] + \'_\' + name + \'_\' + str(self.created)\r\n                for pdID in __.projectData[focus][name].keys():\r\n                    if len(__.projectData[focus][name][pdID][\'data\']):\r\n                        __.datadumps += 1\r\n                        if type(self.records[focus][\'names\'][name][\'database\']) == bool or self.records[focus][\'names\'][name][\'database\'] is None:\r\n                            if len(__.projectData[focus][name][pdID][\'data\']) > 0:\r\n                                \r\n                                saveTableSplitNew( __.projectData[focus][name][pdID][\'data\'], logName, project=True )\r\n                                print_( \'check0:\', focus, name, pdID )\r\n                                if not \'folder\' in name:\r\n                                    print_( \'zero\' )\r\n                                    sys.exit()\r\n                                __.projectData[focus][name][pdID][\'data\'] = []\r\n                        else:\r\n                            print_()\r\n                            print_(\'Data saved to:\',self.records[focus][\'names\'][name][\'database\'])\r\n                            print_()\r\n\r\n\r\n                            if len(__.projectData[focus][name][pdID][\'data\']) > 0:\r\n                                try:\r\n                                    conn = sqlite3.connect(self.records[focus][\'names\'][name][\'database\'])\r\n                                    cursor = conn.cursor()\r\n                                    errors = []\r\n                                    for sql in __.projectData[focus][name][pdID][\'data\']:\r\n                                        try:\r\n                                            cursor.execute( sql )\r\n                                        except Exception as e:\r\n                                            errors.append( sql )\r\n                                    conn.commit()\r\n                                    conn.close()\r\n                                    if len(errors) > 0:\r\n                                        saveTableSplitNew( errors, logName+\'__ERRORS__\', project=True )\r\n                                except Exception as e:\r\n                                    saveTableSplitNew( __.projectData[focus][name][pdID][\'data\'], logName, project=True )\r\n                                    print_( \'check1:\', focus, name, pdID )\r\n                                if not \'folder\' in name:\r\n                                    print_( \'zero\' )\r\n                                    sys.exit()\r\n                                __.projectData[focus][name][pdID][\'data\'] = []\r\n\r\n\r\n\r\n    def manageData( self ):\r\n        sqlite3 = __.imp(\'sqlite3\')\r\n        self.data = {}\r\n        self.data[0] = 0\r\n        self.data[1] = 0\r\n        for focus in __.projectData:\r\n            # print_( \'focus:\', focus )\r\n            try:\r\n                del __.projectData[focus][0]\r\n            except Exception as e:\r\n                pass\r\n            for name in __.projectData[focus].keys():\r\n                logName = \'auto_\' + self.records[focus][\'app\'] + \'_\' + name + \'_\' + str(self.created)\r\n                for pdID in __.projectData[focus][name].keys():\r\n                    if not type(__.projectData[focus][name][pdID][\'saveInitiated\']) == bool:\r\n                        # print_(\'saveInitiated:\',__.projectData[focus][name][pdID][\'saveInitiated\'])\r\n                        # print_()\r\n                        # print_(len( __.projectData[focus][name][ __.projectData[focus][name][pdID][\'saveInitiated\'][\'pdID\'] ][\'data\'] ), __.projectData[focus][name][pdID][\'saveInitiated\'][\'size\'] )\r\n                        # print_()\r\n                        if len( __.projectData[focus][name][ __.projectData[focus][name][pdID][\'saveInitiated\'][\'pdID\'] ][\'data\'] ) > __.projectData[focus][name][pdID][\'saveInitiated\'][\'size\']:\r\n                            __.projectData[focus][name][pdID][\'saveInitiated\'][\'timeSizeChange\'] = time.time()\r\n                        else:\r\n                            # print_()\r\n                            # print_(\'got here\')\r\n                            # print_()\r\n\r\n                            diff = time.time() - __.projectData[focus][name][pdID][\'saveInitiated\'][\'timestamp\']\r\n                            print_()\r\n                            # print_()\r\n                            # print_(\'diff:\',diff)\r\n                            # print_()\r\n                            print_( \'diff:\', diff )\r\n                            print_( __.projectData[focus][name][pdID][\'saveInitiated\'][\'size\'], len(__.projectData[focus][name][  __.projectData[focus][name][pdID][\'saveInitiated\'][\'pdID\']  ][\'data\']))\r\n                            if diff > __.projectData[focus][name][pdID][\'saveInitiated\'][\'startAfterNoChangeFor\']:\r\n                                __.datadumps += 1\r\n                                if type(self.records[focus][\'names\'][name][\'database\']) == bool or self.records[focus][\'names\'][name][\'database\'] is None:\r\n                                    tmpData = __.projectData[focus][name][__.projectData[focus][name][pdID][\'saveInitiated\'][\'pdID\']][\'data\']\r\n                                    print_( \'save started\' )\r\n                                    saveTableSplitNew( tmpData, __.projectData[focus][name][pdID][\'saveInitiated\'][\'logname\'], project=True )\r\n                                    tmpData = []\r\n                                    print_( \'post split save:\', len(__.projectData[focus][name][__.projectData[focus][name][pdID][\'saveInitiated\'][\'pdID\']][\'data\']) )\r\n                                    __.projectData[__.projectData[focus][name][pdID][\'saveInitiated\'][\'focus\']][__.projectData[focus][name][pdID][\'saveInitiated\'][\'pdID\']] = []\r\n                                    if not \'folder\' in name:\r\n                                        print_( \'zero\' )\r\n                                        sys.exit()\r\n                                    __.projectData[focus][name][pdID][\'saveInitiated\'] = False\r\n                                    threadTimer( .5, enableThreadDataSwap )\r\n                            \r\n                                else:\r\n                                    print_()\r\n                                    print_(\'Data saved to:\',self.records[focus][\'names\'][name][\'database\'])\r\n                                    print_()\r\n                                    # try:\r\n                                    conn = sqlite3.connect(self.records[focus][\'names\'][name][\'database\'])\r\n                                    cursor = conn.cursor()\r\n                                    errors = []\r\n                                    for sql in __.projectData[focus][name][__.projectData[focus][name][pdID][\'saveInitiated\'][\'pdID\']][\'data\']:\r\n                                        try:\r\n                                            cursor.execute( sql )\r\n                                        except Exception as e:\r\n                                            errors.append( sql )\r\n                                    conn.commit()\r\n                                    conn.close()\r\n                                    if len(errors) > 0:\r\n                                        saveTableSplitNew( errors, logName+\'__ERRORS__\', project=True )\r\n                                    # except Exception as e:\r\n                                    #   saveTableSplitNew( __.projectData[focus][name][__.projectData[focus][name][pdID][\'saveInitiated\'][\'pdID\']][\'data\'], __.projectData[focus][name][pdID][\'saveInitiated\'][\'logname\'], project=True )\r\n                                    \r\n\r\n\r\n                                    # __.projectData[focus][name][  __.projectData[focus][name][pdID][\'saveInitiated\'][\'pdID\']  ][\'data\'] = []\r\n                                    if not \'folder\' in name:\r\n                                        print_( \'zero\' )\r\n                                        sys.exit()\r\n                                    __.projectData[focus][name][pdID][\'saveInitiated\'] = False\r\n                                    threadTimer( .5, enableThreadDataSwap )\r\n\r\n\r\n\r\n        tmpData = []\r\n\r\n        if not __.saveInitiated:\r\n            for focus in __.projectData:\r\n                try:\r\n                    del __.projectData[focus][0]\r\n                except Exception as e:\r\n                    pass\r\n                for name in __.projectData[focus].keys():\r\n                    for pdID in __.projectData[focus][name].keys():\r\n                        # print_(\'data len:\',len(__.projectData[focus][name][pdID][\'data\']))\r\n                        # print_(\'projectDataMaxLen:\',self.projectDataMaxLen)\r\n                        if len(__.projectData[focus][name][pdID][\'data\']):\r\n                            self.projectDataDetected = True\r\n\r\n                            # print_()\r\n                            # print_( len(__.projectData[focus][name][pdID][\'data\']), self.projectDataMaxLen )\r\n                            # print_()\r\n\r\n                            if len(__.projectData[focus][name][pdID][\'data\']) >= self.projectDataMaxLen:\r\n                                \r\n                                if __.pdID[focus][name] == 0:\r\n                                    __.pdID[focus][name] = 1\r\n                                    print_( \'NOW: 1\' )\r\n                                else:\r\n                                    __.pdID[focus][name] = 0\r\n                                    print_( \'NOW: 0\' )\r\n                                \r\n                                logname = \'auto_\' + self.records[focus][\'app\'] + \'_\' + str(self.created)\r\n                                __.saveInitiated = True\r\n\r\n                                __.processing = [ focus, name, pdID ]\r\n\r\n                                __.projectData[focus][name][pdID][\'saveInitiated\'] = {\r\n                                                            \'logname\': logname,\r\n                                                            \'pdID\': pdID,\r\n                                                            \'focus\': focus,\r\n                                                            \'timestamp\': time.time(),\r\n                                                            \'size\': len(__.projectData[focus][name][pdID][\'data\']),\r\n                                                            \'startAfterNoChangeFor\': 3,\r\n                                                            \'timeSizeChange\': 0,\r\n\r\n                                }\r\n\r\n\r\n            # self.timeout = False\r\n            # self.timeoutAsk = False\r\n            \r\n\r\n\r\n    def listen( self, qID, trigger=False, triggerArg=False, kwargs=False, data=False  ):\r\n        try:\r\n            self.listeningFor[\'active\']\r\n        except Exception as e:\r\n            self.listeningFor = []\r\n        self.listeningFor.append( { \'active\': True, \'qID\': qID, \'trigger\': trigger, \'triggerArg\': triggerArg, \'kwargs\': kwargs, \'data\': data } )\r\n\r\n    def listener( self ):\r\n        for li,listen in enumerate(self.listeningFor):\r\n            if self.listeningFor[li][\'active\']:\r\n                for focus in self.records.keys():\r\n                    for i,q in enumerate(self.records[focus][\'threads\']):\r\n                        if self.records[focus][\'threads\'][i].qID == listen[\'qID\'] and not self.records[focus][\'threads\'][i].status:\r\n                            thisData0 = self.records[focus][\'threads\'][i].data\r\n                            thisData1 = self.listeningFor[li][\'data\']\r\n                            thisData = False\r\n                            if sys.getsizeof(thisData0) > sys.getsizeof(thisData1):\r\n                                thisData = thisData0\r\n                            elif sys.getsizeof(thisData0) < sys.getsizeof(thisData1):\r\n                                thisData = thisData1\r\n                            self.listeningFor[li][\'data\'] = False\r\n                            self.listeningFor[li][\'active\'] = False\r\n                            self.records[focus][\'threads\'][i].data = False\r\n                            self.listenActivated( self.listeningFor[li][\'trigger\'], self.listeningFor[li][\'triggerArg\'], self.listeningFor[li][\'kwargs\'], thisData )\r\n\r\n\r\n    def listenActivated( self, trigger=False, triggerArg=False, kwargs=False, data=False  ):\r\n\r\n        __.queueLastActivity = time.time()\r\n        if not type(trigger) == bool:\r\n            try:\r\n                triggerName = trigger.__name__\r\n            except Exception as e:\r\n                triggerName = \'\'\r\n\r\n            try:\r\n\r\n                if type(data) == bool and type(triggerArg) == bool:\r\n                    threadTimer( .0001, trigger )\r\n                elif not type(data) == bool and type(triggerArg) == bool:\r\n                    threadTimer( .0001, trigger, [data] )\r\n                elif type(data) == bool and not type(triggerArg) == bool:\r\n                    threadTimer( .0001, trigger, triggerArg )\r\n                elif not type(data) == bool and not type(triggerArg) == bool and kwargs:\r\n                    args = [{ \'func\': trigger, \'args\': triggerArg }]\r\n                    try:\r\n                        args[0][\'args\'][0][\'data\'] = data\r\n                    except Exception as e:\r\n                        args[0][\'args\'][\'data\'] = data\r\n\r\n                    \r\n                    # print_(args)\r\n                    threadTimer( .0001, threadKwargs, args )\r\n                elif not type(data) == bool and not type(triggerArg) == bool and not kwargs:\r\n                    try:\r\n                        triggerArg.append(data)\r\n                        threadTimer( .0001, threadKwargs, triggerArg )\r\n                    except Exception as e:\r\n                        try:\r\n                            triggerArg[0].append(data)\r\n                            threadTimer( .0001, threadKwargs, triggerArg )\r\n                        except Exception as e:\r\n                            print_(\'listener trigger error\')\r\n\r\n\r\n            except Exception as e:\r\n                print_(\'listener trigger error\')\r\n\r\n\r\n    def printStatus( self ):\r\n        pDone = str(int(percentageDiffInt(self.closed, self.statusTotal)))\r\n        if not type( self.prefix ) == bool:\r\n            print_(\' \' + self.prefix + \':\', pDone + \'%\' , end=\'\\r\')\r\n        else:\r\n            print_(\' \' + pDone + \'%\' , end=\'\\r\')\r\n        sys.stdout.flush()\r\n\r\n    def timeoutCount( self ):\r\n        cnt = 0\r\n        for focus in self.records.keys():\r\n            for i,q in enumerate(self.records[focus][\'threads\']):\r\n\r\n                if self.records[focus][\'threads\'][i].hasTimedOut:\r\n                    cnt += 1\r\n        return cnt\r\n\r\n                \r\n\r\n    def kill( self, qID ):\r\n\r\n        qID = int(qID)\r\n        focus = None\r\n        rID = None\r\n        for i,t in enumerate(self.records[self.table[\'focus\'][qID]][\'threads\']):\r\n            if self.records[ self.table[\'focus\'][qID] ][\'threads\'][i].qID == qID:\r\n                focus = self.table[\'focus\'][qID]\r\n                name = self.records[self.table[\'focus\'][qID]][\'threads\'][i].name\r\n        \r\n                self.spent( qID, 0 )\r\n                self.records[focus][\'threads\'][i].hasTimedOut = 1\r\n                self.records[focus][\'threads\'][i].thisThread.kill()\r\n\r\n\r\n\r\n    def checkTimeout( self ):\r\n\r\n        for focus in self.records.keys():\r\n            for i, threads in enumerate( self.records[focus][\'threads\'] ):\r\n                if not threads.thisThread is None:\r\n                    if threads.status and threads.timeout:\r\n                        dur = time.time() - threads.log[\'start\']\r\n                        if dur > threads.timeout:\r\n                            # print_( \'time ran out\',threads.qID )\r\n                            # print_( \'time ran out\',threads.qID )\r\n                            # print_( \'time ran out\',threads.qID )\r\n\r\n\r\n                            # for x in dir(threads.thisThread):\r\n                            #     print_(x)\r\n\r\n                            # sys.exit()\r\n\r\n\r\n                            self.spent( threads.qID, 0 )\r\n                            self.records[focus][\'threads\'][i].hasTimedOut = 1\r\n                            self.records[focus][\'threads\'][i].thisThread.kill()\r\n                            # print_( \'stopped\' )\r\n\r\n\r\n\r\n        # return None\r\n        # if self.opened:\r\n        #     for focus in self.records.keys():\r\n        #         for i, threads in enumerate( self.records[focus][\'threads\'] ):\r\n        #             if not threads.thisThread is None:\r\n        #                 if threads.status and threads.timeout:\r\n        #                     print_( \'Has timeout\' )\r\n        #                     dur = time.time() - threads.log[\'start\']\r\n        #                     if dur > threads.timeout:\r\n        #                         print_( \'time ran out\' )\r\n        #                         self.spent( threads.qID, 0 )\r\n        #                         self.records[focus][\'threads\'][i].hasTimedOut = 1\r\n        #                         self.records[focus][\'threads\'][i].thisThread.kill()\r\n        #                         self.records[focus][\'threads\'][i].thisThread.join()\r\n        #                         print_( \'stopped\' )\r\n\r\n\r\n\r\n        # if not type( self.timeout ) == bool:\r\n        #     for focus in self.records.keys():\r\n        #         for i,q in enumerate(self.records[focus][\'threads\']):\r\n        #             if self.records[focus][\'threads\'][i].status:\r\n        #                 diff = time.time() - self.records[focus][\'threads\'][i].created\r\n        #                 if diff > self.timeout:\r\n        #                     self.records[focus][\'threads\'][i].timeout = True\r\n        #                     __.threadQueue[  self.records[focus][\'threads\'][i].qID  ]._stop()\r\n\r\n        # for focus in self.records.keys():\r\n        #     for name in self.records[focus][\'names\'].keys():\r\n        #         if not type( self.records[focus][\'names\'][name][\'timeout\'] ) == bool:\r\n        #             for i,q in enumerate(self.records[focus][\'threads\']):\r\n        #                 if name == self.records[focus][\'threads\'][i].name:\r\n        #                     if self.records[focus][\'threads\'][i].status:\r\n        #                         diff = time.time() - self.records[focus][\'threads\'][i].created\r\n        #                         if diff > self.records[focus][\'names\'][name][\'timeout\']:\r\n        #                             self.records[focus][\'threads\'][i].timeout = True\r\n        #                             __.threadQueue[  self.records[focus][\'threads\'][i].qID  ]._stop()\r\n                            \r\n\r\n        \r\n    def audit( self ):\r\n        if not type(self.listeningFor) == bool:\r\n            self.listener()\r\n        self.schedule()\r\n        self.checkTimeout()\r\n        self.isEverythingLoaded()\r\n        __.queueCountAudit += 1\r\n        __.queueCountAuditAudit -= 1\r\n        self.numberClosed()\r\n        if not self.isLoaded:\r\n            if self.autoLoaded:\r\n\r\n                diff2 = int(time.time() - __.queueLastActivity)\r\n                diff = int(time.time() - self.lastActivity)\r\n                if diff > self.autoLoadedAfter:\r\n                    if diff2 > self.autoLoadedAfter:\r\n                        if self.auditPrint:\r\n                            print_(\'Auto Loaded:\', diff)\r\n\r\n                        for focus in self.records.keys():\r\n                            for name in self.records[focus][\'names\'].keys():\r\n                                self.loaded( name=name, focus=focus )\r\n                        \r\n                        self.numberClosed()\r\n\r\n\r\n        self.manageData()\r\n\r\n\r\n\r\n        if self.auditPrint:\r\n            if self.projectDataDetected:\r\n\r\n                if False:\r\n                    print_()\r\n                    print_()\r\n                    print_(\'Opened:\',self.opened,\'\\tClosed:\',self.totalClosed,\'\\tClosed:\',self.closed,\'\\tTotal:\',self.nextID,\'\\tMax in queue:\',self.maxInQueue,\'\\tTotal Task:\',__.totalTask,\'\\tTotal Audit:\',__.queueCountScheduleAudit+__.queueCountSchedule )\r\n                    print_()\r\n                for focus in __.projectData:\r\n                    try:\r\n                        del __.projectData[focus][0]\r\n                    except Exception as e:\r\n                        pass\r\n                    for name in __.projectData[focus].keys():\r\n                        print_( \'pre:\', focus, name, __.projectData[focus].keys() )\r\n                        print_( \'0:\', len(__.projectData[focus][name][0][\'data\']), focus, name )\r\n                        print_( \'1:\', len(__.projectData[focus][name][1][\'data\']), focus, name )\r\n                        if len(__.projectData[focus][name][0][\'data\']) or len(__.projectData[focus][name][1][\'data\']):\r\n                            if False:\r\n                                print_(\'Name:\',name, \'\\tProject 0 Length:\', len(__.projectData[focus][name][0][\'data\']), \'\\tProject 1 Length:\', len(__.projectData[focus][name][1][\'data\']),\'\\tdb:\',self.records[focus][\'names\'][name][\'database\'] )\r\n                            if True:\r\n                                print_(\'Name:\',name, \'\\tOpened:\',self.opened,\'\\tClosed:\',self.closed,\'\\tTotal:\',self.nextID,\'\\tMax in queue:\',self.maxInQueue,\'\\tTotal Task:\',__.totalTask, \'\\tProject 0 Length:\', len(__.projectData[focus][name][0][\'data\']), \'\\tProject 1 Length:\', len(__.projectData[focus][name][1][\'data\']),\'\\tdb:\',self.records[focus][\'names\'][name][\'database\'] )\r\n            else:\r\n                print_(\'Opened:\',self.opened,\'\\tClosed:\',self.closed,\'\\tTotal:\',self.nextID,\'\\tMax in queue:\',self.maxInQueue,\'\\tTotal Task:\',__.totalTask,\'\\tTotal Audit:\',__.queueCountScheduleAudit+__.queueCountSchedule )\r\n            # print_( self.opened, self.isLoaded, self.notstarted )\r\n            if False:\r\n                print_()\r\n                print_( self.opened, self.isLoaded, self.notstarted )\r\n                print_()\r\n\r\n        elif self.statusTotal > 0:\r\n            self.printStatus()\r\n\r\n        pass\r\n        # if self.opened == 0:\r\n        for f in self.records.keys():\r\n            for n in self.records[f][\'names\'].keys():\r\n                if self.isEverythingLoadedEach( name=n, focus=f ) and self.isEverythingClosedEach( name=n, focus=f ):\r\n                    self.spendFocus( n, f, 2 )\r\n\r\n\r\n        if self.opened == 0 and self.isLoaded and self.notstarted <= 0:\r\n            if self.auditPrint:\r\n                print_(\'audit:\',__.queueCountAudit)\r\n            self.printReport()\r\n            self.saveData()\r\n            if self.saveLog:\r\n                threadTimer( 1, saveThreadsLog )\r\n\r\n            for f in self.records.keys():\r\n                for n in self.records[f][\'names\'].keys():\r\n                    self.spendFocus( n, f, 2 )\r\n\r\n\r\n        else:\r\n            diff = self.nextID - self.opened\r\n\r\n            if diff < 5:\r\n                threadTimer( self.auditLoop, threadAudit )\r\n                # Timer( .5, threadAudit ).start()\r\n            else:\r\n                for f in self.records.keys():\r\n                    for n in self.records[f][\'names\'].keys():\r\n\r\n                        data = self.getRuntimeMemoryNameFocusTopBottom( n, f )\r\n                        if type(data) == bool:\r\n                            threadTimer( self.auditLoop, threadAudit )\r\n                            # Timer( .5, threadAudit ).start()\r\n                            return False\r\n                        else:\r\n                            diff = percentageDiffInt(data[\'top\'], data[\'bottom\'])\r\n                            diff2 = percentageDiffInt(data[\'top\'], data[\'freshbottom\'])\r\n\r\n                            if diff < self.auditPercentChangeMax or diff2 < self.auditPercentChangeMax:\r\n                                self.records[f][\'names\'][n][\'failure\'] = 0\r\n                                self.records[f][\'names\'][n][\'changes\'] = 0\r\n                                self.records[f][\'names\'][n][\'watch\'] = 0\r\n                                shouldAct = False\r\n                            else:\r\n                                if not self.records[f][\'names\'][n][\'watch\'] >= self.auditWatchMax:\r\n                                    self.records[f][\'names\'][n][\'watch\'] += 1\r\n                                else:\r\n                                    self.records[f][\'names\'][n][\'failure\'] += 1\r\n                                    self.records[f][\'names\'][n][\'changes\'] += 1\r\n                                shouldAct = True\r\n\r\n                            if shouldAct:\r\n                                \r\n                                if self.records[f][\'names\'][n][\'failure\'] >= self.auditMaxFailuresBeforeAction:\r\n                                    lastMax = self.records[f][\'names\'][n][\'maxThreads\']\r\n                                    if self.records[f][\'names\'][n][\'changes\'] >= self.auditPercentDrasticThreshold:\r\n                                        changeBy = self.auditPercentReduceByDrastic\r\n                                    else:\r\n                                        changeBy = self.auditPercentReduceBy\r\n\r\n                                    newMax = percentageInt(self.opened, changeBy)\r\n\r\n                                    if newMax < self.minThreads:\r\n                                        newMax = self.minThreads\r\n                                    if newMax > self.maxThreadsSafe:\r\n                                        newMax = self.maxThreadsSafe\r\n                                    self.auditAutoAdjust = True\r\n                                    self.records[f][\'names\'][n][\'maxThreads\'] = newMax\r\n                                    print_(\'_________________________________________\')\r\n                                    print_()\r\n                                    print_(\'Changed max threads from:\', lastMax,\'to:\',newMax)\r\n\r\n                threadTimer( self.auditLoop, threadAudit )\r\n                # Timer( .5, threadAudit ).start()\r\n    # self.auditWatchMax\r\n\r\n# watch\r\n\r\n#                           if self.records[f][\'names\'][n][\'maxThreads\'] == 0:\r\n#                               newMax = self.opened\r\n#                       percentageInt(percent, whole)\r\n#                       if not self.records[f][\'names\'][n][\'loaded\']:\r\n#                           self.records[f][\'names\'][n][\'maxThreads\'] = True\r\n\r\n#                           self.records[f][\'names\'][n][\'maxThreads\'] = \r\n\r\n\r\n#       self.auditPercentReduceByOverMax = 15       self.maxThreads = 1000\r\n#       self.auditPercentReduceByOverMaxBy = 30\r\n\r\n\r\n# self.auditPercentReduceByDrastic\r\n#       self.auditPercentChangeMin = 10\r\n#       self. = 5\r\n\r\n#       self.auditPercentChangeMin = 10\r\n#       self.auditPercentReduceBy = 5\r\n\r\n# self.records[focus][\'names\'][name][\'maxThreads\']\r\n# self.auditPercentChangeMax\r\n#           __.queueCountAudit += 1\r\n#           Timer( .5, threadSchedule ).start()\r\n\r\n# threadTimer\r\n# thread = Timer( .0001, threadKwargs, data ).start()\r\n# thread = Timer( .0001, threadKwargs, data ).start()\r\n# thread = Timer( .0001, self.func, self.argID ).start()\r\n# thread = Timer( .0001, self.func, self.arg ).start()\r\n# Timer( self.scheduleLoop, threadSchedule ).start()\r\n# Timer( .3, threadAudit ).start()\r\n# Timer( self.scheduleLoop, threadSchedule ).start()\r\n# Timer( self.scheduleLoop, threadSchedule ).start()\r\n# Timer( self.scheduleLoop, threadSchedule ).start()\r\n# Timer( .5, threadAudit ).start()\r\n# Timer( .5, threadAudit ).start()\r\n# Timer( .5, threadAudit ).start()\r\n\r\n\r\n# __.queueCountScheduleAudit = 0\r\n# __.queueCountAuditAudit = 0\r\n\r\n\r\n    def numberClosed( self ):\r\n        self.isEverythingLoaded()\r\n        totalClosed = 0\r\n        for f in self.records.keys():\r\n            for i,t in enumerate(self.records[f][\'threads\']):\r\n                for n in self.records[f][\'names\'].keys():\r\n                    if not self.records[f][\'threads\'][i].name == n:\r\n                        self.records[f][\'names\'][n][\'closed\'] = 0 \r\n\r\n\r\n        info = {}\r\n        for f in self.records.keys():\r\n            for i,t in enumerate(self.records[f][\'threads\']):\r\n                if not self.records[f][\'threads\'][i].status:\r\n                    for n in self.records[f][\'names\'].keys():\r\n                        if self.records[f][\'threads\'][i].name == n:\r\n                            try:\r\n                                info[n][\'total\'] += 1\r\n                                info[n][\'closed\'] += 1\r\n                            except Exception as e:\r\n                                info[n] = {}\r\n                                info[n][\'total\'] = 0\r\n                                info[n][\'closed\'] = 0\r\n                                info[n][\'total\'] += 1\r\n                                info[n][\'closed\'] += 1\r\n                            if not self.records[f][\'threads\'][i].status:\r\n                                self.records[f][\'names\'][n][\'closed\'] += 1\r\n                                totalClosed += 1\r\n                        # if info[n][\'total\'] == info[n][\'closed\'] and info[n][\'total\'] > 0 and self.opened == 0 and self.isEverythingLoaded() and self.notstarted == 0:\r\n                            if self.isEverythingLoadedEach( name=n, focus=f ) and self.isEverythingClosedEach( name=n, focus=f ):\r\n                                self.spendFocus( n, f, 3 )\r\n                                # if not type( self.records[f][\'names\'][n][\'trigger\'] ) == bool:\r\n                                \r\n\r\n        self.totalClosed = totalClosed\r\n\r\n\r\n\r\n    def getRuntimeMemoryNameFocusTopBottom( self, name, focus ):\r\n        topruntime = []\r\n        bottomruntime = []\r\n        bottomruntimeFresh = []\r\n        \r\n        length = len(self.records[focus][\'threads\'])\r\n        sampleSize = percentageInt( self.auditPercentSample, length )\r\n        bottom = length - sampleSize\r\n        data = self.getRuntimeMemoryNameFocus( name, focus )\r\n        if type(data) == bool:\r\n            return False\r\n        if len(data[\'runtimebottom\']) < 5:\r\n            return False\r\n        else:\r\n\r\n            for i,row in enumerate(data[\'runtime\']):\r\n                if i <= sampleSize:\r\n                    topruntime.append(row)\r\n                if i >= bottom:\r\n                    bottomruntime.append(row)\r\n            for i,row in enumerate(data[\'runtimebottom\']):\r\n                    bottomruntimeFresh.append(row)\r\n\r\n            topaverageruntime = self.calcAverage(topruntime)\r\n            bottomaverageruntime = self.calcAverage(bottomruntime)\r\n            freshbottomaverageruntime = self.calcAverage(bottomruntimeFresh)\r\n\r\n            return { \'top\': topaverageruntime, \'bottom\': bottomaverageruntime, \'freshbottom\': freshbottomaverageruntime }\r\n\r\n\r\n    def getRuntimeMemoryFocusTopBottom( self, focus ):\r\n        topruntime = []\r\n        bottomruntime = []\r\n        \r\n        length = len(self.records[focus][\'threads\'])\r\n        sampleSize = percentageInt( self.auditPercentSample, length )\r\n        bottom = length - sampleSize\r\n        data = self.getRuntimeMemoryFocus( focus )\r\n\r\n        for i,row in enumerate(data[\'runtime\']):\r\n            if i <= sampleSize:\r\n                topruntime.append(row)\r\n            if i >= bottom:\r\n                bottomruntime.append(row)\r\n\r\n        topaverageruntime = self.calcAverage(topruntime)\r\n        bottomaverageruntime = self.calcAverage(bottomruntime)\r\n\r\n        return { \'top\': topaverageruntime, \'bottom\': bottomaverageruntime }\r\n\r\n\r\n\r\ndef enableThreadDataSwap():\r\n    print_( \'key test00:\', __.projectData[ __.processing[0] ].keys() )\r\n    print_( \'enableThreadDataSwap: initiated\' )\r\n    # print_( __.processing )\r\n    print_( \'post process size:\', len(__.projectData[ __.processing[0] ][ __.processing[1] ][   __.processing[2]   ][\'data\']) )\r\n    __.saveInitiated = False\r\n    \r\n    # __.projectData[focus][name][0][\'data\'] = []\r\n    print_( \'key test0:\', __.projectData[ __.processing[0] ].keys() )\r\n    # __.projectData[ __.processing[0] ][ __.processing[1] ][   __.processing[2]   ][\'data\'] = []\r\n    # __.projectData[ \'__main__\' ][ \'folder\' ][   __.processing[2]   ][\'data\'] = []\r\n    print_( \'key test1:\', __.projectData[ __.processing[0] ].keys() )\r\n\r\n# def hasTimedOut():\r\n#   print_( \'hasTimedOut\' )\r\n\r\n# @timeout( 10, hasTimedOut() )\r\ndef threadTimer( tim, func, args=False, qID=False ):\r\n    Timer = __.imp(\'threading.Timer\')\r\n    __.totalTask += 1\r\n    # print_(func.__name__)\r\n    shouldRun = True\r\n    if func.__name__ == \'threadSchedule\':\r\n        if __.queueCountScheduleAudit > 4:\r\n            shouldRun = False\r\n        else:\r\n            __.queueCountScheduleAudit += 1\r\n\r\n    if func.__name__ == \'threadAudit\':\r\n        if __.queueCountAuditAudit > 4:\r\n            shouldRun = False\r\n        else:\r\n            __.queueCountAuditAudit += 1\r\n\r\n    if shouldRun:\r\n        if tim < .01:\r\n            tim = .01\r\n\r\n        try:\r\n            if type(args) == bool:\r\n                if not type(qID) == bool:\r\n                    __.threadQueue[qID] = Timer( tim, func )\r\n                    __.threadQueue[qID].start()\r\n                else:\r\n                    Timer( tim, func ).start()\r\n            else:\r\n                if not type(qID) == bool:\r\n                    __.threadQueue[qID] = Timer( tim, func, args )\r\n                    __.threadQueue[qID].start()\r\n                else:\r\n                    Timer( tim, func, args ).start()\r\n            __.queueCountTimer += 1\r\n            # https://stackoverflow.com/questions/34562473/most-pythonic-way-to-kill-a-thread-after-some-period-of-time\r\n            # __.threadQueue[qID].join(30)\r\n            # if __.threadQueue[qID].is_alive():\r\n            #   print_( \'Has Timed Out\' )\r\n            #   e.set()\r\n            # else:\r\n            #   pass\r\n        except Exception as e:\r\n            print_(\'Thread Error:\',__.queueCountTimer)\r\n\r\n\r\ndef threadAudit():\r\n    global threads\r\n    threads.audit()\r\n\r\ndef threadSchedule():\r\n    global threads\r\n    threads.schedule()\r\n\r\ndef threadKwargs( data=False ):\r\n    # print_(data)\r\n    try:\r\n        data[\'func\'](**data[\'args\'][0])\r\n    except Exception as e:\r\n        try:\r\n            data[0][\'func\'](**data[\'args\'][0])\r\n        except Exception as e:\r\n            print_(\'Error: kwargs\')\r\n\r\n\r\n\r\ndef percentageInt( percent, whole, isFloat=False ):\r\n    # return int((percent * whole) / 100.0)\r\n    if not isFloat:\r\n        return int(round( (percent * whole) / 100.0 , 0))\r\n    else:\r\n        return round( (percent * whole) / 100.0 , 1)\r\n\r\ndef percentageDiffInt( smaller, bigger, isFloat=False, rnd=1 ):\r\n    # return int((smaller/bigger)*100)\r\n    try:\r\n\r\n        if not isFloat:\r\n            return int(round( abs(smaller/bigger)*100, 0))\r\n        else:\r\n            r = round( abs(smaller/bigger)*100, rnd)\r\n            if str(r) == \'0.0\':\r\n                return 0\r\n            # if str(r).endswtih(\'.0\'):\r\n            #     return int(r)\r\n\r\n            return r\r\n\r\n    except Exception as e:\r\n        return 0\r\n        smaller+=1\r\n        bigger+=1\r\n        if not isFloat:\r\n            return int(round( abs(smaller/bigger)*100, 0))\r\n        else:\r\n            r = round( abs(smaller/bigger)*100, rnd)\r\n            if str(r) == \'0.0\':\r\n                return 0\r\n            return r\r\n\r\ndef percentageDiffIntAuto( smaller, bigger, isFloat=False ):\r\n    if smaller < bigger:\r\n        s = smaller\r\n        b = bigger\r\n    else:\r\n        s = bigger\r\n        b = smaller\r\n    if not isFloat:\r\n        return percentageDiffInt(s, b)\r\n    else:\r\n        result = round(float((s/b)*100), 1)\r\n        r = str(result)\r\n        if \'.0\' in r:\r\n            result = int(result)\r\n        return result\r\n\r\ndef percentageDiffAuto( smaller, bigger, isFloat=False, rnd=1 ):\r\n    if smaller < bigger:\r\n        s = smaller\r\n        b = bigger\r\n    else:\r\n        s = bigger\r\n        b = smaller\r\n    return percentageDiffCalc(s, b, isFloat, rnd)\r\n\r\ndef percentageDiffSmaller( smaller, bigger, isFloat=False, rnd=1 ):\r\n    if smaller < bigger:\r\n        s = smaller\r\n        b = bigger\r\n    else:\r\n        s = bigger\r\n        b = smaller\r\n    a = percentageDiffCalc(s, b, isFloat, rnd)\r\n    b = percentageDiffCalc(b, s, isFloat, rnd)\r\n    if a<b:\r\n        return a\r\n    else:\r\n        return b\r\n\r\n\r\n\r\ndef percentageDiffCalc( smaller, bigger, isFloat=False, rnd=1 ):\r\n    # x=abs(abs(smaller - bigger)/smaller)*100\r\n    try:\r\n\r\n        if not isFloat:\r\n            return int(round( abs(abs(smaller - bigger)/smaller)*100, 0))\r\n        else:\r\n            r = round( abs(abs(smaller - bigger)/smaller)*100, rnd)\r\n            if str(r) == \'0.0\':\r\n                return 0\r\n            # if str(r).endswtih(\'.0\'):\r\n            #     return int(r)\r\n\r\n            return r\r\n\r\n    except Exception as e:\r\n        return 0\r\n        smaller+=1\r\n        bigger+=1\r\n        if not isFloat:\r\n            return int(round( abs(abs(smaller - bigger)/smaller)*100, 0))\r\n        else:\r\n            r = round( abs(abs(smaller - bigger)/smaller)*100, rnd)\r\n            if str(r) == \'0.0\':\r\n                return 0\r\n            return r\r\n\r\n\r\n     # = 0.2 = 20%\r\n # |5 - 6|/5 = 1/5 = 0.2 = 20%\r\n\r\n\r\n    # return percentageDiffInt(s, b, isFloat, rnd)\r\n\r\n\r\n###################################################################################################################\r\n""" {7DB6A001-0637-4F13-B328-2B17A481CF35}\r\n    print_(\'got here 2\')\r\n\r\ndef loadingGraphic():\r\n    # return False\r\n    import tkinter as tk\r\n    from PIL import Image, ImageTk\r\n    from itertools import count, cycle\r\n\r\n    global theLoadingGraphic\r\n\r\n    class ImageLabel(tk.Label):\r\n        \r\n        #A Label that displays images, and plays them if they are gifs\r\n\r\n        #:im: A PIL Image instance or a string filename\r\n        \r\n        def load(self, im):\r\n            if isinstance(im, str):\r\n                im = Image.open(im)\r\n            frames = []\r\n\r\n            try:\r\n                for i in count(1):\r\n                    frames.append(ImageTk.PhotoImage(im.copy()))\r\n                    im.seek(i)\r\n            except EOFError:\r\n                pass\r\n            self.frames = cycle(frames)\r\n\r\n            try:\r\n                self.delay = im.info[\'duration\']\r\n            except:\r\n                self.delay = 100\r\n\r\n            if len(frames) == 1:\r\n                self.config(image=next(self.frames))\r\n            else:\r\n                self.next_frame()\r\n\r\n        def unload(self):\r\n            self.config(image=None)\r\n            self.frames = None\r\n\r\n        def next_frame(self):\r\n            if self.frames:\r\n                self.config(image=next(self.frames))\r\n                self.after(self.delay, self.next_frame)\r\n\r\n    theLoadingGraphic = tk.Tk()\r\n    theLoadingGraphic.wait_visibility(theLoadingGraphic)\r\n    lbl = ImageLabel(theLoadingGraphic)\r\n    lbl.pack()\r\n    lbl.load( _v.dance )\r\n    theLoadingGraphic.mainloop()\r\n\r\ndef loadingGraphicEnd():\r\n    # return False\r\n    global theLoadingGraphic\r\n    print_(\'got here 1\')\r\n    # theLoadingGraphic.destroy()\r\n    # theLoadingGraphic.quit()\r\n"""\r\n###################################################################################################################\r\n\r\ndef isText( data ):\r\n    if type( data ) == str:\r\n\r\n        return True\r\n    else:\r\n        return False\r\n\r\ndef isNum( data ):\r\n    if type( data ) == int:\r\n        return True\r\n    else:\r\n        return False\r\n\r\ndef isFloat( data ):\r\n    if type( data ) == str:\r\n        t = \'\'\r\n        for x in data:\r\n            if not x in \'.0123456789\':\r\n                return False\r\n            else:\r\n                t += x\r\n\r\n        try:\r\n            data = float(t)\r\n        except Exception as e:\r\n            return False\r\n\r\n    if type( data ) == float:\r\n        return True\r\n    else:\r\n        return False\r\n\r\n###################################################################################################################\r\n\r\n\r\nclass Field:\r\n\r\n    def __init__( self, project, name, value, appReg, script, maxField ):\r\n        self.appReg = appReg\r\n        self.project = project\r\n        self.name = name\r\n        self.trigger = script\r\n        self.maxField = maxField\r\n\r\n\r\n\r\n        self.registerValue( value )\r\n\r\n    def setTrigger( self, script ):\r\n        self.trigger = script\r\n\r\n    def addPadding( self, value, extra, right, center ):\r\n        value = self.runTrigger( str(value) )\r\n        oValue = value\r\n        addPadding = (extra + self.maxField) - len( value )\r\n        add = \'\'\r\n        i=0\r\n        l=\'\'\r\n        r=\'\'\r\n        while not len(value) >= self.maxField+extra:\r\n            i+=1\r\n            if(i%2==0):\r\n                l+=\' \'\r\n            else:\r\n                r+=\' \'\r\n            value += \' \'\r\n            add += \' \'\r\n        # for x in range(1,addPadding+1):\r\n        #   value += \' \'\r\n        # return str(self.maxField)+\' \'+str(len( value ))+value\r\n        if right:\r\n            value = add + oValue\r\n        if center:\r\n            value = l + oValue + r\r\n        return value\r\n\r\n    def addPaddingSetSpaces( self, value ):\r\n        value = self.runTrigger( str(value) )\r\n        addPadding = self.maxField - len( value )\r\n        newValue = value\r\n        Zeros = \'\'\r\n        while not len(newValue) == self.maxField:\r\n            Zeros += \' \'\r\n            newValue = Zeros + value\r\n        return newValue\r\n\r\n    def addPaddingZeros( self, value ):\r\n        value = self.runTrigger( str(value) )\r\n        addPadding = self.maxField - len( value )\r\n        newValue = value\r\n        Zeros = \'\'\r\n        while not len(newValue) == self.maxField:\r\n            Zeros += \'0\'\r\n            newValue = Zeros + value\r\n        return newValue\r\n\r\n    def runTrigger( self, value ):\r\n        if type( self.trigger ) == bool:\r\n            return value\r\n\r\n        # print_( \'HERE\' )\r\n        return self.trigger( value )\r\n\r\n    def registerValue( self, value ):\r\n        thisLen = len( self.runTrigger( str(value) ) )\r\n\r\n        if thisLen > self.maxField:\r\n            self.maxField = thisLen\r\n\r\n\r\n\r\nclass Fields:\r\n\r\n    def __init__(self):\r\n        self.fields = {}\r\n        self.extra = 0\r\n\r\n    def lengths( self, project ):\r\n        result = {}\r\n        for record in self.fields[project]:\r\n            if record.project == project:\r\n                result[record.name] = record.maxField\r\n            \r\n        return result\r\n        \r\n\r\n    def register( self, project=\'\', names=\'\', value=\'\', appReg=False, script=False, maxField=None,        p=None, n=None, v=None, m=None, isRegisterDic=False ):\r\n\r\n        # if project in self.fields:\r\n        #   if not isRegisterDic:\r\n        #       del self.fields[ project ]\r\n\r\n        if not p is None:\r\n            project = p\r\n\r\n        if not n is None:\r\n            names = n\r\n\r\n        if not v is None:\r\n            value = v\r\n\r\n        maxField = 0\r\n\r\n        if not maxField is None:\r\n            maxField = maxField\r\n            \r\n        if not m is None:\r\n            maxField = m\r\n\r\n\r\n        if type(appReg) == bool:\r\n            appReg = __.appReg\r\n        if not project in self.fields:\r\n            self.fields[project] = []\r\n        for name in names.split(\',\'):\r\n\r\n            shouldAdd = True\r\n\r\n            for i,s in enumerate(self.fields[project]):\r\n                if self.fields[project][i].appReg == appReg and project == self.fields[project][i].project and name == self.fields[project][i].name:\r\n                    shouldAdd = False\r\n            if shouldAdd:\r\n                self.fields[project].append( Field( project, name, value, appReg, script, maxField ) )\r\n                if maxField and type(value) == int:\r\n                    return self.fields[project][len(self.fields[project])-1].addPaddingZeros(value)\r\n                elif maxField and type(value) == str:\r\n                    return self.fields[project][len(self.fields[project])-1].addPadding(value)\r\n            else:\r\n                self.registerValue( project, name, value, appReg )\r\n\r\n    def registerValue( self, project, name, value, appReg=False ):\r\n        if type(appReg) == bool:\r\n            appReg = __.appReg\r\n        \r\n        result = False\r\n        for i,s in enumerate(self.fields[project]):\r\n            if self.fields[project][i].appReg == appReg and project == self.fields[project][i].project and name == self.fields[project][i].name:\r\n                self.fields[project][i].registerValue( value )\r\n                result = True\r\n        return result\r\n\r\n\r\n    def padZeros( self, project, name, value, extra=None, appReg=False, space=False ):\r\n\r\n        if extra is None:\r\n            extra = self.extra\r\n\r\n        if type(appReg) == bool:\r\n            appReg = __.appReg\r\n        for i,s in enumerate(self.fields[project]):\r\n            if self.fields[project][i].appReg == appReg and project == self.fields[project][i].project and name == self.fields[project][i].name:\r\n                if space:\r\n                    return self.fields[project][i].addPaddingSetSpaces( value )\r\n                else:\r\n                    return self.fields[project][i].addPaddingZeros( value )\r\n                result = self.fields[project][i].addPaddingZeros( value )\r\n        return result\r\n\r\n\r\n    def value( self, project, name, value, extra=None, right=False, appReg=False,    r=None, center=False ):\r\n        result = value\r\n        if not r is None:\r\n            right = r\r\n\r\n        if extra is None:\r\n            extra = self.extra\r\n\r\n        if type(appReg) == bool:\r\n            appReg = __.appReg\r\n        for i,s in enumerate(self.fields[project]):\r\n            if self.fields[project][i].appReg == appReg and project == self.fields[project][i].project and name == self.fields[project][i].name:\r\n                result = self.fields[project][i].addPadding( value, extra, right, center )\r\n        return result\r\n    def valuez( self, project, name, value, appReg=False ):\r\n        if type(appReg) == bool:\r\n            appReg = __.appReg\r\n        for i,s in enumerate(self.fields[project]):\r\n            if self.fields[project][i].appReg == appReg and project == self.fields[project][i].project and name == self.fields[project][i].name:\r\n                result = self.fields[project][i].addPaddingZeros( value )\r\n        return result\r\n\r\n    def asset( self, project, asset, appReg=False ):\r\n        self.fields[project] = []\r\n        if type(appReg) == bool:\r\n            appReg = __.appReg\r\n\r\n        if type( asset ) == dict:\r\n            self.registerDic( project, asset, appReg )\r\n\r\n        if type( asset ) == list:\r\n            for row in asset:\r\n                if type( row ) == dict:\r\n                    self.registerDic( project, row, appReg )\r\n\r\n\r\n    def registerDic( self, project, asset, appReg=False ):\r\n        if type(appReg) == bool:\r\n            appReg = __.appReg\r\n\r\n        for name in asset.keys():\r\n            self.register( project, name, asset[name], appReg, isRegisterDic=True )\r\n\r\n# _.fields.register( \'project\', \'name\', script=_.resolveEpochTest )\r\n# _.fields.asset( \'project\', {} )\r\n# _.fields.asset( \'project\', [{}] )\r\n# _.fields.register( \'project\', \'name\', value, appReg=focus() )\r\n# _.fields.register( \'project\', \'name\', value )\r\n# _.fields.value( \'project\', \'name\', value )\r\n\r\n###################################################################################################################\r\n\r\n\r\n\r\nthisTest = \'hello\'\r\n\r\n\r\n\r\nerrors = []\r\nappInfo = {}\r\nappData = {}\r\n\r\nargvProcess = True\r\n\r\nfields = Fields()\r\n\r\nthreads = Queue()\r\nswitches = Switches()\r\ntables = Tables()\r\ndatabases = Databases()\r\n__.databases = Databases()\r\n\r\n\r\ndef appInfoDump():\r\n    global appInfo\r\n    for k in appInfo.keys():\r\n        print_()\r\n        print_(k,appInfo[k])\r\n\r\n\r\n\r\ndef appInfoDump2():\r\n    global appInfo\r\n    for k in appInfo.keys():\r\n        print_()\r\n        print_(k,appInfo[k])\r\n\r\n\r\n\r\n# def appInfoDump2():\r\n#   global appInfo\r\n#   for k in appInfo.keys():\r\n#       print_(k,appInfo[k][\'columns\'])\r\n\r\nswitches_loaded = 0\r\ndef load():\r\n    global switches_loaded\r\n    switches_loaded += 1\r\n    if switches_loaded > 1:\r\n    # if True\r\n        global switches\r\n        global switchDefault\r\n\r\n        # global tables\r\n\r\n        # switches.trigger(\'Column\',formatColumns)\r\n\r\n        switchDefault = switches.length()\r\n        switches.register(\'Help\', \'?,??,/?,/??,-?,-??,--??,/h,/help,-help,--help\', \'copy  OR ids  OR  12  OR  ?? x\')\r\n        switches.register(\'Column\', \'-c,-column\', \'size, name\')\r\n        switches.register(\'Sort\',\'-s,-sort\', \'Asc:type, Desc:ext\')\r\n        switches.register(\'Debug\', \'-debug\')\r\n        switches.register(\'Errors\', \'-Error,-Errors\', \'8,11 OR hide:8,11\')\r\n        switches.register(\'Timeout\', \'-t,-Timeout\')\r\n        switches.register(\'GroupBy\', \'-g,-group,-groupby\', \'ext, month\')\r\n        switches.register(\'WrapTable\', \'-wrap\', \'n p  OR  2  OR  path\')\r\n        switches.register(\'NoWrapTable\', \'-nowrap\')\r\n        # switches.register(\'NoTableLines\', \'-nolines\')\r\n        switches.register(\'YesTableLines\', \'-yl,-yeslines\')\r\n        switches.register(\'TableJSON\', \',-tjson,-tablejson\')\r\n        switches.register(\'FieldTotal\', \'-fieldtotal\', \'mem_usage\')\r\n        switches.register(\'Aggregate\', \'-aggregate\', \'" eof-field-len= add(len(version),len(backup)); config(var,eof,isFirst); "\')\r\n        switches.register(\'GroupSpaces\', \'-gs,-space,-groupspaces\')\r\n        switches.register(\'TableProfile\', \'-tp,-table\',\' *;c *;l  h;l header;left  size;l,gs\')\r\n        # switches.register(\'ShortenColumn\', \'-sc,-shortencolumn\')\r\n        switches.register(\'WebTable\', \'-web\')\r\n        switches.register(\'Long\', \'-long\')\r\n        switches.register(\'Short\', \'-sc,-short\')\r\n        switches.register(\'Length\', \'-length\',\'x3\')\r\n        # switches.register(\'Report\', \'-report\')\r\n        switches.register(\'Plus\', \'+\',\'all unless -or\')\r\n        switches.register(\'Minus\', \'-\')\r\n        switches.register(\'Plus-Sub\', \'++\',\'any\')\r\n        switches.register(\'PlusOr\', \'-or\')\r\n        switches.register(\'PlusClose\', \'+close\', \'90%\')\r\n        switches.register(\'PlusDuplicate\', \'+dup,+duplicate\', \'90%\')\r\n        switches.register(\'StrictCase\', \'-case,-strictcase\')\r\n        switches.register(\'PrintAutoAbbreviations\', \',-printa,-aprint\')\r\n        switches.register(\'NoColor\', \'-nocolor\', space=True)\r\n        switches.register(\'LoadEpoch\', \'-loadepoch\')\r\n        switches.register(\'PrintEpoch\', \'-printepoch\')\r\n        # switches.register(\'SkipColumnTriggers\', \'-skiptriggers\')\r\n        defaultScriptTriggers_do()\r\n        \r\n\r\n\r\n\r\nimport importlib\r\n\r\n\r\n\r\nregImps = {}\r\n\r\n\r\n\r\n##############################\r\n\r\nclass regImp:\r\n\r\n    def __init__( self, focus, app, argvProcessForce=False, dirty=False ):\r\n        global regImps\r\n        global appInfo\r\n\r\n        regImps[focus] = {}\r\n\r\n        # self.functions = autoKwargsGetArgsFromApp(app)\r\n\r\n        self.app = app\r\n        self.parent = focus\r\n        # print_( \'self.imp = importlib.import_module\', app )\r\n        self.imp = importlib.import_module(app)\r\n        # self.imp = importlib.util.spec_from_file_location( app, _v.py + _v.slash + app + \'.py\' )\r\n        # print_( os.path.isfile( _v.py + _v.slash + app + \'.py\' ) )\r\n        # print_( self.imp )\r\n        # print_( self.imp.test )\r\n        # sys.exit()\r\n        # print_(self.imp.focus())\r\n\r\n        self.focus = self.imp.focus( parentApp=focus )\r\n        self.focusPop = focus\r\n        \r\n        self.saveLog = True\r\n\r\n        \r\n        self.imp.registerSwitches( argvProcessForce=False)\r\n\r\n        appInfo[self.imp.focus(focus)] = appInfo[self.imp.focus()]\r\n        appData[self.imp.focus(focus)] = appData[self.imp.focus()]\r\n        __.constructRegistration(appInfo[self.imp.focus(focus)][\'file\'],self.imp.focus(focus))\r\n\r\n        regImps[focus] = {}\r\n        regImps[focus][app] = self.imp\r\n\r\n        __.appReg = self.focusPop\r\n\r\n        if dirty   and   not self.focus == \'__init___-___init__\':\r\n            self.imp.appDBA = self.focus\r\n\r\n\r\n        # self.provideImport()\r\n\r\n    def provideImport( self ):\r\n        return self.imp\r\n\r\n    def listFunctions( self ):\r\n        self.functions\r\n        for func in self.functions:\r\n            print_( func[\'name\'], func[\'args\'] )\r\n\r\n    def pipe( self, data=[], xfer=False, clear=True, appReg=False ):\r\n        global appData\r\n        if type(data) == bool:\r\n            return appData[self.focus][\'pipe\']\r\n\r\n        if type(appReg) == bool:\r\n            appReg = self.focusPop\r\n\r\n        if not len( data ):\r\n            if xfer:\r\n                data = appData[appReg][\'pipe\']\r\n                if clear:\r\n                    appData[appReg][\'pipe\'] = []\r\n\r\n        appData[self.focus][\'pipe\'] = data\r\n\r\n        try:\r\n            appData[self.focus][\'data\'][\'table\'][\'received\']\r\n            \r\n            profile = _profile.records.audit( \'pipe\', data, appReg=[appReg,self.focus] )\r\n            appData[appReg][\'data\'][\'table\'][\'sent\'].append( profile )\r\n            appData[self.focus][\'data\'][\'table\'][\'received\'].append( profile )\r\n        except Exception as e:\r\n            pass\r\n\r\n    def switch( self, names, value=None, appReg=False, delete=False,        d=False ):\r\n        global appData\r\n        global switches\r\n\r\n        if type(appReg) == bool:\r\n            appReg = self.focusPop\r\n\r\n        for name in names.split(\',\'):\r\n            vl = value\r\n            if name == \'Password\' or name == \'Key\':\r\n                vl = \'*******\'\r\n            if not value is None:\r\n                try:\r\n                    appData[self.focus][\'data\'][\'field\'][\'received\']\r\n                    profile = _profile.records.audit( name, vl, appReg=[appReg,self.focus] )\r\n                    appData[appReg][\'data\'][\'field\'][\'sent\'].append( profile )\r\n                    appData[self.focus][\'data\'][\'field\'][\'received\'].append( profile )\r\n                except Exception as e:\r\n                    pass\r\n\r\n\r\n            # print_(self.focus)\r\n            __.appReg = self.focus\r\n\r\n            if delete or d:\r\n                switches.fieldSet( name, \'active\', False )\r\n\r\n            else:\r\n\r\n                switches.fieldSet( name, \'active\', True )\r\n\r\n                # if not type ( value ) == bool:\r\n                if not value is None:\r\n                    if type( value ) == list:\r\n                        switches.fieldSet( name, \'values\', value )\r\n                        switches.fieldSet( name, \'value\', \',\'.join(value) )\r\n                    else:\r\n                        switches.fieldSet( name, \'value\', value )\r\n                        switches.fieldSet( name, \'values\', [value] )\r\n\r\n\r\n        __.appReg = self.focusPop\r\n\r\n    def deleteSwitch( self, name ):\r\n        global switches\r\n        __.appReg = self.focus\r\n\r\n        switches.fieldSet( name, \'active\', False )\r\n\r\n        __.appReg = self.focusPop\r\n\r\n    def action( self, focusPop=True ):\r\n        __.appReg = self.focus\r\n\r\n        result = self.imp.action()\r\n\r\n        if focusPop:\r\n            __.appReg = self.focusPop\r\n\r\n        return result\r\n\r\n\r\n    def do( self, func, arg=False, focusPop=True ):\r\n\r\n        __.appReg = self.focus\r\n\r\n        if type( func ) == str:\r\n            theFunction = eval( \'self.imp.\' + func )\r\n        else:\r\n            theFunction = func\r\n\r\n        if type( arg ) == bool:\r\n            result = theFunction()\r\n        elif type( arg ) == dict:\r\n            result = theFunction(**arg)\r\n        elif type( arg ) == list:\r\n            result = theFunction(*arg)\r\n        else:\r\n            result = theFunction(arg)\r\n\r\n        \r\n\r\n        if focusPop:\r\n            __.appReg = self.focusPop\r\n\r\n        return result\r\n\r\n    def execute( self, func, arg=False, nofocus=False ):\r\n        global threads\r\n        theFunc = eval(\'self.imp.\'+func)\r\n\r\n        shouldRun = True\r\n        if not nofocus and  type(arg) == bool:\r\n            args = [ self.focus ]\r\n        elif not nofocus and  not type(arg) == bool:\r\n            args = [ arg, self.focus ]\r\n\r\n        if nofocus and  type(arg) == bool:\r\n            shouldRun = False\r\n            theID = threads.add( \'execute\', theFunc, loaded=True )\r\n        elif nofocus and  not type(arg) == bool:\r\n            args = [ arg ]\r\n\r\n\r\n        if shouldRun:\r\n\r\n            theID = threads.add( \'execute\', theFunc, args, loaded=True )\r\n\r\n        # if self.saveLog:\r\n        # else:\r\n        #   theID = threads.add( \'execute\', theFunc, [ arg, self.focus ], trigger=saveThreadsLog, loaded=True )\r\n\r\n        return theID\r\n\r\n##############################\r\n# _regImpEXAMPLE = _.regImp( focus(), \'_rightThumb._auditCodeBase\' )\r\n\r\n# _regImpEXAMPLE.do( \'functionTest\' )\r\n# _regImpEXAMPLE.do( _codeX.imp.functionTest )\r\n# _regImpEXAMPLE.do( \'functionTestKwargs\', [\'Scott\',\'Alpha\'] )\r\n# _regImpEXAMPLE.do( \'functionTestKwargs\', { \'one\': \'Scott\', \'two\': \'Alpha\' } )\r\n\r\n# _regImpEXAMPLE.switch( \'Long\' )\r\n# _regImpEXAMPLE.switch( \'GroupBy\', \'appreg\' )\r\n\r\n# _regImpEXAMPLE.imp.focus( focus() )\r\n# _.switches.dumpSwitches()\r\n# _regImpEXAMPLE.imp.action()\r\n##############################\r\n##############################\r\n# txtBackup = _.regImp( __.appReg, \'txtBackup\' )\r\n# txtBackup = _.regImp( focus(), \'txtBackup\' )\r\n# txtBackup.switch( \'Silent\' )\r\n# txtBackup.switch( \'Input\', \'appreg\' )\r\n\r\n# txtBackup.do( txtBackup.imp.action )\r\n# txtBackup.do( \'action\' )\r\n# txtBackup.action()\r\n##############################\r\n\r\n\r\ndef saveThreadsLog():\r\n    global threads\r\n    # log = threads.log(\'execute\')\r\n    saveLog( \'threads\', printThis=False )\r\n\r\n\r\n\r\n\r\ndef autoKwargsGetArgsFromApp(app):\r\n    if not \'.py\' in app:\r\n        app = app + \'.py\'\r\n    appText = getText(_v.py + _v.slash + app)\r\n    func = []\r\n    for row in appText:\r\n        if \'def \' in row:\r\n            fr = row.split(\'def \')[1].replace(\' \',\'\')\r\n            name = fr.split(\'(\')[0]\r\n            if name+\'():\' in fr:\r\n                args = []\r\n            else:\r\n                tmp = fr.replace(name+\'(\',\'\')\r\n                arg = tmp.split(\'):\')[0]\r\n                args = []\r\n                for x in arg.split(\',\'):\r\n                    if \'=\' in x:\r\n                        args.append( { \'arg\': x.split(\'=\')[0], \'default\': x.split(\'=\')[1] } )\r\n                    else:\r\n                        args.append( { \'arg\': x, \'default\': \'\' } )\r\n\r\n\r\n            func.append( { \'name\': name, \'args\': args } )\r\n    return func\r\n\r\n\r\n\r\n###############################################\r\n####### imported into functions as needed\r\n    # math\r\n    # calendar\r\n    # re\r\n    # np\r\n    # random\r\n\r\n####### deleted\r\n# glob\r\n# subprocess\r\n# join\r\n# getsize\r\n# splitext\r\n# rrule\r\n# ast\r\n# OrderedDict\r\n###############################################\r\n\r\n### NOTES ###\r\n    # types of timestamps:\r\n    #                       1522705321.1137724      file create, modification\r\n    #                       1517338060740           int(round(time.time() * 1000))\r\n    \r\n\r\n\r\n# _.regImps( focus(), \'app\' )\r\n# _.regImps[focus()][\'app\']\r\n\r\n# class Threads\r\n# class Queue\r\n# def add(\r\n# def printReport(\r\n# def checkTimeout(\r\n# def audit\r\n\r\n# class regImp:\r\n\r\n\r\n# 2B-C3P0-AF i: {id} \r\n# 2B-R2D2-AF\r\n# r: {relatedid}\r\n\r\n{ \'2B100AF\': 0, \'id\': 0, \'genfrom\': 0,  \'created\': 1558456773.7885933 }\r\n\r\n############################################### ###############################################\r\n\r\nciData = (  \r\n            [ \'_;192A;_\',   \',\' ],\r\n            [ \'_;192B;_\',   \':\' ],\r\n            [ \';;\',         \',\' ],\r\n            [ \';c\',         \',\' ],\r\n            \r\n            [ \';_\',         \'-\' ],\r\n            [ \';-\',         \'-\' ],\r\n\r\n            [ \';p;\',        \'%\' ],\r\n            [ \';p\',         \'%\' ],\r\n            [ \';.\',         \':\' ],\r\n            [ ";;\'",        _v.slash+\'"\' ],\r\n\r\n            [ _v.slash+\'n\',        \'\\n\' ],\r\n            [ \';n\',         \'\\n\' ],\r\n            [ \';return\',    \'\\n\' ],\r\n            [ \';t\',         \'\\t\' ],\r\n\r\n            [ ";\'",         \'"\' ],\r\n            [ \';q;\',        \'"\' ],\r\n            [ \'"\\\'"\',       "\'" ],\r\n            [ \'null00\',     \'"",\' ],\r\n            [ \'"\\\'", "\\\'"\', "\',\'" ],\r\n\r\n            [ \'[star]\',     \'*\' ],\r\n            [ \'[a]\',        \'*\' ],\r\n            [ \'[s]\',        \'$\' ],\r\n            [ \'[eq]\',       \'=\' ],\r\n            [ \';opar;\',     \'[\' ],\r\n            [ \'[pipe]\',     \'|\' ],\r\n            [ \'[p]\',     \'|\' ],\r\n            [ \'[htmlopen]\', \'<\' ],\r\n            [ \'[htmlclose]\',\'>\' ],\r\n            [ \'[gtr]\',      \'>\' ],\r\n            [ \'[lss]\',      \'<\' ],\r\n            [ \';6\',         \'^\' ],\r\n            [ \';+\',         \'+\' ],\r\n\r\n            [ \'+--+c\',          \'--c\' ],\r\n\r\n            [ \'[semi]\',         \';\' ],\r\n            \r\n            [ \'[caret]\',    \'^\' ]  )\r\n\r\nleap_years_table = None\r\n###############################################\r\n \r\n\r\n\r\n\r\n############################################### ###############################################\r\n# testlist = [1, 2, 3, 5, 3, 1, 2, 1, 6]\r\n# test = [i for i,x in enumerate(testlist) if x == 1]\r\n\r\n\r\n\r\n# _.fields.register( \'project\', \'name\', script=_.resolveEpochTest )\r\n# _.fields.asset( \'project\', {} )\r\n# _.fields.asset( \'project\', [{}] )\r\n# _.fields.register( \'project\', \'name\', value, appReg=focus() )\r\n# _.fields.register( \'project\', \'name\', value )\r\n# _.fields.value( \'project\', \'name\', value )\r\n\r\n# fields = Fields()\r\n\r\n# TableProfile TableProfile_Config\r\n\r\n# switchDefault = switches.length()\r\n\r\n"""\r\n\r\nTo Do: * aggregate *\r\n    p ls -g folder ext -aggregate sum{bytes} -c folder ext bytes\r\n        self.group_structure[ folder ][ ext ] \r\n        sum( self.group_structure[ folder ][ ext ][ \' - aggregates (A359) - \' ][ bytes ] )\r\n\r\n"""\r\n"""\r\n        fileBackup = _.regImp( focus(), \'fileBackup\' )\r\n        fileBackup.switch( \'Silent\' )\r\n        fileBackup.switch( \'Flag\', \'cloud.del\' )\r\n        fileBackup.switch( \'isRunOnce\' )\r\n        fileBackup.switch( \'DoNotSchedule\' )\r\n\r\n        fileBackup.switch( \'Input\', path )\r\n        paths[\'backup\'] = fileBackup.do( \'action\' )\r\n\r\n\r\n\r\n_cryptFile = _.regImp( __.appReg, \'cryptFile\' )\r\n_cryptFile.switch( \'NoExt\' )\r\n_cryptFile.imp.appDBA = _cryptFile.focus\r\nfocus()\r\n\r\n_cryptFile.switch( \'Files\', row )\r\n_cryptFile.do( \'action\' )\r\n\r\n"""\r\n\r\n\r\n\r\n# {0E7253CE-1D9A-423D-9418-E082BF8495E1}\r\n\r\n# defaultScriptTriggers()\r\n\r\n############################################### ###############################################\r\n# alias\r\n\r\ncolorPrint=colorThis\r\ncp=colorThis\r\n\r\nvp=printVarSimple\r\npv=printVarSimple\r\npvs=printVarSimple\r\n\r\ndef e( msg , e=None, kill=True):\r\n    \r\n    cp( linePrint(txt=\'*\',p=0), \'red\' )\r\n    \r\n    cp( \'  Error\', \'red\' )\r\n    if type(msg) == str:\r\n        cp( [ \'  \\t\', msg ], \'yellow\' )\r\n    if type(msg) == list:\r\n        nu={}\r\n        # msgN = [\'  \\t\']\r\n        for x in msg:\r\n            if x ==0:\r\n                print_()\r\n            elif type(x)==dict: # { \'l\': line, \'c\': \'green\', \'d\': 1, \'n\': \'todo\' }\r\n                l=x[\'l\']\r\n                if \'c\' in x:\r\n                    c=x[\'c\']\r\n                else:\r\n                    c=\'yellow\'\r\n                if \'d\' in x:\r\n                    d=x[\'d\']\r\n                else:\r\n                    d=0\r\n\r\n                if \'n\' in x:\r\n                    nn=x[\'n\']\r\n                    if not nn in nu:\r\n                        nu[nn]=0\r\n                    n=nu[nn]\r\n                else:\r\n                    n=None\r\n\r\n                if len(x) == 3:\r\n                    c\r\n                w=\'  \\t\'\r\n                i=0\r\n                while not i == d:\r\n                    i+=1\r\n                    w+=\'\\t\'\r\n                if n is None:\r\n                    cp( [ w, l ], c )\r\n                else:\r\n                    nu[nn]+=1\r\n                    cp( [ w, str(nu[nn])+\')\', l ], c )\r\n\r\n            else:\r\n                cp( [ \'  \\t\', x ], \'yellow\' )\r\n\r\n            # msgN.append(x)\r\n        # cp( msgN, \'yellow\' )\r\n    if not e is None:\r\n        cp( [\'  \\t\\t\',e], \'cyan\' )\r\n        \r\n    # cp( \'**********************************************************************\', \'red\', isError=True )\r\n    # linePrint()\r\n    cp( linePrint(txt=\'*\',p=0), \'red\' )\r\n    if kill:\r\n        sys.exit()\r\n    # \xe2\x96\xb3 \xe2\x96\xbd\r\n\r\ndef key( subject ):\r\n    try:\r\n        table = getTableDB( \'secureStrings.hash\' )\r\n        return table[subject]\r\n    except Exception as ee:\r\n        e( \'secureString\', ee )\r\n\r\n\r\n\r\ndef historyPrint( code, pre=\'\' ):\r\n    i=0\r\n    while not i >= 4:\r\n        i+=1\r\n        code = _str.cleanBE(code, \'\\n\')\r\n        code = _str.cleanBE(code, \' \')\r\n        code = _str.cleanBE(code, \'\\t\')\r\n\r\n    if switches.isActive(\'DoNotColorize\'):\r\n        return code\r\n    result = \'\'\r\n    \r\n    colors = {\r\n                \'cmd\': \'purple\',\r\n                \'py\': \'yellow\',\r\n                \'pipe\': \'red\',\r\n                \'switches\': \'green\',\r\n                \'value\': \'cyan\',\r\n                \'quote\': \'darkcyan\',\r\n    }\r\n\r\n        \r\n    lastP=False\r\n    lastSwitch=False\r\n    lastCMD=False\r\n    lastPipe=False\r\n    for i,x in enumerate(code.split(\' \')):\r\n        if x.lower() == \'p\' or x.lower() == \'%py%\' or x.lower() == \'pp\' or x.lower() == \'python\' or x.lower() == \'python.exe\' or x.lower().endswith(\'python.exe\'):\r\n            lastP = True\r\n            result += colorThis( x, colors[\'cmd\'], p=0 )\r\n            lastSwitch = False\r\n            lastPipe = False\r\n        elif i == 0 or lastPipe:\r\n            lastPipe = False\r\n            lastCMD = True\r\n            result += colorThis( x, colors[\'cmd\'], p=0 )\r\n        elif lastP:\r\n            lastSwitch = False\r\n            result += colorThis( x, colors[\'py\'], p=0 )\r\n        elif x.startswith(\'+\'):\r\n            lastSwitch = True\r\n            result += colorThis( x, colors[\'switches\'], p=0 )\r\n        elif x.startswith(\'-\') or( x.startswith(\'/\') and not \' -\' in code ):\r\n            lastSwitch = True\r\n            result += colorThis( x, colors[\'switches\'], p=0 )\r\n\r\n\r\n        elif x == \'|\' or x == \'&\':\r\n            lastCMD = False\r\n            lastSwitch = False\r\n            lastPipe = True\r\n            result += colorThis( x, colors[\'pipe\'], p=0 )\r\n        elif lastSwitch:\r\n            if \'"\' in x:\r\n                yx=\'\'\r\n                Yy=\'\'\r\n                for yY in x:\r\n                    if not yY == \'"\':\r\n                        Yy+=yY\r\n                    else:\r\n                        if Yy:\r\n                            yx+=colorThis( Yy, colors[\'value\'], p=0 )\r\n                            Yy=\'\'\r\n                        yx+=colorThis( \'"\', colors[\'quote\'], p=0 )\r\n                if Yy:\r\n                    yx+=colorThis( Yy, colors[\'value\'], p=0 )\r\n                    Yy=\'\'\r\n\r\n                result += yx\r\n            else:\r\n                result += colorThis( x, colors[\'value\'], p=0 )\r\n        elif lastCMD:\r\n            result += colorThis( x, colors[\'value\'], p=0 )\r\n        else:\r\n            result += x\r\n        result += \' \'\r\n\r\n        if not x == \'p\':\r\n            lastP = False\r\n    return pre+result\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\nclass ONLINE:\r\n    def __init__( self ):\r\n        self.onStatus=0\r\n        self.ip=\'0.0.0.0\'\r\n \r\n        \r\n \r\n\r\n    def page( self, url ):\r\n        # requests = vc.FIG.imp(\'requests\')\r\n        requests = __.imp(\'requests\')\r\n        if requests is None:\r\n            return \'\'\r\n        try:\r\n            page = requests.get(url)\r\n            page_code = str(page.text)\r\n            self.onStatus=True\r\n        except Exception as e:\r\n            self.onStatus=False\r\n            page_code=\'\'\r\n        page_code = page_code.replace( chr(10), \'\\n\' )\r\n        page_code = page_code.replace( chr(27), \'\' )\r\n        page_code = page_code.replace( \'\\r\', \'\' )\r\n        return page_code\r\n\r\n\r\n    def status( self ):\r\n \r\n        # loader()\r\n \r\n        # requests = vc.FIG.imp(\'requests\')\r\n        requests = __.imp(\'requests\')\r\n        if requests is None:\r\n            self.onStatus = None\r\n            return self.onStatus\r\n\r\n        url = \'http://tools.rightthumb.com/ip.php\'\r\n        if type(self.onStatus) == bool:\r\n            return self.onStatus\r\n        page_code = self.page(url)\r\n        if not self.onStatus:\r\n            return self.onStatus\r\n        page_code = page_code.replace( \'\\n\', \'\' )\r\n        page_code = page_code.replace( \' \', \'\' )\r\n        if len(page_code) > 6 and len(page_code) < 16:\r\n            self.ip = page_code\r\n            self.onStatus = True\r\n        else:\r\n            self.onStatus = False\r\n        # print_(self.ip)\r\n        # print_(self.onStatus)\r\n        return self.onStatus\r\n\r\n\r\n\r\n    def download_updates( self ):\r\n        # requests = vc.FIG.imp(\'requests\')\r\n        requests = __.imp(\'requests\')\r\n        # print_(\'here\')\r\n        # vc.FIG.bash_vars(p=0)\r\n        if not os.path.isdir(_v.home +os.sep+ \'.rt\'):\r\n            os.mkdir(_v.home +os.sep+ \'.rt\')\r\n\r\n        \r\n\r\n        if self.status():\r\n            cp( [\'status:\', self.onStatus], \'green\' )\r\n        else:\r\n            cp( [\'status:\', self.onStatus], \'red\' )\r\n        if self.status():\r\n\r\n            files = []\r\n            files.append({ \'label\': \'tool\', \'path\': _v.home +os.sep+ \'.rt\' +os.sep+ \'tool\', \'pre-exist\': False })\r\n            files.append({ \'label\': \'tool.sh\', \'path\': _v.home +os.sep+ \'.rt\' +os.sep+ \'tool.sh\', \'pre-exist\': False })\r\n            files.append({ \'label\': \'help.txt\', \'path\': _v.home +os.sep+ \'.rt\' +os.sep+ \'help.txt\', \'pre-exist\': False })\r\n            # rec = { \'label\': \'bashrc.py\', \'path\': v.bash[\'tech_drive\'] + \'/tech/programs/python/src/unity/bashrc.py\', \'pre-exist\': True }\r\n            # rec[\'path\'] = rec[\'path\'].replace( \'/\', os.sep )\r\n            # files.append(rec)\r\n            rec = { \'label\': \'load-vars.sh\', \'path\': v.bash[\'tech_drive\'] + \'/tech/programs/bash/load-vars.sh\', \'pre-exist\': True }\r\n            rec[\'path\'] = rec[\'path\'].replace( \'/\', os.sep )\r\n            files.append(rec)\r\n\r\n\r\n            for rec in files:\r\n                p = rec[\'path\']\r\n                l = rec[\'label\']\r\n\r\n                shouldProcess = False\r\n                if not rec[\'pre-exist\']:\r\n                    shouldProcess = True\r\n                else:\r\n                    if os.path.isfile(rec[\'path\']):\r\n                        shouldProcess = True\r\n                if shouldProcess:\r\n                    \r\n                    if os.path.isfile(p):\r\n                        os.unlink(p)\r\n                    if not os.path.isfile( p ):\r\n                        print_()\r\n                        cp( [ \'downloading:\', l ], \'yellow\' )\r\n                        url = \'http://reph.us/tools/\'+l\r\n                        page = requests.get(url)\r\n                        page_code = str(page.text)\r\n                        page_code = page_code.replace( chr(10), \'\\n\' )\r\n                        page_code = page_code.replace( chr(27), \'\' )\r\n                        page_code = page_code.replace( \'\\r\', \'\' )\r\n                        # vc.HD.saveText( page_code, p )\r\n                        saveText( page_code, p )\r\n                        cp( [ \'saved:\', p ], \'yellow\' )\r\n                else:\r\n                    print_(rec)\r\n\r\n    download = download_updates\r\nimps = {}\r\ndef impath(path):\r\n    if path == \'?tool\':\r\n        path = _v.home +os.sep+ \'.rt\' +os.sep+ \'tool\'\r\n    return path\r\ndef import_path(path):\r\n    global imps\r\n    path = impath(path)\r\n    module_name = os.path.basename(path).replace(\'-\', \'_\')\r\n    spec = importlib.util.spec_from_loader( module_name, importlib.machinery.SourceFileLoader(module_name, path) )\r\n    module = importlib.util.module_from_spec(spec)\r\n    spec.loader.exec_module(module)\r\n    sys.modules[module_name] = module\r\n    if not path in imps:\r\n        imps[path] = module\r\n    return imps[path]\r\n\r\nsize_group_data = [{"l": "1", "s": "500", "x": "kb"}, {"l": "2", "s": "1", "x": "mb"}, {"l": "3", "s": "5", "x": "mb"}, {"l": "4", "s": "10", "x": "mb"}, {"l": "5", "s": "20", "x": "mb"}, {"l": "6", "s": "50", "x": "mb"}, {"l": "7", "s": "200", "x": "mb"}, {"l": "8", "s": "500", "x": "mb"}, {"l": "9", "s": "1", "x": "gb"}, {"l": "10", "s": "5", "x": "gb"}, {"l": "11", "s": "10", "x": "gb"}, {"l": "12", "s": "20", "x": "gb"}, {"l": "13", "s": "50", "x": "gb"}, {"l": "14", "s": "200", "x": "gb"}, {"l": "15", "s": "500", "x": "gb"}, {"l": "16", "s": "1", "x": "tb"}, {"l": "17", "s": "5", "x": "tb"}, {"l": "18", "s": "10", "x": "tb"}, {"l": "19", "s": "20", "x": "tb"}, {"l": "20", "s": "50", "x": "tb"}, {"l": "21", "s": "200", "x": "tb"}, {"l": "22", "s": "500", "x": "tb"}, {"l": "23", "s": "1", "x": "pb"}, {"l": "24", "s": "5", "x": "pb"}, {"l": "25", "s": "10", "x": "pb"}, {"l": "26", "s": "20", "x": "pb"}, {"l": "27", "s": "50", "x": "pb"}, {"l": "28", "s": "200", "x": "pb"}, {"l": "29", "s": "500", "x": "pb"}, {"l": "30", "s": "1", "x": "eb"}, {"l": "31", "s": "5", "x": "eb"}, {"l": "32", "s": "10", "x": "eb"}, {"l": "33", "s": "20", "x": "eb"}, {"l": "34", "s": "50", "x": "eb"}, {"l": "35", "s": "200", "x": "eb"}, {"l": "36", "s": "500", "x": "eb"}, {"l": "37", "s": "1", "x": "zb"}, {"l": "38", "s": "5", "x": "zb"}, {"l": "39", "s": "10", "x": "zb"}, {"l": "40", "s": "20", "x": "zb"}, {"l": "41", "s": "50", "x": "zb"}, {"l": "42", "s": "200", "x": "zb"}, {"l": "43", "s": "500", "x": "zb"}, {"l": "44", "s": "1", "x": "yb"}, {"l": "45", "s": "5", "x": "yb"}, {"l": "46", "s": "10", "x": "yb"}, {"l": "47", "s": "20", "x": "yb"}, {"l": "48", "s": "50", "x": "yb"}, {"l": "49", "s": "200", "x": "yb"}, {"l": "50", "s": "500", "x": "yb"}]\r\ndef size_group_print(m=True, l=0):\r\n    global size_group_data\r\n    records = []\r\n    for rec in size_group_data:\r\n        if m:\r\n            if rec[\'x\'] == \'pb\':\r\n                break\r\n        records.append({ \'group\': rec[\'l\'], \'size\': rec[\'s\']+rec[\'x\'] })\r\n    tables.rprint( records , l=l)\r\ndef size_group(s):\r\n    global size_group_data\r\n    if type(s) == str:\r\n        s = unFormatSize(s)\r\n\r\n    if s == 0:\r\n        return 0\r\n    size_group_data.reverse()\r\n    last = 0\r\n\r\n    for rec in size_group_data:\r\n        un = rec[\'s\']+rec[\'x\']\r\n        fo = unFormatSize(un)\r\n        if s >= fo:\r\n            return int(rec[\'l\'])\r\n    return 1\r\n\r\ndef size_group_size(g,f=1):\r\n    global size_group_data\r\n    if type(g) == str:\r\n        g = int(g)\r\n    for rec in size_group_data:\r\n        if g == int(rec[\'l\']):\r\n            un = rec[\'s\']+rec[\'x\']\r\n            fo = unFormatSize(un)\r\n            if f:\r\n                return formatSize(fo).replace(\' \',\'\').replace(\'.0\',\'\')\r\n            return fo\r\n\r\n\r\n\r\n    pass\r\n\r\n# try:\r\n#     class ONLINE2:\r\n#         def __init__( self ):\r\n#             self.tool = import_path(\'?tool\')\r\n#             self.page = self.tool.vc.ONLINE = self.tool.ONLINE()\r\n#             self.page = self.tool.vc.ONLINE.page\r\n#             self.status = self.tool.vc.ONLINE.status\r\n#             self.download_updates = self.tool.vc.ONLINE.download_updates\r\n#             self.download = self.tool.vc.ONLINE.download_updates\r\n#     o2 = ONLINE2()\r\n#     ol = o2.status()\r\n#     if ol:\r\n#         cp( \'online\', \'green\' )\r\n#     else:\r\n#         cp( \'offline\', \'red\' )\r\n# except Exception as e:\r\n#     cp( \'ol2\', \'red\' )\r\n\r\n# self.columnTab+tableLine\r\n\r\n__.onExit(tables.eof)\r\n\r\nhp = historyPrint\r\nph = historyPrint\r\n\r\n# class regImp:\r\n# \'WebTable\'\r\n# NoTableLines\r\n\r\n##########################################################\r\n# index AND line\r\n\'\'\'\r\n    i=0\r\n    while True:\r\n        eol=_.vindex(data,i,n=\'\\n\')\r\n        if not type(eol) == int: eol=len(data)-1;\r\n        if eol < 1: break;\r\n        line = data[ i: eol+1 ].replace(\'\\n\',\'\')\r\n        pass\r\n        pass\r\n        i=eol+1\r\n        if i == len(data): break;\r\n\'\'\'\r\n##########################################################\r\n# colorizeRow\r\n\r\n# def dict_generator(indict, pre=None):\r\n#     pre = pre[:] if pre else []\r\n#     if isinstance(indict, dict):\r\n#         for key, value in indict.items():\r\n#             if isinstance(value, dict):\r\n#                 for d in dict_generator(value, pre + [key]):\r\n#                     yield d\r\n#             elif isinstance(value, list) or isinstance(value, tuple):\r\n#                 for v in value:\r\n#                     for d in dict_generator(v, pre + [key]):\r\n#                         yield d\r\n#             else:\r\n#                 yield pre + [key, value]\r\n#     else:\r\n#         yield pre + [indict]\r\n\r\n\r\ndef appID_nID_password():\r\n    try:\r\n        from random import randrange\r\n    except Exception as e:\r\n        pass\r\n    tn=\'8136901260\'\r\n    o=randrange(len(tn))\r\n    if not o:\r\n        o+=1\r\n    if str(randrange(1000)/2).endswith(\'.0\'):\r\n        n=tn[o:]\r\n    else:\r\n        n=tn[:o]\r\n    return n\r\n\r\n\r\ndef dict_generator_prefix( cnt, txt=\'    \' ):\r\n    result=\'\'\r\n    n=0\r\n    while not n == cnt:\r\n        result+=txt\r\n        n+=1\r\n    return result\r\n\r\n\r\n\r\ndict_generator_spent=[]\r\ndict_generator_index={}\r\ndef dict_generator(indict, pre=None, fields=[] ):\r\n    global dict_generator_spent\r\n    global dict_generator_index\r\n    pre = pre[:] if pre else []\r\n    if isinstance(indict, dict):\r\n        for key, value in indict.items():\r\n            if isinstance(value, dict):\r\n                for d in dict_generator(value, pre + [key],fields):\r\n                    yield d\r\n            elif isinstance(value, list) or isinstance(value, tuple):\r\n                for v in value:\r\n                    for d in dict_generator(v, pre + [key],fields):\r\n                        yield d\r\n            else:\r\n                # yield pre + [key, value]\r\n                path = pre + [key]\r\n                p = \'.\'.join(path)\r\n                if not p in dict_generator_index:\r\n                    dict_generator_index[p]=1\r\n                else:\r\n                    dict_generator_index[p]+=1\r\n                # print_(p)\r\n                found = False\r\n\r\n                if key in fields:\r\n                    found = True\r\n                    pp=key\r\n                elif p in fields:\r\n                    pp=p\r\n                    found = True\r\n                if found:\r\n                    f = fields.index(pp)\r\n                    if f == 0:\r\n                        if not value in dict_generator_spent:\r\n                            dict_generator_spent.append(value)\r\n                            cp(value,\'green\')\r\n                    else:\r\n                        xXx = dict_generator_prefix(f) + value\r\n                        if f ==1:\r\n                            cp(xXx,\'yellow\')\r\n                        elif f == 2:\r\n                            cp(xXx,\'cyan\')\r\n                        elif f == 3:\r\n                            cp(xXx,\'blue\')\r\n                        elif f == 4:\r\n                            cp(xXx,\'red\')\r\n                        elif f == 5:\r\n                            cp(xXx,\'darkcyan\')\r\n                        elif f == 6:\r\n                            cp(xXx,\'purple\')\r\n                        elif f == 7:\r\n                            cp(xXx,\'white\')\r\n                        else:\r\n                            print_(xXx)\r\n\r\n\r\n\r\n\r\n                yield path\r\n    else:\r\n        if isinstance(indict, list) or isinstance(indict, tuple):\r\n            for v in indict:\r\n                for d in dict_generator(v, pre + [\'i\'],fields):\r\n                    yield d\r\n\r\n        # yield pre \r\n\r\n# index = {}\r\n# for x in _.dict_generator(dic):\r\n#   s = \'.\'.join(x)\r\n#   if not s in index:\r\n#       index[s] = 1\r\n#   else:\r\n#       index[s] += 1\r\n\r\ndef timeblock(epoch=None,hr=None,ish=None, ):\r\n    if epoch is None and hr is None and ish is None:\r\n        hr=5\r\n    elif not ish is None:\r\n        hr = int( isDate(ish)[\'time\'].split(\' \')[1].split(\':\')[0] )\r\n    elif not epoch is None:\r\n        hr = int( friendlyDate2( epoch ).split(\' \')[1].split(\':\')[0] )\r\n    elif not hr is None:\r\n        hr = int(hr)\r\n    t=\'err\'\r\n    if hr > 22:\r\n        t=\'late\'\r\n    elif hr < 4:\r\n        t=\'late\'\r\n    elif hr < 6:\r\n        t=\'wee\'\r\n    elif hr < 8:\r\n        t=\'early\'\r\n    elif hr < 12:\r\n        t=\'morning\'\r\n    elif hr <= 17:\r\n        t=\'afternoon\'\r\n    else:\r\n        t=\'evening\'\r\n    # wee early morning afternoon evening late\r\n    return t\r\n\r\ndef rli(LIST,default=\'\'):\r\n    random = __.imp(\'random\')\r\n    if len(LIST) == 0:\r\n        return default\r\n    if len(LIST) == 1:\r\n        return LIST[0]\r\n    # random_list_item\r\n    return LIST[ random.randint(0,len(LIST)-1) ]\r\n\r\ntb=timeblock\r\n\r\nepoch_times_dic = {\r\n                        "y": 31536000,\r\n                        "m": 2678400,\r\n                        "w": 604800,\r\n                        "d": 86400,\r\n                        "h": 3600,\r\n                        "min": 60\r\n}\r\net=epoch_times_dic\r\ndef epoch_times():\r\n    global epoch_times_dic\r\n    if not epoch_times_dic is None:\r\n        return epoch_times_dic\r\n\r\n    dic={}\r\n    a=isDate(\'2022-03-28\',f=\'epoch\')\r\n    b=isDate(\'2022-03-29\',f=\'epoch\')\r\n    day=int(b-a)\r\n\r\n    a=isDate(\'2022-02-25\',f=\'epoch\')\r\n    b=isDate(\'2023-02-25\',f=\'epoch\')\r\n    dic[\'y\']=int(b-a)\r\n\r\n    a=isDate(\'2022-01-01\',f=\'epoch\')\r\n    b=isDate(\'2022-02-01\',f=\'epoch\')\r\n    dic[\'m\']=int(b-a)\r\n\r\n    dic[\'w\']=day*7\r\n    dic[\'d\']=day\r\n\r\n    a=isDate(\'2022-01-01 21:00:00\',f=\'epoch\')\r\n    b=isDate(\'2022-01-01 22:00:00\',f=\'epoch\')\r\n    dic[\'h\']=int(b-a)\r\n\r\n    a=isDate(\'2022-01-01 21:15:00\',f=\'epoch\')\r\n    b=isDate(\'2022-01-01 21:16:00\',f=\'epoch\')\r\n    dic[\'min\']=int(b-a)\r\n\r\n\r\n    return dic\r\n\r\n# timeCalc\r\n\r\ndef newid(subject):\r\n    requests = __.imp(\'requests\')\r\n    url=\'https://eyeformeta.com/apps/ids/?subject=live-\'+subject\r\n    page = requests.get(url).content.decode("utf-8").replace(\'\\\\n\',\'\\n\').replace(\'\\n\',\'\').replace(\'\\r\',\'\').replace(\' \',\'\').replace(\'\\t\',\'\')\r\n    return page\r\n    \r\naib=aiBullet\r\nail=aiLine\r\nbu=aiBullet\r\nbull=aiBullet\r\nlbu=aiLine\r\n\r\nnw=n2w\r\n\r\n## UUID ##\r\n\r\n\r\n# print_( 1,2,3,4, c=\'yellow\' ); sys.exit();\r\npr=print_\r\nprt=printt\r\npt=printt\r\n_fileBackup=None\r\ndef bk(path,flag=None):\r\n    global _fileBackup\r\n    if _fileBackup is None: _fileBackup = regImp( __.appReg, \'fileBackup\' );\r\n    _fileBackup.switch( \'Silent\' )\r\n    _fileBackup.switch( \'Input\', path )\r\n    if type(flag) == str: _fileBackup.switch( \'Flag\', flag );\r\n    return _fileBackup.do( \'action\' )\r\n\r\ndef life(subject):\r\n    return _v.life+subject.replace(\'/\',os.sep)\r\n\r\n\r\n\r\n\r\n\r\ndef ico():\r\n    random=__.imp(\'random\')\r\n    ads=fo(_v.life+\'ads\')\r\n    ri = random.randrange(len(ads))\r\n    cho=ads[ri]\r\n    ic=list(\'\xf0\x9f\xa7\xbb\xf0\x9f\xa7\xaa\xf0\x9f\x92\x80\xf0\x9f\xa6\x86\xf0\x9f\xa6\x89\xf0\x9f\xa5\x93\xf0\x9f\xa6\x84\xf0\x9f\xa6\x80\xf0\x9f\x96\x95\xf0\x9f\x8d\xa3\xf0\x9f\x8d\xa4\xf0\x9f\x8d\xa5\xf0\x9f\x8d\xa1\xf0\x9f\xa5\x83\xf0\x9f\xa5\x9e\xf0\x9f\x90\x95\xf0\x9f\x91\xbe\xf0\x9f\x90\x89\xf0\x9f\x90\x93\xf0\x9f\x90\x8b\xf0\x9f\x90\x8c\xf0\x9f\x90\xa2\xf0\x9f\x91\xbd\xf0\x9f\x91\xbf\xf0\x9f\xa5\x91\xf0\x9f\x90\xa1\xf0\x9f\x90\x97\xf0\x9f\x92\x90\xf0\x9f\x8f\xb9\xf0\x9f\x8e\xa8\xf0\x9f\x90\x94\xf0\x9f\x90\x9b\xf0\x9f\x8e\xaf\xf0\x9f\x8c\xaf\xf0\x9f\x93\xb7\xf0\x9f\x9b\xb6\xf0\x9f\xa5\x95\xf0\x9f\x8d\xb8\xf0\x9f\x8d\xb3\xf0\x9f\x90\xb2\xf0\x9f\x8e\xa3\xf0\x9f\x90\x9f\xf0\x9f\xa6\x85\xf0\x9f\x91\x80\xf0\x9f\x90\xb8\xf0\x9f\xa4\x9e\xf0\x9f\x92\xaa\xf0\x9f\x92\xbe\xf0\x9f\x91\xbb\xf0\x9f\x90\x8a\xf0\x9f\x8d\x94\xf0\x9f\x8c\xad\xf0\x9f\x8d\x80\xf0\x9f\x95\x93\xf0\x9f\xa6\x8a\xf0\x9f\x8d\x9f\xf0\x9f\xa5\x9d\xf0\x9f\x90\x92\xf0\x9f\xa5\x9e\xf0\x9f\x90\xbc\xf0\x9f\x93\x8e\xf0\x9f\x90\xa7\xf0\x9f\x92\xa9\xf0\x9f\x8d\x95\xf0\x9f\x8d\x8d\xf0\x9f\xa6\x8f\xf0\x9f\x8d\x97\xf0\x9f\x8c\x88\xf0\x9f\x90\xb3\xf0\x9f\xa6\x91\xf0\x9f\x9a\x80\xf0\x9f\x99\x88\xf0\x9f\x99\x8a\xf0\x9f\x99\x89\xf0\x9f\x8c\xae\xf0\x9f\x90\x85\xf0\x9f\x90\xaf\xf0\x9f\x8d\x89\xf0\x9f\x9a\xbd\xf0\x9f\x8d\x85\xf0\x9f\x91\x85\xf0\x9f\x8e\xa9\xf0\x9f\x8d\xb7\')\r\n    for x in ic:\r\n        print(x)\r\n\r\nnsfw=True\r\n\r\nl=dot()\r\nl.v=dot()\r\nl.sw=dot()\r\n\r\n\r\ndef l_fieldSet( switchName, switchField, switchValue, theFocus=False ):\r\n    global switches\r\n    switches.fieldSet( switchName, switchField, switchValue, theFocus )\r\ndef l_registerSwitches_vars():\r\n    autoBackupData = __.setting(\'receipt-log\')\r\n    __.releaseAcquiredData = __.setting(\'receipt-file\')\r\n    __.myFileLocations_SKIP_VALIDATION = __.setting(\'myFileLocations-skip-validation\')\r\n    __.isRequired_Pipe = __.setting(\'require-pipe\')\r\n    __.isRequired_Pipe_or_File = __.setting(\'require-pipe||file\')\r\n    __.pre_error = __.setting(\'pre-error\')\r\n    __.switch_raw = __.setting(\'switch-raw\')\r\n    __.isRequired_or_List = __.setting(\'require-list\')\r\ndef l_registerSwitches( trig=None, sw=None ):\r\n    global appInfo\r\n    global argvProcess\r\n    global myFileLocation_Print\r\n    global autoBackupData\r\n    l_registerSwitches_vars()\r\n    # appInfo=l.conf(\'info\')\r\n\r\n\r\n\r\n    if not l.conf(\'__name__\') == \'__main__\':\r\n        argvProcess = False\r\n    else:\r\n        argvProcess = True\r\n\r\n    if not __.appReg == l.conf(\'appDBA\') and l.conf(\'appDBA\') in __.appReg:\r\n\r\n\r\n\r\n        load()\r\n        appInfo[__.appReg] = appInfo[l.conf(\'appDBA\')]\r\n        appData[__.appReg] = appData[l.conf(\'appDBA\')]\r\n    __.constructRegistration( appInfo[__.appReg][\'file\'],__.appReg )\r\n    if not sw is None: sw();\r\n    if not trig is None: trig();\r\n    \r\n    defaultScriptTriggers()\r\n    switches.process()\r\n\r\n    if l.conf(\'__name__\') == \'__main__\':\r\n        if not sys.stdin.isatty():\r\n            setPipeData( sys.stdin.readlines(), __.appReg, clean=l.conf(\'clean-pipe\' ,d=True) )\r\n    postLoad( l.conf(\'__file__\') )\r\n    myFileLocation_Print=l.conf(\'myFileLocation_Print\',d=False)\r\n    appInfo[__.appReg][\'file\']=appInfo[__.appReg][\'liveAppName\']\r\nl.v.cnf=dot()\r\nl.v.cnf.placeholder=\'3586006adfdc\'\r\nl.v.cnf.default=None\r\nl.v.cnf.data={}\r\ndef l_settings(subject,value=l.v.cnf.placeholder,default=l.v.cnf.default,v=None,d=None):\r\n    if not d is None: default=d;\r\n    if not v is None: value=v;\r\n\r\n    if not value == l.v.cnf.placeholder:\r\n        l.v.cnf.data[subject]=value\r\n\r\n    if subject in l.v.cnf.data: return l.v.cnf.data[subject];\r\n    else: return default;\r\n\r\nl.fieldSet=l_fieldSet\r\nl.sw.register=l_registerSwitches\r\nl.cnf=l_settings\r\nl.conf=l_settings\r\nl.config=l_settings\r\nl.fig=l_settings\r\nl.setting=l_settings\r\n\r\ndef l_vars(fcs,n,f,d):\r\n    __.registeredApps.append( fcs )\r\n    l.conf(\'__name__\',n)\r\n    l.conf(\'__file__\',f)\r\n    l.conf(\'appDBA\',d)\r\n    return l.fieldSet\r\nl.vars=l_vars\r\noc=vindex\r\n\r\n\r\ndef dots(path):\r\n    def _dots_(pth):\r\n        try: exec(pth); return True;\r\n        except Exception as e: return False;\r\n    rts=path.split(\'.\'); exec(\'global \'+rts[0]);\r\n    if _dots_(path): return eval(rts[0])\r\n    pre=[]; thp=[];\r\n    for i,seg in enumerate(rts):\r\n        pre=thp.copy(); thp.append(seg); npre=\'.\'.join(pre); npath=\'.\'.join(thp)\r\n        if i == len(rts)-1:\r\n            exec(\'from 1 import 2\'.replace(\'1\',npre).replace(\'2\',rts[-1]))\r\n            f=\'3=2\'.replace(\'1\',npre).replace(\'2\',rts[-1]).replace(\'3\',path)\r\n        else: f=\'1=dot()\'.replace(\'1\',npath);\r\n\r\n        if not _dots_(npath):\r\n            exec(f)\r\n            if i == len(rts)-1: return eval(rts[0]);\r\nnsfw_=False\r\ndef ad():\r\n    # print(_v.life+\'ads\')\r\n    # sys.exit()\r\n    if not os.path.isdir(_v.life+\'ads\'): return None\r\n    global nsfw; global nsfw_;\r\n    if not nsfw_:\r\n        try:\r\n            if \'1\' in URL(\'https://eyeformeta.com/apps/terminal/switches/nsfw\'): nsfw=True;\r\n            else: nsfw=False;1\r\n        except Exception as ee: nsfw=False;\r\n    nsfw_=True\r\n    random=__.imp(\'random\')\r\n    ads=fo(_v.life+\'ads\')\r\n    if nsfw:\r\n        for a2 in fo(_v.life+\'ads.nsfw\'): ads.append(a2);\r\n    ri = random.randrange(len(ads))\r\n    cho=ads[ri]\r\n    ad=getText( cho , raw=True )\r\n    ad=ad.replace(\'\\r\',\'\')\r\n    def _cl(ad):\r\n        ad=_str.do(\'be\',ad,\'\\n\')\r\n        ad=_str.do(\'be\',ad,\' \')\r\n        ad=_str.do(\'be\',ad,\'\\t\')\r\n        return ad\r\n    ad=_cl(ad); ad=_cl(ad); ad=_cl(ad); ad=_cl(ad);\r\n    ad=_cl(ad); ad=_cl(ad); ad=_cl(ad); ad=_cl(ad);\r\n    sub=__.path(cho,file=True)\r\n    # cp( \'<ad>\', \'yellow\' )\r\n    linePrint(c=\'green\',center=\'ad\', length=41)\r\n    cp( sub, \'yellow\' )\r\n    linePrint(\'20\',c=\'yellow\')\r\n    for liner in ad.split(\'\\n\'):\r\n        pr(\'> \'+liner)\r\n    linePrint(c=\'green\',center=\'ad\', length=41)\r\n    # cp( \'</ad>\', \'yellow\' )\r\n    return ad\r\nads=ad\r\n\r\ndef URL(url):\r\n    requests=dots(\'requests.get\')\r\n    return requests.get(url).content.decode("utf-8").replace(\'\\\\n\',\'\\n\')\r\n\r\n\r\ndef getConfig(path):\r\n    def _cl_(string): return _str.do(\'be\',   _str.do(\'be\',string,\'\\n\')   ,\' \');\r\n    def _val_(string):\r\n        if string.startswith(\'"\'): string=string[1:]; string=string[:-1]; return _cl_(string);\r\n        if string.startswith("\'"): string=string[1:]; string=string[:-1]; return _cl_(string);\r\n        if string.startswith(\'[\') or string.startswith(\'{\'):\r\n            simplejson = __.imp(\'simplejson\')\r\n            return simplejson.loads(string)\r\n        if string.lower() == \'none\': return None;\r\n        if string.lower() == \'null\': return None;\r\n        if string.lower() == \'true\': return True;\r\n        elif string.lower() == \'false\': return False;\r\n        else:\r\n            has=[]\r\n            if \'-\' in string and not string.startswith(\'-\'): return _cl_(string);\r\n            for s in string:\r\n                if s in \'01234567890-\' and not \'n\' in has: has.append(\'n\');\r\n                if s in \'.\' and not \'f\' in has: has.append(\'f\');\r\n                if s in \'\\n\\tabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ{}()[]<>\' and not \'a\' in has: return _cl_(string);\r\n            if \'f\' in has and len(has)<3 and len(has)>1: return float(string);\r\n            if \'n\' in has and len(has)==1: return int(string);\r\n        return _cl_(string)\r\n    # print(path)\r\n    data=getText(path)\r\n    dic={}\r\n    for item in data:\r\n        item=_str.do(\'be\',item,\' \')\r\n        item=_str.do(\'be\',item,\'\\n\')\r\n        item=_str.do(\'be\',item,\'\\t\')\r\n        if item and not item.startswith(\'#\'):\r\n            if \'=\' in item:\r\n                a=item[0:item.index(\'=\')]\r\n                b=item[item.index(\'=\')+1:len(item)]\r\n                dic[a]=_val_(b)\r\n    return dic\r\n\r\ndef saveConfig(data,path):\r\n    def _cl_(string): return _str.do(\'be\',   _str.do(\'be\',string,\'\\n\')   ,\' \');\r\n    def _val_(string):\r\n        if type(string) == str and not \'\\n\' in string: return _cl_(string);\r\n        elif type(string) == str and \'\\n\' in string: return _cl_(str({\'d\':string})[7:-2]);\r\n        elif type(string) == int or type(string) == float: return _cl_(str(string));\r\n        elif type(string) == dict or type(string) == list:\r\n            simplejson = __.imp(\'simplejson\')\r\n            return simplejson.dumps(string)\r\n\r\n        return _cl_(str(string))\r\n\r\n    config=[]\r\n    for k in data:\r\n        config.append(  _cl_(k)+\'=\'+_val_(data[k])  )\r\n    saveText(config,path)\r\n    return config\r\n\r\nimp=__.imp\r\ndef HID(sub): requests=imp(\'requests\'); return int(requests.get(\'https://eyeformeta.com/assets/widgets/ids/index.php?subject=\'+sub).content.decode("utf-8").replace(\'\\\\n\',\'\\n\').replace(\'\\n\',\'\'));\r\n\r\ndef cmd(run):\r\n    subprocess=__.imp(\'subprocess.check_output\')\r\n    res = subprocess.check_output(run.split(\' \'))\r\n    return str(res,\'iso-8859-1\')\r\n\r\n# releaseAcquiredData\r\n\r\n')
    __stickytape_write_module('_rightThumb/_vars/__init__.py', b'#!/usr/bin/python3\n\n# ## {R2D2919B742E} ##\n# ###########################################################################\n# What if magic existed?\n# What if a place existed where your every thought and dream come to life.\n# There is only one catch: it has to be written down.\n# Such a place exists, it is called programming.\n#    - Scott Taylor Reph, RightThumb.com\n# ###########################################################################\n# ## {C3P0D40fAe8B} ##\n\nconfig_hash_default = {\n                            \'register.php\': \'http://tools.rightthumb.com/register.php\',\n                            \'ip.php\': \'http://tools.rightthumb.com/ip.php\',\n}\n\nimport _rightThumb._construct as __\nimport _rightThumb._string as _str\nfrom pathlib import Path\nimport os\nimport sys\nimport platform\nimport time\nsimplejson = None\nclass dot:\n    def __init__( self ):\n        pass\nconfig_default = dot()\nconfig_default.cloud = dot()\nconfig_default.cloud.ssh = dot()\nconfig_default.cloud.ssh.password = \'v2SUI1UMn7Q2xF3DJmoJZuB+rgBesCSA\'\nconfig_default_dic = {}\nconfig_default_dic[\'cloud-ssh-pass\'] = config_default.cloud.ssh.password\nconfigFile_data = {}\ndef dics(*arg):\n    dic = {}\n    for table in arg:\n        for k in table:\n            dic[k] = table[k]\n    return dic\n\n\ndef path_fix(path):\n    path=path.replace(\'/\',os.sep).replace(\'\\\\\',os.sep)\n    path=_str.do(\'dup\',path,os.sep)\n    return path\n\ndef configFile( item=None, value=None, p=True ):\n    global simplejson\n    try:\n        global configFile_data\n        if item is None:\n            if p:\n                if not simplejson is None:\n                    import simplejson\n                dataDump = simplejson.dumps(configFile_data, indent=4, sort_keys=False)\n                _.pr(dataDump)\n            return configFile_data\n        if value is None:\n            if item in configFile_data:\n                return configFile_data[item]\n            else:\n                _.pr( \'Error: configFile\', item, \'value not set\' )\n        elif not value is None:\n            configFile_data[item] = value\n            return value\n    except Exception as e:\n        pass\n# import _rightThumb._base3 as _\n# import md5\n# _v.generateFunctionLogFilename( filename )\n# _v.myDatabases\n# _v.bookmarkFormat\n# _v.myTables\n# _v.myAppsJs\n# _v.chromedriver\n# _v.myTemp+slash+\n# base_import\n# import_delim\n# base_versions\n# baseFolderVersions\ndef genUUID(x=False):\n    import uuid\n    string = uuid.uuid4()\n    string = str(string)\n    if x:\n        string = string.upper()\n    else:\n        string = \'{\' + string.upper() + \'}\'\n    if x:\n        try:\n            random\n        except Exception as e:\n            import random\n        string = string.replace(\'-\',\'\')\n        x = []\n        for y in string:\n            ran = random.randint(0,20)\n            if ran % 2 == 0:\n                x.append( y.lower() )\n            else:\n                x.append( y.upper() )\n        string = \'\'.join(x)\n    return string\n# unixID\nfolderID_tech      = \'{A8693D4B-8A80-898F-83F0-E806D2F36800}\'\nfolderID_profile   = \'{6FAB5628-94A1-410A-82D1-1D42A2A11750}\'\nfolderID_host      = \'{C12F266D-71B9-40D2-98B9-424B42D2DBAC}\'\nfolderID_techApps  = \'{D53E69A0-5663-4D19-B0A8-817F0AECBF9C}\'\nfolderID_alt       = \'{BCAE64F2-C911-4F04-AF8C-DFE052E60973}\'\nfolder_alt = \'(profile)Downloads\'\nwindowsSlash = chr(92)\nunixSlash = chr(47)\nslashes = {\n                \'w\': windowsSlash,\n                \n                \'o\': unixSlash,\n                \n                \'u\': unixSlash,\n                \'l\': unixSlash,\n                \n                \'a\': unixSlash,\n                \'m\': unixSlash,\n                \'d\': unixSlash,\n                \n                \'windows\': windowsSlash,\n                \n                \'other\': unixSlash,\n                \'unix\': unixSlash,\n                \'linux\': unixSlash,\n                \n                \'apple\': unixSlash,\n                \'mac\': unixSlash,\n                \'macOS\': unixSlash,\n                \'darwin\': unixSlash,\n}\ns = slashes\nif __.isWin:\n    slash = slashes[\'windows\']\n    dDim = \':\'\nelif not __.isWin:\n    slash = slashes[\'unix\']\n    dDim = \'\'\nimport_delim = \'VX\'\nbase_import = \'import _rightThumb._base\'+import_delim+\' as _\'\nbase_template = \'_base\'+import_delim+\'_init_example.py\'\nbase_file = \'_rightThumb\'+slash+\'_base\'+import_delim+slash+\'__init__.py\'\npy_examples = \'py_base\'+import_delim+\'_examples.json\'\ndef base_versions():\n    data = []\n    data.append(\'\')\n    alpha = \'abcdefghijklmnopqrstuvwxyz\'\n    for x in range(0,10):\n        data.append( str(x) )\n        for y in alpha:\n            data.append( str(x)+y )\n    return data\ndef cmdSetVar( n, v ):\n    os.environ[n.upper()] = v\ndef cmdGetVar( n ):\n    return os.getenv( n.upper() )\n\nif __.isWin:\n    profileTMP = cmdGetVar(\'userprofile\') + slash+\'_AppShareTemp\'\nelif not __.isWin:\n    profileTMP = cmdGetVar(\'HOME\') + slash+\'_AppShareTemp\'\n\nhome = \'\'\nif __.isWin:\n    home = cmdGetVar(\'USERPROFILE\')\nif not __.isWin:\n    try:\n        home = cmdGetVar(\'HOME\')\n    except Exception as e:\n        pass\n    if not home:\n        try:\n            home = str(Path.home())\n        except Exception as e:\n            pass\n    if not home:\n        if not __.isWin:\n            home = \'~\'\n# _.pr( \'home:\',home )\nif __.isWin:\n    computername = os.getenv(\'COMPUTERNAME\')\n    userprofile = os.getenv(\'USERPROFILE\')\nelif not __.isWin:\n    import socket\n    computername = socket.gethostname()\n    userprofile = os.getenv(\'HOME\')\n# user = os.getlogin()\ndownloads = userprofile + slash+\'Downloads\'\ncomputername2 = computername.replace(\' \',\'_\')\n# inputScriptDriveFile = php_drive.txt\ntd = dot() \ntd.a = dot()\ntd.b = dot()\ntd.c = dot()\n\nconfigFile( \'.path\', home  +os.sep+\'.rt\'+os.sep+  \'.path\' )\nconfigFile( \'.config.hash\', home +os.sep+\'.rt\'+os.sep+ \'.config.hash\' )\n\n# _.pr(\'techDrive\',techDrive)\nconfigFile( \'.path\', home  +os.sep+\'.rt\'+os.sep+  \'.path\' )\nconfigFile( \'.config.hash\', home +os.sep+\'.rt\'+os.sep+ \'.config.hash\' )\nif os.path.isfile( configFile(\'.path\') ):\n    techDrive_test = open( configFile(\'.path\')  , \'r\').read().replace(\'\\n\',\'\').replace(\'\\r\',\'\').replace(\'\\t\',\'\')\n    if os.path.isdir(techDrive_test):\n        techDrive = techDrive_test\n    del techDrive_test\nconfig_hash = {}\nif os.path.isfile( configFile(\'.config.hash\') ):\n    config_hash = __.getTable( configFile(\'.config.hash\') )\n    for k in config_hash_default:\n        if not k in config_hash: config_hash[k]=config_hash_default[k];\n    if \'w\' in config_hash:\n        if __.isWin:\n            techDrive = config_hash[\'w\']\n            # techDrive = techDrive.replace(\':\',\'\')\n        if not __.isWin:\n            if os.path.isdir(config_hash[\'w\']):\n                techDrive = config_hash[\'w\']\n    if \'path\' in config_hash:\n        if __.isWin:\n            techDrive = config_hash[\'path\']\n            # techDrive = techDrive.replace(\':\',\'\')\n        if not __.isWin:\n            if os.path.isdir(config_hash[\'path\']):\n                techDrive = config_hash[\'path\']\nme = os.path.abspath(__file__)\nmep = me.split(os.sep)\nmep.reverse()\nmep.pop(0)\nmep.pop(0)\nmep.pop(0)\nmep.pop(0)\nmep.pop(0)\nmep.reverse()\ntechDrive = os.sep.join(mep)\ndel me\ndel mep\nconfig_default.path = techDrive\nconfig_default_dic[\'w\'] = techDrive\nconfig_default_dic[\'widgets\'] = techDrive\nconfig_default_dic[\'tech_drive\'] = techDrive\nconfig_default_dic[\'techDrive\'] = techDrive\nconfig_default_dic[\'path\'] = techDrive\ntry:\n    configFile( \'.host\', techDrive+\'/.host\' )\nexcept Exception as e:\n    pass\ntry:\n    if not __.isWin:\n        if not os.path.isfile(configFile(\'.host\')):\n            open( configFile(\'.host\') ,\'w\', encoding=\'utf-8\').write( computername2 )\nexcept Exception as e:\n    pass\ntechDrive = techDrive.replace(\'\\t\',\'\')\ntechDrive = techDrive.replace(\'\\r\',\'\')\ntechDrive = techDrive.replace(\'\\n\',\'\')\ntechDrive = _str.cleanBE(techDrive,\' \')\nif techDrive.endswith(os.sep):\n    techDrive = techDrive[:-1]\ntechDrive = _str.cleanBE(techDrive,\' \')\ntd.path = techDrive\ndrive=techDrive\n\nif __.isWin:\n    # fileName = home + slash+\'.tk421\'\n    fileName = home + slash+\'.tk421\'\n    # if not os.path.isfile( fileName ):\n    #     open(fileName,\'w\', encoding=\'utf-8\').write(\'C:\\\\.rightthumb-widgets\')\n    # techDrive = open( fileName, \'r\' ).read()\n    # techDrive = techDrive\n    # _.pr(\'techDrive\',techDrive)\n    if \'\\n\' in techDrive or \'\\r\' in techDrive:\n        if os.path.isfile( fileName ):\n            techDrive = techDrive.replace(\'\\n\',\'\').replace(\'\\r\',\'\')\n            techDrive = techDrive.replace(\'\\n\',\'\').replace(\'\\r\',\'\')\n            techDrive = techDrive.replace(\'\\n\',\'\').replace(\'\\r\',\'\')\n            open(fileName,\'w\', encoding=\'utf-8\').write( techDrive )\nw=techDrive\n# elif not __.isWin:\n#     techDrive = \'/opt/RightThumb\'\n#     try:\n#         if not os.path.isdir(techDrive):\n#             os.mkdir(techDrive)\n#     except Exception as e:\n#         if os.path.isdir(\'/home/ximlickficfp/cloud/files\'):\n#             techDrive = \'/home/ximlickficfp/cloud/files\'\n    # fileName = home + slash+\'.tk421\'\n    # fileNameHost = home + slash+\'.ncc1701\'\n    # fileName = fileName.replace( slashes[\'windows\'], slash )\n    # if not os.path.isfile( fileNameHost ):\n    #     open(fileNameHost,\'w\', encoding=\'utf-8\').write(computername)\n    # if not os.path.isfile( fileName ):\n    #     open(fileName,\'w\', encoding=\'utf-8\').write(home)\n    # techDrive = open( fileName, \'r\' ).read()\ndef ddDim(xyz):\n    return xyz\n    global dDim\n    if not dDim:\n        return xyz\n    if not dDim in xyz:\n        return xyz+dDim\ntechFolder =  ddDim(techDrive)\n# _.pr(\'techFolder:\',techFolder)\n# sys.exit()\nappsFolder =  ddDim(techDrive) +slash+\'techApps\'\narchive7z =  ddDim(techDrive) +slash+\'archive_7z_files\'\nwidgets = techFolder\nprograms=widgets\npp = techFolder + slash+\'widgets\'\nw = techFolder \nww = techFolder + slash+\'widgets\'\nappProfiles = widgets+os.sep+\'widgets\'+ slash+\'python\'+slash+\'profiles\'\ncompiled = widgets+os.sep+\'widgets\'+ slash+\'compiled\'\ndocumentation = widgets+os.sep+\'widgets\'+ slash+\'documentation\'\nproject = widgets+os.sep+\'widgets\'+ slash+\'project\'\nupdates = project + slash+\'updates\'\nimages = techFolder + slash+\'widgets\'+slash+\'project\'+slash+\'img\'+slash\n# log_config = techFolder + slash+\'widgets\'+slash+\'project\'+slash+\'log_config\'+slash+\'log_data.js\'\nlog_config = techFolder + slash+\'widgets\'+slash+\'html\'+slash+\'projects\'+slash+\'log_config\'+slash+\'log_data.js\'\n# log_config_html = techFolder + slash+\'widgets\'+slash+\'project\'+slash+\'log_config\'+slash+\'index.htm\'\nlog_config_html = techFolder + slash+\'widgets\'+slash+\'html\'+slash+\'projects\'+slash+\'log_config\'+slash+\'index.htm\'\ndance = images + \'dance.gif\'\ngears = images + \'gears.gif\'\nlife=home +os.sep+\'.rt\'+os.sep+\'profile\'+os.sep+\'life\'+os.sep\n\nif __.isWin:\n    sublime = \'"C:\\\\Program Files\\\\Sublime Text 3\\\\sublime_text.exe"\'\nelif not __.isWin:\n    if os.path.isfile(\'/opt/sublime/sublime_text\'):\n        sublime = \'/opt/sublime/sublime_text\'\n    elif os.path.isfile(\'/usr/bin/sublime_text\'):\n        sublime = \'/usr/bin/sublime_text\'\n    elif os.path.isfile(\'/usr/bin/code-oss\'):\n        sublime = \'/usr/bin/code-oss\'\n# _v.sublime\n# scriptsFolder =  techFolder + slash+\'scripts\'\n# thisHost =  \'hosts\' + slash + computername2\n# myHome =  techFolder + slash+\'hosts\' + slash + computername2\nmyHome =  home+os.sep+\'.rt\'+os.sep+\'profile\'\n# _.pr(\'myHome\',myHome)\nthisHost =  myHome\n# myHome =  home +slash+ \'profile\'\n# thisHost =  myHome\ndataFolder = techFolder + slash+\'data\'\nmyIndexes = myHome + slash+\'indexes\'\nquickIndex = myIndexes + slash+\'0A{465C1A34-D22F-184E-F713-F8E5149E212D}\'\nmyTables = myHome + slash+\'tables\'\nduckDuckGo = myTables + slash+\'DuckDuckGo\'\nrelevant_folders = myTables + slash+\'relevantFolders.txt\'\nmyWebApp = myHome + slash+\'/widgets/servers/web/crud\'\nmyBackup = myHome + slash+\'backup\'\nmyLogs = myHome + slash+\'logs\'\nmyConfig = myHome + slash+\'config\'\nunixID_path = myConfig + slash + \'.unix_id\'\nvault_path = myConfig + slash + \'.vault\'\n\n\n\nconfigFile( \'.ip.hash\', myConfig + slash + \'.ip.hash\' )\nconfigFile( \'.ip\', myConfig + slash + \'.ip\' )\n# unix_editor_path = myConfig + slash + \'.editor\'\nif os.path.isfile( myConfig + os.sep + \'.terminal-copy\' ):\n    terminal_copy = True\nelse:\n    terminal_copy = False\nisTerminal = True\nisGUI = False\ntry:\n    if len( os.getenv(\'HOMEXDG_CURRENT_DESKTOP\') ) > 1:\n        isGUI = True\n        isTerminal = False\nexcept Exception as e:\n    pass\ntry:\n    if len( os.getenv(\'GDMSESSION\') ) > 1:\n        isGUI = True\n        isTerminal = False\nexcept Exception as e:\n    pass\nconfigFile( \'.distro\', myConfig + slash + \'.distro\' )\nconfigFile( \'.alias\', myConfig + slash + \'.alias\' )\n \nhost_alias = computername2\nif os.path.isfile(configFile(\'.alias\')):\n    host_alias = open( configFile(\'.alias\'), \'r\' ).read()\nif host_alias.startswith(\'client_ \'):\n    isClient = True\nelse:\n    isClient = False\nif __.isWin:\n    unix_editor_path = home + slash+\'.tk421_editor\'\nelse:\n    unix_editor_path = techDrive + slash+\'.editor\'\n    unix_editor_path_sufix = techDrive + slash+\'.editor.sufix\'\n    # _.pr(unix_editor_path)\nif not __.isWin:\n    unix_editor_edit = \'\'\n    if os.path.isfile(unix_editor_path_sufix):\n        unix_editor_edit = open( unix_editor_path_sufix, \'r\' ).read()\n    if os.path.isfile(unix_editor_path):\n        unix_editor = open( unix_editor_path, \'r\' ).read()\n    else:\n        find_unix_editor = [\n                \'/snap/bin/subl\',\n                \'/usr/bin/sublime_text\',\n                \'/usr/bin/subl\',\n                \'/opt/sublime/subl\',\n                \'/opt/sublime/sublime_text\',\n                \'/usr/bin/code-oss\',\n                \'/usr/share/code/code\',\n                \'/usr/share/code\',\n                \'/usr/bin/code/code\',\n                \'/usr/bin/code\',\n                "/usr/bin/brackets",\n                \'/usr/bin/bluefish\',\n                \'/usr/bin/notepad++\',\n                "/usr/bin/acme",\n                "/usr/bin/akelpad",\n                "/usr/bin/alphatk",\n                "/usr/bin/arachnophilia",\n                "/usr/bin/bbedit",\n                "/usr/bin/bbedit",\n                "/usr/bin/codewright",\n                "/usr/bin/crimson",\n                "/usr/bin/cudatext",\n                "/usr/bin/cygnused",\n                "/usr/bin/eddie",\n                "/usr/bin/emeditor",\n                "/usr/bin/epsilon",\n                "/usr/bin/featherpad",\n                "/usr/bin/golded",\n                "/usr/bin/html_kit",\n                "/usr/bin/hxd",\n                "/usr/bin/jedit",\n                "/usr/bin/jove",\n                "/usr/bin/juffed",\n                "/usr/bin/kedit",\n                "/usr/bin/kile",\n                "/usr/bin/komodo",\n                "/usr/bin/lapis",\n                "/usr/bin/leafpad",\n                "/usr/bin/leo",\n                "/usr/bin/mcedit",\n                "/usr/bin/metapad",\n                "/usr/bin/microemacs",\n                "/usr/bin/mousepad",\n                "/usr/bin/multi-edit",\n                "/usr/bin/nedit",\n                "/usr/bin/notepad",\n                "/usr/bin/notepad2",\n                "/usr/bin/notetab",\n                "/usr/bin/pe",\n                "/usr/bin/pluma",\n                "/usr/bin/polyedit",\n                "/usr/bin/pfe",\n                "/usr/bin/pspad",\n                "/usr/bin/q10",\n                "/usr/bin/rj",\n                "/usr/bin/sam",\n                "/usr/bin/scite",\n                "/usr/bin/simpletext",\n                "/usr/bin/slickedit",\n                "/usr/bin/smultron",\n                "/usr/bin/subethaedit",\n                "/usr/bin/hydra",\n                "/usr/bin/teachtext",\n                "/usr/bin/ted",\n                "/usr/bin/tex-edit",\n                "/usr/bin/textpad",\n                "/usr/bin/wildedit",\n                "/usr/bin/texniccenter",\n                "/usr/bin/texshop",\n                "/usr/bin/textedit",\n                "/usr/bin/textmate",\n                "/usr/bin/textwrangler",\n                "/usr/bin/topstyle",\n                "/usr/bin/ultraedit",\n                "/usr/bin/ulysses",\n                "/usr/bin/vedit",\n                "/usr/bin/winedt",\n                "/usr/bin/x11",\n                "/usr/bin/xedit",\n                "/usr/bin/yudit",\n                \'/usr/bin/vscode\',\n                \'/usr/bin/lighttable\',\n                \'/usr/bin/gedit\',\n                \'/usr/bin/kakoune\',\n                \'/usr/bin/brackets \',\n                \n                \'/usr/bin/limetext \',\n                \'/usr/bin/leafpad \',\n                \n                \'/usr/bin/atom\',\n                \'/usr/bin/pico\',\n                \'/usr/bin/nano\',\n                \'/usr/bin/kwrite\',\n                \'/usr/bin/kate\',\n                \'/usr/bin/geany\',\n                \'/usr/bin/medit\',\n                \'/usr/bin/neovim\',\n                \'/usr/bin/jed\',\n                \'/usr/bin/micro\',\n                \'/usr/bin/gvim\',\n                \'/usr/bin/vim\',\n                \'/usr/bin/vi\'\n        ]\n        try:\n            for tep in find_unix_editor:\n                if os.path.isfile(tep):\n                    unix_editor = tep\n                    open(unix_editor_path,\'w\', encoding=\'utf-8\').write( tep )\n                    break\n        except Exception as e:\n            pass\nunixID = None\nunixIDs = []\nunixID_NEW = False\ndef gen_unixIDs():\n    global unixID\n    global unixIDs\n    global unixID_NEW\n    if os.path.isfile(unixID_path):\n        try:\n            f = open(unixID_path, \'r\', encoding=\'utf-8\')\n            unixIDs = []\n            for x in f.readlines():\n                unixIDs.append(x.replace(\'\\n\',\'\'))\n            unixID = unixIDs[0]\n            f.close()\n        except Exception as e:\n            pass\n    else:\n        unixID = genUUID(x=True)\n        unixIDs = unixID+\'\\n\'+genUUID(x=True)+\'\\n\'+genUUID(x=True)+\'\\n\'+genUUID(x=True)+\'\\n\'+genUUID(x=True)+\'\\n\'+genUUID(x=True)+\'\\n\'+genUUID(x=True)+\'\\n\'+genUUID(x=True)+\'\\n\'+genUUID(x=True)+\'\\n\'+genUUID(x=True)\n        unixID_NEW = True\n    return unixIDs\ngen_unixIDs()\nif not \'/bash/\' in __file__:\n    try:\n        if \'-\' in unixIDs[8]:\n            os.unlink(unixID_path)\n            if os.path.isfile(vault_path):\n                os.unlink(vault_path)\n            gen_unixIDs()\n    except Exception as e:\n        if os.path.isfile(unixID_path):\n            os.unlink(unixID_path)\n        if os.path.isfile(vault_path):\n            os.unlink(vault_path)\n        gen_unixIDs()\nresearch = techFolder + slash+\'widgets\'+slash+\'databank\'\nmyDatabank = research\nkeys = techFolder + slash+\'widgets\'+slash+\'keys\'\ndata = research\ndatabank = research\npython = {\n            \'crypt\': {\n                        \'en\': widgets+os.sep+\'widgets\'+ slash+\'python\'+slash+\'crypt\'+slash+\'en\',\n                        \'de\': widgets+os.sep+\'widgets\'+ slash+\'python\'+slash+\'crypt\'+slash+\'de\',\n            },\n            \'imploded\': {\n                        \'windows\': widgets+os.sep+\'widgets\'+ slash+\'python\'+slash+\'imploded\'+slash+\'unity\',\n                        \'unix\': widgets+os.sep+\'widgets\'+ slash+\'python\'+slash+\'imploded\'+slash+\'unity\',\n                        \'this\': None,\n            },\n            \'src\': {\n                        \'windows\': widgets+os.sep+\'widgets\'+ slash+\'python\'+slash+\'src\'+slash+\'unity\',\n                        \'unix\': widgets+os.sep+\'widgets\'+ slash+\'python\'+slash+\'src\'+slash+\'unity\',\n                        \'this\': None,\n            },\n            \'compiled\': {\n                        \'windows\': widgets+os.sep+\'widgets\'+ slash+\'python\'+slash+\'compiled\'+slash+\'unity\',\n                        \'unix\': widgets+os.sep+\'widgets\'+ slash+\'python\'+slash+\'compiled\'+slash+\'unity\',\n                        \'this\': None,\n            },\n            \'burn\': {\n                        \'windows\': widgets+os.sep+\'widgets\'+ slash+\'python\'+slash+\'burn\'+slash+\'unity\',\n                        \'unix\': widgets+os.sep+\'widgets\'+ slash+\'python\'+slash+\'burn\'+slash+\'unity\',\n                        \'this\': None,\n            },\n}\n\npy = widgets+os.sep+\'widgets\'+ slash+\'python\'\n\n  \nfolder_alt = folder_alt.replace( \'(profile)\', userprofile + slash )\nUNC = { \'en\': {}, \'de\': {} }\nUNC[\'de\'][folderID_techApps] = appsFolder\nUNC[\'de\'][folderID_host] = myHome\nUNC[\'de\'][folderID_tech] = techFolder\nUNC[\'de\'][folderID_profile] = userprofile\nUNC[\'de\'][folderID_alt] = folder_alt\nUNC[\'en\'][appsFolder] = folderID_techApps\nUNC[\'en\'][myHome] = folderID_host\nUNC[\'en\'][techFolder] = folderID_tech\nUNC[\'en\'][userprofile] = folderID_profile\nUNC[\'en\'][folder_alt] = folderID_alt\nUNC[\'en\'][\'alt\'] = folderID_alt\ndbTables = databank + slash+\'tables\'\ntablesDB = dbTables\ndatabases = databank + slash+\'databases\'\ndb = databank \ndbs = databank + slash+\'databases\'\ndbdbs = databank + slash+\'databases\'\nmyBatch = myHome + slash+\'widgets\'+slash+\'batch\'\nmyTXT = myBackup + slash+\'txt\'\nmyBIN = myBackup + slash+\'bin\'\nwebapp = techFolder +os.sep+ os.sep.join( \'widgets/servers/web/crud\'.split(\'/\') )\n\nlibrary = techFolder + slash+\'widgets\'+slash+\'library\'\nmyDatabases = myHome + slash+\'databases\'\nmyVars = myHome + slash+\'vars\'\nmyNotes = myHome + slash+\'notes\'\numlJson = myHome + slash+\'json-uml-tree\'+slash+\'data.js\'\numlHtml = myHome + slash+\'json-uml-tree\'+slash+\'index.htm\'\nandroidMaster = \'android_apps_master.json\'\nandroidMasterFull = myTables + slash + androidMaster\nmyApps = techFolder + slash+\'widgets\'\nipsum = myApps + slash+\'project\'+slash+\'ipsum.txt\'\nmyAppsJs = myApps + slash+\'javascript\'\nmyAppsBatch = myApps + slash+\'batch\'\n# chromedriver = myApps + slash+\'exe\'+slash+\'ChromeDriver\'+slash+\'2.46\'+slash+\'chromedriver.exe\'\n# chromedriver = myApps + slash+\'exe\'+slash+\'ChromeDriver\'+slash+\'73.0.3683.68\'+slash+\'chromedriver.exe\'\n# chromedriver = myApps + slash+\'exe\'+slash+\'ChromeDriver\'+slash+\'74.0.3729.6\'+slash+\'chromedriver.exe\'\n# chromedriver = myApps + slash+\'exe\'+slash+\'ChromeDriver\'+slash+\'75.0.3770.90\'+slash+\'chromedriver.exe\'\n# chromedriver = myApps + slash+\'exe\'+slash+\'ChromeDriver\'+slash+\'76.0.3809.25\'+slash+\'chromedriver.exe\'\nif __.isWin:\n    chromedriver = myApps + slash+\'exe\'+slash+\'ChromeDriver\'+slash+\'80.0.3987.16\'+slash+\'chromedriver.exe\'\n    geckodriver = myApps + slash+\'exe\'+slash+\'gecko\'+slash+\'0.24.0\'+slash+\'geckodriver.exe\'\n    chromePortable = appsFolder + slash+\'chrome-win\'+slash+\'chrome.exe\'\nelif platform.system() == \'Linux\':\n    chromedriver = myApps + slash+\'exe\'+slash+\'ChromeDriver\'+slash+\'linux\'+slash+\'chromedriver\'\n    chromePortable = chromedriver\nelif platform.system() == \'Darwin\':\n    chromedriver = myApps + slash+\'exe\'+slash+\'ChromeDriver\'+slash+\'darwin\'+slash+\'chromedriver\'\n    chromePortable = chromedriver\nstmp = myHome + slash+\'temp\'\nrtstmp = home +slash+\'.rt\'+slash+ \'profile\'+slash+\'temp\'\n\nexif_temp = stmp + slash+\'exif\'\njson_temp = stmp + slash+\'_temp.json\'\ntxt_temp = stmp + slash+\'_temp.txt\'\ntext_temp = stmp + slash+\'_temp.txt\'\nhtml_temp = stmp + slash+\'_temp.htm\'\n# D:\\tech\\hosts\\MSI\\temp\\_temp.htm\npips = stmp + slash+\'pips.txt\'\ntmpbat = stmp + slash+\'44E28BDF-8269-EEAE-D1DC-9B05B63E5F93.bat\'\ntmpf = stmp + slash+\'{8E3F33E4-86AB-AB1E-6219-801DE111D9AF}\'\ntmpf0 = stmp + slash+\'{B820137A-79B8-45E3-BCBD-A6CAC50892D0}\'\ntmpf1 = stmp + slash+\'{C0FA8E56-8426-46BB-9CE8-4A14C51EA261}\'\ntmpf2 = stmp + slash+\'{5FBF34C0-9A95-4C7E-BA53-44F84ECECCB5}\'\ntmpf3 = stmp + slash+\'{F139D191-FA1A-44D5-855C-7E5141B30E0D}\'\ntmpf4 = stmp + slash+\'{AA8EC8E1-EA9D-460D-A593-7B0FAEB9243E}\'\ntmpf5 = stmp + slash+\'{201D82D6-2DC0-4552-A598-54F5481399A1}\'\ntmpf6 = stmp + slash+\'{26B3B9C6-0A59-432A-9386-D432B53001CB}\'\ntmpf7 = stmp + slash+\'{C03C0132-CFFC-4E3A-8F0F-614BB95164C7}\'\ntmpf8 = stmp + slash+\'{4CCA3EBD-4535-42B7-9C75-05EFAACB00E0}\'\ntmpf9 = stmp + slash+\'{DF1D4EBC-838E-419C-9C58-943C1767391A}\'\ncontextTemp = stmp + slash+\'{21E8D046-A855-EE9B-B772-9EECBD922D87}\'\nmyTemp = stmp\ntempFile = tmpf\n# indexFolder = indexRoot + slash + computername + slash+\'index\'+slash\nmyBookmarks = myHome + slash+\'bookmarks\'\nbookmarkFormat = myBookmarks + slash+\'BM-ALIASHERE.txt\'\nmyTickets = myHome + slash+\'tickets\'\n# bookmarksFolder = techFolder + slash+\'scripts\'+slash+\'script-bookmarks\'+slash+\'MSI\'+slash\nfileBackupLogData = []\nprintable = \'0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!"#$%&\\\'()*+,-./:;<=>?@[\'+slash+\']^_`{|}~ \\t\\n\\r\\x0b\\x0c\'\nsafeChar = printable\ncryptoKeyPad = \'{D0A25D57-37B9-4DCA-A290-F7F5D2B4E869-ED89EEC8-FC42-4E36-B57A-BD2756F58071-1358EA50-2BED-4533-99C7-4D90BB450D7F-40A9A7E8-6AF5-4C32-9062-F975CDF12209}\'\nmyLogs = myHome + slash+\'logs\'\nmyAppLogs = myHome + slash+\'logs\'+slash+\'apps\'\ndef cloud_path( path ):\n    global techDrive\n    global slash\n    global techFolder\n    global slashes\n    paths = []\n    if not __.isWin:\n        x = os.getenv(\'HOME\') + slash + \'tech\' + slash\n        paths.append(x)\n    x = techFolder+slash\n    if not x in paths:\n        paths.append(x)\n    x = \'D:\\\\tech\\\\\'\n    if not x in paths:\n        paths.append(x)\n    x = techDrive\n    if not x in paths:\n        paths.append(x)\n    found = False\n    newPath = path\n    for test in paths:\n        if test.lower() in path.lower():\n            found = True\n            if not test in path:\n                for subject in _.caseUnspecific( path, test ):\n                    newPath = newPath.replace( subject, \'\' )\n            else:\n                newPath = newPath.replace( test, \'\' )\n    if found:\n        if __.isWin:\n            newPath = newPath.replace(  slashes[\'w\'], slashes[\'u\']  )\n        newPath = \'/\'+newPath\n        newPath = newPath.replace( \'//\', \'/\' )\n        newPath = newPath.replace( \'//\', \'/\' )\n        newPath = newPath.replace( \'//\', \'/\' )\n        _.pr(newPath)\n        return newPath\n    _.pr(path)\n    return path\ndef projectData( project ):\n    global slash\n    global databank\n    pf = slash.join(  project.split(\'.\')  )\n    p = databank+slash+\'projects\'+slash+pf+slash\n    dir_check_create(p)\n    return p\ndef session():\n    return os.getenv(\'Session_ID\')\ndef autoUNC( path, alt=False, o=None, crypt=None ):\n    global windowsSlash\n    global unixSlash\n    global slash\n    global UNC\n    found = False\n    if crypt is None:\n        for key in UNC[\'de\'].keys():\n            if key in path:\n                found = True\n                path = path.replace( key, UNC[\'de\'][key] )\n        if not found:\n            for key in UNC[\'en\'].keys():\n                if key in path:\n                    found = True\n                    path = path.replace( key, UNC[\'en\'][key] )\n        if not found and alt:\n            if \':\' in path:\n                path = UNC[\'en\'][\'alt\'] + path.split(\':\')[1]\n    \n    elif not crypt is None:\n        if \'en\' in crypt:\n            if not found:\n                for key in UNC[\'en\'].keys():\n                    if key in path:\n                        found = True\n                        path = path.replace( key, UNC[\'en\'][key] )\n            if not found and alt:\n                if \':\' in path:\n                    path = UNC[\'en\'][\'alt\'] + path.split(\':\')[1]\n        elif \'de\' in crypt:\n            for key in UNC[\'de\'].keys():\n                if key in path:\n                    found = True\n                    path = path.replace( key, UNC[\'de\'][key] )\n    if not o is None:\n        if \'w\' in o.lower():\n            path = path.replace( unixSlash, windowsSlash )\n        else:\n            path = path.replace( windowsSlash, unixSlash )\n    return path\ndef theUSB():\n    pass\ndef create_default_profile():\n    pass\n\ndef popFile( path ):\n    global slash\n    parts = path.split( slash )\n    parts.reverse()\n    parts.pop(0)\n    parts.reverse()\n    folder = slash.join(parts)\n    return folder\ndef popFileDir( path ):\n    try: dir_check_create(popFile(path));\n    except Exception as e: return False;\n    return True\n    \ndef dir_structure():\n    global slash\n    global appProfiles\n    global compiled\n    global databank\n    global databases\n    global dbTables\n    global documentation\n    global duckDuckGo\n    global library\n    global myAppLogs\n    global myBackup\n    global myBIN\n    global myBookmarks\n    global myConfig\n    global myDatabank\n    global myDatabases\n    global myIndexes\n    global myLogs\n    global myNotes\n    global myTables\n    global myTickets\n    global myTXT\n    global myVars\n    global myWebApp\n    global profileTMP\n    global widgets\n    global project\n    # global python\n    global stmp\n    global techDrive\n    global thisHost\n    global umlHtml\n    global umlJson\n    global updates\n    global myHome\n    global py\n    dir_check_create( py )\n    home_created = dir_check_create( myHome )\n    dir_check_create( myIndexes )\n    dir_check_create( myTables )\n    dir_check_create( myWebApp )\n    dir_check_create( myBackup )\n    dir_check_create( myDatabases )\n    dir_check_create( myVars )\n    dir_check_create( myNotes )\n    dir_check_create( myLogs )\n    dir_check_create( myConfig )\n    dir_check_create( myDatabank )\n    \n    dir_check_create( umlJson )\n    dir_check_create( umlHtml )\n    dir_check_create( stmp )\n    dir_check_create( myBookmarks )\n    dir_check_create( myTickets )\n    dir_check_create( myLogs )\n    dir_check_create( myAppLogs )\n    dir_check_create( myTXT )\n    dir_check_create( myBIN )\n    dir_check_create( profileTMP )\n    \n    dir_check_create( duckDuckGo )\n    dir_check_create( library )\n    dir_check_create( databank )\n    dir_check_create( databank+slash+\'indexes\' )\n    dir_check_create( databank+slash+\'indexes\'+slash+\'queries\' )\n    dir_check_create( databank+slash+\'indexes\'+slash+\'databases\' )\n    dir_check_create( databank+slash+\'indexes\'+slash+\'tag_stems\' )\n    dir_check_create( databank+slash+\'vault\' )\n    dir_check_create( databank+slash+\'profiles\' )\n    dir_check_create( databank+slash+\'profiles\'+slash+\'folders\' )\n    dir_check_create( databank+slash+\'db\' )\n    dir_check_create( databank+slash+\'temp\' )\n    dir_check_create( databank+slash+\'projects\' )\n    # dir_check_create( databank+slash+\'query_cache\' )\n    dir_check_create( widgets )\n    dir_check_create( documentation )\n    dir_check_create( project )\n    dir_check_create( updates )\n    dir_check_create( appProfiles )\n    dir_check_create( compiled )\n    # dir_check_create( thisHost + slash+\'{}\' )\n    dir_check_create( thisHost+slash+\'config\' )\n    dir_check_create( thisHost+slash+\'WebApp\' )\n    dir_check_create( thisHost+slash+\'archive\' )\n    dir_check_create( thisHost+slash+\'backup\' )\n    dir_check_create( thisHost+slash+\'bookmarks\' )\n    dir_check_create( thisHost+slash+\'databases\' )\n    dir_check_create( thisHost+slash+\'indexes\' )\n    # dir_check_create( thisHost+slash+\'info\' )\n    dir_check_create( thisHost+slash+\'logs\' )\n    dir_check_create( thisHost+slash+\'notes\' )\n    # dir_check_create( thisHost+slash+\'playground\' )\n    dir_check_create( thisHost+slash+\'widgets\' )\n    dir_check_create( thisHost+slash+\'projects\' )\n    # dir_check_create( thisHost+slash+\'scripts\' )\n    dir_check_create( thisHost+slash+\'tables\' )\n    dir_check_create( thisHost+slash+\'temp\' )\n    dir_check_create( thisHost+slash+\'tickets\' )\n    dir_check_create( thisHost+slash+\'txt\' )\n    dir_check_create( thisHost+slash+\'json-uml-tree\' )\n    dir_check_create( thisHost+slash+\'vars\' )\n    dir_check_create( thisHost+slash+\'tables\'+slash+\'imdb\' )\n    dir_check_create( thisHost+slash+\'tables\'+slash+\'txt\' )\n    dir_check_create( thisHost+slash+\'tables\'+slash+\'applogs\' )\n    # dir_check_create( widgets+os.sep+\'widgets\'+slash+\'{}\' )\n    # type %tmpf1% | p line --c -make "dir_check_create( widgets+os.sep+\'widgets\'+slash+\'{}\' )"\n    dir_check_create( widgets+os.sep+\'widgets\'+slash+\'batch\' )\n    dir_check_create( widgets+os.sep+\'widgets\'+slash+\'c++\' )\n    # dir_check_create( widgets+os.sep+\'widgets\'+slash+\'compiled\' )\n    # dir_check_create( widgets+os.sep+\'widgets\'+slash+\'data\' )\n    dir_check_create( widgets+os.sep+\'widgets\'+slash+\'databank\' )\n    dir_check_create( widgets+os.sep+\'widgets\'+slash+\'documentation\' )\n    # dir_check_create( widgets+os.sep+\'widgets\'+slash+\'exe\' )\n    # dir_check_create( widgets+os.sep+\'widgets\'+slash+\'extensions\' )\n    # dir_check_create( widgets+os.sep+\'widgets\'+slash+\'hack\' )\n    # dir_check_create( widgets+os.sep+\'widgets\'+slash+\'html\' )\n    # dir_check_create( widgets+os.sep+\'widgets\'+slash+\'javascript\' )\n    dir_check_create( widgets+os.sep+\'widgets\'+slash+\'keys\' )\n    dir_check_create( widgets+os.sep+\'widgets\'+slash+\'php\' )\n    dir_check_create( widgets+os.sep+\'widgets\'+slash+\'powershell\' )\n    dir_check_create( widgets+os.sep+\'widgets\'+slash+\'project\' )\n    dir_check_create( widgets+os.sep+\'widgets\'+slash+\'python\' )\n    # dir_check_create( widgets+os.sep+\'widgets\'+slash+\'vbs\' )\n    # dir_check_create( widgets+os.sep+\'widgets\'+slash+\'webApp\' )\n    # dir_check_create( widgets+os.sep+\'widgets\'+slash+\'java\' )\n    # dir_check_create( widgets+os.sep+\'widgets\'+slash+\'git\' )\n    dir_check_create( widgets+os.sep+\'widgets\'+slash+\'cron\' )\n    dir_check_create( widgets+os.sep+\'widgets\'+slash+\'sessions\'+slash+\'waiting\' )\n    dir_check_create( widgets+os.sep+\'widgets\'+slash+\'sessions\'+slash+\'active\' )\n    # dir_check_create( techDrive+slash+\'techApps\' )\n    # dir_check_create( techDrive + slash+\'techApps\\\\_installers\' )\n    # dir_check_create( techDrive + slash+\'techApps\\\\_stand_alone\' )\n    # dir_check_create( techDrive + slash+\'techApps\\\\tools\' )\n    # dir_check_create( techDrive + slash+\'techApps\\\\one\\\\two\\\\three\' )\n    dir_check_create( dbTables )\n    dir_check_create( databases )\n\n    if home_created:\n        create_default_profile()\ndef createDestinationFolders( folder, o=None, isFile=False, p=False ):\n    folder=path_fix(folder)\n    global techDrive\n    global slashes\n    global slash\n    global UNC\n    # _.pr(folder)\n    if os.path.isdir(folder): return None;\n    \n    thisSlash = slash\n    for key in UNC[\'de\'].keys():\n        if key in folder:\n            folder = folder.replace( key, UNC[\'de\'][key] )\n    if os.path.isdir(folder): return None;\n    # _.pr(folder)\n    if not __.isWin:\n        isUnix = True\n    else:\n        isUnix = False\n    if not o is None:\n        if not \'w\' in o.lower():\n            isUnix = True\n        else:\n            isUnix = False\n    if isUnix:\n        thisSlash = slashes[\'unix\']\n        if \':\' in folder:\n            folder = techDrive + slash + folder.split(\':\')[1]\n    if isFile:\n        f = folder.split(thisSlash)\n        f.pop()\n        folder = thisSlash.join( f )\n    if os.path.isdir( folder ):\n        return folder\n    try:\n        os.mkdir(  folder )\n        if p:\n            _.pr( folder )\n        return folder\n    except Exception as e:\n        pass\n    parts = folder.split( slash )\n    \n    if not os.path.isdir( parts[0]+slash ):\n        return folder\n        # _.colorThis( \'Error: Destination drive does not exist\', \'red\' )\n    newParts = []\n    for p in parts:\n        newParts.append( p )\n        f = slash.join( newParts )\n        exist = os.path.isdir( f )\n        if not exist:\n            try:\n                os.mkdir( f )\n            except Exception as e:\n                pass\n                # _.colorThis( [ \'Error: creating folder\', f ], \'red\' )\n    return folder\ndef dir_check_create( folder ):\n    folder=path_fix(folder)\n    # _.pr(folder)\n    return createDestinationFolders( folder )\n    global dDim\n    global slash\n    global slashes\n    global techDrive\n    global techFolder\n    global appsFolder\n    if not __.isWin:\n        folder = folder.replace( slashes[\'windows\'], slash )\n        folder = folder.replace( \':\', \'\' )\n        techDrive = techDrive.replace( slashes[\'windows\'], slash )\n        techDrive = techDrive.replace( \':\', \'\' )\n    # if techDrive in folder:\n    #     folder = techDrive+dDim+slash+folder\n    # _.pr(folder)\n    # _.pr( folder )\n    if os.path.isdir( folder ):\n        # _.pr( folder )\n        return False\n    try:\n        os.mkdir( folder )\n        return True\n    except Exception as e:\n        pass\n    t = None\n    if appsFolder in folder:\n        t = appsFolder\n    elif techFolder in folder:\n        t = techFolder\n    if t is None:\n        return None\n    fld = folder.replace( t+slash, \'\' )\n    parts = fld.split( slash )\n    # parts.pop(0)\n    newParts = []\n    for p in parts:\n        newParts.append( p )\n        f = slash.join( newParts )\n        f = t+slash+f\n        # if not techDrive in f:\n        #     f = techDrive+dDim+slash+f\n        # _.pr(f)\n        exist = os.path.isdir( f )\n        # _.pr( \'exist:\', exist, f, \'\\r\\n\' )\n        if not exist:\n            try:\n                os.mkdir( f )\n            except Exception as e:\n                pass\n                # _.pr( \'Error:\', f )\n    return True\ndef dir_check_create2( theFolder ):\n    theFolder=path_fix(theFolder)\n    global slashes\n    global slash\n    if not __.isWin:\n        theFolder = theFolder.replace( slashes[\'windows\'], slash )\n    if not os.path.exists( theFolder ):\n        try:\n            os.mkdir( theFolder )\n        except Exception as e:\n            pass\ndef appLogs():\n    global myLogs\n    global myAppLogs\n    if not os.path.isdir( myLogs ):\n        os.mkdir( myLogs )\n    if not os.path.isdir( myAppLogs ):\n        os.mkdir( myAppLogs )\n    return myAppLogs\ndef ticketPath( ticket ):\n    global myTickets\n    global slash\n    dirList = os.listdir(myTickets)\n    i = 0\n    for item in dirList:\n        path = myTickets + slash + item\n        if os.path.isfile(path) and item.lower().endswith(\'.txt\'):\n            if item.lower().startswith(\'closed-\') or item.lower().startswith(\'open-\'):\n                idx = item.lower().replace( \'closed-\', \'\' ).replace( \'open-\', \'\' ).replace( \'.txt\', \'\' )\n                if idx == ticket:\n                    return path\n    return False\ndef fileBackupLog():\n    global fileBackupLogData\n    if len(fileBackupLogData) == 0:\n        fileBackupLogData = getTable(\'fileBackup.json\')\n    return fileBackupLogData\ndef generateFunctionLogFilename( filename ):\n    global myTXT\n    global py\n    file = os.path.abspath( filename )\n    # _.pr( file )\n    f = file\n    if myTXT in file:\n        for record in fileBackupLog():\n            if record[\'backup\'] == file:\n                f = record[\'file\']\n                break\n    fb = f.replace( py, \'\' ).replace( \'.py\', \'\' )\n    fb = fb.replace( slash, \'_\' )\n    fbr = \'audit_\'+fb + \'_raw.json\'\n    fbf = \'audit_\'+fb + \'_functions.json\'\n    # _.pr( fbf )\n    return fbf\n\ndef getTable( theFile, tableTemp=False, printThis=False ):\n    theFile=path_fix(theFile)\n    global simplejson\n    if not simplejson is None:\n        import simplejson\n    global myTables\n    global slash\n    global stmp\n    if os.sep in theFile:\n        file0 = theFile\n    else:\n        if not type( tableTemp ) == bool:\n            if tableTemp == \'split\':\n                file0 = myTables + slash+\'tablesets\'+slash + theFile\n        else:\n            if tableTemp == True:\n                file0 = stmp + slash + theFile\n            else:\n                file0 = myTables + slash + theFile\n    if printThis:\n        _.pr(\'Loaded: \' + file0)\n    if os.path.isfile(file0) == True:\n        with open(file0,\'r\', encoding="latin-1") as json_file:\n            json_data = simplejson.load(json_file)\n        return json_data\n    else:\n        return __.data_default(file=theFile,default=[]).default()\n\ndef app7z():\n    if not __.isWin:\n        if not os.path.isfile(\'/usr/bin/7z\'):\n            ask=\'\'\n            # get = \'sudo apt-get install p7zip-full\'\n            ask=input( \' not installed.. install ? \' )\n            if not \'y\' in ask.lower():\n                sys.exit()\n            os.system( \'sudo apt-get install p7zip-full\' )\n        return \'/usr/bin/7z\'\n    else:\n        app7z0 = "c:\\\\Program Files (x86)\\\\7-Zip\\\\7z.exe"\n        app7z1 = appsFolder + "\\\\7-Zip\\\\7z.exe"\n        app = ""\n        if os.path.isfile(app7z0):\n            app = app7z0\n        elif os.path.isfile(app7z1):\n            app = app7z1\n        else:\n            _.pr(\'Error: no 7z\')\n            sys.exit()\n        app = \'"\' + app + \'"\'\n    return app\ndef getUserProfile():\n# machineID = _v.getMachineID()\n    os.system("echo %userprofile% >" + tempFile)\n    output = open( tempFile, \'r\' ).read()\n    os.remove(tempFile)\n    output = output.replace(\'\\n\',\'\')\n    output = output.replace(\'\\r\',\'\')\n    output = _str.cleanBE( output, \' \' )\n    return output\ndef getMachineID():\n# machineID = _v.getMachineID()\n    import _rightThumb._md5 as _md5\n    global tempFile\n    if __.isWin:\n        os.system("wmic useraccount where (name=\'administrator\' and domain=\'%computername%\') get name,sid | find \\"admin\\" >" + tempFile)\n        output = open( tempFile, \'r\' ).read()\n        os.remove(tempFile)\n        output = _str.replaceAll(output, \' \',\'\')\n        output = _str.totalStrip(output)\n        output = output.replace(\'administrator\',\'\')\n        # _.pr(\'getMachineID\',output)\n        # sys.exit()\n        md5 = _md5.md5(output)\n        guid = _md5.md52GUID(md5,True)\n        return guid\n    else:\n        global unixID\n        return unixID\n        \ndef getDriveID(driveLetter):\n    global slash\n    global dDim\n    idFile = ddDim(driveLetter) +slash+\'drive.id.sys\'\n    # _.pr(idFile)\n    result = False\n    if os.path.isfile(idFile) == True:\n        driveID = open( idFile, \'r\' ).read()\n        driveID = driveID.replace(\' \',\'\')\n        driveID = driveID.replace(\'\\n\',\'\')\n        driveID = driveID.replace(\'\\r\',\'\')\n        result = driveID\n    return result\ndef sanitizeFolder( id_path ):\n    global folderID_tech\n    global folderID_profile\n    global folderID_host\n    global techFolder\n    global thisHost\n    global slash\n    id_path = __.path(id_path)\n    if id_path is None:\n        return None\n    id_path = id_path.replace( techFolder, folderID_tech )\n    if __.isWin:\n        id_path = id_path.replace( os.environ[\'USERPROFILE\'], folderID_profile )\n    elif not __.isWin:\n        id_path = id_path.replace( os.environ[\'HOME\'], folderID_profile )\n    \n    id_path = id_path.replace( thisHost, folderID_host )\n    id_path = id_path.replace( slash, \'/\' ).replace( \'//\', \'/\' ).replace( \'//\', \'/\' ).replace( \'//\', \'/\' ).replace( \'//\', \'/\' ).replace( \'//\', \'/\' )\n    return id_path\ndef resolveFolderIDs( id_path ):\n    if id_path is None:\n        return None\n    global folderID_tech\n    global folderID_profile\n    global folderID_host\n    global techFolder\n    global thisHost\n    global slash\n    if id_path is None:\n        return None\n    id_path = id_path.replace( folderID_tech, techFolder )\n    if __.isWin:\n        id_path = id_path.replace( folderID_profile, os.environ[\'USERPROFILE\'] )\n    elif not __.isWin:\n        id_path = id_path.replace( folderID_profile, os.environ[\'HOME\'] )\n    \n    id_path = id_path.replace( folderID_host, thisHost )\n    # id_path = id_path.replace( folderID_tech, techFolder )\n    # if __.isWin:\n    #     id_path = id_path.replace( os.environ[\'USERPROFILE\'], folderID_profile )\n    # elif not __.isWin:\n    #     id_path = id_path.replace( os.environ[\'HOME\'], folderID_profile )\n    \n    # id_path = id_path.replace( folderID_host, thisHost )\n    # if not __.isWin:\n    id_path = id_path.replace( \'4FD4030911\', slash )\n    id_path = id_path.replace( \'/\', slash )\n    id_path = id_path.replace( \'\\\\\', slash )\n    return __.path(id_path)\ndef filePath(path):\n    return \'file://\' + os.path.realpath(path)\ndef notepad():\n    global slash\n    global myVars\n    f = open(myVars + slash+\'notepad.txt\' , \'r\', encoding=\'latin-1\')\n    lines = f.readlines()\n    f.close()\n    result = lines[0].replace(\'\\n\',\'\')\n    return result\ndef myCrypto( data=False, encrypt=True, decrypt=False ):\n    global cryptoKeyPad\n    import _rightThumb._encryptString as _blowfish\n    if type( data ) == bool:\n        data = cryptoKeyPad\n    if decrypt or not encrypt:\n        return _blowfish.decrypt( data, password=True )\n    else:\n        return _blowfish.encrypt( data, password=True )\ndef scrampleIDs(ids):\n    if len(ids) == 38 and ids[0] == \'{\' and ids[-1] == \'}\' and len(ids.split(\'-\')) == 5:\n        result = \'\'\n        \n        i=0\n        for char in ids:\n            if i == 1:\n                result += ids[36]\n            elif i == 2:\n                result += ids[35]\n            elif i == 8:\n                result += ids[20]\n            elif i == 36:\n                result += ids[1]\n            elif i == 35:\n                result += ids[2]\n            elif i == 20:\n                result += ids[8]\n            elif i == 10:\n                result += ids[15]\n            elif i == 11:\n                result += ids[16]\n            elif i == 12:\n                result += ids[17]\n            elif i == 13:\n                result += ids[18]\n            elif i == 15:\n                result += ids[10]\n            elif i == 16:\n                result += ids[11]\n            elif i == 17:\n                result += ids[12]\n            elif i == 18:\n                result += ids[13]\n            else:\n                result += char\n            i+=1\n    else:\n        result = ids\n    return result\ndef installationCheck():\n    global techFolder\n    fileName = techFolder + slash+\'scripts\\\\instanceID.sys\'\n    if not os.path.isfile( fileName ):\n        open(fileName,\'w\', encoding=\'utf-8\').write( genUUID() )\ndef batch_files():\n    # epyi vars -file batch_c\n    # epyi vars -file batch_cc\n    # epyi vars -file batch_timestamp\n    # epyi vars -file batch_theUSB\n    global batch_files_installed\n    try:\n        batch_files_installed\n    except Exception as e:\n        batch_files_installed = False\n        \n    if not batch_files_installed:\n        batch_files_installed = True\n        global home\n        global widgets\n        global slash\n        ## OLD_INSTALLER\n        # if __.isWin:\n        #     if not os.path.isfile( widgets+os.sep+\'widgets\'+ slash+\'batch\\\\c.bat\' ):\n        #         from _rightThumb._vars import batch_c\n        #         batch_c.GENERATE_FILE(widgets)\n        #     if not os.path.isfile( home + slash+\'cc.bat\' ):\n        #         from _rightThumb._vars import batch_cc\n        #         batch_cc.GENERATE_FILE(home)\n        #     if not os.path.isfile( widgets+os.sep+\'widgets\'+ slash+\'batch\\\\timestamp.bat\' ):\n        #         from _rightThumb._vars import batch_timestamp\n        #         batch_timestamp.GENERATE_FILE(widgets)\n        #     if not os.path.isfile( widgets+os.sep+\'widgets\'+ slash+\'batch\\\\theUSB.bat\' ):\n        #         from _rightThumb._vars import batch_theUSB\n        #         batch_theUSB.GENERATE_FILE(widgets)\nif not __.autoCreationConfiguration[\'created\'][\'_vars\']:\n    dir_structure()\n    batch_files()\n    __.autoCreationConfiguration[\'created\'][\'_vars\'] +=1\n    # autoCreationConfiguration_folders = False\ntry:\n    if unixID_NEW:\n        f = open(unixID_path,\'w\', encoding=\'utf-8\')\n        f.write(unixIDs)\n        f.close()\nexcept Exception as e:\n    pass\nip = \'offline\'\nip_old = None\ndef ipGet(force=False):\n    global ip_old\n    global ip\n    global host_alias\n    global unixIDs\n    global config_hash\n    \n    \n    get_ip = False\n    hasImported = False\n    if not os.path.isfile(configFile(\'.ip\')):\n        from lxml import html\n        import requests\n        import urllib\n        hasImported = True\n        f = {\n                \'alias\': host_alias,\n                \'ids\': \'-\'.join(unixIDs),\n                \'os\':str(platform.platform())\n        }\n        if os.path.isfile( configFile(\'.distro\') ):\n            f[\'distro\'] = open( configFile(\'.distro\'), \'r\' ).read()\n        url = config_hash[\'register.php\']+\'?\'+urllib.parse.urlencode(f)\n        # _.pr(url)\n        try:\n            ip = html.fromstring(requests.get( url  ).content).text_content()\n            open(configFile(\'.ip\'),\'w\', encoding=\'utf-8\').write( ip )\n        except Exception as e:\n            ip = \'offline\'\n        get_ip = True\n    else:\n        cache_time = os.path.getmtime(configFile(\'.ip\'))\n        cache_age = time.time() - cache_time\n        if cache_age > 14400:\n            get_ip = True\n    # _.pr(get_ip)\n    if not get_ip and not force:\n        # ip = open( configFile(\'.ip\'), \'r\' ).read()\n        ip = open(configFile(\'.ip\'), \'r\', encoding=\'utf-8\').readlines()[0]\n        # _.pr(ip,\'here\',configFile(\'.ip\'))\n        ip = _str.totalStrip(ip)\n    elif get_ip or force:\n        if not hasImported:\n            from lxml import html\n            import requests\n        ip_old = open(configFile(\'.ip\'), \'r\', encoding=\'utf-8\').readlines()[0]\n        try:\n            ip = html.fromstring(requests.get(config_hash[\'ip.php\']+\'?id=\'+unixIDs[8]).content).text_content()\n            open(configFile(\'.ip\'),\'w\', encoding=\'utf-8\').write( ip )\n        except Exception as e:\n            ip = \'offline\'\n    # import urllib\n    # ip = urllib.request.urlopen( \'http://tools.rightthumb.com/ip.php?\' ).read()\n    # ip = str(ip,\'iso-8859-1\')\n    if ip_old is None:\n        ip_old = ip\n    if not ip_old == ip:\n        ip_hash = __.getTable( configFile(\'.ip.hash\') )\n        if not ip in ip_hash:\n            ip_hash[ip] = {}\n        ip_hash[ip][time.time()] = {}\n        __.saveTable( ip_hash, configFile(\'.ip.hash\') )\n    \n    return ip\nif not os.path.isdir( myConfig ):\n    dir_check_create( myConfig )\n    dir_structure()\n    gen_unixIDs()\nif not \'/bash/\' in __file__:\n    try:\n        ipGet()\n    except Exception as e:\n        pass\n        # _.pr( \'Error: IP\' )\ndef table(t):\n    global myTables\n    global slash\n    return myTables + slash + t\ndef tableDB(t):\n    global tablesDB\n    global slash\n    return tablesDB + slash + t\ndef tableAlt(t,h=\'MSI\'):\n    global myHome\n    global slash\n    parts = myHome.split(slash)\n    parts.reverse()\n    parts.pop(0)\n    parts.reverse()\n    fo = slash.join( parts ) +slash+ h +slash+ \'tables\'\n    if os.path.isdir(fo):\n        fo = os.path.abspath(fo)\n    fi = fo+slash+ t\n    return fi\ndef tableAlts(t,omit=True):\n    global myHome\n    global slash\n    parts = myHome.split(slash)\n    parts.reverse()\n    current = parts.pop(0)\n    parts.reverse()\n    folder = slash.join( parts )\n    # _.pr( folder )\n    # sys.exit()\n    result = []\n    for ho in os.listdir(folder):\n        shouldInclude = True\n        if omit and ho == current:\n            shouldInclude = False\n        if shouldInclude:\n            fo =  folder+slash+ ho +slash+ \'tables\'\n            if os.path.isdir(fo):\n                fo = os.path.abspath(fo)\n                fi = fo+slash+ t\n                if os.path.isfile(fi):\n                    result.append(fi)\n    return result\n\n\n\n\n\n# popFileDir(path)\n# _.pr(\'end\')\ndef config( subject=\'?\' ):\n    global mymyConfig\n    global config_file\n    global config_hash\n    global config_default\n    if config_file is None:\n        config_file = {}\n        try:\n            if os.path.isfile(myConfig +os.sep+ \'.config.hash\'):\n                config_file = __.getTable( myConfig +os.sep+ \'.config.hash\' )\n                if \'cloud-ssh-pass\' in config_file:\n                    config_default.cloud.ssh.password = config_file[\'cloud-ssh-pass\']\n        except Exception as e:\n            pass\n    cData = dics( config_hash, config_file, config_default_dic )\n\n    if subject == \'?\':\n        return config_default\n    if subject in cData:\n        return cData[subject]\n    return None\n\n\ntry:\n    if not os.path.isfile(myConfig+os.sep+\'construct.settings\'):\n        with open(   myConfig+os.sep+\'construct.settings\',    \'w\' ) as f:\n            pass\nexcept Exception as e:\n    _.pr( \'unable to touch:\', myConfig+os.sep+\'construct.settings\' )\n\ndef settings_load():\n    global myConfig\n    if os.stat( myConfig+os.sep+\'construct.settings\' ).st_size:\n        table = getTable(myConfig+os.sep+\'construct.settings\')\n        for k in table:\n            __.settings_table[k] = table[k]\n\ndef fpath(path): return resolveFolderIDs(path.replace(\'\\\\\',os.sep).replace(\'/\',os.sep))\n\n\npath = __.path\nmkdir = createDestinationFolders\n# default_powershell = \'echo test | py $p\\\\app.py\'\ndefault_powershell = \'\'\nconfig_file = None\n\nhp=myHome\nhi=myIndexes\nhc=myConfig\nht=myTables\nhb=myBackup\n\nbk=myBackup\ntt=myTables\n\npp = techFolder + slash+\'widgets\'\nw = techFolder \nww = techFolder + slash+\'widgets\'\n\nt   = techDrive\ntt  = myTables\nttt = dbTables\np   = home\npp = widgets\nta = appsFolder\n\nif not os.path.isdir(myConfig):\n    dir_structure()\n# dir_check_create\n# thisHost\n## OLD_INSTALLER\nmyAppsPy=py\nwprofile = myHome\ndoc_sep = \'__________________________________________________________________________________\'\nmeta=config_hash\n# print(life); sys.exit();\n\nfn=dot()\nfn.path=dot()\nfn.path.fix=fpath\nfn.path.res=resolveFolderIDs\nfn.path.san=sanitizeFolder\nfn.path.resolve=resolveFolderIDs\nfn.path.sanitize=sanitizeFolder\nfn.path.path=__.path\nfn.path.pop=popFile\nfn.path.mpop=popFileDir\napplog=myAppLogs\nif __.isWin:\n    user = cmdGetVar(\'username\')\nelse:\n    user = cmdGetVar(\'USER\')\n')
    __stickytape_write_module('_rightThumb/_md5/__init__.py', b'# md5\n\n# ## {R2D2919B742E} ##\n# ###########################################################################\n# What if magic existed?\n# What if a place existed where your every thought and dream come to life.\n# There is only one catch: it has to be written down.\n# Such a place exists, it is called programming.\n#    - Scott Taylor Reph, RightThumb.com\n# ###########################################################################\n# ## {C3P0D40fAe8B} ##\n\n# import _rightThumb._md5 as _md5\nimport os\nimport sys\nimport hashlib\n\n\ndef md5File(fname):\n    # return \'\'\n    if os.path.isfile(fname):\n        # print(fname)\n        hashData = hashlib.md5()\n        with open(fname, "rb") as f:\n            for chunk in iter(lambda: f.read(4096), b""):\n                hashData.update(chunk)\n        return hashData.hexdigest()\n    else:\n        print(\'Error: md5 no file\')\n        sys.exit()\n\ndef sha256File(fname):\n    # return \'\'\n    if os.path.isfile(fname):\n        # print(fname)\n        hashData = hashlib.sha256()\n        with open(fname, "rb") as f:\n            for chunk in iter(lambda: f.read(4096), b""):\n                hashData.update(chunk)\n        return hashData.hexdigest()\n    else:\n        print(\'Error: md5 no file\')\n        sys.exit()\n\n\ndef file( fname, h=\'md5\' ):\n    # return \'\'\n    if os.path.isfile(fname):\n        hashes = [\n                    \'md5\',\n                    \'sha1\',\n                    \'sha224\',\n                    \'sha256\',\n                    \'sha384\',\n                    \'sha512\',\n                    \'sha3_224\',\n                    \'sha3_256\',\n                    \'sha3_384\',\n                    \'sha3_512\',\n        ]\n        if not h in hashes:\n            print( \'Error: hash type not valid\' )\n            print( \'\\t Try:\', \' , \'.join( hashes ) )\n            sys.exit()\n        if h == \'md5\':\n            hashData = hashlib.md5()\n        if h == \'sha1\':\n            hashData = hashlib.sha1()\n        if h == \'sha224\':\n            hashData = hashlib.sha224()\n        if h == \'sha256\':\n            hashData = hashlib.sha256()\n        if h == \'sha384\':\n            hashData = hashlib.sha384()\n        if h == \'sha3_224\':\n            hashData = hashlib.sha3_224()\n        if h == \'sha3_256\':\n            hashData = hashlib.sha3_256()\n        if h == \'sha3_384\':\n            hashData = hashlib.sha3_384()\n        if h == \'sha3_512\':\n            hashData = hashlib.sha3_512()\n        if h == \'sha512\':\n            hashData = hashlib.sha512()\n\n\n        with open(fname, "rb") as f:\n            for chunk in iter(lambda: f.read(4096), b""):\n                hashData.update(chunk)\n        return hashData.hexdigest()\n    else:\n        print(\'Error: not a file\')\n        sys.exit()\n\n\ndef string( chunk, h=\'md5\' ):\n    \n    hashes = [\n                \'md5\',\n                \'sha1\',\n                \'sha224\',\n                \'sha256\',\n                \'sha384\',\n                \'sha512\',\n                \'sha3_224\',\n                \'sha3_256\',\n                \'sha3_384\',\n                \'sha3_512\',\n    ]\n    if not h in hashes:\n        print( \'Error: hash type not valid\' )\n        print( \'\\t Try:\', \' , \'.join( hashes ) )\n        sys.exit()\n    if h == \'md5\':\n        hashData = hashlib.md5()\n    if h == \'sha1\':\n        hashData = hashlib.sha1()\n    if h == \'sha224\':\n        hashData = hashlib.sha224()\n    if h == \'sha256\':\n        hashData = hashlib.sha256()\n    if h == \'sha384\':\n        hashData = hashlib.sha384()\n    if h == \'sha3_224\':\n        hashData = hashlib.sha3_224()\n    if h == \'sha3_256\':\n        hashData = hashlib.sha3_256()\n    if h == \'sha3_384\':\n        hashData = hashlib.sha3_384()\n    if h == \'sha3_512\':\n        hashData = hashlib.sha3_512()\n    if h == \'sha512\':\n        hashData = hashlib.sha512()\n\n    pass\n    hashData.update(bytes(chunk, \'utf-8\'))\n    return hashData.hexdigest()\n\n\n\ndef bin( data, h=\'md5\' ):\n    \n    hashes = [\n                \'md5\',\n                \'sha1\',\n                \'sha224\',\n                \'sha256\',\n                \'sha384\',\n                \'sha512\',\n                \'sha3_224\',\n                \'sha3_256\',\n                \'sha3_384\',\n                \'sha3_512\',\n    ]\n    if not h in hashes:\n        print( \'Error: hash type not valid\' )\n        print( \'\\t Try:\', \' , \'.join( hashes ) )\n        sys.exit()\n    if h == \'md5\':\n        hashData = hashlib.md5()\n    if h == \'sha1\':\n        hashData = hashlib.sha1()\n    if h == \'sha224\':\n        hashData = hashlib.sha224()\n    if h == \'sha256\':\n        hashData = hashlib.sha256()\n    if h == \'sha384\':\n        hashData = hashlib.sha384()\n    if h == \'sha3_224\':\n        hashData = hashlib.sha3_224()\n    if h == \'sha3_256\':\n        hashData = hashlib.sha3_256()\n    if h == \'sha3_384\':\n        hashData = hashlib.sha3_384()\n    if h == \'sha3_512\':\n        hashData = hashlib.sha3_512()\n    if h == \'sha512\':\n        hashData = hashlib.sha512()\n\n    pass\n    hashData.update(data)\n    return hashData.hexdigest()\n\n\n# md5\n# sha1\n# sha224\n# sha256\n# sha384\n# sha3_224\n# sha3_256\n# sha3_384\n# sha3_512\n# sha512\n# shake_128\n# shake_256\n\n\n\ndef md5Bin( data ):\n    hashData = hashlib.md5()\n    hashData.update(data)\n    return hashData.hexdigest()\n\ndef md5(chunk):\n    # try:\n    #     pass\n    #     chunk = line.encode(\'UTF-8\').decode(\'latin-1\')\n    # except Exception as e:\n    #     pass\n    hashData = hashlib.md5()\n    hashData.update(bytes(chunk, \'utf-8\'))\n    return hashData.hexdigest()\n            \ndef md52GUID(string,brackets):\n    string = string.upper()\n    result = \'\'\n    result += str(string[0:8])\n    result += str(\'-\')\n    result += str(string[8:12])\n    result += str(\'-\')\n    result += str(string[12:16])\n    result += str(\'-\')\n    result += str(string[16:20])\n    result += str(\'-\')\n    result += str(string[20:32])\n    if brackets == True:\n        result = \'{\' + result + \'}\'\n    return result\n\n# set machineID={%machineID:~0,8%-%machineID:~8,4%-%machineID:~12,4%-%machineID:~16,4%-%machineID:~20,12%}\n\n')
    __stickytape_write_module('_rightThumb/_encryptString/__init__.py', b'import sys\n\n# ## {R2D2919B742E} ##\n# ###########################################################################\n# What if magic existed?\n# What if a place existed where your every thought and dream come to life.\n# There is only one catch: it has to be written down.\n# Such a place exists, it is called programming.\n#    - Scott Taylor Reph, RightThumb.com\n# ###########################################################################\n# ## {C3P0D40fAe8B} ##\n\nerrors=False\nerrors=True\nhasErrors=False\ntry:\n    import base64\nexcept Exception as e:\n    hasErrors=True\n    if errors: print(e);\n    pass\ntry:\n    from Crypto.Cipher import Blowfish\nexcept Exception as e:\n    hasErrors=True\n    if errors: print(e);\n    pass\ntry:\n    import _rightThumb._vars as _v\nexcept Exception as e:\n    hasErrors=True\n    if errors: print(e);\n    pass\ntry:\n    import _rightThumb._md5 as _md5\nexcept Exception as e:\n    hasErrors=True\n    if errors: print(e);\n    pass\ntry:\n    import _rightThumb._string as _str\nexcept Exception as e:\n    hasErrors=True\n    if errors: print(e);\n    pass\n\nif errors and hasErrors:\n    sys.exit()\n\ndef genPassword( password=False ):\n    return newKey( password )\n\ndef newKey( password ):\n    # min 150\n\n    if not type(password) == bool:\n        result = _v.cryptoKeyPad + str(password)\n    else:\n        if password:\n            # 187 chars\n            result = _v.cryptoKeyPad + _v.scrampleIDs(_v.getMachineID())\n        else:\n            result = _v.myCrypto()\n\n    return _md5.md5( result )\n\n\ndef pad_string( string ):\n    INPUT_SIZE = 8\n    new_str = string\n    pad_chars = INPUT_SIZE - (len(string) % INPUT_SIZE)\n\n    if pad_chars != 0:\n        for x in range(pad_chars):\n            new_str += " "\n        \n\n    return new_str\n\n\n\ndef decryptClean( data, password=False ):\n    result = decrypt( data, password )\n    # return result\n    # return _str.cleanBE( result, \' \' )\n    return _str.do(\'e\',result,\' \')\ndef decrypt( data, password=False ):\n    crypt_obj = Blowfish.new(newKey(password), Blowfish.MODE_ECB)\n    decoded = base64.b64decode(data)\n    decrypt = crypt_obj.decrypt(decoded)\n    result = str(decrypt,\'iso-8859-1\')\n    return result\n    return _str.do(\'e\',result,\' \')\n\n\ndef encrypt( data, password=False ):\n    crypt_obj = Blowfish.new(newKey(password), Blowfish.MODE_ECB)\n    try:\n        ciphertext = crypt_obj.encrypt(pad_string(str(data)))\n    except Exception as e:\n        works = False\n        space = \' \'\n        i = 0\n        while works == False:\n            try:\n                ciphertext = crypt_obj.encrypt(pad_string(str(data)) + space)\n                works = True\n            except Exception as e:\n                pass\n            space += \' \'\n            if i == 10:\n                works = True\n            i += 1\n\n    result = base64.b64encode(ciphertext)\n    thePayload = str(result,\'iso-8859-1\')\n\n    return thePayload\n\n\n\n\n\nimport hashlib\ndef md5(chunk):\n    hash_md5 = hashlib.md5()\n    hash_md5.update(bytes(chunk, \'utf-8\'))\n    return hash_md5.hexdigest()\n\n\ndef md5File(fname):\n    import os, sys\n    if os.path.isfile(fname):\n        hash_md5 = hashlib.md5()\n        with open(fname, "rb") as f:\n            for chunk in iter(lambda: f.read(4096), b""):\n                hash_md5.update(chunk)\n        return hash_md5.hexdigest()\n    else:\n        print(\'MD5 Error: file not found\')\n        sys.exit()\n\n\n# def encryptFile( password, path, savePath ):\n#     data = open(  path , \'rb\'  ).read()\n#     encoded = base64.encodebytes(data)\n#     crypt_obj = Blowfish.new( md5(password) , Blowfish.MODE_ECB)\n\n#     try:\n#         ciphertext = crypt_obj.encrypt(pad_string(str(encoded)))\n#     except Exception as e:\n#         works = False\n#         space = \' \'\n#         i = 0\n#         while works == False:\n#             try:\n#                 ciphertext = crypt_obj.encrypt(pad_string(str(encoded)) + space)\n#                 works = True\n#             except Exception as e:\n#                 pass\n#             space += \' \'\n#             if i == 10:\n#                 works = True\n#             i += 1\n\n#     encoded = base64.encodebytes(ciphertext)\n#     for x in dir(base64):\n#         if \'code\' in x:\n#             print(x)\n#     # thePayload = str(result,\'iso-8859-1\')\n#     save( encoded, savePath )\n#     return None\n\n\n\n\n# def save( data, path ):\n#     with open(  path   ,  \'wb\'  ) as fh:\n#         fh.write( data )\n#         # fh.write(base64.decodebytes(encoded))\n\n\n# def decryptBin( password, path, savePath ):\n#     data = open(  path , \'rb\'  ).read()\n\n#     decoded = base64.decodebytes(data)\n#     # decoded = base64.b64decode(data)\n\n#     what = decoded\n#     crypt_obj = Blowfish.new( md5(password)  , Blowfish.MODE_ECB)\n#     decrypt = crypt_obj.decrypt(what)\n\n#     # decoded = base64.b64decode(decrypt)\n#     decoded = base64.decodebytes(decrypt)\n\n#     what = decoded\n#     save( what, savePath )\n#     return None\n\np=genPassword\n\n')
    __stickytape_write_module('_rightThumb/_profileVariables/__init__.py', b'import sys\n\n# ## {R2D2919B742E} ##\n# ###########################################################################\n# What if magic existed?\n# What if a place existed where your every thought and dream come to life.\n# There is only one catch: it has to be written down.\n# Such a place exists, it is called programming.\n#    - Scott Taylor Reph, RightThumb.com\n# ###########################################################################\n# ## {C3P0D40fAe8B} ##\n\nimport os\nimport time\nimport _rightThumb._construct as __\nimport _rightThumb._vars as _v\nimport simplejson as json\n\n__.dictProfile_fields = []\n\nclass Profile:\n\n    def __init__( self, name, asset, appReg ):\n        self.appReg = appReg\n        self.name = name\n        self.asset = asset\n        self.profile = {}\n\n        self.multiType = False\n        self.samples = 1\n        self.type = False\n        self.types = []\n\n        self.dictProfile = False\n        self.dictProfiles = []\n\n        self.length = False\n        self.lengths = []\n\n        self.mem = False\n        self.mems = []\n\n        self.dKey = False\n        self.dKeys = []\n\n        self.first = True\n\n\n    def audit( self ):\n        profile = self.initialize()\n        length = 0\n        mem = 1\n\n\n\n        if \'socket\' in str(type( self.asset )).lower() and \'ssl\' in str(type( self.asset )).lower()  :\n            thisType = \'SSL_Socket\'\n        elif \'socket\' in str(type( self.asset )).lower():\n            thisType = \'Socket\'\n        elif type( self.asset ) == bool:\n            thisType = \'bool\'\n        elif type( self.asset ) == tuple:\n            mem = sys.getsizeof( str( self.asset ) )\n            thisType = \'tuple\'\n            length = len( self.asset )\n        elif type( self.asset ) == list:\n            mem = sys.getsizeof( str( self.asset ) )\n            thisType = \'list\'\n            length = len( self.asset )\n            if length:\n                if type( self.asset[0] ) == dict:\n                    thisType = \'list_dics\'\n\n\n\n        elif type( self.asset ) == int:\n            mem = sys.getsizeof( str( self.asset ) )\n            thisType = \'int\'\n            length = len( str(self.asset) )\n        elif type( self.asset ) == float:\n            mem = sys.getsizeof( str( self.asset ) )\n            thisType = \'float\'\n            length = len( str(self.asset) )\n        elif type( self.asset ) == str:\n            mem = sys.getsizeof( str( self.asset ) )\n            thisType = \'str\'\n            length = len( self.asset )\n        elif type( self.asset ) == complex:\n            thisType = \'complex\'\n        elif type( self.asset ) == dict:\n            mem = sys.getsizeof( str( self.asset ) )\n            thisType = \'dict\'\n        elif self.asset is None:\n            thisType = \'None\'\n\n        elif \'class\' in str(type( self.asset )):\n            saveTable( self.asset.__dict__, \'profileVariables_temp.json\' )\n            newData = getTable( \'profileVariables_temp.json\' )\n            self.asset = newData\n            return self.audit()\n\n\n\n        # print( type( self.asset ) )\n\n\n        self.addType( thisType )\n        dictProfile = False\n        if thisType == \'dict\' or thisType == \'list_dics\' :\n            if thisType == \'dict\':\n                if self.hasKeys( self.asset ):\n                    try:\n                        dictProfile = processRows( [ self.asset ] )\n                    except Exception as e:\n                        dictProfile = False\n                else:\n                    dictProfile = False\n            else:\n                if self.hasKeys( self.asset[0] ):\n                    try:\n                        dictProfile = processRows( self.asset )\n                    except Exception as e:\n                        dictProfile = False\n                else:\n                    dictProfile = False\n        \n        \n\n        if len( __.dictProfile_fields ):\n            self.addKeys( __.dictProfile_fields )\n            if thisType == \'dict\':\n                length = len( __.dictProfile_fields )\n            else:\n                length = [ length, len( __.dictProfile_fields ) ]\n            self.addDictProfile( dictProfile )\n\n\n        self.addLength( length )\n        self.addMem( mem )\n\n\n        # self.asset = None\n        \n        self.profile = self.initialize()\n        return self.profile\n\n    def addKeys( self, data ):\n        if type( self.dKey ) == bool:\n            self.dKey = data\n        elif not len(self.dKeys):\n            if not self.dKey == data:\n                self.dKeys.append( self.dKey )\n                self.dKeys.append( data )\n                self.dKey = data\n        else:\n            self.dKeys.append( data )\n            self.dKey = data\n\n    def addMem( self, data ):\n        if type( self.mem ) == bool:\n            self.mem = data\n        elif not len(self.mems):\n            self.mems.append( self.mem )\n            self.mems.append( data )\n        else:\n            self.mems.append( self.mem )\n\n\n    def addLength( self, data ):\n        if type( self.length ) == bool:\n            self.length = data\n        elif not len(self.lengths):\n            self.lengths.append( self.length )\n            self.lengths.append( data )\n        else:\n            self.lengths.append( self.length )\n\n    def addDictProfile( self, data ):\n        if self.hasKeys( self.dictProfile ):\n            self.first = False\n\n        if not self.hasKeys( self.dictProfile ):\n            self.dictProfile = data\n        else:\n            found = False\n            for row in self.dictProfiles:\n                if row == data:\n                    found = True\n            if not found:\n                self.dictProfiles.append( data )\n            self.dictProfile = data\n\n\n\n\n    def addType( self, thisType ):\n        \n        if type( self.type ) == bool:\n            self.type = thisType\n        else:\n            if len( self.types ):\n                same = True\n                for row in self.types:\n                    if not row == thisType:\n                        same = False\n                        self.multiType = True\n                if not same:\n                    self.types.append( thisType )\n                    self.type = thisType\n            else:\n                if not self.type == thisType:\n                    self.types.append( self.type )\n                    self.types.append( thisType )\n                    self.type = thisType\n\n\n\n\n\n    def prep( self ):\n        if not self.hasKeys( self.profile ):\n            self.profile = self.initialize()\n\n\n    def initialize( self ):\n        profile = {\n                            \'name\': self.name,\n                            \'epoch\': time.time(),\n                            \'type\': self.type,\n                            \'types\': self.types,\n                            \'multi\': self.multiType,\n                            \'mem\': self.mem,\n                            \'mems\': self.mems,\n                            \'length\': self.length,\n                            \'lengths\': self.lengths,\n                            \'dKey\': self.dKey,\n                            \'dKeys\': self.dKeys,\n                            \'dicProfiles\': self.dictProfiles,\n                            \'dicProfile\': self.dictProfile,\n        }\n\n        return profile\n\n\n    def hasKeys( self, data ):\n        if not type(data) == dict:\n            return False\n            \n        if len( data.keys() ):\n            return True\n        else:\n            return False\n\n\n\n\n\nclass Variable_Profiles:\n\n    def __init__( self ):\n        self.profiles = []\n        self.appReg = __.appReg\n\n    def audit( self, name, asset, appReg=False ):\n        if type(appReg) == bool:\n            appReg = __.appReg\n        found = False\n        thisID = False\n        for i,t in enumerate(self.profiles):\n            if self.profiles[i].name == name and self.profiles[i].appReg == appReg:\n                found = True\n                if len(asset) > 0:\n                    self.profiles[i].asset = asset\n                    return self.profiles[i].profile()\n        if not found:\n            i = len(self.profiles)\n            self.profiles.append(Profile( name, asset, appReg ))\n            return self.profiles[i].audit()\n\n    def getAsset( self, name, appReg=False ):\n        if type(appReg) == bool:\n            appReg = __.appReg\n\n        for i,t in enumerate(self.profiles):\n            print( self.profiles[i].name, name )\n            if self.profiles[i].name == name:\n            # if self.profiles[i].name == name and self.profiles[i].appReg == appReg:\n                return self.profiles[i].asset\n\n        return None\n\n\nrecords = Variable_Profiles()\n\n\ndef processDic( rows, thisDic, parent=[]):\n    \n    \n\n    fields = []\n    for tK in thisDic.keys():\n\n        if thisDic[tK] == \'dic\':\n            __.dictProfile_fields.append({ \'type\': thisDic[tK], \'field\': tK, \'parent\': parent })\n            # newParent = list(tuple(parent))\n            try:\n                if type(rows[tK]) == dict:\n                    dicRow = []\n                    dicRow.append(rows[tK])\n                newParent = list(tuple(parent))\n                newParent.append( str(tK) )\n                fields.append({\'type\': thisDic[tK], \'field\': tK, \'parent\': parent, \'zChildren\': processRows(dicRow, newParent)})\n            except Exception as e:\n                try:\n                    newParent = list(tuple(parent))\n                    newParent.append( str(tK) )\n                    fields.append({\'type\': thisDic[tK], \'field\': tK, \'parent\': parent, \'zChildren\': processRows(rows[0][tK], newParent)})\n                except Exception as e:\n                    fields.append({\'type\': thisDic[tK], \'field\': tK, \'parent\': parent })\n        elif thisDic[tK] == \'multidimensional\' or thisDic[tK] == \'list\':\n            __.dictProfile_fields.append({ \'type\': thisDic[tK], \'field\': tK, \'parent\': parent })\n            try:\n                try:\n                    newParent = list(tuple(parent))\n                    newParent.append( str(tK) )\n                    fields.append({\'type\': thisDic[tK]+\'1\', \'field\': tK, \'parent\': parent, \'zChildren\': processRows(rows[0][tK], newParent)})\n                except Exception as e:\n                    # print(\'dic\')\n                    newParent = list(tuple(parent))\n                    newParent.append( str(tK) )\n                    fields.append({\'type\': thisDic[tK]+\'2\', \'field\': tK, \'parent\': parent, \'zChildren\': processRows(rows[tK], newParent)})\n                    # print(\'dic\')\n            except Exception as e:\n                # try:\n                #     print(rows[0][tK])\n                # except Exception as e:\n                #     pass\n                # print(rows[0][tK])\n                # print(tK)\n\n\n                \n                # if \'date_test\' in tK:\n                #     print("\'"+tK+"\'")\n                #     print(\'it was found\')\n                #     print(rows)\n                #     # fields.append({\'type\': thisDic[tK]+\'3\', \'field\': tK, \'zChildren\': processRows2(rows[0][tK])})\n                #     print(\'done\')\n                #     sys.exit()\n                # else:\n                #     fields.append({\'type\': thisDic[tK]+\'3\', \'field\': tK})\n                fields.append({\'type\': thisDic[tK]+\'3\', \'field\': tK, \'parent\': parent })\n        else:\n            __.dictProfile_fields.append({ \'type\': thisDic[tK], \'field\': tK, \'parent\': parent })\n            fields.append({\'type\': thisDic[tK], \'field\': tK, \'parent\': parent })\n    # print(fields)\n    return fields\n\n\n\ndef processRows( rows, parent=[] ):\n    jsonKeys = {}\n    # print(\'yes\')\n    # if type(rows) == list:\n        # rows = rows[0]\n    # print(type(rows))\n    if type(rows) == dict:\n        # print(rows)\n        # print(\'dic\')\n        # print(rows)\n        # print(\'dic\')\n        for i,kS in enumerate(rows.keys()):\n            if i == 0:\n                pass\n                # print(kS,type(rows[kS]))\n            try:\n                try:\n                    float(rows[kS])\n                except Exception as e:\n                    int(rows[kS])\n                if i == 0:\n                    jsonKeys[kS] = \'int\'\n            except Exception as e:\n                if len(kS) > 0:\n                    jsonKeys[kS] = variableType(rows[kS])\n            if jsonKeys[kS] == \'int\' and isDate(rows[kS]):\n                jsonKeys[kS] = \'date\'\n            if type(rows[kS]) == list:\n                try:\n                    if len(jsonKeys[kS][0].keys()) > 0:\n                        jsonKeys[kS] = \'multidimensional\'\n                    else:\n                        jsonKeys[kS] = \'list\'\n                except Exception as e:\n                    jsonKeys[kS] = \'list\'\n    else:\n        for  i,jN in enumerate(rows):\n            # print(jN)\n\n            try:\n                for kS in jN.keys():\n                    if i == 0:\n                        pass\n                        # print(kS,type(jN[kS]))\n                    try:\n                        int(jN[kS])\n                        if i == 0:\n                            jsonKeys[kS] = \'int\'\n                    except Exception as e:\n                        if len(kS) > 0:\n                            jsonKeys[kS] = variableType(jN[kS])\n                    if jsonKeys[kS] == \'int\' and isDate(jN[kS]):\n                        jsonKeys[kS] = \'date\'\n                    if type(jN[kS]) == list:\n                        try:\n                            if len(jsonKeys[kS][0].keys()) > 0:\n                                jsonKeys[kS] = \'multidimensional\'\n                            else:\n                                jsonKeys[kS] = \'list\'\n                        except Exception as e:\n                            jsonKeys[kS] = \'list\'\n                    if type(jN[kS]) == dict:\n                        jsonKeys[kS] = \'dic\'\n                        # print(jN[kS])\n                pass\n            except Exception as e:\n                # print(rows)\n                try:\n                    try:\n                        float(jN[i])\n                    except Exception as e:\n                        int(jN[i])\n                    jsonKeys[i] = \'int\'\n                except Exception as e:\n                    try:\n                        jN[i]\n                        jsonKeys[i] = variableType(jN[i])\n                    except Exception as e:\n                        pass\n                try: ###\n                    if jsonKeys[i] == \'int\' and isDate(jN[i]):\n                        jsonKeys[i] = \'date\'\n                except Exception as e:\n                    pass\n    return processDic( rows, jsonKeys, parent )\n\ndef isDate(n):\n    try:\n        try:\n            n = int(n)\n        except Exception as e:\n            n = float(n)\n        test = cal_days_diff(n)\n        if test < 7000:\n            result = True\n        else:\n            result = False\n    except Exception as e:\n        result = False\n    return result\n\n\n\ndef getTable( theFile, tableTemp=False, printThis=False ):\n    # defaults to myTables\n    if not type( tableTemp ) == bool:\n        if tableTemp == \'split\':\n            file0 = _v.myTables + _v.slash+\'tablesets\'+_v.slash + theFile\n    else:\n        if tableTemp == True:\n            file0 = _v.stmp + _v.slash + theFile\n        else:\n            file0 = _v.myTables + _v.slash + theFile\n\n    if printThis:\n        print(\'Loaded: \' + file0)\n    if os.path.isfile(file0) == True:\n        with open(file0,\'r\', encoding="latin-1") as json_file:\n            json_data = json.load(json_file)\n            # json_data = json.load(json_file, object_pairs_hook=OrderedDict)\n    else:\n        json_data = []\n    return json_data\n\n\ndef saveTable( rows, theFile, tableTemp=False, printThis=False, indentCode=True, sort_keys=False ):\n    # defaults to myTables\n    p = \'\'\n    if not tableTemp:\n        file0 = _v.myTables + _v.slash + theFile\n        p = theFile\n    else:\n        file0 = _v.stmp + _v.slash + theFile\n        p = file0\n    if indentCode:\n        dataDump = json.dumps(rows, indent=4, sort_keys=sort_keys)\n    else:\n        dataDump = json.dumps(rows)\n    f = open(file0,\'w\')\n    f.write(str(dataDump))\n    f.close()\n    if printThis:\n        print(\'Saved: \' + p, \'blue\')\n    return file0\n\n\ndef variableType( asset ):\n    if \'socket\' in str(type( asset )).lower() and \'ssl\' in str(type( asset )).lower()  :\n        thisType = \'SSL_Socket\'\n    elif \'socket\' in str(type( asset )).lower():\n        thisType = \'Socket\'\n    elif type( asset ) == bool:\n        thisType = \'bool\'\n    elif type( asset ) == tuple:\n        mem = sys.getsizeof( str( asset ) )\n        thisType = \'tuple\'\n        length = len( asset )\n    elif type( asset ) == list:\n        mem = sys.getsizeof( str( asset ) )\n        thisType = \'list\'\n        length = len( asset )\n        if length:\n            if type( asset[0] ) == dict:\n                thisType = \'list_dics\'\n\n\n\n    elif type( asset ) == int:\n        mem = sys.getsizeof( str( asset ) )\n        thisType = \'int\'\n        length = len( str(asset) )\n    elif type( asset ) == float:\n        mem = sys.getsizeof( str( asset ) )\n        thisType = \'float\'\n        length = len( str(asset) )\n    elif type( asset ) == str:\n        mem = sys.getsizeof( str( asset ) )\n        thisType = \'str\'\n        length = len( asset )\n    elif type( asset ) == complex:\n        thisType = \'complex\'\n    elif type( asset ) == dict:\n        mem = sys.getsizeof( str( asset ) )\n        thisType = \'dict\'\n    elif asset is None:\n        thisType = \'None\'\n\n    elif \'class\' in str(type( asset )):\n        thisType = \'class\'\n\n    return thisType\n\n\n\n')
    __stickytape_write_module('_rightThumb/_date/__init__.py', b"import datetime\n\n# ## {R2D2919B742E} ##\n# ###########################################################################\n# What if magic existed?\n# What if a place existed where your every thought and dream come to life.\n# There is only one catch: it has to be written down.\n# Such a place exists, it is called programming.\n#    - Scott Taylor Reph, RightThumb.com\n# ###########################################################################\n# ## {C3P0D40fAe8B} ##\n\nimport os\nimport time\n\n# auto = autoDate( data )\n\nclass Color:\n    purple = '\\033[95m'\n    cyan = '\\033[96m'\n    darkcyan = '\\033[36m'\n    blue = '\\033[94m'\n    green = '\\033[92m'\n    yellow = '\\033[93m'\n    red = '\\033[91m'\n    bold = '\\033[1m'\n    underline = '\\033[4m'\n    end = '\\033[0m'\n\n\ndef friendlyDate( theDate ):\n    try:\n        return resolveEpoch( float(theDate) )\n    except Exception as e:\n        try:\n            return resolveEpoch( autoDate( str(theDate) ) )\n        except Exception as e:\n            return Color.red + 'error: friendlyDate()' + Color.end\n            # return colorThis( [ 'error: friendlyDate()' ], 'red' )\n            # return 'error: friendlyDate()'\n\ndef friendlyDateTouch( theDate ):\n    xyz = friendlyDate(theDate)\n    # 2020-12-29 07:40:16\n    partsA = xyz.split(' ')\n    a = partsA[0].replace('-', '')\n    partsB = partsA[1].split(':')\n    a = a + partsB[0] + partsB[1] \n    return int(a)\ndef resolveEpoch( string, test=1, showPrint=False, showPrintTry=False, onlyEpoch=True, delim='-', falseBlank=False ):\n    # onlyEpoch = True, False, 'day' \n\n    auto = autoDate( string )\n    if not type( auto ) == bool:\n        string = auto\n\n\n    rData = False\n\n    try:\n        float( string )\n    except Exception as e:\n        test = 0\n\n    word = string\n    if test == 1:\n\n        if showPrintTry:\n            print( 'try:', 1 )\n        try:\n            if showPrint:\n                print( 'success:', 1 )\n            result = ' { { ' + str(datetime.datetime.fromtimestamp(float(word)).strftime('%Y-%m-%d %H:%M:%S')) + ' } } '\n            epoch = str(datetime.datetime.fromtimestamp(float(word)).strftime('%Y-%m-%d %H:%M:%S'))\n            rData = [ result, epoch ]\n        except Exception as e:\n            pass\n            rData = resolveEpoch( string, 2, showPrint, showPrintTry, onlyEpoch, delim )\n    \n\n    if test == 2:\n\n        if showPrintTry:\n            print( 'try:', 2 )\n        try:\n            if showPrint:\n                print( 'success:', 2 )\n            result = ' { { ' + str(time.strftime('%m/%d/%Y %H:%M:%S',  time.gmtime(float(word)/1000.))) + ' } } '\n            epoch = str(time.strftime('%m/%d/%Y %H:%M:%S',  time.gmtime(float(word)/1000.)))\n            rData = [ result, epoch ]\n        except Exception as e:\n            pass\n            rData = resolveEpoch( string, 3, showPrint, showPrintTry, onlyEpoch, delim )\n\n\n\n    if test == 3:\n\n        if showPrintTry:\n            print( 'try:', 3 )\n        try:\n            if showPrint:\n                print( 'success:', 3 )\n            result = ' { { ' + str(datetime.datetime.fromtimestamp(float(word)/1000.)) + ' } } '\n            epoch = str(datetime.datetime.fromtimestamp(float(word)/1000.))\n            rData = [ result, epoch ]\n        except Exception as e:\n            pass\n            rData = resolveEpoch( string, 4, showPrint, showPrintTry, onlyEpoch, delim )\n\n\n    if test == 4:\n\n        if showPrintTry:\n            print( 'try:', 4 )\n        try:\n            if showPrint:\n                print( 'success:', 4 )\n            result = ' { { ' + str(time.ctime(float(word))) + ' } } '\n            epoch = str(time.ctime(float(word)))\n            rData = [ result, epoch ]\n        except Exception as e:\n            pass\n            rData = resolveEpoch( string, 5, showPrint, showPrintTry, onlyEpoch, delim )\n\n\n\n    if test == 5:\n\n        if showPrintTry:\n            print( 'try:', 5 )\n        try:\n            if showPrint:\n                print( 'success:', 5 )\n            result = ' { { ' + str(time.strftime('%m/%d/%Y %H:%M:%S',  time.gmtime(float(word)/1000.))) + ' } } '\n            epoch = str(time.strftime('%m/%d/%Y %H:%M:%S',  time.gmtime(float(word)/1000.)))\n            rData = [ result, epoch ]\n        except Exception as e:\n            pass\n            rData = resolveEpoch( string, 6, showPrint, showPrintTry, onlyEpoch, delim )\n\n    if test == 6:\n\n        if showPrintTry:\n            print( 'try:', 6 )\n        try:\n            if showPrint:\n                print( 'success:', 6 )\n            result = ' { { ' + str(datetime.datetime.fromtimestamp(float(word)).strftime('%Y-%m-%d %H:%M:%S')) + ' } } '\n            epoch = str(datetime.datetime.fromtimestamp(float(word)).strftime('%Y-%m-%d %H:%M:%S'))\n            rData = [ result, epoch ]\n        except Exception as e:\n            pass\n\n    if not type( rData ) == bool:\n        if not type( onlyEpoch ) == bool:\n            rData = rData[1].split(' ')[0].replace( '-', delim )\n        elif onlyEpoch == True:\n            rData = rData[1].replace( '-', delim )\n        else:\n            rData[1] = rData[1].replace( '-', delim )\n\n    if falseBlank and type( rData ) == bool:\n        rData = ''\n    return rData\n\ndef findDelims( data ):\n    data = str( data )\n    d = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'\n    delims = []\n    for c in data:\n        if not c in d:\n            delims.append(c)\n    return delims\n\ndef formatDate(date):\n    theDate = datetime.datetime.fromtimestamp( float(date) ).strftime('%Y.%m.%d-%H.%M-%S')\n    # theDate = datetime.datetime.fromtimestamp( int(date) ).strftime('%Y-%m-%d %H:%M:%S')\n    theDate = str(theDate)\n    return theDate\n\ndef epoch2TextTimestamp( date ):\n    date = str( date )\n    try:\n        theDate = formatDate( date )\n    except Exception as e:\n        if not '.' in date and len( date ) > 10:\n            nDate = int( date )\n            date = nDate / 1000\n        theDate = datetime.datetime.fromtimestamp( float(date) ).strftime('%Y.%m.%d-%H.%M-%S')\n        # theDate = datetime.datetime.fromtimestamp( int(date) ).strftime('%Y-%m-%d %H:%M:%S')\n    theDate = str(theDate)\n    return theDate\n\ndef hasAlpha( data ):\n    data = str( data )\n    d = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'\n    result = False\n    for c in data:\n        if c in d:\n            result = True\n    return result\n\ndef hasInt( data ):\n    data = str( data )\n    d = '0123456789'\n    result = False\n    for c in data:\n        if c in d:\n            result = True\n    return result\n\ndef isInt( data ):\n    data = str( data )\n    d = '0123456789'\n    result = True\n    for c in data:\n        if not c in d:\n            result = False\n    return result\n\ndef isFloat( data ):\n    data = str( data )\n    result = True\n    if isInt( data ):\n        result = False\n    else:\n        try:\n            float( data )\n        except Exception as e:\n            result = False\n\n    return result\n\n\n\ndef isEpoch( data ):\n    result = True\n    try:\n        epoch2TextTimestamp( data )\n    except Exception as e:\n        result = False\n    return result\n\ndef date2epoch( theDate, delim='-' ):\n    theDate = str(theDate)\n    theDate = theDate.replace(delim,'-')\n    fdtl = theDate.split(delim)\n    try:\n        stmp = datetime.date(int(fdtl[0]), int(fdtl[1]), int(fdtl[2]))\n        result = float(time.mktime(stmp.timetuple()))\n    except Exception as e:\n        try:\n            stmp = datetime.date(int(fdtl[2]), int(fdtl[0]), int(fdtl[1]))\n            result = float(time.mktime(stmp.timetuple()))\n        except Exception as e:\n            result = False\n    \n    # stmp = datetime.datetime.strptime(theDate, '%Y-%m-%d')\n    return result\n\n\n\ndef singlDelim( data, newDelim='-' ):\n    data = str( data )\n    for x in findDelims( data ):\n        data = data.replace( x, newDelim )\n    return data\n\ndef hasYear( data ):\n    foundYear = False\n    for x in singlDelim( data ).split('-'):\n        if isInt( x ) and len( x ) == 4:\n            if int( x ) > 1000:\n                foundYear = True\n    return foundYear\n\ndef stripDelimBE( data, delim='-' ):\n    data = str( data )\n    delim = str( delim )\n    if data.startswith(delim):\n        data = data[1:]\n    if data.endswith(delim):\n        data = data[:-1]\n    return data\n\ndef removeDuplicatesDelim( data, delim='-' ):\n    data = str( data )\n    delim = str( delim )\n    dup = delim + delim\n    if dup in data:\n        done = False\n        while not done:\n            data = data.replace( dup, delim )\n            if not dup in data:\n                done = True\n    return data\n\ndef hasWeekday( data ):\n    data = str( data )\n    data = data.lower()\n    setA = 'sun mon tue wed thu fri sat'.split(' ')\n    setB = 'Sunday Monday Tuesday Wednesday Thursday Friday Saturday'.lower().split(' ')\n\n    result = False\n    for i,test in enumerate(setA):\n        if setA[i] in data or setB[i] in data:\n            result = True\n    return result\n\ndef hasTextMonth( data ):\n    data = str( data )\n    data = data.lower()\n    setA = 'jan feb mar apr may jun jul aug sep oct nov dec'.split(' ')\n    setB = 'January February March April May June July August September October November December'.lower().split(' ')\n\n    result = False\n    for i,test in enumerate(setA):\n        if setA[i] in data or setB[i] in data:\n            result = True\n    return result\n\ndef isWeekday( data ):\n    data = str( data )\n    data = data.lower()\n    setA = 'sun mon tue wed thu fri sat'.split(' ')\n    setB = 'Sunday Monday Tuesday Wednesday Thursday Friday Saturday'.lower().split(' ')\n\n    result = False\n    for i,test in enumerate(setA):\n        if data == setA[i] or data == setB[i]:\n            result = True\n    return result\n\n\ndef isMonth( data ):\n    data = str( data )\n    data = data.lower()\n    setA = 'jan feb mar apr may jun jul aug sep oct nov dec'.split(' ')\n    setB = 'January February March April May June July August September October November December'.lower().split(' ')\n\n    result = False\n    for i,test in enumerate(setA):\n        if data == setA[i] or data == setB[i]:\n            result = True\n    return result\n\ndef month2Number( data ):\n    data = str( data )\n    data = data.lower()\n    setA = 'jan feb mar apr may jun jul aug sep oct nov dec'.split(' ')\n    setB = 'January February March April May June July August September October November December'.lower().split(' ')\n\n    result = False\n    for i,test in enumerate(setA):\n        if data == setA[i] or data == setB[i]:\n            result = i+1\n    return padZero(result)\n\ndef removeDayOfWeek( data, delim='-' ):\n    data = str( data )\n    if hasWeekday( data ):\n        result = ''\n        for row in data.split(delim):\n            if not isWeekday( row ):\n                result += row + delim\n        data = removeDuplicatesDelim( result, delim )\n        data = stripDelimBE( data, delim )\n\n\n    return data\ndef isYear( data ):\n    result = False\n    data = str(data)\n    if isInt( data ) and len( data ) == 4:\n        result = True\n    return result\ndef validDay( data ):\n    result = False\n    data = str(data)\n    if isInt( data ):\n        if int( data ) < 32:\n            result = True\n    return result\ndef padZero( data, pad=2 ):\n    data = str(data)\n    l = len(data)\n    if not l == pad:\n        x = l\n        pre = ''\n        while not x == pad:\n            pre += '0'\n            x += 1\n        data = pre + data\n    return data\ndef cleanDate( data, delim='-' ):\n    data = str(data)\n    if delim in data:\n\n        y  = False\n        m  = False\n        d  = False\n        sData = data.split(delim)\n        if isMonth( sData[0] ):\n            m = month2Number( sData[0] )\n            if isYear( sData[1] ):\n                y = sData[1]\n                if validDay( sData[2] ):\n                    d = sData[2]\n                \n            if isYear( sData[2] ):\n                y = sData[2]\n                if validDay( sData[1] ):\n                    d = sData[1]\n        if isMonth( sData[1] ):\n            m = month2Number( sData[1] )\n\n            if isYear( sData[0] ):\n                y = sData[0]\n                if validDay( sData[2] ):\n                    d = sData[2]\n                \n            if isYear( sData[2] ):\n                y = sData[2]\n                if validDay( sData[0] ):\n                    d = sData[0]\n        if not type( y ) == bool and not type( m ) == bool and not type( d ) == bool:\n            sData[0] = y\n            sData[1] = m\n            sData[2] = d\n            result = ''\n            for row in sData:\n                result += row + delim\n            data = removeDuplicatesDelim( result, delim )\n            data = stripDelimBE( data, delim )\n    return data\n\n\n\ndef address24Hr( data, hr, delim='-' ):\n    data = str(data)\n    if hr == 12:\n        sData = data.split(delim)\n        if len( sData ) == 5 or len( sData ) == 4:\n            result = ''\n            for i,row in enumerate(sData):\n                if i == 3 and isInt( row ):\n                    row = str( int( row ) + 12 )\n                result += row + delim\n            data = removeDuplicatesDelim( result, delim )\n            data = stripDelimBE( data, delim )\n    return data\n\n\ndef autoDate( data, theFormat=False, fail=False ):\n    # print('data',data)\n    try:\n        import datefinder\n        for match in datefinder.find_dates(data):\n            # print( 'match.timestamp()', match.timestamp() )\n            return match.timestamp()\n    except Exception as e:\n        pass\n\n    if type(data) == float or type(data) == int:\n        return data\n    try:\n        if 'T' in data:\n            data = data.replace( 'T', ' ' )\n    except Exception as e:\n        pass\n        # print( data )\n    try:\n        if '+' in data:\n            data = data.split('+')[0]\n    except Exception as e:\n        pass\n\n    try:\n        float(data)\n        return False\n    except Exception as e:\n        pass\n\n    originalData = data\n    data = str( data )\n    if not hasInt( data ):\n        if fail:\n            print( 'Error: not a date', 0 )\n            sys.exit()\n        data = False\n    data = singlDelim( data )\n    data = data.lower()\n    data = data.replace( 't', '-' )\n    data = data.replace( 'at', '-' )\n    hr = 24\n    if 'pm' in data:\n        hr = 12\n    data = data.replace( 'am', '' ).replace( 'am', '' )\n    data = removeDuplicatesDelim( data )\n    data = stripDelimBE( data )\n    data = removeDayOfWeek( data )\n    data = cleanDate( data )\n    delims = findDelims( data )\n    \n\n    if type( theFormat ) == bool and not hasAlpha( data ):\n        if len( delims ) == 0:\n            if not isEpoch( data ):\n                if fail:\n                    print( 'Error: not a date', 1 )\n                    sys.exit()\n                data = False\n            else:\n                data = str( int( data ) / 1000 )\n        elif isEpoch( data ):\n            data\n            \n        else:\n            if not hasYear( data ):\n                if fail:\n                    print( 'Error: not a date', 2 )\n                    sys.exit()\n                data = False\n            else:\n                if len( delims ) == 2:\n                    data = date2epoch( data, delims[0] )\n                    if fail and type(data) == bool:\n                        print( 'Error: not a date', 3 )\n                        sys.exit()\n\n                elif len( delims ) == 5:\n                    sData = data.split('-')\n                    try:\n                        test = datetime.datetime.strptime( address24Hr( data, hr ), '%Y-%m-%d-%H-%M-%S' )\n                        data = test.timestamp()\n                    except Exception as e:\n                        if fail:\n                            print( 'Error: not a date', 4 )\n                            sys.exit()\n                        data = False\n                elif len( delims ) == 4:\n                    sData = data.split('-')\n                    try:\n                        test = datetime.datetime.strptime( address24Hr( data, hr ), '%Y-%m-%d-%H-%M' )\n                        data = test.timestamp()\n                    except Exception as e:\n                        if fail:\n                            print( 'Error: not a date', 5 )\n                            sys.exit()\n                        data = False\n                else:\n                    if fail:\n                        print( 'Error: not a date', 6 )\n                        sys.exit()\n                    data = False\n\n    if not type( data ) == bool:\n        if isFloat( data ):\n            data = float( data )\n\n    d = str(data)\n    if d.endswith('.0'):\n        d = d.replace('.0','')\n        data = int(d)\n    return data\n\n\n\n")
    __stickytape_write_module('_rightThumb/_bookmarks/__init__.py', b"#!/usr/bin/python3\n\n# ## {R2D2919B742E} ##\n# ###########################################################################\n# What if magic existed?\n# What if a place existed where your every thought and dream come to life.\n# There is only one catch: it has to be written down.\n# Such a place exists, it is called programming.\n#    - Scott Taylor Reph, RightThumb.com\n# ###########################################################################\n# ## {C3P0D40fAe8B} ##\n\nimport os, sys, time\n##################################################\nimport _rightThumb._construct as __\nappDBA = __.clearFocus( __name__, __file__ )\n__.appReg = appDBA\ndef focus( parentApp='', childApp='', reg=True ):\n    global appDBA\n    f = __.appName( appDBA, parentApp, childApp )\n    if reg:\n        __.appReg = f\n    return f\n__.registeredApps.append( focus() )\nimport _rightThumb._base3 as _\n_.load()\n##################################################\nimport _rightThumb._vars as _v\nimport _rightThumb._string as _str\n##################################################\n\n\ndef appSwitches():\n    pass\n    # _.switches.register( 'Alias', '-a' )\n    # _.switches.register( 'Save', '-save' )\n    # _.switches.register( 'm', '-m' )\n    # _.switches.register( 'b', '-b' )\n\n\n_.autoBackupData = __.autoCreationConfiguration['backup']\n__.isRequired_Pipe = False\n__.isRequired_Pipe_or_File = False\n__.pre_error = False\n# __.isRequired_or_List = ['Pipe','Files','Plus']\n\n_.appInfo[focus()] = {\n    'file': 'bookmarks.py',\n    'liveAppName': __.thisApp( __file__ ),\n    'description': 'manage bookmarks',\n    'categories': [\n                        'bm',\n                        'bookmarks',\n                        'manage',\n                        'system',\n                ],\n    'usage': [\n                        # 'epy another',\n                        # 'e nmap',\n                        # '',\n    ],\n    'relatedapps': [\n                        # 'p another -file file.txt',\n                        # '',\n    ],\n    'prerequisite': [\n                        # 'p another -file file.txt',\n                        # '',\n    ],\n    'examples': [\n                        '',\n                        '',\n    ],\n    'columns': [\n                       # { 'name': 'name', 'abbreviation': 'n' },\n                       # { 'name': '{1}', 'abbreviation': '{0}', 'sort': '{2}' },\n    ],\n    'aliases': [\n                       # 'this',\n                       # 'app',\n    ],\n    'notes': [\n                       # {},\n    ],\n}\n\n_.appData[focus()] = {\n        'start': __.startTime,\n        'uuid': '',\n        'audit': [],\n        'pipe': False,\n        'data': {\n                    'field': {'sent': [], 'received': [] }, # { 'label': '', 'context': [],  }\n                    'table': {'sent': [], 'received': [] }, \n        },\n    }\n\n\n\ndef registerSwitches( argvProcessForce=False ):\n    global appDBA\n    if not __.appReg == appDBA and appDBA in __.appReg:\n\n        if not __name__ == '__main__':\n            _.argvProcess = argvProcessForce\n        else:\n            _.argvProcess = True\n\n        _.load()\n        _.appInfo[__.appReg] = _.appInfo[appDBA]\n        _.appData[__.appReg] = _.appData[appDBA]\n    __.constructRegistration( _.appInfo[__.appReg]['file'],__.appReg )\n    appSwitches()\n\n    _.myFileLocation_Print = False\n    __.myFileLocations_SKIP_VALIDATION = False\n    _.switches.trigger( 'Files', _.myFileLocations )\n    _.switches.trigger( 'Folder', _.myFolderLocations )\n    _.switches.trigger( 'URL', _.urlTrigger )\n    ### EXAMPLE: START\n    # _.switches.trigger( 'Files',_.inRelevantFolder )\n    \n    # _.switches.trigger( 'Watched', _.txt2Date )\n    # _.switches.trigger( 'Input',_.formatColumns )\n    # _.switches.trigger( 'Franchise',_.triggerSpace )\n    ### EXAMPLE: END\n    \n    _.defaultScriptTriggers()\n    _.switches.process()\n\n\nif not __name__ == '__main__':\n    _.argvProcess = False\nelse:\n    _.argvProcess = True\n\nregisterSwitches()\n\n\ndef fieldSet( switchName, switchField, switchValue, theFocus=False ):\n    if not type( theFocus ) == bool:\n        theFocus = theFocus\n    _.switches.fieldSet( switchName, switchField, switchValue, theFocus )\n\n\nif __name__ == '__main__':\n    if not sys.stdin.isatty():\n        _.setPipeData( sys.stdin.readlines(), __.appReg, clean=True )\n\n\n_.postLoad( __file__ )\n\n\n########################################################################################\n\ndef c41(strin):\n    return strin.replace('\\\\',os.sep).replace('/',os.sep)\n\nclass Bookmarks:\n    def __init__( self, alias=None, path=None ):\n        self.index = _.getTable( 'bookmarks.index' )\n        if self.index == {}:\n            self.index = {\n                            'labels': {},\n                            'paths': {},\n            }\n\n        self.current = os.getcwd()\n        self.alias = alias\n        self.path = path\n        self.folder = None\n\n        if path is None:\n            self.bm = 'b'\n        else:\n            self.bm = 'm'\n\n    pass\n    \n\n\n    def sanitize( self, path=None ):\n        if not path is None: self.folder = _v.sanitizeFolder( path );\n        else: self.folder = _v.sanitizeFolder( self.path );\n        return c41(self.folder)\n\n    def resolve( self, path ):\n        self.folder = _v.resolveFolderIDs(path)\n        if not _.isWin: self.folder = self.folder.replace( '\\\\', '/' );\n        return c41(self.folder)\n\n    def file( self ):\n        return _v.bookmarkFormat.replace( 'ALIASHERE', self.alias )\n\n    def log( self ):\n        log = _.getTable( 'bookmarks.logs' )\n        if not self.bm in log: log[self.bm] = [];\n        log[self.bm].append({ 'epoch': time.time(), 'alias': self.alias, 'location': self.folder, 'session': _v.session() })\n        _.saveTable( log, 'bookmarks.logs', p=0 )\n\n    ###########################################################################################\n    def save( self ):\n        b = self.file()\n        p = self.sanitize()\n        _.saveText( p, b )\n\n        if self.alias in self.index['labels'].keys():\n            old = self.index['labels'][self.alias]\n            if p in self.index['paths'].keys():\n                nX = []\n                for record in self.index['paths'][p]:\n                    if not record == self.alias:\n                        nX.append( record )\n                self.index['paths'][p] = nX\n            if not _.switches.isActive('Clean'):\n                _.colorThis( [  '\\told', old  ], 'yellow' )\n            if os.path.isdir(  self.resolve(old)  ):\n                status = 'still exists'\n                if not _.switches.isActive('Clean'):\n                    _.colorThis( [  '\\t\\t', status  ], 'green' )\n            else:\n                status = 'no longer exists'\n                if not _.switches.isActive('Clean'):\n                    _.colorThis( [  '\\t\\t', status  ], 'red' )\n        self.index['labels'][self.alias] = p\n        self.index['labels'][self.alias.lower()] = p\n\n        if p in self.index['paths'].keys():\n            self.index['paths'][p].append( self.alias )\n        else:\n            self.index['paths'][p] = []\n            if not self.alias in self.index['paths'][p]:\n                self.index['paths'][p].append( self.alias )\n        _.saveTable( self.index, 'bookmarks.index', p=0 )\n        if not _.switches.isActive('Clean'):\n            _.colorThis( [  self.alias, self.current  ], 'cyan' )\n        self.log()\n        return c41(self.folder)\n    ###########################################################################################\n    def get( self ):\n        if not self.alias in self.index['labels'] and not self.alias.lower() in self.index['labels']:\n\n            return None\n        try:\n            self.resolve( self.index['labels'][self.alias] )\n        except Exception as e:\n            self.resolve( self.index['labels'][self.alias.lower()] )\n\n        self.log()\n        return c41(self.folder)\n\ndef action():\n    pass\n\nmade={}\nif 'wprofile' in _v.config_hash:\n    made['h'] = 1\n    h  = _v.config_hash['wprofile']\nif 'ww' in _v.config_hash:\n    made['ww'] = 1\n    ww = _v.config_hash['ww']\n# _.pr('made',made)\nif 'ww' in made  and 'h' in made:\n    try:\n        a = ww+os.sep+'databank'+os.sep+'tables'+os.sep+'bookmarks.index'\n        b = h+os.sep+'tables'+os.sep+'bookmarks.index'\n        if not os.path.isfile(b) and os.path.isfile(a):\n            from shutil import copyfile\n            copyfile(a,b)\n    except Exception as e:\n        pass\n\n\n########################################################################################\nif __name__ == '__main__':\n    action()\n\n\n\n\n\n\n")
    __stickytape_write_module('_rightThumb/_dir/__init__.py', b'# import _rightThumb._dir as _dir\n\n# ## {R2D2919B742E} ##\n# ###########################################################################\n# What if magic existed?\n# What if a place existed where your every thought and dream come to life.\n# There is only one catch: it has to be written down.\n# Such a place exists, it is called programming.\n#    - Scott Taylor Reph, RightThumb.com\n# ###########################################################################\n# ## {C3P0D40fAe8B} ##\n\n# import sys\nimport os, subprocess\nfrom os.path import join, getsize, isfile, isdir, splitext\nfrom datetime import datetime as dt, timedelta\nimport datetime\nfrom datetime import date\n# from dateutil import rrule\ntry:\n    import dateutil.relativedelta\nexcept Exception as e:\n    pass\n    \nimport time\n\nfrom pathlib import Path\n\nimport _rightThumb._construct as __\nimport _rightThumb._vars as _v\nimport _rightThumb._md5 as _md5\nimport _rightThumb._mimetype as _mime\nimport hashlib\nimport simplejson as json\n\n###########################################\n#               HOW TO USE\n\n# import _rightThumb._dir as _dir\n# _dir.info(path)\n# _dir.fileInfo(path)\n\n# specify asset or ** _dir.commit() ** at end \n\n# _dir.sqlCreateTable( \'dir_temp.db\' , asset=files, delete=True )\n# for file in files:\n#     _dir.fileInfo( file, sql=True, insert=True )\n\n        # modified = os.path.getmtime(aPath)\n        # created = os.path.getctime(aPath)\n\n###########################################\n"""\n\n[\n    {\n        "path": "D:\\\\tech\\\\programs\\\\python\\\\src\\\\windows\\\\5e.py",\n        "name_": "5e.py",\n        "name": "5e.py",\n        "folder": "D:\\\\tech\\\\programs\\\\python\\\\src\\\\windows",\n        "stat": [\n            33206,\n            562949953429741,\n            1319441880,\n            1,\n            0,\n            0,\n            7361,\n            1606402282,\n            1603981112,\n            1606402282\n        ],\n        "bytes": 7361,\n        "size": "7.19 KB",\n        "date_created_raw": 1606402282.416147,\n        "date_modified_raw": 1603981112.0,\n        "date_created": "2020-11-26 07:51:22",\n        "date_modified": "2020-10-29 08:18:32",\n        "type": "File",\n        "typesort": 1,\n        "ext": "py",\n        "week_of_year": "2020.44",\n        "week_of_year_": 44,\n        "day_of_the_week": "Thursday",\n        "month": "2020.10",\n        "friendly_week": "",\n        "friendly_month": "",\n        "md5": "",\n        "year": 2020,\n        "accessed_raw": 1606402282.416147,\n        "date_accessed": "2020-11-26 07:51:22",\n        "ce": 1606402282.416147,\n        "me": 1603981112.0,\n        "ae": 1606402282.416147\n    }\n]\n\n\n"""\n\ndef size_group(s):\n\n    if type(s) == str:\n        s = unFormatSize(s)\n\n    if s == 0:\n        return 0\n    groups = [{"l": "1", "s": "500", "x": "kb"}, {"l": "2", "s": "1", "x": "mb"}, {"l": "3", "s": "5", "x": "mb"}, {"l": "4", "s": "10", "x": "mb"}, {"l": "5", "s": "20", "x": "mb"}, {"l": "6", "s": "50", "x": "mb"}, {"l": "7", "s": "200", "x": "mb"}, {"l": "8", "s": "500", "x": "mb"}, {"l": "9", "s": "1", "x": "gb"}, {"l": "10", "s": "5", "x": "gb"}, {"l": "11", "s": "10", "x": "gb"}, {"l": "12", "s": "20", "x": "gb"}, {"l": "13", "s": "50", "x": "gb"}, {"l": "14", "s": "200", "x": "gb"}, {"l": "15", "s": "500", "x": "gb"}, {"l": "16", "s": "1", "x": "tb"}, {"l": "17", "s": "5", "x": "tb"}, {"l": "18", "s": "10", "x": "tb"}, {"l": "19", "s": "20", "x": "tb"}, {"l": "20", "s": "50", "x": "tb"}, {"l": "21", "s": "200", "x": "tb"}, {"l": "22", "s": "500", "x": "tb"}, {"l": "23", "s": "1", "x": "pb"}, {"l": "24", "s": "5", "x": "pb"}, {"l": "25", "s": "10", "x": "pb"}, {"l": "26", "s": "20", "x": "pb"}, {"l": "27", "s": "50", "x": "pb"}, {"l": "28", "s": "200", "x": "pb"}, {"l": "29", "s": "500", "x": "pb"}, {"l": "30", "s": "1", "x": "eb"}, {"l": "31", "s": "5", "x": "eb"}, {"l": "32", "s": "10", "x": "eb"}, {"l": "33", "s": "20", "x": "eb"}, {"l": "34", "s": "50", "x": "eb"}, {"l": "35", "s": "200", "x": "eb"}, {"l": "36", "s": "500", "x": "eb"}, {"l": "37", "s": "1", "x": "zb"}, {"l": "38", "s": "5", "x": "zb"}, {"l": "39", "s": "10", "x": "zb"}, {"l": "40", "s": "20", "x": "zb"}, {"l": "41", "s": "50", "x": "zb"}, {"l": "42", "s": "200", "x": "zb"}, {"l": "43", "s": "500", "x": "zb"}, {"l": "44", "s": "1", "x": "yb"}, {"l": "45", "s": "5", "x": "yb"}, {"l": "46", "s": "10", "x": "yb"}, {"l": "47", "s": "20", "x": "yb"}, {"l": "48", "s": "50", "x": "yb"}, {"l": "49", "s": "200", "x": "yb"}, {"l": "50", "s": "500", "x": "yb"}]\n    groups.reverse()\n    last = 0\n\n    for rec in groups:\n        un = rec[\'s\']+rec[\'x\']\n        fo = unFormatSize(un)\n        # _.pr(fo)\n        print\n        if s >= fo:\n            return int(rec[\'l\'])\n    return 1\n\ndef size_group2(s):\n    if s < 10:\n        return \'0\'+str(s)\n    else:\n        return str(s)\n\n\ntouch_meta = None\n\ntimeAudit = []\ntimeAuditCollect = False\n\ncommitPer = 46285\n# commitPer = 46,285\n\n\nmaxFileNameLength = 35\ndateCalcByModified = True\n\nif not os.path.isdir( _v.exif_temp ):\n    os.mkdir( _v.exif_temp )\n\ndef fileAge( file ):\n    md = fileInfo( file )[\'date_modified_raw\']\n    return time.time() - md\n\n\ndef acquireExif( info ):\n    try:\n        do = \'exiftool "THEFILE" -json > MOD_BYTES.json\'\n        MOD_BYTES = \'MOD_BYTES.json\'\n        doThis = do.replace( \'THEFILE\', info[\'path\'] )\n        doThis = doThis.replace( \'MOD_BYTES\', _v.exif_temp +_v.slash+ str(info[\'date_modified_raw\'])+\'_\'+str(info[\'bytes\']) )\n        MOD_BYTES = MOD_BYTES.replace( \'MOD_BYTES\', _v.exif_temp +_v.slash+ str(info[\'date_modified_raw\'])+\'_\'+str(info[\'bytes\']) )\n        os.system(\'"\' + doThis + \'"\')\n        return getTable2( MOD_BYTES )\n    except Exception as e:\n        return [{}]\n\n\n\n\ndef getTable2( theFile ):\n    if os.path.isfile( theFile ):\n        with open( theFile,\'r\', encoding=\'latin-1\' ) as json_file:\n            json_data = json.load( json_file )\n            # json_data = json.load(json_file, object_pairs_hook=OrderedDict)\n        return json_data\n    else:\n        return [{}]\n\n\n\n\ndef epoch( path ):\n    return os.path.getmtime( path )\n\ndef getSize(path):\n    stat = os.stat(path)\n    size = stat.st_size\n    return size\n\n\nconn = None\ncursor = None\ntotal_records = 0\ndef sqlCreateTable( db, deleteDBFirst=False, close=False, asset=None, length=None, delete=None ):\n    global total_records\n    global conn\n    global cursor\n    import sqlite3\n\n    if not length is None:\n        if type(length) == int:\n            total_records = length\n\n    if not asset is None:\n        if type(asset) == int:\n            total_records = asset\n        elif type(asset) == list:\n            total_records = len(asset)\n            # _.pr( type(asset) )\n\n        # pause = input( \'pause: \' )\n    if not delete is None:\n        deleteDBFirst = delete\n\n\n    if deleteDBFirst:\n        try:\n            os.unlink(db)\n        except Exception as e:\n            pass\n            \n    conn = sqlite3.connect(db)\n    cursor = conn.cursor()\n    sql =  \'CREATE TABLE files (path text, name_ text, name text, folder text, stat text, attrib text, bytes int, size text, date_created_raw double, date_modified_raw double, date_created text, date_modified text, type text, typesort text, ext text, week_of_year text, week_of_year_ text, day_of_the_week text, month text, friendly_week text, friendly_month text, accessed_raw double, date_accessed text                        , ce double, me double, ae double, meta text, header text, err int        )\'\n    cursor.execute( sql )\n    if close:\n        conn.close()\n    else:\n        return conn, cursor\n    \n\n\n# def insert( path, sql=True, md5=False, exif=0,   attrib=None, mime=None, db_connection=None, db_cursor=None, count=None, last ):\n#     global conn\n#     global cursor\n#     record = fileInfo( path, sql, md5, exif, attrib, mime, db_connection, db_cursor, count )\n#     if record is None:\n#         _.pr( \'Error:\', path )\n#     else:\n#         cursor.execute( record )\ncommit_count = 0\nprocessed_count = 0\n# NOTE:\n#         sdate finds oldest or newsest date in accessed modified created\ndef info( path, sql=False, md5=False, exif=0,   attrib=None, mime=None, db_connection=None, db_cursor=None, count=None, insert=None, last=False, sdate=None, meta=True, err=False,       subject=None, k=None, f=None, s=None, sub=None, field=None ):\n    if not field is None: subject=field;\n    if not sub is None: subject=sub;\n    if not s is None: subject=s;\n    if not k is None: subject=k;\n    if not f is None: subject=f;\n    sub=subject\n    return fileInfo( path=path, sql=sql, md5=md5, exif=exif,   attrib=attrib, mime=mime, db_connection=db_connection, db_cursor=db_cursor, count=count, insert=insert, last=last, sdate=sdate, meta=meta, err=err, subject=subject )\ndef fileInfo( path, sql=False, md5=False, exif=0,   attrib=None, mime=None, db_connection=None, db_cursor=None, count=None, insert=None, last=False, sdate=None, meta=True, err=False, subject=None ):\n    global processed_count\n    global total_records\n    processed_count += 1\n    # _.pr( processed_count, total_records )\n    if processed_count == total_records:\n        last = True\n\n    if not insert is None:\n        if insert:\n            global conn\n            global cursor\n            db_connection = conn\n            db_cursor = cursor\n            count = processed_count\n            # _.pr( \'here\', type(db_cursor) )\n            # import sys\n            # sys.exit()\n\n    if err:\n        return fileInfoAction( path, sql, md5, exif, attrib, mime, db_connection, db_cursor, count, insert, last, sdate, meta, subject )\n    else:\n        try:\n            return fileInfoAction( path, sql, md5, exif, attrib, mime, db_connection, db_cursor, count, insert, last, sdate, meta, subject )\n        except Exception as e:\n            return False\n\ndef _woy_(epoch):\n    weekAndYear=round(getWOYFromEpoch(epoch) * 0.01,2) + getYearFromEpoch(epoch); weekAndYear = str(weekAndYear);\n    if len(weekAndYear) == 6: weekAndYear += \'0\';\n    return weekAndYear\n\ndef _header_(path):\n        global header\n        theHeader = \'\'\n        if header:\n            theHeader = " ".join([\'{:02X}\'.format(byte) for byte in     open( path, \'rb\' ).read(32)    ])\n            if type(header) == int:\n                theHeader = theHeader[0:header*3]\n        return theHeader\n\ndef individual(path,subject):\n    path=__.path(path)\n    # return info(path)\n    # fields=\' path name folder stat bytes size date_created_raw date_modified_raw date_created date_modified type typesort ext week_of_year week_of_year_ day_of_the_week month friendly_week friendly_month md5 year accessed_raw date_accessed ce me ae meta ago header error group \':\n    # if not subject in fields: return info(path);\n    dic={}\n    if \' path \' in \' \'+subject+\' \': dic[\'path\'] =  os.path.realpath(path);\n    if \' name \' in \' \'+subject+\' \': dic[\'name\'] =  Path(path).name;\n    if \' folder \' in \' \'+subject+\' \': dic[\'folder\'] =  os.path.dirname(path);\n    if \' stat \' in \' \'+subject+\' \': dic[\'stat\'] =  os.stat(path);\n    if \' bytes \' in \' \'+subject+\' \': dic[\'bytes\'] =  os.stat(path).st_size;\n    if \' size \' in \' \'+subject+\' \': dic[\'size\'] = formatSize(os.stat(path).st_size) ;\n    if \' date_created_raw \' in \' \'+subject+\' \': dic[\'date_created_raw\'] =  os.path.getctime(path);\n    if \' date_modified_raw \' in \' \'+subject+\' \': dic[\'date_modified_raw\'] =  os.path.getmtime(path);\n    if \' date_created \' in \' \'+subject+\' \': dic[\'date_created\'] =  formatDate(os.path.getctime(path));\n    if \' created \' in \' \'+subject+\' \': dic[\'date_created\'] =  formatDate(os.path.getctime(path));\n    if \' date_modified \' in \' \'+subject+\' \': dic[\'date_modified\'] =  formatDate(os.path.getmtime(path));\n    if \' modified \' in \' \'+subject+\' \': dic[\'date_modified\'] =  formatDate(os.path.getmtime(path));\n    if \' fd \' in \' \'+subject+\' \': dic[\'date_modified\'] =  formatDate(os.path.getmtime(path));\n    if \' type \' in \' \'+subject+\' \': dic[\'type\'] = (\'File\' if os.path.isfile(path) else \'Folder\');\n    if \' typesort \' in \' \'+subject+\' \': dic[\'typesort\'] =  (1 if os.path.isfile(path) else 0);\n    if \' ext \' in \' \'+subject+\' \': dic[\'ext\'] =  getExtension(Path(path).name);\n    if \' week_of_year \' in \' \'+subject+\' \': dic[\'week_of_year\'] =  _woy_(os.path.getmtime(path));\n    if \' day_of_the_week \' in \' \'+subject+\' \': dic[\'day_of_the_week\'] =  getDOWromEpochText(os.path.getmtime(path));\n    if \' dow \' in \' \'+subject+\' \': dic[\'dow\'] =  getDOWromEpochText(os.path.getmtime(path));\n    if \' month \' in \' \'+subject+\' \': dic[\'month\'] =  str(getYearFromEpoch(os.path.getmtime(path))) + \'.\' + str(formatDateMonth(os.path.getmtime(path)))\n    if \' friendly_week \' in \' \'+subject+\' \': dic[\'friendly_week\'] =  friendlyWeekNew(os.path.getmtime(path));\n    if \' fw \' in \' \'+subject+\' \': dic[\'fw\'] =  friendlyWeekNew(os.path.getmtime(path));\n    if \' friendly_month \' in \' \'+subject+\' \': dic[\'friendly_month\'] =  friendlyMonthNew(os.path.getmtime(path));\n    if \' fm \' in \' \'+subject+\' \': dic[\'fm\'] =  friendlyMonthNew(os.path.getmtime(path));\n    if \' md5 \' in \' \'+subject+\' \': dic[\'md5\'] =  _md5.md5File(path);\n    if \' year \' in \' \'+subject+\' \': dic[\'year\'] =  getYearFromEpoch(os.path.getmtime(path));\n    if \' accessed_raw \' in \' \'+subject+\' \': dic[\'accessed_raw\'] =  os.path.getatime(path);\n    if \' date_accessed \' in \' \'+subject+\' \': dic[\'date_accessed\'] =  formatDate(os.path.getatime(path));\n    if \' accessed \' in \' \'+subject+\' \': dic[\'accessed\'] =  formatDate(os.path.getatime(path));\n    if \' ce \' in \' \'+subject+\' \': dic[\'ce\'] =  os.path.getctime(path);\n    if \' cef \' in \' \'+subject+\' \': dic[\'ce\'] =  formatDate(os.path.getctime(path));\n    if \' me \' in \' \'+subject+\' \': dic[\'me\'] =  os.path.getmtime(path);\n    if \' mef \' in \' \'+subject+\' \': dic[\'me\'] =  formatDate(os.path.getmtime(path));\n    if \' ae \' in \' \'+subject+\' \': dic[\'ae\'] =  os.path.getatime(path);\n    if \' aef \' in \' \'+subject+\' \': dic[\'ae\'] =  formatDate(os.path.getatime(path));\n    if \' woy \' in \' \'+subject+\' \': dic[\'me\'] =  _woy_(os.path.getmtime(path));\n    if \' me-woy \' in \' \'+subject+\' \': dic[\'me\'] =  _woy_(os.path.getmtime(path));\n    if \' mwoy \' in \' \'+subject+\' \': dic[\'me\'] =  _woy_(os.path.getmtime(path));\n    if \' ce-woy \' in \' \'+subject+\' \': dic[\'me\'] =  _woy_(os.path.getctime(path));\n    if \' cwoy \' in \' \'+subject+\' \': dic[\'me\'] =  _woy_(os.path.getctime(path));\n    if \' awoy \' in \' \'+subject+\' \': dic[\'me\'] =  _woy_(os.path.getatime(path));\n    if \' ae-woy \' in \' \'+subject+\' \': dic[\'me\'] =  _woy_(os.path.getatime(path));\n    if \' ae-woy \' in \' \'+subject+\' \': dic[\'me\'] =  _woy_(os.path.getatime(path));\n    if \' ago \' in \' \'+subject+\' \': dic[\'ago\'] =  dateDiffText(os.path.getmtime(path));\n    if \' me-ago \' in \' \'+subject+\' \': dic[\'ago\'] =  dateDiffText(os.path.getmtime(path));\n    if \' ce-ago \' in \' \'+subject+\' \': dic[\'ago\'] =  dateDiffText(os.path.getctime(path));\n    if \' header \' in \' \'+subject+\' \': dic[\'header\'] =  _header_(path);\n    if \' head \' in \' \'+subject+\' \': dic[\'head\'] =  _header_(path);\n    if \' group \' in \' \'+subject+\' \': dic[\'group\'] =  size_group(os.stat(path).st_size);\n    if \' sg \' in \' \'+subject+\' \': dic[\'group\'] =  size_group(os.stat(path).st_size);\n\n    # if \' meta \' in \' \'+subject+\' \': dic[\'meta\'] =  run(path,subject);\n    if not dic: return info(path);\n    k=list(dic.keys())\n    if len(k) == 1: return dic[k[0]];\n    return dic\n# \'Key.alt\', \'Key.cmd\', \'1\'\n# p -paste | p line --c -make "if subject == \'{}\': return run(path,subject);"\n# p -paste | p line --c -make "if \' {} \' in \' \'+subject+\' \': dic[\'{}\'] =  run(path,subject);"\n\ndef fileInfoAction( path, sql, md5, exif, getAttrib=None, getMime=None, db_connection=None, db_cursor=None, count=None, insert=None, last=False, sdate=None, meta=True, subject=None ):\n    global touch_meta\n    global dateCalcByModified\n    global timeAudit\n    global timeAuditCollect\n\n    if not subject is None: return individual(path,subject);\n\n    hasError = 0\n\n\n    error = False\n\n    epoch = []\n    epoch.append({ \'label\': \'start\', \'epoch\': time.time() })\n\n    md5\n    aPath = os.path.abspath(path)\n    if os.path.isfile(aPath):\n        ty = \'File\'\n        typesort = 1\n    elif os.path.isdir(aPath):\n        ty = \'Folder\'\n        typesort = 0\n    else:\n        error = True\n\n    epoch.append({ \'label\': \'pre\', \'epoch\': time.time() })\n    if not error:\n        # dateCalcByModified = True\n        if not getAttrib is None:\n            attri = attrib(aPath)\n            epoch.append({ \'label\': \'attrib\', \'epoch\': time.time() })\n            attribs = getAttribs(attri)\n            epoch.append({ \'label\': \'getAttribs\', \'epoch\': time.time() })\n        name = Path(path).name\n        epoch.append({ \'label\': \'Path\', \'epoch\': time.time() })\n        path2 = os.path.realpath(aPath)\n        epoch.append({ \'label\': \'realpath\', \'epoch\': time.time() })\n        createdRaw = os.path.getctime(aPath)\n        modifiedRaw = os.path.getmtime(aPath)\n\n        if modifiedRaw == 0:\n            # EPOCH-ERROR-FAIL\n            modifiedRaw = time.time()\n            hasError = 1\n        if createdRaw == 0:\n            # EPOCH-ERROR-FAIL\n            createdRaw = time.time()\n            hasError = 2\n\n        epoch.append({ \'label\': \'get_time\', \'epoch\': time.time() })\n        stat = os.stat(aPath)\n        size = stat.st_size\n        sizeF = formatSize(size)\n        epoch.append({ \'label\': \'size\', \'epoch\': time.time() })\n        ext = getExtension(name)\n        folder = os.path.dirname(aPath)\n        epoch.append({ \'label\': \'dirname\', \'epoch\': time.time() })\n        mwoy = getWOYFromEpoch(modifiedRaw)\n        myear = getYearFromEpoch(modifiedRaw)\n        cwoy = getWOYFromEpoch(createdRaw)\n        cyear = getYearFromEpoch(createdRaw)\n\n        accessed_raw = os.path.getatime(aPath)\n\n        if not sdate is None:\n            sdate_raw = createdRaw\n            if \'o\' in sdate:\n                if modifiedRaw > sdate_raw:\n                    sdate_raw = modifiedRaw\n                if accessed_raw > sdate_raw:\n                    sdate_raw = accessed_raw\n\n            elif \'n\' in sdate:\n                if modifiedRaw < sdate_raw:\n                    sdate_raw = modifiedRaw\n                if accessed_raw < sdate_raw:\n                    sdate_raw = accessed_raw\n        \n        if dateCalcByModified:\n            woy = mwoy\n            year = myear\n            calcBy = modifiedRaw\n            # _.pr(\'mwoy\')\n            woyBY = \'.m\'\n        else:\n            woyBY = \'.c\'\n            # _.pr(\'cwoy\')\n            woy = cwoy\n            year = cyear\n            calcBy = createdRaw\n        # _.pr(\'dateCalcByModified\', dateCalcByModified)\n        thisweek = getWOYFromEpoch(time.time())\n        weekAndYear = round(woy * 0.01,2) + year\n        dow = getDOWromEpochText(calcBy)\n        friendlyWeek1 = friendlyWeekNew(calcBy)\n        friendlyMonth1 = friendlyMonthNew(calcBy)\n        # month = round(int(formatDateMonth(modifiedRaw))* 0.01,2) + year\n        month = str(year) + \'.\' + str(formatDateMonth(calcBy))\n        epoch.append({ \'label\': \'week_and_year\', \'epoch\': time.time() })\n\n        md5Data = \'\'\n\n        shouldMD5 = False\n        if type( md5 ) == bool:\n            if md5:\n                shouldMD5 = True\n        else:\n            shouldMD5 = True\n\n            if modifiedRaw > float(md5[0]):\n                shouldMD5 = True\n            else:\n                shouldMD5 = False\n                md5Data = md5[1]\n        # _.pr( \'shouldMD5:\', shouldMD5 )\n        if shouldMD5:\n            # _.pr( \'shouldMD5:\', shouldMD5 )\n            # _.pr()\n            # _.pr( \'Processing:\', path2 )\n            try:\n                md5Data = _md5.md5File( path2 )\n            except Exception as e:\n                pass\n                \n            # _.pr( md5Data )\n            # _.pr( \'md5File\', md5Data, path2 )\n            # try:\n            # except Exception as e:\n            #     pass\n        epoch.append({ \'label\': \'md5:\'+str(shouldMD5), \'epoch\': time.time() })\n        \n        if not getMime is None:\n            try:\n                if _mime.isText(path2):\n                    mime = \'Text\'\n                else:\n                    mime = \'Binary\'\n            except Exception as e:\n                mime = \'\'\n            epoch.append({ \'label\': \'mime\', \'epoch\': time.time() })\n        weekAndYear = str(weekAndYear)\n        if len(weekAndYear) == 6:\n            weekAndYear += \'0\' \n\n        # _.pr( dateDiffText(calcBy) )\n        global header\n        theHeader = \'\'\n        if header:\n            theHeader = " ".join([\'{:02X}\'.format(byte) for byte in     open( aPath, \'rb\' ).read(32)    ])\n            if type(header) == int:\n                theHeader = theHeader[0:header*3]\n\n        obj = {\n                \'path\': path2,\n                \'name_\': fileNameLength(name,ext),\n                \'name\': name,\n                \'folder\': folder,\n                \'stat\': stat,\n                \'bytes\': size,\n                \'size\': sizeF,\n                \'date_created_raw\': createdRaw,\n                \'date_modified_raw\': modifiedRaw,\n                \'date_created\': formatDate(createdRaw),\n                \'date_modified\': formatDate(modifiedRaw),\n                \'type\': ty,\n                \'typesort\': typesort,\n                \'ext\': ext,\n                \'week_of_year\': weekAndYear,\n                \'week_of_year_\': woy,\n                \'day_of_the_week\': dow,\n                \'month\': month,\n                \'friendly_week\': friendlyWeek1,\n                \'friendly_month\': friendlyMonth1,\n                \'md5\': md5Data,\n                \'year\': year,\n                \'accessed_raw\': accessed_raw,\n                \'date_accessed\': formatDate(accessed_raw),\n                \'ce\': createdRaw,\n                \'me\': modifiedRaw,\n                \'ae\': accessed_raw,\n                \'meta\': {},\n                \'ago\': dateDiffText(calcBy),\n                \'header\': theHeader,\n                \'error\': hasError,\n                \'group\': size_group(size),\n        }\n        if not type(obj[\'bytes\']) == int:\n            # _.pr(\'here\')\n            # sys.exit()\n            obj[\'bytes\'] = 0\n\n        if not sdate is None:\n            # _.pr(sdate_raw)\n            obj[\'sdate\'] = formatDate(sdate_raw)\n            obj[\'sdate_raw\'] = sdate_raw\n            obj[\'de\'] = sdate_raw\n            obj[\'cps\'] = ps_timestamp(createdRaw)\n            obj[\'mps\'] = ps_timestamp(modifiedRaw)\n            obj[\'aps\'] = ps_timestamp(accessed_raw)\n            obj[\'dps\'] = ps_timestamp(sdate_raw)\n\n        if touch_meta is None:\n            touch_meta = getTable(\'touch.meta\')\n\n        if path2 in touch_meta:\n            touch_meta[path2]\n            obj[\'meta\'] = touch_meta[path2]\n\n            if meta:\n                if \'epoch\' in obj[\'meta\']:\n                    obj[\'meta\'][\'epoch-bk\'] = {}\n                    if \'ce\' in obj[\'meta\'][\'epoch\']:\n                        obj[\'meta\'][\'epoch-bk\'][\'ce\'] = obj[\'ce\']\n                        obj[\'meta\'][\'epoch-bk\'][\'date_created\'] = obj[\'date_created\']\n                        obj[\'ce\'] = obj[\'meta\'][\'epoch\'][\'ce\']\n                        obj[\'date_created_raw\'] = obj[\'ce\']\n                        obj[\'date_created\'] = formatDate(obj[\'ce\'])\n                    \n                    if \'me\' in obj[\'meta\'][\'epoch\']:\n                        obj[\'meta\'][\'epoch-bk\'][\'me\'] = obj[\'me\']\n                        obj[\'meta\'][\'epoch-bk\'][\'date_modified\'] = obj[\'date_modified\']\n                        obj[\'me\'] = obj[\'meta\'][\'epoch\'][\'me\']\n                        obj[\'date_modified_raw\'] = obj[\'me\']\n                        obj[\'date_modified\'] = formatDate(obj[\'me\'])\n\n                    if \'ae\' in obj[\'meta\'][\'epoch\']:\n                        obj[\'meta\'][\'epoch-bk\'][\'ae\'] = obj[\'ae\']\n                        obj[\'meta\'][\'epoch-bk\'][\'date_accessed\'] = obj[\'date_accessed\']\n                        obj[\'ae\'] = touch_meta[path2][\'epoch\'][\'ae\']\n                        obj[\'accessed_raw\'] = obj[\'ae\']\n                        obj[\'date_accessed\'] = formatDate(obj[\'ae\'])\n\n\n\n        pass\n        if not getAttrib is None:\n            obj[\'attrib\'] = attribs\n        if not getMime is None:\n            obj[\'mime\'] = mime\n        # _.pr(\'here\')\n        epoch.append({ \'label\': \'obj\', \'epoch\': time.time() })\n\n    if exif == 1:\n        obj[\'exif\'] = acquireExif( obj )\n    if exif == 2:\n        exifData = acquireExif( obj )\n            \n        # _.pr( exifData[0] )\n        \n        # for key in exifData[0].keys():\n        #     _.pr( key )\n        # sys.exit()\n        for key in exifData[0].keys():\n            try:\n                try:\n                    if not str( obj[key] ) > 0:\n                        obj[key] = exifData[0][key]\n                except Exception as e:\n                    obj[key] = exifData[0][key]\n            except Exception as e:\n                pass\n\n\n    if sql:\n        path = obj[\'path\']\n        name_ = obj[\'name_\']\n        name = obj[\'name\']\n        folder = obj[\'folder\']\n        bytesx = obj[\'bytes\']\n        sizeF = obj[\'size\']\n        createdRaw = obj[\'date_created_raw\']\n        modifiedRaw = obj[\'date_modified_raw\']\n        date_created = obj[\'date_created\']\n        date_modified = obj[\'date_modified\']\n        week_of_year = obj[\'week_of_year\']\n        week_of_year_ = obj[\'week_of_year_\']\n        day_of_the_week = obj[\'day_of_the_week\']\n        month = obj[\'month\']\n        friendly_week = obj[\'friendly_week\']\n        friendly_month = obj[\'friendly_month\']\n\n        sqlInsert = \'INSERT INTO files VALUES ("{}","{}","{}","{}","", "",{},"{}",{},{},"{}","{}","File", "1", "{}","{}","{}","{}","{}","{}","{}"  ,{},"{}"         , {}, {}, {}, "{}", "{}", {}        )\'.format(path, name_, name, folder, bytesx, sizeF, createdRaw, modifiedRaw, date_created, date_modified, ext, week_of_year, week_of_year_, day_of_the_week, month, friendly_week, friendly_month, accessed_raw, formatDate(accessed_raw)                          , obj[\'ce\'], obj[\'me\'], obj[\'ae\'], obj[\'meta\'], obj[\'header\'], obj[\'error\']       )\n        # sqlInsert = "INSERT INTO files VALUES (\'{}\',\'{}\',\'{}\',\'{}\',\'\', \'\',{},\'{}\',{},{},\'{}\',\'{}\',\'Files\', \'0\', \'\',\'{}\',\'{}\',\'{}\',\'{}\',\'{}\',\'{}\')".format(path, name_, name, folder, bytesx, sizeF, createdRaw, modifiedRaw, date_created, date_modified, week_of_year, week_of_year_, day_of_the_week, month, friendly_week, friendly_month)\n        obj = sqlInsert\n\n    if error:\n        obj = False\n\n    epoch.append({ \'label\': \'sql\', \'epoch\': time.time() })\n\n\n    if not db_cursor is None:\n        # _.pr( count )\n        global commitPer\n        global commit_count\n        if not type(obj) == bool:\n            db_cursor.execute(obj)\n            epoch.append({ \'label\': \'sql_execute\', \'epoch\': time.time() })\n            if not count is None and count % commitPer == 0:\n                # _.pr( count, commitPer )\n                db_connection.commit()\n                commit_count+=1\n\n            if last:\n                db_connection.commit()\n                commit_count+=1\n            epoch.append({ \'label\': \'sql_commit\', \'epoch\': time.time() })\n        else:\n            _.pr( \'error:\', path )\n\n\n\n    if timeAuditCollect:\n        timeAudit.append(epoch)\n\n\n    return obj\n\n\ndef commit():\n    global conn\n    global cursor\n    global commit_count\n    db_connection = conn\n    db_cursor = cursor\n    db_connection.commit()\n    commit_count+=1\n\n\ndef ps_timestamp( stamp ):\n    d = formatDate(stamp)\n    parts = d.split(\' \')\n    day = parts[0]\n    tip = parts[1].split(\':\')\n    \n    if int(tip[0]) > 12:\n        tip[0] = int(tip[0]) - 12\n        ap = \'PM\'\n    else:\n        ap = \'AM\'\n    if not len(tip)> 2:\n        f = day + \' \' + str(tip[0])+\':\'+str(tip[1])+ \' \'+ ap\n    else:\n        f = day + \' \' + str(tip[0])+\':\'+str(tip[1])+\':\'+str(tip[2])+ \' \'+ ap\n    return f\n\ndef formatDate(theDate):\n    result = datetime.datetime.fromtimestamp( int(theDate) ).strftime(\'%Y-%m-%d %H:%M:%S\')\n    result = str(result)\n    return result\ndef formatDateYear(theDate):\n    result = datetime.datetime.fromtimestamp( int(theDate) ).strftime(\'%Y\')\n    # result = str(result)\n    return result\ndef formatDateDay(theDate):\n    result = datetime.datetime.fromtimestamp( int(theDate) ).strftime(\'%d\')\n    # result = str(result)\n    return result\ndef formatDateMonth(theDate):\n    result = datetime.datetime.fromtimestamp( int(theDate) ).strftime(\'%m\')\n    result = str(result)\n    return result\n\n\ndef friendlyMonthNew(theDate):\n    friendlyMonth1 = \'\'\n    currentDate = time.time()\n    currentYear = formatDateYear(currentDate)\n    try:\n        theDate = int(theDate)\n        testYear = formatDateYear(theDate)\n        friendlyMonth0 = months_between(theDate, currentDate)\n        littleMonth = monthByNumber(formatDateMonth(theDate))\n        testMonth = formatDateMonth(theDate)\n        testMonthThis = formatDateMonth(currentDate)\n        if currentYear == testYear and testMonth == testMonthThis:\n            friendlyMonth1 = \'( This month: \' + littleMonth + \' )\'\n        elif currentYear == testYear and testMonth == lastMonth(testMonthThis):\n            friendlyMonth1 = \'( Last month: \' + littleMonth + \' )\'\n\n        else:\n            if int(friendlyMonth0) > 12:\n                years = math.floor(int(friendlyMonth0)/12)\n                months = int(friendlyMonth0) - (years * 12)\n                friendlyMonth1 = str(years) + \' years \' + str(months) + \' months ago: \' + littleMonth \n            else:\n                friendlyMonth1 = str(friendlyMonth0) + \' months ago: \' + littleMonth\n    except Exception as e:\n        pass\n\n    return friendlyMonth1\n\ndef friendlyWeekNew(theDate):\n    friendlyWeek1 = \'\'\n    currentDate = time.time()\n    currentYear = formatDateYear(currentDate)\n    currentWeek = datetime.datetime.fromtimestamp(currentDate).isocalendar()[1]\n    # _.pr(date(2018, 12, 28).isocalendar()[1])\n    try:\n        theDate = int(theDate)\n        testYear = formatDateYear(theDate)\n        woy = datetime.datetime.fromtimestamp(theDate).isocalendar()[1]\n        # friendlyWeek0 = weeks_between(theDate, currentDate)\n        friendlyWeek0 = weeks_between(theDate, currentDate)\n        # friendlyMonth0 = months_between(theDate, currentDate)\n\n\n        if currentYear == testYear and currentWeek == woy:\n            # friendlyWeek1 = str(friendlyWeek0) + \' weeks ago\'\n            # friendlyWeek1 += \' (This week)\'\n            friendlyWeek1 = \'( This week )\'\n        elif (currentYear == testYear and currentWeek == lastWeek(woy)) or str(friendlyWeek0) == \'1\':\n            friendlyWeek1 = \'( Last week )\'\n        else:\n            friendlyWeek1 = str(friendlyWeek0) + \' weeks ago\'\n    except Exception as e:\n        pass\n\n    return friendlyWeek1\n\n\ndef getWeekAndYear(theDate):\n     y = getYearFromEpoch(theDate)\n     w = getWOYFromEpoch(theDate)\n     if w < 10:\n         w = \'0\'+str(w)\n     else:\n         w = str(w)\n     return str(y) +\'.\'+ w\n\ndef getMonthFromEpoch(theDate):\n    return str( getYearFromEpoch(theDate) ) + \'.\' + str(formatDateMonth(theDate))\n\n\ndef getYearFromEpoch(theDate):\n    return datetime.datetime.fromtimestamp( int(theDate) ).isocalendar()[0]\n\ndef getWOYFromEpoch(theDate):\n    return datetime.datetime.fromtimestamp( int(theDate) ).isocalendar()[1]\n\ndef getDOWromEpoch(theDate):\n    return datetime.datetime.fromtimestamp( int(theDate) ).isocalendar()[2]\n\ndef getDOWromEpochText(theDate):\n    return dowConvert(getDOWromEpoch(theDate))\ndef dowConvert(dow):\n    result = \'\'\n    if dow == 1:\n        result = \'Monday\'\n    if dow == 2:\n        result = \'Tuesday\'\n    if dow == 3:\n        result = \'Wednesday\'\n    if dow == 4:\n        result = \'Thursday\'\n    if dow == 5:\n        result = \'Friday\'\n    if dow == 6:\n        result = \'Saturday\'\n    if dow == 7:\n        result = \'Sunday\'\n    return result\n\ndef formatSize(size):\n    result = \'\'\n    if size == None:\n        result = \'\'\n    elif size < 1024:\n        result = str(size) + \' B\'\n    elif size > 1024 and size < 1048576:\n        num = round(size / 1024, 2)\n        result = str(num) + \' KB\'\n    elif size > 1048576 and size < 1073741824:\n        num = round(size / 1048576, 2)\n        result = str(num) + \' MB\'\n    elif size > 1073741824 and size < 1099511627776    :\n        num = round(size / 1073741824, 2)\n        result = str(num) + \' GB\'\n    else:\n        num = round(size / 1099511627776, 2)\n        result = str(num) + \' TB\'\n    # if size < 1:\n    #     result = \'\'\n    return result\n\ndef unFormatSize(size):\n    size = str(size)\n    size = size.upper()\n    factor = \'\'\n    # 1152921504606846976\n    if False:\n        pass\n    elif \'YB\' in size:\n        factor = 1208925819614629174706176\n    elif \'ZB\' in size:\n        factor = 1180591620717411303424\n    elif \'EB\' in size:\n        factor = 1152921504606847000\n    elif \'PB\' in size:\n        factor = 1125899906842624\n    elif \'TB\' in size:\n        factor = 1099511627776\n    elif \'GB\' in size:\n        factor = 1073741824\n    elif \'MB\' in size:\n        factor = 1048576\n    elif \'KB\' in size:\n        factor = 1024\n    else:\n        factor = 1\n    size = size.replace(\'X\',\'\')\n    size = size.replace(\'Y\',\'\')\n    size = size.replace(\'Z\',\'\')\n    size = size.replace(\'E\',\'\')\n    size = size.replace(\'P\',\'\')\n    size = size.replace(\'T\',\'\')\n    size = size.replace(\'B\',\'\')\n    size = size.replace(\'M\',\'\')\n    size = size.replace(\'K\',\'\')\n    size = size.replace(\'G\',\'\')\n    size = float(size)\n    if str(size).endswith(\'.0\'):\n        size = int(size)\n\n    result = round(size * factor,0)\n    # _.pr( size, factor )\n    # result = size * factor\n    return result\n\ndef fileNameLength(string,ext,l=0):\n    global maxFileNameLength\n    if l == 0:\n        theLength = maxFileNameLength\n    else:\n        theLength = l\n\n    result = \'\'\n    toLong = False\n    try:\n        i = 0\n        for L in string:\n            if i <= theLength:\n                result += L\n            else:\n                toLong = True\n            i += 1\n        if toLong == True:\n            result += \'...\'\n            if len(ext) > 0:\n                result += \'  .\' + ext\n    except Exception as e:\n        result = string\n    return result\n\n\n\ndef attrib(path, a=None, s=None, h=None, r=None, i=None):\n    attrs=[]\n    if r==True:    attrs.append(\'+R\')\n    elif r==False: attrs.append(\'-R\')\n    if a==True:    attrs.append(\'+A\')\n    elif a==False: attrs.append(\'-A\')\n    if s==True:    attrs.append(\'+S\')\n    elif s==False: attrs.append(\'-S\')\n    if h==True:    attrs.append(\'+H\')\n    elif h==False: attrs.append(\'-H\')\n    if i==True:    attrs.append(\'+I\')\n    elif i==False: attrs.append(\'-I\')\n\n    if attrs: # write attributes\n        cmd = attrs\n        cmd.insert(0,\'attrib\')\n        cmd.append(path)\n        cmd.append(\'/L\')\n        return subprocess.call(cmd, shell=False)\n\n    else: # just read attributes\n        output = subprocess.check_output(\n            [\'attrib\', path, \'/L\'],\n            shell=False, universal_newlines=True\n        )[:9]\n        attrs = {\'A\':False, \'S\':False, \'H\':False, \'R\':False, \'I\':False}\n        for char in output:\n            if char in attrs:\n                attrs[char] = True\n        return attrs\n\n\ndef getAttribs(rows):\n    result = \'\'\n    if rows[\'A\'] == True:\n        result += \'A\' \n    if rows[\'S\'] == True:\n        result += \'S\' \n    if rows[\'H\'] == True:\n        result += \'H\' \n    if rows[\'R\'] == True:\n        result += \'R\' \n    if rows[\'I\'] == True:\n        result += \'I\' \n    return result\n\ndef getExtension(string):\n    # return \'test\'\n    if not \'.\' in string:\n        return \'\'\n    ext = string.split(\'.\')\n    ext.reverse()\n    return ext[0]\n    # extId = len(ext0) - 1\n    # if extId > 0:\n    #     ext = ext0[extId]\n    # else:\n    #     ext = \'\'\n    # return ext\n\n\ndef getTable( theFile, tableTemp=False,      isDic=None, isList=None,      tmp=None ):\n\n    # defaults to myTables\n    if not type( tableTemp ) == bool:\n        if tableTemp == \'split\':\n            file0 = _v.myTables + _v.slash+\'tablesets\'+_v.slash + theFile\n    else:\n        if tableTemp == True:\n            file0 = _v.stmp + _v.slash + theFile\n        else:\n            file0 = _v.myTables + _v.slash + theFile\n\n\n    if not os.path.isfile(file0):\n        file0 = theFile\n    if os.path.isfile(file0):\n        # _.pr( \'theFile\', theFile )\n        # _.pr( \'file0\', file0 )\n        # import bigjson\n        with open(file0,\'r\', encoding="latin-1") as json_file:\n            json_data = json.load(json_file)\n        return json_data\n        # with open( file0, \'rb\' ) as f:\n            # json_data = bigjson.load(f)\n            # json_data = bigjson.load(json_file)\n            # json_data = json.load(json_file, object_pairs_hook=OrderedDict)\n    else:\n        return __.data_default(file=theFile,default=[]).default()\n\n# woy_hash_table_back = None\n# woy_hash_table_forward = None\n# def time_diff( thedate ):\n#     if thedate <= time.time():\n#         return time_ago( thedate )\n#     else:\n#         return time_2be( thedate )\n# def time_ago( thedate ):\n\n#     woy = getWOYFromEpoch(thedate)\n#     year = getYearFromEpoch(thedate)\n#     weekAndYear = round(woy * 0.01,2) + year\n#     weekAndYear = str(weekAndYear)\n#     if len(weekAndYear) == 6:\n#         weekAndYear += \'0\' \n#     data = weekAndYear\n\n#     wks=10000\n#     global woy_hash_table_back\n#     if woy_hash_table_back is None:\n#         KILL_ON = getYearFromEpoch( time.time() ) - 100\n#         woy_hash_table_back = {}\n#         def gen_woy_b( y, wy ):\n#             wy-=1\n#             if wy == 0:\n#                 wy=53\n#                 y-=1\n#             if wy <= 9:\n#                 z = str(y)+\'.0\'+str(wy)\n#             else:\n#                 z = str(y)+\'.\'+str(wy)\n#             return y, wy, z\n#         i=0\n#         epoch=time.time()\n#         y = int(getYearFromEpoch( float(epoch) ))\n#         wy = int(getWOYFromEpoch(  float(epoch)  ))\n        \n#         tdy0 = _.friendlyDate( time.time() ).split(\' \')[0]\n#         woy_hash_table_back[  tdy0  ] = \'today\'\n#         woy_hash_table_back[  gen_days_ago(1)  ] = \'yesterday\'\n#         # woy_hash_table_back[  gen_days_ago(2)  ] = \'2 days\'\n#         # woy_hash_table_back[  gen_days_ago(2)  ] = \'3 days\'\n\n#         # woy_hash_table_back[  _.friendlyDate( _.dateMathEpoch(time.time() , 0, \'-\' ) ).split(\' \')[0]  ] = \'yesterday\'\n#         # woy_hash_table_back[  _.friendlyDate( _.dateMathEpoch(time.time() , 1, \'-\' ) ).split(\' \')[0]  ] = \'2 days ago\'\n#         # woy_hash_table_back[  _.friendlyDate( _.dateMathEpoch(time.time() , 2, \'-\' ) ).split(\' \')[0]  ] = \'2 days\'\n#         # woy_hash_table_back[  _.friendlyDate( _.dateMathEpoch(time.time() , 3, \'-\' ) ).split(\' \')[0]  ] = \'3 days\'\n#         # woy_hash_table_back[  _.friendlyDate( _.dateMathEpoch(time.time() , 4, \'-\' ) ).split(\' \')[0]  ] = \'4 days\'\n#         # woy_hash_table_back[  _.friendlyDate( _.dateMathEpoch(time.time() , 5, \'-\' ) ).split(\' \')[0]  ] = \'5 days\'\n#         # woy_hash_table_back[  _.friendlyDate( _.dateMathEpoch(time.time() , 6, \'-\' ) ).split(\' \')[0]  ] = \'6 days\'\n#         # woy_hash_table_back[  _.friendlyDate( _.dateMathEpoch(time.time() , 7, \'-\' ) ).split(\' \')[0]  ] = \'7 days\'\n\n#         if wy <= 9:\n#             woy_hash_table_back[  str(y)+\'.0\'+str(wy)  ] = \'this week\'\n#         else:\n#             woy_hash_table_back[  str(y)+\'.\'+str(wy)  ] = \'this week\'\n#         y, wy, z = gen_woy_b( y, wy )\n#         woy_hash_table_back[  z  ] = \'a week ago\'\n#         i+=1\n#         while i<=wks :\n#             i+=1\n#             y, wy, z = gen_woy_b( y, wy )\n#             ixx = i\n#             tyrs = 0\n#             tMs = 0\n#             if i >= 52:\n#                 tyrsZ = float(i / 52)\n#                 tyrs = int(str(tyrsZ).split(\'.\')[0])\n#                 ixx = i - ( tyrs*52 )\n#             if ixx >= 4:\n#                 tMsZ = float(ixx / 4)\n#                 tMs = int(str(tMsZ).split(\'.\')[0])\n#                 ixx\n#                 nwoy = str( round(wy * 0.01,2) + y )\n#                 ixx = ixx - ( tMs*4 )-1\n#                 if nwoy == \'1969.52\':\n#                     break\n#                 # wmd = abs(_.daysDiff(   _.monthMath(      _.woy2dates( str( round(wy * 0.01,2) + y ) )[0]      , tMs, do=\'+\' ), epoch   ))\n#                 # ixx = abs(int(str( wmd/7 ).split(\'.\')[0]))\n#                 # _.pr(ixx)\n#                 # if ixx> 4:\n\n#                 #     _.pr( \'\\n000-time_ago\' )\n#                 #     _.pr( \'000\', nwoy )\n#                 #     _.pr( \'010\', _.friendlyDate(_.woy2dates( str( round(wy * 0.01,2) + y ) )[0]) )\n\n#                 #     _.pr( \'020\', tMs, _.friendlyDate(_.monthMath(      _.woy2dates( str( round(wy * 0.01,2) + y ) )[0]      , tMs, do=\'+\' ))    )\n                    \n#                 #     _.pr( \'030\', nwoy, tyrs, tMs, ixx, \'  ...  \', wmd )\n\n#                 #     import sys\n#                 #     sys.exit()\n#                 # _.pr( wmd )\n\n#                 # ixx = ixx - ( tMs*4 )\n\n#             thisAgo = []\n#             if tyrs:\n#                 thisAgo.append( str(tyrs)+\'Y\' )\n#             if tMs:\n#                 thisAgo.append( str(tMs)+\'M\' )\n#             if ixx > 0:\n#                 thisAgo.append( str(ixx)+\'W\' )\n#             # thisAgo.append( \'ago\' )\n\n\n#             woy_hash_table_back[  z  ] = \' \'.join( thisAgo ) + \' <\'\n#             # woy_hash_table_back[  z  ] = str(i)+\' weeks ago\'\n#             if y < KILL_ON:\n#                 break\n#     if not woy_hash_table_back:\n#         # _.pr(0,data)\n#         return data\n#     else:\n#         if not data in woy_hash_table_back:\n#             # _.pr(1,data)\n#             # printVarSimple(woy_hash_table_back)\n#             return data\n#         else:\n\n# # dateMathEpoch\n#             if woy_hash_table_back[data] == \'this week\':\n#                 ixD = _.friendlyDate( thedate ).split(\' \')[0]\n#                 if ixD in woy_hash_table_back:\n#                     return woy_hash_table_back[ixD]\n#             return woy_hash_table_back[data]\n\n\n# import _rightThumb._base3 as _\n\ndef gen_days_ago(days=1):\n    now = _.autoDate( _.friendlyDate( time.time() ).split(\' \')[0] ) - (  86400*days  )\n    tdy0 = _.friendlyDate( now ).split(\' \')[0]\n    return tdy0\n    \ndef gen_days_2be(days=1):\n    now = _.autoDate( _.friendlyDate( time.time() ).split(\' \')[0] ) + (  86400*days  )\n    tdy0 = _.friendlyDate( now ).split(\' \')[0]\n    return tdy0\n\n# def time_2be( thedate ):\n\n#     woy = getWOYFromEpoch(thedate)\n#     year = getYearFromEpoch(thedate)\n#     weekAndYear = round(woy * 0.01,2) + year\n#     weekAndYear = str(weekAndYear)\n#     if len(weekAndYear) == 6:\n#         weekAndYear += \'0\' \n#     data = weekAndYear\n\n#     wks=10000\n#     global woy_hash_table_forward\n#     if woy_hash_table_forward is None:\n#         KILL_ON = getYearFromEpoch( time.time() ) + 100\n#         woy_hash_table_forward = {}\n#         def gen_woy_f( y, wy ):\n#             wy+=1\n#             if wy == 53:\n#                 wy=1\n#                 y+=1\n#             if wy <= 9:\n#                 z = str(y)+\'.0\'+str(wy)\n#             else:\n#                 z = str(y)+\'.\'+str(wy)\n#             return y, wy, z\n#         i=0\n#         epoch=time.time()\n#         y = int(getYearFromEpoch( float(epoch) ))\n#         wy = int(getWOYFromEpoch(  float(epoch)  ))\n        \n#         tdy0 = _.friendlyDate( time.time() ).split(\' \')[0]\n#         woy_hash_table_forward[  tdy0  ] = \'today\'\n#         woy_hash_table_forward[  gen_days_2be(1)  ] = \'tomorrow\'\n\n#         if wy <= 9:\n#             woy_hash_table_forward[  str(y)+\'.0\'+str(wy)  ] = \'this week\'\n#         else:\n#             woy_hash_table_forward[  str(y)+\'.\'+str(wy)  ] = \'this week\'\n#         y, wy, z = gen_woy_f( y, wy )\n#         woy_hash_table_forward[  z  ] = \'next week\'\n#         i+=1\n#         while i<=wks :\n#             i+=1\n#             y, wy, z = gen_woy_f( y, wy )\n#             ixx = i\n#             tyrs = 0\n#             tMs = 0\n\n#             # ty = _.woy2dates( str( round(wy * 0.01,2) + y ) )[0].split(\' \')[0]\n#             # tMs = _.monthsDiff( ty, epoch )\n#             # tmd = _.monthMath( epoch, tMs, \'+\' )\n#             # ixx = abs(_.daysDiff( tmd, ty ))\n#             # if tMs >= 12:\n#             #     tyrsZ = float(tMs / 12)\n#             #     tyrs = int(str(tyrsZ).split(\'.\')[0])\n#             #     # ixx = i - ( tyrs*12 )\n            \n#             # tMs = int(str( tMs/12 ).split(\'.\')[0])\n\n            \n#             if i >= 52:\n#                 tyrsZ = float(i / 52)\n#                 tyrs = int(str(tyrsZ).split(\'.\')[0])\n#                 ixx = i - ( tyrs*52 )\n#             if ixx >= 4:\n#                 tMsZ = float(ixx / 4)\n#                 # tMs = _.monthsDiff(  )\n#                 tMs = int(str(tMsZ).split(\'.\')[0])\n#                 ixx = ixx - ( tMs*4 )\n#                 # _.pr( \'000-time_2be\' )\n#                 # wmd = abs(_.daysDiff(   _.monthMath(      _.woy2dates( str( round(wy * 0.01,2) + y ) )[0]      , tMs, do=\'+\' ), epoch   ))\n#                 # ixx = int(str( wmd/7 ).split(\'.\')[0])\n                \n\n#             thisAgo = []\n#             if tyrs:\n#                 thisAgo.append( str(tyrs)+\'Y\' )\n#             if tMs:\n#                 thisAgo.append( str(tMs)+\'M\' )\n#             if ixx>0:\n#                 thisAgo.append( str(ixx)+\'W\' )\n#             # thisAgo.append( \'ago\' )\n\n\n#             woy_hash_table_forward[  z  ] = \' \'.join( thisAgo ) + \' >\'\n#             # woy_hash_table_forward[  z  ] = str(i)+\' weeks ago\'\n#             if y > KILL_ON:\n#                 break\n#     if not woy_hash_table_forward:\n#         # _.pr(0,data)\n#         return data\n#     else:\n#         if not data in woy_hash_table_forward:\n#             # _.pr(1,data)\n#             # printVarSimple(woy_hash_table_back)\n#             return data\n#         else:\n\n# # dateMathEpoch\n#             if woy_hash_table_forward[data] == \'this week\':\n#                 ixD = _.friendlyDate( thedate ).split(\' \')[0]\n#                 if ixD in woy_hash_table_forward:\n#                     return woy_hash_table_forward[ixD]\n#             return woy_hash_table_forward[data]\n\n\n# import _rightThumb._base3 as _\n\ndef gen_days_ago(days=1):\n    now = _.autoDate( _.friendlyDate( time.time() ).split(\' \')[0] ) - (  86400*days  )\n    tdy0 = _.friendlyDate( now ).split(\' \')[0]\n    return tdy0\n    \n# def gen_woy( thisDate ):\n#     thedate = _.autoDate(thisDate)\n#     woy = getWOYFromEpoch(thedate)\n#     year = getYearFromEpoch(thedate)\n#     weekAndYear = round(woy * 0.01,2) + year\n#     return str(weekAndYear)\n\n\n\n\ndef dateDiffText( theDate ):\n\n    # _.pr( theDate )\n\n    y=0\n    m=0\n    w=0\n\n    # theDate = autoDate( theDate )\n    epoch = time.time()\n    # woy = getWOY( theDate )\n\n    days = int( str( (time.time() - theDate)/86400 ).split(\'.\')[0] )\n\n    msDiff = epoch - theDate\n\n    if msDiff <= 86402:\n        return \'today\'\n\n    # days = abs(daysDiff( theDate, epoch ))\n    \n    if theDate < epoch:\n        end = \'<\'\n    else:\n        end = \'>\'\n\n    if days == 0:\n        return \'today\'\n    elif theDate < epoch:\n        if days == 1:\n            return \'yesterday\'\n        elif days < 7:\n            return \'this week\'\n    elif theDate > epoch:\n        if days == 1:\n            return \'tommorow\'\n        elif days < 7:\n            return \'next week\'\n\n    if days >= 365:\n        tmp = float(days / 365)\n        y = int(str(tmp).split(\'.\')[0])\n        days = days - ( y*365 )\n    if days >= 30:\n        tmp = float(days / 30)\n        m = int(str(tmp).split(\'.\')[0])\n        days = days - ( m*30 )\n    if days >= 7:\n        tmp = float(days / 7)\n        w = int(str(tmp).split(\'.\')[0])\n        days = days - ( w*7 )\n\n    result = []\n    if y:\n        result.append( str(y)+\'y\' )\n    if m:\n        result.append( str(m)+\'m\' )\n    if w:\n        result.append( str(w)+\'w\' )\n    result.append( end )\n    return \' \'.join( result )\n\ndef daysDiff( one, two ):\n\n    _.pr(one, two)\n    _.pr(type(one), type(two))\n\n    if one == two:\n        return 0\n    elif one > two:\n        one = datetime.datetime.fromtimestamp( int(one) )\n        two = datetime.datetime.fromtimestamp( int(two) )\n    else:\n        two = datetime.datetime.fromtimestamp( int(one) )\n        one = datetime.datetime.fromtimestamp( int(two) )\n\n\n\n    delta = one - two\n    return delta.days\n\n# dateDiffText\nheader = 0\n\n\n\n')
    __stickytape_write_module('_rightThumb/_mimetype/__init__.py', b'# import _rightThumb._mimetype as _mime\n\n# ## {R2D2919B742E} ##\n# ###########################################################################\n# What if magic existed?\n# What if a place existed where your every thought and dream come to life.\n# There is only one catch: it has to be written down.\n# Such a place exists, it is called programming.\n#    - Scott Taylor Reph, RightThumb.com\n# ###########################################################################\n# ## {C3P0D40fAe8B} ##\n\n# _mime.isText(file)\n# _mime.isBinary(file)\n# _mime.what(file)\n\n# textChars = ["Z", "c", "1", "y", "Q", "W", "m", "L", "k", "A", "E", "B", "z", "g", "0", "q", "C", "D", "u", "e", "w", "-", "4", "M", "p", "b", "O", "v", "K", "8", "I", "j", "7", "n", "r", "s", "V", "G", "X", "P", "l", "a", "x", "N", "3", "T", "t", "_", "d", "i", "Y", "o", "2", "9", "J", "F", "6", "U", "h", "f", "R", "S", "H", " ", ",", ".", "\\n", "[", "5", "]", "{", "\\"", ":", "\\\\", "}", "(", ")", "?", "\'", "/", "$", "!", "|", ";", "&", "*", "+", "=", "#", "<", ">", "@", "`", "%", "~", "^", "\\u00a0", "\\u2014", "\\u2019", "\\u2013", "\\u2022", "\\u201c", "\\u201d", "\\u0093", "\\u0094", "\\u0097", "\\u2018", "\\u2003", "\\ufffc", "\\u00d7", "\\u2060", "\\u2212", "\\u00b0", "\\u00c5", "\\u0431", "\\u0433", "\\u00f4", "\\u00e7", "\\u00f1", "\\u00f8", "\\u00e9", "\\u00cd", "\\u0101", "\\u0441", "\\u0440", "\\u0444", "\\u00e3", "\\u00ed", "\\u00fc", "\\u0627", "\\u0644", "\\u062c", "\\u0632", "\\u0626", "\\u0631", "\\u0570", "\\u0561", "\\u0575", "\\u0628", "\\u062d", "\\u064a", "\\u0646", "\\u09ac", "\\u09be", "\\u0982", "\\u09b2", "\\u0435", "\\u043b", "\\u4e2d", "\\u56fd", "\\u014d", "\\u00f3", "\\u570b", "\\u0645", "\\u0635", "\\u1e63", "\\u044e", "\\u03b5", "\\u03c5", "\\u10d2", "\\u10d4", "\\u03bb", "\\u9999", "\\u6e2f", "\\u092d", "\\u093e", "\\u0930", "\\u0924", "\\u06be", "\\u062a", "\\u0c2d", "\\u0c3e", "\\u0c30", "\\u0c24", "\\u0c4d", "\\u0aad", "\\u0abe", "\\u0ab0", "\\u0aa4", "\\u0a2d", "\\u0a3e", "\\u0a30", "\\u0a24", "\\u012b", "\\u0b87", "\\u0ba8", "\\u0bcd", "\\u0ba4", "\\u0bbf", "\\u0baf", "\\u0bbe", "\\u09ad", "\\u09b0", "\\u09a4", "\\u0cad", "\\u0cbe", "\\u0cb0", "\\u0ca4", "\\u0d2d", "\\u0d3e", "\\u0d30", "\\u0d24", "\\u0d02", "\\u09f0", "\\u0b2d", "\\u0b3e", "\\u0b30", "\\u0b24", "\\u092e", "\\u094d", "\\u094b", "\\u0680", "\\u06cc", "\\u012a", "\\u0639", "\\u0642", "\\u02bf", "\\u05d9", "\\u05e9", "\\u05e8", "\\u05d0", "\\u05dc", "\\u062f", "\\u049b", "\\u0430", "\\u0437", "\\u0ea5", "\\u0eb2", "\\u0ea7", "\\u6fb3", "\\u95e8", "\\u00c0", "\\u9580", "\\u0633", "\\u0648", "\\u016b", "\\u043c", "\\u043e", "\\u043d", "\\u063a", "\\u0121", "\\u043a", "\\u0434", "\\u067e", "\\u06a9", "\\u0641", "\\u0637", "\\u1e6d", "\\u0629", "\\u65b0", "\\u52a0", "\\u5761", "\\u0b9a", "\\u0b99", "\\u0b95", "\\u0baa", "\\u0bc2", "\\u0bb0", "\\ud55c", "\\uad6d", "\\u0dbd", "\\u0d82", "\\u0d9a", "\\u0dcf", "\\u0bb2", "\\u0bc8", "\\u1e45", "\\u53f0", "\\u6e7e", "\\u00e1", "\\u7063", "\\u0e44", "\\u0e17", "\\u0e22", "\\u0443", "\\u00e4", "\\u00fa", "\\u01ce", "\\u7f51", "\\u7db2", "\\u4eba", "\\u624b", "\\u673a", "\\u014f", "\\u56fe", "\\u4e66", "\\u8d2d", "\\u00f2", "\\u5fae", "\\u535a", "\\u0113", "\\u559c", "\\u6b22", "\\u01d0", "\\u4fe1", "\\u00ec", "\\u00e0", "\\u0926", "\\u0947", "\\u0938", "\\u0940", "\\u0936", "\\u093f", "\\u0915", "\\u0937", "\\u0643", "\\u062b", "\\u0634", "\\u00e2", "\\u5728", "\\u7ebf", "\\u6587", "\\u5740", "\\u7ad9", "\\u7edc", "\\u516c", "\\u53f8", "\\u5546", "\\u57ce", "\\u6784", "\\u6211", "\\u7231", "\\u4f60", "\\u01d2", "\\u6807", "\\u4e16", "\\u754c", "\\u00e8", "\\u96c6", "\\u56e2", "\\u6148", "\\u5584", "\\u516b", "\\u5366", "\\u76ca", "\\u0442", "\\u0438", "\\u0439", "\\u0902", "\\u0917", "\\u0920", "\\u0928", "\\u0949", "\\u091f", "\\ub2f7", "\\ucef4", "\\ub137", "\\u05e7", "\\u05d5", "\\u05dd", "\\u307f", "\\u3093", "\\u306a", "\\u30bb", "\\u30fc", "\\u30eb", "\\u30d5", "\\u30a1", "\\u30c3", "\\u30b7", "\\u30e7", "\\u30f3", "\\u30b9", "\\u30c8", "\\u30a2", "\\u30dd", "\\u30a4", "\\u30af", "\\u30e9", "\\u30a6", "\\u30c9", "\\u30b3", "\\u30e0", "\\u0e04", "\\u0e2d", "\\u0e21", "\\u0130", "\\u1e92", "\\u00f6", "\\u8054", "\\u901a", "\\u79fb", "\\u52a8", "\\u683c", "\\u91cc", "\\u62c9", "\\u2010", "\\u6de1", "\\u9a6c", "\\u9521", "\\u5927", "\\u4f17", "\\u6c7d", "\\u8f66", "\\u30b0", "\\u8c37", "\\u6b4c", "\\u01d4", "\\u5de5", "\\u884c", "\\u5609", "\\u9152", "\\u5e97", "\\u98de", "\\u5229", "\\u6d66", "\\u8bfa", "\\u57fa", "\\u4e9a", "\\u96fb", "\\u8a0a", "\\u76c8", "\\u79d1", "\\uc0bc", "\\uc131", "\\u00ff", "\\u00ad", "\\u25bd", "\\u25b3", "\\ud83e\\uddfb", "\\ud83e\\uddea", "\\ud83d\\udc80", "\\ud83e\\udd86", "\\ud83e\\udd89", "\\ud83e\\udd53", "\\ud83e\\udd84", "\\ud83e\\udd80", "\\ud83d\\udd95", "\\ud83c\\udf63", "\\ud83c\\udf64", "\\ud83c\\udf65", "\\ud83c\\udf61", "\\ud83e\\udd43", "\\ud83e\\udd5e", "\\ud83d\\udc15", "\\ud83d\\udc7e", "\\ud83d\\udc09", "\\ud83d\\udc13", "\\ud83d\\udc0b", "\\ud83d\\udc0c", "\\ud83d\\udc22", "\\ud83d\\udc7d", "\\ud83d\\udc7f", "\\ud83e\\udd51", "\\ud83d\\udc21", "\\ud83d\\udc17", "\\ud83d\\udc90", "\\ud83c\\udff9", "\\ud83c\\udfa8", "\\ud83d\\udc14", "\\ud83d\\udc1b", "\\ud83c\\udfaf", "\\ud83c\\udf2f", "\\ud83d\\udcf7", "\\ud83d\\udef6", "\\ud83e\\udd55", "\\ud83c\\udf52", "\\ud83c\\udf78", "\\ud83c\\udf73", "\\ud83d\\udc32", "\\ud83c\\udfa3", "\\ud83d\\udc1f", "\\ud83e\\udd85", "\\ud83d\\udc40", "\\ud83d\\udc38", "\\ud83e\\udd1e", "\\ud83d\\udcaa", "\\ud83d\\udcbe", "\\ud83d\\udc7b", "\\ud83d\\udc0a", "\\ud83c\\udf54", "\\ud83c\\udf2d", "\\ud83c\\udf40", "\\ud83d\\udd53", "\\ud83e\\udd8a", "\\ud83c\\udf5f", "\\ud83e\\udd5d", "\\ud83d\\udc12", "\\ud83d\\udc3c", "\\ud83d\\udcce", "\\ud83d\\udc27", "\\ud83d\\udca9", "\\ud83c\\udf55", "\\ud83c\\udf4d", "\\ud83e\\udd8f", "\\ud83c\\udf57", "\\ud83c\\udf08", "\\ud83d\\udc33", "\\ud83e\\udd91", "\\ud83d\\ude80", "\\ud83d\\ude48", "\\ud83d\\ude4a", "\\ud83d\\ude49", "\\ud83c\\udf2e", "\\ud83e\\udd52", "\\ud83d\\udc05", "\\ud83d\\udc2f", "\\ud83c\\udf49", "\\ud83d\\udebd", "\\ud83c\\udf45", "\\ud83d\\udc45", "\\ud83c\\udfa9", "\\ud83c\\udf77", "\\u327f", "\\u250c", "\\u2500", "\\u2514", "\\u00b6", "\\u2588", "\\u0095", "\\u2026", "\\u00b4", "\\u00f7", "\\ud83c\\udfff", "\\ud83c\\udffb", "\\ud83c\\udffe", "\\ud83c\\udffc", "\\ud83c\\udffd", "\\ud83d\\uddbc", "\\u001b", "\\u00fe", "\\u0000", "\\u0088", "\\u00f9", "\\u00d6", "\\u00b5", "\\u0003", "\\u00b8", "\\u00b3", "\\b", "\\u0080", "\\u0099", "\\u00c2", "\\u00b2", "\\u00a9", "\\u00ac", "\\u0005", "\\u0014", "\\u0001", "\\u00bc", "\\u00fd", "\\u009e", "\\u00b9", "\\u00c8", "\\u0002", "\\u0098", "\\u00f5", "\\u008a", "\\u00b7", "\\u008f", "\\u00bb", "\\u0096", "\\u00af", "\\u0004", "\\u00f0", "\\u00aa", "\\u00a1", "\\f", "\\u00bf", "\\u0086", "\\u000b", "\\u00d5", "\\u00ee", "\\u009a", "\\u001f", "\\u009f", "\\u00a6", "\\u00b1", "\\u00dc", "\\u0011", "\\u000e", "\\u009d", "\\u001e", "\\u00de", "\\u00ab", "\\u0085", "\\u00c7", "\\u001c", "\\u00c4", "\\u00d9", "\\u007f", "\\u0089", "\\u00eb", "\\u0082", "\\u00df", "\\u00d2", "\\u0091", "\\u00ea", "\\u0010", "\\u00be", "\\u00d0", "\\u008b", "\\u0006", "\\u00db", "\\u00d3", "\\u009c", "\\u00c9", "\\u009b", "\\u00cf", "\\u0084", "\\u00da", "\\u00c6", "\\u0007", "\\u0018", "\\u00cb", "\\u00ba", "\\u00e6", "\\u00c1", "\\u00bd", "\\u00a2", "\\u00dd", "\\u0012", "\\u0423", "\\u0420", "\\u044f", "\\u0131", "\\u00a5", "\\u00ef", "\\u0151", "\\u0161", "\\u0107", "\\u010d", "\\u1ec5", "\\u1ecd", "\\u1ea1", "\\u0219", "\\u00e5", "\\u0160", "\\u00d8", "\\u0647", "\\u06d0", "\\u069a", "\\u062e", "\\u0693", "\\u06ab", "\\u0696", "\\u0685", "\\u06cd", "\\u0698", "\\u067c", "\\u0689", "\\u0686", "\\u06bc", "\\u0681", "\\u060c", "\\u0411", "\\u0456", "\\u043f", "\\u0414", "\\u045e", "\\u044b", "\\u044c", "\\u0447", "\\u0432", "\\u044d", "\\u0448", "\\u0451", "\\u041d", "\\u0446", "\\u041f", "\\u0445", "\\u0436", "\\u0428", "\\u0417", "\\u0421", "\\u041a", "\\u041b", "\\u042d", "\\u0422", "\\u0412", "\\u041c", "\\u041e", "\\u0416", "\\u0410", "\\u042c", "\\u0426", "\\u0424", "\\u0454", "\\u0406", "\\u0413", "\\u0457", "\\u0449", "\\u0415", "\\u0427", "\\u0419", "\\u0654", "\\u0638", "\\u200c", "\\u200e", "\\u06af", "\\u0650", "\\u200f", "\\u0630", "\\u061b", "\\u0622", "\\u064b", "\\u0636", "\\u00fb", "\\u0905", "\\u092a", "\\u092f", "\\u0941", "\\u0923", "\\u0935", "\\u0932", "\\u090f", "\\u0939", "\\u0948", "\\u0908", "\\u0927", "\\u091a", "\\u0906", "\\u0901", "\\u0921", "\\u093c", "\\u0942", "\\u094c", "\\u091c", "\\u092b", "\\u0943", "\\u0925", "\\u0916", "\\u0907", "\\u092c", "\\u0909", "\\u0922", "\\u091e", "\\u0910", "\\u0914", "\\u0903", "\\u091b", "\\u0913", "\\u0911", "\\u0651", "\\u0652", "\\u0623", "\\u0625", "\\u0649", "\\u064f", "\\u0621", "\\u0640", "\\u0624", "\\u202a", "\\u202c", "\\u064e", "\\ufefb", "\\u201e", "\\u045a", "\\u0458", "\\u0459", "\\u045b", "\\u0418", "\\u0452", "\\u7518", "\\u9732", "\\u015f", "\\u017d", "\\u017e", "\\u0259", "\\u018f", "\\ufffd", "\\u0f62", "\\u0f7a", "\\u0f0b", "\\u0f56", "\\u0f58", "\\u0f51", "\\u0f54", "\\u0f60", "\\u0f72", "\\u0f41", "\\u0fb1", "\\u0f46", "\\u0f7c", "\\u0f66", "\\u0f64", "\\u0f42", "\\u0f53", "\\u0f63", "\\u0f74", "\\u0f0d", "\\u0f5a", "\\u0f50", "\\u0f44", "\\u0f9f", "\\u0f90", "\\u0fa1", "\\u0fa3", "\\u0f45", "\\u0f61", "\\u0f68", "\\u0f67", "\\u0f5b", "\\u0f92", "\\u0f5f", "\\u0f5e", "\\u0fb2", "\\u0fb3", "\\u0fb7", "\\u0f55", "\\u0f4a", "\\u0f47", "\\u0f40", "\\u0f4c", "\\u0f49", "\\u0f0c", "\\u0f71", "\\u0fa4", "\\u0f4f", "\\u0fa9", "\\u0f5d", "\\u0f28", "\\u0fa6", "\\u0f59", "\\u0f97", "\\u0fab", "\\u0f21", "\\u0f26", "\\u044a", "\\u200a", "\\u042f", "\\u042e", "\\u0111", "\\u010c", "\\u0c35", "\\u0c3f", "\\u0c15", "\\u0c02", "\\u0c2b", "\\u0c23", "\\u0c40", "\\u0c26", "\\u0c21", "\\u0c41", "\\u0c2a", "\\u0c38", "\\u0c2e", "\\u0c2f", "\\u0c42", "\\u0c32", "\\u0c05", "\\u0c28", "\\u0c4b", "\\u0c1f", "\\u0c2c", "\\u0c4a", "\\u0c47", "\\u0c17", "\\u0c46", "\\u0c48", "\\u0c12", "\\u0c1a", "\\u0c1c", "\\u0c39", "\\u0c0e", "\\u0c37", "\\u0c27", "\\u0c09", "\\u0c06", "\\u0c10", "\\u0c25", "\\u0c07", "\\u0c13", "\\u0c03", "\\u0c43", "\\u0c1b", "\\u0c36", "\\u0c20", "\\u0c16", "\\u0c33", "\\u0c0a", "\\u0c0f", "\\u200d", "\\u0c08", "\\u0c69", "\\u0c68", "\\u0c4c", "\\u0549", "\\u056b", "\\u057b", "\\u0578", "\\u0572", "\\u057e", "\\u0565", "\\u056c", "\\u056f", "\\u0580", "\\u0564", "\\u057d", "\\u0574", "\\u0582", "\\u0568", "\\u055d", "\\u057a", "\\u0576", "\\u0562", "\\u0581", "\\u056d", "\\u057f", "\\u0569", "\\u0586", "\\u0583", "\\u056e", "\\u0563", "\\u0567", "\\u0579", "\\u054d", "\\u057c", "\\u0584", "\\u0553", "\\u0587", "\\u0585", "\\u053f", "\\u0551", "\\u0541", "\\u0556", "\\u306f", "\\u3068", "\\u3044", "\\u3046", "\\u8981", "\\u7d20", "\\u306b", "\\u5bfe", "\\u3057", "\\u3066", "\\u60f3", "\\u5b9a", "\\u5916", "\\u306e", "\\u5c5e", "\\u6027", "\\u3067", "\\u3059", "\\u3042", "\\u308a", "\\u307e", "\\u305b", "\\u30bf", "\\u305f", "\\u30c7", "\\u30fb", "\\u30a3", "\\u30ec", "\\u30ea", "\\u59a5", "\\u5f53", "\\u30d6", "\\u30de", "\\u304c", "\\u65e2", "\\u5b58", "\\u898b", "\\u3064", "\\u304b", "\\u578b", "\\u7fa9", "\\u3055", "\\u308c", "\\u30d7", "\\u30d9", "\\u30b1", "\\u3092", "\\u767b", "\\u9332", "\\u5c55", "\\u958b", "\\u304d", "\\u3089", "\\u5b57", "\\u5408", "\\u3078", "\\u5909", "\\u63db", "\\u30b5", "\\u51e6", "\\u7406", "\\u3051", "\\u308b", "\\u5165", "\\u529b", "\\u7121", "\\u52b9", "\\u30d0", "\\u4e26", "\\u3073", "\\u30a8", "\\u6700", "\\u5f8c", "\\u4e0d", "\\u5b8c", "\\u5168", "\\u30a9", "\\u30ad", "\\u7d76", "\\u542b", "\\u3060", "\\u30ed", "\\u30ab", "\\u6b63", "\\u304f", "\\u30db", "\\u540d", "\\u9593", "\\u9055", "\\u3063", "\\u30d1", "\\u6642", "\\u78ba", "\\u4fdd", "\\u8aad", "\\u8fbc", "\\u5fc5", "\\u51fa", "\\u30ba", "\\u304e", "\\u3081", "\\u53d6", "\\u5f97", "\\u5931", "\\u6557", "\\u66f4", "\\u751f", "\\u6210", "\\u66f8", "\\u30e2", "\\u524a", "\\u9664", "\\u30c6", "\\u3053", "\\u30dc", "\\u6b8b", "\\u30c1", "\\u30e3", "\\u30cd", "\\u7d42", "\\u308f", "\\u76ee", "\\u524d", "\\u5217", "\\u3002", "\\u53c2", "\\u7167", "\\u6570", "\\u4f8b", "\\u304a", "\\u305d", "\\u30df", "\\u3082", "\\u4f7f", "\\u7528", "\\u53ef", "\\u80fd", "\\u7a7a", "\\u660e", "\\u3087", "\\u3088", "\\u30e5", "\\u30e1", "\\u59cb", "\\u7d9a", "\\u672b", "\\u5c3e", "\\u5024", "\\u8a2d", "\\u7b49", "\\u53f7", "\\u8a18", "\\u5f15", "\\u9589", "\\u3058", "\\u4f55", "\\u73fe", "\\u3001", "\\u767d", "\\u30ae", "\\u76f4", "\\u4e86", "\\u7a81", "\\u7136", "\\u3071", "\\u9014", "\\u6b21", "\\u6307", "\\u793a", "\\u5b50", "\\u30aa", "\\u30b8", "\\u30a7", "\\u5185", "\\u90e8", "\\u8db3", "\\u4e0a", "\\u9650", "\\u9054", "\\u5206", "\\u6761", "\\u4ef6", "\\u65b9", "\\u518d", "\\u5e30", "\\u4f5c", "\\u696d", "\\u9818", "\\u57df", "\\u6539", "\\u9023", "\\u643a", "\\u539f", "\\u56e0", "\\u7aef", "\\u8a8d", "\\u8b58", "\\u308d", "\\u5c0f", "\\u633f", "\\u91cf", "\\u9806", "\\u756a", "\\u8868", "\\u7e70", "\\u8fd4", "\\u4ed8", "\\u898f", "\\u9577", "\\u56fa", "\\u5f62", "\\u5f0f", "\\u4e8c", "\\u4ee5", "\\u5e8f", "\\u547c", "\\u540c", "\\u4e0b", "\\u591a", "\\u500b", "\\uff18", "\\u9032", "\\uff11", "\\u77db", "\\u76fe", "\\uff10", "\\u8d85", "\\u3048", "\\u969b", "\\u9069", "\\u5316", "\\u534a", "\\u5fdc", "\\u4ee3", "\\u66ff", "\\u89e3", "\\u6790", "\\u52d5", "\\u8d77", "\\u74b0", "\\u5883", "\\u30d8", "\\u30c0", "\\u5b9f", "\\u5341", "\\u7bc4", "\\u56f2", "\\u6cd5", "\\u6574", "\\u691c", "\\u7d22", "\\u5e38", "\\u30da", "\\u91c8", "\\u6301", "\\u8ad6", "\\u6e21", "\\u64cd", "\\u7a2e", "\\u985e", "\\u65e9", "\\u5230", "\\u9805", "\\u30e6", "\\u30b6", "\\u72ec", "\\u81ea", "\\u5074", "\\u88c5", "\\u300c", "\\u300d", "\\u505c", "\\u6b62", "\\u4f53", "\\u30d4", "\\u8c61", "\\u7684", "\\u7279", "\\u5225", "\\u30b4", "\\u7bb1", "\\u6271", "\\u5207", "\\u63d0", "\\u4f9b", "\\u30bd", "\\u5145", "\\u76e3", "\\u8996", "\\u30cb", "\\u60c5", "\\u5831", "\\u62e1", "\\u5f35", "\\u72b6", "\\u614b", "\\u6a29", "\\u6240", "\\u6709", "\\u8005", "\\u65e5", "\\u3080", "\\u53e4", "\\u6c42", "\\u914d", "\\u63a8", "\\u6e2c", "\\u671f", "\\u6c7a", "\\u9006", "\\u30d3", "\\u4e00", "\\u521d", "\\u63a5", "\\uff1a", "\\u53d7", "\\u9001", "\\u5f85", "\\u8ffd", "\\u3061", "\\u88dc", "\\u52a9", "\\u62bd", "\\u7d44", "\\u96a0", "\\u89a7", "\\u3070", "\\u7d0d", "\\u7701", "\\u7565", "\\u3069", "\\u8907", "\\u1295", "\\u1270", "\\u1240", "\\u1265", "\\u120f", "\\u120d", "\\u12e8", "\\u12a5", "\\u130d", "\\u12f3", "\\u1263", "\\u12ed", "\\u1235", "\\u121d", "\\u134b", "\\u1208", "\\u121b", "\\u1260", "\\u1205", "\\u1275", "\\u12a0", "\\u1366", "\\u1230", "\\u122b", "\\u133d", "\\u1211", "\\u134d", "\\u1236", "\\u12a8", "\\u00c3", "\\u015c", "\\u011d", "\\u0109", "\\u015d", "\\u016d", "\\u0408", "\\u0b17", "\\u0b41", "\\u0b23", "\\u0b09", "\\u0b2a", "\\u0b26", "\\u0b28", "\\u0b07", "\\u0b01", "\\u0b05", "\\u0b4d", "\\u0b2f", "\\u0b36", "\\u0b3f", "\\u0b1f", "\\u0b47", "\\u0b15", "\\u0b16", "\\u0b4b", "\\u0b1c", "\\u0b32", "\\u0b39", "\\u0b38", "\\u0b42", "\\u0b1a", "\\u0b06", "\\u0b25", "\\u0b2e", "\\u0b27", "\\u0b1b", "\\u0b21", "\\u0b19", "\\u0b4c", "\\u0b2c", "\\u0b48", "\\u0b33", "\\u0b0f", "\\u0b5f", "\\u0b1e", "\\u0b37", "\\u0b2b", "\\u0b02", "\\u0b40", "\\u0b22", "\\u0b3c", "\\u0b20", "\\u0b68", "\\u0b69", "\\u0b6a", "\\u0b03", "\\u0b43", "\\u0b71", "\\u0b6e", "\\u0b67", "\\u0b6c", "\\u0964", "\\u0b18", "\\u011f", "\\u015e", "\\u0919", "\\u05de", "\\u05b8", "\\u05d3", "\\u05e0", "\\u05e2", "\\u05e4", "\\u05bf", "\\u05d8", "\\u05e6", "\\u05f2", "\\u05db", "\\u05df", "\\u05f0", "\\u05b7", "\\u05da", "\\u05d1", "\\u05be", "\\u05d2", "\\u05e1", "\\u05e5", "\\u05f1", "\\u05ea", "\\u05d4", "\\u05e3", "\\u05d6", "\\u05bc", "\\u0918", "\\u0933", "\\u0945", "\\u090a", "\\u091d", "\\u1ed9", "\\u1ea5", "\\u01b0", "\\u1edd", "\\u1ebf", "\\u1ed1", "\\u1ee7", "\\u1ebb", "\\u1ee3", "\\u1ead", "\\u1ec7", "\\u1ee5", "\\u1eef", "\\u1ecb", "\\u1ec3", "\\u1eb7", "\\u1ee9", "\\u0103", "\\u1ed7", "\\u1edf", "\\u1ef1", "\\u1eb1", "\\u1ea3", "\\u1ed5", "\\u1eeb", "\\u1ea7", "\\u1ed3", "\\u1eed", "\\u1eab", "\\u1edb", "\\u1ee1", "\\u1ecf", "\\u1ebd", "\\u1ea9", "\\u1eaf", "\\u1ec9", "\\u1ec1", "\\u1eb3", "\\u01a1", "\\u0169", "\\u0129", "\\u1ecc", "\\u0110", "\\u1eac", "\\u0171", "\\u10d5", "\\u10da", "\\u10d0", "\\u10d3", "\\u10d8", "\\u10db", "\\u10e0", "\\u10e1", "\\u10ed", "\\u10dc", "\\u10dd", "\\u10e3", "\\u10e2", "\\u10d1", "\\u10d7", "\\u10eb", "\\u10ea", "\\u10e7", "\\u10e8", "\\u10d9", "\\u10e4", "\\u10de", "\\u10ef", "\\u10ee", "\\u10e5", "\\u10d6", "\\u10ec", "\\u10e9", "\\u10e6", "\\u021b", "\\u0218", "\\u021a", "\\u00ce", "\\u0985", "\\u09aa", "\\u09cd", "\\u09af", "\\u09b6", "\\u09bf", "\\u0997", "\\u09c1", "\\u09a3", "\\u09a6", "\\u09a5", "\\u09c7", "\\u09cb", "\\u09f1", "\\u09a8", "\\u099a", "\\u09b9", "\\u0986", "\\u0995", "\\u09c8", "\\u099b", "\\u099e", "\\u099c", "\\u09a7", "\\u0987", "\\u09ae", "\\u09b8", "\\u09df", "\\u09b7", "\\u099f", "\\u09a0", "\\u09c0", "\\u09c2", "\\u09c3", "\\u09ab", "\\u0996", "\\u0981", "\\u098f", "\\u09dd", "\\u09a1", "\\u0999", "\\u0993", "\\u0983", "\\u0989", "\\u09e8", "\\u09e9", "\\u09ea", "\\u0998", "\\u09e7", "\\u09e6", "\\u09dc", "\\u098a", "\\u09ce", "\\u09eb", "\\u203a", "\\u011e", "\\u0175", "\\u0e1e", "\\u0e1a", "\\u0e41", "\\u0e15", "\\u0e23", "\\u0e34", "\\u0e27", "\\u0e4c", "\\u0e35", "\\u0e48", "\\u0e49", "\\u0e07", "\\u0e01", "\\u0e32", "\\u0e2a", "\\u0e33", "\\u0e2b", "\\u0e31", "\\u0e25", "\\u0e40", "\\u0e19", "\\u0e47", "\\u0e02", "\\u0e13", "\\u0e30", "\\u0e20", "\\u0e43", "\\u0e1f", "\\u0e0a", "\\u0e14", "\\u0e39", "\\u0e38", "\\u0e42", "\\u0e1b", "\\u0e37", "\\u0e08", "\\u0e16", "\\u0e1c", "\\u0e0b", "\\u0e2e", "\\u0e18", "\\u0e0d", "\\u0e29", "\\u0e36", "\\u0e12", "\\u0e28", "\\u0e10", "\\u0e46", "\\u0e1d", "\\u015b", "\\u0105", "\\u0119", "\\u0142", "\\u017c", "\\u017a", "\\u017b", "\\u0144", "\\u015a", "\\u0a10", "\\u0a32", "\\u0a40", "\\u0a2e", "\\u0a48", "\\u0a02", "\\u0a1f", "\\u0a08", "\\u0a17", "\\u0a41", "\\u0a23", "\\u0a28", "\\u0a39", "\\u0a71", "\\u0a3f", "\\u0a06", "\\u0a4b", "\\u0a5c", "\\u0a26", "\\u0a38", "\\u0a35", "\\u0a1a", "\\u0a21", "\\u0a07", "\\u0a15", "\\u0a22", "\\u0a2c", "\\u0a2b", "\\u0a2a", "\\u0a4c", "\\u0a1c", "\\u0a42", "\\u0a3c", "\\u0a4d", "\\u0a47", "\\u0a70", "\\u0a09", "\\u0a27", "\\u0a20", "\\u0a05", "\\u0a16", "\\u0a36", "\\u0a1d", "\\u0a1b", "\\u0a5b", "\\u0a33", "\\u0a25", "\\u0a2f", "\\u0a69", "\\u0a68", "\\u0a67", "\\u0a66", "\\u0a13", "\\u0a6d", "\\u0a0a", "\\u0a6c", "\\u0a98", "\\u0a9f", "\\u0a95", "\\u0aae", "\\u0ac7", "\\u0a85", "\\u0aa8", "\\u0abf", "\\u0a9a", "\\u0acd", "\\u0a9b", "\\u0ac0", "\\u0aaf", "\\u0ab2", "\\u0ab7", "\\u0aa3", "\\u0ac1", "\\u0a82", "\\u0ab3", "\\u0ab9", "\\u0a97", "\\u0a88", "\\u0a8f", "\\u0aa1", "\\u0a93", "\\u0acb", "\\u0aac", "\\u0aab", "\\u0aaa", "\\u0aa5", "\\u0a9c", "\\u0ab5", "\\u0a96", "\\u0ac2", "\\u0ab8", "\\u0a86", "\\u0aa7", "\\u0ab6", "\\u0a87", "\\u0ac8", "\\u0aa6", "\\u0aa2", "\\u0a89", "\\u0acc", "\\u0a83", "\\u0a9e", "\\u0aa0", "\\u0ae9", "\\u0ae8", "\\u0ae7", "\\u0ae6", "\\u0a9d", "\\u0aee", "\\u0aec", "\\u0ac3", "\\u039c", "\\u03b7", "\\u03b1", "\\u03bd", "\\u03bc", "\\u03cc", "\\u03bf", "\\u03b3", "\\u03ce", "\\u03c1", "\\u03b9", "\\u03c3", "\\u03c4", "\\u03c7", "\\u03af", "\\u03a4", "\\u03b4", "\\u03b2", "\\u03ad", "\\u03b8", "\\u03ba", "\\u0391", "\\u03c0", "\\u0394", "\\u03c2", "\\u03c9", "\\u03a5", "\\u03ac", "\\u03ae", "\\u03cd", "\\u039a", "\\u03c6", "\\u03be", "\\u0397", "\\u03b6", "\\u03a3", "\\u03c8", "\\u039f", "\\u0395", "\\u03a0", "\\u0386", "\\u03a7", "\\u0399", "\\u039b", "\\u0393", "\\u03a1", "\\u0990", "\\u04af", "\\u04e8", "\\u04e9", "\\u0425", "\\u0b8e", "\\u0ba3", "\\u0bc1", "\\u0bb1", "\\u0b89", "\\u0bae", "\\u0bb5", "\\u0b92", "\\u0b9f", "\\u0bb3", "\\u0b85", "\\u0ba9", "\\u0bcb", "\\u0b8f", "\\u0bc7", "\\u0bca", "\\u0bb4", "\\u0bc6", "\\u0b90", "\\u0b86", "\\u0bc0", "\\u0b93", "\\u0b9c", "\\u0b88", "\\u0b83", "\\u0bb8", "\\u0b8a", "\\u5143", "\\u672a", "\\u9810", "\\u5c6c", "\\u627e", "\\u6a19", "\\u7c64", "\\uff0c", "\\u61c9", "\\u70ba", "\\u8cc7", "\\u6599", "\\u9304", "\\u6548", "\\u6a94", "\\u6848", "\\u5df2", "\\u7d93", "\\u6c92", "\\u79c1", "\\u65d7", "\\u5e5f", "\\u7fa3", "\\u7a0b", "\\u8a3b", "\\u518a", "\\u652f", "\\u63f4", "\\u5c07", "\\u7b26", "\\u8f49", "\\u81f3", "\\u8f38", "\\u9047", "\\u4f4d", "\\u767c", "\\u932f", "\\u8aa4", "\\u7d50", "\\u675f", "\\u4ecd", "\\u5099", "\\u4e32", "\\u662f", "\\u7d55", "\\u5c0d", "\\u672c", "\\u6a5f", "\\u4e3b", "\\u7a31", "\\u8df3", "\\u8def", "\\u5f91", "\\u555f", "\\u7f6e", "\\u4f86", "\\u8b80", "\\u592a", "\\u904e", "\\u5de8", "\\u7372", "\\u7531", "\\u5efa", "\\u7acb", "\\u5beb", "\\u95dc", "\\u6a23", "\\u5305", "\\u865f", "\\u5668", "\\u7de9", "\\u885d", "\\u5340", "\\u4e4b", "\\u7ba1", "\\u9053", "\\u7b2c", "\\u7de8", "\\u78bc", "\\u53c3", "\\u5167", "\\u8a72", "\\u6578", "\\uff08", "\\u5982", "\\uff09", "\\uff1b", "\\u5f88", "\\u4f46", "\\u5b83", "\\u8b8a", "\\u5be6", "\\u9ad4", "\\u8acb", "\\u4efb", "\\u610f", "\\u9808", "\\u9019", "\\u4efd", "\\u53ea", "\\u5c0b", "\\u65bc", "\\u6216", "\\u4e5f", "\\u8a31", "\\u7576", "\\u503c", "\\u5141", "\\u5c16", "\\u89d2", "\\u62ec", "\\u8655", "\\u640d", "\\u6bc0", "\\u7269", "\\u61b6", "\\u8017", "\\u76e1", "\\u56de", "\\u6eaf", "\\u6b64", "\\u6a21", "\\u6bd4", "\\u53cd", "\\u5411", "\\u689d", "\\u905e", "\\u5efb", "\\u8fa8", "\\u7740", "\\u88cf", "\\u985b", "\\u5012", "\\u7f3a", "\\u5c11", "\\u812b", "\\u570d", "\\u6771", "\\u897f", "\\u91cd", "\\u547d", "\\u55ae", "\\u982d", "\\u5224", "\\u65b7", "\\u5ea6", "\\u5169", "\\u77e5", "\\u53eb", "\\u5708", "\\u5177", "\\u76f8", "\\u81f4", "\\u9078", "\\u96a8", "\\u5f27", "\\u975e", "\\u96f6", "\\u6ea2", "\\u6d41", "\\u8b6f", "\\u5148", "\\u6838", "\\u5eab", "\\u4f73", "\\u4ee4", "\\u5176", "\\u5c31", "\\u5f9e", "\\u526f", "\\u548c", "\\u6e9d", "\\u57f7", "\\u5354", "\\u8a08", "\\u884d", "\\u5c0e", "\\u5920", "\\u8aaa", "\\u986f", "\\u7d66", "\\u96d9", "\\u7cbe", "\\u6d6e", "\\u9ede", "\\u9375", "\\u88ab", "\\u908f", "\\u8f2f", "\\u50b3", "\\u6d88", "\\u684c", "\\u9762", "\\u6b04", "\\u593e", "\\u88dd", "\\u9000", "\\u529f", "\\u5a92", "\\u8f2a", "\\u8a62", "\\u7248", "\\u639b", "\\u8f09", "\\u88fd", "\\u6b8a", "\\u6536", "\\u7b52", "\\u5132", "\\u5c1a", "\\u8209", "\\u7570", "\\u826f", "\\u641c", "\\u622a", "\\u77ed", "\\u4ecb", "\\u6b78", "\\u5716", "\\u5730", "\\u7cfb", "\\u7d71", "\\u6839", "\\u5553", "\\u9802", "\\u5c64", "\\u7d1a", "\\u5ef6", "\\u4f38", "\\u72c0", "\\u63cf", "\\u8ff0", "\\u6b0a", "\\u64c1", "\\u4fee", "\\u523b", "\\u806f", "\\u820a", "\\u66ab", "\\u9663", "\\u5378", "\\u5bb9", "\\u6b65", "\\u6e90", "\\u670d", "\\u52d9", "\\u7d00", "\\u9060", "\\u807d", "\\u7d81", "\\u7dda", "\\u5019", "\\u6cc1", "\\u606f", "\\u7a97", "\\u90f5", "\\u63a7", "\\u5236", "\\u537b", "\\u8f14", "\\u6388", "\\u96b1", "\\u85cf", "\\u679c", "\\u50cf", "\\u994b", "\\u5426", "\\u7e2e", "\\u5247", "\\u5ffd", "\\u0165", "\\u013e", "\\u010f", "\\u013a", "\\u013d", "\\u0148", "\\u013c", "\\u0146", "\\u0db8", "\\u0dd6", "\\u0dba", "\\u0dc3", "\\u0db3", "\\u0dc4", "\\u0db6", "\\u0db4", "\\u0ddc", "\\u0dbb", "\\u0dad", "\\u0dca", "\\u0dd4", "\\u0db1", "\\u0dc0", "\\u0dd2", "\\u0dc1", "\\u0dda", "\\u0dc2", "\\u0dab", "\\u0dd9", "\\u0dd0", "\\u0da7", "\\u0d9c", "\\u0dc5", "\\u0d87", "\\u0daf", "\\u0db7", "\\u0dd8", "\\u0db0", "\\u0ddd", "\\u0dd3", "\\u0d85", "\\u0d89", "\\u0d86", "\\u0da9", "\\u0d9b", "\\u0d8b", "\\u045c", "\\u0453", "\\u0403", "\\u0c98", "\\u0c9f", "\\u0c95", "\\u0ccd", "\\u0cc6", "\\u0c85", "\\u0ca8", "\\u0caa", "\\u0cc7", "\\u0cb7", "\\u0cbf", "\\u0c97", "\\u0cc1", "\\u0ca3", "\\u0cb5", "\\u0cb6", "\\u0ca6", "\\u0caf", "\\u0cb2", "\\u0c9a", "\\u0c9b", "\\u0cb8", "\\u0c92", "\\u0cb3", "\\u0c82", "\\u0ccb", "\\u0cae", "\\u0cac", "\\u0ca1", "\\u0c88", "\\u0c96", "\\u0cc2", "\\u0cb9", "\\u0c9c", "\\u0c8e", "\\u0cca", "\\u0cab", "\\u0c86", "\\u0cc8", "\\u0ca7", "\\u0ca5", "\\u0cc0", "\\u0c93", "\\u0c89", "\\u0ca0", "\\u0c87", "\\u0c83", "\\u0ccc", "\\u0c8f", "\\u0c9e", "\\u0cc3", "\\u0c8a", "\\u0159", "\\u011b", "\\u016f", "\\u0158", "\\uc608", "\\uc0c1", "\\uce58", "\\ubabb", "\\ud558", "\\uac8c", "\\uc5d8", "\\ub9ac", "\\uba3c", "\\ud2b8", "\\uc5d0", "\\uc560", "\\ubdf0", "\\uac00", "\\uc788", "\\uc2b5", "\\ub2c8", "\\ub2e4", "\\uc5c6", "\\ud0dc", "\\uadf8", "\\uc5b4", "\\uc57c", "\\ud569", "\\uc548", "\\ub370", "\\uc774", "\\ud130", "\\ub514", "\\ub809", "\\ud1a0", "\\uc62c", "\\ubc14", "\\ub978", "\\ubd81", "\\ub9c8", "\\ud06c", "\\ud30c", "\\uc77c", "\\ub300", "\\ubbf8", "\\ud0c0", "\\uc785", "\\uac1c", "\\uc778", "\\ud50c", "\\ub798", "\\ub8f9", "\\uc124", "\\uc815", "\\ub418", "\\uc9c0", "\\uc54a", "\\ub984", "\\ub5a4", "\\ud504", "\\ub85c", "\\ub7a8", "\\ub3c4", "\\ub97c", "\\ub4f1", "\\ub85d", "\\uc558", "\\uc744", "\\uc0ac", "\\uc6a9", "\\ud574", "\\uc2e4", "\\ud589", "\\uc904", "\\ud655", "\\uc7a5", "\\uae30", "\\ud328", "\\ud588", "\\ubb38", "\\uc790", "\\uc14b", "\\uc11c", "\\uc73c", "\\ubcc0", "\\ud658", "\\uc740", "\\uc6d0", "\\ub294", "\\uc5f4", "\\uc218", "\\ub825", "\\uc798", "\\ub41c", "\\uc21c", "\\uc911", "\\uc624", "\\ub958", "\\uc758", "\\ub05d", "\\ubd80", "\\ubd84", "\\uc801", "\\ucf54", "\\ub4dc", "\\uccb4", "\\ud568", "\\uc2a4", "\\ud0a4", "\\uc808", "\\uacbd", "\\uc544", "\\ub2d9", "\\uceec", "\\ub4e4", "\\uac08", "\\uc5c8", "\\ud638", "\\ucf00", "\\uc5ec", "\\uc77d", "\\ud560", "\\ub2f9", "\\ub108", "\\ubb34", "\\ud07d", "\\uc18d", "\\uc838", "\\uafb8", "\\ub9cc", "\\uc4f0", "\\ub2eb", "\\uc874", "\\uc6b8", "\\ud15c", "\\uba74", "\\ub429", "\\uc2ec", "\\ubcfc", "\\ub9ad", "\\ub9c1", "\\uc74c", "\\ubc84", "\\ud37c", "\\ub0a8", "\\uaca8", "\\ub460", "\\ucc44", "\\ub110", "\\ub0c4", "\\ub9e4", "\\ud551", "\\uc9f8", "\\ub529", "\\ud14d", "\\ub974", "\\uad6c", "\\uc11d", "\\ucc38", "\\uc870", "\\uc22b", "\\uc368", "\\ud074", "\\uc138", "\\ucf5c", "\\ub860", "\\ub098", "\\uc6b0", "\\uc5d4", "\\ud2f0", "\\uc2dc", "\\uc791", "\\ub824", "\\uace0", "\\uacf3", "\\uac83", "\\ub7f0", "\\ub77c", "\\uc2ed", "\\uc751", "\\ud5c8", "\\ube44", "\\ucc3e", "\\uc54c", "\\ub3d9", "\\ubc88", "\\uc5ed", "\\uc4f8", "\\ube48", "\\ub0b4", "\\ud639", "\\uac70", "\\uc640", "\\uc4f4", "\\uac12", "\\ub54c", "\\ub530", "\\uc634", "\\ud45c", "\\ud614", "\\ud604", "\\uc7ac", "\\uacf5", "\\ubc31", "\\uac11", "\\ub7fd", "\\ub0ac", "\\ub9c9", "\\ub358", "\\uc8fc", "\\ucc98", "\\uc190", "\\ub610", "\\uba54", "\\ubaa8", "\\uc871", "\\ucd94", "\\ucd5c", "\\ub2ec", "\\ud134", "\\ud56d", "\\ubaa9", "\\ud6c4", "\\uc704", "\\uac74", "\\uadc0", "\\uc5c5", "\\uac04", "\\uafc8", "\\uc2dd", "\\uc18c", "\\ubc97", "\\uad04", "\\ube60", "\\uc84c", "\\ud000", "\\ubc94", "\\ubc18", "\\ubcf5", "\\ub124", "\\uc784", "\\ube0c", "\\uaddc", "\\ubcf4", "\\ub8e9", "\\uc158", "\\uae38", "\\ud615", "\\ub79c", "\\ub9ce", "\\uc804", "\\ucd9c", "\\ud788", "\\uae00", "\\uac19", "\\uae41", "\\uc9c4", "\\ub7ec", "\\uad00", "\\uc635", "\\ub458", "\\uc2fc", "\\ub2cc", "\\ub118", "\\uac14", "\\uac80", "\\ub9de", "\\ubc1c", "\\uc0dd", "\\ud654", "\\uafc0", "\\ub2a5", "\\ub9d0", "\\ub5bb", "\\uba85", "\\ub839", "\\uc178", "\\ud1b5", "\\uc2e0", "\\uc6c0", "\\ud3ec", "\\ud544", "\\uc694", "\\ubc16", "\\ubc95", "\\ubd05", "\\ub4e0", "\\ubc30", "\\uc0c9", "\\uc30d", "\\ub2e8", "\\ubd88", "\\uc5b8", "\\uae34", "\\uce74", "\\uc6b4", "\\ub9bc", "\\ucde8", "\\uc885", "\\ucc0d", "\\ud3f4", "\\ub354", "\\ud070", "\\ub36e", "\\ud2b9", "\\ud734", "\\ub968", "\\ub274", "\\uba38", "\\ub808", "\\ud398", "\\ucf58", "\\ucf13", "\\ubcf8", "\\ub8e8", "\\uc81c", "\\ub9b4", "\\uc62e", "\\ub9bd", "\\uad8c", "\\uc720", "\\uac01", "\\uc811", "\\uadfc", "\\ucee8", "\\uc678", "\\ub00c", "\\uccad", "\\uacc4", "\\ub0bc", "\\ucd08", "\\uaca9", "\\uc5f0", "\\uacb0", "\\ubc1b", "\\ubc00", "\\ub9b0", "\\uc708", "\\uc988", "\\ub864", "\\ub2c9", "\\uacfc", "\\uc228", "\\ub7fc", "\\uc644", "\\u0117", "\\u0173", "\\u012f", "\\u0179", "\\u0141", "\\u7b7e", "\\u9700", "\\u65e0", "\\u636e", "\\u5f55", "\\u7ecf", "\\u4e49", "\\u7c7b", "\\u5fd7", "\\u8bbe", "\\u7ec4", "\\u6ca1", "\\u4e3a", "\\u5e94", "\\u6ce8", "\\u518c", "\\u5f00", "\\u8d25", "\\u4ece", "\\u8f6c", "\\u6362", "\\u6253", "\\u8f93", "\\u73b0", "\\u8fc7", "\\u9519", "\\u5c3d", "\\u540e", "\\u5907", "\\u7edd", "\\u5bf9", "\\u5f84", "\\u65f6", "\\u53d1", "\\u8bef", "\\u8282", "\\u8bfb", "\\u83b7", "\\u5c06", "\\u521b", "\\u5199", "\\u5173", "\\u95ed", "\\u5220", "\\u677f", "\\u8be5", "\\u94fe", "\\u51fd", "\\u8fdb", "\\u7f13", "\\u51b2", "\\u7559", "\\u7ec8", "\\u4e8e", "\\u6620", "\\u5c04", "\\u4e2a", "\\u7f16", "\\u7801", "\\u79f0", "\\u7ed3", "\\u60a8", "\\u800c", "\\u53c8", "\\u5b9e", "\\u8fd9", "\\u53d8", "\\u8bb8", "\\u6863", "\\u987b", "\\u5934", "\\u6765", "\\u8bb0", "\\u7d27", "\\u8ddf", "\\u7ed9", "\\u8d4b", "\\u4ec5", "\\u8fd8", "\\u53f3", "\\u91ca", "\\u5904", "\\u8fbe", "\\u5339", "\\u9879", "\\u9012", "\\u5f52", "\\u95f4", "\\u8bc6", "\\u522b", "\\u98a0", "\\u8303", "\\u56f4", "\\u590d", "\\u5219", "\\u957f", "\\u65ad", "\\u8a00", "\\u786e", "\\u4e24", "\\u8c03", "\\u5bfc", "\\u5faa", "\\u73af", "\\u9009", "\\u82b1", "\\u9884", "\\u8bd1", "\\u533a", "\\u68c0", "\\u67e5", "\\u5e93", "\\u4f18", "\\u671b", "\\u516d", "\\u4e22", "\\u4ed6", "\\u4e0e", "\\u8baf", "\\u6267", "\\u5f02", "\\u591f", "\\u5e2e", "\\u663e", "\\u53cc", "\\u952e", "\\u666e", "\\u70b9", "\\u5e03", "\\u5c14", "\\u4f20", "\\u8ba1", "\\u6237", "\\u5939", "\\u9a71", "\\u63a2", "\\u5f39", "\\u8f6e", "\\u8be2", "\\u6302", "\\u8f7d", "\\u5783", "\\u573e", "\\u5377", "\\u679a", "\\u4e3e", "\\u53e3", "\\u5957", "\\u9ed8", "\\u8ba4", "\\u76d1", "\\u89c6", "\\u7edf", "\\u653e", "\\u9876", "\\u7ea7", "\\u6269", "\\u6001", "\\u6743", "\\u8bbf", "\\u95ee", "\\u542f", "\\u65e7", "\\u62f7", "\\u8d1d", "\\u4e34", "\\u8bf7", "\\u731c", "\\u6d4b", "\\u52a1", "\\u6682", "\\u534f", "\\u8bae", "\\u64a4", "\\u9500", "\\u8fdc", "\\u542c", "\\u7ed1", "\\u8fde", "\\u51b3", "\\u589e", "\\u5374", "\\u8f85", "\\u6458", "\\u9690", "\\u90fd", "\\u628a", "\\u7f29", "\\u521a", "\\u0d0e", "\\u0d32", "\\u0d2e", "\\u0d46", "\\u0d28", "\\u0d4d", "\\u0d31", "\\u0d3f", "\\u0d05", "\\u0d2a", "\\u0d40", "\\u0d15", "\\u0d37", "\\u0d2f", "\\u0d38", "\\u0d35", "\\u0d36", "\\u0d47", "\\u0d23", "\\u0d1f", "\\u0d41", "\\u0d17", "\\u0d1a", "\\u0d09", "\\u0d33", "\\u0d21", "\\u0d27", "\\u0d2c", "\\u0d2b", "\\u0d42", "\\u0d4a", "\\u0d12", "\\u0d4b", "\\u0d1c", "\\u0d07", "\\u0d48", "\\u0d39", "\\u0d19", "\\u0d25", "\\u0d06", "\\u0d43", "\\u0d34", "\\u0d26", "\\u0d16", "\\u0d13", "\\u0d1e", "\\u0d08", "\\u0d14", "\\u0d4c", "\\u0d0f", "\\u0d10", "\\u7fa4", "\\u8457", "\\u88e1", "\\u8a02", "\\u8a9e", "\\u0307", "\\u0345", "\\u0314", "\\u00cc", "\\u0300", "\\u0301", "\\u0128", "\\u0303", "\\u0328", "\\u012e", "\\ufb04", "\\u00ca", "\\u00d1", "\\u00d4", "\\u0178", "\\u0100", "\\u0102", "\\u0104", "\\u0106", "\\u0108", "\\u010a", "\\u010b", "\\u010e", "\\u0112", "\\u0114", "\\u0115", "\\u0116", "\\u0118", "\\u011a", "\\u011c", "\\u0120", "\\u0122", "\\u0123", "\\u0124", "\\u0125", "\\u0126", "\\u0127", "\\u012c", "\\u012d", "\\u0132", "\\u0133", "\\u0134", "\\u0135", "\\u0136", "\\u0137", "\\u0138", "\\u0139", "\\u013b", "\\u013f", "\\u0140", "\\u0143", "\\u0145", "\\u0147", "\\u0149", "\\u02bc", "\\u014a", "\\u014b", "\\u014c", "\\u014e", "\\u0150", "\\u0152", "\\u0153", "\\u0154", "\\u0155", "\\u0156", "\\u0157", "\\u0162", "\\u0163", "\\u0164", "\\u0166", "\\u0167", "\\u0168", "\\u016a", "\\u016c", "\\u016e", "\\u0170", "\\u0172", "\\u0174", "\\u0176", "\\u0177", "\\u017f", "\\u0180", "\\u0243", "\\u0181", "\\u0253", "\\u0182", "\\u0183", "\\u0184", "\\u0185", "\\u0186", "\\u0254", "\\u0187", "\\u0188", "\\u0189", "\\u0256", "\\u018a", "\\u0257", "\\u018b", "\\u018c", "\\u018d", "\\u018e", "\\u01dd", "\\u0190", "\\u025b", "\\u0191", "\\u0192", "\\u0193", "\\u0260", "\\u0194", "\\u0263", "\\u0195", "\\u01f6", "\\u0196", "\\u0269", "\\u0197", "\\u0268", "\\u0198", "\\u0199", "\\u019a", "\\u023d", "\\u019b", "\\u019c", "\\u026f", "\\u019d", "\\u0272", "\\u019e", "\\u0220", "\\u019f", "\\u0275", "\\u01a0", "\\u01a2", "\\u01a3", "\\u01a4", "\\u01a5", "\\u01a6", "\\u0280", "\\u01a7", "\\u01a8", "\\u01a9", "\\u0283", "\\u01aa", "\\u01ab", "\\u01ac", "\\u01ad", "\\u01ae", "\\u0288", "\\u01af", "\\u01b1", "\\u028a", "\\u01b2", "\\u028b", "\\u01b3", "\\u01b4", "\\u01b5", "\\u01b6", "\\u01b7", "\\u0292", "\\u01b8", "\\u01b9", "\\u01ba", "\\u01bc", "\\u01bd", "\\u01be", "\\u01bf", "\\u01f7", "\\u01c4", "\\u01c6", "\\u01c5", "\\u01c7", "\\u01c9", "\\u01c8", "\\u01ca", "\\u01cc", "\\u01cb", "\\u01cd", "\\u01cf", "\\u01d1", "\\u01d3", "\\u01d5", "\\u01d6", "\\u01d7", "\\u01d8", "\\u01d9", "\\u01da", "\\u01db", "\\u01dc", "\\u01de", "\\u01df", "\\u01e0", "\\u01e1", "\\u01e2", "\\u01e3", "\\u01e4", "\\u01e5", "\\u01e6", "\\u01e7", "\\u01e8", "\\u01e9", "\\u01ea", "\\u01eb", "\\u01ec", "\\u01ed", "\\u01ee", "\\u01ef", "\\u01f0", "\\u030c", "\\u01f1", "\\u01f3", "\\u01f2", "\\u01f4", "\\u01f5", "\\u01f8", "\\u01f9", "\\u01fa", "\\u01fb", "\\u01fc", "\\u01fd", "\\u01fe", "\\u01ff", "\\u0200", "\\u0201", "\\u0202", "\\u0203", "\\u0204", "\\u0205", "\\u0206", "\\u0207", "\\u0208", "\\u0209", "\\u020a", "\\u020b", "\\u020c", "\\u020d", "\\u020e", "\\u020f", "\\u0210", "\\u0211", "\\u0212", "\\u0213", "\\u0214", "\\u0215", "\\u0216", "\\u0217", "\\u021c", "\\u021d", "\\u021e", "\\u021f", "\\u0221", "\\u0222", "\\u0223", "\\u0224", "\\u0225", "\\u0226", "\\u0227", "\\u0228", "\\u0229", "\\u022a", "\\u022b", "\\u022c", "\\u022d", "\\u022e", "\\u022f", "\\u0230", "\\u0231", "\\u0232", "\\u0233", "\\u0234", "\\u0235", "\\u0236", "\\u0237", "\\u0238", "\\u0239", "\\u023a", "\\u2c65", "\\u023b", "\\u023c", "\\u023e", "\\u2c66", "\\u023f", "\\u0240", "\\u0241", "\\u0242", "\\u0244", "\\u0289", "\\u0245", "\\u028c", "\\u0246", "\\u0247", "\\u0248", "\\u0249", "\\u024a", "\\u024b", "\\u024c", "\\u024d", "\\u024e", "\\u024f", "\\u0250", "\\u2c6f", "\\u0251", "\\u2c6d", "\\u0252", "\\u0255", "\\u0258", "\\u025a", "\\u025c", "\\u025d", "\\u025e", "\\u025f", "\\u0261", "\\u0262", "\\u0264", "\\u0265", "\\u0266", "\\u0267", "\\u026a", "\\u026b", "\\u2c62", "\\u026c", "\\u026d", "\\u026e", "\\u0270", "\\u0271", "\\u2c6e", "\\u0273", "\\u0274", "\\u0276", "\\u0277", "\\u0278", "\\u0279", "\\u027a", "\\u027b", "\\u027c", "\\u027d", "\\u2c64", "\\u027e", "\\u027f", "\\u0281", "\\u0282", "\\u0284", "\\u0285", "\\u0286", "\\u0287", "\\u028d", "\\u028e", "\\u028f", "\\u0290", "\\u0291", "\\u0293", "\\u0295", "\\u0296", "\\u0297", "\\u0298", "\\u0299", "\\u029a", "\\u029b", "\\u029c", "\\u029d", "\\u029e", "\\u029f", "\\u02a0", "\\u02a1", "\\u02a2", "\\u02a3", "\\u02a4", "\\u02a5", "\\u02a6", "\\u02a7", "\\u02a8", "\\u02a9", "\\u02aa", "\\u02ab", "\\u02ac", "\\u02ad", "\\u02ae", "\\u02af", "\\u0370", "\\u0371", "\\u0372", "\\u0373", "\\u0376", "\\u0377", "\\u037b", "\\u03fd", "\\u037c", "\\u03fe", "\\u037d", "\\u03ff", "\\u0388", "\\u0389", "\\u038a", "\\u038c", "\\u038e", "\\u038f", "\\u0390", "\\u0308", "\\u0392", "\\u0396", "\\u0398", "\\u039d", "\\u039e", "\\u03a6", "\\u03a8", "\\u03a9", "\\u03aa", "\\u03ca", "\\u03ab", "\\u03cb", "\\u03b0", "\\u03cf", "\\u03d7", "\\u03d0", "\\u03d1", "\\u03d2", "\\u03d3", "\\u03d4", "\\u03d5", "\\u03d6", "\\u03d8", "\\u03d9", "\\u03da", "\\u03db", "\\u03dc", "\\u03dd", "\\u03de", "\\u03df", "\\u03e0", "\\u03e1", "\\u03e2", "\\u03e3", "\\u03e4", "\\u03e5", "\\u03e6", "\\u03e7", "\\u03e8", "\\u03e9", "\\u03ea", "\\u03eb", "\\u03ec", "\\u03ed", "\\u03ee", "\\u03ef", "\\u03f0", "\\u03f1", "\\u03f2", "\\u03f9", "\\u03f3", "\\u03f4", "\\u03f5", "\\u03f7", "\\u03f8", "\\u03fa", "\\u03fb", "\\u03fc", "\\u0400", "\\u0450", "\\u0401", "\\u0402", "\\u0404", "\\u0405", "\\u0455", "\\u0407", "\\u0409", "\\u040a", "\\u040b", "\\u040c", "\\u040d", "\\u045d", "\\u040e", "\\u040f", "\\u045f", "\\u0429", "\\u042a", "\\u042b", "\\u0460", "\\u0461", "\\u0462", "\\u0463", "\\u0464", "\\u0465", "\\u0466", "\\u0467", "\\u0468", "\\u0469", "\\u046a", "\\u046b", "\\u046c", "\\u046d", "\\u046e", "\\u046f", "\\u0470", "\\u0471", "\\u0472", "\\u0473", "\\u0474", "\\u0475", "\\u0476", "\\u0477", "\\u0478", "\\u0479", "\\u047a", "\\u047b", "\\u047c", "\\u047d", "\\u047e", "\\u047f", "\\u0480", "\\u0481", "\\u048a", "\\u048b", "\\u048c", "\\u048d", "\\u048e", "\\u048f", "\\u0490", "\\u0491", "\\u0492", "\\u0493", "\\u0494", "\\u0495", "\\u0496", "\\u0497", "\\u0498", "\\u0499", "\\u049a", "\\u049c", "\\u049d", "\\u049e", "\\u049f", "\\u04a0", "\\u04a1", "\\u04a2", "\\u04a3", "\\u04a4", "\\u04a5", "\\u04a6", "\\u04a7", "\\u04a8", "\\u04a9", "\\u04aa", "\\u04ab", "\\u04ac", "\\u04ad", "\\u04ae", "\\u04b0", "\\u04b1", "\\u04b2", "\\u04b3", "\\u04b4", "\\u04b5", "\\u04b6", "\\u04b7", "\\u04b8", "\\u04b9", "\\u04ba", "\\u04bb", "\\u04bc", "\\u04bd", "\\u04be", "\\u04bf", "\\u04c0", "\\u04cf", "\\u04c1", "\\u04c2", "\\u04c3", "\\u04c4", "\\u04c5", "\\u04c6", "\\u04c7", "\\u04c8", "\\u04c9", "\\u04ca", "\\u04cb", "\\u04cc", "\\u04cd", "\\u04ce", "\\u04d0", "\\u04d1", "\\u04d2", "\\u04d3", "\\u04d4", "\\u04d5", "\\u04d6", "\\u04d7", "\\u04d8", "\\u04d9", "\\u04da", "\\u04db", "\\u04dc", "\\u04dd", "\\u04de", "\\u04df", "\\u04e0", "\\u04e1", "\\u04e2", "\\u04e3", "\\u04e4", "\\u04e5", "\\u04e6", "\\u04e7", "\\u04ea", "\\u04eb", "\\u04ec", "\\u04ed", "\\u04ee", "\\u04ef", "\\u04f0", "\\u04f1", "\\u04f2", "\\u04f3", "\\u04f4", "\\u04f5", "\\u04f6", "\\u04f7", "\\u04f8", "\\u04f9", "\\u04fa", "\\u04fb", "\\u04fc", "\\u04fd", "\\u04fe", "\\u04ff", "\\u0500", "\\u0501", "\\u0502", "\\u0503", "\\u0504", "\\u0505", "\\u0506", "\\u0507", "\\u0508", "\\u0509", "\\u050a", "\\u050b", "\\u050c", "\\u050d", "\\u050e", "\\u050f", "\\u0510", "\\u0511", "\\u0512", "\\u0513", "\\u0514", "\\u0515", "\\u0516", "\\u0517", "\\u0518", "\\u0519", "\\u051a", "\\u051b", "\\u051c", "\\u051d", "\\u051e", "\\u051f", "\\u0520", "\\u0521", "\\u0522", "\\u0523", "\\u0531", "\\u0532", "\\u0533", "\\u0534", "\\u0535", "\\u0536", "\\u0566", "\\u0537", "\\u0538", "\\u0539", "\\u053a", "\\u056a", "\\u053b", "\\u053c", "\\u053d", "\\u053e", "\\u0540", "\\u0571", "\\u0542", "\\u0543", "\\u0573", "\\u0544", "\\u0545", "\\u0546", "\\u0547", "\\u0577", "\\u0548", "\\u054a", "\\u054b", "\\u054c", "\\u054e", "\\u054f", "\\u0550", "\\u0552", "\\u0554", "\\u0555", "\\u10a0", "\\u2d00", "\\u10a1", "\\u2d01", "\\u10a2", "\\u2d02", "\\u10a3", "\\u2d03", "\\u10a4", "\\u2d04", "\\u10a5", "\\u2d05", "\\u10a6", "\\u2d06", "\\u10a7", "\\u2d07", "\\u10a8", "\\u2d08", "\\u10a9", "\\u2d09", "\\u10aa", "\\u2d0a", "\\u10ab", "\\u2d0b", "\\u10ac", "\\u2d0c", "\\u10ad", "\\u2d0d", "\\u10ae", "\\u2d0e", "\\u10af", "\\u2d0f", "\\u10b0", "\\u2d10", "\\u10b1", "\\u2d11", "\\u10b2", "\\u2d12", "\\u10b3", "\\u2d13", "\\u10b4", "\\u2d14", "\\u10b5", "\\u2d15", "\\u10b6", "\\u2d16", "\\u10b7", "\\u2d17", "\\u10b8", "\\u2d18", "\\u10b9", "\\u2d19", "\\u10ba", "\\u2d1a", "\\u10bb", "\\u2d1b", "\\u10bc", "\\u2d1c", "\\u10bd", "\\u2d1d", "\\u10be", "\\u2d1e", "\\u10bf", "\\u2d1f", "\\u10c0", "\\u2d20", "\\u10c1", "\\u2d21", "\\u10c2", "\\u2d22", "\\u10c3", "\\u2d23", "\\u10c4", "\\u2d24", "\\u10c5", "\\u2d25", "\\u1d00", "\\u1d01", "\\u1d02", "\\u1d03", "\\u1d04", "\\u1d05", "\\u1d06", "\\u1d07", "\\u1d08", "\\u1d09", "\\u1d0a", "\\u1d0b", "\\u1d0c", "\\u1d0d", "\\u1d0e", "\\u1d0f", "\\u1d10", "\\u1d11", "\\u1d12", "\\u1d13", "\\u1d14", "\\u1d15", "\\u1d16", "\\u1d17", "\\u1d18", "\\u1d19", "\\u1d1a", "\\u1d1b", "\\u1d1c", "\\u1d1d", "\\u1d1e", "\\u1d1f", "\\u1d20", "\\u1d21", "\\u1d22", "\\u1d23", "\\u1d24", "\\u1d25", "\\u1d26", "\\u1d27", "\\u1d28", "\\u1d29", "\\u1d2a", "\\u1d2b", "\\u1d62", "\\u1d63", "\\u1d64", "\\u1d65", "\\u1d66", "\\u1d67", "\\u1d68", "\\u1d69", "\\u1d6a", "\\u1d6b", "\\u1d6c", "\\u1d6d", "\\u1d6e", "\\u1d6f", "\\u1d70", "\\u1d71", "\\u1d72", "\\u1d73", "\\u1d74", "\\u1d75", "\\u1d76", "\\u1d77", "\\u1d79", "\\ua77d", "\\u1d7a", "\\u1d7b", "\\u1d7c", "\\u1d7d", "\\u2c63", "\\u1d7e", "\\u1d7f", "\\u1d80", "\\u1d81", "\\u1d82", "\\u1d83", "\\u1d84", "\\u1d85", "\\u1d86", "\\u1d87", "\\u1d88", "\\u1d89", "\\u1d8a", "\\u1d8b", "\\u1d8c", "\\u1d8d", "\\u1d8e", "\\u1d8f", "\\u1d90", "\\u1d91", "\\u1d92", "\\u1d93", "\\u1d94", "\\u1d95", "\\u1d96", "\\u1d97", "\\u1d98", "\\u1d99", "\\u1d9a", "\\u1e00", "\\u1e01", "\\u1e02", "\\u1e03", "\\u1e04", "\\u1e05", "\\u1e06", "\\u1e07", "\\u1e08", "\\u1e09", "\\u1e0a", "\\u1e0b", "\\u1e0c", "\\u1e0d", "\\u1e0e", "\\u1e0f", "\\u1e10", "\\u1e11", "\\u1e12", "\\u1e13", "\\u1e14", "\\u1e15", "\\u1e16", "\\u1e17", "\\u1e18", "\\u1e19", "\\u1e1a", "\\u1e1b", "\\u1e1c", "\\u1e1d", "\\u1e1e", "\\u1e1f", "\\u1e20", "\\u1e21", "\\u1e22", "\\u1e23", "\\u1e24", "\\u1e25", "\\u1e26", "\\u1e27", "\\u1e28", "\\u1e29", "\\u1e2a", "\\u1e2b", "\\u1e2c", "\\u1e2d", "\\u1e2e", "\\u1e2f", "\\u1e30", "\\u1e31", "\\u1e32", "\\u1e33", "\\u1e34", "\\u1e35", "\\u1e36", "\\u1e37", "\\u1e38", "\\u1e39", "\\u1e3a", "\\u1e3b", "\\u1e3c", "\\u1e3d", "\\u1e3e", "\\u1e3f", "\\u1e40", "\\u1e41", "\\u1e42", "\\u1e43", "\\u1e44", "\\u1e46", "\\u1e47", "\\u1e48", "\\u1e49", "\\u1e4a", "\\u1e4b", "\\u1e4c", "\\u1e4d", "\\u1e4e", "\\u1e4f", "\\u1e50", "\\u1e51", "\\u1e52", "\\u1e53", "\\u1e54", "\\u1e55", "\\u1e56", "\\u1e57", "\\u1e58", "\\u1e59", "\\u1e5a", "\\u1e5b", "\\u1e5c", "\\u1e5d", "\\u1e5e", "\\u1e5f", "\\u1e60", "\\u1e61", "\\u1e62", "\\u1e64", "\\u1e65", "\\u1e66", "\\u1e67", "\\u1e68", "\\u1e69", "\\u1e6a", "\\u1e6b", "\\u1e6c", "\\u1e6e", "\\u1e6f", "\\u1e70", "\\u1e71", "\\u1e72", "\\u1e73", "\\u1e74", "\\u1e75", "\\u1e76", "\\u1e77", "\\u1e78", "\\u1e79", "\\u1e7a", "\\u1e7b", "\\u1e7c", "\\u1e7d", "\\u1e7e", "\\u1e7f", "\\u1e80", "\\u1e81", "\\u1e82", "\\u1e83", "\\u1e84", "\\u1e85", "\\u1e86", "\\u1e87", "\\u1e88", "\\u1e89", "\\u1e8a", "\\u1e8b", "\\u1e8c", "\\u1e8d", "\\u1e8e", "\\u1e8f", "\\u1e90", "\\u1e91", "\\u1e93", "\\u1e94", "\\u1e95", "\\u1e96", "\\u0331", "\\u1e97", "\\u1e98", "\\u030a", "\\u1e99", "\\u1e9a", "\\u02be", "\\u1e9b", "\\u1e9c", "\\u1e9d", "\\u1e9e", "\\u1e9f", "\\u1ea0", "\\u1ea2", "\\u1ea4", "\\u1ea6", "\\u1ea8", "\\u1eaa", "\\u1eae", "\\u1eb0", "\\u1eb2", "\\u1eb4", "\\u1eb5", "\\u1eb6", "\\u1eb8", "\\u1eb9", "\\u1eba", "\\u1ebc", "\\u1ebe", "\\u1ec0", "\\u1ec2", "\\u1ec4", "\\u1ec6", "\\u1ec8", "\\u1eca", "\\u1ece", "\\u1ed0", "\\u1ed2", "\\u1ed4", "\\u1ed6", "\\u1ed8", "\\u1eda", "\\u1edc", "\\u1ede", "\\u1ee0", "\\u1ee2", "\\u1ee4", "\\u1ee6", "\\u1ee8", "\\u1eea", "\\u1eec", "\\u1eee", "\\u1ef0", "\\u1ef2", "\\u1ef3", "\\u1ef4", "\\u1ef5", "\\u1ef6", "\\u1ef7", "\\u1ef8", "\\u1ef9", "\\u1efa", "\\u1efb", "\\u1efc", "\\u1efd", "\\u1efe", "\\u1eff", "\\u1f00", "\\u1f08", "\\u1f01", "\\u1f09", "\\u1f02", "\\u1f0a", "\\u1f03", "\\u1f0b", "\\u1f04", "\\u1f0c", "\\u1f05", "\\u1f0d", "\\u1f06", "\\u1f0e", "\\u1f07", "\\u1f0f", "\\u1f10", "\\u1f18", "\\u1f11", "\\u1f19", "\\u1f12", "\\u1f1a", "\\u1f13", "\\u1f1b", "\\u1f14", "\\u1f1c", "\\u1f15", "\\u1f1d", "\\u1f20", "\\u1f28", "\\u1f21", "\\u1f29", "\\u1f22", "\\u1f2a", "\\u1f23", "\\u1f2b", "\\u1f24", "\\u1f2c", "\\u1f25", "\\u1f2d", "\\u1f26", "\\u1f2e", "\\u1f27", "\\u1f2f", "\\u1f30", "\\u1f38", "\\u1f31", "\\u1f39", "\\u1f32", "\\u1f3a", "\\u1f33", "\\u1f3b", "\\u1f34", "\\u1f3c", "\\u1f35", "\\u1f3d", "\\u1f36", "\\u1f3e", "\\u1f37", "\\u1f3f", "\\u1f40", "\\u1f48", "\\u1f41", "\\u1f49", "\\u1f42", "\\u1f4a", "\\u1f43", "\\u1f4b", "\\u1f44", "\\u1f4c", "\\u1f45", "\\u1f4d", "\\u1f50", "\\u0313", "\\u1f51", "\\u1f59", "\\u1f52", "\\u1f53", "\\u1f5b", "\\u1f54", "\\u1f55", "\\u1f5d", "\\u1f56", "\\u0342", "\\u1f57", "\\u1f5f", "\\u1f60", "\\u1f68", "\\u1f61", "\\u1f69", "\\u1f62", "\\u1f6a", "\\u1f63", "\\u1f6b", "\\u1f64", "\\u1f6c", "\\u1f65", "\\u1f6d", "\\u1f66", "\\u1f6e", "\\u1f67", "\\u1f6f", "\\u1f70", "\\u1fba", "\\u1f71", "\\u1fbb", "\\u1f72", "\\u1fc8", "\\u1f73", "\\u1fc9", "\\u1f74", "\\u1fca", "\\u1f75", "\\u1fcb", "\\u1f76", "\\u1fda", "\\u1f77", "\\u1fdb", "\\u1f78", "\\u1ff8", "\\u1f79", "\\u1ff9", "\\u1f7a", "\\u1fea", "\\u1f7b", "\\u1feb", "\\u1f7c", "\\u1ffa", "\\u1f7d", "\\u1ffb", "\\u1f80", "\\u1f88", "\\u1f81", "\\u1f89", "\\u1f82", "\\u1f8a", "\\u1f83", "\\u1f8b", "\\u1f84", "\\u1f8c", "\\u1f85", "\\u1f8d", "\\u1f86", "\\u1f8e", "\\u1f87", "\\u1f8f", "\\u1f90", "\\u1f98", "\\u1f91", "\\u1f99", "\\u1f92", "\\u1f9a", "\\u1f93", "\\u1f9b", "\\u1f94", "\\u1f9c", "\\u1f95", "\\u1f9d", "\\u1f96", "\\u1f9e", "\\u1f97", "\\u1f9f", "\\u1fa0", "\\u1fa8", "\\u1fa1", "\\u1fa9", "\\u1fa2", "\\u1faa", "\\u1fa3", "\\u1fab", "\\u1fa4", "\\u1fac", "\\u1fa5", "\\u1fad", "\\u1fa6", "\\u1fae", "\\u1fa7", "\\u1faf", "\\u1fb0", "\\u1fb8", "\\u1fb1", "\\u1fb9", "\\u1fb2", "\\u1fb3", "\\u1fbc", "\\u1fb4", "\\u1fb6", "\\u1fb7", "\\u1fbe", "\\u1fc2", "\\u1fc3", "\\u1fcc", "\\u1fc4", "\\u1fc6", "\\u1fc7", "\\u1fd0", "\\u1fd8", "\\u1fd1", "\\u1fd9", "\\u1fd2", "\\u1fd3", "\\u1fd6", "\\u1fd7", "\\u1fe0", "\\u1fe8", "\\u1fe1", "\\u1fe9", "\\u1fe2", "\\u1fe3", "\\u1fe4", "\\u1fe5", "\\u1fec", "\\u1fe6", "\\u1fe7", "\\u1ff2", "\\u1ff3", "\\u1ffc", "\\u1ff4", "\\u1ff6", "\\u1ff7", "\\u2071", "\\u207f", "\\u2102", "\\u2107", "\\u210a", "\\u210b", "\\u210c", "\\u210d", "\\u210e", "\\u210f", "\\u2110", "\\u2111", "\\u2112", "\\u2113", "\\u2115", "\\u2119", "\\u211a", "\\u211b", "\\u211c", "\\u211d", "\\u2124", "\\u2126", "\\u2128", "\\u212a", "\\u212b", "\\u212c", "\\u212d", "\\u212f", "\\u2130", "\\u2131", "\\u2132", "\\u214e", "\\u2133", "\\u2134", "\\u2139", "\\u213c", "\\u213d", "\\u213e", "\\u213f", "\\u2145", "\\u2146", "\\u2147", "\\u2148", "\\u2149", "\\u2183", "\\u2184", "\\u2c00", "\\u2c30", "\\u2c01", "\\u2c31", "\\u2c02", "\\u2c32", "\\u2c03", "\\u2c33", "\\u2c04", "\\u2c34", "\\u2c05", "\\u2c35", "\\u2c06", "\\u2c36", "\\u2c07", "\\u2c37", "\\u2c08", "\\u2c38", "\\u2c09", "\\u2c39", "\\u2c0a", "\\u2c3a", "\\u2c0b", "\\u2c3b", "\\u2c0c", "\\u2c3c", "\\u2c0d", "\\u2c3d", "\\u2c0e", "\\u2c3e", "\\u2c0f", "\\u2c3f", "\\u2c10", "\\u2c40", "\\u2c11", "\\u2c41", "\\u2c12", "\\u2c42", "\\u2c13", "\\u2c43", "\\u2c14", "\\u2c44", "\\u2c15", "\\u2c45", "\\u2c16", "\\u2c46", "\\u2c17", "\\u2c47", "\\u2c18", "\\u2c48", "\\u2c19", "\\u2c49", "\\u2c1a", "\\u2c4a", "\\u2c1b", "\\u2c4b", "\\u2c1c", "\\u2c4c", "\\u2c1d", "\\u2c4d", "\\u2c1e", "\\u2c4e", "\\u2c1f", "\\u2c4f", "\\u2c20", "\\u2c50", "\\u2c21", "\\u2c51", "\\u2c22", "\\u2c52", "\\u2c23", "\\u2c53", "\\u2c24", "\\u2c54", "\\u2c25", "\\u2c55", "\\u2c26", "\\u2c56", "\\u2c27", "\\u2c57", "\\u2c28", "\\u2c58", "\\u2c29", "\\u2c59", "\\u2c2a", "\\u2c5a", "\\u2c2b", "\\u2c5b", "\\u2c2c", "\\u2c5c", "\\u2c2d", "\\u2c5d", "\\u2c2e", "\\u2c5e", "\\u2c60", "\\u2c61", "\\u2c67", "\\u2c68", "\\u2c69", "\\u2c6a", "\\u2c6b", "\\u2c6c", "\\u2c71", "\\u2c72", "\\u2c73", "\\u2c74", "\\u2c75", "\\u2c76", "\\u2c77", "\\u2c78", "\\u2c79", "\\u2c7a", "\\u2c7b", "\\u2c7c", "\\u2c80", "\\u2c81", "\\u2c82", "\\u2c83", "\\u2c84", "\\u2c85", "\\u2c86", "\\u2c87", "\\u2c88", "\\u2c89", "\\u2c8a", "\\u2c8b", "\\u2c8c", "\\u2c8d", "\\u2c8e", "\\u2c8f", "\\u2c90", "\\u2c91", "\\u2c92", "\\u2c93", "\\u2c94", "\\u2c95", "\\u2c96", "\\u2c97", "\\u2c98", "\\u2c99", "\\u2c9a", "\\u2c9b", "\\u2c9c", "\\u2c9d", "\\u2c9e", "\\u2c9f", "\\u2ca0", "\\u2ca1", "\\u2ca2", "\\u2ca3", "\\u2ca4", "\\u2ca5", "\\u2ca6", "\\u2ca7", "\\u2ca8", "\\u2ca9", "\\u2caa", "\\u2cab", "\\u2cac", "\\u2cad", "\\u2cae", "\\u2caf", "\\u2cb0", "\\u2cb1", "\\u2cb2", "\\u2cb3", "\\u2cb4", "\\u2cb5", "\\u2cb6", "\\u2cb7", "\\u2cb8", "\\u2cb9", "\\u2cba", "\\u2cbb", "\\u2cbc", "\\u2cbd", "\\u2cbe", "\\u2cbf", "\\u2cc0", "\\u2cc1", "\\u2cc2", "\\u2cc3", "\\u2cc4", "\\u2cc5", "\\u2cc6", "\\u2cc7", "\\u2cc8", "\\u2cc9", "\\u2cca", "\\u2ccb", "\\u2ccc", "\\u2ccd", "\\u2cce", "\\u2ccf", "\\u2cd0", "\\u2cd1", "\\u2cd2", "\\u2cd3", "\\u2cd4", "\\u2cd5", "\\u2cd6", "\\u2cd7", "\\u2cd8", "\\u2cd9", "\\u2cda", "\\u2cdb", "\\u2cdc", "\\u2cdd", "\\u2cde", "\\u2cdf", "\\u2ce0", "\\u2ce1", "\\u2ce2", "\\u2ce3", "\\u2ce4", "\\ua640", "\\ua641", "\\ua642", "\\ua643", "\\ua644", "\\ua645", "\\ua646", "\\ua647", "\\ua648", "\\ua649", "\\ua64a", "\\ua64b", "\\ua64c", "\\ua64d", "\\ua64e", "\\ua64f", "\\ua650", "\\ua651", "\\ua652", "\\ua653", "\\ua654", "\\ua655", "\\ua656", "\\ua657", "\\ua658", "\\ua659", "\\ua65a", "\\ua65b", "\\ua65c", "\\ua65d", "\\ua65e", "\\ua65f", "\\ua662", "\\ua663", "\\ua664", "\\ua665", "\\ua666", "\\ua667", "\\ua668", "\\ua669", "\\ua66a", "\\ua66b", "\\ua66c", "\\ua66d", "\\ua680", "\\ua681", "\\ua682", "\\ua683", "\\ua684", "\\ua685", "\\ua686", "\\ua687", "\\ua688", "\\ua689", "\\ua68a", "\\ua68b", "\\ua68c", "\\ua68d", "\\ua68e", "\\ua68f", "\\ua690", "\\ua691", "\\ua692", "\\ua693", "\\ua694", "\\ua695", "\\ua696", "\\ua697", "\\ua722", "\\ua723", "\\ua724", "\\ua725", "\\ua726", "\\ua727", "\\ua728", "\\ua729", "\\ua72a", "\\ua72b", "\\ua72c", "\\ua72d", "\\ua72e", "\\ua72f", "\\ua730", "\\ua731", "\\ua732", "\\ua733", "\\ua734", "\\ua735", "\\ua736", "\\ua737", "\\ua738", "\\ua739", "\\ua73a", "\\ua73b", "\\ua73c", "\\ua73d", "\\ua73e", "\\ua73f", "\\ua740", "\\ua741", "\\ua742", "\\ua743", "\\ua744", "\\ua745", "\\ua746", "\\ua747", "\\ua748", "\\ua749", "\\ua74a", "\\ua74b", "\\ua74c", "\\ua74d", "\\ua74e", "\\ua74f", "\\ua750", "\\ua751", "\\ua752", "\\ua753", "\\ua754", "\\ua755", "\\ua756", "\\ua757", "\\ua758", "\\ua759", "\\ua75a", "\\ua75b", "\\ua75c", "\\ua75d", "\\ua75e", "\\ua75f", "\\ua760", "\\ua761", "\\ua762", "\\ua763", "\\ua764", "\\ua765", "\\ua766", "\\ua767", "\\ua768", "\\ua769", "\\ua76a", "\\ua76b", "\\ua76c", "\\ua76d", "\\ua76e", "\\ua76f", "\\ua771", "\\ua772", "\\ua773", "\\ua774", "\\ua775", "\\ua776", "\\ua777", "\\ua778", "\\ua779", "\\ua77a", "\\ua77b", "\\ua77c", "\\ua77e", "\\ua77f", "\\ua780", "\\ua781", "\\ua782", "\\ua783", "\\ua784", "\\ua785", "\\ua786", "\\ua787", "\\ua78b", "\\ua78c", "\\ufb00", "\\ufb01", "\\ufb02", "\\ufb03", "\\ufb05", "\\ufb06", "\\ufb13", "\\ufb14", "\\ufb15", "\\ufb16", "\\ufb17", "\\uff21", "\\uff41", "\\uff22", "\\uff42", "\\uff23", "\\uff43", "\\uff24", "\\uff44", "\\uff25", "\\uff45", "\\uff26", "\\uff46", "\\uff27", "\\uff47", "\\uff28", "\\uff48", "\\uff29", "\\uff49", "\\uff2a", "\\uff4a", "\\uff2b", "\\uff4b", "\\uff2c", "\\uff4c", "\\uff2d", "\\uff4d", "\\uff2e", "\\uff4e", "\\uff2f", "\\uff4f", "\\uff30", "\\uff50", "\\uff31", "\\uff51", "\\uff32", "\\uff52", "\\uff33", "\\uff53", "\\uff34", "\\uff54", "\\uff35", "\\uff55", "\\uff36", "\\uff56", "\\uff37", "\\uff57", "\\uff38", "\\uff58", "\\uff39", "\\uff59", "\\uff3a", "\\uff5a", "\\ud801\\udc00", "\\ud801\\udc28", "\\ud801\\udc01", "\\ud801\\udc29", "\\ud801\\udc02", "\\ud801\\udc2a", "\\ud801\\udc03", "\\ud801\\udc2b", "\\ud801\\udc04", "\\ud801\\udc2c", "\\ud801\\udc05", "\\ud801\\udc2d", "\\ud801\\udc06", "\\ud801\\udc2e", "\\ud801\\udc07", "\\ud801\\udc2f", "\\ud801\\udc08", "\\ud801\\udc30", "\\ud801\\udc09", "\\ud801\\udc31", "\\ud801\\udc0a", "\\ud801\\udc32", "\\ud801\\udc0b", "\\ud801\\udc33", "\\ud801\\udc0c", "\\ud801\\udc34", "\\ud801\\udc0d", "\\ud801\\udc35", "\\ud801\\udc0e", "\\ud801\\udc36", "\\ud801\\udc0f", "\\ud801\\udc37", "\\ud801\\udc10", "\\ud801\\udc38", "\\ud801\\udc11", "\\ud801\\udc39", "\\ud801\\udc12", "\\ud801\\udc3a", "\\ud801\\udc13", "\\ud801\\udc3b", "\\ud801\\udc14", "\\ud801\\udc3c", "\\ud801\\udc15", "\\ud801\\udc3d", "\\ud801\\udc16", "\\ud801\\udc3e", "\\ud801\\udc17", "\\ud801\\udc3f", "\\ud801\\udc18", "\\ud801\\udc40", "\\ud801\\udc19", "\\ud801\\udc41", "\\ud801\\udc1a", "\\ud801\\udc42", "\\ud801\\udc1b", "\\ud801\\udc43", "\\ud801\\udc1c", "\\ud801\\udc44", "\\ud801\\udc1d", "\\ud801\\udc45", "\\ud801\\udc1e", "\\ud801\\udc46", "\\ud801\\udc1f", "\\ud801\\udc47", "\\ud801\\udc20", "\\ud801\\udc48", "\\ud801\\udc21", "\\ud801\\udc49", "\\ud801\\udc22", "\\ud801\\udc4a", "\\ud801\\udc23", "\\ud801\\udc4b", "\\ud801\\udc24", "\\ud801\\udc4c", "\\ud801\\udc25", "\\ud801\\udc4d", "\\ud801\\udc26", "\\ud801\\udc4e", "\\ud801\\udc27", "\\ud801\\udc4f", "\\ud835\\udc00", "\\ud835\\udc01", "\\ud835\\udc02", "\\ud835\\udc03", "\\ud835\\udc04", "\\ud835\\udc05", "\\ud835\\udc06", "\\ud835\\udc07", "\\ud835\\udc08", "\\ud835\\udc09", "\\ud835\\udc0a", "\\ud835\\udc0b", "\\ud835\\udc0c", "\\ud835\\udc0d", "\\ud835\\udc0e", "\\ud835\\udc0f", "\\ud835\\udc10", "\\ud835\\udc11", "\\ud835\\udc12", "\\ud835\\udc13", "\\ud835\\udc14", "\\ud835\\udc15", "\\ud835\\udc16", "\\ud835\\udc17", "\\ud835\\udc18", "\\ud835\\udc19", "\\ud835\\udc1a", "\\ud835\\udc1b", "\\ud835\\udc1c", "\\ud835\\udc1d", "\\ud835\\udc1e", "\\ud835\\udc1f", "\\ud835\\udc20", "\\ud835\\udc21", "\\ud835\\udc22", "\\ud835\\udc23", "\\ud835\\udc24", "\\ud835\\udc25", "\\ud835\\udc26", "\\ud835\\udc27", "\\ud835\\udc28", "\\ud835\\udc29", "\\ud835\\udc2a", "\\ud835\\udc2b", "\\ud835\\udc2c", "\\ud835\\udc2d", "\\ud835\\udc2e", "\\ud835\\udc2f", "\\ud835\\udc30", "\\ud835\\udc31", "\\ud835\\udc32", "\\ud835\\udc33", "\\ud835\\udc34", "\\ud835\\udc35", "\\ud835\\udc36", "\\ud835\\udc37", "\\ud835\\udc38", "\\ud835\\udc39", "\\ud835\\udc3a", "\\ud835\\udc3b", "\\ud835\\udc3c", "\\ud835\\udc3d", "\\ud835\\udc3e", "\\ud835\\udc3f", "\\ud835\\udc40", "\\ud835\\udc41", "\\ud835\\udc42", "\\ud835\\udc43", "\\ud835\\udc44", "\\ud835\\udc45", "\\ud835\\udc46", "\\ud835\\udc47", "\\ud835\\udc48", "\\ud835\\udc49", "\\ud835\\udc4a", "\\ud835\\udc4b", "\\ud835\\udc4c", "\\ud835\\udc4d", "\\ud835\\udc4e", "\\ud835\\udc4f", "\\ud835\\udc50", "\\ud835\\udc51", "\\ud835\\udc52", "\\ud835\\udc53", "\\ud835\\udc54", "\\ud835\\udc56", "\\ud835\\udc57", "\\ud835\\udc58", "\\ud835\\udc59", "\\ud835\\udc5a", "\\ud835\\udc5b", "\\ud835\\udc5c", "\\ud835\\udc5d", "\\ud835\\udc5e", "\\ud835\\udc5f", "\\ud835\\udc60", "\\ud835\\udc61", "\\ud835\\udc62", "\\ud835\\udc63", "\\ud835\\udc64", "\\ud835\\udc65", "\\ud835\\udc66", "\\ud835\\udc67", "\\ud835\\udc68", "\\ud835\\udc69", "\\ud835\\udc6a", "\\ud835\\udc6b", "\\ud835\\udc6c", "\\ud835\\udc6d", "\\ud835\\udc6e", "\\ud835\\udc6f", "\\ud835\\udc70", "\\ud835\\udc71", "\\ud835\\udc72", "\\ud835\\udc73", "\\ud835\\udc74", "\\ud835\\udc75", "\\ud835\\udc76", "\\ud835\\udc77", "\\ud835\\udc78", "\\ud835\\udc79", "\\ud835\\udc7a", "\\ud835\\udc7b", "\\ud835\\udc7c", "\\ud835\\udc7d", "\\ud835\\udc7e", "\\ud835\\udc7f", "\\ud835\\udc80", "\\ud835\\udc81", "\\ud835\\udc82", "\\ud835\\udc83", "\\ud835\\udc84", "\\ud835\\udc85", "\\ud835\\udc86", "\\ud835\\udc87", "\\ud835\\udc88", "\\ud835\\udc89", "\\ud835\\udc8a", "\\ud835\\udc8b", "\\ud835\\udc8c", "\\ud835\\udc8d", "\\ud835\\udc8e", "\\ud835\\udc8f", "\\ud835\\udc90", "\\ud835\\udc91", "\\ud835\\udc92", "\\ud835\\udc93", "\\ud835\\udc94", "\\ud835\\udc95", "\\ud835\\udc96", "\\ud835\\udc97", "\\ud835\\udc98", "\\ud835\\udc99", "\\ud835\\udc9a", "\\ud835\\udc9b", "\\ud835\\udc9c", "\\ud835\\udc9e", "\\ud835\\udc9f", "\\ud835\\udca2", "\\ud835\\udca5", "\\ud835\\udca6", "\\ud835\\udca9", "\\ud835\\udcaa", "\\ud835\\udcab", "\\ud835\\udcac", "\\ud835\\udcae", "\\ud835\\udcaf", "\\ud835\\udcb0", "\\ud835\\udcb1", "\\ud835\\udcb2", "\\ud835\\udcb3", "\\ud835\\udcb4", "\