
certificate.spreadsheet = {
	dbField: '',
	dbSearch: '',
	limit: 50,
	offset: 0,
	totalrecords: 0,
	first: true,
	manage: {},
	default: {},
	columns: {
		"week":true,
		"created":true,
		"order":true,
		"first":true,
		"last":true,
		"email":true,
		"ecard":true,
		"value":true,
		"transfer":true,
		"tip":true,
		"emailed":true,
		"gift":true,
		"cardtype":true,
		"modified":true,
		"used":true
	},
	guid: '',
	view: function() {
		var keys = Object.keys(certificate.spreadsheet.columns);
		for (var i = 0; i < keys.length; i++) {
			if (certificate.spreadsheet.columns[keys[i]]) {
				$('.'+keys[i]).css('display','table-cell');
			} else {
				$('.'+keys[i]).css('display','none');
			}
		}
		certificate.spreadsheet.save();
		// certificate.spreadsheet.view();
	}, //==============================================
	save: function() {
		if (!certificate.spreadsheet.first) {
			$.cookie('columns', JSON.stringify(certificate.spreadsheet.columns), { path: '/projects/certificates', expires: 8000 });
			$.cookie('columns', JSON.stringify(certificate.spreadsheet.columns), {  expires: 8000 });
		}
		// certificate.spreadsheet.save();
	}, //==============================================
	showAll: function() {
		var keys = Object.keys(certificate.spreadsheet.columns);
		for (var i = 0; i < keys.length; i++) {
			certificate.spreadsheet.columns[keys[i]] = true;
		}

		var keys = Object.keys(certificate.spreadsheet.columns);
		for (var i = 0; i < keys.length; i++) {
			if (certificate.spreadsheet.columns[keys[i]]) {
				$('#'+keys[i]).prop('checked', true);
			} else {
				$('#'+keys[i]).prop('checked', false);
			}
		}

		certificate.spreadsheet.view();
		// certificate.spreadsheet.showAll();
	}, //==============================================
	update: function() {

		if (typeof $.cookie('columns') !== 'undefined'){
			certificate.spreadsheet.default = certificate.spreadsheet.columns;
			var c = $.cookie('columns');
			var keys = Object.keys(c);
			if (keys.length > 3) {
			}
				certificate.spreadsheet.columns = JSON.parse(c);
			var keys = Object.keys(certificate.spreadsheet.columns);
			for (var i = 0; i < keys.length; i++) {
				if (certificate.spreadsheet.columns[keys[i]]) {
					$('#'+keys[i]).prop('checked', true);
				} else {
					$('#'+keys[i]).prop('checked', false);
				}
			}
		}
		certificate.spreadsheet.view();
		certificate.spreadsheet.first = false;
		// JSON.parse($.cookie("columns"))
		// certificate.spreadsheet.update();
	}, //==============================================
	getWeekNumber: function(d) {
		d = new Date(Date.UTC(d.getFullYear(), d.getMonth(), d.getDate()));
		d.setUTCDate(d.getUTCDate() + 4 - (d.getUTCDay()||7));
		var yearStart = new Date(Date.UTC(d.getUTCFullYear(),0,1));
		var weekNo = Math.ceil(( ( (d - yearStart) / 86400000) + 1)/7);
		return [d.getUTCFullYear(), weekNo];
		// certificate.spreadsheet.thisweek();
	}, //==============================================
	thisweek: function() {
		var result = certificate.spreadsheet.getWeekNumber(new Date());
		certificate.v.week = result[1];
		certificate.v.year = result[0];
		return result;
	}, //==============================================
	woyPrint: function(datetime) {
		var data = certificate.spreadsheet.woy(datetime);
		return data[0].toString() + certificate.spreadsheet.cleanwoy(data[1]);
	}, //==============================================
	cleanwoy: function(data) {
		var w = data.toString();
		if (w.length === 1) {
			var result = '0'+w;
		} else {
			var result = w;
		}
		return result;
		// certificate.spreadsheet.cleanwoy();
	}, //==============================================
	woy: function(datetime) {
		var one = datetime.split(' ');
		var dt = one[0].split('-');
		var year = Number(dt[0]);
		var month = Number(dt[1]);
		var day = Number(dt[2]);
		// console.log(year, month, day)
		d = new Date(year, month-1, day);
		d.setUTCDate(d.getUTCDate() + 4 - (d.getUTCDay()||7));
		var yearStart = new Date(Date.UTC(d.getUTCFullYear(),0,1));
		var weekNo = Math.ceil(( ( (d - yearStart) / 86400000) + 1)/7);
		return [d.getUTCFullYear(), weekNo];
		// return [year, month, day];
	}, //==============================================
	woy_old: function(datetime) {
		// '2019-01-06 20:03:05'
		var one = datetime.split(' ');
		var dt = one[0].split('-');
		var year = Number(dt[0]);
		var month = Number(dt[1]);
		var day = Number(dt[2]);
		var d = new Date(Date.UTC(year, month, day));
		var dayNum = d.getUTCDay() || 7;
		d.setUTCDate(d.getUTCDate() + 4 - dayNum);
		var yearStart = new Date(Date.UTC(d.getUTCFullYear(),0,1));
		return year+certificate.spreadsheet.cleanwoy(Math.ceil((((d - yearStart) / 86400000) + 1)/7));
		// certificate.spreadsheet.woy(datetime);
	}, //==============================================
	showallrecords: function() {
		if($('#saverecords').is(":checked")) {
			var data = {records: 0};
			$.cookie('spreadsheet_records', JSON.stringify(data), { path: '/projects/certificates', expires: 8000 });
			$.cookie('spreadsheet_records', JSON.stringify(data), {  expires: 8000 });
		} else {
			$.removeCookie('spreadsheet_records', { path: '/' });
			$.removeCookie('spreadsheet_records', { path: '/projects/certificates' });
			$.removeCookie('spreadsheet_records');
		}
		
		if (location['search'].includes('field')) {
			var newURL = location['origin'] + '' + location['pathname'] + '?records=0' + '&field=' + certificate.spreadsheet.dbField + '&search=' + certificate.spreadsheet.dbSearch;
		} else {
			var newURL = location['origin'] + '' + location['pathname'] + '?records=0';
		}
		console.log(newURL);
		location.replace(newURL);
		// certificate.spreadsheet.showallrecords()
	}, //==============================================
	records: function(records) {
		if (isNaN(records)) {
			records = 0;
		}
		if($('#saverecords').is(":checked")) {
			var data = {records: records};
			$.cookie('spreadsheet_records', JSON.stringify(data), { path: '/projects/certificates', expires: 8000 });
			$.cookie('spreadsheet_records', JSON.stringify(data), {  expires: 8000 });
		} else {
			$.removeCookie('spreadsheet_records', { path: '/' });
			$.removeCookie('spreadsheet_records', { path: '/projects/certificates' });
			$.removeCookie('spreadsheet_records');
		}
		if (location['search'].includes('field')) {
			var newURL = location['origin'] + '' + location['pathname'] + '?records=' + records + '&field=' + certificate.spreadsheet.dbField + '&search=' + certificate.spreadsheet.dbSearch;
		} else {
			var newURL = location['origin'] + '' + location['pathname'] + '?records=' + records;
		}
		location.replace(newURL);
		// certificate.spreadsheet.records(records)
	}, //==============================================
	restoreRecords: function() {

		// if (typeof $.cookie('spreadsheet_records') !== 'undefined'){
		//     var data = JSON.parse($.cookie('spreadsheet_records'));
		//     certificate.spreadsheet.limit = data['records'];
		//     // $('#recordsvalue').val(data['records']);
		// }
		if (certificate.spreadsheet.limit > 0) {
			$('#recordsvalue').val(certificate.spreadsheet.limit);
			// $('#recordstext').text('Showing ' + certificate.spreadsheet.limit.toString() + ' records at a time');
			$('#recordstext').text('' + certificate.spreadsheet.limit.toString() + ' Per Page');
		} else {
			$('#recordsvalue').val('ALL');
			$('#recordstext').text('Showing all records');
		}

		
		// certificate.spreadsheet.restoreRecords()
	}, //==============================================
	recordButtons: function() {
		if (certificate.spreadsheet.limit > 0) {
			var offPlus = certificate.spreadsheet.offset + Number(certificate.spreadsheet.loadedCount());
			var end = false;
			if (offPlus > certificate.spreadsheet.totalrecords) {
				offPlus = certificate.spreadsheet.totalrecords;
				var end = true;
			}
			if (offPlus === certificate.spreadsheet.totalrecords) { var end = true; }


			if (!end) {
				$('#recordNavNext').css('display','inline-block');
				$('#recordNavLabel').css('display','block');
			} else {
				$('#recordNavNext').css('display','none');
			}
			if (certificate.spreadsheet.offset > 0) {
				$('#recordNavBack').css('display','inline-block');
				$('#recordNavLabel').css('display','block');
			} else {
				$('#recordNavBack').css('display','none');
			}

			$('#recordNavLabel').text('(' + certificate.spreadsheet.offset.toString() + ' - ' + offPlus + ') of ' + certificate.spreadsheet.totalrecords.toString());
		} else {
			$('#recordNavLabel').css('display','block');
			$('#recordNavLabel').text('Found: ' + certificate.spreadsheet.totalrecords.toString());
		}
		console.log(certificate.spreadsheet.offset);

		// certificate.spreadsheet.limit
		// certificate.spreadsheet.offset
		// certificate.spreadsheet.totalrecords
		// certificate.spreadsheet.recordButtons()
	}, //==============================================
	recordsBack: function() {
		var newOffset = certificate.spreadsheet.offset - certificate.spreadsheet.limit;
		if (newOffset > -1) {
			certificate.spreadsheet.offset = newOffset;
			if (location['search'].includes('field')) {
				var newURL = location['origin'] + '' + location['pathname'] + '?records=' + certificate.spreadsheet.limit.toString() + '&offset=' + certificate.spreadsheet.offset.toString() + '&field=' + certificate.spreadsheet.dbField + '&search=' + certificate.spreadsheet.dbSearch;
			} else {
				var newURL = location['origin'] + '' + location['pathname'] + '?records=' + certificate.spreadsheet.limit.toString() + '&offset=' + certificate.spreadsheet.offset.toString();
			}
			console.log(newURL);
			location.replace(newURL);
		}
		// certificate.spreadsheet.recordButtons();
		// certificate.spreadsheet.recordsBack()
	}, //==============================================
	recordsNext: function() {
		certificate.spreadsheet.offset = certificate.spreadsheet.offset + certificate.spreadsheet.limit;
		if (location['search'].includes('field')) {
			var newURL = location['origin'] + '' + location['pathname'] + '?records=' + certificate.spreadsheet.limit.toString() + '&offset=' + certificate.spreadsheet.offset.toString() + '&field=' + certificate.spreadsheet.dbField + '&search=' + certificate.spreadsheet.dbSearch;
		} else {
			var newURL = location['origin'] + '' + location['pathname'] + '?records=' + certificate.spreadsheet.limit.toString() + '&offset=' + certificate.spreadsheet.offset.toString();
		}
		console.log(newURL);
		location.replace(newURL);
		// certificate.spreadsheet.recordButtons();
		// certificate.spreadsheet.recordsNext()
	}, //==============================================
	databaseSearch: function(field,search) {
		// certificate.order.activeSearch = 'database';
		certificate.order.showall();
		certificate.spreadsheet.dbField = field;
		certificate.spreadsheet.dbSearch = search;
		var newURL = location['origin'] + '' + location['pathname'] + '?records=' + certificate.spreadsheet.limit.toString() + '&offset=0' + '&field=' + certificate.spreadsheet.dbField + '&search=' + certificate.spreadsheet.dbSearch;
		console.log(newURL);
		location.replace(newURL);

		// certificate.spreadsheet.databaseSearch()
	}, //==============================================
	loadedCount: function() {
		certificate.v.rowCount = 0;
		$('tr').each(function( index ) { certificate.v.rowCount++; });
		certificate.v.rowCount--;
		return certificate.v.rowCount.toString();
		// certificate.spreadsheet.loadedCount()
	}, //==============================================
	recordsNext00: function() {
	} //==============================================
};
$(document).ready(function() {

	$('#columncheckboxes [type=checkbox]').change(function() {
		var n = $(this).attr('name');
		if($(this).is(":checked")) {
			certificate.spreadsheet.columns[n] = true;
			console.log(n+': yes');
		} else {
			certificate.spreadsheet.columns[n] = false;
			console.log(n+': no');
		}
		certificate.spreadsheet.view();
	});
});

// setTimeout(function(){ certificate.spreadsheet.update();certificate.order.restoreSearch(); }, 800);



function minimize() {
	certificate.spreadsheet.showAll();
	$('tr').each(function(index){

		if ( !index ) {
			$(this).find('.created').after( '<th class="time" style="display: table-cell;"></th>' );
		} else {
			$(this).find('.created').after( '<td class="time" style="display: table-cell;"></td>' );
		}

		
		var created = $(this).find('.created').text();
		var x = created.split(' ');
		var date = x[0];
		var time = x[1];
		date = date.replace( '2019-', '' );
		date = date.replace( '2020-', '' );
		$(this).find('.created').text( date );
		$(this).find('.time').text( time );
		if ( !index ) { $(this).find('.time').text( 'time' ); }
		if ( !index ) { console.log( $(this).find('.created').prop("tagName") ); }
		if ( index === 1 ) { console.log( $(this).find('.created').prop("tagName") ); }

		var transfer = $(this).find('.transfer').html();
		transfer = transfer.replace( 'Yes', '' );
		$(this).find('.transfer').html(transfer);


		if (   $(this).find('.used').text() === 'YES'   ) {
			$(this).css( 'background-color', 'antiquewhite' );
		}

		if ( !index ) {
			var cardtype = $(this).find('.cardtype').text();
			cardtype = cardtype.replace( 'card', '' );
			$(this).find('.cardtype').text(cardtype);
		}

	});



	// $('head').append('\
	//                     <style>\
	//                         #datatable {\
	//                           font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;\
	//                           border-collapse: collapse;\
	//                         }\
	//                         #datatable td, #datatable th {\
	//                           border: 1px solid #ddd;\
	//                           padding: 8px;\
	//                         }\
	//                         #datatable tr:nth-child(even){background-color: #f2f2f2;}\
	//                         #datatable tr:hover {background-color: #ddd;}\
	//                         #datatable th {\
	//                           padding-top: 12px;\
	//                           padding-bottom: 12px;\
	//                           text-align: left;\
	//                           background-color: #4CAF50;\
	//                           color: white;\
	//                         }\
	//                     </style>\
	//     ');




	$("#columncheckboxes [for='created']").after('<br><input type="checkbox" id="time" name="time" checked=""> <label for="time">time</label>');
	$('.time').css('display','none');



	$('#time').prop("checked", false);
	$('#value').prop("checked", false);
	$('#emailed').prop("checked", false);
	$('#gift').prop("checked", false);
	$('#modified').prop("checked", false);
	$('#used').prop("checked", false);
	$('#tip').prop("checked", false);

	certificate.spreadsheet.columns['tip'] = false;
	certificate.spreadsheet.columns['time'] = false;
	certificate.spreadsheet.columns['value'] = false;
	certificate.spreadsheet.columns['emailed'] = false;
	certificate.spreadsheet.columns['gift'] = false;
	certificate.spreadsheet.columns['modified'] = false;
	certificate.spreadsheet.columns['email'] = false;
	// certificate.spreadsheet.columns['used'] = false;


	certificate.spreadsheet.view();


	$('#columncheckboxes [type=checkbox]').change(function() {
		var n = $(this).attr('name');
		if($(this).is(":checked")) {
			certificate.spreadsheet.columns[n] = true;
			console.log(n+': yes');
		} else {
			certificate.spreadsheet.columns[n] = false;
			console.log(n+': no');
		}
		certificate.spreadsheet.view();
	});
	$('th.ecard').text('card');
	$('th.order').text('order');
	$('#minimize').remove();

	
	
	
	
	
	

	$('th').css( 'text-align', 'center' );
	$('.created').css( 'text-align', 'center' );
	$('.order').css( 'text-align', 'center' );
	$('.ecard').css( 'text-align', 'center' );
	$('.cardtype').css( 'text-align', 'center' );
	$('.resend').css( 'text-align', 'center' );
	$('.transfer').css( 'text-align', 'center' );













}

$(document).ready(function() {

	console.log( 'cookie:', $.cookie('spreadsheet_records') );
	certificate.spreadsheet.manage.buildData();
	setTimeout(function(){
		if (typeof $.cookie('spreadsheet_records') === 'undefined'){
			certificate.spreadsheet.records( '50' );
			// $.cookie('spreadsheet_records', JSON.stringify( {"records":"50"} ), { path: '/projects/certificates', expires: 8000 });
		}
		$('body').append('<div id="minimize"  onclick="minimize();"  title="Click to minimize"  style="position: fixed; bottom: 10px; left: 10px;background-color: lightblue; padding: 5px;" >minimize</div>');
	}, 500);
	setTimeout(function(){
		$('#minimize').remove(); 
	}, 10000);
});



certificate.spreadsheet.manage = {
		initialized: 0,
		records: {
					'original': [],
					'live': [],
					'send': [],
		},
		
		update: function() {
			certificate.spreadsheet.manage.records.send = [];
			$('body').prepend('<div id="loading" ><img src="images/gears.gif"  style="z-index:99999999;"></div>');

			for (var i = 0; i < certificate.spreadsheet.manage.records.live.length; i++) {
				var record = certificate.spreadsheet.manage.records.live[i];
				
				if ( certificate.spreadsheet.manage.check( record ) ) {
					certificate.spreadsheet.manage.records.send.push( record );
				}
			}

			console.log( certificate.spreadsheet.manage.records.send );

			$.post(
					'updateSpreadsheet.php', {
									'JSON': JSON.stringify( certificate.spreadsheet.manage.records.send )
					},
					function(data) {
						console.log( 'START' );
						console.log( data );
						console.log( 'END' );

							if ( location.href.indexOf( '?recently_deleted' ) > -1 ) {
								var newURL = location.href.split('?');
								location.href = newURL[0];
							} else {
								location.reload();
							}

					}
			);
			// certificate.spreadsheet.manage.update()
		}, //==============================================
		check: function( nRecord ) {
			for (var i = 0; i < certificate.spreadsheet.manage.records.original.length; i++) {
				var oRecord = certificate.spreadsheet.manage.records.original[i];

				if ( oRecord.guid === nRecord.guid ) {
					if ( oRecord.used !== nRecord.used ) {
						return 1;
					}

					if ( oRecord.del !== nRecord.del ) {
						return 1;
					}

				}
			}
			return 0;
			// certificate.spreadsheet.manage.check( record )
		}, //==============================================
		getLive: function( guid ) {

			for (var i = 0; i < certificate.spreadsheet.manage.records.live.length; i++) {
				var record = certificate.spreadsheet.manage.records.live[i];
				if ( record.guid === guid ) {
					return i;
				}
			}

		}, //==============================================
		toggleDelete: function(dex) {

			var thisID = '#rec_del_' + dex;
			var record = certificate.spreadsheet.manage.records.live[ dex ];


			if ( record.del ) {
				record.del = 0;
			} else {
				record.del = 1;
			}


			if ( record.del ) {
				$(thisID).attr( 'src', 'images/toggle_off.png' );
			} else {
				$(thisID).attr( 'src', 'images/toggle_on.png' );
			}




		}, //==============================================
		toggleUsed: function(dex) {

			var thisID = '#rec_tog_' + dex;
			var record = certificate.spreadsheet.manage.records.live[ dex ];


			if ( record.used ) {
				record.used = 0;
			} else {
				record.used = 1;
			}


			if ( record.used ) {
				$(thisID).attr( 'src', 'images/toggle_off.png' );
			} else {
				$(thisID).attr( 'src', 'images/toggle_on.png' );
			}



		}, //==============================================
		buildCode: function() {
			$('tr').each(function( index ) {
				if ( index ) {
					var guid = $(this).attr( 'record' );
					var i = certificate.spreadsheet.manage.getLive( guid );
					var record = certificate.spreadsheet.manage.records.live[i];

					if ( record.del ) {
						$(this).find('.rec_del').html( '<img id="rec_del_'+record.dex+'" class="rec_del_img" onclick="certificate.spreadsheet.manage.toggleDelete('+record.dex+');" src="images/toggle_off.png" style="height:23px;width: 50px;">' );
					} else {
						$(this).find('.rec_del').html( '<img id="rec_del_'+record.dex+'" class="rec_del_img" onclick="certificate.spreadsheet.manage.toggleDelete('+record.dex+');" src="images/toggle_on.png" style="height:23px;width: 50px;">' );
					}

					if ( record.used ) {
						$(this).find('.rec_tog').html( '<img id="rec_tog_'+record.dex+'" class="rec_tog_img" onclick="certificate.spreadsheet.manage.toggleUsed('+record.dex+');" src="images/toggle_off.png" style="height:23px;width: 50px;">' );
					} else {
						$(this).find('.rec_tog').html( '<img id="rec_tog_'+record.dex+'" class="rec_tog_img" onclick="certificate.spreadsheet.manage.toggleUsed('+record.dex+');" src="images/toggle_on.png" style="height:23px;width: 50px;">' );
					}

				}
			});



			if ( location.href.indexOf( '?recently_deleted' ) > -1 ) {
				$('.rec_tog_img').remove();
				$('.resend').remove();
			}


			// certificate.spreadsheet.manage.buildCode();
		}, //==============================================
		buildData: function() {
			if ( location.href.indexOf( '?recently_deleted' ) > -1 ) {


				if ( !$('#datatable').length ) {

					setTimeout(function(){

						var newURL = location.href.split('?');

						alert( '\n\n   *** READ THIS ***\n\nNo recently deleted records available. \n\nPlease contact support to recover a record. \nScott 813-690-1260\n\n' )
						alert( ' Loading Speadsheet ' )

						location.href = newURL[0];

					}, 2000);
				}

				certificate.v.default_del = 1;
			} else {
				certificate.v.default_del = 0;
			}


			$('tr').each(function( index ) {

				if ( $(this).find('.used').text().toLowerCase().indexOf( 'n' ) > -1 ) {
					var used = 0;
				} else {
					var used = 1;
				}
				if ( index ) {
					var i = certificate.spreadsheet.manage.records.original.length;					
					certificate.spreadsheet.manage.records.original.push({ 'guid': $(this).attr( 'record' ), 'used': used, 'dex': i,    'del': certificate.v.default_del, 'undel': certificate.v.default_del });
						certificate.spreadsheet.manage.records.live.push({ 'guid': $(this).attr( 'record' ), 'used': used, 'dex': i,    'del': certificate.v.default_del, 'undel': certificate.v.default_del });
				}
			});



			// certificate.spreadsheet.manage.buildData();
		} //==============================================
};


// Add     Reload     Columns     Search     Record Count     Recently Deleted     Email Copies     Opened Email     Clean Cache


// columns_     search_     record_count_     

certificate.menu = {
        record: 0,
        guid: '',
        button: function( action ) {

        	if ( action === 'Add' ) {
        		var parts = location.href.split( '/' );
        		parts[ parts.length-1 ] = 'index.php?';
        		location.href = parts.join( '/' );
        	} else if ( action === 'Reload' ) {
        		location.replace(location['origin'] + '' + location['pathname']);
        	} else if ( action === 'Columns' ) {
				$('#columns_something').css( 'display', 'block' );
				$('#search_something').css( 'display', 'none' );
				$('#record_count_something').css( 'display', 'none' );
        	} else if ( action === 'Search' ) {
				$('#columns_something').css( 'display', 'none' );
				$('#search_something').css( 'display', 'block' );
				$('#record_count_something').css( 'display', 'none' );
        	} else if ( action === 'Record Count' ) {
				$('#columns_something').css( 'display', 'none' );
				$('#search_something').css( 'display', 'none' );
				$('#record_count_something').css( 'display', 'block' );
        	} else if ( action === 'Recently Deleted' ) {
        		var parts = location.href.split( '/' );
        		parts[ parts.length-1 ] = 'spreadsheet.php?recently_deleted';
        		window.open(  parts.join( '/' )  ,  '_blank'  );
        	} else if ( action === 'Email Copies' ) {
        		var parts = location.href.split( '/' );
        		parts[ parts.length-1 ] = 'emails/index.php?repository=A521DCAC-AC19-4E10-AEC0-D1CA3566729D';
        		window.open(  parts.join( '/' )  ,  '_blank'  );
        	} else if ( action === 'Opened Email' ) {
        		var parts = location.href.split( '/' );
        		parts[ parts.length-1 ] = 'tracker/index.php?repository=A521DCAC-AC19-4E10-AEC0-D1CA3566729D';
        		window.open(  parts.join( '/' )  ,  '_blank'  );
        	} else if ( action === 'Clean Cache' ) {
        		var parts = location.href.split( '/' );
        		parts[ parts.length-1 ] = 'clearCache.php?';
        		location.href = parts.join( '/' );
        	}

            // certificate.menu.button();
        }, //==============================================
        openNav: function() {
			document.getElementById("mySidebar").style.width = "250px";
			document.getElementById("main").style.marginLeft = "250px";
			$('#mainmenu').css( 'display', 'none' );
            // certificate.menu.openNav();
        }, //==============================================
        closeNav: function() {
			$('#mainmenu').css( 'display', 'block' );
			document.getElementById("mySidebar").style.width = "0";
			document.getElementById("main").style.marginLeft= "0";
            // certificate.menu.openNav();
            // certificate.menu.closeNav();
        }, //==============================================
        three: function(data) {
            console.log(data);
            // certificate.menu.three();
        } //==============================================
};





// <div id="" style="padding-left: 100px;text-align: left;padding-bottom: 20px;">
// <div class="button" id="clearcache" onclick="certificate.order.clearCache();">Update Database</div>
// </div>

// <div class="button managebutton" onclick="$('.viewbutton').css('display','inline-block');$(this).css('display','none');$('.editrecords').css('display','table-cell');" style="display: inline-block;">Manage Records</div>

// <div class="button viewbutton" onclick="$('.managebutton').css('display','inline-block');$(this).css('display','none');$('.editrecords').css('display','none');" style="display: none;">View</div>

// <img src="images/toggle_on.png" style="height:23px;width: 50px;">



// $('.viewbutton').css('display','inline-block');$(this).css('display','none');certificate.spreadsheet.manage.buildCode();

// $('.editrecords').css('display','table-cell');
$(document).ready(function() {
	setTimeout(function(){
		if ( location.href.indexOf( '?recently_deleted' ) > -1 ) {
			// $('.rec_tog_img').remove();
			$('.resend').remove();
		}
	}, 800);
});


// setTimeout(function(){}, 2000);
// $(document).ready(function() {});
// $('body').prepend('<div id="loadsomething"  ><span class="close" onclick="$(\'#loadsomething\').remove();">X</span> <div id="loadsomethinginner"><span id="loadheader"   > Header </span> <hr> <div class="items">  </div> </div> </div>'); $('#loadsomething').draggable({ handle: '#loadheader' });
// $('body').prepend('<div id="selectsomething"  ><span class="close" onclick="$(\'#selectsomething\').remove();">X</span> <div id="selectsomethinginner"><span id="selectheader"   > Header </span> <hr> <div class="items">  </div> </div> </div>'); $('#selectsomething').draggable({ handle: '#selectheader' });

