document.addEventListener('DOMContentLoaded', () => {
  const form = document.getElementById('inputForm');
  const input = document.getElementById('inputValue');
  const displayArea = document.getElementById('displayArea');

  form.addEventListener('submit', (event) => {
    event.preventDefault();
    if (input.value.trim() !== '') {
      createItem(input.value.trim());
      input.value = '';
    }
  });

  function createItem(name, isFile = false) {
    const item = document.createElement('div');
    item.className = isFile ? 'file' : 'folder';

    const itemName = document.createElement('span');
    itemName.className = 'name';
    itemName.innerText = name;

    const renameButton = document.createElement('button');
    renameButton.innerText = 'Rename';
    renameButton.addEventListener('click', () => {
      const newName = prompt('Enter the new name:');
      if (newName && newName.trim() !== '') {
        itemName.innerText = newName.trim();
      }
    });

    const removeButton = document.createElement('button');
    removeButton.innerText = 'Remove';
    removeButton.addEventListener('click', () => {
      item.remove();
    });

    const addFileButton = isFile ? null : document.createElement('button');
    if (!isFile) {
      addFileButton.innerText = 'Add File';
      addFileButton.addEventListener('click', () => {
        const fileName = prompt('Enter file name:');
        if (fileName && fileName.trim() !== '') {
          createItem(fileName.trim(), true);
        }
      });
    }

    item.appendChild(itemName);
    item.appendChild(renameButton);
    item.appendChild(removeButton);
    if (!isFile) {
      item.appendChild(addFileButton);
    }
    displayArea.appendChild(item);
  }
});
