eyeformeta.alt = {
        record: 0,
        drag: function(pp,cc,rID) {
            // eyeformeta.alt.drag(pp,cc)

            if ( typeof pp !== 'undefined' && typeof cc !== 'undefined' && typeof rID !== 'undefined'  ) {
                var x, y, target = null;
                eyeformeta.app.bind( document.getElementById('eyeformeta-note-main-'+rID), 'mousedown', function(e) {
                  var clickedDragger = false;
                  for(var i = 0; e.path[i] !== document.body; i++) {
                    if (e.path[i].classList.contains(cc)) {
                        clickedDragger = true;
                    }
                    else if (clickedDragger && e.path[i].classList.contains(pp)) {
                        target = e.path[i];
                        target.classList.add('dragging');
                        x = e.clientX - target.style.left.slice(0, -2);
                        y = e.clientY - target.style.top.slice(0, -2);
                        return;
                    }
                  }
                });
                eyeformeta.app.bind( document, 'mouseup', function() {
                    if (target !== null) target.classList.remove('dragging');
                    target = null;
                    // //console.log( 'STOP DRAG:', rID );
                });
                eyeformeta.app.bind( document, 'mousemove', function(e) {
                    if (target === null) return;
                    target.style.left = e.clientX - x + 'px';
                    target.style.top = e.clientY - y + 'px';
                    eyeformeta.alt.records[rID].x = e.clientX - x;
                    eyeformeta.alt.records[rID].y = e.clientY - y;
                    var pRect = target.parentElement.getBoundingClientRect();
                    var tgtRect = target.getBoundingClientRect();

                    if (tgtRect.left < pRect.left) target.style.left = 0;
                    if (tgtRect.top < pRect.top) target.style.top = 0;
                    if (tgtRect.right > pRect.right)   { target.style.left = pRect.width - tgtRect.width + 'px'; eyeformeta.alt.records[rID].x=pRect.width - tgtRect.width;}
                    if (tgtRect.bottom > pRect.bottom) { target.style.top = pRect.height - tgtRect.height + 'px';  eyeformeta.alt.records[rID].y=pRect.height - tgtRect.height; }
                });
            }
            // eyeformeta.alt.drag(pp,cc)
        }, //==============================================
        blink: function() {
                document.getElementById('eyeformeta-background-cover').style.display = 'block';
                document.getElementById('eyeformeta-background-cover').style.background = '#0000FF';
                setTimeout(function() { document.getElementById('eyeformeta-background-cover').style.display = 'none';  }, 500);
                setTimeout(function() { document.getElementById('eyeformeta-background-cover').innerText = '';  }, 500);
                setTimeout(function() { document.getElementById('eyeformeta-background-cover').style.background = '#FFFFFF';  }, 1000);
        }, //==============================================
        tail: function() {
            // eyeformeta.alt.tail()
        }, //==============================================
}; 



/*Make resizable div by Hung Nguyen*/
function makeResizableDiv(div,divChild,diff) {
  const element = document.querySelector(div);
  const mentChil = document.querySelector(divChild);
  const resizers = document.querySelectorAll(div + ' .eyeformeta-resizer')
  const minimum_size = 20;
  let original_width = 0;
  let original_height = 0;
  let original_x = 0;
  let original_y = 0;
  let original_mouse_x = 0;
  let original_mouse_y = 0;
  for (let i = 0;i < resizers.length; i++) {
    const currentResizer = resizers[i];
    currentResizer.addEventListener('mousedown', function(e) {
      e.preventDefault()
      original_width = parseFloat(getComputedStyle(element, null).getPropertyValue('width').replace('px', ''));
      original_height = parseFloat(getComputedStyle(element, null).getPropertyValue('height').replace('px', ''));
      original_x = element.getBoundingClientRect().left;
      original_y = element.getBoundingClientRect().top;
      original_mouse_x = e.pageX;
      original_mouse_y = e.pageY;
      window.addEventListener('mousemove', resize)
      window.addEventListener('mouseup', stopResize)
    })
    
    function resize(e) {
      if (currentResizer.classList.contains('eyeformeta-bottom-right')) {
        const width = original_width + (e.pageX - original_mouse_x);
        const height = original_height + (e.pageY - original_mouse_y)
        if (width > minimum_size) {
          element.style.width = width + 'px'
        }
        if (height > minimum_size) {
          element.style.height = height + 'px'
          mentChil.style.maxHeight = height-diff + 'px'
        }
      }
      else if (currentResizer.classList.contains('eyeformeta-bottom-left')) {
        const height = original_height + (e.pageY - original_mouse_y)
        const width = original_width - (e.pageX - original_mouse_x)
        if (height > minimum_size) {
          element.style.height = height + 'px'
          mentChil.style.height = maxHeight-diff + 'px'
        }
        if (width > minimum_size) {
          element.style.width = width + 'px'
          element.style.left = original_x + (e.pageX - original_mouse_x) + 'px'
        }
      }
      else if (currentResizer.classList.contains('eyeformeta-top-right')) {
        const width = original_width + (e.pageX - original_mouse_x)
        const height = original_height - (e.pageY - original_mouse_y)
        if (width > minimum_size) {
          element.style.width = width + 'px'
        }
        if (height > minimum_size) {
          element.style.height = height + 'px'
          mentChil.style.maxHeight = height-diff + 'px'
          element.style.top = original_y + (e.pageY - original_mouse_y) + 'px'
        }
      }
      else {
        const width = original_width - (e.pageX - original_mouse_x)
        const height = original_height - (e.pageY - original_mouse_y)
        if (width > minimum_size) {
          element.style.width = width + 'px'
          element.style.left = original_x + (e.pageX - original_mouse_x) + 'px'
        }
        if (height > minimum_size) {
          element.style.height = height + 'px'
          mentChil.style.maxHeight = height-diff + 'px'
          element.style.top = original_y + (e.pageY - original_mouse_y) + 'px'
        }
      }
    }
    
    function stopResize() {
      window.removeEventListener('mousemove', resize);
    }
  }
}


















function eyeformeta_menu(menuID, item, link, active, subject, isClass) {

  //////////////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////////////
  //
  // H E L P E R    F U N C T I O N S
  //
  //////////////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////////////

  /**
   * Function to check if we clicked inside an element with a particular class
   * name.
   * 
   * @param {Object} e The event
   * @param {String} className The class name to check against
   * @return {Boolean}
   */
  function clickInsideElement( e, className ) {
    var el = e.srcElement || e.target;
    try {
	    var rID = el.getAttribute('rid')
	    if ( typeof rID !== 'null' && typeof rID !== 'undefined' && rID !== null && rID !== undefined ) {
	    	eyeformeta.menu.rID = rID;
	    	// console.log('rid',eyeformeta.menu.rID);
	    }
    } catch (err) {}

    
    // eyeformeta.menu.xy.rID = el.getAttribute('eyeformeta');
    if (isClass) {
        if ( el.classList.contains(className) ) {
            ////console.log('isClass',isClass,eyeformeta.menu.status);
            eyeformeta.menu.status_check(menuID);

            setTimeout(function() {if (eyeformeta.app.status) document.querySelector('#eyeformeta-context-menu-main').classList.remove( contextMenuActive )}, 50);
          return el;
        } else {
          while ( el = el.parentNode ) {
            if ( el.classList && el.classList.contains(className) ) {
                ////console.log('isClass',isClass,eyeformeta.menu.status);
                eyeformeta.menu.status_check(menuID);
                setTimeout(function() {if (eyeformeta.app.status) document.querySelector('#eyeformeta-context-menu-main').classList.remove( contextMenuActive )}, 50);
              return el;
            }
          }
        }
    } else {
        ////console.log('isClass',isClass,eyeformeta.menu.status);
        eyeformeta.menu.status_check(menuID);
        return el;
    }


    return false;
  }

  /**
   * Get's exact position of event.
   * 
   * @param {Object} e The event passed in
   * @return {Object} Returns the x and y position
   */
  function getPosition(e) {


    // console.log(
    //     'A',
    //     e.pageX,
    //     e.pageY
    //     );

    // console.log(
    //     'B',
    //     e.clientX + document.body.scrollLeft + document.documentElement.scrollLeft,
    //     e.clientY + document.body.scrollTop + document.documentElement.scrollTop
    //     );

    // console.log(
    //     'C',
    //     e.clientX,
    //     e.clientY
    //     );


    // console.log(
    //     'D',
    //     e.screenY
    //     );


    var posx = 0;
    var posy = 0;

    if (!e) var e = window.event;
    
    if (e.pageX || e.pageY) {
      posx = e.pageX;
      posy = e.pageY;
    } else if (e.clientX || e.clientY) {
      posx = e.clientX + document.body.scrollLeft + document.documentElement.scrollLeft;
      posy = e.clientY + document.body.scrollTop + document.documentElement.scrollTop;
    }

    return {
      x: posx,
      y: posy
    }
  }

  //////////////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////////////
  //
  // C O R E    F U N C T I O N S
  //
  //////////////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////////////
  // menu, item, link, active, subject
  /**
   * Variables.
   */
  var contextMenuClassName = menuID;
  var contextMenuItemClassName = item;
  var contextMenuLinkClassName = link;
  var contextMenuActive = active;

  var taskItemClassName = subject;
  var taskItemInContext;

  var clickCoords;
  var clickCoordsX;
  var clickCoordsY;

  var menu = document.querySelector('#'+menuID);
  var menuItems = menu.querySelectorAll('.'+item);
  var menuState = 0;
  var menuWidth;
  var menuHeight;
  var menuPosition;
  var menuPositionX;
  var menuPositionY;

  var windowWidth;
  var windowHeight;

  /**
   * Initialise our application's code.
   */
  function init() {
    contextListener();
    clickListener();
    keyupListener();
    resizeListener();
  }

  /**
   * Listens for contextmenu events.
   */
  function contextListener() {
    eyeformeta.app.bind( document,  'contextmenu', function(e) {
        if ( eyeformeta.menu.status ) {
              taskItemInContext = clickInsideElement( e, taskItemClassName );

              if ( taskItemInContext ) {
                e.preventDefault();
                toggleMenuOn();
                positionMenu(e);
              } else {
                taskItemInContext = null;
                toggleMenuOff();
              }
        }
    });
  }

  /**
   * Listens for click events.
   */
  function clickListener() {
    eyeformeta.app.bind( document, 'click', function(e) {
    // console.log( 'clickListener:', Date.now() - eyeformeta.menu.menuTimer, eyeformeta.menu.menuTimer )
    if (  eyeformeta.menu.status  &&  (   Date.now() - eyeformeta.menu.menuTimer < 2000   ||  eyeformeta.menu.menuTimer==0   )  ) {

          var clickeElIsLink = clickInsideElement( e, contextMenuLinkClassName );
          // console.log('clickeElIsLink',clickeElIsLink);
          if ( clickeElIsLink ) {
            e.preventDefault();
            menuItemListener( clickeElIsLink );
          } else {
            var button = e.which || e.button;
            if ( button === 1 ) {
              toggleMenuOff();
            }
          }
    }

    });
  }

  /**
   * Listens for keyup events.
   */
  function keyupListener() {
    window.onkeyup = function(e) {
      if ( e.keyCode === 27 ) {
        toggleMenuOff();
      }
    }
  }

  /**
   * Window resize event listener
   */
  function resizeListener() {
    window.onresize = function(e) {
      toggleMenuOff();
    };
  }

  /**
   * Turns the custom context menu on.
   */
  function toggleMenuOn() {
    if ( menuState !== 1 ) {
      menuState = 1;
      menu.classList.add( contextMenuActive );
    }
  }

  /**
   * Turns the custom context menu off.
   */
  function toggleMenuOff() {
    if ( menuState !== 0 ) {
      menuState = 0;
      menu.classList.remove( contextMenuActive );
    }
  }

  /**
   * Positions the menu properly.
   * 
   * @param {Object} e The event
   */
  function positionMenu(e) {
    clickCoords = getPosition(e);
    clickCoordsX = clickCoords.x;
    clickCoordsY = clickCoords.y;

    menuWidth = menu.offsetWidth + 4;
    menuHeight = menu.offsetHeight + 4;

    windowWidth = window.outerWidth;
    windowHeight = window.outerHeight;

    if ( (windowWidth - clickCoordsX) < menuWidth ) {
        eyeformeta.menu.xy.x=windowWidth - menuWidth;
      menu.style.left = windowWidth - menuWidth + "px";
    } else {
        eyeformeta.menu.xy.x=clickCoordsX;
      menu.style.left = clickCoordsX + "px";
    }

    if ( (windowHeight - clickCoordsY) < menuHeight ) {


        if ( windowHeight - menuHeight < window.scrollY+window.innerHeight ) {
            eyeformeta.menu.xy.y=clickCoordsY;
            menu.style.top = clickCoordsY + "px";


            // console.log('xx',windowHeight - menuHeight, window.scrollY+window.innerHeight);
            // console.log('xy',clickCoordsY, window.scrollY+window.innerHeight);
            // console.log('yx',window.scrollY,window.innerHeight);
            // console.log('zy',window.scrollY+window.innerHeight);

        } else {
            eyeformeta.menu.xy.y=windowHeight - menuHeight;
            menu.style.top = windowHeight - menuHeight + "px";
            // console.log('yy',clickCoordsY);
        }
    } else {
        eyeformeta.menu.xy.y=clickCoordsY;
        menu.style.top = clickCoordsY + "px";
      // console.log('zz',clickCoordsY);

    }
  }

  /**
   * Dummy action function that logs an action when a menu item link is clicked
   * 
   * @param {HTMLElement} link The link that was clicked
   */
  function menuItemListener( link ) {
    // //console.log( "Task ID - " + taskItemInContext.getAttribute("data-id") + ", Task action - " + link.getAttribute("data-action"));
    // //console.log('CLICK:',link.getAttribute("data-action"));
    toggleMenuOff();
    setTimeout(function() { if (eyeformeta.app.status) eyeformeta.alt.clicked( link.getAttribute('data-action') ); }, 500);
    
  }

  /**
   * Run the app.
   */
  init();
}

function syntaxHighlight(json) {
if (typeof json != 'string') {
     json = JSON.stringify(json, undefined, 4);
}
json = json.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;');
return json.replace(/("(\\u[a-zA-Z0-9]{4}|\\[^u]|[^\\"])*"(\s*:)?|\b(true|false|null)\b|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?)/g, function (match) {
    var cls = 'number';
    if (/^"/.test(match)) {
        if (/:$/.test(match)) {
            cls = 'key';
        } else {
            cls = 'string';
        }
    } else if (/true|false/.test(match)) {
        cls = 'boolean';
    } else if (/null/.test(match)) {
        cls = 'null';
    }
    return '<span class="' + cls + '">' + match + '</span>';
});
}


    // eyeformeta.menu.menu( 'eyeformeta-context-menu-edit', 'test' );
    // eyeformeta.menu.menu( 'eyeformeta-context-menu-note', 'eyeformeta-note-box' );
    // eyeformeta.menu.menu( 'eyeformeta-context-menu-main', '' );




