<?php
include_once 'head.php';

$memberId = $_GET['member_id'];
$fileId = $_GET['file_id'];
$appId = $appManager->appSearch($memberId, $fileId);

if ($appId) {
    $fileInfo = $appManager->readJson("members/$memberId/apps/$appId/files/$fileId.json");
    if ($fileInfo) {
        $filePath = $fileInfo['path'];
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $appManager->removeFile($memberId, $appId, $filePath);
            header("Location: saved.php");
            exit();
        }
    } else {
        echo "File not found or invalid.";
        exit();
    }
} else {
    echo "File not found or invalid.";
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Remove File</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <?php include_once($_SERVER['DOCUMENT_ROOT'].'/.re/themes-header.php'); ?>
</head>
<body>
    
    <div class="container">
        <h2>Remove File</h2>
        <form method="POST">
            <p>Are you sure you want to remove the file "<?php echo htmlspecialchars($filePath); ?>"?</p>
            <button type="submit" class="btn btn-danger">Remove</button>
            <a href="app_edit.php?id=<?php echo $appId; ?>&member_id=<?php echo $memberId; ?>" class="btn btn-secondary">Cancel</a>
        </form>
    </div>
</body>
</html>
