<?php
ini_set('display_errors', 1); ini_set('display_startup_errors', 1); error_reporting(E_ALL);
include_once 'head.php';
$memberId = $_GET['member_id'];
$folderId = $_GET['folder_id'];
$appId = $appManager->appSearch($memberId,$folderId);

$folderInfo = $appManager->readJson("members/$memberId/apps/$appId/folders/$folderId.json");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $path = $_POST['path'];
    $access = implode(',', $_POST['access']);
    $newFolderId = $appManager->generateMd5($path); // Use generateMd5 for new ID

    // Update folder info
    $folderInfo['path'] = $path;
    $folderInfo['access'] = $appManager->inflateAccess($access);

    // If the ID has changed, rename the folder
    if ($newFolderId !== $folderId) {
        // Ensure new ID does not exist already
        if (!file_exists("members/$memberId/apps/$appId/folders/$newFolderId.json")) {
            // Rename the folder
            rename("members/$memberId/apps/$appId/folders/$folderId.json", "members/$memberId/apps/$appId/folders/$newFolderId.json");
            // Update $folderId to the new one
            $folderId = $newFolderId;
        } else {
            // Handle case where the new ID already exists (optional)
            echo "Error: A folder with the new ID already exists.";
            exit();
        }
    }

    // Save the updated info
    $appManager->writeJson("members/$memberId/apps/$appId/folders/$folderId.json", $folderInfo);

    // header("Location: member_edit.php?id=$memberId");
    header("Location: saved.php");
    exit();
}

?><!DOCTYPE html>
<html lang="en">
<head>
    <title>Edit Folder</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <?php include_once($_SERVER['DOCUMENT_ROOT'].'/.re/themes-header.php'); ?>
</head>
<body>
    
    <div class="container">
        <h2>Edit Folder</h2>
        <form method="POST">
            <div class="form-group">
                <label for="path">Path:</label>
                <input type="text" class="form-control" id="path" name="path" value="<?php echo htmlspecialchars($folderInfo['path']); ?>" required>
            </div>
            <div class="form-group">
                <label for="access">Access:</label>
                <select class="form-control" id="access" name="access[]" multiple style="height: 200px;">
                    <option value="admin" <?php echo in_array('admin', $folderInfo['access']) ? 'selected' : ''; ?>>Admin</option>
                    <option value="view" <?php echo in_array('view', $folderInfo['access']) ? 'selected' : ''; ?>>View</option>
                    <option value="add" <?php echo in_array('add', $folderInfo['access']) ? 'selected' : ''; ?>>Add</option>
                    <option value="modify" <?php echo in_array('modify', $folderInfo['access']) ? 'selected' : ''; ?>>Modify</option>
                    <option value="move" <?php echo in_array('move', $folderInfo['access']) ? 'selected' : ''; ?>>Move</option>
                    <option value="edit" <?php echo in_array('edit', $folderInfo['access']) ? 'selected' : ''; ?>>Edit</option>
                    <option value="dir" <?php echo in_array('dir', $folderInfo['access']) ? 'selected' : ''; ?>>Dir</option>
                    <option value="checklist" <?php echo in_array('checklist', $folderInfo['access']) ? 'selected' : ''; ?>>Checklist</option>
                    <option value="delete" <?php echo in_array('delete', $folderInfo['access']) ? 'selected' : ''; ?>>Delete</option>
                    <option value="php" <?php echo in_array('php', $folderInfo['access']) ? 'selected' : ''; ?>>PHP</option>
                </select>
            </div>
            <button type="submit" class="btn btn-primary">Submit</button>
        </form>
    </div>
</body>
</html>
