<?php
include_once 'head.php';
$memberId = $_GET['member_id'];
$accessOptions = ['admin', 'view', 'add', 'modify', 'move', 'edit', 'dir', 'checklist', 'delete', 'php'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $url = $_POST['url'];
    $access = isset($_POST['access']) ? $_POST['access'] : [];
    $appManager->addMemberAppUrl($memberId, $url, $access);
    // header("Location: member_edit.php?id=$memberId");
    header("Location: saved.php");
    exit();
}
?><!DOCTYPE html>
<html lang="en">
<head>
    <title>Add App URL</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <?php include_once($_SERVER['DOCUMENT_ROOT'].'/.re/themes-header.php'); ?>
</head>
<body>
    
    <div class="container">
        <h2>Add App URL</h2>
        <form method="POST">
            <div class="form-group">
                <label for="url">App URL:</label>
                <input type="text" class="form-control" id="url" name="url" required>
            </div>
            <div class="form-group">
                <label for="access">Access:</label>
                <select class="form-control" id="access" name="access[]" multiple style="height: 200px;">
                    <?php foreach ($accessOptions as $option): ?>
                        <option value="<?php echo $option; ?>"><?php echo ucfirst($option); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <button type="submit" class="btn btn-primary">Add App URL</button>
        </form>
    </div>
</body>
</html>
