<?php
include_once 'head.php';
$memberId = $_GET['id'];
$memberInfo = $appManager->readJson("members/$memberId/who.json");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $updatedInfo = [
        "nickname" => $_POST['nickname'],
        "first" => $_POST['first'],
        "last" => $_POST['last'],
        "email" => $_POST['email'],
        "phone" => $_POST['phone']
    ];
    $appManager->addMember($updatedInfo);
    // header("Location: member_list.php");
    header("Location: saved.php");
    exit();
}

$memberApps = $appManager->appListForMember($memberId); // Custom function to get member-specific apps
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Manage Member</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <?php include_once($_SERVER['DOCUMENT_ROOT'].'/.re/themes-header.php'); ?>
    <style>
        body {
            color: var(--text-color);
        }
        th, td {
            color: var(--text-color) !important;
        }
        .modal-dialog {
            width: 100%;
            height: 100%;
            margin: 0;
            padding: 0;
            max-width: 100%;
        }
        .modal-content {
            height: 100%;
            border: 0;
            border-radius: 0;
        }
        .modal-body {
            height: 100%;
            padding: 0;
        }
        #modalIframe {
            width: 100%;
            height: calc(100vh - 100px); /* Adjust height to take full viewport minus modal header/footer */
            border: none; /* Optional: remove border */
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Manage Member</h2>
        <form method="POST">
            <div class="form-group">
                <label for="nickname">Nickname:</label>
                <input type="text" class="form-control" id="nickname" name="nickname" value="<?php echo htmlspecialchars($memberInfo['nickname']); ?>" required>
            </div>
            <div class="form-group">
                <label for="first">First Name:</label>
                <input type="text" class="form-control" id="first" name="first" value="<?php echo htmlspecialchars($memberInfo['first']); ?>" required>
            </div>
            <div class="form-group">
                <label for="last">Last Name:</label>
                <input type="text" class="form-control" id="last" name="last" value="<?php echo htmlspecialchars($memberInfo['last']); ?>" required>
            </div>
            <div class="form-group">
                <label for="email">Email:</label>
                <input type="email" class="form-control" id="email" name="email" value="<?php echo htmlspecialchars($memberInfo['email']); ?>" required>
            </div>
            <div class="form-group">
                <label for="phone">Phone:</label>
                <input type="text" class="form-control" id="phone" name="phone" value="<?php echo htmlspecialchars($memberInfo['phone']); ?>" required>
            </div>
            <button type="submit" class="btn btn-primary">Submit</button>
        </form>

        <h3>Apps</h3>
        <a href="member_add_app.php?member_id=<?php echo $memberId; ?>" class="btn btn-primary">Add App URL</a>
        <ul>
            <?php foreach ($memberApps as $url): ?>
                <li>
                    <a href="app_edit.php?id=<?php echo $appManager->getAppId($url); ?>&member_id=<?php echo $memberId; ?>"><?php echo htmlspecialchars($url); ?></a>
                    <a href="app_edit.php?id=<?php echo $appManager->getAppId($url); ?>&member_id=<?php echo $memberId; ?>" class="btn btn-sm btn-secondary">Edit</a>
                    <a href="#" data-toggle="modal" data-target="#modal" data-remote="app_remove.php?app_id=<?php echo $appManager->getAppId($url); ?>&member_id=<?php echo $memberId; ?>" class="btn btn-sm btn-danger">Remove</a>
                </li>
            <?php endforeach; ?>
        </ul>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="modal" tabindex="-1" role="dialog" aria-labelledby="modalLabel" aria-hidden="true">
        <div class="modal-dialog modal-fullscreen" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalLabel">App Removal Confirmation</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <iframe id="modalIframe" width="100%" height="100%" frameborder="0"></iframe>
                </div>
            </div>
        </div>
    </div>

    <script>
        $('#modal').on('show.bs.modal', function (e) {
            var link = $(e.relatedTarget);
            var modal = $(this);
            var remote = link.data('remote');
            modal.find('#modalIframe').attr('src', remote);
        });

        $('#modal').on('hidden.bs.modal', function (e) {
            // Reset the iframe src to prevent retaining the previous page state
            $(this).find('#modalIframe').attr('src', '');
            location.reload();
        });
    </script>
</body>
</html>
