<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>Game Manager Dashboard</title>
	<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
	<link href="https://cdn.jsdelivr.net/npm/bootstrap-dark-5/dist/css/bootstrap-dark.min.css" rel="stylesheet">
	<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
	<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
	<div class="container-fluid">
		<a class="navbar-brand" href="#">Game Manager Dashboard</a>
		<button class="btn btn-secondary ms-auto" data-bs-toggle="modal" data-bs-target="#instructionsModal">Instructions</button>
	</div>
</nav>








<div class="container mt-4">
	<h1 class="text-center">Game Manager Dashboard</h1>
	<div class="row mt-4">
		<div class="col-md-12">
			<ul class="nav nav-tabs" id="entityTabs" role="tablist">
				<li class="nav-item" role="presentation">
					<button class="nav-link active" id="campaigns-tab" data-bs-toggle="tab" data-bs-target="#campaigns" type="button" role="tab">Campaigns</button>
				</li>
				<li class="nav-item" role="presentation">
					<button class="nav-link" id="battles-tab" data-bs-toggle="tab" data-bs-target="#battles" type="button" role="tab">Battles</button>
				</li>
				<!-- Add other tabs dynamically -->
			</ul>

			<div class="tab-content mt-4" id="entityTabsContent">
				<div class="tab-pane fade show active" id="campaigns" role="tabpanel">
					<button class="btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#createCampaignModal">Add Campaign</button>
					<div id="campaignsTable">Loading...</div>
				</div>
				<div class="tab-pane fade" id="battles" role="tabpanel">
					<button class="btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#createBattleModal">Add Battle</button>
					<div id="battlesTable">Loading...</div>
				</div>
				<!-- Add other tab panes dynamically -->
			</div>
		</div>
	</div>
</div>

<!-- Instructions Modal -->
<div class="modal fade" id="instructionsModal" tabindex="-1">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title">Instructions</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
				<ol>
					<li>Create players and optionally assign them as Dungeon Masters.</li>
					<li>Create campaigns and assign Dungeon Masters and players to them.</li>
					<li>Manage battles, characters, and other game components from the respective tabs.</li>
					<li>Ensure all dropdowns are populated with valid data from the database.</li>
				</ol>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
			</div>
		</div>
	</div>
</div>


<!-- Add Modals for Each Entity -->
<div class="modal fade" id="createBattleModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Create Battle</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="createBattleForm">
                    <div class="mb-3">
                        <label for="battleName" class="form-label">Battle Name</label>
                        <input type="text" class="form-control" id="battleName" name="Name" required>
                    </div>
                    <div class="mb-3">
                        <label for="campaignId" class="form-label">Campaign</label>
                        <select class="form-select" id="campaignId" name="CampaignID" required>
                            <!-- Populate options dynamically -->
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="description" class="form-label">Description</label>
                        <textarea class="form-control" id="battleDescription" name="Description"></textarea>
                    </div>
                    <div class="mb-3">
                        <label for="battleDate" class="form-label">Date</label>
                        <input type="date" class="form-control" id="battleDate" name="Date" required>
                    </div>
                    <div class="mb-3">
                        <label for="battleOutcome" class="form-label">Outcome</label>
                        <textarea class="form-control" id="battleOutcome" name="Outcome"></textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" onclick="createBattle()">Save</button>
            </div>
        </div>
    </div>
</div>



<div class="modal fade" id="createCampaignModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Create Campaign</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="createCampaignForm">


                    <div class="mb-3">
                        <label for="campaignName" class="form-label">Campaign Name</label>
                        <input type="text" class="form-control" id="campaignName" name="Name" required>
                    </div>



                    <div class="mb-3">
                        <label for="description" class="form-label">Description</label>
                        <textarea class="form-control" id="description" name="Description"></textarea>
                    </div>
                    <div class="mb-3">
                        <label for="campaignStartDate" class="form-label">Start Date</label>
                        <input type="date" class="form-control" id="campaignStartDate" name="StartDate" required>
                    </div>
                    <div class="mb-3">
                        <label for="campaignEndDate" class="form-label">End Date</label>
                        <input type="date" class="form-control" id="campaignEndDate" name="EndDate" required>
                    </div>
                    <div class="mb-3">
                        <label for="campaignStatus" class="form-label">Status</label>
                        <input type="text" class="form-control" id="campaignStatus" name="Status" required>
                    </div>
                    <input class="DungeonMasterID" type="hidden" id="campaignDungeonMasterID" name="DungeonMasterID" value="<?php echo $_GET['dm']; ?>">
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" onclick="createCampaign()">Save</button>
            </div>
        </div>
    </div>
</div>


<!-- Modals for All Entities -->
<div id="entityModals"></div>

<script>



function createBattle() {
        const formData = $('#createBattleForm').serializeArray();
        const data = {};
        formData.forEach(item => data[item.name] = item.value);

        $.ajax({
            url: 'functions.php',
            type: 'POST',
            data: { action: 'create', table: 'Battles', record: data },
            success: function (response) {
                if (response.success) {
                    $('#createBattleModal').modal('hide');
                    _.crud.loadEntityData('Battles', '#battlesTable');
                } else {
                    alert(response.error || 'Failed to create battle.');
                }
            }
        });
    }

    function createCampaign() {
        const formData = $('#createCampaignForm').serializeArray();
        const data = {};
        formData.forEach(item => data[item.name] = item.value);

        $.ajax({
            url: 'functions.php',
            type: 'POST',
            data: { action: 'create', table: 'Campaigns', record: data },
            success: function (response) {
				console.log(response);
                if (response.success) {
                    $('#createCampaignModal').modal('hide');
                    _.crud.loadEntityData('Campaigns', '#campaignsTable');
                } else {
                    alert(response.error || 'Failed to create campaign.');
                }
            }
        });
    }


	_ = typeof _ !== 'undefined' ? _ : {};
	_.crud = {};
	_.tables = {};
	_.tables.defaults = { expire: 30 }; // Expire sessions in minutes

	$(document).ready(function () {
		const urlParams = new URLSearchParams(window.location.search);
		const dmId = urlParams.get('dm');
		// $('#campaignDungeonMasterID').val(dmId);
		// const dmId = _.url.var('dm');
		// localStorage.setItem('dmId', dmId);
		_.crud.initEntities(['Campaigns', 'Battles']);
	});

	_.crud.initEntities = function (entities) {
		entities.forEach(entity => {
			_.crud.loadEntityData(entity, `#${entity.toLowerCase()}Table`);
			$(`#create${entity}Modal`).on('shown.bs.modal', function () {
				_.crud.populateDropdown(entity, `#${entity.toLowerCase()}Dropdown`);
			});
		});
	};

	_.crud.loadEntityData = function (entity, tableId) {
		$.ajax({
			url: 'functions.php',
			type: 'POST',
			data: { action: 'read', table: entity },
			success: function (response) {
				if (response.error) {
					console.error(`Error loading ${entity} data: ${response.error}`);
					$(tableId).html('<p>Error loading data.</p>');
					return;
				}

				// Generate table dynamically based on response
				let tableHtml = '<table class="table table-dark"><thead><tr>';
				for (const key in response[0]) {
					tableHtml += _.tables.code.layouts.read.th.replace('{FieldName}', key);
				}
				tableHtml += '<th>Actions</th></tr></thead><tbody>';

				response.forEach(row => {
					let rowHtml = '';
					for (const key in row) {
						rowHtml += _.tables.code.layouts.read.td.replace('{FieldData}', row[key]);
					}
					rowHtml += '<td><button class="btn btn-warning btn-sm">Edit</button> ' +
							'<button class="btn btn-danger btn-sm">Delete</button></td>';
					tableHtml += `<tr>${rowHtml}</tr>`;
				});

				tableHtml += '</tbody></table>';
				$(tableId).html(tableHtml);
			}
		});
	};


	// _.crud.loadEntityData = function (entity, tableId) {
	// 	$.ajax({
	// 		url: 'functions.php',
	// 		type: 'POST',
	// 		data: { action: 'read', table: entity },
	// 		success: function (response) {
	// 			if (response.error) {
	// 				$(tableId).html('<p>Error loading data.</p>');
	// 				return;
	// 			}

	// 			let tableHtml = '<table class="table table-dark">';
	// 			tableHtml += '<thead><tr>';
	// 			for (const key in response[0]) {
	// 				tableHtml += `<th>${key}</th>`;
	// 			}
	// 			tableHtml += '<th>Actions</th></tr></thead><tbody>';

	// 			response.forEach(row => {
	// 				tableHtml += '<tr>';
	// 				for (const key in row) {
	// 					tableHtml += `<td>${row[key]}</td>`;
	// 				}
	// 				tableHtml += `<td>
	// 					<button class="btn btn-warning btn-sm" onclick="_.crud.editEntity('${entity}', '${row.ID}')">Edit</button>
	// 					<button class="btn btn-danger btn-sm" onclick="_.crud.deleteEntity('${entity}', '${row.ID}')">Delete</button>
	// 				</td>`;
	// 				tableHtml += '</tr>';
	// 			});

	// 			tableHtml += '</tbody></table>';
	// 			$(tableId).html(tableHtml);
	// 		}
	// 	});
	// };

	_.crud.populateDropdown = function (entity, dropdownId) {
		$.ajax({
			url: 'functions.php',
			type: 'POST',
			data: { action: 'read', table: entity },
			success: function (response) {
				if (response.error) {
					$(dropdownId).html('<option>Error loading data.</option>');
					return;
				}

				let options = '';
				response.forEach(item => {
					options += `<option value="${item.ID}">${item.Name || item.Label}</option>`;
				});
				$(dropdownId).html(options);
			}
		});
	};

	_.crud.createEntity = function (entity, formId) {
		const formData = $(`#${formId}`).serializeArray();
		const data = {};
		formData.forEach(item => data[item.name] = item.value);

		$.ajax({
			url: 'functions.php',
			type: 'POST',
			data: { action: 'create', table: entity, record: data },
			success: function (response) {
				if (response.success) {
					$(`#create${entity}Modal`).modal('hide');
					_.crud.loadEntityData(entity, `#${entity.toLowerCase()}Table`);
				} else {
					alert(response.error || `Failed to create ${entity.toLowerCase()}.`);
				}
			}
		});
	};

	_.crud.editEntity = function (entity, id) {
		// Logic for editing an entity
	};

	_.crud.deleteEntity = function (entity, id) {
		// Logic for deleting an entity
	};

	_.crud.updateEntity = function (entity, id) {
		// Logic for updating an entity
	};
</script>
<script>
	// Tables

	_ = typeof _ !== 'undefined' ? _ : {};
	_.tables = {};
	_.tables.code = {
		fields: {
			textarea: '<textarea class="form-control" id="{TableLowerCase}{Field}" name="{Field}"></textarea>',
			text: '<input type="text" class="form-control" id="{TableLowerCase}{Field}" name="{Field}">',
			int: '<input type="number" class="form-control" id="{TableLowerCase}{Field}" name="{Field}">',
			date: '<input type="date" class="form-control" id="{TableLowerCase}{Field}" name="{Field}">',
			hidden: '<input class="{Field}" type="hidden" id="{TableLowerCase}{Field}" name="{Field}" value="">',
			option: '<option value="{Value}">{Field}</option>',
			select: '<select class="form-select" id="{TableLowerCase}{Field}" required="">{options}</select>',

			
		},
		layouts: {
			read: {
				th: '<th>{FieldName}</th>',
				td: '<td>{FieldData}</td>',
				table: '<div id="{TableLowerCase}Table"><table class="table table-dark"><thead><tr>{TH}</tr></thead><tbody><tr>{TD}<td><button class="btn btn-warning btn-sm">Edit</button> <button class="btn btn-danger btn-sm">Delete</button></td></tr></tbody></table></div>'
			},
			modal: {
				htmlBase: '<div class="modal fade" id="{Action}{Table}Modal" tabindex="-1">\n' +
						'\t<div class="modal-dialog">\n' +
						'\t\t<div class="modal-content">\n' +
						'\t\t\t<div class="modal-header">\n' +
						'\t\t\t\t<h5 class="modal-title">{ActionTitle} {Table}</h5>\n' +
						'\t\t\t\t<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>\n' +
						'\t\t\t</div>\n' +
						'\t\t\t<div class="modal-body">{Fields}</div>\n' +
						'\t\t\t<div class="modal-footer">\n' +
						'\t\t\t\t<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>\n' +
						'\t\t\t\t<button type="button" class="btn btn-primary">Save</button>\n' +
						'\t\t\t</div>\n' +
						'\t\t</div>\n' +
						'\t</div>\n' +
						'</div>',
				label: '<label for="{TableLowerCase}{Field}">{Field}</label>',
				field: '\t\t\t\t<div class="mb-3">' +
					'\t\t\t\t\t{label}' +
					'\t\t\t\t\t{field}' +
					'\t\t\t\t</div>'
			}
		}
	};

	_.tables.init = function (gameManagerID) {
		const url = `./TableProfiles/${gameManagerID}/tables.json`;

		fetch(url)
			.then(response => response.json())
			.then(json => {
				_.tables.GameTables = json;
				_.tables.initTabs(json.Tabs);
				_.tables.loadDefaultTab(json.Tabs);
			})
			.catch(error => console.error('Error loading table profiles:', error));
	};

	_.tables.initTabs = function (tabs) {
		tabs.List.forEach(tab => {
			// Add tabs to #entityTabs
			const tabButton = `<li class="nav-item" role="presentation">
				<button class="nav-link" id="${tab}-tab" data-bs-toggle="tab" data-bs-target="#${tab}" type="button" role="tab">${tab}</button>
			</li>`;
			$('#entityTabs').append(tabButton);

			// Add tab panes to #entityTabsContent
			const tabPane = `<div class="tab-pane fade" id="${tab}" role="tabpanel">
				<button class="btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#create${tab}Modal">Add ${tab}</button>
				<div id="${tab.toLowerCase()}Table">Loading...</div>
			</div>`;
			$('#entityTabsContent').append(tabPane);
		});
	};

	_.tables.loadDefaultTab = function (tabs) {
		if (tabs.Default) {
			$('#entityTabs .nav-link').removeClass('active');
			$('#entityTabsContent .tab-pane').removeClass('show active');
			$(`#${tabs.Default}-tab`).addClass('active');
			$(`#${tabs.Default}`).addClass('show active');
		}
	};

	_.tables.generateField = function (type, tableName, fieldName) {
		const template = _.tables.code.fields[type];
		if (!template) return '';

		return template
			.replace(/{TableLowerCase}/g, tableName.toLowerCase())
			.replace(/{Field}/g, fieldName);
	};

	_.tables.generateTable = function (schema, tableName) {
		let thHtml = '', tdHtml = '';

		schema.forEach(field => {
			thHtml += _.tables.code.layouts.read.th.replace(/{FieldName}/g, field.name);
			tdHtml += _.tables.code.layouts.read.td.replace(/{FieldData}/g, `{${field.name}}`);
		});

		return _.tables.code.layouts.read.table
			.replace(/{TableLowerCase}/g, tableName.toLowerCase())
			.replace(/{TH}/g, thHtml)
			.replace(/{TD}/g, tdHtml);
	};

	_.tables.generateModal = function (tableName, schema) {
    let modalFields = '';
    for (const field in schema) {
        const fieldType = schema[field].type;
        const fieldLowerCase = field.toLowerCase();

        let fieldHtml;
        if (field.endsWith('ID')) {
            fieldHtml = _.tables.code.hidden
                .replace(/{Field}/g, field)
                .replace(/{TableLowerCase}/g, tableName.toLowerCase());
        } else {
            fieldHtml = _.tables.code[fieldType]
                .replace(/{Field}/g, field)
                .replace(/{TableLowerCase}/g, tableName.toLowerCase());
        }

        modalFields += _.tables.code.layouts.modal.field
            .replace('{label}', _.tables.code.layouts.modal.label
                .replace(/{TableLowerCase}/g, tableName.toLowerCase())
                .replace(/{Field}/g, field))
            .replace('{field}', fieldHtml);
    }

    return _.tables.code.layouts.modal.htmlBase
        .replace(/{Table}/g, tableName)
        .replace(/{fields}/g, modalFields);
};


	_.tables.loadEntityIdData = function (table, selectId) {
    const storedData = localStorage.getItem(`lastID_${table}ID`);
    if (storedData) {
        const parsedData = JSON.parse(storedData);
        if (parsedData.login === localStorage.getItem('LoginEpoch')) {
            $(`#${selectId}`).val(parsedData.value);
            return; // Use stored value if valid
        }
    }

    // If no valid stored data, load via AJAX
    $.ajax({
        url: 'functions.php',
        type: 'POST',
        data: { action: 'readNameID', table },
        success: function (response) {
            if (response.error) {
                console.error(`Error loading ${table}ID data: ${response.error}`);
                return;
            }
            let options = '';
            response.forEach(item => {
                options += _.tables.code.option
                    .replace('{Value}', item[`${table}ID`])
                    .replace('{Field}', item.Name);
            });
            $(`#${selectId}`).html(options);
        }
    });
};


</script>
</body>
</html>
