<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-dark-5/dist/css/bootstrap-dark.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
    <div class="container-fluid">
        <a class="navbar-brand" href="#">Login</a>
    </div>
</nav>

<div class="container mt-4">
    <h1 class="text-center">Login</h1>
    <form id="loginForm" class="mt-4">
        <div class="mb-3">
            <label for="email" class="form-label">Email</label>
            <input type="email" class="form-control" id="email" name="email" required>
        </div>
        <div class="mb-3">
            <label for="password" class="form-label">Password</label>
            <input type="password" class="form-control" id="password" name="password" required>
        </div>
        <button type="submit" class="btn btn-primary">Login</button>
    </form>
</div>

<script>
    $('#loginForm').on('submit', function (e) {
        e.preventDefault();

        const formData = {
            action: 'login',
            email: $('#email').val(),
            password: $('#password').val()
        };

        $.ajax({
            url: 'functions.php',
            type: 'POST',
            data: formData,
            success: function (response) {
                if (response.success) {
                    if (response.isDungeonMaster) {
                        window.location.href = 'GameManager.php?dm=' + response.dungeonMasterID;
                    } else {
                        window.location.href = 'MyGames.php?player=' + response.playerID;
                    }
                } else {
                    alert(response.error || 'Invalid login credentials.');
                }
            }
        });
    });
</script>
</body>
</html>