<?php
include '../functions.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'];
    $description = $_POST['description'];
    $dungeon_master_id = $_POST['dungeon_master_id'];
    $start_date = $_POST['start_date'];
    $end_date = $_POST['end_date'];
    $status = $_POST['status'];

    // Validate DungeonMasterID exists
    $dungeon_master = fetchById('DungeonMasters', $dungeon_master_id);
    if (!$dungeon_master) {
        die("Error: Dungeon Master with ID $dungeon_master_id does not exist.");
    }

    insert('Campaigns', [
        'Name' => $name,
        'Description' => $description,
        'DungeonMasterID' => $dungeon_master_id,
        'StartDate' => $start_date,
        'EndDate' => $end_date,
        'Status' => $status
    ]);

    header('Location: read.php');
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <link rel="stylesheet" href="https://a.sds.sh/?f=css/fw.css&exec=[r=1,i:app.css][r=1,i:dnd.css]">
    <title>Create Campaign</title>
</head>
<body>
    <h2>Create Campaign</h2>
    <form method="POST">
        <label for="name">Name:</label>
        <input type="text" name="name" id="name" required>
        <label for="description">Description:</label>
        <textarea name="description" id="description"></textarea>
        <label for="dungeon_master_id">Dungeon Master ID:</label>
        <input type="number" name="dungeon_master_id" id="dungeon_master_id" required>
        <label for="start_date">Start Date:</label>
        <input type="date" name="start_date" id="start_date" required>
        <label for="end_date">End Date:</label>
        <input type="date" name="end_date" id="end_date">
        <label for="status">Status:</label>
        <input type="text" name="status" id="status" required>
        <br>
        <button type="submit">Create</button>
    </form>
</body>
</html>
