<?php
// Fetch database credentials
function getDBCredentials() {
    $credentials = json_decode(file_get_contents('https://keys.sds.sh/?json=1&prefix=1&id=programmer-dnd-*'), true);
    // echo json_encode($credentials, JSON_PRETTY_PRINT);exit;
    if (!$credentials || !isset($credentials['host'], $credentials['user'], $credentials['password'], $credentials['db'])) {
        die('Failed to fetch database credentials.');
    }

    return $credentials;
}

// Establish database connection
function getDBConnection() {
    $credentials = getDBCredentials();
    $conn = new mysqli(
        $credentials['host'],
        $credentials['user'],
        $credentials['password'],
        $credentials['db']
    );

    if ($conn->connect_error) {
        die("Database connection failed: " . $conn->connect_error);
    }

    // Debug: Check the selected database
    $result = $conn->query("SELECT DATABASE()");
    if ($result) {
        $row = $result->fetch_row();
        echo "Selected Database: " . $row[0] . "<br>";
    }

    return $conn;
}



// Fetch all records
function fetchAll($table) {
    $conn = getDBConnection();
    $sql = "SELECT * FROM $table";
    $result = $conn->query($sql);
    $rows = [];
    if ($result) {
        while ($row = $result->fetch_assoc()) {
            $rows[] = $row;
        }
    }
    $conn->close();
    return $rows;
}

// Fetch a single record by ID
function fetchById($table, $id) {
    $conn = getDBConnection();

    // Determine the primary key column dynamically
    $primaryKey = match ($table) {
        'DungeonMasters' => 'DungeonMasterID',
        'Battles' => 'BattleID',
        'Campaigns' => 'CampaignID',
        'Characters' => 'CharacterID',
        'Players' => 'PlayerID',
        'Items' => 'ItemID',
        'CharacterSpells' => 'CharacterSpellID',
        'Narratives' => 'NarrativeID',
        'Storylines' => 'StorylineID',
        'NPCInteractions' => 'InteractionID',
        default => 'id', // Fallback for generic tables
    };

    $sql = "SELECT * FROM $table WHERE $primaryKey = ?";
    $stmt = $conn->prepare($sql);

    if (!$stmt) {
        die("Prepare failed: " . $conn->error);
    }

    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    $conn->close();

    return $result;
}



// Insert a record
function insert($table, $data) {
    $conn = getDBConnection();
    $fields = implode(", ", array_keys($data));
    $placeholders = implode(", ", array_fill(0, count($data), '?'));
    $types = str_repeat('s', count($data));

    $sql = "INSERT INTO $table ($fields) VALUES ($placeholders)";
    $stmt = $conn->prepare($sql);

    if (!$stmt) {
        die("Prepare failed: " . $conn->error);
    }

    $stmt->bind_param($types, ...array_values($data));

    if (!$stmt->execute()) {
        die("Execution failed: " . $stmt->error);
    }

    $stmt->close();
    $conn->close();
}

// Update a record
function update($table, $data, $id) {
    $conn = getDBConnection();

    // Determine the primary key column dynamically
    $primaryKey = match ($table) {
        'DungeonMasters' => 'DungeonMasterID',
        'Battles' => 'BattleID',
        'Campaigns' => 'CampaignID',
        'Characters' => 'CharacterID',
        'Players' => 'PlayerID',
        'Items' => 'ItemID',
        'CharacterSpells' => 'CharacterSpellID',
        'Narratives' => 'NarrativeID',
        'Storylines' => 'StorylineID',
        'NPCInteractions' => 'InteractionID',
        default => 'id', // Fallback for generic tables
    };

    // Construct the SQL query
    $fields = implode(" = ?, ", array_keys($data)) . " = ?";
    $types = str_repeat('s', count($data)) . 'i'; // Assume strings for data, integer for ID
    $sql = "UPDATE $table SET $fields WHERE $primaryKey = ?";
    $stmt = $conn->prepare($sql);

    if (!$stmt) {
        die("Prepare failed: " . $conn->error);
    }

    // Bind parameters
    $params = array_merge(array_values($data), [$id]);
    $stmt->bind_param($types, ...$params);

    // Execute the query
    if (!$stmt->execute()) {
        die("Execution failed: " . $stmt->error);
    }

    $stmt->close();
    $conn->close();
}



// Delete a record
function delete($table, $id) {
    $conn = getDBConnection();
    $sql = "DELETE FROM $table WHERE id = ?";
    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        die('Failed to prepare statement: ' . $conn->error);
    }
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $stmt->close();
    $conn->close();
}
?>
