<?php
include '../functions.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $id = $_POST['id'];
    $name = $_POST['name'];
    $description = $_POST['description'];
    $level = $_POST['level'];
    $casting_time = $_POST['casting_time'];
    $range = $_POST['range'];
    $components = $_POST['components'];
    $duration = $_POST['duration'];

    update('Spells', [
        'Name' => $name,
        'Description' => $description,
        'Level' => $level,
        'CastingTime' => $casting_time,
        '`Range`' => $range, // Escaping reserved keyword Range
        'Components' => $components,
        'Duration' => $duration
    ], $id);
    header("Location: read.php");
    exit;
} else {
    $id = $_GET['id'];
    $spell = fetchById('Spells', $id);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <link rel="stylesheet" href="https://a.sds.sh/?f=css/fw.css&exec=[r=1,i:app.css][r=1,i:dnd.css]">
    <title>Update Spell</title>
</head>
<body>
    <h2>Update Spell</h2>
    <form method="POST">
        <input type="hidden" name="id" value="<?= $spell['SpellID'] ?>">
        <label for="name">Name:</label>
        <input type="text" name="name" id="name" value="<?= $spell['Name'] ?>" required>
        <label for="description">Description:</label>
        <textarea name="description" id="description"><?= $spell['Description'] ?></textarea>
        <label for="level">Level:</label>
        <input type="number" name="level" id="level" value="<?= $spell['Level'] ?>" required>
        <label for="casting_time">Casting Time:</label>
        <input type="text" name="casting_time" id="casting_time" value="<?= $spell['CastingTime'] ?>" required>
        <label for="range">Range:</label>
        <input type="text" name="range" id="range" value="<?= $spell['Range'] ?>" required>
        <label for="components">Components:</label>
        <input type="text" name="components" id="components" value="<?= $spell['Components'] ?>">
        <label for="duration">Duration:</label>
        <input type="text" name="duration" id="duration" value="<?= $spell['Duration'] ?>">
        <br>
        <button type="submit">Update</button>
    </form>
</body>
</html>
